/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.condition;

import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.condition.TypeSentiveCondition;
import org.apache.uima.ruta.expression.number.NumberExpression;
import org.apache.uima.ruta.expression.number.SimpleNumberExpression;
import org.apache.uima.ruta.expression.type.TypeExpression;
import org.apache.uima.ruta.rule.EvaluatedCondition;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class CurrentCountCondition
extends TypeSentiveCondition {
    private final NumberExpression min;
    private final NumberExpression max;
    private final String var;

    public CurrentCountCondition(TypeExpression type, NumberExpression min, NumberExpression max, String var) {
        super(type);
        this.min = min == null ? new SimpleNumberExpression(Integer.MIN_VALUE) : min;
        this.max = max == null ? new SimpleNumberExpression(Integer.MAX_VALUE) : max;
        this.var = var;
    }

    public EvaluatedCondition eval(AnnotationFS annotation, RuleElement element, RutaStream stream, InferenceCrowd crowd) {
        AnnotationFS next;
        int count = 0;
        FSIterator it = stream.getCas().getAnnotationIndex(this.type.getType(element.getParent())).iterator();
        while (it.hasNext() && (next = (AnnotationFS)it.next()).getBegin() < annotation.getBegin()) {
            ++count;
        }
        if (this.var != null) {
            element.getParent().getEnvironment().setVariableValue(this.var, count);
        }
        boolean value = count >= this.min.getIntegerValue(element.getParent()) && count <= this.max.getIntegerValue(element.getParent());
        return new EvaluatedCondition(this, value);
    }

    public NumberExpression getMin() {
        return this.min;
    }

    public NumberExpression getMax() {
        return this.max;
    }

    public String getVar() {
        return this.var;
    }
}

