/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.expression.bool;

import org.apache.uima.ruta.RutaStatement;
import org.apache.uima.ruta.expression.bool.BooleanExpression;

public class SimpleBooleanFunction
extends BooleanExpression {
    private String op;
    private BooleanExpression e1;
    private BooleanExpression e2;

    public SimpleBooleanFunction(String text, BooleanExpression e1, BooleanExpression e2) {
        this.op = text;
        this.e1 = e1;
        this.e2 = e2;
    }

    public boolean getBooleanValue(RutaStatement parent) {
        boolean b1 = this.e1.getBooleanValue(parent);
        boolean b2 = this.e2.getBooleanValue(parent);
        if ("XOR".equals(this.op)) {
            return !(!b1 && !b2 || b1 && b2);
        }
        if ("==".equals(this.op)) {
            return b1 == b2;
        }
        if ("!=".equals(this.op)) {
            return b1 != b2;
        }
        return false;
    }

    public String getStringValue(RutaStatement parent) {
        return this.e1.getStringValue(parent) + " " + this.op + " " + this.e2.getStringValue(parent);
    }
}

