/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.verbalize;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.uima.ruta.RutaBlock;
import org.apache.uima.ruta.RutaElement;
import org.apache.uima.ruta.RutaStatement;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.condition.AbstractRutaCondition;
import org.apache.uima.ruta.expression.RutaExpression;
import org.apache.uima.ruta.expression.number.NumberExpression;
import org.apache.uima.ruta.expression.type.TypeExpression;
import org.apache.uima.ruta.rule.ComposedRuleElement;
import org.apache.uima.ruta.rule.RegExpRule;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RutaDisjunctiveMatcher;
import org.apache.uima.ruta.rule.RutaMatcher;
import org.apache.uima.ruta.rule.RutaRule;
import org.apache.uima.ruta.rule.RutaRuleElement;
import org.apache.uima.ruta.rule.WildCardRuleElement;
import org.apache.uima.ruta.rule.quantifier.MinMaxGreedy;
import org.apache.uima.ruta.rule.quantifier.MinMaxReluctant;
import org.apache.uima.ruta.rule.quantifier.NormalQuantifier;
import org.apache.uima.ruta.rule.quantifier.PlusGreedy;
import org.apache.uima.ruta.rule.quantifier.PlusReluctant;
import org.apache.uima.ruta.rule.quantifier.QuestionGreedy;
import org.apache.uima.ruta.rule.quantifier.QuestionReluctant;
import org.apache.uima.ruta.rule.quantifier.RuleElementQuantifier;
import org.apache.uima.ruta.rule.quantifier.StarGreedy;
import org.apache.uima.ruta.rule.quantifier.StarReluctant;
import org.apache.uima.ruta.verbalize.RutaVerbalizer;

public class ScriptVerbalizer {
    private static final String THEN = " -> ";
    private RutaVerbalizer verbalizer;

    public ScriptVerbalizer(RutaVerbalizer verbalizer) {
        this.verbalizer = verbalizer;
    }

    public String verbalizeBlock(RutaBlock block, boolean withElements) {
        StringBuilder result = new StringBuilder();
        RutaRule rule = block.getRule();
        List<RutaStatement> elements = block.getElements();
        result.append("BLOCK(");
        result.append(block.getName());
        result.append(")");
        result.append(" ");
        if (rule != null) {
            result.append(this.verbalizeRule(rule));
        }
        if (withElements) {
            result.append(" {\n");
            for (RutaStatement each : elements) {
                if (each instanceof RutaBlock) {
                    result.append(this.verbalizeBlock((RutaBlock)each, withElements));
                } else if (each instanceof RutaRule) {
                    result.append(this.verbalizeRule((RutaRule)each));
                }
                result.append(";");
                result.append("\n");
            }
            result.append(" }\n");
        }
        return result.toString();
    }

    public String verbalizeRule(RutaRule rule) {
        List<RuleElement> elements = rule.getRuleElements();
        StringBuilder result = new StringBuilder();
        for (RuleElement each : elements) {
            result.append(this.verbalizeRuleElement(each));
            result.append(" ");
        }
        return result.toString();
    }

    public String verbalizeRuleElement(RuleElement re) {
        List<AbstractRutaCondition> conditions = re.getConditions();
        List<AbstractRutaAction> actions = re.getActions();
        RuleElementQuantifier quantifier = re.getQuantifier();
        StringBuilder result = new StringBuilder();
        if (re instanceof ComposedRuleElement) {
            result.append(this.verbalizeComposed((ComposedRuleElement)re));
        } else if (re instanceof RutaRuleElement) {
            RutaRuleElement tmre = (RutaRuleElement)re;
            result.append(this.verbalizeMatcher(tmre));
        } else if (re instanceof WildCardRuleElement) {
            result.append("#");
        }
        result.append(this.verbalizeQuantifier(quantifier));
        if (!conditions.isEmpty() || !actions.isEmpty()) {
            result.append("{");
            Iterator<AbstractRutaCondition> cit = conditions.iterator();
            while (cit.hasNext()) {
                AbstractRutaCondition each = cit.next();
                result.append(this.verbalizer.verbalize(each));
                if (!cit.hasNext()) continue;
                result.append(",");
            }
            if (!actions.isEmpty()) {
                result.append(THEN);
                Iterator<AbstractRutaAction> ait = actions.iterator();
                while (ait.hasNext()) {
                    AbstractRutaAction each = ait.next();
                    result.append(this.verbalizer.verbalize(each));
                    if (!ait.hasNext()) continue;
                    result.append(",");
                }
            }
            result.append("}");
        }
        return result.toString();
    }

    public String verbalizeComposed(ComposedRuleElement cre) {
        StringBuilder result = new StringBuilder();
        List<RuleElement> ruleElements = cre.getRuleElements();
        result.append("(");
        for (RuleElement each : ruleElements) {
            if (cre.getRuleElements().indexOf(each) != 0) {
                result.append(" ");
            }
            result.append(this.verbalizeRuleElement(each));
        }
        result.append(")");
        return result.toString();
    }

    public String verbalizeMatcher(RutaRuleElement tmre) {
        StringBuilder result = new StringBuilder();
        RutaMatcher matcher = tmre.getMatcher();
        if (matcher instanceof RutaDisjunctiveMatcher) {
            RutaDisjunctiveMatcher dmatcher = (RutaDisjunctiveMatcher)matcher;
            List<RutaExpression> expressions = dmatcher.getExpressions();
            result.append("(");
            for (RutaExpression each : expressions) {
                if (expressions.indexOf(each) != 0) {
                    result.append(" | ");
                }
                result.append(this.verbalizer.verbalize(each));
            }
            result.append(")");
        } else {
            result.append(this.verbalizer.verbalize(matcher.getExpression()));
        }
        return result.toString();
    }

    public String verbalizeQuantifier(RuleElementQuantifier quantifier) {
        if (quantifier instanceof NormalQuantifier) {
            return "";
        }
        if (quantifier instanceof MinMaxGreedy) {
            MinMaxGreedy mmg = (MinMaxGreedy)quantifier;
            return "[" + this.verbalizer.verbalize(mmg.getMin()) + "," + this.verbalizer.verbalize(mmg.getMax()) + "]";
        }
        if (quantifier instanceof MinMaxReluctant) {
            MinMaxReluctant mmr = (MinMaxReluctant)quantifier;
            return "[" + this.verbalizer.verbalize(mmr.getMin()) + "," + this.verbalizer.verbalize(mmr.getMax()) + "]?";
        }
        if (quantifier instanceof PlusGreedy) {
            return "+";
        }
        if (quantifier instanceof PlusReluctant) {
            return "+?";
        }
        if (quantifier instanceof QuestionGreedy) {
            return "?";
        }
        if (quantifier instanceof QuestionReluctant) {
            return "??";
        }
        if (quantifier instanceof StarGreedy) {
            return "*";
        }
        if (quantifier instanceof StarReluctant) {
            return "*?";
        }
        return null;
    }

    public String verbalize(RutaElement element) {
        if (element instanceof RutaBlock) {
            return this.verbalizeBlock((RutaBlock)element, false);
        }
        if (element instanceof RuleElementQuantifier) {
            return this.verbalizeQuantifier((RuleElementQuantifier)((Object)element));
        }
        if (element instanceof RutaRule) {
            return this.verbalizeRule((RutaRule)element);
        }
        if (element instanceof RegExpRule) {
            return this.verbalizeRegExpRule((RegExpRule)element);
        }
        if (element instanceof RutaRuleElement) {
            return this.verbalizeRuleElement((RutaRuleElement)element);
        }
        return null;
    }

    private String verbalizeRegExpRule(RegExpRule rule) {
        StringBuilder sb = new StringBuilder();
        String regexp = this.verbalizer.verbalize(rule.getRegExp());
        sb.append(regexp);
        sb.append(THEN);
        Iterator<Map.Entry<TypeExpression, NumberExpression>> iterator = rule.getTypeMap().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<TypeExpression, NumberExpression> next = iterator.next();
            String type = this.verbalizer.verbalize(next.getKey());
            NumberExpression value = next.getValue();
            if (value != null) {
                String group = this.verbalizer.verbalize(value);
                sb.append(group + " = " + type);
            } else {
                sb.append(type);
            }
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(";");
        return sb.toString();
    }
}

