/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.statistics;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.impl.DoubleArrayFSImpl;
import org.apache.uima.cas.impl.IntArrayFSImpl;
import org.apache.uima.cas.impl.StringArrayFSImpl;

public class StatisticsEntry {
    private static final String PARTS = "part";
    private static final String AMOUNTS = "amount";
    private static final String TOTALS = "total";
    private static final String NAMES = "name";
    private static final String TYPE = "org.apache.uima.ruta.type.Statistics";
    private final String name;
    private final double total;
    private final int amount;
    private final double part;

    public StatisticsEntry(String name, double total, int amount, double part) {
        this.name = name;
        this.total = total;
        this.amount = amount;
        this.part = part;
    }

    public static List<StatisticsEntry> createEntries(FeatureStructure fs) {
        ArrayList<StatisticsEntry> result = new ArrayList<StatisticsEntry>();
        Type type = fs.getCAS().getTypeSystem().getType(TYPE);
        Feature fname = type.getFeatureByBaseName(NAMES);
        Feature ftotal = type.getFeatureByBaseName(TOTALS);
        Feature famount = type.getFeatureByBaseName(AMOUNTS);
        Feature fparts = type.getFeatureByBaseName(PARTS);
        StringArrayFSImpl vname = (StringArrayFSImpl)fs.getFeatureValue(fname);
        DoubleArrayFSImpl vtotal = (DoubleArrayFSImpl)fs.getFeatureValue(ftotal);
        IntArrayFSImpl vamount = (IntArrayFSImpl)fs.getFeatureValue(famount);
        DoubleArrayFSImpl vpart = (DoubleArrayFSImpl)fs.getFeatureValue(fparts);
        String[] narray = new String[]{};
        if (vname != null) {
            narray = vname.toArray();
        }
        double[] tarray = vtotal.toArray();
        int[] aarray = vamount.toArray();
        double[] parray = vpart.toArray();
        int i = 0;
        for (String each : narray) {
            result.add(new StatisticsEntry(each, tarray[i], aarray[i], parray[i]));
            ++i;
        }
        return result;
    }

    public double getPart() {
        return this.part;
    }

    public int getAmount() {
        return this.amount;
    }

    public double getTotal() {
        return this.total;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName() + " : " + this.getTotal() + " : " + this.getAmount() + " : " + this.getPart();
    }
}

