#!/bin/sh

. "${TEST_SCRIPTS_DIR}/unit.sh"

define_test "4 nodes, some IPs unassigned on target nodes"

export CTDB_TEST_LOGLEVEL=INFO

required_result <<EOF
${TEST_DATE_STAMP} 10.19.99.251 -> 2 [+9216]
${TEST_DATE_STAMP} 130.216.30.173 -> 2 [+24345]
${TEST_DATE_STAMP} 130.216.30.171 -> 2 [+39970]
130.216.30.181 0
130.216.30.180 1
130.216.30.179 2
130.216.30.178 3
130.216.30.177 0
130.216.30.176 1
130.216.30.175 0
130.216.30.174 1
130.216.30.173 2
130.216.30.172 3
130.216.30.171 2
130.216.30.170 3
10.19.99.253 0
10.19.99.252 1
10.19.99.251 2
10.19.99.250 3
EOF

# In this example were 4 releases from node 2 in a previous iteration
#
#   Release of IP 130.216.30.179/27 on interface ethX1  node:3
#   Release of IP 130.216.30.173/27 on interface ethX1  node:0
#   Release of IP 130.216.30.171/27 on interface ethX1  node:1
#   Release of IP 10.19.99.251/22 on interface ethX2  node:0
#
# However, one release failed so no takeovers were done.  This means
# that the target node for each IP still thinks that the IPs are held
# by node 2.  The release of 130.216.30.179 was so late that node 2
# still thought that it held that address.

simple_test 0,0,0,0 multi <<EOF
130.216.30.181 0
130.216.30.180 1
130.216.30.179 3
130.216.30.178 3
130.216.30.177 0
130.216.30.176 1
130.216.30.175 0
130.216.30.174 1
130.216.30.173 2
130.216.30.172 3
130.216.30.171 1
130.216.30.170 3
10.19.99.253 0
10.19.99.252 1
10.19.99.251 2
10.19.99.250 3

130.216.30.181 0
130.216.30.180 1
130.216.30.179 3
130.216.30.178 3
130.216.30.177 0
130.216.30.176 1
130.216.30.175 0
130.216.30.174 1
130.216.30.173 0
130.216.30.172 3
130.216.30.171 2
130.216.30.170 3
10.19.99.253 0
10.19.99.252 1
10.19.99.251 0
10.19.99.250 3

130.216.30.181 0
130.216.30.180 1
130.216.30.179 2
130.216.30.178 3
130.216.30.177 0
130.216.30.176 1
130.216.30.175 0
130.216.30.174 1
130.216.30.173 0
130.216.30.172 3
130.216.30.171 1
130.216.30.170 3
10.19.99.253 0
10.19.99.252 1
10.19.99.251 0
10.19.99.250 3

130.216.30.181 0
130.216.30.180 1
130.216.30.179 2
130.216.30.178 3
130.216.30.177 0
130.216.30.176 1
130.216.30.175 0
130.216.30.174 1
130.216.30.173 0
130.216.30.172 3
130.216.30.171 1
130.216.30.170 3
10.19.99.253 0
10.19.99.252 1
10.19.99.251 0
10.19.99.250 3
EOF
