#include <stdio.h>
#include <ctype.h>
#include <X11/Intrinsic.h>
#include <unistd.h>
#include "bibview.h"


#define YYSTYPE char

#define __RUNTIME_YYMAXDEPTH
#define YYMAXDEPTH 1000

char uebergabe[MAX_UEBERGABE];
char ue2[MAX_UEBERGABE];
int ueIdx = 0;

FILE *tempDatei;
extern FILE *yyin;
extern YY_NEW_FILE;
extern int yy_init;

extern int fld_indent, cont_indent, newline_indent, max_fields;

typedef struct _Snode {
                       char inh;
                       int slen;
                       struct _Snode *next;
} Snode;

/*******************************************/
/* Globale Variablen                       */
/*******************************************/

int yynline;
int yynflexcalls;
int yynerrs;
char errorstr[MAX_ERRORSTRLEN];

/*******************************************/
/* Lokale Variablen                        */
/*******************************************/

static Snode *key = NULL;            
static Snode *fldname = NULL;       

static char errstr[MAX_ERRLINELENGTH];
#ifdef GERMAN
static char *anfhelpstr = 
  "Es wurden leider Fehler entdeckt\n\n\t%15s\t\t%10s\t%10s\n";
static char *endhelpstr = 
  "\n%40s: %3d Fehler";
#else
static char *anfhelpstr = 
  "Sorry, but there were syntax errors:\n\n\t%15s\t\t%10s\t%10s\n";
static char *endhelpstr = 
  "\n%40s: %3d errors";
#endif
static CardType cardtype;
static CardData *card = NULL;
static UserFld *helpufield = NULL;
static String helpFldName = NULL;
static String errkey;
static Errcode err;
static BibPtr glbbp;
static int beginIdx;
static int keyline;
static int errorline;

/*******************************************/
/* Lokale Funktionen                       */
/*******************************************/

static void PushSign(Snode **w, char a);
static void FreeStack(Snode **s);
static void StringToString(char *text1, char **text); 
static void StackToString(Snode *s, char **text); 
static void GetKey();
static void GetFldNameCont();
static void SecStrcat(int maxlen, char *str1, char *str2);

static int SetInputFile(char *file);
static int SkipSpace(char *text, char *text2);
static int SkipNewLineSpace(char *text);
static int SkipApe(char *text);
static int StringIsPeteEmpty(char *text);
static void WriteRecToFile(CardData *card, FILE *datei);
static long WriteLineToFile(FILE *datei, char *feld, char *inh);
#ifdef __cplusplus
#  include <stdio.h>
   extern "C" {
     extern void yyerror(char *);
     extern int yylex();
   }
#endif	/* __cplusplus */ 
# define COMMENT 257
# define STRING 258
# define PREAMBLE 259
# define TYPE 260
# define KOMMA 261
# define EQ 262
# define AFFE 263
# define LGKL 264
# define RGKL 265
# define LRKL 266
# define RRKL 267
# define DAZ 268
# define ZAUN 269
# define PROZENT 270
# define ZEICHEN 271
# define WHITE_SPACE 272
# define NEW_LINE 273
# define BUCHSTABE_ZAHL 274
#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif

/* __YYSCLASS defines the scoping/storage class for global objects
 * that are NOT renamed by the -p option.  By default these names
 * are going to be 'static' so that multi-definition errors
 * will not occur with multiple parsers.
 * If you want (unsupported) access to internal names you need
 * to define this to be null so it implies 'extern' scope.
 * This should not be used in conjunction with -p.
 */
#ifndef __YYSCLASS
# define __YYSCLASS static
#endif
#ifndef YYSTYPE
#define YYSTYPE int
#endif
YYSTYPE yylval;
__YYSCLASS YYSTYPE yyval;
typedef int yytabelem;
# define YYERRCODE 256



static int SkipApe(char *text)
{ 
 int erg, back;

 erg = 0;
 while (erg < ueIdx) {
   if (*text == '@') 
     return erg+1;
   text++;
   erg++;
 }
 return 0;
}


static int SkipNewLineSpace(char *text)
{ 
 int erg, back;

 erg = 0;
 while (erg < MAX_UEBERGABE) {
   if (*text == '{' ||  *text == '(') {
     back = strlen(text);
     text = text + back;
     while (*text != '}' && *text != ')') { 
       *text = '\0';
       text--;
     }
     return erg;
   }
   text++;
   erg++;
 }
 return 0;
}

static int SkipSpace(char *text, char *text2)
{
 int erg, lgkl, daz, index, inmakro, anfang;
 char *zaehler, *suchzeiger;

 index = 0;
 lgkl = 0;
 daz = 0;
 inmakro = 0;
 anfang = 0;
 zaehler = text2;
 *zaehler = '\0';


 while ((*text == ' ' || *text == '=' || *text == '\t') && index < ueIdx) { 
   text++; 
   index++;
   }
 erg = index;
 while (index < ueIdx) {
   if (*text == '{') {
     if ((lgkl >= 1) || daz || cotOrig())  /* Klammer in String */
       *zaehler++ = *text;
     lgkl += 1;
     inmakro = 0;
     anfang = 0;
   }
   else if (*text == '}') {
     if ((lgkl > 1) || daz || ((lgkl == 1) && cotOrig()))
       *zaehler++ = *text;
     lgkl -= 1;
     inmakro = 0;
     anfang = 0;
   }
   else if (*text == '"') {
     if (lgkl >= 1) 
       *zaehler++ = *text;
     else {
       daz = !daz;
       if (cotOrig())
          *zaehler++ = *text;
     }
     inmakro = 0;
     anfang = 0;
   }
   else if (*text == ',') {        /* Komma am Ende */
     if ((lgkl >= 1) || daz)
       *zaehler++ = *text;
     inmakro = 0;
     anfang = 0;
   }
   else if (*text == '#') {        /* Space vor/nach Konkatenation */
     if ((lgkl < 1) && !daz) {
       if (!cotOrig()) {
	 if (text[index-1] != ' ')
            *zaehler++ = ' ';
         *zaehler++ = '@';
	 }
       *zaehler++ = *text;
       if (!cotOrig() && (text[index+1] != ' '))
          *zaehler++ = ' ';
     }
     else {                        /* Konkatenation in String */
       *zaehler++ = *text;
     }
     inmakro = 0;
     anfang = 0;
   } 
   else if (*text == '\n') {
     if (lgkl >= 1 || daz)
       *zaehler++ = '\n';
     else { 
       suchzeiger = text+1;
       while ((*suchzeiger == ' ') || (*suchzeiger == '\t') ||
	      (*suchzeiger == '\n'))
	  suchzeiger++;
       if ((*suchzeiger != '}') && (*suchzeiger != ')')){
	  *zaehler++ = '\n';
	  }
       inmakro = 0;
       }
     anfang = 1;
   } 
   else if ((*text == ' ') || (*text == '\t')) {
     if (!anfang)
	*zaehler++ = *text;
     inmakro = 0;
   }
   else if (*text == ')') {        /* runde Klammer am Ende */
     if (lgkl >= 1 || daz)
       *zaehler++ = *text;
     inmakro = 0;
     anfang = 0;
   }
   else if (*text == '@') {        /* @ */
     *zaehler++ = *text;
     if (!cotOrig())
        *zaehler++ = *text;
     inmakro = 0;
     anfang = 0;
   } 
   else {
     if ((lgkl < 1) && (daz < 1) && (inmakro==0)) {
       if (!cotOrig()){
          if ((*zaehler != '\0') && (text[index-1] != ' '))
	     *zaehler++ = ' ';
          *zaehler++ = '@';
       }
       *zaehler++ = *text;
       inmakro = 1;
       anfang = 0;
     }
     else {                        /* Zeichen in String */
       *zaehler++ = *text;
       anfang = 0;
       }
   } 
   text++;
   index++;
 }
 *zaehler++ = '\0';
 return erg;
}

static void PushSign(Snode **w, char a)
{
 Snode *hnode, *oldw;

 if (*w == NULL) {
   hnode = (Snode *)XtCalloc(1,sizeof(Snode));
   hnode->inh = a;
   hnode->slen = 1;
   hnode->next = NULL;
   *w = hnode;
 }
 else {
   oldw = *w; 
   hnode = (Snode *)XtCalloc(1,sizeof(Snode));
   hnode->inh = a;
   hnode->slen = oldw->slen + 1;
   hnode->next = oldw;
   *w = hnode;
}
}


static void FreeStack(Snode **s)
{
 Snode *h, *del;

 del = *s;
 while (del != NULL) {
   h = del->next;
   XtFree((char *)del);
   del = h;
 }
 *s = NULL;
} 


static void StringToString(char *text1, char **text) 
  
  {
   *text = (char *)XtCalloc(1,strlen(text1)+1);
   strcpy(*text, text1);
   }


static void StackToString(Snode *s, char **text) 
{
  char *help;
  
  if (s==NULL)
     help = (char *)XtCalloc(1,1);
  else
     help = (char *)XtCalloc(1,s->slen+1);
  *text = help;
  while (s != NULL) {
    *help = s->inh; 
    s = s->next;
    help++;
  }
  *help = '\0';
  help--;
  while (*help == '\n') {    /* NL am Ende vom Wort loeschen */
    *help = '\0';
    help--;
  }
}



static void GetKey()
{
  StackToString(key, &card->mainkey);
  FreeStack(&key);
  err = dbtInsert(glbbp, card);
  err = dbtDeleteCard(&card);
  ueIdx = 0;
}


static void GetFldNameCont()
{
  int found;
  FieldName i;
  
  if (helpFldName != NULL) {
    XtFree((char *)helpFldName);
    helpFldName = NULL;
  }
  StackToString(fldname, &helpFldName);
  strlower(helpFldName); 
  SkipSpace(uebergabe, ue2);
  found = 0;
  for (i=0;i<max_fields && (!found);i++) {
      if (strcmp(helpFldName, glbFldToName(i)) == 0) {
         if (isstandardfield(i, cardtype))
            StringToString(ue2, &card->field[i]);
         else {
            err = dbtMakeUserFld(&helpufield);
            Scalloc(&helpufield->fldName, helpFldName);
            StringToString(ue2, &helpufield->fldData); 
            err = dbtAppendUserFld(&card->ufield, helpufield);
            }
         found = 1; 
         break;
      }
  }
  if (!found){
     err = dbtMakeUserFld(&helpufield);
     Scalloc(&helpufield->fldName, helpFldName);
     StringToString(ue2, &helpufield->fldData); 
     err = dbtAppendUserFld(&card->ufield, helpufield);
     }
  FreeStack(&fldname);
}

static void SecStrcat(int maxlen, char *str1, char *str2)
{
 if (strlen(str1)+strlen(str2) < maxlen)
    strcat(str1, str2);
}

static int SetInputFile(char *file)
{
 char *infilename; 
    
 if (file)
 {
  infilename = file;

  if (access(infilename, F_OK) != 0)
     return BIF_ENOTEXISTS;

  yyin = fopen(infilename, "r" );

  if ( yyin == NULL ) {
    return BIF_EOPEN;  
  }
  return BIF_OK;  
 }
 else
 {
   yyin = stdin;
   infilename = "<stdin>";
   return BIF_OK;  
 }
}


/*********************************************
 * BibTeX-Datei lesen                        *
 *********************************************/
Errcode bifFileRead(BibPtr bp)
{
  int erg;
  char *tempName;

  yynline = 1; 
  yynflexcalls = 0;
  hlpQuitHelpError(7);

  sprintf(errorstr, anfhelpstr, "KEY", "OFFSET", "LINE");
#ifdef NO_TEMPNAM
  tempName = (char *)tmpnam(NULL);
  bp->tempfile = (char *)XtMalloc(strlen(tempName)+1);
  strcpy(bp->tempfile,tempName);
  tempName = (char *)tmpnam(NULL);
  bp->macrofile = (char *)XtMalloc(strlen(tempName)+1);
  strcpy(bp->macrofile,tempName);
#else
  bp->tempfile = (char *)tempnam(NULL, NULL);
  bp->macrofile = (char *)tempnam(NULL, NULL);
#endif
  tempDatei = fopen(bp->macrofile, "w" );

  if ((erg = SetInputFile(bp->filepath)) == BIF_ENOTEXISTS){
     glbbp = bp;
     fclose(tempDatei);
     return BIF_OK;
     }
  
  if ((erg = glbContIllegalChar(bp->filepath)) == 2) return ERR_NOBIB;
  if (erg == 1) return BIF_EOPEN;
  glbbp = bp; 
  erg = yyparse();
  fclose(tempDatei);
  uebergabe[0] = '\0';
  sprintf(errstr, endhelpstr, bp->filepath, yynerrs);
  SecStrcat(MAX_ERRORSTRLEN, errorstr, errstr);
  ueIdx = 0;
  if (erg == 0) {
    if (yyin) fclose(yyin);
    erg = yynline;
    if (yynerrs > 0)
       return yynline-1;
    else
       return BIF_OK;
  }
  else {
    erg = -yynline;
    yy_init = 1;
    if (yyin) fclose(yyin);
    FreeStack(&key);
    FreeStack(&fldname);
    return (Errcode)erg;
  }
}



Errcode bifFileWrite(BibPtr bp)
{
 char sysStr[2*MAX_FILEPATHLEN];
 CardListNode *cl1 = NULL;
 CardListNode *cl2 = NULL;
 Errcode status;

 if (bp->macrofile!=NULL){
    sprintf(sysStr, "cp  %s %s", bp->macrofile, bp->tempfile);
    system(sysStr);
    tempDatei = fopen(bp->tempfile, "r+");
    }
 else
    {tempDatei = fopen(bp->tempfile, "w+");
     }

 if (tempDatei == NULL) return BIF_EWRITE;

   /* build list */
   if ((status = dbtBuildList(bp->treeIdx, &cl1, bp->sortedby)) != OK) {
      guwError(status); 
      return(status);
   }

 cl2 = cl1;

 while (cl1 != NULL) {
   if (!glbIsStringEmpty(cl1->data->field[ncrossref]))
      WriteRecToFile(cl1->data, tempDatei);
   cl1 = cl1->next;
 } 

 while (cl2 != NULL) {
   if (glbIsStringEmpty(cl2->data->field[ncrossref]))
      WriteRecToFile(cl2->data, tempDatei);
   cl2 = cl2->next;
 } 

 fclose(tempDatei);
 sprintf(sysStr, "cp  %s %s", bp->tempfile, bp->filepath);
 system(sysStr);
 return BIF_OK;
}


Errcode bifFileListWrite(BibPtr bp, CardListNode *list, String fname)
{
 CardListNode *hlist;
 Errcode erg;
 char sysStr[2*MAX_FILEPATHLEN];
 
 if (bp->macrofile!=NULL){
    sprintf(sysStr, "cp  %s %s", bp->macrofile, fname);
    system(sysStr);
    tempDatei = fopen(fname, "r+");
    }
 else
    {tempDatei = fopen(fname, "w+");
     }

 if (tempDatei == NULL) return BIF_EWRITE;
 hlist = list;
 while (hlist != NULL) {
   if (!glbIsStringEmpty(hlist->data->field[ncrossref]))
      WriteRecToFile(hlist->data, tempDatei);
   hlist = hlist->next;
 } 
 hlist = list;
 while (hlist != NULL) {
   if (glbIsStringEmpty(hlist->data->field[ncrossref]))
      WriteRecToFile(hlist->data, tempDatei);
   hlist = hlist->next;
 } 
 fclose(tempDatei);
 return BIF_OK;
}


static void WriteOrigLine(FILE *datei, char *inh)
{ 
  int zaehler;
  char *zeiger;

  zeiger = inh;
  while (*zeiger != '\0'){
     if (*zeiger != '\n')
	fputc(*zeiger, datei);
     else {
	fputc(*zeiger, datei);
        for (zaehler = 0; zaehler < newline_indent; zaehler++)
	   fputc(' ', datei);
     }
     zeiger++;
  }
}

static long WriteLineToFile(FILE *datei, char *feld, char *inh)
{
  int inmakro = 0;    /* weder Makro, noch String */
  int instring = 0;
  int isempty = 1;
  int zaehler;
  long pos; 
  char *blank, *blankptr, *zeichen; 

  
  for (zaehler = 0; zaehler < fld_indent; zaehler++)
     fprintf(datei," ");
  fprintf(datei,"%s", feld);
  zaehler += strlen(feld);
  for (;zaehler < cont_indent - 3; zaehler++)
     fprintf(datei," ");
  fprintf(datei," = ");

  if (cotOrig()){
     WriteOrigLine(datei, inh);
     pos = ftell(datei);
     fprintf(datei,",\n");
     return pos;
  }

  zeichen = inh;
  blank = (char *)XtMalloc(100);
  blankptr = blank;

  while (*zeichen!='\0'){
   switch (*zeichen){
     case ' ':
     case '\t':
	  if (instring)
	     *blankptr++ = *zeichen;
          else if (inmakro){
	     fprintf(datei, " ");
	     inmakro = 0;
	     }
          break;
     case '\n':
	  if (instring){ 
	     *blankptr++ = *zeichen;
	     for (zaehler = 0; zaehler < newline_indent; zaehler++)
	        *blankptr++ = ' ';
             } 
          else {
	     fprintf(datei, "\n");
	     for (zaehler = 0; zaehler < newline_indent; zaehler++)
	        fprintf(datei, " ");
	     inmakro = 0;
	     } 
	  inmakro = 0;
          break;
     case '@':
          if (inmakro)
	     fprintf(datei, " ");
          else if (*(zeichen+1) == '@'){
	     if (instring){
		*blankptr++ = '\0';
		fprintf(datei, "%s", blank);
		blankptr = blank;
		}
             else {
	        fprintf(datei, "{");
		instring=1;
		}
	     fprintf(datei, "@");
	     zeichen++;
	     }
          else if (instring){
	     fprintf(datei, "} ");
	     inmakro = 1;
	     instring = 0;
	     }
          else {
	     inmakro = 1;
	     instring = 0;
	     }
          break;
     case '#':
          if (isempty && inmakro) {
	     fprintf(datei, "{ } #");
             blankptr = blank;
	     *blankptr = '\0';
	     inmakro = 0;
	     }
          else if (inmakro){
	     fprintf(datei, "# ");
             blankptr = blank;
	     *blankptr = '\0';
	     inmakro = 0;
	     }
          else if (instring) 
	     fprintf(datei, "#");
          else {
	     fprintf(datei, "{#");
	     instring = 1;
	     }
          break;
      default:
          isempty = 0;
          if (inmakro)
	     fprintf(datei, "%c", *zeichen);
          else if (instring){
	     *blankptr++ = '\0';
	     fprintf(datei, "%s", blank);
	     blankptr = blank;
	     fprintf(datei, "%c", *zeichen);
	     }
          else{
	     fprintf(datei, "{%c", *zeichen);
	     instring = 1;
	     inmakro = 0;
	     }
          break;
      } /* case */
  zeichen++;
  } /* while */
	   
  if ((isempty==1) && (inmakro==0) && (instring==0))
    fprintf(datei,"{ }");    
  else if (instring) {
    fprintf(datei,"}");    
  }
        
  pos = ftell(datei);
  fprintf(datei,",\n");
  XtFree(blank);
  return pos;
}

static void WriteRecToFile(CardData *card, FILE *datei)
{
 UserFld *h;
 String newType;
 long pos;
 FieldName i;

 fseek(datei, 0L, SEEK_END); 
 fprintf(datei,"\n");
 pos = ftell(datei);
 newType = glbNewString(card->cardtypestr);
 fprintf(datei,"@%s{%s",newType, card->mainkey);
 XtFree(newType);
 pos = ftell(datei);
 fprintf(datei,",\n");

 for (i=0; i<max_fields; i++) {
    if (!StringIsPeteEmpty(card->field[i]))
       pos = WriteLineToFile(datei, glbFldToName(i), card->field[i]);
 }
 h = card->ufield; 
 while (h) {
   if (!StringIsPeteEmpty(h->fldData)) 
      pos = WriteLineToFile(datei,h->fldName,h->fldData);    
   h = h->next;
 }   
 fseek(datei, pos, SEEK_SET);
 fprintf(datei,"\n}\n\n");
}



static int StringIsPeteEmpty(char *text)
{
 if (text == NULL || *text == '\0') return 1;
 return 0;
}



yyerror(char *s)
{

 fputs(s, stderr);
 putc('\n', stderr);
}

#ifdef BIFMAIN

int main(int argc, char *argv[])
{
 Bib bp;
 int erg, b1, i;
 Errcode err;

#ifdef YYDEBUG
       extern int yydebug;

       yydebug = 1;
#endif

 strcpy(bp.filepath, argv[1]);
 dbtGetFreeTreeIdx(&b1);
 bp.treeIdx = b1;
 err = bifFileRead(&bp);
 err = bifFileWrite(&bp);
}

#endif
__YYSCLASS yytabelem yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
-1, 2,
	0, 4,
	-2, 0,
-1, 3,
	0, 3,
	-2, 0,
	};
# define YYNPROD 247
# define YYLAST 623
__YYSCLASS yytabelem yyact[]={

   277,    35,    12,    13,    36,    14,    15,    16,    17,    18,
    19,    37,    20,    21,    33,    22,    41,    42,   243,   291,
   289,   290,   288,   293,   295,   292,   287,   312,   285,   286,
   294,   284,   283,   282,   279,   280,   281,   291,   289,   290,
   288,   293,   295,   292,   287,   278,   285,   286,   294,   284,
   283,   282,   279,   280,   281,    73,    71,    72,    70,    63,
    64,    74,    67,   242,    68,    69,    66,    65,    61,    60,
    58,    59,    62,    73,    71,    72,    70,    63,    64,    74,
    67,   127,    68,    69,    66,    65,    61,    60,    58,    59,
    62,    11,    24,    25,    26,    28,    12,    13,    52,    14,
    15,    16,    17,    18,    19,    23,    20,    21,     6,    22,
   291,   289,   290,   288,   293,   295,   292,   287,   238,   285,
   286,   294,   284,   283,   282,   279,   280,   281,   259,   257,
   258,   256,   250,   251,   260,   255,   266,   253,   254,   244,
   252,   249,   248,   245,   246,   247,    73,    71,    72,    70,
    63,    64,    74,    67,   236,    68,    69,    66,    65,    61,
    60,    58,    59,    62,    92,    90,    91,    89,    83,    84,
    93,    87,   223,    88,   150,    86,    85,    81,    80,    78,
    79,    82,    92,    90,    91,    89,    83,    84,    93,    87,
   148,    88,   322,    86,    85,    81,    80,    78,    79,    82,
   259,   257,   258,   256,   250,   251,   260,   255,   234,   253,
   254,   233,   252,   249,   248,   245,   246,   247,    92,    90,
    91,    89,    83,    84,    93,    87,   186,    88,   301,    86,
    85,    81,    80,    78,    79,    82,    35,    12,    13,    36,
    14,    15,    16,    17,    18,    19,    37,    20,    21,   110,
    22,   222,   206,   111,   112,   109,    41,    42,   108,    41,
    42,   107,    41,    42,   267,   268,   269,   270,   271,   272,
   273,   274,   275,   276,   184,   296,   297,   298,   299,   300,
   303,   304,   305,   306,   307,   308,   309,   310,   311,   313,
   314,   315,   316,   317,   318,   319,   320,   302,   230,   182,
   192,   265,   231,   191,   220,   234,    41,    42,   233,   179,
   110,    41,    42,   323,   111,   112,   109,   230,   163,   108,
   321,   231,   107,   324,   234,   159,   137,   233,   192,    41,
    42,   191,    49,   212,    51,    46,   217,    48,    41,    42,
    41,    42,   235,    41,    42,    43,   214,    45,    38,   203,
    40,   201,   213,    41,    42,   185,    41,    42,    41,    42,
    41,    42,   113,   101,   114,   102,    97,    75,    98,    76,
   183,   180,   178,   176,   160,   156,   116,    31,   105,   195,
   194,   175,   164,   227,    57,   190,   232,   189,   228,    32,
   218,   187,    34,     4,     1,     4,     4,    29,    30,   226,
    27,    10,     9,    39,    44,    47,    50,     8,     7,     5,
     3,   106,     2,   104,     0,    77,     0,     0,     0,     0,
    94,    95,     0,     0,    53,    54,    55,    56,    96,     0,
     0,   100,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,   117,   118,   119,   120,   121,   122,   123,
   124,   125,   126,   128,   129,   130,   131,   132,   133,   134,
   135,    99,     0,     0,   103,   115,     0,     0,     0,     0,
     0,     0,     0,     0,     0,   152,     0,     0,     0,     0,
     0,     0,   157,     0,     0,   166,   161,     0,     0,     0,
     0,     0,   136,     0,   138,   139,   140,   141,   142,   143,
   144,   145,   146,   147,   149,   151,     0,   153,   154,   155,
     0,     0,   177,     0,   158,     0,     0,   165,   162,   167,
   168,   169,   170,   171,   172,     0,     0,   173,   174,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,   188,   193,     0,     0,     0,     0,     0,
     0,     0,     0,     0,   188,     0,     0,     0,     0,     0,
     0,   197,     0,     0,   181,     0,   200,   196,   204,   205,
     0,     0,     0,   188,   188,   211,   202,   207,   208,     0,
     0,     0,   216,     0,     0,     0,   209,   210,   219,   221,
     0,     0,     0,   225,     0,   215,   198,   229,   199,     0,
     0,     0,     0,     0,   202,   229,   224,   239,     0,     0,
   237,     0,     0,   202,     0,   241,     0,   229,   240,   264,
   261,   262,   263 };
__YYSCLASS yytabelem yypact[]={

  -165, -3000,  -165,  -165, -3000, -3000, -3000, -3000, -3000, -3000,
 -3000,   112, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000,
 -3000, -3000, -3000,  -259,    84,    81,    71,    68, -3000, -3000,
 -3000, -3000,  -175, -3000,   -24,   -24,   -24,   -24,  -111,   103,
   -39,  -256,  -256,  -111,   102,   -39,  -111,    99,   -39,   -13,
    98,   -13, -3000, -3000, -3000, -3000, -3000,   111,  -111,  -111,
  -111,  -111,  -111,  -111,  -111,  -111,  -111,  -184,  -111,  -111,
  -111,  -111,  -111,  -111,  -111,  -111,   -39,    59,   -39,   -39,
   -39,   -39,   -39,   -39,   -39,   -39,   -39,   -75,   -93,   -39,
  -111,   -39,   -39,   -39, -3000, -3000,   110,  -111,   -39,    58,
   109,  -111,   -39,    51,   121,    48,  -256,    48,    48,    48,
    48,    48,    48,   -13,   -13,   120, -3000, -3000, -3000, -3000,
 -3000, -3000, -3000, -3000, -3000, -3000,   108,  -111, -3000, -3000,
 -3000, -3000, -3000, -3000, -3000,   107,    42, -3000, -3000, -3000,
 -3000, -3000, -3000, -3000, -3000, -3000, -3000,   106,   -39,    32,
 -3000, -3000, -3000, -3000, -3000, -3000, -3000,   105,     7, -3000,
 -3000,    90,   -41, -3000,    57,  -256, -3000, -3000, -3000, -3000,
 -3000, -3000, -3000,   119,   118,    57,  -111, -3000, -3000, -3000,
   -39, -3000,   -39, -3000, -3000, -3000, -3000,    86,    29,    88,
   -10,    29,    29, -3000,    57,    57,    66, -3000, -3000, -3000,
    87, -3000,    85,    57, -3000,    74, -3000, -3000, -3000,    39,
   -16,   -95, -3000, -3000,    57, -3000,    29, -3000,    34,    77,
 -3000,  -113, -3000, -3000, -3000,    29,    34,  -151,  -256,    53,
  -202,  -129, -3000,   -63,   -63, -3000, -3000,  -151,    34, -3000,
  -256,    36, -3000,  -132, -3000,   -57,   -57,   -57,   -57,   -57,
   -57,   -57,   -57,   -57,   -57,  -220,   -57,   -57,   -57,   -57,
   -57, -3000, -3000,  -151, -3000, -3000, -3000, -3000, -3000, -3000,
 -3000, -3000, -3000, -3000, -3000, -3000, -3000,   -37,   -57,  -147,
  -147,  -147,  -147,  -147,  -147,  -147,  -147,  -238,  -147,  -147,
  -147,  -147,  -147,  -147,  -147,  -147, -3000, -3000, -3000, -3000,
 -3000,   -57, -3000, -3000, -3000, -3000, -3000, -3000, -3000, -3000,
 -3000,   -73,  -147, -3000, -3000, -3000, -3000, -3000, -3000, -3000,
 -3000, -3000,  -147, -3000, -3000 };
__YYSCLASS yytabelem yypgo[]={

     0,   394,   412,   410,   392,   409,   389,   408,   407,   402,
   401,   384,   378,   415,   400,   413,   391,   411,   387,   385,
   399,   383,   390,   388,    18,   386,     0 };
__YYSCLASS yytabelem yyr1[]={

     0,     1,     1,     1,     1,     2,     2,     2,     4,     4,
     4,     4,     4,     4,     4,     4,     4,     4,     4,     5,
     5,     6,     6,     6,     6,     6,     6,     6,     6,     3,
     3,     3,     3,     3,     8,     8,     8,     8,     7,     7,
     7,     7,     9,     9,     9,     9,    11,    11,    11,    11,
    11,    11,    11,    11,    11,    11,    11,    11,    11,    11,
    11,    11,    11,    11,    11,    11,    11,    11,    11,    11,
    11,    11,    11,    11,    11,    11,    11,    11,    11,    11,
    11,    11,    13,    13,    13,    13,    13,    13,    13,    13,
    13,    13,    13,    13,    13,    13,    13,    13,    13,    13,
    13,    13,    13,    13,    13,    13,    13,    13,    13,    13,
    13,    13,    13,    13,    13,    13,    13,    10,    10,    10,
    10,    10,    10,    10,    10,    14,    15,    15,    15,    15,
    17,    17,    17,    17,    17,    17,    17,    17,    17,    17,
    17,    17,    16,    16,    16,    16,    16,    16,    16,    16,
    16,    20,    18,    22,    18,    19,    19,    19,    19,    12,
    12,    12,    12,    21,    21,    21,    21,    21,    23,    23,
    23,    23,    23,    25,    25,    25,    25,    24,    24,    24,
    24,    24,    24,    24,    24,    24,    24,    24,    24,    24,
    24,    24,    24,    24,    24,    24,    24,    24,    24,    24,
    24,    24,    24,    24,    24,    24,    24,    24,    24,    24,
    24,    26,    26,    26,    26,    26,    26,    26,    26,    26,
    26,    26,    26,    26,    26,    26,    26,    26,    26,    26,
    26,    26,    26,    26,    26,    26,    26,    26,    26,    26,
    26,    26,    26,    26,    26,    26,    26 };
__YYSCLASS yytabelem yyr2[]={

     0,     4,     4,     2,     2,     3,     3,     3,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     6,
     4,     4,     4,     4,     4,     2,     2,     2,     2,     2,
     2,     2,     2,     5,     9,    11,     9,    11,     9,    11,
     9,    11,     9,    11,     9,    11,     4,     4,     4,     4,
     4,     4,     4,     4,     4,     8,     6,     6,     4,     4,
     4,     4,     4,     4,     4,     4,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     4,     4,     4,     4,     4,     4,     4,     4,
     4,     8,     6,     6,     4,     8,     6,     4,     4,     4,
     4,     4,     4,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,    15,    17,    13,
    15,    15,    17,    13,    15,     3,     4,     4,     6,     2,
     5,     5,     5,     5,     5,     5,     3,     3,     3,     3,
     3,     3,     8,     6,     6,     8,     4,     6,     4,     2,
     4,     1,    11,     1,     9,     5,     5,     3,     3,     4,
     4,     2,     2,     6,     2,     4,     4,     6,     6,     6,
     4,     4,     2,     4,     4,     2,     2,     4,     4,     4,
     4,     4,     4,     4,     4,     4,     4,     6,     8,     4,
     6,     4,     4,     4,     4,     4,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     4,     4,     4,     4,     4,     4,     4,     4,     6,
     8,     4,     6,     4,     4,     4,     4,     4,     2,     2,
     2,     4,     4,     4,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2 };
__YYSCLASS yytabelem yychk[]={

 -3000,    -1,    -2,    -3,    -4,    -5,   273,    -7,    -8,    -9,
   -10,   256,   261,   262,   264,   265,   266,   267,   268,   269,
   271,   272,   274,   270,   257,   258,   259,   -14,   260,    -1,
    -1,   265,    -6,   273,    -4,   260,   263,   270,   264,   -12,
   266,   272,   273,   264,   -12,   266,   264,   -12,   266,   264,
   -12,   266,   273,    -6,    -6,    -6,    -6,   -11,   272,   273,
   271,   270,   274,   261,   262,   269,   268,   264,   266,   267,
   260,   258,   259,   257,   263,   264,   266,   -13,   272,   273,
   271,   270,   274,   261,   262,   269,   268,   264,   266,   260,
   258,   259,   257,   263,   -12,   -12,   -11,   264,   266,   -13,
   -11,   264,   266,   -13,   -15,   -12,   -17,   274,   271,   268,
   262,   266,   267,   264,   266,   -15,   265,   -11,   -11,   -11,
   -11,   -11,   -11,   -11,   -11,   -11,   -11,   265,   -11,   -11,
   -11,   -11,   -11,   -11,   -11,   -11,   -13,   267,   -13,   -13,
   -13,   -13,   -13,   -13,   -13,   -13,   -13,   -13,   265,   -13,
   267,   -13,   -11,   -13,   -13,   -13,   265,   -11,   -13,   267,
   265,   -11,   -13,   267,   261,   -17,   -12,   -17,   -17,   -17,
   -17,   -17,   -17,   -15,   -15,   261,   265,   -11,   265,   267,
   265,   -13,   267,   265,   267,   265,   267,   -16,   -12,   -18,
   -19,   274,   271,   -12,   261,   261,   -16,   -11,   -13,   -13,
   -12,   265,   -18,   261,   -12,   -12,   262,   -19,   -19,   -16,
   -16,   -12,   267,   265,   261,   -16,   -12,   262,   -22,   -12,
   265,   -12,   267,   267,   -16,   -12,   -20,   -21,   -23,   -12,
   264,   268,   -25,   274,   271,   265,   267,   -21,   269,   -12,
   -23,   -11,   265,   -24,   268,   272,   273,   274,   271,   270,
   261,   262,   269,   266,   267,   264,   260,   258,   259,   257,
   263,   -25,   -25,   -21,   -12,   265,   268,   -24,   -24,   -24,
   -24,   -24,   -24,   -24,   -24,   -24,   -24,   -26,   265,   272,
   273,   274,   271,   270,   269,   266,   267,   264,   260,   258,
   259,   257,   263,   261,   268,   262,   -24,   -24,   -24,   -24,
   -24,   265,   -24,   -26,   -26,   -26,   -26,   -26,   -26,   -26,
   -26,   -26,   265,   -26,   -26,   -26,   -26,   -26,   -26,   -26,
   -26,   -24,   265,   -26,   -26 };
__YYSCLASS yytabelem yydef[]={

     0,    -2,    -2,    -2,     5,     6,     7,    29,    30,    31,
    32,     0,     8,     9,    10,    11,    12,    13,    14,    15,
    16,    17,    18,     0,     0,     0,     0,     0,   125,     1,
     2,    33,     0,    20,    25,    26,    27,    28,     0,     0,
     0,   161,   162,     0,     0,     0,     0,     0,     0,     0,
     0,     0,    19,    21,    22,    23,    24,     0,    66,    67,
    68,    69,    70,    71,    72,    73,    74,     0,    75,    76,
    77,    79,    80,    81,    78,     0,     0,     0,   103,   104,
   105,   106,   107,   108,   109,   110,   111,     0,     0,   112,
   114,   115,   116,   113,   159,   160,     0,     0,     0,     0,
     0,     0,     0,     0,     0,     0,   129,   136,   137,   139,
   138,   140,   141,     0,     0,     0,    38,    46,    47,    48,
    49,    50,    51,    52,    53,    54,     0,    58,    59,    60,
    61,    62,    63,    64,    65,     0,     0,    40,    82,    83,
    84,    85,    86,    87,    88,    89,    90,     0,    94,     0,
   102,    97,    98,    99,   100,   101,    34,     0,     0,    36,
    42,     0,     0,    44,     0,   126,   127,   130,   131,   132,
   133,   134,   135,     0,     0,     0,    57,    56,    39,    41,
    93,    92,    96,    35,    37,    43,    45,     0,     0,   149,
     0,   157,   158,   128,     0,     0,     0,    55,    91,    95,
     0,   119,   148,   146,   150,     0,   153,   155,   156,     0,
     0,     0,   123,   117,   144,   143,   147,   151,     0,     0,
   120,     0,   124,   121,   142,   145,     0,   154,   164,     0,
     0,     0,   172,   175,   176,   118,   122,   152,     0,   165,
   166,     0,   171,     0,   170,   196,   197,   198,   199,   200,
   201,   202,   203,   204,   205,     0,   207,   208,   209,   210,
   206,   173,   174,   163,   167,   168,   169,   177,   178,   179,
   180,   181,   182,   183,   184,   185,   186,     0,   189,   228,
   229,   230,   234,   235,   236,   238,   239,     0,   243,   244,
   245,   246,   242,   240,   241,   237,   191,   192,   193,   194,
   195,   187,   190,   211,   212,   213,   214,   215,   216,   217,
   218,     0,   221,   223,   224,   225,   226,   227,   231,   232,
   233,   188,   219,   222,   220 };
typedef struct { char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

__YYSCLASS yytoktype yytoks[] =
{
	"COMMENT",	257,
	"STRING",	258,
	"PREAMBLE",	259,
	"TYPE",	260,
	"KOMMA",	261,
	"EQ",	262,
	"AFFE",	263,
	"LGKL",	264,
	"RGKL",	265,
	"LRKL",	266,
	"RRKL",	267,
	"DAZ",	268,
	"ZAUN",	269,
	"PROZENT",	270,
	"ZEICHEN",	271,
	"WHITE_SPACE",	272,
	"NEW_LINE",	273,
	"BUCHSTABE_ZAHL",	274,
	"-unknown-",	-1	/* ends search */
};

__YYSCLASS char * yyreds[] =
{
	"-no such reduction-",
	"datei : between datei",
	"datei : entry datei",
	"datei : entry",
	"datei : between",
	"between : alles",
	"between : kommentar",
	"between : NEW_LINE",
	"alles : KOMMA",
	"alles : EQ",
	"alles : LGKL",
	"alles : RGKL",
	"alles : LRKL",
	"alles : RRKL",
	"alles : DAZ",
	"alles : ZAUN",
	"alles : ZEICHEN",
	"alles : WHITE_SPACE",
	"alles : BUCHSTABE_ZAHL",
	"kommentar : PROZENT kommaffe NEW_LINE",
	"kommentar : PROZENT NEW_LINE",
	"kommaffe : alles kommaffe",
	"kommaffe : TYPE kommaffe",
	"kommaffe : AFFE kommaffe",
	"kommaffe : PROZENT kommaffe",
	"kommaffe : alles",
	"kommaffe : TYPE",
	"kommaffe : AFFE",
	"kommaffe : PROZENT",
	"entry : comment",
	"entry : string",
	"entry : preamble",
	"entry : eintrag",
	"entry : error RGKL",
	"string : STRING LGKL allstringG RGKL",
	"string : STRING leerraum LGKL allstringG RGKL",
	"string : STRING LRKL allstringR RRKL",
	"string : STRING leerraum LRKL allstringR RRKL",
	"comment : COMMENT LGKL allstringG RGKL",
	"comment : COMMENT leerraum LGKL allstringG RGKL",
	"comment : COMMENT LRKL allstringR RRKL",
	"comment : COMMENT leerraum LRKL allstringR RRKL",
	"preamble : PREAMBLE LGKL allstringG RGKL",
	"preamble : PREAMBLE leerraum LGKL allstringG RGKL",
	"preamble : PREAMBLE LRKL allstringR RRKL",
	"preamble : PREAMBLE leerraum LRKL allstringR RRKL",
	"allstringG : WHITE_SPACE allstringG",
	"allstringG : NEW_LINE allstringG",
	"allstringG : ZEICHEN allstringG",
	"allstringG : PROZENT allstringG",
	"allstringG : BUCHSTABE_ZAHL allstringG",
	"allstringG : KOMMA allstringG",
	"allstringG : EQ allstringG",
	"allstringG : ZAUN allstringG",
	"allstringG : DAZ allstringG",
	"allstringG : LGKL allstringG RGKL allstringG",
	"allstringG : LGKL RGKL allstringG",
	"allstringG : LGKL allstringG RGKL",
	"allstringG : LGKL RGKL",
	"allstringG : LRKL allstringG",
	"allstringG : RRKL allstringG",
	"allstringG : TYPE allstringG",
	"allstringG : STRING allstringG",
	"allstringG : PREAMBLE allstringG",
	"allstringG : COMMENT allstringG",
	"allstringG : AFFE allstringG",
	"allstringG : WHITE_SPACE",
	"allstringG : NEW_LINE",
	"allstringG : ZEICHEN",
	"allstringG : PROZENT",
	"allstringG : BUCHSTABE_ZAHL",
	"allstringG : KOMMA",
	"allstringG : EQ",
	"allstringG : ZAUN",
	"allstringG : DAZ",
	"allstringG : LRKL",
	"allstringG : RRKL",
	"allstringG : TYPE",
	"allstringG : AFFE",
	"allstringG : STRING",
	"allstringG : PREAMBLE",
	"allstringG : COMMENT",
	"allstringR : WHITE_SPACE allstringR",
	"allstringR : NEW_LINE allstringR",
	"allstringR : ZEICHEN allstringR",
	"allstringR : PROZENT allstringR",
	"allstringR : BUCHSTABE_ZAHL allstringR",
	"allstringR : KOMMA allstringR",
	"allstringR : EQ allstringR",
	"allstringR : ZAUN allstringR",
	"allstringR : DAZ allstringR",
	"allstringR : LGKL allstringR RGKL allstringR",
	"allstringR : LGKL RGKL allstringR",
	"allstringR : LGKL allstringR RGKL",
	"allstringR : LGKL RGKL",
	"allstringR : LRKL allstringR RRKL allstringR",
	"allstringR : LRKL allstringR RRKL",
	"allstringR : TYPE allstringR",
	"allstringR : STRING allstringG",
	"allstringR : PREAMBLE allstringR",
	"allstringR : COMMENT allstringR",
	"allstringR : AFFE allstringR",
	"allstringR : LRKL RRKL",
	"allstringR : WHITE_SPACE",
	"allstringR : NEW_LINE",
	"allstringR : ZEICHEN",
	"allstringR : PROZENT",
	"allstringR : BUCHSTABE_ZAHL",
	"allstringR : KOMMA",
	"allstringR : EQ",
	"allstringR : ZAUN",
	"allstringR : DAZ",
	"allstringR : TYPE",
	"allstringR : AFFE",
	"allstringR : STRING",
	"allstringR : PREAMBLE",
	"allstringR : COMMENT",
	"eintrag : eingabetyp LGKL schluessel KOMMA felder leerraum RGKL",
	"eintrag : eingabetyp leerraum LGKL schluessel KOMMA felder leerraum RGKL",
	"eintrag : eingabetyp LGKL schluessel KOMMA felder RGKL",
	"eintrag : eingabetyp leerraum LGKL schluessel KOMMA felder RGKL",
	"eintrag : eingabetyp LRKL schluessel KOMMA felder leerraum RRKL",
	"eintrag : eingabetyp leerraum LRKL schluessel KOMMA felder leerraum RRKL",
	"eintrag : eingabetyp LRKL schluessel KOMMA felder RRKL",
	"eintrag : eingabetyp leerraum LRKL schluessel KOMMA felder RRKL",
	"eingabetyp : TYPE",
	"schluessel : leerraum schl",
	"schluessel : schl leerraum",
	"schluessel : leerraum schl leerraum",
	"schluessel : schl",
	"schl : BUCHSTABE_ZAHL schl",
	"schl : ZEICHEN schl",
	"schl : DAZ schl",
	"schl : EQ schl",
	"schl : LRKL schl",
	"schl : RRKL schl",
	"schl : BUCHSTABE_ZAHL",
	"schl : ZEICHEN",
	"schl : EQ",
	"schl : DAZ",
	"schl : LRKL",
	"schl : RRKL",
	"felder : leerraum feld KOMMA felder",
	"felder : feld KOMMA felder",
	"felder : leerraum feld KOMMA",
	"felder : leerraum feld KOMMA leerraum",
	"felder : feld KOMMA",
	"felder : feld KOMMA leerraum",
	"felder : leerraum feld",
	"felder : feld",
	"felder : feld leerraum",
	"feld : feldname leerraum EQ",
	"feld : feldname leerraum EQ konkatenation",
	"feld : feldname EQ",
	"feld : feldname EQ konkatenation",
	"feldname : BUCHSTABE_ZAHL feldname",
	"feldname : ZEICHEN feldname",
	"feldname : BUCHSTABE_ZAHL",
	"feldname : ZEICHEN",
	"leerraum : WHITE_SPACE leerraum",
	"leerraum : NEW_LINE leerraum",
	"leerraum : WHITE_SPACE",
	"leerraum : NEW_LINE",
	"konkatenation : konkatenation ZAUN konkatenation",
	"konkatenation : feldinhalt",
	"konkatenation : feldinhalt leerraum",
	"konkatenation : leerraum feldinhalt",
	"konkatenation : leerraum feldinhalt leerraum",
	"feldinhalt : LGKL allstringG RGKL",
	"feldinhalt : DAZ dazfeldinhalt DAZ",
	"feldinhalt : DAZ DAZ",
	"feldinhalt : LGKL RGKL",
	"feldinhalt : makro",
	"makro : BUCHSTABE_ZAHL makro",
	"makro : ZEICHEN makro",
	"makro : BUCHSTABE_ZAHL",
	"makro : ZEICHEN",
	"dazfeldinhalt : WHITE_SPACE dazfeldinhalt",
	"dazfeldinhalt : NEW_LINE dazfeldinhalt",
	"dazfeldinhalt : BUCHSTABE_ZAHL dazfeldinhalt",
	"dazfeldinhalt : ZEICHEN dazfeldinhalt",
	"dazfeldinhalt : PROZENT dazfeldinhalt",
	"dazfeldinhalt : KOMMA dazfeldinhalt",
	"dazfeldinhalt : EQ dazfeldinhalt",
	"dazfeldinhalt : ZAUN dazfeldinhalt",
	"dazfeldinhalt : LRKL dazfeldinhalt",
	"dazfeldinhalt : RRKL dazfeldinhalt",
	"dazfeldinhalt : LGKL dazdaz RGKL",
	"dazfeldinhalt : LGKL dazdaz RGKL dazfeldinhalt",
	"dazfeldinhalt : LGKL RGKL",
	"dazfeldinhalt : LGKL RGKL dazfeldinhalt",
	"dazfeldinhalt : TYPE dazfeldinhalt",
	"dazfeldinhalt : STRING dazfeldinhalt",
	"dazfeldinhalt : PREAMBLE dazfeldinhalt",
	"dazfeldinhalt : COMMENT dazfeldinhalt",
	"dazfeldinhalt : AFFE dazfeldinhalt",
	"dazfeldinhalt : WHITE_SPACE",
	"dazfeldinhalt : NEW_LINE",
	"dazfeldinhalt : BUCHSTABE_ZAHL",
	"dazfeldinhalt : ZEICHEN",
	"dazfeldinhalt : PROZENT",
	"dazfeldinhalt : KOMMA",
	"dazfeldinhalt : EQ",
	"dazfeldinhalt : ZAUN",
	"dazfeldinhalt : LRKL",
	"dazfeldinhalt : RRKL",
	"dazfeldinhalt : AFFE",
	"dazfeldinhalt : TYPE",
	"dazfeldinhalt : STRING",
	"dazfeldinhalt : PREAMBLE",
	"dazfeldinhalt : COMMENT",
	"dazdaz : WHITE_SPACE dazdaz",
	"dazdaz : NEW_LINE dazdaz",
	"dazdaz : BUCHSTABE_ZAHL dazdaz",
	"dazdaz : ZEICHEN dazdaz",
	"dazdaz : PROZENT dazdaz",
	"dazdaz : ZAUN dazdaz",
	"dazdaz : LRKL dazdaz",
	"dazdaz : RRKL dazdaz",
	"dazdaz : LGKL dazdaz RGKL",
	"dazdaz : LGKL dazdaz RGKL dazdaz",
	"dazdaz : LGKL RGKL",
	"dazdaz : LGKL RGKL dazdaz",
	"dazdaz : TYPE dazdaz",
	"dazdaz : STRING dazdaz",
	"dazdaz : PREAMBLE dazdaz",
	"dazdaz : COMMENT dazdaz",
	"dazdaz : AFFE dazdaz",
	"dazdaz : WHITE_SPACE",
	"dazdaz : NEW_LINE",
	"dazdaz : BUCHSTABE_ZAHL",
	"dazdaz : KOMMA dazdaz",
	"dazdaz : DAZ dazdaz",
	"dazdaz : EQ dazdaz",
	"dazdaz : ZEICHEN",
	"dazdaz : PROZENT",
	"dazdaz : ZAUN",
	"dazdaz : EQ",
	"dazdaz : LRKL",
	"dazdaz : RRKL",
	"dazdaz : KOMMA",
	"dazdaz : DAZ",
	"dazdaz : AFFE",
	"dazdaz : TYPE",
	"dazdaz : STRING",
	"dazdaz : PREAMBLE",
	"dazdaz : COMMENT",
};
#endif /* YYDEBUG */
#define YYFLAG  (-3000)
/* @(#) $Revision: 70.7 $ */    

/*
** Skeleton parser driver for yacc output
*/

#if defined(NLS) && !defined(NL_SETN)
#include <msgbuf.h>
#endif

#ifndef nl_msg
#define nl_msg(i,s) (s)
#endif

/*
** yacc user known macros and defines
*/
#define YYERROR		goto yyerrlab

#ifndef __RUNTIME_YYMAXDEPTH
#define YYACCEPT	return(0)
#define YYABORT		return(1)
#else
#define YYACCEPT	{free_stacks(); return(0);}
#define YYABORT		{free_stacks(); return(1);}
#endif

#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( (nl_msg(30001,"syntax error - cannot backup")) );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
/* define for YYFLAG now generated by yacc program. */
/*#define YYFLAG		(FLAGVAL)*/

/*
** global variables used by the parser
*/
# ifndef __RUNTIME_YYMAXDEPTH
__YYSCLASS YYSTYPE yyv[ YYMAXDEPTH ];	/* value stack */
__YYSCLASS int yys[ YYMAXDEPTH ];		/* state stack */
# else
__YYSCLASS YYSTYPE *yyv;			/* pointer to malloc'ed value stack */
__YYSCLASS int *yys;			/* pointer to malloc'ed stack stack */

#if defined(__STDC__) || defined (__cplusplus)
#include <stdlib.h>
#else
	extern char *malloc();
	extern char *realloc();
	extern void free();
#endif /* __STDC__ or __cplusplus */


static int allocate_stacks(); 
static void free_stacks();
# ifndef YYINCREMENT
# define YYINCREMENT (YYMAXDEPTH/2) + 10
# endif
# endif	/* __RUNTIME_YYMAXDEPTH */
long  yymaxdepth = YYMAXDEPTH;

__YYSCLASS YYSTYPE *yypv;			/* top of value stack */
__YYSCLASS int *yyps;			/* top of state stack */

__YYSCLASS int yystate;			/* current state */
__YYSCLASS int yytmp;			/* extra var (lasts between blocks) */

int yynerrs;			/* number of errors */
__YYSCLASS int yyerrflag;			/* error recovery flag */
int yychar;			/* current input token number */



/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
int
yyparse()
{
	register YYSTYPE *yypvt;	/* top of value stack for $vars */

	/*
	** Initialize externals - yyparse may be called more than once
	*/
# ifdef __RUNTIME_YYMAXDEPTH
	if (allocate_stacks()) YYABORT;
# endif
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

	goto yystack;
	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_ps >= &yys[ yymaxdepth ] )	/* room on stack? */
		{
# ifndef __RUNTIME_YYMAXDEPTH
			yyerror( (nl_msg(30002,"yacc stack overflow")) );
			YYABORT;
# else
			/* save old stack bases to recalculate pointers */
			YYSTYPE * yyv_old = yyv;
			int * yys_old = yys;
			yymaxdepth += YYINCREMENT;
			yys = (int *) realloc(yys, yymaxdepth * sizeof(int));
			yyv = (YYSTYPE *) realloc(yyv, yymaxdepth * sizeof(YYSTYPE));
			if (yys==0 || yyv==0) {
			    yyerror( (nl_msg(30002,"yacc stack overflow")) );
			    YYABORT;
			    }
			/* Reset pointers into stack */
			yy_ps = (yy_ps - yys_old) + yys;
			yyps = (yyps - yys_old) + yys;
			yy_pv = (yy_pv - yyv_old) + yyv;
			yypv = (yypv - yyv_old) + yyv;
# endif

		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif
		if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
			yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			printf( "Received token " );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
#if YYDEBUG
			yytmp = yychar < 0;
#endif
			if ( ( yychar < 0 ) && ( ( yychar = yylex() ) < 0 ) )
				yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				printf( "Received token " );
				if ( yychar == 0 )
					printf( "end-of-file\n" );
				else if ( yychar < 0 )
					printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				errorline = yynline;
				yynerrs++;
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
				yynerrs++;
			skip_init:
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					printf( "Error recovery discards " );
					if ( yychar == 0 )
						printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( yytmp )
	{
		
case 5:{
               uebergabe[0] = '\0';
	       ueIdx = 0;
	     } break;
case 6:{
               uebergabe[0] = '\0';
	       ueIdx = 0;
	     } break;
case 7:{
               uebergabe[0] = '\0';
	       ueIdx = 0;
	     } break;
case 33:{StackToString(key, &errkey);
	       FreeStack(&key);
	       if ((errkey!=NULL) && (errkey[0]!='\0')){
		 sprintf(errstr, "\t%15s:\t%10d\t%10d\n", 
				 errkey, errorline-keyline, errorline-1);
                 XtFree(errkey);
		 errkey = NULL;
		 }
               else
		 sprintf(errstr, "\t%15s:\t%10d\t%10d\n", "key unknown", 
				     errorline-keyline, errorline-1);
               SecStrcat(MAX_ERRORSTRLEN, errorstr, errstr);
	       } break;
case 34:{         
		keyline = yynline;
                beginIdx = SkipApe(uebergabe);
                fprintf(tempDatei,"@%s\n",&uebergabe[beginIdx]); 
                ueIdx = 0;
              } break;
case 35:{          
		keyline = yynline;
                beginIdx = SkipApe(uebergabe);
                fprintf(tempDatei,"@%s\n",&uebergabe[beginIdx]); 
                ueIdx = 0;
              } break;
case 36:{         
		keyline = yynline;
                beginIdx = SkipApe(uebergabe);
                fprintf(tempDatei,"@%s\n",&uebergabe[beginIdx]); 
                ueIdx = 0;
              } break;
case 37:{         
		keyline = yynline;
                beginIdx = SkipApe(uebergabe);
                fprintf(tempDatei,"@%s\n",&uebergabe[beginIdx]); 
                ueIdx = 0;
              } break;
case 38:{         
		keyline = yynline;
                beginIdx = SkipApe(uebergabe);
                fprintf(tempDatei,"@%s\n",&uebergabe[beginIdx]); 
                ueIdx = 0;
              } break;
case 39:{          
		keyline = yynline;
                beginIdx = SkipApe(uebergabe);
                fprintf(tempDatei,"@%s\n",&uebergabe[beginIdx]); 
                ueIdx = 0;
              } break;
case 40:{         
		keyline = yynline;
                beginIdx = SkipApe(uebergabe);
                fprintf(tempDatei,"@%s\n",&uebergabe[beginIdx]); 
                ueIdx = 0;
              } break;
case 41:{         
		keyline = yynline;
                beginIdx = SkipApe(uebergabe);
                fprintf(tempDatei,"@%s\n",&uebergabe[beginIdx]); 
                ueIdx = 0;
              } break;
case 42:{         
		keyline = yynline;
                beginIdx = SkipApe(uebergabe);
                fprintf(tempDatei,"@%s\n",&uebergabe[beginIdx]); 
                ueIdx = 0;
              } break;
case 43:{         
		keyline = yynline;
                beginIdx = SkipApe(uebergabe);
                fprintf(tempDatei,"@%s\n",&uebergabe[beginIdx]); 
                ueIdx = 0;
              } break;
case 44:{         
		keyline = yynline;
                beginIdx = SkipApe(uebergabe);
                fprintf(tempDatei,"@%s\n",&uebergabe[beginIdx]); 
                ueIdx = 0;
              } break;
case 45:{         
		keyline = yynline;
                beginIdx = SkipApe(uebergabe);
                fprintf(tempDatei,"@%s\n",&uebergabe[beginIdx]); 
                ueIdx = 0;
              } break;
case 117:{                 
                  GetKey();
                } break;
case 118:{
                  GetKey();
                } break;
case 119:{
                  GetKey();
                } break;
case 120:{
                  GetKey();
                } break;
case 121:{
                  GetKey();
                } break;
case 122:{
                  GetKey();
                } break;
case 123:{
                  GetKey();
                } break;
case 124:{
                  GetKey();
                } break;
case 125:{
		  err = dbtMakeCard(&card);
		  beginIdx = SkipApe(uebergabe);
		  card->cardtype = cardtype = 
		     glbNameToType(strlower(&uebergabe[beginIdx])); 
		  if (cardtype == -1)
		     card->cardtype = cardtype = MAX_BIBTEX_TYPES;
		  Scalloc(&card->cardtypestr, &uebergabe[beginIdx]);
		  ueIdx = 0;
                } break;
case 130:{
                  PushSign(&key, yypvt[-1]);
		  keyline = yynline;
                } break;
case 131:{
                  PushSign(&key, yypvt[-1]);
		  keyline = yynline;
                } break;
case 132:{
                  PushSign(&key, yypvt[-1]);
		  keyline = yynline;
                } break;
case 133:{
                  PushSign(&key, yypvt[-1]);
		  keyline = yynline;
                } break;
case 134:{
                  PushSign(&key, yypvt[-1]);
		  keyline = yynline;
                } break;
case 135:{
                  PushSign(&key, yypvt[-1]);
		  keyline = yynline;
                } break;
case 136:{
                  PushSign(&key, yypvt[-0]);
		  keyline = yynline;
                } break;
case 137:{
                  PushSign(&key, yypvt[-0]);
		  keyline = yynline;
                } break;
case 138:{
                  PushSign(&key, yypvt[-0]);
		  keyline = yynline;
                } break;
case 139:{
                  PushSign(&key, yypvt[-0]);
		  keyline = yynline;
                } break;
case 140:{
                  PushSign(&key, yypvt[-0]);
		  keyline = yynline;
                } break;
case 141:{
                  PushSign(&key, yypvt[-0]);
		  keyline = yynline;
                } break;
case 151:{
		  ueIdx = 0;
                } break;
case 152:{
                  GetFldNameCont();
                } break;
case 153:{
		  ueIdx = 0;
                } break;
case 154:{
                  GetFldNameCont();
                } break;
case 155:{
                  PushSign(&fldname, yypvt[-1]);
                  ueIdx = 0;
                } break;
case 156:{
                  PushSign(&fldname, yypvt[-1]);
                  ueIdx = 0;
                } break;
case 157:{
                  PushSign(&fldname, yypvt[-0]);
                  ueIdx = 0;
                } break;
case 158:{
                  PushSign(&fldname, yypvt[-0]);
                  ueIdx = 0;
                } break;
	}
	goto yystack;		/* reset registers in driver code */
}

# ifdef __RUNTIME_YYMAXDEPTH

static int allocate_stacks() {
	/* allocate the yys and yyv stacks */
	yys = (int *) malloc(yymaxdepth * sizeof(int));
	yyv = (YYSTYPE *) malloc(yymaxdepth * sizeof(YYSTYPE));

	if (yys==0 || yyv==0) {
	   yyerror( (nl_msg(30004,"unable to allocate space for yacc stacks")) );
	   return(1);
	   }
	else return(0);

}


static void free_stacks() {
	if (yys!=0) free((char *) yys);
	if (yyv!=0) free((char *) yyv);
}

# endif  /* defined(__RUNTIME_YYMAXDEPTH) */

