/*
** Datei: DVIPKCH.C (Version DVI)
** Autor: Ingo Eichenseher
*/

#include <stdio.h>
#include <stdarg.h>
#include "dvi.h"
#include "dviframe.h"
#include "dvidvi.h"

static int repeat_count;
static int q;
static byte *p;

#define get_pk_nyb(p,q) ( ((q)=!(q))==0 ? *(p)++&15 : *(p)>>4)

static int pk_pnum(int dyn_f)
{
    int i;
    if ( (i=get_pk_nyb(p,q))==0 )
    {
	int j; i++;
	while ( (j=get_pk_nyb(p,q))==0 ) i++;
	while ( i-- ) j = (j<<4)+get_pk_nyb(p,q);
	return j-15+((13-dyn_f)<<4)+dyn_f;
    }
    if (i<=dyn_f) return i;
    if (i<14) return ((i-dyn_f-1)<<4) + get_pk_nyb(p,q) + dyn_f +1;
    if (i==14) repeat_count=pk_pnum(dyn_f);
    else repeat_count=1;
    return pk_pnum(dyn_f);
}

#ifndef IBMPC
void draw_char(pk_char *c, int x ,int y)
{
    long    da;
    int     db;
    byte    dm;
    int     dyn_f   = c->dyn_f;
    int     state   = !c->state;
    int     h       = (int)c->h;
    int     w       = (int)c->w;
    int     xx;

    x  -= (int)c->hoff;
    y  -= (int)c->voff;
    p  =  (byte far*)(byte huge*)c->data;
    q  =  0;
    db =  x%8<0 ? -(x%8):7-x%8;
    dm =  128 >> (7-db);
    x  =  x<0 ? (x-7)/8 : x/8;
    da =  x+(long)y*frame_width;

    if (w==0 || h==0 || y>=frame_height) return;
    repeat_count=0;

    if (dyn_f==14)
    {
	register byte *pa = c->data;
	register byte  pm = 128;
	register int   pb = 7;
	register int   ww;
	register byte  lm;
	register int   lb;
	register long  la;
	while(h--)
	{
	    la=da; lb=db; lm=dm;
	    for (ww=w,xx=x; ww--;)
	    {
		if (pm & *pa)
		    if (y>=0 && xx>=0 && xx<frame_width)
			frame_or(la,lm);
		if (lb--) lm >>= 1;
		else { lb=7; lm=128; la++; xx++; }
		if (pb--) pm >>= 1;
		else { pb=7; pm=128; pa++; }
	    }
	    da += frame_width;
	    if (++y>=frame_height) break;
	}
    }
    else
    {
	register int    r=0;
	int    rep_mode=0;

	while(h>0)
	{
	    register byte  lm;
	    register long  la;
	    register int   lb,ww;
	    register byte *rp;
	    register int   rq,rstate,rr;

	    la=da; lb=db; lm=dm;
	    rp=p; rq=q; rstate=state; rr=r;
	    for(ww=w,xx=x; ww--;)
	    {
		if (r==0) { state=!state; r=pk_pnum(dyn_f); }
		r--;
		if (state)
		    if (y>=0 && xx>=0 && xx<frame_width)
			frame_or(la,lm);
		if (lb--) lm>>=1;
		else { lb=7; lm=128; la++; xx++; }
	    }
	    da += frame_width; h--;
	    if (++y>=frame_height) break;

	    if (rep_mode==0 && repeat_count) rep_mode=repeat_count+1;
	    repeat_count=0;
	    if (rep_mode)
	    {
		if (--rep_mode==0) continue;
		p=rp; q=rq; state=rstate; r=rr;
	    }
	}
    }
}
#endif

void draw_rule(int x, int y, int w, int h)
{
    register int db, dm, ww, xx, lb, lm;
    register long da;
    register long la;

    db =  x%8<0 ? -(x%8):7-x%8;
    dm =  128 >> (7-db);
    x  =  x<0 ? (x-7)/8 : x/8;
    da =  x+(long)y*frame_width;

    if (y>=frame_height) return;
    if (w<=0 || h<=0) return;

    while(h--)
    {
	la=da; lb=db; lm=dm;
	for (ww=w, xx=x; ww--;)
	{
	    if (y>=0 && xx>=0 && xx<frame_width) frame_or(la,lm);
	    if (lb--) lm>>=1;
	    else { lb=7; lm=128; la++; xx++; }
	}
	da += frame_width;
	if (++y>=frame_height) break;
    }
}

void ldraw_char(pk_char *c, int x, int y)
{
    long    da;
    int     db;
    byte    dm;
    int     dyn_f   = c->dyn_f;
    int     state   = !c->state;
    int     h       = (int)c->h;
    int     w       = (int)c->w;

    x  += (int)c->voff;
    y  -= (int)c->hoff;
    p  =  (byte far*)(byte huge*)c->data;
    q  =  0;
    db =  x%8<0 ? -(x%8):7-x%8;
    dm =  128 >> (7-db);
    x  =  x<0 ? (x-7)/8 : x/8;
    da =  x+(long)y*frame_width;

    if (w==0 || h==0 || x<0) return;
    repeat_count=0;

    if (dyn_f==14)
    {
	register byte huge *pa = c->data;
	register byte  pm = 128;
	register int   pb = 7;
	register long  la;

	while(h--)
	{
	    register int ww,yy;
	    la=da; yy=y;
	    for (ww=w; ww--;)
	    {
		if (pm & *pa)
		    if (yy>=0 && yy<frame_height && x<frame_width)
			frame_or(la,dm);
		la += frame_width; yy++;
		if (pb--) pm >>= 1;
		else { pb=7; pm=128; pa++; }
	    }
	    if (++db==8) { db=0; dm=1; da--; x--; if (x<0) break; }
	    else dm<<=1;
	}
    }
    else
    {
	register int r=0; int rep_mode=0;
	while(h>0)
	{
	    register long  la;
	    register int   ww,yy;
	    register byte *rp;
	    register int   rq,rstate,rr;
	    la = da;
	    rp=p; rq=q; rstate=state; rr=r; yy=y;
	    for (ww=w; ww--; )
	    {
		if (r==0) { state=!state; r=pk_pnum(dyn_f); }
		r--;
		if (state)
		    if (yy>=0 && yy<frame_height && x<frame_width)
			frame_or(la,dm);
		la += frame_width; yy++;
	    }
	    if (++db==8) { db=0; dm=1; da--; x--; if (x<0) break; }
	    else dm<<=1;
	    h--;
	    if (rep_mode==0 && repeat_count) rep_mode=repeat_count+1;
	    repeat_count=0;
	    if (rep_mode)
	    {
		if (--rep_mode==0) continue;
		p=rp; q=rq; state=rstate; r=rr;
	    }
	}
    }
}
