{$A+,B-,D-,E-,F-,G-,I+,L-,N-,O-,R-,S-,V+,X-}
{$M 10000,0,655360}
{ Turbo Pascal 6.0 }
{ A+,B-,D-,E-,F-,I+,L-,N-,O-,R-,S-,V+}
{ Turbo Pascal 5.5 }

program Selektie;

(*
Displays a list from which one item can be selected.
The list is based on a file specification.
List items can include several file specific fields in a specified format.
The output can be one or more of the file specific field in another
specified format. Output can be redirected or piped.
Both mouse and keyboard interfacing are supported.

Erik Frambach
*)

uses
  OPCRT,        { Object Professional }
  DOS,
  OPSTRING,
  OPMOUSE;

const
  gc_Versie        = '1.13 <11-nov-93>';
  gc_Esc           = #27;
  gc_Enter         = #13;
  gc_UArr          = #1;
  gc_DArr          = #2;
  gc_PgUp          = #3;
  gc_PgDn          = #4;
  gc_Home          = #5;
  gc_End           = #6;
  gc_BackSpace     = #8;
  gc_MaxLijst      = 1000;
  gc_Sep           = '/';
  gc_RecursChar    = '#';
  gs_Kopkleur      : byte      = 127; { wit op grijs }
  gs_Balkkleur     : byte      = 112; { zwart op grijs }
  gs_Tekstkleur    : byte      = 7;   { grijs op zwart }
  gs_DescrFileOpen : boolean   = false;
  gs_FileBestaat   : boolean   = true;

type
  gt_Inhoud        = string [60];
  gt_Bestand       = record
                       _Naam   : string [13];  { \maximaal.dir }
                       _Ext    : string [3];
                       _Tijd   : longint;
                       _Size   : longint;
                       _Inhoud : gt_Inhoud
                     end;
  gt_String20      = string [20];
  gt_Filenaam      = string [12];
  gt_PadStr        = string [50];

var
  gv_Lijst         : array [1..gc_MaxLijst] of ^gt_Bestand;
  gv_FileSpec      : string;
  gv_Sortering     : string [1];
  gv_Aantal        : word;
  gv_Toets         : char;
  gv_Keuze         : word;
  gv_OudAttr       : byte;
  gv_DescrFile     : text;
  gv_Recursie      : boolean;


{$F+}
function gf_HeapFunc (pc_Size : word) : integer;
begin
gf_HeapFunc := 1
end;
{$F-}


procedure VerwijderBB (var pv_String : string);
var
  i : word;
begin
repeat
  i := Pos ('\\', pv_String);
  if i > 0 then
    Delete (pv_String, i, 1)
until i = 0
end;


procedure LeesParameters;
var
  i          : word;
  lv_Kleuren : string [11];
  lv_Test    : byte;
  lv_Ctrl    : integer;
begin
if ParamCount < 2 then
  begin
  WriteLn ('SELEKTIE versie ', gc_Versie);
  WriteLn ('syntaxis: SELEKTIE <filespec> <display> [return] [sortcrit]');
  WriteLn ('   filespec is pad + bestandspecs[/bestandspecs[...]]');
  WriteLn ('     bv. c:\texfiles\*.tex');
  WriteLn ('     of  c:\texfiles\*.pas/*.tpu/*.exe');
  WriteLn ('     of #c:\texfiles\*.tex, wandelen door directories');
  WriteLn ('     of $ENVPAR, waarbij ENVPAR een env.parameter is');
  WriteLn ('   gebruik in display en return:');
  WriteLn ('     n=naam, N=NAAM, e=extensie, E=EXTENSIE,');
  WriteLn ('     d=datum, t=tijd, s=size,');
  WriteLn ('     (i=eerste regel of :=idem zonder eerste karakter of !=4DOSdescription),');
  WriteLn ('     _=spatie, .=punt');
  WriteLn ('   gebruik in sortcrit:');
  WriteLn ('     oplopend: N=naam, E=extensie, T=datum+tijd, S=size');
  WriteLn ('     aflopend: n=naam, e=extensie, t=datum+tijd, s=size');
  WriteLn ('     -=niet sorteren');
  WriteLn ('kleurinstelling: environmentparameter SEL_COLOR, een string van');
  WriteLn ('   3 * 3 karakters: kleurattributen voor resp. kopregel, balk');
  WriteLn ('   en tekst. Voorbeeld: 120090008 of (hexadecimaal) $78$5A$08');
  WriteLn ('   Defaultkleuren: ', gs_Kopkleur, ', ', gs_Balkkleur, ', ',
           gs_Tekstkleur);
  Halt (1)
  end;
gv_FileSpec := ParamStr (1);
if gv_FileSpec [1] = '$' then
  gv_FileSpec := GetEnv (Copy (gv_FileSpec, 2, 255));
if gv_FileSpec [1] = gc_RecursChar then
  begin
  gv_FileSpec := Copy (gv_FileSpec, 2, 255);
  gv_Recursie := true
  end
else
  gv_Recursie := false;
VerwijderBB (gv_FileSpec);
gv_Aantal := 0;
gv_Sortering := ParamStr (4);
if gv_Sortering = '' then
  gv_Sortering := '-';
gv_OudAttr := TextAttr;
lv_Kleuren := GetEnv ('SEL_COLOR');
if lv_Kleuren <> '' then
  begin
  Val (Copy (lv_Kleuren, 1, 3), lv_Test, lv_Ctrl);
  if lv_Ctrl = 0 then
    gs_Kopkleur := lv_Test;
  Val (Copy (lv_Kleuren, 4, 3), lv_Test, lv_Ctrl);
  if lv_Ctrl = 0 then
    gs_Balkkleur := lv_Test;
  Val (Copy (lv_Kleuren, 7, 3), lv_Test, lv_Ctrl);
  if lv_Ctrl = 0 then
    gs_Tekstkleur := lv_Test
  end
end;


function gf_LowCaseStr (pc_String : string) : string;
var
  lv_String : string;
  i         : word;
begin
lv_String := pc_String;
for i := 1 to Length (lv_String) do
  if lv_String [i] in ['A'..'Z'] then
    Inc (lv_String [i], 32);
gf_LowCaseStr := lv_String
end;


function gf_UpCaseStr (pc_String : string) : string;
var
  i         : word;
  lv_String : string;
begin
lv_String := pc_String;
for i := 1 to Length (lv_String) do
  lv_String [i] := UpCase (lv_String [i]);
gf_UpCaseStr := lv_String
end;


function gf_PlaatsGevonden (pc_Plaats  : word;
                            pc_FileRec : SearchRec) : boolean;
var
  lv_Naam : string [8];
begin
if pc_FileRec.Attr = Directory then
  begin
  lv_Naam := gv_Lijst [pc_Plaats]^._Naam;
  if lv_Naam [1] = '\' then
    begin
    lv_Naam [1] := #0;
    gf_Plaatsgevonden := lv_Naam > #0 + pc_FileRec.Name
    end
  else
    gf_PlaatsGevonden := true
  end
else
  case UpCase (gv_Sortering [1]) of
  'N' :
    begin
    lv_Naam := JustFilename (pc_FileRec.Name);
    if Pos ('.', lv_Naam) > 0 then
      lv_Naam [0] := Chr (Pos ('.', lv_Naam) - 1);
    if gv_Sortering [1] = 'n' then
      gf_PlaatsGevonden :=
        gv_Lijst [pc_Plaats]^._Naam < lv_Naam
    else
      gf_PlaatsGevonden :=
        gv_Lijst [pc_Plaats]^._Naam > lv_Naam
    end;
  'E' :
    if gv_Sortering [1] = 'e' then
      gf_PlaatsGevonden :=
        gv_Lijst [pc_Plaats]^._Ext < JustExtension (pc_FileRec.Name)
    else
      gf_PlaatsGevonden :=
        gv_Lijst [pc_Plaats]^._Ext > JustExtension (pc_FileRec.Name);
  'D', 'T' :
    if gv_Sortering [1] in ['d', 't'] then
      gf_PlaatsGevonden :=
        gv_Lijst [pc_Plaats]^._Tijd < pc_FileRec.Time
    else
      gf_PlaatsGevonden :=
        gv_Lijst [pc_Plaats]^._Tijd > pc_FileRec.Time;
  'S' :
    if gv_Sortering [1] = 's' then
      gf_PlaatsGevonden :=
        gv_Lijst [pc_Plaats]^._Size < pc_FileRec.Size
    else
      gf_PlaatsGevonden :=
        gv_Lijst [pc_Plaats]^._Size > pc_FileRec.Size;
  else
    gf_PlaatsGevonden := false
  end
end;


procedure Lees4DosDescription (    pc_Pad      : gt_PadStr;
                                   pc_Filenaam : gt_Filenaam;
                               var pv_Inhoud   : gt_Inhoud);
var
  lv_Regel       : string;
  lv_Gevonden    : boolean;
begin
pv_Inhoud := '';
if gs_FileBestaat then
  begin
  if not gs_DescrFileOpen then
    Assign (gv_DescrFile, pc_Pad + 'descript.ion');
  {$I-}
  Reset (gv_DescrFile);
  if IOresult <> 0 then
    gs_FileBestaat := false
  else
    begin
    gs_DescrFileOpen := true;
    if pc_Filenaam [Length (pc_Filenaam)] = '.' then
      Dec (pc_Filenaam [0]);
    pc_Filenaam := gf_LowCaseStr (pc_Filenaam);
    lv_Regel := '';
    lv_Gevonden := false;
    while (not Eof (gv_DescrFile)) and (IOresult = 0) and (not lv_Gevonden) do
      begin
      ReadLn (gv_DescrFile, lv_Regel);
      lv_Gevonden := Copy (lv_Regel, 1, Length (pc_Filenaam)) = pc_Filenaam;
      if lv_Gevonden then
        begin
        lv_Regel := Copy (lv_Regel, Length (pc_Filenaam) + 2, 255);
        if Pos (^D, lv_Regel) > 0 then
          lv_Regel := Copy (lv_Regel, 1, Pos (^D, lv_Regel) - 1)
        end
      end;
    if lv_Gevonden then
      pv_Inhoud := lv_Regel
    end
  {$I+}
  end
end;


function gf_IsDirectory (pc_FileRec : SearchRec) : boolean;
begin
gf_IsDirectory := pc_FileRec.Attr and Directory <> 0
end;


function gf_IsLabel (pc_FileRec : SearchRec) : boolean;
begin
gf_IsLabel := pc_FileRec.Attr and VolumeId <> 0
end;


function gf_MaakPad : string;
var
  lv_Pad : string;
begin
lv_Pad := JustPathname (gv_FileSpec);
if (lv_Pad <> '') and (lv_Pad [Length (lv_Pad)] <> '\') then
  lv_Pad := lv_Pad + '\';
gf_MaakPad := lv_Pad
end;


procedure VulLijst (pc_FileRec : SearchRec);
var
  i          : word;
  lv_Plaats  : word;
  lv_Bewaar  : pointer;
  lv_Bestand : text;
  lv_Pad     : gt_PadStr;
begin
lv_Pad := gf_MaakPad;
if gv_Aantal = 1 then
  lv_Plaats := 1
else
  begin
  lv_Plaats := 0;
  repeat
    Inc (lv_Plaats)
  until (lv_Plaats = gv_Aantal) or
        (gf_PlaatsGevonden (lv_Plaats, pc_FileRec));
  lv_Bewaar := gv_Lijst [gv_Aantal];
  for i := gv_Aantal - 1 downto lv_Plaats do
    gv_Lijst [i + 1] := gv_Lijst [i];
  gv_Lijst [lv_Plaats] := lv_Bewaar
  end;
with gv_Lijst [lv_Plaats]^, pc_FileRec do
  begin
  if gf_IsDirectory (pc_FileRec) then
    begin
    _Naam := '\' + pc_FileRec.Name;
    _Inhoud := '';
    _Ext := ''
    end
  else
    begin
    _Naam := JustFilename (Name);
    if Pos ('.', _Naam) <> 0 then
    _Naam [0] := Chr (Pos ('.', _Naam) - 1);
    _Ext := JustExtension (Name)
    end;
  _Size := Size;
  _Tijd := Time;
  if not gf_IsDirectory (pc_FileRec) then
    begin
    if (Pos ('i', ParamStr (2) + ParamStr (3)) > 0) or
       (Pos (':', ParamStr (2) + ParamStr (3)) > 0) then
      begin
      FileMode := 0;
      Assign (lv_Bestand, lv_Pad + Name);
      Reset (lv_Bestand);
      ReadLn (lv_Bestand, _Inhoud);
      if Pos (':', ParamStr (2) + ParamStr (3)) > 0 then
        Delete (_Inhoud, 1, 1);
      Close (lv_Bestand)
      end
    else
      if Pos ('!', ParamStr (2) + ParamStr (3)) > 0 then
        Lees4DosDescription (lv_Pad, _Naam + '.' + _Ext, _Inhoud)
      else
        _Inhoud := ''
    end
  end
end;


procedure MaakDeelLijst (    pc_FileSpec : string;
                         var pv_Stop     : boolean;
                             pc_Attr     : word);
var
  lv_FileRec : SearchRec;
begin
VerwijderBB (pc_FileSpec);
FindFirst (pc_FileSpec, pc_Attr, lv_FileRec);
repeat
  if (DosError = 0) and (not gf_IsLabel (lv_FileRec)) then
    begin
    if (not gf_IsDirectory (lv_FileRec) and (pc_Attr <> Directory)) or
       (gf_IsDirectory (lv_FileRec) and (pc_Attr = Directory) and
        (lv_FileRec.name [1] <> '.')) then
      begin
      Inc (gv_Aantal);
      GetMem (gv_Lijst [gv_Aantal], SizeOf (gt_Bestand));
      if gv_Lijst [gv_Aantal] <> nil then
        VulLijst (lv_FileRec)
      else
        Dec (gv_Aantal)
      end
    end;
  FindNext (lv_FileRec);
  pv_Stop := ((gv_Aantal > 0) and (gv_Lijst [gv_Aantal] = nil)) or
             (gv_Aantal = gc_MaxLijst)
until (pv_Stop) or (DosError <> 0)
end;


procedure VoegtoeDirUp;
var
  i         : word;
  lv_Bewaar : pointer;
begin
if Length (JustPathname (gv_FileSpec)) > 3 then
  begin
  Inc (gv_Aantal);
  GetMem (gv_Lijst [gv_Aantal], SizeOf (gt_Bestand));
  if gv_Lijst [gv_Aantal] = nil then
    Dec (gv_Aantal)
  else
    begin
    lv_Bewaar := gv_Lijst [gv_Aantal];
    for i := gv_Aantal - 1 downto 1 do
      gv_Lijst [i + 1] := gv_Lijst [i];
    gv_Lijst [1] := lv_Bewaar;
    with gv_Lijst [1]^ do
      begin
      _Naam := '\..';
      _Inhoud := '';
      _Size := 0;
      _Tijd := 0;
      _Ext := ''
      end
    end
  end
end;


procedure MaakLijstLeeg;
var
  i : word;
begin
TextAttr := gs_Tekstkleur;
ClrScr;
FastWrite ('please wait...', 1,20, gs_Tekstkleur);
for i := 1 to gv_Aantal do
  FreeMem (gv_Lijst [i], SizeOf (gt_Bestand));
gv_Aantal := 0
end;


procedure MaakLijst;
var
  lv_Pos      : word;
  lv_Pad,
  lv_DeelSpec : string;
  lv_Stop     : boolean;
begin
lv_Pos := Pos (gc_Sep, gv_FileSpec);
if lv_Pos = 0 then
  MaakDeelLijst (gv_FileSpec, lv_Stop, AnyFile)
else
  begin
  lv_Pad := gf_MaakPad;
  lv_DeelSpec := Copy (gv_FileSpec, Length (lv_Pad) + 1, 255);
  repeat
    lv_Pos := Pos (gc_Sep, lv_DeelSpec);
    if lv_Pos = 0 then
      lv_Pos := 99;
    MaakDeelLijst (lv_Pad + Copy (lv_DeelSpec, 1, lv_Pos - 1), lv_Stop,
                   AnyFile);
    lv_DeelSpec := Copy (lv_DeelSpec, lv_Pos + 1, 255)
  until (lv_Stop) or (lv_DeelSpec = '')
  end;
{$I-}
if gs_DescrFileOpen then
  Close (gv_DescrFile);
if IOresult = 0 then ;
{$I+}
if gv_Recursie then
  begin
  lv_Stop := false;
  MaakDeelLijst (JustPathName (gv_FileSpec) + '\*.*', lv_Stop, Directory);
  VoegtoeDirUp
  end;
if gv_Aantal = 0 then
  begin
  WriteLn ('no files found');
  Halt (2)
  end;
end;


function gf_Str (pc_Getal : longint) : string;
var
  lv_String : string;
begin
Str (pc_Getal, lv_String);
gf_Str := lv_String
end;


function gf_Regel (pc_Index  : word;
                   pc_Params : string;
                   pc_Scherm : boolean) : string;
var
  lv_Regel    : string [80];
  lv_DateTime : DateTime;
  i, j        : word;
const
  lc_Maand    : array [1..12] of string [3] =
                ('jan', 'feb', 'mar', 'apr', 'may', 'jun',
                 'jul', 'aug', 'sep', 'oct', 'nov', 'dec');
begin
lv_Regel := '';
with gv_Lijst [pc_Index]^ do
  for i := 1 to Length (pc_Params) do
    case pc_Params [i] of
    '_' :
      if pc_Scherm or (lv_Regel <> '') then
        lv_Regel := lv_Regel + ' ';
    'n' :
      if pc_Scherm then
        lv_Regel := lv_Regel + Pad (gf_LowCaseStr (_Naam), 8)
      else
        lv_Regel := lv_Regel + gf_LowCaseStr (_Naam);
    'N' :
      if pc_Scherm then
        lv_Regel := lv_Regel + Pad (_Naam, 8)
      else
        lv_Regel := lv_Regel + _Naam;
    '.' :
      if Pos ('\', lv_Regel) = 0 then
        lv_Regel := lv_Regel + '.';
    'e' :
      if pc_Scherm then
        lv_Regel := lv_Regel + Pad (gf_LowCaseStr (_Ext), 3)
      else
        lv_Regel := lv_Regel + gf_LowCaseStr (_Ext);
    'E' :
      if pc_Scherm then
        lv_Regel := lv_Regel + Pad (_Ext, 3)
      else
        lv_Regel := lv_Regel + _Ext;
    's' :
      if Pos ('\', lv_Regel) = 0 then
        lv_Regel := lv_Regel + LeftPad (gf_Str (_Size), 8);
    'd' :
      if Pos ('\', lv_Regel) = 0 then
        begin
        UnpackTime (_Tijd, lv_DateTime);
        lv_Regel := lv_Regel + LeftPad (gf_Str (lv_DateTime.Day), 3) + '-' +
                               lc_Maand [lv_DateTime.Month] + '-' +
                               gf_Str (lv_DateTime.Year)
        end;
    't' :
      if Pos ('\', lv_Regel) = 0 then
        begin
        UnpackTime (_Tijd, lv_DateTime);
        lv_Regel := lv_Regel + LeftPad (gf_Str (lv_DateTime.Hour), 3) + ':' +
                               LeftPadCh (gf_Str (lv_DateTime.Min), '0', 2);
        end;
    'i', '!', ':' :
      lv_Regel := lv_Regel + _Inhoud
    end; { case }
gf_Regel := lv_Regel
end;


procedure MaakSchoon;
begin
Window (1,3, 80,ScreenHeight);
ClrScr;
Window (1,1, 80,ScreenHeight)
end;


procedure ToonPagina (pc_Start : word);
var
  i,
  lv_Regel  : word;
begin
lv_Regel := 2;
for i := pc_Start to pc_Start + ScreenHeight - 3 do
  if i <= gv_Aantal then
    begin
    Inc (lv_Regel);
    FastWrite (Pad (gf_Regel (i, ParamStr (2), true), 80), lv_Regel,
               1, gs_Tekstkleur)
    end
end;


procedure Inverteer (pc_Oud,
                     pc_Nieuw : word);
begin
if pc_Oud <> 0 then
  ChangeAttribute (80, pc_Oud, 1, gs_Tekstkleur);
if pc_Nieuw <> 0 then
  ChangeAttribute (80, pc_Nieuw, 1, gs_Balkkleur)
end;


function gf_LetterPast (    pc_Woord : string;
                            pc_Start : word;
                        var pv_Keuze : word) : boolean;
var
  lv_Regel    : string [80];
  lv_Gevonden : boolean;
begin
lv_Gevonden := false;
lv_Regel := gf_Regel (gv_Keuze + pc_Start - 3, ParamStr (2), true);
if pc_Woord = gf_UpCaseStr (Copy (lv_Regel, 1, Length (pc_Woord))) then
  begin
  lv_Gevonden := true;
  pv_Keuze := gv_Keuze + pc_Start - 3
  end
else
  begin
  pv_Keuze := 1;
  repeat
    lv_Regel := gf_Regel (pv_Keuze, ParamStr (2), true);
    if pc_Woord = gf_UpCaseStr (Copy (lv_Regel, 1, Length (pc_Woord))) then
      lv_Gevonden := true
    else
      Inc (pv_Keuze)
  until (lv_Gevonden) or (pv_Keuze > gv_Aantal)
  end;
if not lv_Gevonden then
  begin
  Sound (200);
  Delay (20);
  NoSound
  end;
gf_LetterPast := lv_Gevonden
end;


procedure VerwerkToets (var pv_Start : word;
                        var pv_Woord : gt_String20;
                        var pv_Keuze : word);
begin
case gv_Toets of
gc_DArr :
  if gv_Keuze < ScreenHeight then
    begin
    if gv_Keuze + pv_Start - 3 < gv_Aantal then
      begin
      Inverteer (gv_Keuze, gv_Keuze + 1);
      Inc (gv_Keuze)
      end
    end
  else
    if (gv_Aantal > ScreenHeight - 2) and (pv_Start + ScreenHeight - 2 <= gv_Aantal) then
      begin
      Inc (pv_Start);
      ToonPagina (pv_Start);
      Inverteer (0, gv_Keuze)
      end;
gc_UArr :
  if gv_Keuze > 3 then
    begin
    Inverteer (gv_Keuze, gv_Keuze - 1);
    Dec (gv_Keuze);
    end
  else
    if pv_Start > 1 then
      begin
      Dec (pv_Start);
      ToonPagina (pv_Start);
      Inverteer (0, gv_Keuze)
      end;
gc_Home :
  begin
  Inverteer (gv_Keuze, 0);
  pv_Start := 1;
  gv_Keuze := 3;
  ToonPagina (pv_Start);
  Inverteer (0, gv_Keuze)
  end;
gc_End :
  begin
  pv_Start := gv_Aantal;
  gv_Keuze := 3;
  MaakSchoon;
  ToonPagina (pv_Start);
  Inverteer (0, gv_Keuze)
  end;
gc_PgUp :
  if pv_Start > 1 then
    begin
    if pv_Start > ScreenHeight - 2 then
      Dec (pv_Start, ScreenHeight - 2)
    else
      pv_Start := 1;
    gv_Keuze := 3;
    MaakSchoon;
    ToonPagina (pv_Start);
    Inverteer (0, gv_Keuze)
    end;
gc_PgDn :
  if pv_Start + ScreenHeight - 2 <= gv_Aantal then
    begin
    Inc (pv_Start, ScreenHeight - 2);
    gv_Keuze := 3;
    MaakSchoon;
    ToonPagina (pv_Start);
    Inverteer (0, gv_Keuze)
    end;
#32..#126 :
  if gf_LetterPast (pv_Woord + UpCase (gv_Toets), pv_Start, pv_Keuze) then
    begin
    pv_Woord := pv_Woord + UpCase (gv_Toets);
    FastWrite (Pad (pv_Woord, 20), 1,60, gs_Kopkleur);
    if pv_Keuze + 2 <> gv_Keuze then
      begin
      if (pv_Keuze - pv_Start + 3 > ScreenHeight) or
         (pv_Keuze < pv_Start) then
        begin
        MaakSchoon;
        pv_Start := pv_Keuze;
        ToonPagina (pv_Start);
        gv_Keuze := 3;
        Inverteer (0, gv_Keuze)
        end
      else
        begin
        Inverteer (gv_Keuze, pv_Keuze - pv_Start + 3);
        gv_Keuze := pv_Keuze - pv_Start + 3
        end
      end
    end;
gc_BackSpace :
  if pv_Woord > '' then
    begin
    Dec (pv_Woord [0]);
    FastWrite (Pad (pv_Woord, 20), 1,60, gs_Kopkleur)
    end
end; { case }
if gv_Toets in [gc_UArr..gc_End] then
  begin
  pv_Woord := '';
  FastWrite (Pad ('', 20), 1,60, gs_Kopkleur)
  end
end;


procedure ToonLijst;
var
  lv_Start  : word;
  lv_Toets  : word;
  lv_Kar    : char absolute lv_Toets;
  lv_Woord  : gt_String20;
  lv_Keuze  : word;
  lv_Status : ButtonStatus;
  lv_Teller : word;
  x, y      : byte;
begin
lv_Woord := '';
FastWrite (Pad (' select with '#25' '#24'     ' +
                ' choose with ENTER     (' + gf_Str (gv_Aantal) +
                ' items)    '#179, 80), 1,1, gs_Kopkleur);
lv_Start := 1;
gv_Keuze := 3;
ToonPagina (lv_Start);
Inverteer (0, gv_Keuze);
MouseGotoXY (10, 10);
repeat
  x := 10;
  y := 10;
  gv_Toets := #255;
  repeat
    MouseWhereXY (x, y, lv_Status)
  until (lv_Status <> NoButton) or (y <> 10) or (KeyPressed);
  if KeyPressed then
    begin
    lv_Toets := ReadKeyWord;
    while KeyPressed do
      if ReadKey = 'x' then { flush } ;
    if lv_Kar <> #0 then
      gv_Toets := lv_Kar
    else
      begin
      lv_Kar := Chr (Hi (lv_Toets));
      case lv_Kar of
      #71 :
        lv_Kar := gc_Home;
      #72, #75 :
        lv_Kar := gc_UArr;
      #73 :
        lv_Kar := gc_PgUp;
      #79 :
        lv_Kar := gc_End;
      #80, #77 :
        lv_Kar := gc_DArr;
      #81 :
        lv_Kar := gc_PgDn;
      else
        lv_Kar := #0; { unusable }
      end;
      gv_Toets := lv_Kar
      end
    end
  else if y <> 10 then
    begin
    if y > 10 then
      gv_Toets := gc_DArr
    else if y < 10 then
      gv_Toets := gc_UArr;
    MouseGotoXY (10, 10)
    end
  else if MouseButtonReleased (LeftButton, lv_Teller, x, y) then
    gv_Toets := gc_Enter
  else if MouseButtonReleased (RightButton, lv_Teller, x, y) then
    gv_Toets := gc_Esc;
  VerwerkToets (lv_Start, lv_Woord, lv_Keuze)
until gv_Toets in [gc_Enter, gc_Esc];
gv_Keuze := gv_Keuze + lv_Start - 3
end;


function gf_EersteTeken : word;
var
  i           : word;
  lv_Gevonden : boolean;
  lv_Regel    : string [80];
begin
lv_Regel := gf_Regel (gv_Keuze, ParamStr (2), true);
i := 0;
repeat
  Inc (i);
  lv_Gevonden := lv_Regel [i] <> ' '
until (i = Length (lv_Regel)) or (lv_Gevonden);
gf_EersteTeken := i
end;


procedure VerwerkKeuze;
var
  lv_Woord : string [13];
  lv_Pad   : gt_PadStr;
  i        : word;
begin
if gv_Recursie and (gv_Toets = gc_Enter) then
  begin
  lv_Woord := Copy (gf_Regel (gv_Keuze, ParamStr (2), true),
                    gf_EersteTeken, 13);
  while lv_Woord [Length (lv_Woord)] = ' ' do
    Dec (lv_Woord [0]);
  if lv_Woord [1] = '\' then
    begin
    lv_Pad := gf_MaakPad;
    {$I-}
    Close (gv_DescrFile);
    {$I+}
    if IOresult <> 0 then ; { don't care }
    gs_DescrFileOpen := false;
    gs_FileBestaat := true;
    i := Length (lv_Pad);
    gv_Toets := ' ';
    if lv_Woord = '\..' then
      begin
      Dec (lv_Pad [0]);
      while lv_Pad [Length (lv_Pad)] <> '\' do
        Dec (lv_Pad [0]);
      gv_FileSpec := lv_Pad + Copy (gv_FileSpec, i + 1, 255)
      end
    else
      gv_FileSpec := lv_Pad + lv_Woord + '\' + Copy (gv_FileSpec, i + 1, 255);
    VerwijderBB (gv_FileSpec)
    end
  end
end;


procedure ToonKeuze;
begin
TextAttr := gv_OudAttr;
ClrScr;
if gv_Toets = gc_Enter then
  if gv_Recursie then
    WriteLn (JustPathname (gv_FileSpec) + '\' +
             gf_Regel (gv_Keuze, ParamStr (3), false))
  else
    WriteLn (gf_Regel (gv_Keuze, ParamStr (3), false));
NormalCursor
end;


begin
HiddenCursor;
HeapError := @gf_HeapFunc;
Assign (Output, '');
Rewrite (Output);
if MouseInstalled then
  EnableEventHandling;
LeesParameters;
repeat
  MaakLijstLeeg;
  MaakLijst;
  ToonLijst;
  VerwerkKeuze
until gv_Toets in [gc_Enter, gc_Esc];
ToonKeuze
end.
