{$N-,W-,G+,V-,C MOVEABLE DISCARDABLE}

{$DEFINE USENAMEINDEX}

Unit wbibadd;

Interface

Uses
  Wobjects, WinDos, wbibdisp, wbibeden, wbibgui,
  rc_id, WinTypes, WinProcs, strings,
  bibstrg, bibstrm, bibvars, bibfile, bibutil, lfnunit,
  BibReadB, BibReadT, BibReadD, BibReach, bibcache, bibcol64,
  rc_strng, bibflch2, bibtmplt, wbibshow, WHugeMem;

procedure CheckEntryName(DisplayArea: PDisplayArea;
                         Elist1,elist2: PStream; NameIndex: PBigCol; Var ename: string;
                         IgnoreName: string; AskForNew,AskForEdit,IsPlus: Boolean;
                         var SkipDups,QuitIt,AbortIt,EditIt,SkipDupsNow: boolean);
procedure ManualAdd(Entry: EntryRecPtr;
                    var written,changed: boolean;
                    Elist,TEList,TempEntries: PStream; NameIndex: PBigCol;
                    var nadded: word; var LastEntryName: string;
                    SMode: ConfigSortPtr; SortPattern: PatRecPtr;
                    MakeList: boolean );
procedure ImportEnt(Entry: EntryRecPtr; Pattern: PatRecPtr;
                    var ImpFile: string; var written,changed,UnixImp: boolean;
                    Elist,TEList,TempEntries: PStream; NameIndex: PBigCol;
                    var nadded: word; var LastEntryName: string;
                    var FirstEntry: longint;
                    SMode: ConfigSortPtr; SortPattern: PatRecPtr;
                    MakeList: boolean);


implementation

type

  PWord = ^Word;

  ControlRec = record
    Name: CapStrType;
    id,X,Y,W,H: integer;
  end;

  PEntryExistsDlg = ^TEntryExistsDlg;
  TEntryExistsDlg = object(TBasicDialog)
    EBox:       PEditNoCr;
    Ename:      PString;
    Prompt,Heading: PString;
    Controls:   array[1..9] of ControlRec;
    NControls:  integer;
    IsPlus,SkipDups: boolean;
    constructor init(AParent: PWindowsObject; AName: PChar; AEname: Pstring;
                APrompt,AHeading: string; AIsPlus,AskForEdit,ASkipDups: boolean);
    procedure   SetupWindow; virtual;
    procedure   ok(var Msg: TMessage);       virtual id_first+id_ok;
    procedure   Cancel(var Msg: TMessage);   virtual id_first+id_cancel;
    procedure   Auto(var Msg: TMessage);     virtual id_first+dl_EntryExistsAuto;
    procedure   SkipDup(var Msg: TMessage);  virtual id_first+dl_EntExistsSkipDup;
    procedure   AbortBtn(var Msg: TMessage); virtual id_first+id_Abort;
    procedure   QuitBtn(var Msg: TMessage);  virtual id_first+dl_EntExistsQuit;
    procedure   EditBtn(var Msg: TMessage);  virtual id_first+dl_EntExistsEdit;
  end;

  PAddEnWindow = ^TAddEnWindow;
  TAddEnWindow = object(TEdEnWindow)
    written: PBoolean;
    Elist,TElist,TempEntries: PStream;
    NameIndex: PBigCol;
    nadded: Pword;
    LastEntryName: PString;
    SMode: ConfigSortPtr;
    SortPattern: PatRecPtr;
    MakeList,IsPlus,SkipDups: boolean;

    constructor  Init(AParent: PWindowsObject; AEntry: EntryRecPtr;
                      Awritten: Pboolean;
                      AElist,ATEList,ATempEntries: PStream;
                      ANameIndex: PBigCol;
                      Anadded: Pword; ALastEntryName: Pstring;
                      ASMode: ConfigSortPtr; ASortPattern: PatRecPtr;
                      AMakeList: boolean);
    procedure    SetupWindow; virtual;
    procedure    SetupMenu;   virtual;
    function     SaveEntry: integer;
    procedure    Save(var Msg: TMessage);   virtual cm_first+mi_EdSave;
    procedure    Finish(var Msg: TMessage); virtual cm_first+mi_EdFinish;
    procedure    Quit(var Msg: TMessage);   virtual cm_first+mi_EdQuit;
    procedure    Abort(var Msg: TMessage);  virtual cm_first+mi_EdAbort;
    destructor   Done; virtual;
  end;

  PImportEnWindow = ^TImportEnWindow;
  TImportEnWindow = object(TAddEnWindow)
    NProcessed:  word;
    Strm: PStream;
    constructor  Init(AParent: PWindowsObject; AEntry: EntryRecPtr;
                      AStrm: PStream; Awritten: Pboolean;
                      AElist,ATEList,ATempEntries: PStream;
                      ANameIndex: PBigCol;
                      Anadded: Pword; ALastEntryName: Pstring;
                      ASMode: ConfigSortPtr; ASortPattern: PatRecPtr;
                      AMakeList: boolean);
    procedure    SetupWindow; virtual;
    procedure    SetupMenu;   virtual;
    procedure    GetNextEntry(var o_k: boolean);
    procedure    ProcessEntry;
    procedure    Skip(var Msg: TMessage);   virtual cm_First+mi_EdSkip;
    procedure    Save(var Msg: TMessage);   virtual cm_first+mi_EdSave;
    procedure    Quit(var Msg: TMessage);   virtual cm_first+mi_EdQuit;
  end;


{ TEntryExistsDlg methods }

constructor TEntryExistsDlg.Init(AParent: PwindowsObject; AName: PChar;
            AEname: Pstring; APrompt,AHeading: string; AIsPlus,AskForEdit,
            ASkipDups: boolean);
begin
  TBasicDialog.Init(AParent,AName);
  Ename:=AEname;
  isPlus:=AIsPlus;
  Prompt:=Nil; Heading:=Nil;
  if APrompt<>'' then Prompt:=NewStr(APrompt);
  if AHeading<>'' then Heading:=NewStr(AHeading);
  SkipDups:=ASkipDups and IsPlus;
  New(EBox,InitResource(@Self,dl_EntryExistsEBox,50,NameForbid));
  FillChar(Controls,sizeof(Controls),0);
  NControls:=0;
  if Prompt=Nil then Exit;
  NControls:=5;
  Controls[1].id:=dl_EntryExistsText;
  Controls[2].id:=dl_EntryExistsEbox;
  Controls[3].id:=dl_EntryExistsAuto;
  Controls[4].id:=id_cancel;
  Controls[5].id:=id_ok;
  if IsPlus then
  begin
    NControls:=8;
    Controls[6].id:=dl_EntExistsSkipDup;
    Controls[7].id:=dl_EntExistsQuit;
    Controls[8].id:=id_Abort;
    if AskForEdit then
    begin
      Controls[9].id:=dl_EntExistsEdit; inc(NControls);
    end;
  end;
end;               { TEntryExistsDlg.Init }

procedure TEntryExistsDlg.SetupWindow;
var
  CRect,BRect,WRect: TRect;
  Point: TPoint;
  Spacing,Tlen,WNeed,i: integer;
  F: array[0..255] of char;
begin
  TBasicDialog.SetupWindow;
  StrPCopy(F,Ename^); EBox^.Insert(F); EBox^.SetSelection(0,StrLen(F)-1);

  if Heading<>Nil then
  begin
    StrPCopy(F,Heading^); SetWindowText(HWindow,F); DisposeStr(Heading);
  end;
  if Prompt=Nil then Exit;

  GetClientRect(HWindow,CRect);
  GetWindowRect(Hwindow,WRect);
  SendDlgItemMsg(dl_EntryExistsText,wm_SetFont,0,1);
  Spacing:=GetTextLength(GetItemHandle(dl_EntryExistsText),'Ak');
  Tlen:=GetTextLength(GetItemHandle(dl_EntryExistsText),Prompt^)+2*Spacing;
  if Tlen+2*spacing>CRect.right then
  begin
    WNeed:=TLen+((WRect.right-WRect.left)-(CRect.right-Crect.left));
    for i:=1 to NControls do
    with Controls[i] do
    begin
      GetWindowRect(GetItemHandle(id),BRect);
      Point.X:=BRect.left; Point.Y:=BRect.top;
      ScreenToClient(HWindow,Point);
      if id=dl_EntryExistsText then
      begin
        X:=-Tlen div 2; W:=TLen;
      end else
      begin
        X:=Point.X-(CRect.right div 2);
        W:=BRect.right-BRect.left;
      end;
      Y:=Point.Y;
      H:=BRect.bottom-BRect.top;
    end;
    MoveWindow(Hwindow,(Wrect.right+WRect.left) div 2- WNeed div 2,WRect.Top,
               WNeed,WRect.Bottom-WRect.Top,true);
    for i:=1 to NControls do
    with Controls[i] do
      MoveWindow(GetItemHandle(id),Tlen div 2+X,Y,W,H,true);
  end;
  StrPCopy(F,Prompt^); SetWindowText(GetItemHandle(dl_EntryExistsText),F);
  DisposeStr(Prompt);
  if SkipDups then EnableWindow(GetItemHandle(dl_EntExistsSkipDup),false);
end;                   { TEntryExistsDlg.SetupWindow }

procedure TEntryExistsDlg.OK(var Msg: TMessage);  { OK }
var
  F: array[0..255] of char;
begin
  if CanClose then
  begin
    GetWindowText(EBox^.HWindow,F,255);
    Ename^:=StrPas(F);
    EndDlg(id_ok);
  end;
end;                { TEntryExistsDlg.OK }

procedure TEntryExistsDlg.Auto(var Msg: TMessage);   { Auto }
var
  S: string;
  F: array[0..255] of char;
begin
  S:='';
  AutoLabel(Entry,LabelTemplate^,S);
  if S='' then ErrorMessageRC(Str_EmptyTemplate,'')
  else begin
    StrPCopy(F,S); SetWindowText(EBox^.HWindow,F);
  end;
end;               { TEntryExistsDlg.Auto }

procedure TEntryExistsDlg.Cancel(var Msg: TMessage);     { Cancel }
begin EndDlg(id_cancel); end;

procedure TEntryExistsDlg.AbortBtn(var Msg: TMessage);   { Abort }
begin EndDlg(id_abort); end;

procedure TEntryExistsDlg.QuitBtn(var Msg: TMessage);    { Quit }
begin EndDlg(dl_EntExistsQuit); end;

procedure TEntryExistsDlg.SkipDup(var Msg: TMessage);    { Skip dup }
begin EndDlg(dl_EntExistsSkipDup); end;

procedure TEntryExistsDlg.EditBtn(var Msg: TMessage);    { Edit }
begin EndDlg(dl_EntExistsEdit); end;

{ Other }

procedure CheckEntryName(DisplayArea: PDisplayArea;
                         Elist1,Elist2: PStream; NameIndex: PBigCol; Var ename: string;
                         IgnoreName: string; AskForNew,AskForEdit,IsPlus: Boolean;
                         var SkipDups,QuitIt,AbortIt,EditIt,SkipDupsNow: boolean);
var
  D:  PEntryExistsDlg;
  ok,IsDup,IsSimilar: boolean;
  lowline,lowname: string;
  Srec: SortRecType;
  ans,id,i: integer;
  EntStr: string[10];
{$IFNDEF USENAMEINDEX}
  which,NEList: integer;
  EList: array[1..2] of PStream;
{$ENDIF}
begin
  QuitIt:=false; AbortIt:=false; EditIt:=false; SkipDupsNow:=false;
{$IFDEF USENAMEINDEX}
  if NameIndex=Nil then Exit;
{$ELSE}
  if (elist1=Nil) and (elist2=Nil) then Exit;
{$ENDIF}
  ChrDel(Ename,' ');
  if Ename='' then Exit;
  if CheckDuplicate=AllowDuplicate then Exit;
  if EditOnlyStrings then StrLwr(IgnoreName);
  EntStr:='Entry "'; if EditOnlyStrings then EntStr:='String "';
{$IFNDEF USENAMEINDEX}
  NElist:=1;
  if Elist1=Nil then
  begin
    Elist[1]:=Elist2; Elist[2]:=Nil;
  end else
  begin
    Elist[1]:=Elist1; EList[2]:=Elist2;
    if Elist2<>Nil then NElist:=2;
  end;
  which:=NElist;
{$ENDIF}
  Srec.name:='';
  lowname:=ename; StrLwr(lowname);
  repeat
    ok:=true;
    IsDup:=false; IsSimilar:=false;
{$IFDEF USENAMEINDEX}
{    message('Searching for '+ename+' between '+num2str(PBigColOne(NameIndex^.ColCol[true].at(0))^.Count));}
    if ename=IgnoreName then
    else if EditOnlyStrings or (CheckDuplicate=DuplicateCaseOff) then
    begin
      SRec.Name:=NameIndex^.FindStr(ename,false,IgnoreName);
      if SRec.Name<>'' then IsDup:=true;
    end else
    begin
      SRec.Name:=NameIndex^.FindStr(ename,true,IgnoreName);
      if SRec.Name<>'' then IsDup:=true
      else begin
        SRec.Name:=NameIndex^.FindStr(ename,false,IgnoreName);
        if SRec.Name<>'' then IsSimilar:=true;
      end;
    end;
{    message('found "'+SRec.Name+'"');}
    LowLine:=SRec.Name; StrLwr(LowLine);
{$ELSE}
    if Srec.name='' then
    begin
      which:=NEList+1-which;
      elist[which]^.flush; elist[which]^.reset; elist[which]^.seek(0);
    end;

    ReadSortRec(elist[which],Srec);
    lowline:=Srec.name; StrLwr(lowline);
    if (Srec.name='') or (lowline<>lowname) or (ename=IgnoreName) then
    else if EditOnlyStrings or (CheckDuplicate=DuplicateCaseOff) then
        IsDup:=(Lowline<>IgnoreName)
    else if CheckDuplicate=DuplicateCaseOn then IsDup:=true
    else IsSimilar:=true;
{$ENDIF}
{    message('Checking '+ename+' vs. '+Srec.name);}

    if IsDup and SkipDups then
    begin
      {QuitIt:=true;} ok:=false;
    end else if (IsSimilar or IsDup) then
    begin
      ok:=false;
      if AskForNew then
      begin
        id:=rc_EntryExistsDlg;
        if IsPlus then
        begin
          if AskForEdit then id:=rc_EntExistsPlusDlg
          else id:=rc_EntExistsExpDlg;
        end;
        if IsSimilar then
          New(D,Init(CurrentWindow,PChar(id),@Ename,
            EntStr+Ename+'" is similar to "'+Srec.name+'"!',
            'Warning',IsPlus,AskForEdit,SkipDups))
        else
          New(D,Init(CurrentWindow,PChar(id),@Ename,
            EntStr+Ename+'" already exists!',
            'Error',IsPlus,AskForEdit,SkipDups));
        if DisplayArea<>Nil then
        begin
          DisplayArea^.Update; UpdateWindow(DisplayArea^.HWindow);
        end;
        ans:=Application^.ExecDialog(D);

        ok:=(ans=id_ok);
        SkipDups:=SkipDups or (ans=dl_EntExistsSkipDup);
        SkipDupsNow:=(ans=dl_EntExistsSkipDup);
        QuitIt:=(ans=dl_EntExistsQuit);
        AbortIt:=(ans=id_abort);
        EditIt:=(ans=dl_EntExistsEdit);
        if ok then
        begin
          lowname:=ename; StrLwr(lowname);
{$IFNDEF USENAMEINDEX}
          which:=NElist;
{$ENDIF}
          Srec.name:='';
        end;
      end;
    end;
{$IFDEF USENAMEINDEX}
  until (not ok) or not (IsSimilar or IsDup);
{$ELSE}
  until (not ok) or (
    (Srec.name='') and (which=Nelist) and not (IsSimilar or IsDup));
{$ENDIF}
  if QuitIt or AbortIt or EditIt or SkipDupsNow then ok:=false;
  if not ok then ename:='';
  if IsPlus and (AbortIt or EditIt or QuitIt) then ename:='';
{$IFNDEF USENAMEINDEX}
  for i:=1 to 2 do
    if (Elist[i]<>Nil) and (Elist[i]^.status<>stOK) then Elist[i]^.reset;
{$ENDIF}
end;                      { CheckEntryName }


{ TAddEnWindow methods }

constructor TAddEnWindow.init(AParent: PWindowsObject; AEntry: EntryRecPtr;
              Awritten: Pboolean;
              AElist,ATEList,ATempEntries: PStream;
              ANameIndex: PBigCol;
              Anadded: Pword; ALastEntryName: Pstring;
              ASMode: ConfigSortPtr; ASortPattern: PatRecPtr;
              AMakeList: Boolean);
begin
  Aentry^.nentry:=0;
  TEdEnWindow.init(AParent,AEntry,-1,true);
  VerifyAutoName:=(LabelMode<>AutoLabelMode);

  written:=Awritten; nadded:=Anadded;
  Elist:=AElist; TElist:=ATElist; TempEntries:=ATempEntries;
  NameIndex:=ANameIndex;
  LastEntryName:=ALastEntryName;
  SMode:=ASMode; SortPattern:=ASortPattern;
  MakeList:=AMakeList;
  IsPlus:=false; SkipDups:=false;
end;                                { TAddEnWindow.init }

procedure TAddEnWindow.SetupWindow;
begin
  TEdEnWindow.SetupWindow;
  if EditOnlyStrings then SetWindowText(HWindow,'Add string')
  else SetWindowText(HWindow,'Add entry');
end;

procedure TAddEnWindow.SetupMenu;
var
  H: HMenu;
begin
  H:=GetMenu(HWindow);
  DeleteMenu(H,mi_EdSkip,mf_ByCommand);
  ModifyMenu(H,mi_EdQuit,mf_ByCommand or mf_String,mi_EdQuit,'Quit'#9'Esc');
  AccelKeys.Insert(New(PAccelKey,init('i',mi_EdFinish, false)));
  AccelKeys.Insert(New(PAccelKey,init('n',mi_EdSave,   false)));
  AccelKeys.Insert(New(PAccelKey,init(#27,mi_EdQuit,   false)));
end;               { TAddEnWindow.SetupMenu }

function TAddEnWindow.SaveEntry: integer;
var
  Ename: string;
  SkipAll,AbortIt,QuitIt,EditIt,SkipDupsNow: boolean;
begin
  SaveEntry:=id_cancel;
  if entry^.nentry=0 then
  begin
    ErrorMessageRC(Str_EmptyEntry,''); Exit;
  end;
  if Entry^.name='' then
  begin
    if VerifyAutoName then
    begin
      DisplayArea^.Update; UpdateWindow(HWindow);
      if Application^.ExecDialog(New(PEntryNameDlg,
         Init(@Self,Entry,true)))<>id_ok then Entry^.name:='';
    end else
    begin
      AutoLabel(entry,LabelTemplate^,entry^.name);
      if entry^.name='' then
        ErrorMessageRC(Str_EmptyTemplate,'');
    end;
    if Entry^.name='' then Exit;
  end;
  Ename:=entry^.name;
  if nadded^=0 then
    CheckEntryName(DisplayArea,elist,Nil,NameIndex,Ename,'',not SkipDups,true,IsPlus,
                   SkipDups,QuitIt,AbortIt,EditIt,SkipDupsNow)
  else
    CheckEntryName(DisplayArea,elist,TElist,NameIndex,Ename,'',not SkipDups,true,IsPlus,
                   SkipDups,QuitIt,AbortIt,EditIt,SkipDupsNow);
  if EditIt then
  begin
    SaveEntry:=dl_EntExistsEdit; Exit;
  end else if AbortIt then
  begin
    SaveEntry:=id_Abort; Exit;
  end else if QuitIt then
  begin
    SaveEntry:=dl_EntExistsQuit; Exit;
  end else if SkipDupsNow then
  begin
    SaveEntry:=dl_EntExistsSkipDup; Exit;
  end else if Ename='' then Exit;
  entry^.name:=Ename;
  Entry^.beginning:=TempEntries^.getsize;
  TempEntries^.seek(TempEntries^.getsize);
  PutEntryTemp(TempEntries,Entry,false);
  if TempEntries^.status<>stOK then
  begin
    ErrorMessageRC(Str_TempStreamError,'');
    EndDlg(id_abort);
  end;
  LastEntryName^:=Entry^.name;
  TempEntries^.flush;
  if MakeList then
  begin
    MaxMemAvail;
    TElist^.seek(TElist^.getsize);
    WriteElist(Telist,SMode^,SortPattern,Entry);
    if NameIndex<>Nil then NameIndex^.AddString(Entry^.Name);
    if TElist^.status<>stOK then
    begin
      ErrorMessageRC(Str_TempStreamError,'');
      EndDlg(id_Abort);
    end;
    Telist^.Flush;
  end;
  Inc(nadded^);
  written^:=true;
  SaveEntry:=id_ok;
end;                             { TAddEnWindow.SaveEntry }

procedure TAddEnWindow.Save(var Msg: TMessage);
begin
  if SaveEntry<>id_ok then Exit;
  Entry^.entrynum:=0; Entry^.realnum:=0; Entry^.nentry:=0;
  ZeroEntry(Entry); Entry^.name:='';
  if EditOnlyStrings then entry^.EntryType:='string'
  else entry^.EntryType:=TypeEntry^[1];
  FieldLast:=DefFieldLast;
  Update;
end;

procedure TAddEnWindow.Finish(var Msg: TMessage);
begin
  if SaveEntry=id_ok then EndDlg(id_ok);
end;

procedure TAddEnWindow.Quit(var Msg: TMessage);
begin
  EndDlg(id_ok);
end;

procedure TAddEnWindow.Abort(var Msg: TMessage);
begin
  EndDlg(id_Abort);
end;

destructor TAddEnWindow.Done;
begin
  if Elist<>Nil then
  begin
    Elist^.reset; Elist^.Flush;
  end;
  if MakeList and (TElist<>Nil) then
  begin
    TElist^.reset; TElist^.Flush;
  end;
  if TempEntries<>Nil then
  begin
    TempEntries^.reset; TempEntries^.Flush;
  end;
  TEdEnWindow.Done;
end;                     { TAddEnWindow.Done }

{ TImportEnWindow methods }

constructor TImportEnWindow.init(AParent: PWindowsObject; AEntry: EntryRecPtr;
              AStrm: PStream; Awritten: Pboolean;
              AElist,ATEList,ATempEntries: PStream;
              ANameIndex: PBigCol;
              Anadded: Pword; ALastEntryName: Pstring;
              ASMode: ConfigSortPtr; ASortPattern: PatRecPtr;
              AMakeList: Boolean);
begin
  TEdEnWindow.init(AParent,AEntry,-1,true);
  VerifyAutoName:=(LabelMode<>AutoLabelMode);

  written:=Awritten; nadded:=Anadded; Strm:=AStrm;
  Elist:=AElist; TElist:=ATElist; TempEntries:=ATempEntries;
  NameIndex:=ANameIndex;
  LastEntryName:=ALastEntryName;
  SMode:=ASMode; SortPattern:=ASortPattern;
  MakeList:=AMakeList;
  IsPlus:=false; SkipDups:=false;
end;                                { TImportEnWindow.init }

procedure TImportEnWindow.SetupWindow;
begin
  TEdEnWindow.SetupWindow;
  NProcessed:=1; Entry^.entrynum:=1;
  SkipDups:=MacroCommand; IsPlus:=true;
  if EditOnlyStrings then SetWindowText(HWindow,'Import string')
  else SetWindowText(HWindow,'Import entry');
  if not MacroCommand then
  begin
    show(sw_Show); UpdateWindow(HWindow);
  end;
  if MacroCommand or (Verify[ImportFormat]<>VerifyEntry) then ProcessEntry
  else begin
    SearchingMessage; WaitingOff;
  end;
end;                               { TImportEnWindow.SetupWindow }

procedure TImportEnWindow.SetupMenu;
begin
  AccelKeys.Insert(New(PAccelKey,init('i',mi_EdFinish, false)));
  AccelKeys.Insert(New(PAccelKey,init('n',mi_EdSave,   false)));
  AccelKeys.Insert(New(PAccelKey,init(#27,mi_EdSkip,   false)));
end;

procedure TImportEnWindow.GetNextEntry(var o_k: boolean);
begin
  o_k:=false;
  if ActivePattern(Pattern) and not AmWaiting then SearchingMessage;
  if ImportFormat=BibTeXFormat then
          GetEntry(Entry,Strm,entry^.entrynum+1,true,Pattern,o_k)
  else if ImportFormat=CommaDelimited then
          GetDBEntry(Entry,Strm,entry^.entrynum+1,'',Pattern,o_k)
  else if (ImportFormat=TibFormat) or (ImportFormat=ReferFormat) then
          GetTibEntry(Entry,Strm,entry^.entrynum+1,ImportFormat,'',Pattern,o_k);
  ChrDel(Entry^.name,' ');
  inc(NProcessed);
  if NProcessed>Entry^.entrynum then o_k:=false;
end;                                { TImportEnWindow.GetNextEntry }

procedure TImportEnWindow.ProcessEntry;
var
  o_k,QuitIt,AbortIt,EditIt,SkipDupsNow: boolean;
  ans: integer;
begin
  o_k:=true;
  repeat
    if entry^.name='' then AutoLabel(Entry,LabelTemplate^,Entry^.name);
    EntryName^.Update; UpdateWindow(EntryName^.HWindow);
    if (entry^.name<>'') and (MacroCommand or (Verify[ImportFormat]=VerifyOff)) then
    begin
      ans:=SaveEntry;
    end else
    begin
      if SkipDups then
        CheckEntryName(DisplayArea,elist,Nil,NameIndex,Entry^.name,'',false,false,IsPlus,
                       SkipDups,QuitIt,AbortIt,EditIt,SkipDupsNow);
      if Entry^.Name='' then ans:=id_cancel
      else begin 
        Update;
        DisplayArea^.Update; UpdateWindow(HWindow);
        if Verify[ImportFormat]=VerifyEntry then
        begin
          WaitingOff; Exit;   { Edit the entry }
        end;
        ans:=Application^.ExecDialog(New(PEntryExistsDlg,
          Init(CurrentWindow,PChar(rc_VerEntryNameDlg),@Entry^.name,'',
              'Entry name',false,false,false)));
        if ans=id_ok then ans:=SaveEntry;
      end;
    end;
    if ans=id_Abort              then
    begin
      EndDlg(id_Abort); Exit;
    end else if ans=dl_EntExistsQuit then
    begin
      EndDlg(id_ok); Exit;
    end else if ans=dl_EntExistsEdit then
    begin
      WaitingOff; Exit;   { Edit the entry }
    end;
    GetNextEntry(o_k);
  until not o_k;
  EndDlg(id_ok);
end;                          { TImportEnWindow.ProcessEntry }

procedure TImportEnWindow.Save(var Msg: TMessage);
var
  o_k: boolean;
  ans: integer;
begin
  ans:=SaveEntry;
  if ans=dl_EntExistsEdit then Exit;
  if ans=id_Abort then
  begin
    EndDlg(id_Abort); Exit;
  end;
  GetNextEntry(o_k);
  if not o_k then EndDlg(id_ok)
  else ProcessEntry;
end;                { TImportEnWindow.Save }

procedure TImportEnWindow.Quit(var Msg: TMessage);
begin
  EndDlg(id_ok);
end;

procedure TImportEnWindow.Skip(var Msg: TMessage);
var
  o_k: boolean;
begin
  GetNextEntry(o_k);
  if not o_k then EndDlg(id_ok)
  else ProcessEntry;
end;               { TImportEnWindow.Skip }

{ Other stuff }


procedure ManualAdd(Entry: EntryRecPtr;
                    var written,changed: boolean;
                    Elist,TEList,TempEntries: PStream; NameIndex: PBigCol;
                    var nadded: word; var LastEntryName: string;
                    SMode: ConfigSortPtr; SortPattern: PatRecPtr;
                    MakeList: boolean );
begin
  if Application^.ExecDialog(New(PAddEnWindow,
    Init(MainW,Entry,@written,Elist,TElist,TempEntries,NameIndex,@nadded,
             @LastEntryName,SMode,SortPattern,MakeList))
      )<>id_ok then
  begin
    written:=false; nadded:=0; changed:=false;
  end else if nadded>0 then changed:=true;
  UpdateWindow(HMainW);
end;                                     { ManualAdd }

procedure ImportEnt(Entry: EntryRecPtr; Pattern: PatRecPtr;
                 var ImpFile: string; var written,changed,UnixImp: boolean;
                 Elist,TEList,TempEntries: PStream;
                 NameIndex: PBigCol;
                 var nadded: word; var LastEntryName: string;
                 var FirstEntry: longint;
                 SMode: ConfigSortPtr; SortPattern: PatRecPtr;
                 MakeList: boolean);
var
  OldBibName: string;
  OldUnixBib,OldBibFileExists,ok: boolean;
  Strm: PHugeMemStream;
  T: THandle;

procedure TidyUp;
var
  IsClip: boolean;
begin
  IsClip:=false;
  if Strm=Nil then CloseFile(bib)
  else begin
    Dispose(Strm,Done);
    CloseClipboard;
    IsClip:=true;
  end;
  BibName^:=OldBibName;
  LFNAssign(bib,bibname^); UnixBib:=OldUnixBib;
  BibFileExists:=OldBibFileExists;
  SetTextBuf(bib,bibbuf^,FileBufSize);
  if (not AbortFlag) and (nadded=0) then
  begin
    if IsClip then
    begin
      if EditOnlyStrings then MessageRC(Str_NoStringsInClip,ImpFile)
      else MessageRC(Str_NoEntriesInClip,ImpFile);
    end else
    begin
      if EditOnlyStrings then MessageRC(Str_NoStringsIn,ImpFile)
      else MessageRC(Str_NoEntriesIn,ImpFile);
    end;
  end;
  EntryCache^.on:=true;
end;                    { TidyUp }

begin
  if (ImpFile='') then Exit;
  if (ImpFile=File_Clipboard) and not IsClipboardFormatAvailable(cf_text) then exit;
  OldBibFileExists:=BibFileExists;
  OldUnixBib:=UnixBib;
  OldBibName:=BibName^; BibName^:=ImpFile;
  CloseFile(bib);
  EntryCache^.on:=false;

  Strm:=Nil;
  if ImpFile=File_Clipboard then
  begin
    { Get clipboard data and set up the data stream }
    OpenClipboard(HMainW);
    T:=GetClipboardData(cf_text);
    New(Strm,InitExt(T,-1,false));
    Strm^.seek(0);
    UnixImp:=true
  end else
  begin
    LFNAssign(bib,ImpFile); UnixImp:=IsUnixFile(bib,ImpFile);
    SetTextBuf(bib,bibbuf^,FileBufSize);
  end;
  BibFileExists:=true;
  GotoStart(Strm,Entry);
  UnixBib:=UnixImp;
  nadded:=0;
  if ImportFormat=BibTeXFormat then
    GetEntry(Entry,Strm,1,true,Nil,ok)
  else if ImportFormat=CommaDelimited then
    GetDBEntry(Entry,Strm,1,'',Nil,ok)
  else if (ImportFormat=TibFormat) or (ImportFormat=ReferFormat) then
    GetTibEntry(Entry,Strm,1,ImportFormat,'',Nil,ok);
  FirstEntry:=Entry^.Beginning;
  if ok and ActivePattern(Pattern) and (ImportFormat=BibTeXFormat) then
  begin
    SearchingMessage;
    GotoStart(Strm,Entry);
    GetEntry(Entry,Strm,1,true,Pattern,ok);
  end;
  if not ok then
  begin
    TidyUp; Exit;
  end;
  ChrDel(Entry^.name,' ');

  if Application^.ExecDialog(New(PImportEnWindow,
             Init(MainW,Entry,Strm,@written,Elist,TElist,TempEntries,NameIndex,@nadded,
             @LastEntryName,SMode,SortPattern,MakeList)))<>id_ok then
  begin
    written:=false; nadded:=0; changed:=false;
  end else if nadded>0 then changed:=true;
  UpdateWindow(HMainW);

  TidyUp;

end;                                  { Import }




end.
