/* Parameter.h
 *
 * Formatting a file means keeping track of a lot of things, like the current
 * font, the size of the margins, and the chapter number.
 * We call these "parameters" and group them under one class because the ways
 * they are altered recursively or incrementally are very similar.
 *
 * Copyright 1992 Jonathan Monsarrat. Permission given to freely distribute,
 * edit and use as long as this copyright statement remains intact.
 *
 */

#include "LameTeX.h"
#include <iostream.h>

class Param{
 public:
   virtual Param *copy() = 0;
   virtual int set(int, float, char *) = 0;
   virtual float get(int, char *) = 0;
   virtual void postscript_set(int) = 0;
   virtual void revert(Param *) = 0;
};
