/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.AbstractTeXObject;
import com.dickimawbooks.texparserlib.Direction;
import com.dickimawbooks.texparserlib.SpacingObject;
import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import java.io.IOException;

public class Spacer
extends AbstractTeXObject
implements SpacingObject {
    protected Direction direction;
    protected TeXDimension size;
    protected boolean inline;

    public Spacer(Direction direction, TeXDimension teXDimension) {
        this(direction, teXDimension, direction == Direction.HORIZONTAL);
    }

    public Spacer(Direction direction, TeXDimension teXDimension, boolean bl) {
        this.direction = direction;
        this.size = teXDimension;
        this.inline = bl;
    }

    public String toString() {
        return String.format("%s[direction=%s,size=%s,inline=%s]", new Object[]{this.getClass().getSimpleName(), this.direction, this.size, this.inline});
    }

    @Override
    public TeXDimension getSize(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return this.getSize();
    }

    public TeXDimension getSize() {
        return this.size;
    }

    @Override
    public Direction getDirection() {
        return this.direction;
    }

    public boolean isInLine() {
        return this.inline;
    }

    @Override
    public Object clone() {
        return new Spacer(this.direction, this.size == null ? null : (TeXDimension)this.size.clone(), this.isInLine());
    }

    @Override
    public String toString(TeXParser teXParser) {
        return String.format("%s%s %s", new String(Character.toChars(teXParser.getEscChar())), this.direction == Direction.HORIZONTAL ? "hskip" : "vskip", this.size == null ? "0pt" : this.size.toString(teXParser));
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        return teXParser.getListener().createString(" ");
    }

    @Override
    public String format() {
        return String.format("\\%s %s", this.direction == Direction.HORIZONTAL ? "hskip" : "vskip", this.size == null ? "0pt" : this.size.format());
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        if (this.direction == Direction.HORIZONTAL) {
            teXParser.getListener().getWriteable().write(" ");
        } else {
            teXParser.getListener().getWriteable().writeln("");
        }
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        if (this.direction == Direction.HORIZONTAL) {
            teXParser.getListener().getWriteable().write(" ");
        } else {
            teXParser.getListener().getWriteable().writeln("");
        }
    }
}

