package Google::Ads::AdWords::v201109_1::PercentCPAAdGroupCriterionBids;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201109_1' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}


use base qw(Google::Ads::AdWords::v201109_1::AdGroupCriterionBids);
# Variety: sequence
use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %AdGroupCriterionBids__Type_of :ATTR(:get<AdGroupCriterionBids__Type>);
my %percentCpa_of :ATTR(:get<percentCpa>);
my %source_of :ATTR(:get<source>);

__PACKAGE__->_factory(
    [ qw(        AdGroupCriterionBids__Type
        percentCpa
        source

    ) ],
    {
        'AdGroupCriterionBids__Type' => \%AdGroupCriterionBids__Type_of,
        'percentCpa' => \%percentCpa_of,
        'source' => \%source_of,
    },
    {
        'AdGroupCriterionBids__Type' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'percentCpa' => 'SOAP::WSDL::XSD::Typelib::Builtin::int',
        'source' => 'Google::Ads::AdWords::v201109_1::BidSource',
    },
    {

        'AdGroupCriterionBids__Type' => 'AdGroupCriterionBids.Type',
        'percentCpa' => 'percentCpa',
        'source' => 'source',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201109_1::PercentCPAAdGroupCriterionBids

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
PercentCPAAdGroupCriterionBids from the namespace https://adwords.google.com/api/adwords/cm/v201109_1.

Criterion-level Percent cost-per-conversion(acquisition) bid for Product criteria type. {@link PercentCPA} bidding strategy and bids are available only to some advertisers. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * percentCpa


=item * source




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Google::Ads::AdWords::v201109_1::PercentCPAAdGroupCriterionBids
   percentCpa =>  $some_value, # int
   source => $some_value, # BidSource
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

