#
# (c) Jan Gehring <jan.gehring@gmail.com>
#

package Rex::Virtualization::LibVirt::start;

use v5.12.5;
use warnings;

our $VERSION = '1.15.0.1'; # TRIAL VERSION

use Rex::Logger;
use Rex::Helper::Run;

sub execute {
  my ( $class, $arg1, %opt ) = @_;
  my $virt_settings = Rex::Config->get("virtualization");

  Rex::Logger::debug("Starting vm: $arg1");

  chomp( my $uri =
      ref($virt_settings) ? $virt_settings->{connect} : i_run "virsh uri" );

  unless ($arg1) {
    die("You have to define the vm name!");
  }

  my $dom = $arg1;
  Rex::Logger::debug("starting domain: $dom");

  unless ($dom) {
    die("VM $dom not found.");
  }

  my $output = i_run "virsh -c $uri start '$dom' 2>&1", fail_ok => 1;
  if ( $? != 0 ) {
    die("Error starting vm $dom\nError: $output");
  }

}

1;
