#############################################################
# This file was automatically generated on 2021-05-06.      #
#                                                           #
# Perl Bindings Version 2.1.30                              #
#                                                           #
# If you have a bugfix for this file and want to commit it, #
# please fix the bug in the generator. You can find a link  #
# to the generators git repository on tinkerforge.com       #
#############################################################

=pod

=encoding utf8

=head1 NAME

Tinkerforge::BrickletSilentStepperV2 - Silently drives one bipolar stepper motor with up to 46V and 1.6A per phase

=cut

package Tinkerforge::BrickletSilentStepperV2;

use strict;
use warnings;
use Carp;
use threads;
use threads::shared;
use parent 'Tinkerforge::Device';
use Tinkerforge::IPConnection;
use Tinkerforge::Error;

=head1 CONSTANTS

=over

=item DEVICE_IDENTIFIER

This constant is used to identify a Silent Stepper Bricklet 2.0.

The get_identity() subroutine and the CALLBACK_ENUMERATE callback of the
IP Connection have a device_identifier parameter to specify the Brick's or
Bricklet's type.

=cut

use constant DEVICE_IDENTIFIER => 2166;

=item DEVICE_DISPLAY_NAME

This constant represents the display name of a Silent Stepper Bricklet 2.0.

=cut

use constant DEVICE_DISPLAY_NAME => 'Silent Stepper Bricklet 2.0';

=item CALLBACK_UNDER_VOLTAGE

This constant is used with the register_callback() subroutine to specify
the CALLBACK_UNDER_VOLTAGE callback.

=cut

use constant CALLBACK_UNDER_VOLTAGE => 41;

=item CALLBACK_POSITION_REACHED

This constant is used with the register_callback() subroutine to specify
the CALLBACK_POSITION_REACHED callback.

=cut

use constant CALLBACK_POSITION_REACHED => 42;

=item CALLBACK_ALL_DATA

This constant is used with the register_callback() subroutine to specify
the CALLBACK_ALL_DATA callback.

=cut

use constant CALLBACK_ALL_DATA => 53;

=item CALLBACK_NEW_STATE

This constant is used with the register_callback() subroutine to specify
the CALLBACK_NEW_STATE callback.

=cut

use constant CALLBACK_NEW_STATE => 54;

=item CALLBACK_GPIO_STATE

This constant is used with the register_callback() subroutine to specify
the CALLBACK_GPIO_STATE callback.

=cut

use constant CALLBACK_GPIO_STATE => 55;

=item FUNCTION_SET_MAX_VELOCITY

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_MAX_VELOCITY => 1;

=item FUNCTION_GET_MAX_VELOCITY

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_MAX_VELOCITY => 2;

=item FUNCTION_GET_CURRENT_VELOCITY

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_CURRENT_VELOCITY => 3;

=item FUNCTION_SET_SPEED_RAMPING

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_SPEED_RAMPING => 4;

=item FUNCTION_GET_SPEED_RAMPING

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_SPEED_RAMPING => 5;

=item FUNCTION_FULL_BRAKE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_FULL_BRAKE => 6;

=item FUNCTION_SET_CURRENT_POSITION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_CURRENT_POSITION => 7;

=item FUNCTION_GET_CURRENT_POSITION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_CURRENT_POSITION => 8;

=item FUNCTION_SET_TARGET_POSITION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_TARGET_POSITION => 9;

=item FUNCTION_GET_TARGET_POSITION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_TARGET_POSITION => 10;

=item FUNCTION_SET_STEPS

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_STEPS => 11;

=item FUNCTION_GET_STEPS

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_STEPS => 12;

=item FUNCTION_GET_REMAINING_STEPS

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_REMAINING_STEPS => 13;

=item FUNCTION_SET_STEP_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_STEP_CONFIGURATION => 14;

=item FUNCTION_GET_STEP_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_STEP_CONFIGURATION => 15;

=item FUNCTION_DRIVE_FORWARD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_DRIVE_FORWARD => 16;

=item FUNCTION_DRIVE_BACKWARD

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_DRIVE_BACKWARD => 17;

=item FUNCTION_STOP

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_STOP => 18;

=item FUNCTION_GET_INPUT_VOLTAGE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_INPUT_VOLTAGE => 19;

=item FUNCTION_SET_MOTOR_CURRENT

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_MOTOR_CURRENT => 22;

=item FUNCTION_GET_MOTOR_CURRENT

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_MOTOR_CURRENT => 23;

=item FUNCTION_SET_ENABLED

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_ENABLED => 24;

=item FUNCTION_GET_ENABLED

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_ENABLED => 25;

=item FUNCTION_SET_BASIC_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_BASIC_CONFIGURATION => 26;

=item FUNCTION_GET_BASIC_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_BASIC_CONFIGURATION => 27;

=item FUNCTION_SET_SPREADCYCLE_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_SPREADCYCLE_CONFIGURATION => 28;

=item FUNCTION_GET_SPREADCYCLE_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_SPREADCYCLE_CONFIGURATION => 29;

=item FUNCTION_SET_STEALTH_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_STEALTH_CONFIGURATION => 30;

=item FUNCTION_GET_STEALTH_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_STEALTH_CONFIGURATION => 31;

=item FUNCTION_SET_COOLSTEP_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_COOLSTEP_CONFIGURATION => 32;

=item FUNCTION_GET_COOLSTEP_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_COOLSTEP_CONFIGURATION => 33;

=item FUNCTION_SET_MISC_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_MISC_CONFIGURATION => 34;

=item FUNCTION_GET_MISC_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_MISC_CONFIGURATION => 35;

=item FUNCTION_SET_ERROR_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_ERROR_LED_CONFIG => 36;

=item FUNCTION_GET_ERROR_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_ERROR_LED_CONFIG => 37;

=item FUNCTION_GET_DRIVER_STATUS

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_DRIVER_STATUS => 38;

=item FUNCTION_SET_MINIMUM_VOLTAGE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_MINIMUM_VOLTAGE => 39;

=item FUNCTION_GET_MINIMUM_VOLTAGE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_MINIMUM_VOLTAGE => 40;

=item FUNCTION_SET_TIME_BASE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_TIME_BASE => 43;

=item FUNCTION_GET_TIME_BASE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_TIME_BASE => 44;

=item FUNCTION_GET_ALL_DATA

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_ALL_DATA => 45;

=item FUNCTION_SET_ALL_CALLBACK_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_ALL_CALLBACK_CONFIGURATION => 46;

=item FUNCTION_GET_ALL_DATA_CALLBACK_CONFIGURATON

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_ALL_DATA_CALLBACK_CONFIGURATON => 47;

=item FUNCTION_SET_GPIO_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_GPIO_CONFIGURATION => 48;

=item FUNCTION_GET_GPIO_CONFIGURATION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_GPIO_CONFIGURATION => 49;

=item FUNCTION_SET_GPIO_ACTION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_GPIO_ACTION => 50;

=item FUNCTION_GET_GPIO_ACTION

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_GPIO_ACTION => 51;

=item FUNCTION_GET_GPIO_STATE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_GPIO_STATE => 52;

=item FUNCTION_GET_SPITFP_ERROR_COUNT

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_SPITFP_ERROR_COUNT => 234;

=item FUNCTION_SET_BOOTLOADER_MODE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_BOOTLOADER_MODE => 235;

=item FUNCTION_GET_BOOTLOADER_MODE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_BOOTLOADER_MODE => 236;

=item FUNCTION_SET_WRITE_FIRMWARE_POINTER

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_WRITE_FIRMWARE_POINTER => 237;

=item FUNCTION_WRITE_FIRMWARE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_WRITE_FIRMWARE => 238;

=item FUNCTION_SET_STATUS_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_STATUS_LED_CONFIG => 239;

=item FUNCTION_GET_STATUS_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_STATUS_LED_CONFIG => 240;

=item FUNCTION_GET_CHIP_TEMPERATURE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_CHIP_TEMPERATURE => 242;

=item FUNCTION_RESET

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_RESET => 243;

=item FUNCTION_WRITE_UID

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_WRITE_UID => 248;

=item FUNCTION_READ_UID

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_READ_UID => 249;

=item FUNCTION_GET_IDENTITY

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_IDENTITY => 255;
use constant STEP_RESOLUTION_1 => 8;
use constant STEP_RESOLUTION_2 => 7;
use constant STEP_RESOLUTION_4 => 6;
use constant STEP_RESOLUTION_8 => 5;
use constant STEP_RESOLUTION_16 => 4;
use constant STEP_RESOLUTION_32 => 3;
use constant STEP_RESOLUTION_64 => 2;
use constant STEP_RESOLUTION_128 => 1;
use constant STEP_RESOLUTION_256 => 0;
use constant CHOPPER_MODE_SPREAD_CYCLE => 0;
use constant CHOPPER_MODE_FAST_DECAY => 1;
use constant FREEWHEEL_MODE_NORMAL => 0;
use constant FREEWHEEL_MODE_FREEWHEELING => 1;
use constant FREEWHEEL_MODE_COIL_SHORT_LS => 2;
use constant FREEWHEEL_MODE_COIL_SHORT_HS => 3;
use constant CURRENT_UP_STEP_INCREMENT_1 => 0;
use constant CURRENT_UP_STEP_INCREMENT_2 => 1;
use constant CURRENT_UP_STEP_INCREMENT_4 => 2;
use constant CURRENT_UP_STEP_INCREMENT_8 => 3;
use constant CURRENT_DOWN_STEP_DECREMENT_1 => 0;
use constant CURRENT_DOWN_STEP_DECREMENT_2 => 1;
use constant CURRENT_DOWN_STEP_DECREMENT_8 => 2;
use constant CURRENT_DOWN_STEP_DECREMENT_32 => 3;
use constant MINIMUM_CURRENT_HALF => 0;
use constant MINIMUM_CURRENT_QUARTER => 1;
use constant STALLGUARD_MODE_STANDARD => 0;
use constant STALLGUARD_MODE_FILTERED => 1;
use constant OPEN_LOAD_NONE => 0;
use constant OPEN_LOAD_PHASE_A => 1;
use constant OPEN_LOAD_PHASE_B => 2;
use constant OPEN_LOAD_PHASE_AB => 3;
use constant SHORT_TO_GROUND_NONE => 0;
use constant SHORT_TO_GROUND_PHASE_A => 1;
use constant SHORT_TO_GROUND_PHASE_B => 2;
use constant SHORT_TO_GROUND_PHASE_AB => 3;
use constant OVER_TEMPERATURE_NONE => 0;
use constant OVER_TEMPERATURE_WARNING => 1;
use constant OVER_TEMPERATURE_LIMIT => 2;
use constant STATE_STOP => 1;
use constant STATE_ACCELERATION => 2;
use constant STATE_RUN => 3;
use constant STATE_DEACCELERATION => 4;
use constant STATE_DIRECTION_CHANGE_TO_FORWARD => 5;
use constant STATE_DIRECTION_CHANGE_TO_BACKWARD => 6;
use constant GPIO_ACTION_NONE => 0;
use constant GPIO_ACTION_NORMAL_STOP_RISING_EDGE => 1;
use constant GPIO_ACTION_NORMAL_STOP_FALLING_EDGE => 2;
use constant GPIO_ACTION_FULL_BRAKE_RISING_EDGE => 4;
use constant GPIO_ACTION_FULL_BRAKE_FALLING_EDGE => 8;
use constant GPIO_ACTION_CALLBACK_RISING_EDGE => 16;
use constant GPIO_ACTION_CALLBACK_FALLING_EDGE => 32;
use constant ERROR_LED_CONFIG_OFF => 0;
use constant ERROR_LED_CONFIG_ON => 1;
use constant ERROR_LED_CONFIG_SHOW_HEARTBEAT => 2;
use constant ERROR_LED_CONFIG_SHOW_ERROR => 3;
use constant BOOTLOADER_MODE_BOOTLOADER => 0;
use constant BOOTLOADER_MODE_FIRMWARE => 1;
use constant BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT => 2;
use constant BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT => 3;
use constant BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT => 4;
use constant BOOTLOADER_STATUS_OK => 0;
use constant BOOTLOADER_STATUS_INVALID_MODE => 1;
use constant BOOTLOADER_STATUS_NO_CHANGE => 2;
use constant BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT => 3;
use constant BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT => 4;
use constant BOOTLOADER_STATUS_CRC_MISMATCH => 5;
use constant STATUS_LED_CONFIG_OFF => 0;
use constant STATUS_LED_CONFIG_ON => 1;
use constant STATUS_LED_CONFIG_SHOW_HEARTBEAT => 2;
use constant STATUS_LED_CONFIG_SHOW_STATUS => 3;


=back

=head1 FUNCTIONS

=over

=item new()

Creates an object with the unique device ID *uid* and adds it to
the IP Connection *ipcon*.

=cut

sub new
{
	my ($class, $uid, $ipcon) = @_;

	my $self = Tinkerforge::Device->_new($uid, $ipcon, [2, 0, 0], &DEVICE_IDENTIFIER, &DEVICE_DISPLAY_NAME);

	$self->{response_expected}->{&FUNCTION_SET_MAX_VELOCITY} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_MAX_VELOCITY} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_CURRENT_VELOCITY} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_SPEED_RAMPING} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_SPEED_RAMPING} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_FULL_BRAKE} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_SET_CURRENT_POSITION} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_CURRENT_POSITION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_TARGET_POSITION} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_TARGET_POSITION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_STEPS} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_STEPS} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_REMAINING_STEPS} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_STEP_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_STEP_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_DRIVE_FORWARD} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_DRIVE_BACKWARD} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_STOP} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_INPUT_VOLTAGE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_MOTOR_CURRENT} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_MOTOR_CURRENT} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_ENABLED} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_ENABLED} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_BASIC_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_BASIC_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_SPREADCYCLE_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_SPREADCYCLE_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_STEALTH_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_STEALTH_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_COOLSTEP_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_COOLSTEP_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_MISC_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_MISC_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_ERROR_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_ERROR_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_DRIVER_STATUS} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_MINIMUM_VOLTAGE} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_MINIMUM_VOLTAGE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_TIME_BASE} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_TIME_BASE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_ALL_DATA} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_ALL_CALLBACK_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_ALL_DATA_CALLBACK_CONFIGURATON} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_GPIO_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_GPIO_CONFIGURATION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_GPIO_ACTION} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_GPIO_ACTION} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_GPIO_STATE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_SPITFP_ERROR_COUNT} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_BOOTLOADER_MODE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_BOOTLOADER_MODE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_WRITE_FIRMWARE_POINTER} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_WRITE_FIRMWARE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_STATUS_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_STATUS_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_CHIP_TEMPERATURE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_RESET} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_WRITE_UID} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_READ_UID} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_IDENTITY} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;

	$self->{callback_formats}->{&CALLBACK_UNDER_VOLTAGE} = shared_clone([10, 'S']);
	$self->{callback_formats}->{&CALLBACK_POSITION_REACHED} = shared_clone([12, 'l']);
	$self->{callback_formats}->{&CALLBACK_ALL_DATA} = shared_clone([22, 'S l l S S']);
	$self->{callback_formats}->{&CALLBACK_NEW_STATE} = shared_clone([10, 'C C']);
	$self->{callback_formats}->{&CALLBACK_GPIO_STATE} = shared_clone([9, '?2']);



	bless($self, $class);

	$ipcon->_add_device($self);

	return $self;
}


=item set_max_velocity()

Sets the maximum velocity of the stepper motor.
This function does *not* start the motor, it merely sets the maximum
velocity the stepper motor is accelerated to. To get the motor running use
either :func:`Set Target Position`, :func:`Set Steps`, :func:`Drive Forward` or
:func:`Drive Backward`.

=cut

sub set_max_velocity
{
	my ($self, $velocity) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_MAX_VELOCITY, [$velocity], 'S', 0, '');
}

=item get_max_velocity()

Returns the velocity as set by :func:`Set Max Velocity`.

=cut

sub get_max_velocity
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_MAX_VELOCITY, [], '', 10, 'S');
}

=item get_current_velocity()

Returns the *current* velocity of the stepper motor.

=cut

sub get_current_velocity
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_CURRENT_VELOCITY, [], '', 10, 'S');
}

=item set_speed_ramping()

Sets the acceleration and deacceleration of the stepper motor.
An acceleration of 1000 means, that
every second the velocity is increased by 1000 *steps/s*.

For example: If the current velocity is 0 and you want to accelerate to a
velocity of 8000 *steps/s* in 10 seconds, you should set an acceleration
of 800 *steps/s²*.

An acceleration/deacceleration of 0 means instantaneous
acceleration/deacceleration (not recommended)

=cut

sub set_speed_ramping
{
	my ($self, $acceleration, $deacceleration) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_SPEED_RAMPING, [$acceleration, $deacceleration], 'S S', 0, '');
}

=item get_speed_ramping()

Returns the acceleration and deacceleration as set by
:func:`Set Speed Ramping`.

=cut

sub get_speed_ramping
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_SPEED_RAMPING, [], '', 12, 'S S');
}

=item full_brake()

Executes an active full brake.

.. warning::
 This function is for emergency purposes,
 where an immediate brake is necessary. Depending on the current velocity and
 the strength of the motor, a full brake can be quite violent.

Call :func:`Stop` if you just want to stop the motor.

=cut

sub full_brake
{
	my ($self) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_FULL_BRAKE, [], '', 0, '');
}

=item set_current_position()

Sets the current steps of the internal step counter. This can be used to
set the current position to 0 when some kind of starting position
is reached (e.g. when a CNC machine reaches a corner).

=cut

sub set_current_position
{
	my ($self, $position) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_CURRENT_POSITION, [$position], 'l', 0, '');
}

=item get_current_position()

Returns the current position of the stepper motor in steps. On startup
the position is 0. The steps are counted with all possible driving
functions (:func:`Set Target Position`, :func:`Set Steps`, :func:`Drive Forward` or
:func:`Drive Backward`). It also is possible to reset the steps to 0 or
set them to any other desired value with :func:`Set Current Position`.

=cut

sub get_current_position
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_CURRENT_POSITION, [], '', 12, 'l');
}

=item set_target_position()

Sets the target position of the stepper motor in steps. For example,
if the current position of the motor is 500 and :func:`Set Target Position` is
called with 1000, the stepper motor will drive 500 steps forward. It will
use the velocity, acceleration and deacceleration as set by
:func:`Set Max Velocity` and :func:`Set Speed Ramping`.

A call of :func:`Set Target Position` with the parameter *x* is equivalent to
a call of :func:`Set Steps` with the parameter
(*x* - :func:`Get Current Position`).

=cut

sub set_target_position
{
	my ($self, $position) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_TARGET_POSITION, [$position], 'l', 0, '');
}

=item get_target_position()

Returns the last target position as set by :func:`Set Target Position`.

=cut

sub get_target_position
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_TARGET_POSITION, [], '', 12, 'l');
}

=item set_steps()

Sets the number of steps the stepper motor should run. Positive values
will drive the motor forward and negative values backward.
The velocity, acceleration and deacceleration as set by
:func:`Set Max Velocity` and :func:`Set Speed Ramping` will be used.

=cut

sub set_steps
{
	my ($self, $steps) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_STEPS, [$steps], 'l', 0, '');
}

=item get_steps()

Returns the last steps as set by :func:`Set Steps`.

=cut

sub get_steps
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_STEPS, [], '', 12, 'l');
}

=item get_remaining_steps()

Returns the remaining steps of the last call of :func:`Set Steps`.
For example, if :func:`Set Steps` is called with 2000 and
:func:`Get Remaining Steps` is called after the motor has run for 500 steps,
it will return 1500.

=cut

sub get_remaining_steps
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_REMAINING_STEPS, [], '', 12, 'l');
}

=item set_step_configuration()

Sets the step resolution from full-step up to 1/256-step.

If interpolation is turned on, the Silent Stepper Bricklet 2.0 will always interpolate
your step inputs as 1/256-step. If you use full-step mode with interpolation, each
step will generate 256 1/256 steps.

For maximum torque use full-step without interpolation. For maximum resolution use
1/256-step. Turn interpolation on to make the Stepper driving less noisy.

If you often change the speed with high acceleration you should turn the
interpolation off.

=cut

sub set_step_configuration
{
	my ($self, $step_resolution, $interpolation) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_STEP_CONFIGURATION, [$step_resolution, $interpolation], 'C ?', 0, '');
}

=item get_step_configuration()

Returns the step mode as set by :func:`Set Step Configuration`.

=cut

sub get_step_configuration
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_STEP_CONFIGURATION, [], '', 10, 'C ?');
}

=item drive_forward()

Drives the stepper motor forward until :func:`Drive Backward` or
:func:`Stop` is called. The velocity, acceleration and deacceleration as
set by :func:`Set Max Velocity` and :func:`Set Speed Ramping` will be used.

=cut

sub drive_forward
{
	my ($self) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_DRIVE_FORWARD, [], '', 0, '');
}

=item drive_backward()

Drives the stepper motor backward until :func:`Drive Forward` or
:func:`Stop` is triggered. The velocity, acceleration and deacceleration as
set by :func:`Set Max Velocity` and :func:`Set Speed Ramping` will be used.

=cut

sub drive_backward
{
	my ($self) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_DRIVE_BACKWARD, [], '', 0, '');
}

=item stop()

Stops the stepper motor with the deacceleration as set by
:func:`Set Speed Ramping`.

=cut

sub stop
{
	my ($self) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_STOP, [], '', 0, '');
}

=item get_input_voltage()

Returns the external input voltage. The external input voltage is
given via the black power input connector on the Silent Stepper Bricklet 2.0.

If there is an external input voltage and a stack input voltage, the motor
will be driven by the external input voltage. If there is only a stack
voltage present, the motor will be driven by this voltage.

.. warning::
 This means, if you have a high stack voltage and a low external voltage,
 the motor will be driven with the low external voltage. If you then remove
 the external connection, it will immediately be driven by the high
 stack voltage

=cut

sub get_input_voltage
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_INPUT_VOLTAGE, [], '', 10, 'S');
}

=item set_motor_current()

Sets the current with which the motor will be driven.

.. warning::
 Do not set this value above the specifications of your stepper motor.
 Otherwise it may damage your motor.

=cut

sub set_motor_current
{
	my ($self, $current) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_MOTOR_CURRENT, [$current], 'S', 0, '');
}

=item get_motor_current()

Returns the current as set by :func:`Set Motor Current`.

=cut

sub get_motor_current
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_MOTOR_CURRENT, [], '', 10, 'S');
}

=item set_enabled()

Enables/Disables the driver chip. The driver parameters can be configured (maximum velocity,
acceleration, etc) before it is enabled.

.. warning::
 Disabling the driver chip while the motor is still turning can damage the
 driver chip. The motor should be stopped calling :func:`Stop` function
 before disabling the motor power. The :func:`Stop` function will **not**
 wait until the motor is actually stopped. You have to explicitly wait for the
 appropriate time after calling the :func:`Stop` function before calling
 the :func:`Set Enabled` with false function.

=cut

sub set_enabled
{
	my ($self, $enabled) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_ENABLED, [$enabled], '?', 0, '');
}

=item get_enabled()

Returns *true* if the stepper driver is enabled, *false* otherwise.

=cut

sub get_enabled
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_ENABLED, [], '', 9, '?');
}

=item set_basic_configuration()

Sets the basic configuration parameters for the different modes (Stealth, Coolstep, Classic).

* Standstill Current: This value can be used to lower the current during stand still. This might
  be reasonable to reduce the heating of the motor and the Bricklet 2.0. When the motor is in standstill
  the configured motor phase current will be driven until the configured
  Power Down Time is elapsed. After that the phase current will be reduced to the standstill
  current. The elapsed time for this reduction can be configured with the Standstill Delay Time.
  The maximum allowed value is the configured maximum motor current
  (see :func:`Set Motor Current`).

* Motor Run Current: The value sets the motor current when the motor is running.
  Use a value of at least one half of the global maximum motor current for a good
  microstep performance. The maximum allowed value is the current
  motor current. The API maps the entered value to 1/32 ... 32/32 of the maximum
  motor current. This value should be used to change the motor current during motor movement,
  whereas the global maximum motor current should not be changed while the motor is moving
  (see :func:`Set Motor Current`).

* Standstill Delay Time: Controls the duration for motor power down after a motion
  as soon as standstill is detected and the Power Down Time is expired. A high Standstill Delay
  Time results in a smooth transition that avoids motor jerk during power down.

* Power Down Time: Sets the delay time after a stand still.

* Stealth Threshold: Sets the upper threshold for Stealth mode.
  If the velocity of the motor goes above this value, Stealth mode is turned
  off. Otherwise it is turned on. In Stealth mode the torque declines with high speed.

* Coolstep Threshold: Sets the lower threshold for Coolstep mode.
  The Coolstep Threshold needs to be above the Stealth Threshold.

* Classic Threshold: Sets the lower threshold for classic mode.
  In classic mode the stepper becomes more noisy, but the torque is maximized.

* High Velocity Chopper Mode: If High Velocity Chopper Mode is enabled, the stepper control
  is optimized to run the stepper motors at high velocities.

If you want to use all three thresholds make sure that
Stealth Threshold < Coolstep Threshold < Classic Threshold.

=cut

sub set_basic_configuration
{
	my ($self, $standstill_current, $motor_run_current, $standstill_delay_time, $power_down_time, $stealth_threshold, $coolstep_threshold, $classic_threshold, $high_velocity_chopper_mode) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_BASIC_CONFIGURATION, [$standstill_current, $motor_run_current, $standstill_delay_time, $power_down_time, $stealth_threshold, $coolstep_threshold, $classic_threshold, $high_velocity_chopper_mode], 'S S S S S S S ?', 0, '');
}

=item get_basic_configuration()

Returns the configuration as set by :func:`Set Basic Configuration`.

=cut

sub get_basic_configuration
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_BASIC_CONFIGURATION, [], '', 23, 'S S S S S S S ?');
}

=item set_spreadcycle_configuration()

Note: If you don't know what any of this means you can very likely keep all of
the values as default!

Sets the Spreadcycle configuration parameters. Spreadcycle is a chopper algorithm which actively
controls the motor current flow. More information can be found in the TMC2130 datasheet on page
47 (7 spreadCycle and Classic Chopper).

* Slow Decay Duration: Controls duration of off time setting of slow decay phase.
  0 = driver disabled, all bridges off. Use 1 only with Comparator Blank time >= 2.

* Enable Random Slow Decay: Set to false to fix chopper off time as set by Slow Decay Duration.
  If you set it to true, Decay Duration is randomly modulated.

* Fast Decay Duration: Sets the fast decay duration. This parameters is
  only used if the Chopper Mode is set to Fast Decay.

* Hysteresis Start Value: Sets the hysteresis start value. This parameter is
  only used if the Chopper Mode is set to Spread Cycle.

* Hysteresis End Value: Sets the hysteresis end value. This parameter is
  only used if the Chopper Mode is set to Spread Cycle.

* Sine Wave Offset: Sets the sine wave offset. This parameters is
  only used if the Chopper Mode is set to Fast Decay. 1/512 of the value becomes added to the absolute
  value of the sine wave.

* Chopper Mode: 0 = Spread Cycle, 1 = Fast Decay.

* Comparator Blank Time: Sets the blank time of the comparator. Available values are

  * 0 = 16 clocks,
  * 1 = 24 clocks,
  * 2 = 36 clocks and
  * 3 = 54 clocks.

  A value of 1 or 2 is recommended for most applications.

* Fast Decay Without Comparator: If set to true the current comparator usage for termination of the
  fast decay cycle is disabled.

=cut

sub set_spreadcycle_configuration
{
	my ($self, $slow_decay_duration, $enable_random_slow_decay, $fast_decay_duration, $hysteresis_start_value, $hysteresis_end_value, $sine_wave_offset, $chopper_mode, $comparator_blank_time, $fast_decay_without_comparator) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_SPREADCYCLE_CONFIGURATION, [$slow_decay_duration, $enable_random_slow_decay, $fast_decay_duration, $hysteresis_start_value, $hysteresis_end_value, $sine_wave_offset, $chopper_mode, $comparator_blank_time, $fast_decay_without_comparator], 'C ? C C c c C C ?', 0, '');
}

=item get_spreadcycle_configuration()

Returns the configuration as set by :func:`Set Basic Configuration`.

=cut

sub get_spreadcycle_configuration
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_SPREADCYCLE_CONFIGURATION, [], '', 17, 'C ? C C c c C C ?');
}

=item set_stealth_configuration()

Note: If you don't know what any of this means you can very likely keep all of
the values as default!

Sets the configuration relevant for Stealth mode.

* Enable Stealth: If set to true the stealth mode is enabled, if set to false the
  stealth mode is disabled, even if the speed is below the threshold set in :func:`Set Basic Configuration`.

* Amplitude: If autoscale is disabled, the PWM amplitude is scaled by this value. If autoscale is enabled,
  this value defines the maximum PWM amplitude change per half wave.

* Gradient: If autoscale is disabled, the PWM gradient is scaled by this value. If autoscale is enabled,
  this value defines the maximum PWM gradient. With autoscale a value above 64 is recommended,
  otherwise the regulation might not be able to measure the current.

* Enable Autoscale: If set to true, automatic current control is used. Otherwise the user defined
  amplitude and gradient are used.

* Force Symmetric: If true, A symmetric PWM cycle is enforced. Otherwise the PWM value may change within each
  PWM cycle.

* Freewheel Mode: The freewheel mode defines the behavior in stand still if the Standstill Current
  (see :func:`Set Basic Configuration`) is set to 0.

=cut

sub set_stealth_configuration
{
	my ($self, $enable_stealth, $amplitude, $gradient, $enable_autoscale, $force_symmetric, $freewheel_mode) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_STEALTH_CONFIGURATION, [$enable_stealth, $amplitude, $gradient, $enable_autoscale, $force_symmetric, $freewheel_mode], '? C C ? ? C', 0, '');
}

=item get_stealth_configuration()

Returns the configuration as set by :func:`Set Stealth Configuration`.

=cut

sub get_stealth_configuration
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_STEALTH_CONFIGURATION, [], '', 14, '? C C ? ? C');
}

=item set_coolstep_configuration()

Note: If you don't know what any of this means you can very likely keep all of
the values as default!

Sets the configuration relevant for Coolstep.

* Minimum Stallguard Value: If the Stallguard result falls below this value*32, the motor current
  is increased to reduce motor load angle. A value of 0 turns Coolstep off.

* Maximum Stallguard Value: If the Stallguard result goes above
  (Min Stallguard Value + Max Stallguard Value + 1) * 32, the motor current is decreased to save
  energy.

* Current Up Step Width: Sets the up step increment per Stallguard value. The value range is 0-3,
  corresponding to the increments 1, 2, 4 and 8.

* Current Down Step Width: Sets the down step decrement per Stallguard value. The value range is 0-3,
  corresponding to the decrements 1, 2, 8 and 16.

* Minimum Current: Sets the minimum current for Coolstep current control. You can choose between
  half and quarter of the run current.

* Stallguard Threshold Value: Sets the level for stall output (see :func:`Get Driver Status`).
  A lower value gives a higher sensitivity. You have to find a suitable value for your
  motor by trial and error, 0 works for most motors.

* Stallguard Mode: Set to 0 for standard resolution or 1 for filtered mode. In filtered mode the Stallguard
  signal will be updated every four full-steps.

=cut

sub set_coolstep_configuration
{
	my ($self, $minimum_stallguard_value, $maximum_stallguard_value, $current_up_step_width, $current_down_step_width, $minimum_current, $stallguard_threshold_value, $stallguard_mode) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_COOLSTEP_CONFIGURATION, [$minimum_stallguard_value, $maximum_stallguard_value, $current_up_step_width, $current_down_step_width, $minimum_current, $stallguard_threshold_value, $stallguard_mode], 'C C C C C c C', 0, '');
}

=item get_coolstep_configuration()

Returns the configuration as set by :func:`Set Coolstep Configuration`.

=cut

sub get_coolstep_configuration
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_COOLSTEP_CONFIGURATION, [], '', 15, 'C C C C C c C');
}

=item set_misc_configuration()

Note: If you don't know what any of this means you can very likely keep all of
the values as default!

Sets miscellaneous configuration parameters.

* Disable Short To Ground Protection: Set to false to enable short to ground protection, otherwise
  it is disabled.

* Synchronize Phase Frequency: With this parameter you can synchronize the chopper for both phases
  of a two phase motor to avoid the occurrence of a beat. The value range is 0-15. If set to 0,
  the synchronization is turned off. Otherwise the synchronization is done through the formula
  f_sync = f_clk/(value*64). In Classic Mode the synchronization is automatically switched off.
  f_clk is 12.8MHz.

=cut

sub set_misc_configuration
{
	my ($self, $disable_short_to_ground_protection, $synchronize_phase_frequency) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_MISC_CONFIGURATION, [$disable_short_to_ground_protection, $synchronize_phase_frequency], '? C', 0, '');
}

=item get_misc_configuration()

Returns the configuration as set by :func:`Set Misc Configuration`.

=cut

sub get_misc_configuration
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_MISC_CONFIGURATION, [], '', 10, '? C');
}

=item set_error_led_config()

Configures the error LED to be either turned off, turned on, blink in
heartbeat mode or show an error.

If the LED is configured to show errors it has three different states:

* Off: No error present.
* 250ms interval blink: Overtemperature warning.
* 1s interval blink: Input voltage too small.
* full red: motor disabled because of short to ground in phase a or b or because of overtemperature.

=cut

sub set_error_led_config
{
	my ($self, $config) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_ERROR_LED_CONFIG, [$config], 'C', 0, '');
}

=item get_error_led_config()

Returns the LED configuration as set by :func:`Set Error LED Config`

=cut

sub get_error_led_config
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_ERROR_LED_CONFIG, [], '', 9, 'C');
}

=item get_driver_status()

Returns the current driver status.

* Open Load: Indicates if an open load is present on phase A, B or both. This could mean that there is a problem
  with the wiring of the motor. False detection can occur in fast motion as well as during stand still.

* Short To Ground: Indicates if a short to ground is present on phase A, B or both. If this is detected the driver
  automatically becomes disabled and stays disabled until it is enabled again manually.

* Over Temperature: The over temperature indicator switches to "Warning" if the driver IC warms up. The warning flag
  is expected during long duration stepper uses. If the temperature limit is reached the indicator switches
  to "Limit". In this case the driver becomes disabled until it cools down again.

* Motor Stalled: Is true if a motor stall was detected.

* Actual Motor Current: Indicates the actual current control scaling as used in Coolstep mode.
  It represents a multiplier of 1/32 to 32/32 of the
  ``Motor Run Current`` as set by :func:`Set Basic Configuration`. Example: If a ``Motor Run Current``
  of 1000mA was set and the returned value is 15, the ``Actual Motor Current`` is 16/32*1000mA = 500mA.

* Stallguard Result: Indicates the load of the motor. A lower value signals a higher load. Per trial and error
  you can find out which value corresponds to a suitable torque for the velocity used in your application.
  After that you can use this threshold value to find out if a motor stall becomes probable and react on it (e.g.
  decrease velocity).
  During stand still this value can not be used for stall detection, it shows the chopper on-time for motor coil A.

* Stealth Voltage Amplitude: Shows the actual PWM scaling. In Stealth mode it can be used to detect motor load and
  stall if autoscale is enabled (see :func:`Set Stealth Configuration`).

=cut

sub get_driver_status
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_DRIVER_STATUS, [], '', 16, 'C C C ? C ? C C');
}

=item set_minimum_voltage()

Sets the minimum voltage, below which the :cb:`Under Voltage` callback
is triggered. The minimum possible value that works with the Silent Stepper
Bricklet 2.0 is 8V.
You can use this function to detect the discharge of a battery that is used
to drive the stepper motor. If you have a fixed power supply, you likely do
not need this functionality.

=cut

sub set_minimum_voltage
{
	my ($self, $voltage) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_MINIMUM_VOLTAGE, [$voltage], 'S', 0, '');
}

=item get_minimum_voltage()

Returns the minimum voltage as set by :func:`Set Minimum Voltage`.

=cut

sub get_minimum_voltage
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_MINIMUM_VOLTAGE, [], '', 10, 'S');
}

=item set_time_base()

Sets the time base of the velocity and the acceleration of the Silent Stepper
Bricklet 2.0.

For example, if you want to make one step every 1.5 seconds, you can set
the time base to 15 and the velocity to 10. Now the velocity is
10steps/15s = 1steps/1.5s.

=cut

sub set_time_base
{
	my ($self, $time_base) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_TIME_BASE, [$time_base], 'L', 0, '');
}

=item get_time_base()

Returns the time base as set by :func:`Set Time Base`.

=cut

sub get_time_base
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_TIME_BASE, [], '', 12, 'L');
}

=item get_all_data()

Returns the following parameters: The current velocity,
the current position, the remaining steps, the stack voltage, the external
voltage and the current consumption of the stepper motor.

The current consumption is calculated by multiplying the ``Actual Motor Current``
value (see :func:`Set Basic Configuration`) with the ``Motor Run Current``
(see :func:`Get Driver Status`). This is an internal calculation of the
driver, not an independent external measurement.

The current consumption calculation was broken up to firmware 2.0.1, it is fixed
since firmware 2.0.2.

There is also a callback for this function, see :cb:`All Data` callback.

=cut

sub get_all_data
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_ALL_DATA, [], '', 22, 'S l l S S');
}

=item set_all_callback_configuration()

Sets the period with which the :cb:`All Data` callback is triggered
periodically. A value of 0 turns the callback off.

=cut

sub set_all_callback_configuration
{
	my ($self, $period) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_ALL_CALLBACK_CONFIGURATION, [$period], 'L', 0, '');
}

=item get_all_data_callback_configuraton()

Returns the period as set by :func:`Set All Callback Configuration`.

=cut

sub get_all_data_callback_configuraton
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_ALL_DATA_CALLBACK_CONFIGURATON, [], '', 12, 'L');
}

=item set_gpio_configuration()

Sets the GPIO configuration for the given channel.
You can configure a debounce and the deceleration that is used if the action is
configured as ``normal stop``. See :func:`Set GPIO Action`.

=cut

sub set_gpio_configuration
{
	my ($self, $channel, $debounce, $stop_deceleration) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_GPIO_CONFIGURATION, [$channel, $debounce, $stop_deceleration], 'C S S', 0, '');
}

=item get_gpio_configuration()

Returns the GPIO configuration for a channel as set by :func:`Set GPIO Configuration`.

=cut

sub get_gpio_configuration
{
	my ($self, $channel) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_GPIO_CONFIGURATION, [$channel], 'C', 12, 'S S');
}

=item set_gpio_action()

Sets the GPIO action for the given channel.

The action can be a normal stop, a full brake or a callback. Each for a rising
edge or falling edge. The actions are a bitmask they can be used at the same time.
You can for example trigger a full brake and a callback at the same time or for
rising and falling edge.

The deceleration speed for the normal stop can be configured with
:func:`Set GPIO Configuration`.

=cut

sub set_gpio_action
{
	my ($self, $channel, $action) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_GPIO_ACTION, [$channel, $action], 'C L', 0, '');
}

=item get_gpio_action()

Returns the GPIO action for a channel as set by :func:`Set GPIO Action`.

=cut

sub get_gpio_action
{
	my ($self, $channel) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_GPIO_ACTION, [$channel], 'C', 12, 'L');
}

=item get_gpio_state()

Returns the GPIO state for both channels. True if the state is ``high`` and
false if the state is ``low``.

=cut

sub get_gpio_state
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_GPIO_STATE, [], '', 9, '?2');
}

=item get_spitfp_error_count()

Returns the error count for the communication between Brick and Bricklet.

The errors are divided into

* ACK checksum errors,
* message checksum errors,
* framing errors and
* overflow errors.

The errors counts are for errors that occur on the Bricklet side. All
Bricks have a similar function that returns the errors on the Brick side.

=cut

sub get_spitfp_error_count
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_SPITFP_ERROR_COUNT, [], '', 24, 'L L L L');
}

=item set_bootloader_mode()

Sets the bootloader mode and returns the status after the requested
mode change was instigated.

You can change from bootloader mode to firmware mode and vice versa. A change
from bootloader mode to firmware mode will only take place if the entry function,
device identifier and CRC are present and correct.

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub set_bootloader_mode
{
	my ($self, $mode) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_SET_BOOTLOADER_MODE, [$mode], 'C', 9, 'C');
}

=item get_bootloader_mode()

Returns the current bootloader mode, see :func:`Set Bootloader Mode`.

=cut

sub get_bootloader_mode
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_BOOTLOADER_MODE, [], '', 9, 'C');
}

=item set_write_firmware_pointer()

Sets the firmware pointer for :func:`Write Firmware`. The pointer has
to be increased by chunks of size 64. The data is written to flash
every 4 chunks (which equals to one page of size 256).

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub set_write_firmware_pointer
{
	my ($self, $pointer) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_WRITE_FIRMWARE_POINTER, [$pointer], 'L', 0, '');
}

=item write_firmware()

Writes 64 Bytes of firmware at the position as written by
:func:`Set Write Firmware Pointer` before. The firmware is written
to flash every 4 chunks.

You can only write firmware in bootloader mode.

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub write_firmware
{
	my ($self, $data) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_WRITE_FIRMWARE, [$data], 'C64', 9, 'C');
}

=item set_status_led_config()

Sets the status LED configuration. By default the LED shows
communication traffic between Brick and Bricklet, it flickers once
for every 10 received data packets.

You can also turn the LED permanently on/off or show a heartbeat.

If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.

=cut

sub set_status_led_config
{
	my ($self, $config) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_STATUS_LED_CONFIG, [$config], 'C', 0, '');
}

=item get_status_led_config()

Returns the configuration as set by :func:`Set Status LED Config`

=cut

sub get_status_led_config
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_STATUS_LED_CONFIG, [], '', 9, 'C');
}

=item get_chip_temperature()

Returns the temperature as measured inside the microcontroller. The
value returned is not the ambient temperature!

The temperature is only proportional to the real temperature and it has bad
accuracy. Practically it is only useful as an indicator for
temperature changes.

=cut

sub get_chip_temperature
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_CHIP_TEMPERATURE, [], '', 10, 's');
}

=item reset()

Calling this function will reset the Bricklet. All configurations
will be lost.

After a reset you have to create new device objects,
calling functions on the existing ones will result in
undefined behavior!

=cut

sub reset
{
	my ($self) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_RESET, [], '', 0, '');
}

=item write_uid()

Writes a new UID into flash. If you want to set a new UID
you have to decode the Base58 encoded UID string into an
integer first.

We recommend that you use Brick Viewer to change the UID.

=cut

sub write_uid
{
	my ($self, $uid) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_WRITE_UID, [$uid], 'L', 0, '');
}

=item read_uid()

Returns the current UID as an integer. Encode as
Base58 to get the usual string version.

=cut

sub read_uid
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_READ_UID, [], '', 12, 'L');
}

=item get_identity()

Returns the UID, the UID where the Bricklet is connected to,
the position, the hardware and firmware version as well as the
device identifier.

The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
A Bricklet connected to an :ref:`Isolator Bricklet <isolator_bricklet>` is always at
position 'z'.

The device identifier numbers can be found :ref:`here <device_identifier>`.
|device_identifier_constant|

=cut

sub get_identity
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_IDENTITY, [], '', 33, 'Z8 Z8 a C3 C3 S');
}

=back
=cut

1;
