.rn '' }`
''' $RCSfile$$Revision$$Date$
'''
''' $Log$
'''
.de Sh
.br
.if t .Sp
.ne 5
.PP
\fB\\$1\fR
.PP
..
.de Sp
.if t .sp .5v
.if n .sp
..
.de Ip
.br
.ie \\n(.$>=3 .ne \\$3
.el .ne 3
.IP "\\$1" \\$2
..
.de Vb
.ft CW
.nf
.ne \\$1
..
.de Ve
.ft R

.fi
..
'''
'''
'''     Set up \*(-- to give an unbreakable dash;
'''     string Tr holds user defined translation string.
'''     Bell System Logo is used as a dummy character.
'''
.tr \(*W-|\(bv\*(Tr
.ie n \{\
.ds -- \(*W-
.ds PI pi
.if (\n(.H=4u)&(1m=24u) .ds -- \(*W\h'-12u'\(*W\h'-12u'-\" diablo 10 pitch
.if (\n(.H=4u)&(1m=20u) .ds -- \(*W\h'-12u'\(*W\h'-8u'-\" diablo 12 pitch
.ds L" ""
.ds R" ""
.ds L' '
.ds R' '
'br\}
.el\{\
.ds -- \(em\|
.tr \*(Tr
.ds L" ``
.ds R" ''
.ds L' `
.ds R' '
.ds PI \(*p
'br\}
.\"	If the F register is turned on, we'll generate
.\"	index entries out stderr for the following things:
.\"		TH	Title 
.\"		SH	Header
.\"		Sh	Subsection 
.\"		Ip	Item
.\"		X<>	Xref  (embedded
.\"	Of course, you have to process the output yourself
.\"	in some meaninful fashion.
.if \nF \{
.de IX
.tm Index:\\$1\t\\n%\t"\\$2"
..
.nr % 0
.rr F
.\}
.TH PERLTOOT 1 "perl 5.003, patch 11" "8/Jan/97" "Perl Programmers Reference Guide"
.IX Title "PERLTOOT 1"
.UC
.IX Name "perltoot - Tom's object-oriented tutorial for perl (rev 0.6)"
.if n .hy 0
.if n .na
.ds C+ C\v'-.1v'\h'-1p'\s-2+\h'-1p'+\s0\v'.1v'\h'-1p'
.de CQ          \" put $1 in typewriter font
.ft CW
'if n "\c
'if t \\&\\$1\c
'if n \\&\\$1\c
'if n \&"
\\&\\$2 \\$3 \\$4 \\$5 \\$6 \\$7
'.ft R
..
.\" @(#)ms.acc 1.5 88/02/08 SMI; from UCB 4.2
.	\" AM - accent mark definitions
.bd B 3
.	\" fudge factors for nroff and troff
.if n \{\
.	ds #H 0
.	ds #V .8m
.	ds #F .3m
.	ds #[ \f1
.	ds #] \fP
.\}
.if t \{\
.	ds #H ((1u-(\\\\n(.fu%2u))*.13m)
.	ds #V .6m
.	ds #F 0
.	ds #[ \&
.	ds #] \&
.\}
.	\" simple accents for nroff and troff
.if n \{\
.	ds ' \&
.	ds ` \&
.	ds ^ \&
.	ds , \&
.	ds ~ ~
.	ds ? ?
.	ds ! !
.	ds /
.	ds q
.\}
.if t \{\
.	ds ' \\k:\h'-(\\n(.wu*8/10-\*(#H)'\'\h"|\\n:u"
.	ds ` \\k:\h'-(\\n(.wu*8/10-\*(#H)'\`\h'|\\n:u'
.	ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'^\h'|\\n:u'
.	ds , \\k:\h'-(\\n(.wu*8/10)',\h'|\\n:u'
.	ds ~ \\k:\h'-(\\n(.wu-\*(#H-.1m)'~\h'|\\n:u'
.	ds ? \s-2c\h'-\w'c'u*7/10'\u\h'\*(#H'\zi\d\s+2\h'\w'c'u*8/10'
.	ds ! \s-2\(or\s+2\h'-\w'\(or'u'\v'-.8m'.\v'.8m'
.	ds / \\k:\h'-(\\n(.wu*8/10-\*(#H)'\z\(sl\h'|\\n:u'
.	ds q o\h'-\w'o'u*8/10'\s-4\v'.4m'\z\(*i\v'-.4m'\s+4\h'\w'o'u*8/10'
.\}
.	\" troff and (daisy-wheel) nroff accents
.ds : \\k:\h'-(\\n(.wu*8/10-\*(#H+.1m+\*(#F)'\v'-\*(#V'\z.\h'.2m+\*(#F'.\h'|\\n:u'\v'\*(#V'
.ds 8 \h'\*(#H'\(*b\h'-\*(#H'
.ds v \\k:\h'-(\\n(.wu*9/10-\*(#H)'\v'-\*(#V'\*(#[\s-4v\s0\v'\*(#V'\h'|\\n:u'\*(#]
.ds _ \\k:\h'-(\\n(.wu*9/10-\*(#H+(\*(#F*2/3))'\v'-.4m'\z\(hy\v'.4m'\h'|\\n:u'
.ds . \\k:\h'-(\\n(.wu*8/10)'\v'\*(#V*4/10'\z.\v'-\*(#V*4/10'\h'|\\n:u'
.ds 3 \*(#[\v'.2m'\s-2\&3\s0\v'-.2m'\*(#]
.ds o \\k:\h'-(\\n(.wu+\w'\(de'u-\*(#H)/2u'\v'-.3n'\*(#[\z\(de\v'.3n'\h'|\\n:u'\*(#]
.ds d- \h'\*(#H'\(pd\h'-\w'~'u'\v'-.25m'\f2\(hy\fP\v'.25m'\h'-\*(#H'
.ds D- D\\k:\h'-\w'D'u'\v'-.11m'\z\(hy\v'.11m'\h'|\\n:u'
.ds th \*(#[\v'.3m'\s+1I\s-1\v'-.3m'\h'-(\w'I'u*2/3)'\s-1o\s+1\*(#]
.ds Th \*(#[\s+2I\s-2\h'-\w'I'u*3/5'\v'-.3m'o\v'.3m'\*(#]
.ds ae a\h'-(\w'a'u*4/10)'e
.ds Ae A\h'-(\w'A'u*4/10)'E
.ds oe o\h'-(\w'o'u*4/10)'e
.ds Oe O\h'-(\w'O'u*4/10)'E
.	\" corrections for vroff
.if v .ds ~ \\k:\h'-(\\n(.wu*9/10-\*(#H)'\s-2\u~\d\s+2\h'|\\n:u'
.if v .ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'\v'-.4m'^\v'.4m'\h'|\\n:u'
.	\" for low resolution devices (crt and lpr)
.if \n(.H>23 .if \n(.V>19 \
\{\
.	ds : e
.	ds 8 ss
.	ds v \h'-1'\o'\(aa\(ga'
.	ds _ \h'-1'^
.	ds . \h'-1'.
.	ds 3 3
.	ds o a
.	ds d- d\h'-1'\(ga
.	ds D- D\h'-1'\(hy
.	ds th \o'bp'
.	ds Th \o'LP'
.	ds ae ae
.	ds Ae AE
.	ds oe oe
.	ds Oe OE
.\}
.rm #[ #] #H #V #F C
.SH "NAME"
.IX Header "NAME"
perltoot \- Tom's object-oriented tutorial for perl (rev 0.6)
.SH "DESCRIPTION"
.IX Header "DESCRIPTION"
Object-oriented programming is a big seller these days.  Some managers
would rather have objects than sliced bread.  Why is that?  What's so
special about an object?  Just what \fIis\fR an object anyway?
.PP
An object is nothing but a way of tucking away complex behaviours into
a neat little easy-to-use bundle.  (This is what professors call
abstraction.) Smart people who have nothing to do but sit around for
weeks on end figuring out really hard problems make these nifty
objects that even regular people can use. (This is what professors call
software reuse.)  Users (well, programmers) can play with this little
bundle all they want, but they aren't to open it up and mess with the
insides.  Just like an expensive piece of hardware, the contract says
that you void the warranty if you muck with the cover.  So don't do that.
.PP
The heart of objects is the class, a protected little private namespace
full of data and functions.  A class is a set of related routines that
addresses some problem area.  You can think of it as a user-defined type.
The Perl package mechanism, also used for more traditional modules,
is used for class modules as well.  Objects \*(L"live\*(R" in a class, meaning
that they belong to some package.
.PP
More often than not, the class provides the user with little bundles.
These bundles are objects.  They know whose class they belong to,
and how to behave.  Users ask the class to do something, like \*(L"give
me an object.\*(R"  Or they can ask one of these objects to do something.
Asking a class to do something for you is calling a \fIclass method\fR.
Asking an object to do something for you is calling an \fIobject method\fR.
Asking either a class (usually) or an object (sometimes) to give you
back an object is calling a \fIconstructor\fR, which is just a
kind of method.
.PP
That's all well and good, but how is an object different from any other
Perl data type?  Just what is an object \fIreally\fR; that is, what's its
fundamental type?  The answer to the first question is easy.  An object
is different from any other data type in Perl in one and only one way:
you may dereference it using not merely string or numeric subscripts
as with simple arrays and hashes, but with named subroutine calls.
In a word, with \fImethods\fR.
.PP
The answer to the second question is that it's a reference, and not just
any reference, mind you, but one whose referent has been \fIbless\fR()ed
into a particular class (read: package).  What kind of reference?  Well,
the answer to that one is a bit less concrete.  That's because in Perl
the designer of the class can employ any sort of reference they'd like
as the underlying intrinsic data type.  It could be a scalar, an array,
or a hash reference.  It could even be a code reference.  But because
of its inherent flexibility, an object is usually a hash reference.
.SH "Creating a Class"
.IX Header "Creating a Class"
Before you create a class, you need to decide what to name it.  That's
because the class (package) name governs the name of the file used to
house it, just as with regular modules.  Then, that class (package)
should provide one or more ways to generate objects.  Finally, it should
provide mechanisms to allow users of its objects to indirectly manipulate
these objects from a distance.
.PP
For example, let's make a simple Person class module.  It gets stored in
the file Person.pm.  If it were called a Happy::Person class, it would
be stored in the file Happy/Person.pm, and its package would become
Happy::Person instead of just Person.  (On a personal computer not
running Unix or Plan 9, but something like MacOS or VMS, the directory
separator may be different, but the principle is the same.)  Do not assume
any formal relationship between modules based on their directory names.
This is merely a grouping convenience, and has no effect on inheritance,
variable accessibility, or anything else.
.PP
For this module we aren't going to use Exporter, because we're
a well-behaved class module that doesn't export anything at all.
In order to manufacture objects, a class needs to have a \fIconstructor
method\fR.  A constructor gives you back not just a regular data type,
but a brand-new object in that class.  This magic is taken care of by
the \fIbless()\fR function, whose sole purpose is to enable its referent to
be used as an object.  Remember: being an object really means nothing
more than that methods may now be called against it.
.PP
While a constructor may be named anything you'd like, most Perl
programmers seem to like to call theirs \fInew()\fR.  However, \fInew()\fR is not
a reserved word, and a class is under no obligation to supply such.
Some programmers have also been known to use a function with
the same name as the class as the constructor.
.Sh "Object Representation"
.IX Subsection "Object Representation"
By far the most common mechanism used in Perl to represent a Pascal
record, a C struct, or a \*(C+ class an anonymous hash.  That's because a
hash has an arbitrary number of data fields, each conveniently accessed by
an arbitrary name of your own devising.
.PP
If you were just doing a simple
struct-like emulation, you would likely go about it something like this:
.PP
.Vb 5
\&    $rec = {
\&        name  => "Jason",
\&        age   => 23,
\&        peers => [ "Norbert", "Rhys", "Phineas"],
\&    };
.Ve
If you felt like it, you could add a bit of visual distinction
by up-casing the hash keys:
.PP
.Vb 5
\&    $rec = {
\&        NAME  => "Jason",
\&        AGE   => 23,
\&        PEERS => [ "Norbert", "Rhys", "Phineas"],
\&    };
.Ve
And so you could get at \f(CW$rec->{NAME}\fR to find \*(L"Jason\*(R", or
\f(CW@{ \f(CW$rec\fR->{PEERS} }\fR to get at \*(L"Norbert\*(R", \*(L"Rhys\*(R", and \*(L"Phineas\*(R".
(Have you ever noticed how many 23-year-old programmers seem to
be named \*(L"Jason\*(R" these days? :\-)
.PP
This same model is often used for classes, although it is not considered
the pinnacle of programming propriety for folks from outside the
class to come waltzing into an object, brazenly accessing its data
members directly.  Generally speaking, an object should be considered
an opaque cookie that you use \fIobject methods\fR to access.  Visually,
methods look like you're dereffing a reference using a function name
instead of brackets or braces.
.Sh "Class Interface"
.IX Subsection "Class Interface"
Some languages provide a formal syntactic interface to a class's methods,
but Perl does not.  It relies on you to read the documentation of each
class.  If you try to call an undefined method on an object, Perl won't
complain, but the program will trigger an exception while it's running.
Likewise, if you call a method expecting a prime number as its argument
with an even one instead, you can't expect the compiler to catch this.
(Well, you can expect it all you like, but it's not going to happen.)
.PP
Let's suppose you have a well-educated user of your Person class,
someone who has read the docs that explain the prescribed
interface.  Here's how they might use the Person class:
.PP
.Vb 1
\&    use Person;
.Ve
.Vb 4
\&    $him = Person->new();
\&    $him->name("Jason");
\&    $him->age(23);
\&    $him->peers( "Norbert", "Rhys", "Phineas" );
.Ve
.Vb 1
\&    push @All_Recs, $him;  # save object in array for later
.Ve
.Vb 2
\&    printf "%s is %d years old.\en", $him->name, $him->age;
\&    print "His peers are: ", join(", ", $him->peers), "\en";
.Ve
.Vb 1
\&    printf "Last rec's name is %s\en", $All_Recs[-1]->name;
.Ve
As you can see, the user of the class doesn't know (or at least, has no
business paying attention to the fact) that the object has one particular
implementation or another.  The interface to the class and its objects
is exclusively via methods, and that's all the user of the class should
ever play with.
.Sh "Constructors and Instance Methods"
.IX Subsection "Constructors and Instance Methods"
Still, \fIsomeone\fR has to know what's in the object.  And that someone is
the class.  It implements methods that the programmer uses to access
the object.  Here's how to implement the Person class using the standard
hash-ref-as-an-object idiom.  We'll make a class method called \fInew()\fR to
act as the constructor, and three object methods called \fIname()\fR, \fIage()\fR, and
\fIpeers()\fR to get at per-object data hidden away in our anonymous hash.
.PP
.Vb 2
\&    package Person;
\&    use strict;
.Ve
.Vb 11
\&    ##################################################
\&    ## the object constructor (simplistic version)  ##
\&    ##################################################
\&    sub new {
\&        my $self  = {};
\&        $self->{NAME}   = undef;
\&        $self->{AGE}    = undef;
\&        $self->{PEERS}  = [];
\&        bless($self);           # but see below
\&        return $self;
\&    }
.Ve
.Vb 6
\&    ##############################################
\&    ## methods to access per-object data        ##
\&    ##                                          ##
\&    ## With args, they set the value.  Without  ##
\&    ## any, they only retrieve it/them.         ##
\&    ##############################################
.Ve
.Vb 5
\&    sub name {
\&        my $self = shift;
\&        if (@_) { $self->{NAME} = shift }
\&        return $self->{NAME};
\&    }
.Ve
.Vb 5
\&    sub age {
\&        my $self = shift;
\&        if (@_) { $self->{AGE} = shift }
\&        return $self->{AGE};
\&    }
.Ve
.Vb 5
\&    sub peers {
\&        my $self = shift;
\&        if (@_) { @{ $self->{PEERS} } = @_ }
\&        return @{ $self->{PEERS} };
\&    }
.Ve
.Vb 1
\&    1;  # so the require or use succeeds
.Ve
We've created three methods to access an object's data, \fIname()\fR, \fIage()\fR,
and \fIpeers()\fR.  These are all substantially similar.  If called with an
argument, they set the appropriate field; otherwise they return the
value held by that field, meaning the value of that hash key.
.Sh "Planning for the Future: Better Constructors"
.IX Subsection "Planning for the Future: Better Constructors"
Even though at this point you may not even know what it means, someday
you're going to worry about inheritance.  (You can safely ignore this
for now and worry about it later if you'd like.)  To ensure that this
all works out smoothly, you must use the double-argument form of \fIbless()\fR.
The second argument is the class into which the referent will be blessed.
By not assuming our own class as the default second argument and instead
using the class passed into us, we make our constructor inheritable.
.PP
While we're at it, let's make our constructor a bit more flexible.
Rather than being uniquely a class method, we'll set it up so that
it can be called as either a class method \fIor\fR an object
method.  That way you can say:
.PP
.Vb 2
\&    $me  = Person->new();
\&    $him = $me->new();
.Ve
To do this, all we have to do is check whether what was passed in
was a reference or not.  If so, we were invoked as an object method,
and we need to extract the package (class) using the \fIref()\fR function.
If not, we just use the string passed in as the package name
for blessing our referent.
.PP
.Vb 10
\&    sub new {
\&        my $proto = shift;
\&        my $class = ref($proto) || $proto;
\&        my $self  = {};
\&        $self->{NAME}   = undef;
\&        $self->{AGE}    = undef;
\&        $self->{PEERS}  = [];
\&        bless ($self, $class);
\&        return $self;
\&    }
.Ve
That's about all there is for constructors.  These methods bring objects
to life, returning neat little opaque bundles to the user to be used in
subsequent method calls.
.Sh "Destructors"
.IX Subsection "Destructors"
Every story has a beginning and an end.  The beginning of the object's
story is its constructor, explicitly called when the object comes into
existence.  But the ending of its story is the \fIdestructor\fR, a method
implicitly called when an object leaves this life.  Any per-object
clean-up code is placed in the destructor, which must (in Perl) be called
\s-1DESTROY\s0.
.PP
If constructors can have arbitrary names, then why not destructors?
Because while a constructor is explicitly called, a destructor is not.
Destruction happens automatically via Perl's garbage collection (\s-1GC\s0)
system, which is a quick but somewhat lazy reference-based \s-1GC\s0 system.
To know what to call, Perl insists that the destructor be named \s-1DESTROY\s0.
.PP
Why is \s-1DESTROY\s0 in all caps?  Perl on occasion uses purely upper-case
function names as a convention to indicate that the function will
be automatically called by Perl in some way.  Others that are called
implicitly include \s-1BEGIN\s0, \s-1END\s0, \s-1AUTOLOAD\s0, plus all methods used by
tied objects, described in the \fIperltie\fR manpage.
.PP
In really good object-oriented programming languages, the user doesn't
care when the destructor is called.  It just happens when it's supposed
to.  In low-level languages without any \s-1GC\s0 at all, there's no way to
depend on this happening at the right time, so the programmer must
explicitly call the destructor to clean up memory and state, crossing
their fingers that it's the right time to do so.   Unlike \*(C+, an
object destructor is nearly never needed in Perl, and even when it is,
explicit invocation is uncalled for.  In the case of our Person class,
we don't need a destructor because Perl takes care of simple matters
like memory deallocation.
.PP
The only situation where Perl's reference-based \s-1GC\s0 won't work is
when there's a circularity in the data structure, such as:
.PP
.Vb 1
\&    $this->{WHATEVER} = $this;
.Ve
In that case, you must delete the self-reference manually if you expect
your program not to leak memory.  While admittedly error-prone, this is
the best we can do right now.  Nonetheless, rest assured that when your
program is finished, its objects\*(R' destructors are all duly called.
So you are guaranteed that an object \fIeventually\fR gets properly
destroyed, except in the unique case of a program that never exits.
(If you're running Perl embedded in another application, this full \s-1GC\s0
pass happens a bit more frequently\*(--whenever a thread shuts down.)
.Sh "Other Object Methods"
.IX Subsection "Other Object Methods"
The methods we've talked about so far have either been constructors or
else simple \*(L"data methods\*(R", interfaces to data stored in the object.
These are a bit like an object's data members in the \*(C+ world, except
that strangers don't access them as data.  Instead, they should only
access the object's data indirectly via its methods.  This is an
important rule: in Perl, access to an object's data should \fIonly\fR
be made through methods.
.PP
Perl doesn't impose restrictions on who gets to use which methods.
The public-versus-private distinction is by convention, not syntax.
(Well, unless you use the Alias module described below in the section on \fI/"Data Members
as Variables\fR.)  Occasionally you'll see method names beginning or ending
with an underscore or two.  This marking is a convention indicating
that the methods are private to that class alone and sometimes to its
closest acquaintances, its immediate subclasses.  But this distinction
is not enforced by Perl itself.  It's up to the programmer to behave.
.PP
There's no reason to limit methods to those that simply access data.
Methods can do anything at all.  The key point is that they're invoked
against an object or a class.  Let's say we'd like object methods that
do more than fetch or set one particular field.
.PP
.Vb 5
\&    sub exclaim {
\&        my $self = shift;
\&        return sprintf "Hi, I'm %s, age %d, working with %s",
\&            $self->{NAME}, $self->{AGE}, join(", ", $self->{PEERS});
\&    }
.Ve
Or maybe even one like this:
.PP
.Vb 4
\&    sub happy_birthday {
\&        my $self = shift;
\&        return ++$self->{AGE};
\&    }
.Ve
Some might argue that one should go at these this way:
.PP
.Vb 5
\&    sub exclaim {
\&        my $self = shift;
\&        return sprintf "Hi, I'm %s, age %d, working with %s",
\&            $self->name, $self->age, join(", ", $self->peers);
\&    }
.Ve
.Vb 4
\&    sub happy_birthday {
\&        my $self = shift;
\&        return $self->age( $self->age() + 1 );
\&    }
.Ve
But since these methods are all executing in the class itself, this
may not be critical.  There are trade-offs to be made.  Using direct
hash access is faster (about an order of magnitude faster, in fact), and
it's more convenient when you want to interpolate in strings.  But using
methods (the external interface) internally shields not just the users of
your class but even you yourself from changes in your data representation.
.SH "Class Data"
.IX Header "Class Data"
What about \*(L"class data\*(R", data items common to each object in a class?
What would you want that for?  Well, in your Person class, you might
like to keep track of the total people alive.  How do you implement that?
.PP
You \fIcould\fR make it a global variable called \f(CW$Person::Census\fR.  But about
only reason you'd do that would be if you \fIwanted\fR people to be able to
get at your class data directly.  They could just say \f(CW$Person::Census\fR
and play around with it.  Maybe this is ok in your design scheme.
You might even conceivably want to make it an exported variable.  To be
exportable, a variable must be a (package) global.  If this were a
traditional module rather than an object-oriented one, you might do that.
.PP
While this approach is expected in most traditional modules, it's
generally considered rather poor form in most object modules.  In an
object module, you should set up a protective veil to separate interface
from implementation.  So provide a class method to access class data
just as you provide object methods to access object data.
.PP
So, you \fIcould\fR still keep \f(CW$Census\fR as a package global and rely upon
others to honor the contract of the module and therefore not play around
with its implementation.  You could even be supertricky and make \f(CW$Census\fR a
tied object as described in the \fIperltie\fR manpage, thereby intercepting all accesses.
.PP
But more often than not, you just want to make your class data a
file-scoped lexical.  To do so, simply put this at the top of the file:
.PP
.Vb 1
\&    my $Census = 0;
.Ve
Even though the scope of a \fImy()\fR normally expires when the block in which
it was declared is done (in this case the whole file being required or
used), Perl's deep binding of lexical variables guarantees that the
variable will not be deallocated, remaining accessible to functions
declared within that scope.  This doesn't work with global variables
given temporary values via \fIlocal()\fR, though.
.PP
Irrespective of whether you leave \f(CW$Census\fR a package global or make
it instead a file-scoped lexical, you should make these
changes to your \fIPerson::new()\fR constructor:
.PP
.Vb 11
\&    sub new {
\&        my $proto = shift;
\&        my $class = ref($proto) || $proto;
\&        my $self  = {};
\&        $Census++;
\&        $self->{NAME}   = undef;
\&        $self->{AGE}    = undef;
\&        $self->{PEERS}  = [];
\&        bless ($self, $class);
\&        return $self;
\&    }
.Ve
.Vb 3
\&    sub population {
\&        return $Census;
\&    }
.Ve
Now that we've done this, we certainly do need a destructor so that
when Person is destroyed, the \f(CW$Census\fR goes down.  Here's how
this could be done:
.PP
.Vb 1
\&    sub DESTROY { --$Census }
.Ve
Notice how there's no memory to deallocate in the destructor?  That's
something that Perl takes care of for you all by itself.
.Sh "Accessing Class Data"
.IX Subsection "Accessing Class Data"
It turns out that this is not really a good way to go about handling
class data.  A good scalable rule is that \fIyou must never reference class
data directly from an object method\fR.  Otherwise you aren't building a
scalable, inheritable class.  The object must be the rendezvous point
for all operations, especially from an object method.  The globals
(class data) would in some sense be in the \*(L"wrong\*(R" package in your
derived classes.  In Perl, methods execute in the context of the class
they were defined in, \fInot\fR that of the object that triggered them.
Therefore, namespace visibility of package globals in methods is unrelated
to inheritance.
.PP
Got that?  Maybe not.  Ok, let's say that some other class \*(L"borrowed\*(R"
(well, inherited) the \s-1DESTROY\s0 method as it was defined above.  When those
objects are destructed, the original \f(CW$Census\fR variable will be altered,
not the one in the new class's package namespace.  Perhaps this is what
you want, but probably it isn't.
.PP
Here's how to fix this.  We'll store a reference to the data in the
value accessed by the hash key \*(L"_CENSUS\*(R".  Why the underscore?  Well,
mostly because an initial underscore already conveys strong feelings
of magicalness to a C programmer.  It's really just a mnemonic device
to remind ourselves that this field is special and not to be used as
a public data member in the same way that \s-1NAME\s0, \s-1AGE\s0, and \s-1PEERS\s0 are.
(Because we've been developing this code under the strict pragma, prior
to 5.004 we'll have to quote the field name.)
.PP
.Vb 13
\&    sub new {
\&        my $proto = shift;
\&        my $class = ref($proto) || $proto;
\&        my $self  = {};
\&        $self->{NAME}     = undef;
\&        $self->{AGE}      = undef;
\&        $self->{PEERS}    = [];
\&        # "private" data
\&        $self->{"_CENSUS"} = \e$Census;
\&        bless ($self, $class);
\&        ++ ${ $self->{"_CENSUS"} };
\&        return $self;
\&    }
.Ve
.Vb 8
\&    sub population {
\&        my $self = shift;
\&        if (ref $self) {
\&            return ${ $self->{"_CENSUS"} };
\&        } else {
\&            return $Census;
\&        }
\&    }
.Ve
.Vb 4
\&    sub DESTROY {
\&        my $self = shift;
\&        -- ${ $self->{"_CENSUS"} };
\&    }
.Ve
.Sh "Debugging Methods"
.IX Subsection "Debugging Methods"
It's common for a class to have a debugging mechanism.  For example,
you might want to see when objects are created or destroyed.  To do that,
add a debugging variable as a file-scoped lexical.  For this, we'll pull
in the standard Carp module to emit our warnings and fatal messages.
That way messages will come out with the caller's filename and
line number instead of our own; if we wanted them to be from our own
perspective, we'd just use \fIdie()\fR and \fIwarn()\fR directly instead of \fIcroak()\fR
and \fIcarp()\fR respectively.
.PP
.Vb 2
\&    use Carp;
\&    my $Debugging = 0;
.Ve
Now add a new class method to access the variable.
.PP
.Vb 6
\&    sub debug {
\&        my $class = shift;
\&        if (ref $class)  { confess "Class method called as object method" }
\&        unless (@_ == 1) { confess "usage: CLASSNAME->debug(level)" }
\&        $Debugging = shift;
\&    }
.Ve
Now fix up \s-1DESTROY\s0 to murmur a bit as the moribund object expires:
.PP
.Vb 5
\&    sub DESTROY {
\&        my $self = shift;
\&        if ($Debugging) { carp "Destroying $self " . $self->name }
\&        -- ${ $self->{"_CENSUS"} };
\&    }
.Ve
One could conceivably make a per-object debug state.  That
way you could call both of these:
.PP
.Vb 2
\&    Person->debug(1);   # entire class
\&    $him->debug(1);     # just this object
.Ve
To do so, we need our debugging method to be a \*(L"bimodal\*(R" one, one that
works on both classes \fIand\fR objects.  Therefore, adjust the \fIdebug()\fR
and \s-1DESTROY\s0 methods as follows:
.PP
.Vb 10
\&    sub debug {
\&        my $self = shift;
\&        confess "usage: thing->debug(level)"    unless @_ == 1;
\&        my $level = shift;
\&        if (ref($self))  {
\&            $self->{"_DEBUG"} = $level;         # just myself
\&        } else {
\&            $Debugging        = $level;         # whole class
\&        }
\&    }
.Ve
.Vb 7
\&    sub DESTROY {
\&        my $self = shift;
\&        if ($Debugging || $self->{"_DEBUG"}) {
\&            carp "Destroying $self " . $self->name;
\&        }
\&        -- ${ $self->{"_CENSUS"} };
\&    }
.Ve
What happens if a derived class (which we'll call \f(CWEmployee\fR) inherits
methods from this person one?  Then \f(CWEmployee->\fIdebug()\fR\fR when called
as a class method manipulates \f(CW$Person::Debugging\fR not \f(CW$Employee::Debugging\fR.
.Sh "Class Destructors"
.IX Subsection "Class Destructors"
The object destructor handles the death of each distinct object.  But sometimes
you want a bit of cleanup when the entire class is shut down, which
currently only happens when the program exits.  To make such a
\fIclass destructor\fR, create a function in that class's package named
\s-1END\s0.  This works just like the \s-1END\s0 function in traditional modules,
meaning that it gets called whenever your program exits unless it execs
or dies of an uncaught signal.  For example,
.PP
.Vb 5
\&    sub END {
\&        if ($Debugging) {
\&            print "All persons are going away now.\en";
\&        }
\&    }
.Ve
When the program exits, all the class destructors (\s-1END\s0 functions) are
be called in the opposite order that they were loaded in (\s-1LIFO\s0 order).
.Sh "Documenting the Interface"
.IX Subsection "Documenting the Interface"
And there you have it: we've just shown you the \fIimplementation\fR of this
Person class.  Its \fIinterface\fR would be its documentation.  Usually this
means putting it in pod ("plain old documentation") format right there
in the same file.  In our Person example, we would place the following
docs anywhere in the Person.pm file.  Even though it looks mostly like
code, it's not.  It's embedded documentation such as would be used by
the pod2man, pod2html, or pod2text programs.  The Perl compiler ignores
pods entirely, just as the translators ignore code.  Here's an example of
some pods describing the informal interface:
.PP
.Vb 1
\&    =head1 NAME
.Ve
.Vb 1
\&    Person - class to implement people
.Ve
.Vb 1
\&    =head1 SYNOPSIS
.Ve
.Vb 1
\&     use Person;
.Ve
.Vb 5
\&     #################
\&     # class methods #
\&     #################
\&     $ob    = Person->new;
\&     $count = Person->population;
.Ve
.Vb 3
\&     #######################
\&     # object data methods #
\&     #######################
.Ve
.Vb 4
\&     ### get versions ###
\&         $who   = $ob->name;
\&         $years = $ob->age;
\&         @pals  = $ob->peers;
.Ve
.Vb 4
\&     ### set versions ###
\&         $ob->name("Jason");
\&         $ob->age(23);
\&         $ob->peers( "Norbert", "Rhys", "Phineas" );
.Ve
.Vb 3
\&     ########################
\&     # other object methods #
\&     ########################
.Ve
.Vb 2
\&     $phrase = $ob->exclaim;
\&     $ob->happy_birthday;
.Ve
.Vb 1
\&    =head1 DESCRIPTION
.Ve
.Vb 1
\&    The Person class implements dah dee dah dee dah....
.Ve
That's all there is to the matter of interface versus implementation.
A programmer who opens up the module and plays around with all the private
little shiny bits that were safely locked up behind the interface contract
has voided the warranty, and you shouldn't worry about their fate.
.SH "Aggregation"
.IX Header "Aggregation"
Suppose you later want to change the class to implement better names.
Perhaps you'd like to support both given names (called Christian names,
irrespective of one's religion) and family names (called surnames), plus
nicknames and titles.  If users of your Person class have been properly
accessing it through its documented interface, then you can easily change
the underlying implementation.  If they haven't, then they lose and
it's their fault for breaking the contract and voiding their warranty.
.PP
To do this, we'll make another class, this one called Fullname.  What's
the Fullname class look like?  To answer that question, you have to
first figure out how you want to use it.  How about we use it this way:
.PP
.Vb 7
\&    $him = Person->new();
\&    $him->fullname->title("St");
\&    $him->fullname->christian("Thomas");
\&    $him->fullname->surname("Aquinas");
\&    $him->fullname->nickname("Tommy");
\&    printf "His normal name is %s\en", $him->name;
\&    printf "But his real name is %s\en", $him->fullname->as_string;
.Ve
Ok.  To do this, we'll change \fIPerson::new()\fR so that it supports
a full name field this way:
.PP
.Vb 12
\&    sub new {
\&        my $proto = shift;
\&        my $class = ref($proto) || $proto;
\&        my $self  = {};
\&        $self->{FULLNAME} = Fullname->new();
\&        $self->{AGE}      = undef;
\&        $self->{PEERS}    = [];
\&        $self->{"_CENSUS"} = \e$Census;
\&        bless ($self, $class);
\&        ++ ${ $self->{"_CENSUS"} };
\&        return $self;
\&    }
.Ve
.Vb 4
\&    sub fullname {
\&        my $self = shift;
\&        return $self->{FULLNAME};
\&    }
.Ve
Then to support old code, define \fIPerson::name()\fR this way:
.PP
.Vb 5
\&    sub name {
\&        my $self = shift;
\&        return $self->{FULLNAME}->nickname(@_)
\&          ||   $self->{FULLNAME}->christian(@_);
\&    }
.Ve
Here's the Fullname class.  We'll use the same technique
of using a hash reference to hold data fields, and methods
by the appropriate name to access them:
.PP
.Vb 2
\&    package Fullname;
\&    use strict;
.Ve
.Vb 12
\&    sub new {
\&        my $proto = shift;
\&        my $class = ref($proto) || $proto;
\&        my $self  = {
\&            TITLE       => undef,
\&            CHRISTIAN   => undef,
\&            SURNAME     => undef,
\&            NICK        => undef,
\&        };
\&        bless ($self, $class);
\&        return $self;
\&    }
.Ve
.Vb 5
\&    sub christian {
\&        my $self = shift;
\&        if (@_) { $self->{CHRISTIAN} = shift }
\&        return $self->{CHRISTIAN};
\&    }
.Ve
.Vb 5
\&    sub surname {
\&        my $self = shift;
\&        if (@_) { $self->{SURNAME} = shift }
\&        return $self->{SURNAME};
\&    }
.Ve
.Vb 5
\&    sub nickname {
\&        my $self = shift;
\&        if (@_) { $self->{NICK} = shift }
\&        return $self->{NICK};
\&    }
.Ve
.Vb 5
\&    sub title {
\&        my $self = shift;
\&        if (@_) { $self->{TITLE} = shift }
\&        return $self->{TITLE};
\&    }
.Ve
.Vb 8
\&    sub as_string {
\&        my $self = shift;
\&        my $name = join(" ", @$self{'CHRISTIAN', 'SURNAME'});
\&        if ($self->{TITLE}) {
\&            $name = $self->{TITLE} . " " . $name;
\&        }
\&        return $name;
\&    }
.Ve
.Vb 1
\&    1;
.Ve
Finally, here's the test program:
.PP
.Vb 4
\&    #!/usr/bin/perl -w
\&    use strict;
\&    use Person;
\&    sub END { show_census() }
.Ve
.Vb 3
\&    sub show_census ()  {
\&        printf "Current population: %d\en", Person->population;
\&    }
.Ve
.Vb 1
\&    Person->debug(1);
.Ve
.Vb 1
\&    show_census();
.Ve
.Vb 1
\&    my $him = Person->new();
.Ve
.Vb 5
\&    $him->fullname->christian("Thomas");
\&    $him->fullname->surname("Aquinas");
\&    $him->fullname->nickname("Tommy");
\&    $him->fullname->title("St");
\&    $him->age(1);
.Ve
.Vb 4
\&    printf "%s is really %s.\en", $him->name, $him->fullname;
\&    printf "%s's age: %d.\en", $him->name, $him->age;
\&    $him->happy_birthday;
\&    printf "%s's age: %d.\en", $him->name, $him->age;
.Ve
.Vb 1
\&    show_census();
.Ve
.SH "Inheritance"
.IX Header "Inheritance"
Object-oriented programming systems all support some notion of
inheritance.  Inheritance means allowing one class to piggy-back on
top of another one so you don't have to write the same code again and
again.  It's about software reuse, and therefore related to Laziness,
the principal virtue of a programmer.  (The import/export mechanisms in
traditional modules are also a form of code reuse, but a simpler one than
the true inheritance that you find in object modules.)
.PP
Sometimes the syntax of inheritance is built into the core of the
language, and sometimes it's not.  Perl has no special syntax for
specifying the class (or classes) to inherit from.  Instead, it's all
strictly in the semantics.  Each package can have a variable called \f(CW@ISA\fR,
which governs (method) inheritance.  If you try to call a method on an
object or class, and that method is not found in that object's package,
Perl then looks to \f(CW@ISA\fR for other packages to go looking through in
search of the missing method.
.PP
Like the special per-package variables recognized by Exporter (such as
\f(CW@EXPORT\fR, \f(CW@EXPORT_OK\fR, \f(CW@EXPORT_FAIL\fR, \f(CW%EXPORT_TAGS\fR, and \f(CW$VERSION\fR), the \f(CW@ISA\fR
array \fImust\fR be a package-scoped global and not a file-scoped lexical
created via \fImy()\fR.  Most classes have just one item in their \f(CW@ISA\fR array.
In this case, we have what's called \*(L"single inheritance\*(R", or SI for short.
.PP
Consider this class:
.PP
.Vb 4
\&    package Employee;
\&    use Person;
\&    @ISA = ("Person");
\&    1;
.Ve
Not a lot to it, eh?  All it's doing so far is loading in another
class and stating that this one will inherit methods from that
other class if need be.  We have given it none of its own methods.
We rely upon an Employee to behave just like a Person.
.PP
Setting up an empty class like this is called the \*(L"empty subclass test\*(R";
that is, making a derived class that does nothing but inherit from a
base class.  If the original base class has been designed properly,
then the new derived class can be used as a drop-in replacement for the
old one.  This means you should be able to write a program like this:
.PP
.Vb 5
\&    use Employee
\&    my $empl = Employee->new();
\&    $empl->name("Jason");
\&    $empl->age(23);
\&    printf "%s is age %d.\en", $empl->name, $empl->age;
.Ve
By proper design, we mean always using the two-argument form of \fIbless()\fR,
avoiding direct access of global data, and not exporting anything.  If you
look back at the \fIPerson::new()\fR function we defined above, we were careful
to do that.  There's a bit of package data used in the constructor,
but the reference to this is stored on the object itself and all other
methods access package data via that reference, so we should be ok.
.PP
What do we mean by the \fIPerson::new()\fR function -- isn't that actually
a method?  Well, in principle, yes.  A method is just a function that
expects as its first argument a class name (package) or object
(blessed reference).   \fIPerson::new()\fR is the function that both the
\f(CWPerson->\fInew()\fR\fR method and the \f(CWEmployee->\fInew()\fR\fR method end
up calling.  Understand that while a method call looks a lot like a
function call, they aren't really quite the same, and if you treat them
as the same, you'll very soon be left with nothing but broken programs.
First, the actual underlying calling conventions are different: method
calls get an extra argument.  Second, function calls don't do inheritance,
but methods do.
.PP
.Vb 4
\&        Method Call             Resulting Function Call
\&        -----------             ------------------------
\&        Person->new()           Person::new("Person")
\&        Employee->new()         Person::new("Employee")
.Ve
So don't use function calls when you mean to call a method.
.PP
If an employee is just a Person, that's not all too very interesting.
So let's add some other methods.  We'll give our employee
data fields to access their salary, their employee ID, and their
start date.
.PP
If you're getting a little tired of creating all these nearly identical
methods just to get at the object's data, do not despair.  Later,
we'll describe several different convenience mechanisms for shortening
this up.  Meanwhile, here's the straight-forward way:
.PP
.Vb 5
\&    sub salary {
\&        my $self = shift;
\&        if (@_) { $self->{SALARY} = shift }
\&        return $self->{SALARY};
\&    }
.Ve
.Vb 5
\&    sub id_number {
\&        my $self = shift;
\&        if (@_) { $self->{ID} = shift }
\&        return $self->{ID};
\&    }
.Ve
.Vb 5
\&    sub start_date {
\&        my $self = shift;
\&        if (@_) { $self->{START_DATE} = shift }
\&        return $self->{START_DATE};
\&    }
.Ve
.Sh "Overridden Methods"
.IX Subsection "Overridden Methods"
What happens when both a derived class and its base class have the same
method defined?  Well, then you get the derived class's version of that
method.  For example, let's say that we want the \fIpeers()\fR method called on
an employee to act a bit differently.  Instead of just returning the list
of peer names, let's return slightly different strings.  So doing this:
.PP
.Vb 2
\&    $empl->peers("Peter", "Paul", "Mary");
\&    printf "His peers are: %s\en", join(", ", $empl->peers);
.Ve
will produce:
.PP
.Vb 1
\&    His peers are: PEON=PETER, PEON=PAUL, PEON=MARY
.Ve
To do this, merely add this definition into the Employee.pm file:
.PP
.Vb 5
\&    sub peers {
\&        my $self = shift;
\&        if (@_) { @{ $self->{PEERS} } = @_ }
\&        return map { "PEON=\eU$_" } @{ $self->{PEERS} };
\&    }
.Ve
There, we've just demonstrated the high-falutin\*(R' concept known in certain
circles as \fIpolymorphism\fR.  We've taken on the form and behaviour of
an existing object, and then we've altered it to suit our own purposes.
This is a form of Laziness.  (Getting polymorphed is also what happens
when the wizard decides you'd look better as a frog.)
.PP
Every now and then you'll want to have a method call trigger both its
derived class (also know as \*(L"subclass") version as well as its base class
(also known as \*(L"superclass") version.  In practice, constructors and
destructors are likely to want to do this, and it probably also makes
sense in the \fIdebug()\fR method we showed previously.
.PP
To do this, add this to Employee.pm:
.PP
.Vb 2
\&    use Carp;
\&    my $Debugging = 0;
.Ve
.Vb 11
\&    sub debug {
\&        my $self = shift;
\&        confess "usage: thing->debug(level)"    unless @_ == 1;
\&        my $level = shift;
\&        if (ref($self))  {
\&            $self->{"_DEBUG"} = $level;
\&        } else {
\&            $Debugging = $level;            # whole class
\&        }
\&        Person::debug($self, $Debugging);   # don't really do this
\&    }
.Ve
As you see, we turn around and call the Person package's \fIdebug()\fR function.
But this is far too fragile for good design.  What if Person doesn't
have a \fIdebug()\fR function, but is inheriting \fIits\fR \fIdebug()\fR method
from elsewhere?  It would have been slightly better to say
.PP
.Vb 1
\&    Person->debug($Debugging);
.Ve
But even that's got too much hard-coded.  It's somewhat better to say
.PP
.Vb 1
\&    $self->Person::debug($Debugging);
.Ve
Which is a funny way to say to start looking for a \fIdebug()\fR method up
in Person.  This strategy is more often seen on overridden object methods
than on overridden class methods.
.PP
There is still something a bit off here.  We've hard-coded our
superclass's name.  This in particular is bad if you change which classes
you inherit from, or add others.  Fortunately, the pseudoclass \s-1SUPER\s0
comes to the rescue here.
.PP
.Vb 1
\&    $class->SUPER::debug($Debugging);
.Ve
This way it starts looking in my class's \f(CW@ISA\fR.  This only makes sense
from \fIwithin\fR a method call, though.  Don't try to access anything
in \s-1SUPER\s0:: from anywhere else, because it doesn't exist outside
an overridden method call.
.PP
Things are getting a bit complicated here.  Have we done anything
we shouldn't?  As before, one way to test whether we're designing
a decent class is via the empty subclass test.  Since we already have
an Employee class that we're trying to check, we'd better get a new
empty subclass that can derive from Employee.  Here's one:
.PP
.Vb 3
\&    package Boss;
\&    use Employee;        # :-)
\&    @ISA = qw(Employee);
.Ve
And here's the test program:
.PP
.Vb 4
\&    #!/usr/bin/perl -w
\&    use strict;
\&    use Boss;
\&    Boss->debug(1);
.Ve
.Vb 1
\&    my $boss = Boss->new();
.Ve
.Vb 4
\&    $boss->fullname->title("Don");
\&    $boss->fullname->surname("Pichon Alvarez");
\&    $boss->fullname->christian("Federico Jesus");
\&    $boss->fullname->nickname("Fred");
.Ve
.Vb 2
\&    $boss->age(47);
\&    $boss->peers("Frank", "Felipe", "Faust");
.Ve
.Vb 2
\&    printf "%s is age %d.\en", $boss->fullname, $boss->age;
\&    printf "His peers are: %s\en", join(", ", $boss->peers);
.Ve
Running it, we see that we're still ok.  If you'd like to dump out your
object in a nice format, somewhat like the way the \*(L'x\*(R' command works in
the debugger, you could use the Data::Dumper module from \s-1CPAN\s0 this way:
.PP
.Vb 3
\&    use Data::Dumper;
\&    print "Here's the boss:\en";
\&    print Dumper($boss);
.Ve
Which shows us something like this:
.PP
.Vb 16
\&    Here's the boss:
\&    $VAR1 = bless( {
\&         _CENSUS => \e1,
\&         FULLNAME => bless( {
\&                              TITLE => 'Don',
\&                              SURNAME => 'Pichon Alvarez',
\&                              NICK => 'Fred',
\&                              CHRISTIAN => 'Federico Jesus'
\&                            }, 'Fullname' ),
\&         AGE => 47,
\&         PEERS => [
\&                    'Frank',
\&                    'Felipe',
\&                    'Faust'
\&                  ]
\&       }, 'Boss' );
.Ve
Hm.... something's missing there.  What about the salary, start date,
and \s-1ID\s0 fields?  Well, we never set them to anything, even undef, so they
don't show up in the hash's keys.  The Employee class has no \fInew()\fR method
of its own, and the \fInew()\fR method in Person doesn't know about Employees.
(Nor should it: proper \s-1OO\s0 design dictates that a subclass be allowed to
know about its immediate superclass, but never vice-versa.)  So let's
fix up \fIEmployee::new()\fR this way:
.PP
.Vb 10
\&    sub new {
\&        my $proto = shift;
\&        my $class = ref($proto) || $proto;
\&        my $self  = $class->SUPER::new();
\&        $self->{SALARY}        = undef;
\&        $self->{ID}            = undef;
\&        $self->{START_DATE}    = undef;
\&        bless ($self, $class);          # reconsecrate
\&        return $self;
\&    }
.Ve
Now if you dump out an Employee or Boss object, you'll find
that new fields show up there now.
.Sh "Multiple Inheritance"
.IX Subsection "Multiple Inheritance"
Ok, at the risk of confusing beginners and annoying \s-1OO\s0 gurus, it's
time to confess that Perl's object system includes that controversial
notion known as multiple inheritance, or \s-1MI\s0 for short.  All this means
is that rather than having just one parent class who in turn might
itself have a parent class, etc., that you can directly inherit from
two or more parents.  It's true that some uses of \s-1MI\s0 can get you into
trouble, although hopefully not quite so much trouble with Perl as with
dubiously-\s-1OO\s0 languages like \*(C+.
.PP
The way it works is actually pretty simple: just put more than one package
name in your \f(CW@ISA\fR array.  When it comes time for Perl to go finding
methods for your object, it looks at each of these packages in order.
Well, kinda.  It's actually a fully recursive, depth-first order.
Consider a bunch of \f(CW@ISA\fR arrays like this:
.PP
.Vb 3
\&    @First::ISA    = qw( Alpha );
\&    @Second::ISA   = qw( Beta );
\&    @Third::ISA    = qw( First Second );
.Ve
If you have an object of class Third:
.PP
.Vb 2
\&    my $ob = Third->new();
\&    $ob->spin();
.Ve
How do we find a \fIspin()\fR method (or a \fInew()\fR method for that matter)?
Because the search is depth-first, classes will be looked up
in the following order: Third, First, Alpha, Second, and Beta.
.PP
In practice, few class modules have been seen that actually
make use of \s-1MI\s0.  One nearly always chooses simple containership of
one class within another over \s-1MI\s0.  That's why our Person
object \fIcontained\fR a Fullname object.  That doesn't mean
it \fIwas\fR one.
.PP
However, there is one particular area where \s-1MI\s0 in Perl is rampant:
borrowing another class's class methods.  This is rather common,
especially with some bundled \*(L"objectless\*(R" classes,
like Exporter, DynaLoader, AutoLoader, and SelfLoader.  These classes
do not provide constructors; they exist only so you may inherit their
class methods.  (It's not entirely clear why inheritance was done
here rather than traditional module importation.)
.PP
For example, here is the \s-1POSIX\s0 module's \f(CW@ISA:\fR
.PP
.Vb 2
\&    package POSIX;
\&    @ISA = qw(Exporter DynaLoader);
.Ve
The \s-1POSIX\s0 module isn't really an object module, but then,
neither are Exporter or DynaLoader.  They're just lending their
classes\*(R' behaviours to \s-1POSIX\s0.
.PP
Why don't people use \s-1MI\s0 for object methods much?  One reason is that
it can have complicated side-effects.  For one thing, your inheritance
graph (no longer a tree) might converge back to the same base class.
Although Perl guards against recursive inheritance, merely having parents
who are related to each other via a common ancestor, incestuous though
it sounds, is not forbidden.  What if in our Third class shown above we
wanted its \fInew()\fR method to also call both overridden constructors in its
two parent classes?  The \s-1SUPER\s0 notation would only find the first one.
Also, what about if the Alpha and Beta classes both had a common ancestor,
like Nought?  If you kept climbing up the inheritance tree calling
overridden methods, you'd end up calling \fINought::new()\fR twice,
which might well be a bad idea.
.Sh "\s-1UNIVERSAL\s0: The Root of All Objects"
.IX Subsection "\s-1UNIVERSAL\s0: The Root of All Objects"
Wouldn't it be convenient if all objects were rooted at some ultimate
base class?  That way you could give every object common methods without
having to go and add it to each and every \f(CW@ISA\fR.  Well, it turns out that
you can.  You don't see it, but Perl tacitly and irrevocably assumes
that there's an extra element at the end of \f(CW@ISA:\fR the class \s-1UNIVERSAL\s0.
In 5.003, there were no predefined methods there, but you could put
whatever you felt like into it.
.PP
However, as of 5.004 (or some subversive releases, like 5.003_08),
\s-1UNIVERSAL\s0 has some methods in it already.  These are built-in to your Perl
binary, so they don't take any extra time to load.  Predefined methods
include \fIisa()\fR, \fIcan()\fR, and \fI\s-1VERSION\s0()\fR.  \fIisa()\fR tells you whether an object or
class \*(L"is\*(R" another one without having to traverse the hierarchy yourself:
.PP
.Vb 2
\&   $has_io = $fd->isa("IO::Handle");
\&   $itza_handle = IO::Socket->isa("IO::Handle");
.Ve
The \fIcan()\fR method, called against that object or class, reports back
whether its string argument is a callable method name in that class.
In fact, it gives you back a function reference to that method:
.PP
.Vb 1
\&   $his_print_method = $obj->can('as_string');
.Ve
Finally, the \s-1VERSION\s0 method checks whether the class (or the object's
class) has a package global called \f(CW$VERSION\fR that's high enough, as in:
.PP
.Vb 2
\&    Some_Module->VERSION(3.0);
\&    $his_vers = $ob->VERSION();
.Ve
However, we don't usually call \s-1VERSION\s0 ourselves.  (Remember that an all
upper-case function name is a Perl convention that indicates that the
function will be automatically used by Perl in some way.)  In this case,
it happens when you say
.PP
.Vb 1
\&    use Some_Module 3.0;
.Ve
If you wanted to add versioning to your Person class explained
above, just add this to Person.pm:
.PP
.Vb 2
\&    use vars qw($VERSION);
\&    $VERSION = '1.1';
.Ve
and then in Employee.pm could you can say
.PP
.Vb 1
\&    use Employee 1.1;
.Ve
And it would make sure that you have at least that version number or
higher available.   This is not the same as loading in that exact version
number.  No mechanism currently exists for concurrent installation of
multiple versions of a module.  Lamentably.
.SH "Alternate Object Representations"
.IX Header "Alternate Object Representations"
Nothing requires objects to be implemented as hash references.  An object
can be any sort of reference so long as its referent has been suitably
blessed.  That means scalar, array, and code references are also fair
game.
.PP
A scalar would work if the object has only one datum to hold.  An array
would work for most cases, but makes inheritance a bit dodgy because
you have to invent new indices for the derived classes.
.Sh "Arrays as Objects"
.IX Subsection "Arrays as Objects"
If the user of your class honors the contract and sticks to the advertised
interface, then you can change its underlying interface if you feel
like it.  Here's another implementation that conforms to the same
interface specification.  This time we'll use an array reference
instead of a hash reference to represent the object.
.PP
.Vb 2
\&    package Person;
\&    use strict;
.Ve
.Vb 1
\&    my($NAME, $AGE, $PEERS) = ( 0 .. 2 );
.Ve
.Vb 11
\&    ############################################
\&    ## the object constructor (array version) ##
\&    ############################################
\&    sub new {
\&        my $self = [];
\&        $self->[$NAME]   = undef;  # this is unnecessary
\&        $self->[$AGE]    = undef;  # as it this
\&        $self->[$PEERS]  = [];     # but this isn't, really
\&        bless($self);
\&        return $self;
\&    }
.Ve
.Vb 5
\&    sub name {
\&        my $self = shift;
\&        if (@_) { $self->[$NAME] = shift }
\&        return $self->[$NAME];
\&    }
.Ve
.Vb 5
\&    sub age {
\&        my $self = shift;
\&        if (@_) { $self->[$AGE] = shift }
\&        return $self->[$AGE];
\&    }
.Ve
.Vb 5
\&    sub peers {
\&        my $self = shift;
\&        if (@_) { @{ $self->[$PEERS] } = @_ }
\&        return @{ $self->[$PEERS] };
\&    }
.Ve
.Vb 1
\&    1;  # so the require or use succeeds
.Ve
You might guess that the array access will be a lot faster than the
hash access, but they're actually comparable.  The array is a little
bit faster, but not more than ten or fifteen percent, even when you
replace the variables above like \f(CW$AGE\fR with literal numbers, like 1.
A bigger difference between the two approaches can be found in memory use.
A hash representation takes up more memory than an array representation
because you have to allocation memory for the keys as well as the values.
However, it really isn't that bad, especially since as of 5.004,
memory is only allocated once for a given hash key, no matter how many
hashes have that key.  It's expected that sometime in the future, even
these differences will fade into obscurity as more efficient underlying
representations are devised.
.PP
Still, the tiny edge in speed (and somewhat larger one in memory)
is enough to make some programmers choose an array representation
for simple classes.  There's still a little problem with
scalability, though, because later in life when you feel
like creating subclasses, you'll find that hashes just work
out better.
.Sh "Closures as Objects"
.IX Subsection "Closures as Objects"
Using a code reference to represent an object offers some fascinating
possibilities.  We can create a new anonymous function (closure) who
alone in all the world can see the object's data.  This is because we
put the data into an anonymous hash that's lexically visible only to
the closure we create, bless, and return as the object.  This object's
methods turn around and call the closure as a regular subroutine call,
passing it the field we want to affect.  (Yes,
the double-function call is slow, but if you wanted fast, you wouldn't
be using objects at all, eh? :\-)
.PP
Use would be similar to before:
.PP
.Vb 7
\&    use Person;
\&    $him = Person->new();
\&    $him->name("Jason");
\&    $him->age(23);
\&    $him->peers( [ "Norbert", "Rhys", "Phineas" ] );
\&    printf "%s is %d years old.\en", $him->name, $him->age;
\&    print "His peers are: ", join(", ", @{$him->peers}), "\en";
.Ve
but the implementation would be radically, perhaps even sublimely
different:
.PP
.Vb 1
\&    package Person;
.Ve
.Vb 16
\&    sub new {
\&         my $that  = shift;
\&         my $class = ref($that) || $that;
\&         my $self = {
\&            NAME  => undef,
\&            AGE   => undef,
\&            PEERS => [],
\&         };
\&         my $closure = sub {
\&            my $field = shift;
\&            if (@_) { $self->{$field} = shift }
\&            return    $self->{$field};
\&        };
\&        bless($closure, $class);
\&        return $closure;
\&    }
.Ve
.Vb 3
\&    sub name   { &{ $_[0] }("NAME",  @_[ 1 .. $#_ ] ) }
\&    sub age    { &{ $_[0] }("AGE",   @_[ 1 .. $#_ ] ) }
\&    sub peers  { &{ $_[0] }("PEERS", @_[ 1 .. $#_ ] ) }
.Ve
.Vb 1
\&    1;
.Ve
Because this object is hidden behind a code reference, it's probably a bit
mysterious to those whose background is more firmly rooted in standard
procedural or object-based programming languages than in functional
programming languages whence closures derive.  The object
created and returned by the \fInew()\fR method is itself not a data reference
as we've seen before.  It's an anonymous code reference that has within
it access to a specific version (lexical binding and instantiation)
of the object's data, which are stored in the private variable \f(CW$self\fR.
Although this is the same function each time, it contains a different
version of \f(CW$self\fR.
.PP
When a method like \f(CW$him->\fIname\fR\|("Jason")\fR is called, its implicit
zeroth argument is as the invoking object just as it is with all method
calls.  But in this case, it's our code reference (something like a
function pointer in \*(C+, but with deep binding of lexical variables).
There's not a lot to be done with a code reference beyond calling it, so
that's just what we do when we say \f(CW&{$_[0]}\fR.  This is just a regular
function call, not a method call.  The initial argument is the string
\*(L"\s-1NAME\s0\*(R", and any remaining arguments are whatever had been passed to the
method itself.
.PP
Once we're executing inside the closure that had been created in \fInew()\fR,
the \f(CW$self\fR hash reference suddenly becomes visible.  The closure grabs
its first argument ("\s-1NAME\s0\*(R" in this case because that's what the \fIname()\fR
method passed it), and uses that string to subscript into the private
hash hidden in its unique version of \f(CW$self\fR.
.PP
Nothing under the sun will allow anyone outside the executing method to
be able to get at this hidden data.  Well, nearly nothing.  You \fIcould\fR
single step through the program using the debugger and find out the
pieces while you're in the method, but everyone else is out of luck.
.PP
There, if that doesn't excite the Scheme folks, then I just don't know
what will.  Translation of this technique into \*(C+, Java, or any other
braindead-static language is left as a futile exercise for aficionados
of those camps.
.PP
You could even add a bit of nosiness via the \fIcaller()\fR function and
make the closure refuse to operate unless called via its own package.
This would no doubt satisfy certain fastidious concerns of programming
police and related puritans.
.PP
If you were wondering when Hubris, the third principle virtue of a
programmer, would come into play, here you have it. (More seriously,
Hubris is just the pride in craftsmanship that comes from having written
a sound bit of well-designed code.)
.SH "AUTOLOAD: Proxy Methods"
.IX Header "AUTOLOAD: Proxy Methods"
Autoloading is a way to intercept calls to undefined methods.  An autoload
routine may choose to create a new function on the fly, either loaded
from disk or perhaps just \fIeval()\fRed right there.  This define-on-the-fly
strategy is why it's called autoloading.
.PP
But that's only one possible approach.  Another one is to just
have the autoloaded method itself directly provide the
requested service.  When used in this way, you may think
of autoloaded methods as \*(L"proxy\*(R" methods.
.PP
When Perl tries to call an undefined function in a particular package
and that function is not defined, it looks for a function in
that same package called AUTOLOAD.  If one exists, it's called
with the same arguments as the original function would have had.
The fully-qualified name of the function is stored in that package's
global variable \f(CW$AUTOLOAD\fR.  Once called, the function can do anything
it would like, including defining a new function by the right name, and
then doing a really fancy kind of \f(CWgoto\fR right to it, erasing itself
from the call stack.
.PP
What does this have to do with objects?  After all, we keep talking about
functions, not methods.  Well, since a method is just a function with
an extra argument and some fancier semantics about where it's found,
we can use autoloading for methods, too.  Perl doesn't start looking
for an AUTOLOAD method until it has exhausted the recursive hunt up
through \f(CW@ISA\fR, though.  Some programmers have even been known to define
a UNIVERSAL::AUTOLOAD method to trap unresolved method calls to any
kind of object.
.Sh "Autoloaded Data Methods"
.IX Subsection "Autoloaded Data Methods"
You probably began to get a little suspicious about the duplicated
code way back earlier when we first showed you the Person class, and
then later the Employee class.  Each method used to access the
hash fields looked virtually identical.  This should have tickled
that great programming virtue, Impatience, but for the time,
we let Laziness win out, and so did nothing.  Proxy methods can cure
this.
.PP
Instead of writing a new function every time we want a new data field,
we'll use the autoload mechanism to generate (actually, mimic) methods on
the fly.  To verify that we're accessing a valid member, we will check
against an \f(CW_permitted\fR (pronounced \*(L"under-permitted") field, which
is a reference to a file-scoped lexical (like a C file static) hash of permitted fields in this record
called \f(CW%fields\fR.  Why the underscore?  For the same reason as the _CENSUS
field we once used: as a marker that means \*(L"for internal use only\*(R".
.PP
Here's what the module initialization code and class
constructor will look like when taking this approach:
.PP
.Vb 3
\&    package Person;
\&    use Carp;
\&    use vars qw($AUTOLOAD);  # it's a package global
.Ve
.Vb 5
\&    my %fields = (
\&        name        => undef,
\&        age         => undef,
\&        peers       => undef,
\&    );
.Ve
.Vb 10
\&    sub new {
\&        my $that  = shift;
\&        my $class = ref($that) || $that;
\&        my $self  = {
\&            _permitted => \e%fields,
\&            %fields,
\&        };
\&        bless $self, $class;
\&        return $self;
\&    }
.Ve
If we wanted our record to have default values, we could fill those in
where current we have \f(CWundef\fR in the \f(CW%fields\fR hash.
.PP
Notice how we saved a reference to our class data on the object itself?
Remember that it's important to access class data through the object
itself instead of having any method reference \f(CW%fields\fR directly, or else
you won't have a decent inheritance.
.PP
The real magic, though, is going to reside in our proxy method, which
will handle all calls to undefined methods for objects of class Person
(or subclasses of Person).  It has to be called \s-1AUTOLOAD\s0.  Again, it's
all caps because it's called for us implicitly by Perl itself, not by
a user directly.
.PP
.Vb 4
\&    sub AUTOLOAD {
\&        my $self = shift;
\&        my $type = ref($self)
\&                    or croak "$self is not an object";
.Ve
.Vb 2
\&        my $name = $AUTOLOAD;
\&        $name =~ s/.*://;   # strip fully-qualified portion
.Ve
.Vb 3
\&        unless (exists $self->{_permitted}->{$name} ) {
\&            croak "Can't access `$name' field in class $type";
\&        }
.Ve
.Vb 6
\&        if (@_) {
\&            return $self->{$name} = shift;
\&        } else {
\&            return $self->{$name};
\&        }
\&    }
.Ve
Pretty nifty, eh?  All we have to do to add new data fields
is modify \f(CW%fields\fR.  No new functions need be written.
.PP
I could have avoided the \f(CW_permitted\fR field entirely, but I
wanted to demonstrate how to store a reference to class data on the
object so you wouldn't have to access that class data 
directly from an object method.
.Sh "Inherited Autoloaded Data Methods"
.IX Subsection "Inherited Autoloaded Data Methods"
But what about inheritance?  Can we define our Employee
class similarly?  Yes, so long as we're careful enough.
.PP
Here's how to be careful:
.PP
.Vb 5
\&    package Employee;
\&    use Person;
\&    use strict;
\&    use vars qw(@ISA);
\&    @ISA = qw(Person);
.Ve
.Vb 4
\&    my %fields = (
\&        id          => undef,
\&        salary      => undef,
\&    );
.Ve
.Vb 11
\&    sub new {
\&        my $that  = shift;
\&        my $class = ref($that) || $that;
\&        my $self = bless $that->SUPER::new(), $class;
\&        my($element);
\&        foreach $element (keys %fields) {
\&            $self->{_permitted}->{$element} = $fields{$element};
\&        }
\&        @{$self}{keys %fields} = values %fields;
\&        return $self;
\&    }
.Ve
Once we've done this, we don't even need to have an
\s-1AUTOLOAD\s0 function in the Employee package, because
we'll grab Person's version of that via inheritance,
and it will all work out just fine.
.SH "Metaclassical Tools"
.IX Header "Metaclassical Tools"
Even though proxy methods can provide a more convenient approach to making
more struct-like classes than tediously coding up data methods as
functions, it still leaves a bit to be desired.  For one thing, it means
you have to handle bogus calls that you don't mean to trap via your proxy.
It also means you have to be quite careful when dealing with inheritance,
as detailed above.
.PP
Perl programmers have responded to this by creating several different
class construction classes.  These metaclasses are classes
that create other classes.  A couple worth looking at are
Class::Template and Alias.  These and other related metaclasses can be
found in the modules directory on CPAN.
.Sh "Class::Template"
.IX Subsection "Class::Template"
One of the older ones is Class::Template.  In fact, its syntax and
interface were sketched out long before perl5 even solidified into a
real thing.  What it does is provide you a way to \*(L"declare\*(R"
a class as having objects whose fields are of a specific type.
The function that does this is called, not surprisingly
enough, \fIstruct()\fR.
.PP
Here's a simple example of using it:
.PP
.Vb 2
\&    use Class::Template qw(struct);
\&    use Jobbie;  # user-defined; see below
.Ve
.Vb 5
\&    struct 'Fred' => {
\&        one        => '$',
\&        many       => '@',
\&        profession => Jobbie,  # calls Jobbie->new()
\&    };
.Ve
.Vb 2
\&    $ob = Fred->new;
\&    $ob->one("hmmmm");
.Ve
.Vb 4
\&    $ob->many(0, "here");
\&    $ob->many(1, "you");
\&    $ob->many(2, "go");
\&    print "Just set: ", $ob->many(2), "\en";
.Ve
.Vb 1
\&    $ob->profession->salary(10_000);
.Ve
You can declare types in the struct to be basic Perl types, or
user-defined types (classes).  User types will be initialized by calling
that class's \fInew()\fR method.
.PP
Here's a real-world example of using struct generation.  Let's say you
wanted to override Perl's idea of \fIgethostbyname()\fR and \fIgethostbyaddr()\fR so
that they would return objects that acted like C structures.  We don't
care about high-falutin\*(R' \s-1OO\s0 gunk.  All we want is for these objects to
act like structs in the C sense.
.PP
.Vb 5
\&    use Socket;
\&    use Net::hostent;
\&    $h = gethostbyname("perl.com");  # object return
\&    printf "perl.com's real name is %s, address %s\en",
\&        $h->name, inet_ntoa($h->addr);
.Ve
Here's how to do this using the Class::Template module.
The crux is going to be this call:
.PP
.Vb 7
\&    struct 'Net::hostent' => [          # note bracket
\&        name       => '$',
\&        aliases    => '@',
\&        addrtype   => '$',
\&        'length'   => '$',
\&        addr_list  => '@',
\&     ];
.Ve
Which creates object methods of those names and types.
It even creates a \fInew()\fR method for us.
.PP
We could also have implemented our object this way:
.PP
.Vb 7
\&    struct 'Net::hostent' => {          # note brace
\&        name       => '$',
\&        aliases    => '@',
\&        addrtype   => '$',
\&        'length'   => '$',
\&        addr_list  => '@',
\&     };
.Ve
and then Class::Template would have used an anonymous hash as the object
type, instead of an anonymous array.  The array is faster and smaller,
but the hash works out better if you eventually want to do inheritance.
Since for this struct-like object we aren't planning on inheritance,
this time we'll opt for better speed and size over better flexibility.
.PP
Here's the whole implementation:
.PP
.Vb 2
\&    package Net::hostent;
\&    use strict;
.Ve
.Vb 13
\&    BEGIN {
\&        use Exporter   ();
\&        use vars       qw(@ISA @EXPORT @EXPORT_OK %EXPORT_TAGS);
\&        @ISA         = qw(Exporter);
\&        @EXPORT      = qw(gethostbyname gethostbyaddr gethost);
\&        @EXPORT_OK   = qw(
\&                           $h_name         @h_aliases
\&                           $h_addrtype     $h_length
\&                           @h_addr_list    $h_addr
\&                       );
\&        %EXPORT_TAGS = ( FIELDS => [ @EXPORT_OK, @EXPORT ] );
\&    }
\&    use vars      @EXPORT_OK;
.Ve
.Vb 8
\&    use Class::Template qw(struct);
\&    struct 'Net::hostent' => [
\&       name        => '$',
\&       aliases     => '@',
\&       addrtype    => '$',
\&       'length'    => '$',
\&       addr_list   => '@',
\&    ];
.Ve
.Vb 1
\&    sub addr { shift->addr_list->[0] }
.Ve
.Vb 11
\&    sub populate (@) {
\&        return unless @_;
\&        my $hob = new();  # Class::Template made this!
\&        $h_name     =    $hob->[0]              = $_[0];
\&        @h_aliases  = @{ $hob->[1] } = split ' ', $_[1];
\&        $h_addrtype =    $hob->[2]              = $_[2];
\&        $h_length   =    $hob->[3]              = $_[3];
\&        $h_addr     =                             $_[4];
\&        @h_addr_list = @{ $hob->[4] } =         @_[ (4 .. $#_) ];
\&        return $hob;
\&    }
.Ve
.Vb 1
\&    sub gethostbyname ($)  { populate(CORE::gethostbyname(shift)) }
.Ve
.Vb 7
\&    sub gethostbyaddr ($;$) {
\&        my ($addr, $addrtype);
\&        $addr = shift;
\&        require Socket unless @_;
\&        $addrtype = @_ ? shift : Socket::AF_INET();
\&        populate(CORE::gethostbyaddr($addr, $addrtype))
\&    }
.Ve
.Vb 8
\&    sub gethost($) {
\&        if ($_[0] =~ /^\ed+(?:\e.\ed+(?:\e.\ed+(?:\e.\ed+)?)?)?$/) {
\&           require Socket;
\&           &gethostbyaddr(Socket::inet_aton(shift));
\&        } else {
\&           &gethostbyname;
\&        }
\&    }
.Ve
.Vb 1
\&    1;
.Ve
We've snuck in quite a fair bit of other concepts besides just dynamic
class creation, like overriding core functions, import/export bits,
function prototyping, and short-cut function call via \f(CW&whatever\fR.
These all mostly make sense from the perspective of a traditional module,
but as you can see, we can also use them in an object module.
.PP
You can look at other object-based, struct-like overrides of core
functions in the 5.004 release of Perl in File::stat, Net::hostent,
Net::netent, Net::protoent, Net::servent, Time::gmtime, Time::localtime,
User::grent, and User::pwent.  These modules have a final component
that's all lower-case, by convention reserved for compiler pragmas,
because they affect the compilation and change a built-in function.
They also have the type names that a C programmer would most expect.
.Sh "Data Members as Variables"
.IX Subsection "Data Members as Variables"
If you're used to \*(C+ objects, then you're accustomed to being able to
get at an object's data members as simple variables from within a method.
The Alias module provides for this, as well as a good bit more, such
as the possibility of private methods that the object can call but folks
outside the class cannot.
.PP
Here's an example of creating a Person using the Alias module.
When you update these magical instance variables, you automatically
update value fields in the hash.  Convenient, eh?
.PP
.Vb 1
\&    package Person;
.Ve
.Vb 12
\&    # this is the same as before...
\&    sub new {
\&         my $that  = shift;
\&         my $class = ref($that) || $that;
\&         my $self = {
\&            NAME  => undef,
\&            AGE   => undef,
\&            PEERS => [],
\&        };
\&        bless($self, $class);
\&        return $self;
\&    }
.Ve
.Vb 2
\&    use Alias qw(attr);
\&    use vars qw($NAME $AGE $PEERS);
.Ve
.Vb 5
\&    sub name {
\&        my $self = attr shift;
\&        if (@_) { $NAME = shift; }
\&        return    $NAME;
\&    }
.Ve
.Vb 5
\&    sub age {
\&        my $self = attr shift;
\&        if (@_) { $AGE = shift; }
\&        return    $AGE;
\&    }
.Ve
.Vb 5
\&    sub peers {
\&        my $self = attr shift;
\&        if (@_) { @PEERS = @_; }
\&        return    @PEERS;
\&    }
.Ve
.Vb 5
\&    sub exclaim {
\&        my $self = attr shift;
\&        return sprintf "Hi, I'm %s, age %d, working with %s",
\&            $NAME, $AGE, join(", ", @PEERS);
\&    }
.Ve
.Vb 4
\&    sub happy_birthday {
\&        my $self = attr shift;
\&        return ++$AGE;
\&    }
.Ve
The need for the \f(CWuse vars\fR declaration is because what Alias does
is play with package globals with the same name as the fields.  To use
globals while \f(CWuse strict\fR is in effect, you have to pre-declare them.
These package variables are localized to the block enclosing the \fIattr()\fR
call just as if you'd used a \fIlocal()\fR on them.  However, that means that
they're still considered global variables with temporary values, just
as with any other \fIlocal()\fR.
.PP
It would be nice to combine Alias with
something like Class::Template or Class::MethodMaker.
.Sh "\s-1NOTES\s0"
.IX Subsection "\s-1NOTES\s0"
.Sh "Object Terminology"
.IX Subsection "Object Terminology"
In the various \s-1OO\s0 literature, it seems that a lot of different words
are used to describe only a few different concepts.  If you're not
already an object programmer, then you don't need to worry about all
these fancy words.  But if you are, then you might like to know how to
get at the same concepts in Perl.
.PP
For example, it's common to call an object an \fIinstance\fR of a class
and to call those objects\*(R' methods \fIinstance methods\fR.  Data fields
peculiar to each object are often called \fIinstance data\fR or \fIobject
attributes\fR, and data fields common to all members of that class are
\fIclass data\fR, \fIclass attributes\fR, or \fIstatic data members\fR.
.PP
Also, \fIbase class\fR, \fIgeneric class\fR, and \fIsuperclass\fR all describe
the same notion, whereas \fIderived class\fR, \fIspecific class\fR, and
\fIsubclass\fR describe the other related one.
.PP
\*(C+ programmers have \fIstatic methods\fR and \fIvirtual methods\fR,
but Perl only has \fIclass methods\fR and \fIobject methods\fR.
Actually, Perl only has methods.  Whether a method gets used
as a class or object method is by usage only.  You could accidentally
call a class method (one expecting a string argument) on an
object (one expecting a reference), or vice versa.
.PP
From the \*(C+ perspective, all methods in Perl are virtual.
This, by the way, is why they are never checked for function
prototypes in the argument list as regular built-in and user-defined
functions can be.
.PP
Because a class is itself something of an object, Perl's classes can be
taken as describing both a \*(L"class as meta-object\*(R" (also called \fIobject
factory\fR) philosophy and the \*(L"class as type definition\*(R" (\fIdeclaring\fR
behaviour, not \fIdefining\fR mechanism) idea.  \*(C+ supports the latter
notion, but not the former.
.SH "SEE ALSO"
.IX Header "SEE ALSO"
The following man pages will doubtless provide more
background for this one:
the \fIperlmod\fR manpage,
the \fIperlref\fR manpage,
the \fIperlobj\fR manpage,
the \fIperlbot\fR manpage,
the \fIperltie\fR manpage,
and
the \fIoverload\fR manpage.
.SH "COPYRIGHT"
.IX Header "COPYRIGHT"
I \fIreally\fR hate to have to say this, but recent unpleasant
experiences have mandated its inclusion:
.PP
.Vb 1
\&    Copyright 1996 Tom Christiansen.  All Rights Reserved.
.Ve
This work derives in part from the second edition of \fIProgramming Perl\fR.
Although destined for release as a man page with the standard Perl
distribution, it is not public domain (nor is any of Perl and its docset:
publishers beware).  It's expected to someday make its way into a revision
of the Camel Book.  While it is copyright by me with all rights reserved,
permission is granted to freely distribute verbatim copies of this
document provided that no modifications outside of formatting be made,
and that this notice remain intact.  You are permitted and encouraged to
use its code and derivatives thereof in your own source code for fun or
for profit as you see fit.  But so help me, if in six months I find some
book out there with a hacked-up version of this material in it claiming to
be written by someone else, I'll tell all the world that you're a jerk.
Furthermore, your lawyer will meet my lawyer (or O'Reilly's) over lunch
to arrange for you to receive your just deserts.  Count on it.
.Sh "Acknowledgments"
.IX Subsection "Acknowledgments"
Thanks to
Larry Wall,
Roderick Schertler,
Gurusamy Sarathy,
Dean Roehrich,
Raphael Manfredi,
Brent Halsey,
Greg Bacon,
Brad Appleton,
and many others for their helpful comments.

.rn }` ''
