Xref: feenix.metronet.com comp.unix.questions:8813
Newsgroups: comp.unix.questions
Path: feenix.metronet.com!spssig.spss.com!uchinews!vixen.cso.uiuc.edu!moe.ksu.ksu.edu!crcnis1.unl.edu!news.unomaha.edu!cwis!mfuhr
From: mfuhr@cwis.unomaha.edu (Michael Fuhr)
Subject: Re: Any good script writers out there ?
Message-ID: <mfuhr.744267253@cwis>
Sender: news@news.unomaha.edu (UNO Network News Server)
Organization: University of Nebraska at Omaha
References: <744065531snz@willen.demon.co.uk>
Date: Mon, 2 Aug 1993 04:54:13 GMT
Lines: 117

adrian@willen.demon.co.uk (Adrian Parker) writes:

>Here's the problem.  I write software in COBOL, and want to generate a 

Yep, that's a problem all right.

>structural tree of the system.   Now in COBOL a call to a sub program 
>is done in the following manner:

[example deleted]

Here's a perl script that does what I think you want, although the
output format isn't exactly what you specified.  It assumes the
name of the calling subroutine is the same as the file name, e.g.,
the subroutine in PROGA.CBL would be PROGA.  Just feed it a file
(or stdin) containing data formatted as the script's comments indicate.
For example, if you call the program "foo", you could use it like
this:

	grep CALL *.CBL | foo
		-or-
	grep CALL *.CBL > bar
	foo bar

--Cut Here--
#!/usr/bin/perl
#
#------------------------------------------------------------------------
# Print a calling tree based on input data.  Examples of input format:
#
#	/prog/asource/PROGA.CBL           CALL "PROGB".
#	/prog/asource/PROGA.CBL           CALL "PROGE".
#	/prog/asource/PROGB.CBL           IF CONDITION CALL "PROGC".
#	/prog/asource/PROGB.CBL           CALL "PROGE".
#	/prog/asource/PROGB.CBL           CALL "PROGD".
#	/prog/bsource/PROGC.CBL           CALL "PROGE".
#	/prog/csource/PROGD.CBL           CALL "PROGE".
#
# Output from the above will be:
#
#	1  PROGA
#	2  .  PROGB
#	3  .  .  PROGC
#	4  .  .  .  PROGE
#	5  .  .  PROGE <4>
#	6  .  .  PROGD
#	7  .  .  .  PROGE <4>
#	8  .  PROGE <4>
#
# Numbers in <> symbols represent the line number where a subroutine was
# first printed (this avoids repeating a deep routine's tree).
#
# 1 Aug 93
# Michael Fuhr
# mfuhr@cwis.unomaha.edu
#------------------------------------------------------------------------


#------------------------------------------------------------------------
# Read each line and get the caller & callee.  Add the callee to the
# caller's list of callees.  To find the top-level routine, we keep a
# count of the number of times a subroutine is called.  Any routine that
# has no count must be at the top.
#------------------------------------------------------------------------

while (<>) {
	($caller, $callee) = m#([^/]+)\.CBL.*CALL\s*"([^"]+)"#;
	$call{$caller} .= "$callee,";
	++$count{$callee};
}

#------------------------------------------------------------------------
# Find each top-level routine and print the tree for it.
#------------------------------------------------------------------------

$linenum = 0;	# Initialization unnecessary, but doesn't hurt.

foreach $sub (keys %call) {
	&print_tree($sub) unless $count{$sub};
}

#------------------------------------------------------------------------
# Subroutine to print the calling tree for a routine.  If we've already
# seen this one, print only the line number where we saw it.  Otherwise
# recurse into the tree for subroutine that this one calls.
#------------------------------------------------------------------------

sub print_tree {
	local($name, $indent) = @_;
	local($sub);

	++$linenum;
	printf "%5d  %s%s", $linenum, $indent, $name;
	if ($already_seen{$name}) {
		print " <", $already_seen{$name}, ">\n";
		return;
	}
	print "\n";

	$already_seen{$name} = $linenum;

	#----------------------------------------------------------------
	# Here's where we do the recursive call.  A different indentation
	# style could be used by changing the "$indent.  " string below.
	#----------------------------------------------------------------

	foreach $sub (split(/,/, $call{$name})) {
		next unless $sub;
		&print_tree($sub, "$indent.  ");
	}
}
--Cut Here--

--
Michael Fuhr                                       "The distrust of wit is the
mfuhr@cwis.unomaha.edu                              beginning of tyranny."
                                                                 -Edward Abbey
