Article 11799 of comp.lang.perl:
Newsgroups: comp.lang.perl
Path: feenix.metronet.com!news.utdallas.edu!convex!cs.utexas.edu!usc!nic-nac.CSU.net!pravda.sdsc.edu!news.cerf.net!netlabs!lwall
From: lwall@netlabs.com (Larry Wall)
Subject: Re: Problem with srand(time^$$)
Message-ID: <1994Mar21.233151.18460@netlabs.com>
Organization: NetLabs, Inc.
References: <CMwtCn.G1u@alsys.com>
Date: Mon, 21 Mar 1994 23:31:51 GMT
Lines: 22

In article <CMwtCn.G1u@alsys.com> kst@alsys.com (Keith Thompson @pulsar) writes:
: Even without this repeatability, one should probably use something better
: than the process ID and the time to generate random seeds, at least when
: security is relevant.  A malicious user on your system with access to
: your Perl random password generator could reproduce your password given
: a good idea of the time when you last changed it (say, by checking the
: access time of the script).

For higher security, use something like this:

    sub very_random {
	local($sum) = time ^ $$ * getppid();
	$sum ^= unpack("%32L*", join('',%ENV));
	open(PS, "/usr/bin/ps -eal|compress|");
	while (<PS>) {
	    $sum ^= unpack("%32L*", $_);
	}
	close PS;
	$sum;
    }

Larry


