# Generated by default/object.tt
package Paws::Batch::Ec2Configuration;
  use Moose;
  has ImageIdOverride => (is => 'ro', isa => 'Str', request_name => 'imageIdOverride', traits => ['NameInRequest']);
  has ImageType => (is => 'ro', isa => 'Str', request_name => 'imageType', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Batch::Ec2Configuration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Batch::Ec2Configuration object:

  $service_obj->Method(Att1 => { ImageIdOverride => $value, ..., ImageType => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Batch::Ec2Configuration object:

  $result = $service_obj->Method(...);
  $result->Att1->ImageIdOverride

=head1 DESCRIPTION

Provides information used to select Amazon Machine Images (AMIs) for
instances in the compute environment. If C<Ec2Configuration> isn't
specified, the default is currently C<ECS_AL1> (Amazon Linux
(https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#alami))
for non-GPU, non-Graviton instances. Starting on March 31, 2021, this
default will be changing to C<ECS_AL2> (Amazon Linux 2
(https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#al2ami)).

This object isn't applicable to jobs running on Fargate resources.

=head1 ATTRIBUTES


=head2 ImageIdOverride => Str

The AMI ID used for instances launched in the compute environment that
match the image type. This setting overrides the C<imageId> set in the
C<computeResource> object.


=head2 B<REQUIRED> ImageType => Str

The image type to match with the instance type to select an AMI. If the
C<imageIdOverride> parameter isn't specified, then a recent Amazon
ECS-optimized AMI
(https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html)
(C<ECS_AL1>) is used. Starting on March 31, 2021, this default will be
changing to C<ECS_AL2> (Amazon Linux 2
(https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#al2ami)).

=over

=item ECS_AL2

Amazon Linux 2
(https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#al2ami)E<minus>
Default for all AWS Graviton-based instance families (for example,
C<C6g>, C<M6g>, C<R6g>, and C<T4g>) and can be used for all non-GPU
instance types.

=item ECS_AL2_NVIDIA

Amazon Linux 2 (GPU)
(https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#gpuami)E<minus>Default
for all GPU instance families (for example C<P4> and C<G4>) and can be
used for all non-AWS Graviton-based instance types.

=item ECS_AL1

Amazon Linux
(https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html#alami)E<minus>Default
for all non-GPU, non-AWS Graviton instance families. Amazon Linux is
reaching the end-of-life of standard support. For more information, see
Amazon Linux AMI (http://aws.amazon.com/amazon-linux-ami/).

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Batch>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

