
#!/usr/bin/perl

# Test that all modules have a version number.

use strict;

BEGIN {
    BAIL_OUT ('Perl version unacceptably old.') if ($] < 5.008001);
    use English qw(-no_match_vars);
    $OUTPUT_AUTOFLUSH = 1;
    $WARNING = 1;
}

my @MODULES = (
    'Test::HasVersion 0.012',
);

# Load the testing modules
use Test::More;
foreach my $MODULE ( @MODULES ) {
    eval "use $MODULE";
    if ( $EVAL_ERROR ) {
        BAIL_OUT( "Failed to load required release-testing module $MODULE" );
    }
}

all_pm_version_ok();

