use strict;
use warnings;

package App::Embra::Plugin::Template::Basic;
$App::Embra::Plugin::Template::Basic::VERSION = '0.001'; # TRIAL
# ABSTRACT: simple HTML5 template

use Method::Signatures;
use App::Embra::Plugin::TemplateToolkit;
use File::ShareDir;
use Moo;



has 'assembler' => (
    is => 'lazy',
    handles => [ 'assemble_files' ],
);

method _build_assembler {
    App::Embra::Plugin::TemplateToolkit->new(
        embra        => $self->embra,
        logger       => $self,
        name         => 'TemplateToolkit',
        include_path => File::ShareDir::module_dir(__PACKAGE__),
    );
}

with 'App::Embra::Role::FileAssembler';

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

App::Embra::Plugin::Template::Basic - simple HTML5 template

=head1 VERSION

version 0.001

=head1 DESCRIPTION

This plugin will process site files through Template Toolkit with a pre-defined set of templates. For each file with a C<.html> extension, it will look for a template with a matching name and use it to process the contents of the file into an assembled HTML document.

The templates are stored as a L<File::ShareDir>, which in the source of the distribution are located at C<share/Plugin/Template/Basic>.

=head1 ATTRIBUTES

=head2 assembler

The object used to assemble files. Defaults to an instance of L<App::Embra::Plugin::TemplateToolkit>.

=head1 AUTHOR

Daniel Holz <dgholz@gmail.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Daniel Holz.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
