
package Apache::MP3::L10N::sk;  # Slovak
use strict;
use Apache::MP3::L10N;
use vars qw($VERSION @ISA %Lexicon);
@ISA = qw(Apache::MP3::L10N);
sub language_tag {__PACKAGE__->SUPER::language_tag}

# Translators for this module, in no particular order:
# Radovan Hrabcak duffy@duffy.sk

sub encoding { "iso-8859-2" }   # Latin-2
  # Change as necessary if you use a different encoding

%Lexicon = (
 '_VERSION' => __PACKAGE__ . ' v' . ($VERSION =
   '20020612'), # Last modified


 # These are links as well as button text:
 'Play All' => "Prehra vetko",
 'Shuffle All' => 'Nhodn poradie',  # Stream all in random order
 'Stream All' => 'Prehra vetko', # What's the difference between Strema All and Play All?

 # This one in just button text
 'Play Selected' => 'Prehra vybran',

 "In this demo, streaming is limited to approximately [quant,_1,second,seconds]."
  => "V tomto deme, je prehrvanie obmedzen; na pribline [quant,_1,sekundu,seknd].",
  # In [quant,_1,seconde,secondes], the seconde is the singular form, and the secondes is the plural.

 # Headings:
 'CD Directories ([_1])' => 'CD adresre ([_1])',
 'Playlists ([_1])' => 'Playlisty (.m3u) ([_1])',        # .m3u files
 'Song List ([_1])' => 'Zoznam skladieb ([_1])', # i.e., file list


 'Playlist' => 'Playlist',
 'Select' => 'Vybra',

 'fetch'  => 'uloi', # Send/download/save this file
 'stream' => 'hra',    # this file

 'Shuffle'  => 'Nhodn poradie',  # a subdirectory, recursively
 'Stream'   => 'Prehra',            # a subdirectory, recursively

 # Label for a link to "http://[servername]/"
 'Home' => 'Na zaiatok',

 # Credits
 "_CREDITS_before_author" => 'Apache::MP3 bol napsan ',
 "_CREDITS_author"        => 'Lincolnom D. Steinom',
 "_CREDITS_after_author"  => ".",


 'unknown' => '?',
   # Used when a file doesn't specify its album name, artist name,
   # year of release, etc.


 # Metadata fields:
 'Artist' => "Interpret",
 'Comment' => "Poznmky",
 'Duration' => "Dka",
 'Filename' => "Nzov",
 'Genre' => "ner",  # i.e., what kind of music
 'Album' => "Album",
 'Min' => "min.",  # abbreviation for "minutes"
 'Track' => "Skladba",  # just the track number (not the track name)
 'Sec' => "sek.",  # abbreviation for "seconds"
 'Seconds' => "Seknd",
 'Title' => "Nzov",
 'Year' => "Rok",

 'Samplerate' => "Kvalita pvodnho zvuku",
 'Bitrate' => "Kvalita zvuku (bitrate)",


 # Now the stuff for the help page:

 'Quick Help Summary' => "Prehad npovedy",
  # page title as well as the text we use for linking to that page

 "= Stream all songs" => "= Prerha; vetky skladby",
 "= Shuffle-play all Songs" => "= Prerha vetky skladby v nhodnom porad",
 "= Go to earlier directory" => "= O rove vyie",
       # i.e., just a link to ../ or higher
 "= Stream contents" => "= Prehra obsah",
 "= Enter directory" => "= Do adresra",
 "= Stream this song" => "= Prehra tto skladbu",
 "= Select for streaming" => "= Vybra na prehratie",
 "= Download this song" => "= Uloi tto skladbu",
 "= Stream this song" => "= Prehra tto skladbu",
 "= Sort by field" => "= Usporiada poda",
    # "sort" in the sense of ordering, not separating out.
);

1;

