package main;
use strict;
use warnings;
use Test::More tests => 2, import => ['!pass'];

{
    use Dancer;
    get '/CVE-2012-5572-cookie' => sub {
        cookie "test\r\nX-Evil-Header: " => "evil";
    };
}


use Dancer::Test;
{
    note "Testing CVE-2012-5572 (CRLF in response headers)";
    my $req = [GET => '/CVE-2012-5572-cookie'];
    route_exists $req;
    my $response = Dancer::Test::_req_to_response($req);

    my $CRLF = "\r\n";

    my $tb = Test::Builder->new;
    my %headers = @{$response->headers_to_array};
    my $foundCRLF = 0;
    while (my($name, $value) = each %headers) {
       index($value, $CRLF) == -1
         && index($name, $CRLF) == -1
         && next;
       $foundCRLF = 1;
       last;
    }

    $tb->ok(!$foundCRLF, 'Headers do not contain CRLF (CVE-2012-5572)');
}


1;

