# Generated by default/object.tt
package Paws::CustomerProfiles::Profile;
  use Moose;
  has AccountNumber => (is => 'ro', isa => 'Str');
  has AdditionalInformation => (is => 'ro', isa => 'Str');
  has Address => (is => 'ro', isa => 'Paws::CustomerProfiles::Address');
  has Attributes => (is => 'ro', isa => 'Paws::CustomerProfiles::Attributes');
  has BillingAddress => (is => 'ro', isa => 'Paws::CustomerProfiles::Address');
  has BirthDate => (is => 'ro', isa => 'Str');
  has BusinessEmailAddress => (is => 'ro', isa => 'Str');
  has BusinessName => (is => 'ro', isa => 'Str');
  has BusinessPhoneNumber => (is => 'ro', isa => 'Str');
  has EmailAddress => (is => 'ro', isa => 'Str');
  has FirstName => (is => 'ro', isa => 'Str');
  has Gender => (is => 'ro', isa => 'Str');
  has HomePhoneNumber => (is => 'ro', isa => 'Str');
  has LastName => (is => 'ro', isa => 'Str');
  has MailingAddress => (is => 'ro', isa => 'Paws::CustomerProfiles::Address');
  has MiddleName => (is => 'ro', isa => 'Str');
  has MobilePhoneNumber => (is => 'ro', isa => 'Str');
  has PartyType => (is => 'ro', isa => 'Str');
  has PersonalEmailAddress => (is => 'ro', isa => 'Str');
  has PhoneNumber => (is => 'ro', isa => 'Str');
  has ProfileId => (is => 'ro', isa => 'Str');
  has ShippingAddress => (is => 'ro', isa => 'Paws::CustomerProfiles::Address');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CustomerProfiles::Profile

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CustomerProfiles::Profile object:

  $service_obj->Method(Att1 => { AccountNumber => $value, ..., ShippingAddress => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CustomerProfiles::Profile object:

  $result = $service_obj->Method(...);
  $result->Att1->AccountNumber

=head1 DESCRIPTION

The standard profile of a customer.

=head1 ATTRIBUTES


=head2 AccountNumber => Str

A unique account number that you have given to the customer.


=head2 AdditionalInformation => Str

Any additional information relevant to the customerE<rsquo>s profile.


=head2 Address => L<Paws::CustomerProfiles::Address>

A generic address associated with the customer that is not mailing,
shipping, or billing.


=head2 Attributes => L<Paws::CustomerProfiles::Attributes>

A key value pair of attributes of a customer profile.


=head2 BillingAddress => L<Paws::CustomerProfiles::Address>

The customerE<rsquo>s billing address.


=head2 BirthDate => Str

The customerE<rsquo>s birth date.


=head2 BusinessEmailAddress => Str

The customerE<rsquo>s business email address.


=head2 BusinessName => Str

The name of the customerE<rsquo>s business.


=head2 BusinessPhoneNumber => Str

The customerE<rsquo>s home phone number.


=head2 EmailAddress => Str

The customerE<rsquo>s email address, which has not been specified as a
personal or business address.


=head2 FirstName => Str

The customerE<rsquo>s first name.


=head2 Gender => Str

The gender with which the customer identifies.


=head2 HomePhoneNumber => Str

The customerE<rsquo>s home phone number.


=head2 LastName => Str

The customerE<rsquo>s last name.


=head2 MailingAddress => L<Paws::CustomerProfiles::Address>

The customerE<rsquo>s mailing address.


=head2 MiddleName => Str

The customerE<rsquo>s middle name.


=head2 MobilePhoneNumber => Str

The customerE<rsquo>s mobile phone number.


=head2 PartyType => Str

The type of profile used to describe the customer.


=head2 PersonalEmailAddress => Str

The customerE<rsquo>s personal email address.


=head2 PhoneNumber => Str

The customer's phone number, which has not been specified as a mobile,
home, or business number.


=head2 ProfileId => Str

The unique identifier of a customer profile.


=head2 ShippingAddress => L<Paws::CustomerProfiles::Address>

The customerE<rsquo>s shipping address.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CustomerProfiles>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

