/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.pipeline;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.trees.semgraph.SemanticGraph;
import edu.stanford.nlp.trees.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.trees.semgraph.SemanticGraphFactory;
import edu.stanford.nlp.util.CoreMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ParserAnnotatorUtils {
    private ParserAnnotatorUtils() {
    }

    public static SemanticGraph generateDependencies(Tree tree, boolean collapse, boolean ccProcess, boolean includeExtras, boolean lemmatize, boolean threadSafe) {
        SemanticGraph deps = SemanticGraphFactory.makeFromTree(tree, collapse, ccProcess, includeExtras, lemmatize, threadSafe);
        return deps;
    }

    public static SemanticGraph generateUncollapsedDependencies(Tree tree) {
        return ParserAnnotatorUtils.generateDependencies(tree, false, false, false, true, true);
    }

    public static SemanticGraph generateCollapsedDependencies(Tree tree) {
        return ParserAnnotatorUtils.generateDependencies(tree, true, false, false, true, true);
    }

    public static SemanticGraph generateCCProcessedDependencies(Tree tree) {
        return ParserAnnotatorUtils.generateDependencies(tree, true, true, false, true, true);
    }

    public static void fillInParseAnnotations(boolean verbose, boolean buildGraphs, CoreMap sentence, Tree tree) {
        ParserAnnotatorUtils.convertToCoreLabels(tree);
        tree.indexSpans(0);
        sentence.set(TreeCoreAnnotations.TreeAnnotation.class, tree);
        if (verbose) {
            System.err.println("Tree is:");
            tree.pennPrint(System.err);
        }
        if (buildGraphs) {
            SemanticGraph deps = ParserAnnotatorUtils.generateCollapsedDependencies(tree);
            SemanticGraph uncollapsedDeps = ParserAnnotatorUtils.generateUncollapsedDependencies(tree);
            SemanticGraph ccDeps = ParserAnnotatorUtils.generateCCProcessedDependencies(tree);
            if (verbose) {
                System.err.println("SDs:");
                System.err.println(deps.toString("plain"));
            }
            sentence.set(SemanticGraphCoreAnnotations.CollapsedDependenciesAnnotation.class, deps);
            sentence.set(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class, uncollapsedDeps);
            sentence.set(SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class, ccDeps);
        }
        ParserAnnotatorUtils.setMissingTags(sentence, tree);
    }

    public static void setMissingTags(CoreMap sentence, Tree tree) {
        ArrayList<TaggedWord> taggedWords = null;
        ArrayList<Label> leaves = null;
        List tokens = (List)sentence.get(CoreAnnotations.TokensAnnotation.class);
        for (int i = 0; i < tokens.size(); ++i) {
            CoreLabel token = (CoreLabel)tokens.get(i);
            if (token.tag() != null) continue;
            if (taggedWords == null) {
                taggedWords = tree.taggedYield();
            }
            if (leaves == null) {
                leaves = tree.yield();
            }
            token.setTag(((TaggedWord)taggedWords.get(i)).tag());
            Label leaf = (Label)leaves.get(i);
            if (!(leaf instanceof HasTag)) continue;
            ((HasTag)((Object)leaf)).setTag(((TaggedWord)taggedWords.get(i)).tag());
        }
    }

    public static void convertToCoreLabels(Tree tree) {
        Label l = tree.label();
        if (!(l instanceof CoreLabel)) {
            CoreLabel cl = new CoreLabel();
            cl.setValue(l.value());
            tree.setLabel(cl);
        }
        for (Tree kid : tree.children()) {
            ParserAnnotatorUtils.convertToCoreLabels(kid);
        }
    }

    public static Tree xTree(List<? extends HasWord> words) {
        LabeledScoredTreeFactory lstf = new LabeledScoredTreeFactory();
        ArrayList<Tree> lst2 = new ArrayList<Tree>();
        for (HasWord hasWord : words) {
            String s = hasWord.word();
            Tree t = lstf.newLeaf(s);
            Tree t2 = lstf.newTreeNode("X", Collections.singletonList(t));
            lst2.add(t2);
        }
        return lstf.newTreeNode("X", lst2);
    }
}

