/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.PropertyUtil;
import java.awt.Image;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.media.jai.JaiI18N;
import javax.media.jai.PropertySource;
import javax.media.jai.util.CaselessStringKey;

public class PropertySourceImpl
implements PropertySource,
Serializable {
    protected transient Map properties = new Hashtable();
    protected transient Map propertySources = new Hashtable();
    protected Set cachedPropertyNames = Collections.synchronizedSet(new HashSet());

    protected PropertySourceImpl() {
    }

    public PropertySourceImpl(Map map, PropertySource propertySource) {
        this();
        String[] stringArray;
        Class<Object> clazz;
        if (map == null && propertySource == null) {
            boolean bl = false;
            try {
                clazz = Class.forName("javax.media.jai.PropertySourceImpl");
                bl = this.getClass().equals(clazz);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bl) {
                throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
            }
        }
        if (map != null) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                clazz = iterator.next();
                if (clazz instanceof String) {
                    this.properties.put(new CaselessStringKey((String)((Object)clazz)), map.get(clazz));
                    continue;
                }
                if (!(clazz instanceof CaselessStringKey)) continue;
                this.properties.put((CaselessStringKey)((Object)clazz), map.get(clazz));
            }
        }
        if (propertySource != null && (stringArray = propertySource.getPropertyNames()) != null) {
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                this.propertySources.put(new CaselessStringKey(stringArray[n2]), propertySource);
                ++n2;
            }
        }
    }

    public String[] getPropertyNames() {
        Map map = this.properties;
        synchronized (map) {
            if (this.properties.size() + this.propertySources.size() == 0) {
                String[] stringArray = null;
                return stringArray;
            }
            Set set = Collections.synchronizedSet(new HashSet(this.properties.keySet()));
            set.addAll(this.propertySources.keySet());
            int n = set.size();
            String[] stringArray = new String[n];
            Iterator iterator = set.iterator();
            int n2 = 0;
            while (iterator.hasNext() && n2 < n) {
                stringArray[n2++] = ((CaselessStringKey)iterator.next()).getName();
            }
            String[] stringArray2 = stringArray;
            return stringArray2;
        }
    }

    public String[] getPropertyNames(String string) {
        return PropertyUtil.getPropertyNames(this.getPropertyNames(), string);
    }

    public Class getPropertyClass(String string) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        Map map = this.properties;
        synchronized (map) {
            Class<?> clazz = null;
            Object v = this.properties.get(new CaselessStringKey(string));
            if (v != null) {
                clazz = v.getClass();
            }
            Class<?> clazz2 = clazz;
            return clazz2;
        }
    }

    public Object getProperty(String string) {
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("Generic0"));
        }
        Map map = this.properties;
        synchronized (map) {
            Object object;
            CaselessStringKey caselessStringKey = new CaselessStringKey(string);
            Object object2 = this.properties.get(caselessStringKey);
            if (object2 == null) {
                object = (PropertySource)this.propertySources.get(caselessStringKey);
                if (object != null) {
                    object2 = object.getProperty(string);
                    if (object2 != Image.UndefinedProperty) {
                        this.properties.put(caselessStringKey, object2);
                        this.cachedPropertyNames.add(caselessStringKey);
                    }
                } else {
                    object2 = Image.UndefinedProperty;
                }
            }
            object = object2;
            return object;
        }
    }

    public Map getProperties() {
        if (this.properties.size() + this.propertySources.size() == 0) {
            return null;
        }
        Map map = this.properties;
        synchronized (map) {
            Hashtable<String, Object> hashtable = null;
            String[] stringArray = this.getPropertyNames();
            if (stringArray != null) {
                int n = stringArray.length;
                hashtable = new Hashtable<String, Object>(this.properties.size());
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    Object object = this.getProperty(string);
                    hashtable.put(string, object);
                    ++n2;
                }
            }
            Hashtable<String, Object> hashtable2 = hashtable;
            return hashtable2;
        }
    }

    private static void writeMap(ObjectOutputStream objectOutputStream, Map map) throws IOException {
        Hashtable hashtable = new Hashtable();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Object v = map.get(k);
            if (!(v instanceof Serializable)) continue;
            hashtable.put(k, v);
        }
        objectOutputStream.writeObject(hashtable);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Map map = this.properties;
        synchronized (map) {
            PropertySourceImpl.writeMap(objectOutputStream, this.properties);
            PropertySourceImpl.writeMap(objectOutputStream, this.propertySources);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.properties = (Map)objectInputStream.readObject();
        this.propertySources = (Map)objectInputStream.readObject();
        Iterator iterator = this.cachedPropertyNames.iterator();
        Set set = this.properties.keySet();
        while (iterator.hasNext()) {
            if (set.contains(iterator.next())) continue;
            iterator.remove();
        }
    }
}

