/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.TFloatFunction;
import gnu.trove.TFloatProcedure;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;

public class TFloatArrayList
implements Serializable,
Cloneable {
    protected static final int DEFAULT_CAPACITY = 10;
    protected float[] _data;
    protected int _pos;

    public void ensureCapacity(int capacity) {
        if (capacity > this._data.length) {
            int newCap = Math.max(this._data.length << 1, capacity);
            float[] tmp = new float[newCap];
            System.arraycopy(this._data, 0, tmp, 0, this._data.length);
            this._data = tmp;
        }
    }

    public int size() {
        return this._pos;
    }

    public boolean isEmpty() {
        return this._pos == 0;
    }

    public void trimToSize() {
        if (this._data.length > this.size()) {
            float[] tmp = new float[this.size()];
            this.toNativeArray(tmp, 0, tmp.length);
            this._data = tmp;
        }
    }

    public void add(float val) {
        this.ensureCapacity(this._pos + 1);
        this._data[this._pos++] = val;
    }

    public void add(float[] vals) {
        this.add(vals, 0, vals.length);
    }

    public void add(float[] vals, int offset, int length) {
        this.ensureCapacity(this._pos + length);
        System.arraycopy(vals, offset, this._data, this._pos, length);
        this._pos += length;
    }

    public void insert(int offset, float value) {
        if (offset == this._pos) {
            this.add(value);
            return;
        }
        this.ensureCapacity(this._pos + 1);
        System.arraycopy(this._data, offset, this._data, offset + 1, this._pos - offset);
        this._data[offset] = value;
        ++this._pos;
    }

    public void insert(int offset, float[] values) {
        this.insert(offset, values, 0, values.length);
    }

    public void insert(int offset, float[] values, int valOffset, int len) {
        if (offset == this._pos) {
            this.add(values, valOffset, len);
            return;
        }
        this.ensureCapacity(this._pos + len);
        System.arraycopy(this._data, offset, this._data, offset + len, this._pos - offset);
        System.arraycopy(values, valOffset, this._data, offset, len);
        this._pos += len;
    }

    public float get(int offset) {
        if (offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        return this._data[offset];
    }

    public float getQuick(int offset) {
        return this._data[offset];
    }

    public void set(int offset, float val) {
        if (offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        this._data[offset] = val;
    }

    public float getSet(int offset, float val) {
        if (offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        float old = this._data[offset];
        this._data[offset] = val;
        return old;
    }

    public void set(int offset, float[] values) {
        this.set(offset, values, 0, values.length);
    }

    public void set(int offset, float[] values, int valOffset, int length) {
        if (offset < 0 || offset + length >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        System.arraycopy(this._data, offset, values, valOffset, length);
    }

    public void setQuick(int offset, float val) {
        this._data[offset] = val;
    }

    public void clear() {
        this.clear(10);
    }

    public void clear(int capacity) {
        this._data = new float[capacity];
        this._pos = 0;
    }

    public void reset() {
        this._pos = 0;
        this.fill(0.0f);
    }

    public void resetQuick() {
        this._pos = 0;
    }

    public float remove(int offset) {
        float old = this.get(offset);
        this.remove(offset, 1);
        return old;
    }

    public void remove(int offset, int length) {
        if (offset < 0 || offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        if (offset == 0) {
            System.arraycopy(this._data, length, this._data, 0, this._pos - length);
        } else if (this._pos - length != offset) {
            System.arraycopy(this._data, offset + length, this._data, offset, this._pos - (offset + length));
        }
        this._pos -= length;
    }

    public void transformValues(TFloatFunction function) {
        int i = this._pos;
        while (i-- > 0) {
            this._data[i] = function.execute(this._data[i]);
        }
    }

    public void reverse() {
        this.reverse(0, this._pos);
    }

    public void reverse(int from, int to) {
        if (from == to) {
            return;
        }
        if (from > to) {
            throw new IllegalArgumentException("from cannot be greater than to");
        }
        int i = from;
        int j = to - 1;
        while (i < j) {
            this.swap(i, j);
            ++i;
            --j;
        }
    }

    public void shuffle(Random rand) {
        int i = this._pos;
        while (i-- > 1) {
            this.swap(i, rand.nextInt(i));
        }
    }

    private final void swap(int i, int j) {
        float tmp = this._data[i];
        this._data[i] = this._data[j];
        this._data[j] = tmp;
    }

    public Object clone() {
        Object o = null;
        try {
            o = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return o;
    }

    public float[] toNativeArray() {
        return this.toNativeArray(0, this._pos);
    }

    public float[] toNativeArray(int offset, int len) {
        float[] rv = new float[len];
        this.toNativeArray(rv, offset, len);
        return rv;
    }

    public void toNativeArray(float[] dest, int offset, int len) {
        if (len == 0) {
            return;
        }
        if (offset < 0 || offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        System.arraycopy(this._data, 0, dest, offset, len);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof TFloatArrayList) {
            TFloatArrayList that = (TFloatArrayList)other;
            if (that.size() != this.size()) {
                return false;
            }
            int i = this._pos;
            while (i-- > 0) {
                if (this._data[i] == that._data[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean forEach(TFloatProcedure procedure) {
        int i = 0;
        while (i < this._pos) {
            if (!procedure.execute(this._data[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean forEachDescending(TFloatProcedure procedure) {
        int i = this._pos;
        while (i-- > 0) {
            if (procedure.execute(this._data[i])) continue;
            return false;
        }
        return true;
    }

    public void sort() {
        Arrays.sort(this._data, 0, this._pos);
    }

    public void sort(int fromIndex, int toIndex) {
        Arrays.sort(this._data, fromIndex, toIndex);
    }

    public void fill(float val) {
        Arrays.fill(this._data, 0, this._pos, val);
    }

    public void fill(int fromIndex, int toIndex, float val) {
        Arrays.fill(this._data, fromIndex, toIndex, val);
    }

    public int binarySearch(float value) {
        return this.binarySearch(value, 0, this._pos);
    }

    public int binarySearch(float value, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > this._pos) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            float midVal = this._data[mid];
            if (midVal < value) {
                low = mid + 1;
                continue;
            }
            if (midVal > value) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public int indexOf(float value) {
        return this.indexOf(0, value);
    }

    public int indexOf(int offset, float value) {
        int i = offset;
        while (i < this._pos) {
            if (this._data[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int lastIndexOf(float value) {
        return this.lastIndexOf(this._pos, value);
    }

    public int lastIndexOf(int offset, float value) {
        int i = offset;
        while (i-- > 0) {
            if (this._data[i] != value) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(float value) {
        return this.lastIndexOf(value) >= 0;
    }

    public TFloatArrayList grep(TFloatProcedure condition) {
        TFloatArrayList list = new TFloatArrayList();
        int i = 0;
        while (i < this._pos) {
            if (condition.execute(this._data[i])) {
                list.add(this._data[i]);
            }
            ++i;
        }
        return list;
    }

    public TFloatArrayList inverseGrep(TFloatProcedure condition) {
        TFloatArrayList list = new TFloatArrayList();
        int i = 0;
        while (i < this._pos) {
            if (!condition.execute(this._data[i])) {
                list.add(this._data[i]);
            }
            ++i;
        }
        return list;
    }

    public float max() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find maximum of an empty list");
        }
        float max = this._data[this._pos - 1];
        int i = this._pos - 1;
        while (i-- > 0) {
            max = Math.max(max, this._data[this._pos]);
        }
        return max;
    }

    public float min() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find minimum of an empty list");
        }
        float min = this._data[this._pos - 1];
        int i = this._pos - 1;
        while (i-- > 0) {
            min = Math.min(min, this._data[this._pos]);
        }
        return min;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("{");
        this.forEach(new TFloatProcedure(this, buf){
            private final /* synthetic */ TFloatArrayList this$0;
            private final /* synthetic */ StringBuffer val$buf;

            public final boolean execute(float val) {
                this.val$buf.append(val);
                this.val$buf.append(", ");
                return true;
            }
            {
                this.val$buf = val$buf;
                this.this$0 = this$0;
                this.constructor$0(this$0);
            }

            private final void constructor$0(TFloatArrayList tFloatArrayList) {
            }
        });
        buf.append("}");
        return buf.toString();
    }

    public TFloatArrayList() {
        this(10);
    }

    public TFloatArrayList(int capacity) {
        this._data = new float[capacity];
        this._pos = 0;
    }

    public TFloatArrayList(float[] values) {
        this(Math.max(values.length, 10));
        this.add(values);
    }
}

