
package Paws::Schemas::ListSchemaVersions;
  use Moose;
  has Limit => (is => 'ro', isa => 'Int', traits => ['ParamInQuery'], query_name => 'limit');
  has NextToken => (is => 'ro', isa => 'Str', traits => ['ParamInQuery'], query_name => 'nextToken');
  has RegistryName => (is => 'ro', isa => 'Str', traits => ['ParamInURI'], uri_name => 'registryName', required => 1);
  has SchemaName => (is => 'ro', isa => 'Str', traits => ['ParamInURI'], uri_name => 'schemaName', required => 1);

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'ListSchemaVersions');
  class_has _api_uri  => (isa => 'Str', is => 'ro', default => '/v1/registries/name/{registryName}/schemas/name/{schemaName}/versions');
  class_has _api_method  => (isa => 'Str', is => 'ro', default => 'GET');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::Schemas::ListSchemaVersionsResponse');
1;

### main pod documentation begin ###

=head1 NAME

Paws::Schemas::ListSchemaVersions - Arguments for method ListSchemaVersions on L<Paws::Schemas>

=head1 DESCRIPTION

This class represents the parameters used for calling the method ListSchemaVersions on the
L<Schemas|Paws::Schemas> service. Use the attributes of this class
as arguments to method ListSchemaVersions.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to ListSchemaVersions.

=head1 SYNOPSIS

    my $schemas = Paws->service('Schemas');
    my $ListSchemaVersionsResponse = $schemas->ListSchemaVersions(
      RegistryName => 'My__string',
      SchemaName   => 'My__string',
      Limit        => 1,               # OPTIONAL
      NextToken    => 'My__string',    # OPTIONAL
    );

    # Results:
    my $NextToken      = $ListSchemaVersionsResponse->NextToken;
    my $SchemaVersions = $ListSchemaVersionsResponse->SchemaVersions;

    # Returns a L<Paws::Schemas::ListSchemaVersionsResponse> object.

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.
For the AWS API documentation, see L<https://docs.aws.amazon.com/goto/WebAPI/schemas/ListSchemaVersions>

=head1 ATTRIBUTES


=head2 Limit => Int





=head2 NextToken => Str





=head2 B<REQUIRED> RegistryName => Str





=head2 B<REQUIRED> SchemaName => Str






=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method ListSchemaVersions in L<Paws::Schemas>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

