# Generated by default/object.tt
package Paws::SecurityHub::AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails;
  use Moose;
  has AuthorizationConfig => (is => 'ro', isa => 'Paws::SecurityHub::AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails');
  has FilesystemId => (is => 'ro', isa => 'Str');
  has RootDirectory => (is => 'ro', isa => 'Str');
  has TransitEncryption => (is => 'ro', isa => 'Str');
  has TransitEncryptionPort => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails object:

  $service_obj->Method(Att1 => { AuthorizationConfig => $value, ..., TransitEncryptionPort => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationDetails object:

  $result = $service_obj->Method(...);
  $result->Att1->AuthorizationConfig

=head1 DESCRIPTION

Information about the Amazon Elastic File System file system that is
used for task storage.

=head1 ATTRIBUTES


=head2 AuthorizationConfig => L<Paws::SecurityHub::AwsEcsTaskDefinitionVolumesEfsVolumeConfigurationAuthorizationConfigDetails>

The authorization configuration details for the Amazon EFS file system.


=head2 FilesystemId => Str

The Amazon EFS file system identifier to use.


=head2 RootDirectory => Str

The directory within the Amazon EFS file system to mount as the root
directory inside the host.


=head2 TransitEncryption => Str

Whether to enable encryption for Amazon EFS data in transit between the
Amazon ECS host and the Amazon EFS server.


=head2 TransitEncryptionPort => Int

The port to use when sending encrypted data between the Amazon ECS host
and the Amazon EFS server.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

