/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.graphic.FontChange;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;

class ColorAndSizeChange
implements FontChange {
    static final Pattern colorPattern = MyPattern.cmpile("(?i)color\\s*=\\s*[%g]?(#[0-9a-fA-F]{6}|\\w+)[%g]?");
    static final Pattern sizePattern = MyPattern.cmpile("(?i)size\\s*=\\s*[%g]?(\\d+)[%g]?");
    private final HtmlColor color;
    private final Integer size;

    ColorAndSizeChange(String string) {
        Matcher matcher = colorPattern.matcher(string);
        this.color = matcher.find() ? HtmlColorUtils.getColorIfValid(matcher.group(1)) : null;
        Matcher matcher2 = sizePattern.matcher(string);
        this.size = matcher2.find() ? new Integer(matcher2.group(1)) : null;
    }

    HtmlColor getColor() {
        return this.color;
    }

    Integer getSize() {
        return this.size;
    }

    public FontConfiguration apply(FontConfiguration fontConfiguration) {
        FontConfiguration fontConfiguration2 = fontConfiguration;
        if (this.color != null) {
            fontConfiguration2 = fontConfiguration2.changeColor(this.color);
        }
        if (this.size != null) {
            fontConfiguration2 = fontConfiguration2.changeSize(this.size.intValue());
        }
        return fontConfiguration2;
    }
}

