/* translation of file(s)
	"bpel-abstract.k"
	"bpel-unparse-petri.k"
	"bpel-unparse-petri2.k"
	"bpel-unparse-xml.k"
	"bpel-unparse-cfg.k"
	"ast-printers.k"
 */
/* generated by:
 *  @(#)$Author: Kimwitu++ version 2.3.8 (C) 1998-2003 Humboldt-University of Berlin $
 */
#define KC_TYPES

#include "bpel-kc-k.h"
#include <stdio.h>
#include <ctype.h>
#include <string>
#include <sys/types.h>
#include <stdlib.h>

#ifdef _MSC_VER
#pragma warning( disable : 4786 )
#endif
#include <new>
#include <set>
#include <list>
#include <algorithm>

#if !defined(USE_HASHSET) && (defined(__GNUC__) || defined(__ICC) || defined(__ECC)) \
&& !defined(DONT_USE_HASHSET)
#  define USE_HASHSET
#endif
#ifdef USE_HASHSET
#  if defined(__GNUC__) && __GNUC__>2
#    include <ext/hash_set>
#  else
#    include <hash_set>
#  endif
#endif

using namespace std;

namespace kc {

inline bool
ht_less(casestring p1, casestring p2){
    return kc_strcmp(p1->name, p2->name)<0;
}

inline bool
ht_less(nocasestring p1, nocasestring p2){
    return kc_strcasecmp(p1->name, p2->name)<0;
}

inline bool
ht_less(real p1, real p2){
    return p1->value < p2->value;
}

inline bool
ht_less(integer p1, integer p2){
    return p1->value < p2->value;
}

inline bool
ht_less(voidptr p1, voidptr p2){
    return p1->pointer < p2->pointer;
}

bool
ht_less(abstract_phylum p1, abstract_phylum p2)
{
    enum_operators prod_sel=p1->prod_sel();
    enum_operators prod_sel2=p2->prod_sel();
    if(prod_sel<prod_sel2)
	return true;
    if(prod_sel>prod_sel2)
	return false;
    switch(prod_sel) {
	case sel_NoCaseStr:
	    return ht_less(static_cast<nocasestring>(p1),static_cast<nocasestring>(p2));
	case sel__Str:
	    return ht_less(static_cast<casestring>(p1),static_cast<casestring>(p2));
	case sel__Real:
	    return ht_less(static_cast<real>(p1),static_cast<real>(p2));
	case sel__Int:
	    return ht_less(static_cast<integer>(p1),static_cast<integer>(p2));
	case sel__VoidPtr:
	    return ht_less(static_cast<voidptr>(p1),static_cast<voidptr>(p2));
	default: {
	    int i=0;
	    bool still_unique = kc_storageclass_still_uniq[phylum_info[p1->phylum()].uniq_stored];
	    abstract_phylum sub1=0;
	    do {
		sub1=p1->subphylum(i);
		abstract_phylum sub2=p2->subphylum(i);
		if(still_unique) {
		    if(sub1<sub2)
			return true;
		    if(sub2<sub1)
			return false;
		}
		else {
		    if(ht_less(sub1, sub2))
			return true;
		    if(ht_less(sub2, sub1))
			return false;
		}
		++i;
	    } while(sub1);
	}
    }
    return false;
}

template<typename T>
class phylum_less : std::binary_function<T, T, bool>
{
    public:
    bool operator()(const T& X, const T& Y) const
	{ return ht_less(X,Y); }
};

inline void deletefun(c_abstract_phylum t){
    delete const_cast<abstract_phylum>(t);
}


#ifdef USE_HASHSET
struct hashitem {
    size_t hashvalue;
    casestring contents;
    hashitem(casestring cs): contents(cs) {
	unsigned long h = 0;
	kc_char_t const *s = cs->name;
	for ( ; *s; ++s)
	    h = 5*h + *s;
	hashvalue=(size_t)h;
    }
};

inline void deletefunhashitem(hashitem t) {
    delete t.contents;
}

#  ifdef __GNUC__
struct eq_hashitem { bool operator()(hashitem hi1, hashitem hi2) const {
	return kc_strcmp(hi1.contents->name, hi2.contents->name) == 0; } };

struct hash_hashitem { size_t operator()(hashitem hi) const {
	return hi.hashvalue; } };

#  else
struct comp_hashitem {
    enum { bucket_size = 4, min_buckets = 8 };
    // bucket_size and min_buckets are just guesses
    size_t operator()(const hashitem hi) const {
	return hi.hashvalue; }
    bool operator()(const hashitem hi1, const hashitem hi2) const {
	return kc_strcmp(hi1.contents->name, hi2.contents->name) < 0; }
};
#  endif // Whether gcc or icc
#endif // Whether hash or not

struct hashtable_level
{
    hashtable_level(bool cod = true): clean_on_destruction(cod) { }
    void clear(bool free_entries=true) {
	if(free_entries)
	    clear_entries();
	_casestring.clear();
	_nocasestring.clear();
	_integer.clear();
	_real.clear();
	_voidptr.clear();
	_abstract_phylum.clear();
    }
    void clear_entries() {
#ifdef USE_HASHSET
	std::for_each(_casestring.begin(),_casestring.end(),deletefunhashitem);
#else
	std::for_each(_casestring.begin(),_casestring.end(),deletefun);
#endif
	std::for_each(_nocasestring.begin(),_nocasestring.end(),deletefun);
	std::for_each(_integer.begin(),_integer.end(),deletefun);
	std::for_each(_real.begin(),_real.end(),deletefun);
	std::for_each(_voidptr.begin(),_voidptr.end(),deletefun);
	std::for_each(_abstract_phylum.begin(),_abstract_phylum.end(),deletefun);
    }
    ~hashtable_level() {
	clear(clean_on_destruction);
    }
    abstract_phylum check_insert(abstract_phylum t) {
	return *_abstract_phylum.insert(t).first;
    }
    casestring check_insert(casestring t) {
#ifdef USE_HASHSET
	return (*_casestring.insert(hashitem(t)).first).contents;
#else
	return *_casestring.insert(t).first;
#endif
    }
    nocasestring check_insert(nocasestring t) {
	return *_nocasestring.insert(t).first;
    }
    integer check_insert(integer t) {
	return *_integer.insert(t).first;
    }
    real check_insert(real t) {
	return *_real.insert(t).first;
    }
    voidptr check_insert(voidptr t) {
	return *_voidptr.insert(t).first;
    }
private:
    bool clean_on_destruction;
#ifdef USE_HASHSET
#  ifdef __GNUC__
#    if __GNUC__==2 || (__GNUC__==3 && __GNUC_MINOR__==0)
    std::hash_set<hashitem, hash_hashitem, eq_hashitem> _casestring;
#    else
    __gnu_cxx::hash_set<hashitem, hash_hashitem, eq_hashitem> _casestring;
#    endif
#  else
    std::hash_set<hashitem, comp_hashitem> _casestring;
#  endif
#else
    std::set<casestring, phylum_less<casestring> > _casestring;
#endif
    std::set<nocasestring, phylum_less<nocasestring> > _nocasestring;
    std::set<integer, phylum_less<integer> > _integer;
    std::set<real, phylum_less<real> > _real;
    std::set<voidptr, phylum_less<voidptr> > _voidptr;
    std::set<abstract_phylum, phylum_less<abstract_phylum> > _abstract_phylum;
};

class hashtable_stack: public std::list<hashtable_level> {
public:
    hashtable_stack(): _pos(begin()) { }

    void inc_level() { _pos=insert(_pos, hashtable_level()); }
    void dec_level() { if(valid() && _pos!=end()) ++_pos; }
    void free_level() { if(_pos!=begin()) { erase(begin(),_pos);_pos=begin(); } }

    bool valid() const { return !empty(); }
    hashtable_level& get_level() { return *_pos; }

    template<typename T>
    T check_insert(T t) {
	return dynamic_cast<T>((*_pos).check_insert(t));
    }
private:
    iterator _pos;
};

class hashtable_struct_t {
public:
    // don't clean _static_level on destruction (program ends)
    hashtable_struct_t(): _static_level(false), _to_be_freed(false),  _dynamic(false) { }

    template <typename T>
    T ht_check_insert(T t) {
	if(_dynamic && _dynamic_level.valid())
	    return _dynamic_level.check_insert(t);
	else
	    return dynamic_cast<T>(_static_level.check_insert(t));
    }
    void ht_static() {_dynamic=false; }
    void ht_dynamic() {
	_dynamic=true;
	if(!_dynamic_level.valid())
	    _dynamic_level.inc_level();
    }
    void ht_inc_level() { _dynamic_level.inc_level(); }
    void ht_dec_level() { _dynamic_level.dec_level(); }
    void ht_free_level() { _dynamic_level.free_level(); }
    void ht_clear() { _static_level.clear(); _dynamic_level.clear(); _dynamic=false; }

    bool to_be_freed() { return _to_be_freed; }
    void set_to_be_freed(bool b=true) { _to_be_freed=b; }
private:
    hashtable_level _static_level;
    hashtable_stack _dynamic_level;
    bool _to_be_freed; /* should be true for dynamic, false for statically allocated structures */
    bool _dynamic;
};

impl_nocasestring_NoCaseStr::impl_nocasestring_NoCaseStr(const kc_char_t* _name) : name(_name) { }
void impl_nocasestring_NoCaseStr::make_own(int length) {
    kc_char_t *newname=new kc_char_t[length+1];
    for (int i=0; i < length && name[i]; ++i)
    newname[i] = kc_tolower(name[i]);
    newname[length]=0;
    name=newname;
}

impl_casestring__Str::impl_casestring__Str(const kc_char_t* _name) : name(_name) { }
void impl_casestring__Str::make_own(int length) {
    kc_char_t *newname=kc_strncpy(new kc_char_t[length+1],name,length);
    newname[length]=0;
    name=newname;
}
abstract_phylum impl_tSource_list::subphylum(int no) const
{
    switch(no){
	case 0: return tSource_1;
	case 1: return tSource_list_1;
    }
    return 0;
}
abstract_phylum impl_tTarget_list::subphylum(int no) const
{
    switch(no){
	case 0: return tTarget_1;
	case 1: return tTarget_list_1;
    }
    return 0;
}
abstract_phylum impl_standardElements_StandardElements::subphylum(int no) const
{
    switch(no){
	case 0: return tTarget_list_1;
	case 1: return tSource_list_1;
    }
    return 0;
}
abstract_phylum impl_tScope_Scope::subphylum(int no) const
{
    switch(no){
	case 0: return standardElements_1;
	case 1: return tVariable_list_1;
	case 2: return tFaultHandlers_1;
	case 3: return tCompensationHandler_1;
	case 4: return tEventHandlers_1;
	case 5: return tStop_1;
	case 6: return activity_1;
    }
    return 0;
}
abstract_phylum impl_tPick_Pick::subphylum(int no) const
{
    switch(no){
	case 0: return standardElements_1;
	case 1: return tOnMessage_list_1;
	case 2: return tOnAlarm_list_1;
    }
    return 0;
}
abstract_phylum impl_tSequence_Sequence::subphylum(int no) const
{
    switch(no){
	case 0: return standardElements_1;
	case 1: return activity_list_1;
    }
    return 0;
}
abstract_phylum impl_tWhile_While::subphylum(int no) const
{
    switch(no){
	case 0: return standardElements_1;
	case 1: return activity_1;
    }
    return 0;
}
abstract_phylum impl_tOtherwise_Otherwise::subphylum(int no) const
{
    switch(no){
	case 0: return activity_1;
    }
    return 0;
}
abstract_phylum impl_tCase_Case::subphylum(int no) const
{
    switch(no){
	case 0: return activity_1;
    }
    return 0;
}
abstract_phylum impl_tCase_list::subphylum(int no) const
{
    switch(no){
	case 0: return tCase_1;
	case 1: return tCase_list_1;
    }
    return 0;
}
abstract_phylum impl_tSwitch_Switch::subphylum(int no) const
{
    switch(no){
	case 0: return standardElements_1;
	case 1: return tCase_list_1;
	case 2: return tOtherwise_1;
    }
    return 0;
}
abstract_phylum impl_tLink_list::subphylum(int no) const
{
    switch(no){
	case 0: return tLink_1;
	case 1: return tLink_list_1;
    }
    return 0;
}
abstract_phylum impl_activity_list::subphylum(int no) const
{
    switch(no){
	case 0: return activity_1;
	case 1: return activity_list_1;
    }
    return 0;
}
abstract_phylum impl_tFlow_Flow::subphylum(int no) const
{
    switch(no){
	case 0: return standardElements_1;
	case 1: return tLink_list_1;
	case 2: return activity_list_1;
    }
    return 0;
}
abstract_phylum impl_tTerminate_Terminate::subphylum(int no) const
{
    switch(no){
	case 0: return standardElements_1;
    }
    return 0;
}
abstract_phylum impl_tCompensate_Compensate::subphylum(int no) const
{
    switch(no){
	case 0: return standardElements_1;
    }
    return 0;
}
abstract_phylum impl_tThrow_Throw::subphylum(int no) const
{
    switch(no){
	case 0: return standardElements_1;
    }
    return 0;
}
abstract_phylum impl_tWait_WaitUntil::subphylum(int no) const
{
    switch(no){
	case 0: return standardElements_1;
    }
    return 0;
}
abstract_phylum impl_tWait_WaitFor::subphylum(int no) const
{
    switch(no){
	case 0: return standardElements_1;
    }
    return 0;
}
abstract_phylum impl_tCopy_Copy::subphylum(int no) const
{
    switch(no){
	case 0: return tFrom_1;
	case 1: return tTo_1;
    }
    return 0;
}
abstract_phylum impl_tCopy_list::subphylum(int no) const
{
    switch(no){
	case 0: return tCopy_1;
	case 1: return tCopy_list_1;
    }
    return 0;
}
abstract_phylum impl_tAssign_Assign::subphylum(int no) const
{
    switch(no){
	case 0: return standardElements_1;
	case 1: return tCopy_list_1;
    }
    return 0;
}
abstract_phylum impl_tReply_Reply::subphylum(int no) const
{
    switch(no){
	case 0: return standardElements_1;
	case 1: return tCorrelation_list_1;
    }
    return 0;
}
abstract_phylum impl_tReceive_Receive::subphylum(int no) const
{
    switch(no){
	case 0: return standardElements_1;
	case 1: return tCorrelation_list_1;
    }
    return 0;
}
abstract_phylum impl_tInvoke_Invoke::subphylum(int no) const
{
    switch(no){
	case 0: return standardElements_1;
	case 1: return tCorrelation_list_1;
    }
    return 0;
}
abstract_phylum impl_tEmpty_Empty::subphylum(int no) const
{
    switch(no){
	case 0: return standardElements_1;
    }
    return 0;
}
abstract_phylum impl_tCorrelation_list::subphylum(int no) const
{
    switch(no){
	case 0: return tCorrelation_1;
	case 1: return tCorrelation_list_1;
    }
    return 0;
}
abstract_phylum impl_tCorrelationSet_list::subphylum(int no) const
{
    switch(no){
	case 0: return tCorrelationSet_1;
	case 1: return tCorrelationSet_list_1;
    }
    return 0;
}
abstract_phylum impl_tVariable_list::subphylum(int no) const
{
    switch(no){
	case 0: return tVariable_1;
	case 1: return tVariable_list_1;
    }
    return 0;
}
abstract_phylum impl_tCompensationHandler_userDefinedCompensationHandler::subphylum(int no) const
{
    switch(no){
	case 0: return activity_1;
    }
    return 0;
}
abstract_phylum impl_tOnAlarm_OnAlarm::subphylum(int no) const
{
    switch(no){
	case 0: return activity_1;
    }
    return 0;
}
abstract_phylum impl_tOnMessage_OnMessage::subphylum(int no) const
{
    switch(no){
	case 0: return activity_1;
    }
    return 0;
}
abstract_phylum impl_tOnAlarm_list::subphylum(int no) const
{
    switch(no){
	case 0: return tOnAlarm_1;
	case 1: return tOnAlarm_list_1;
    }
    return 0;
}
abstract_phylum impl_tOnMessage_list::subphylum(int no) const
{
    switch(no){
	case 0: return tOnMessage_1;
	case 1: return tOnMessage_list_1;
    }
    return 0;
}
abstract_phylum impl_tEventHandlers_userDefinedEventHandler::subphylum(int no) const
{
    switch(no){
	case 0: return tOnMessage_list_1;
	case 1: return tOnAlarm_list_1;
    }
    return 0;
}
abstract_phylum impl_tCatchAll_CatchAll::subphylum(int no) const
{
    switch(no){
	case 0: return activity_1;
    }
    return 0;
}
abstract_phylum impl_tCatch_Catch::subphylum(int no) const
{
    switch(no){
	case 0: return activity_1;
    }
    return 0;
}
abstract_phylum impl_tCatch_list::subphylum(int no) const
{
    switch(no){
	case 0: return tCatch_1;
	case 1: return tCatch_list_1;
    }
    return 0;
}
abstract_phylum impl_tFaultHandlers_userDefinedFaultHandler::subphylum(int no) const
{
    switch(no){
	case 0: return tCatch_list_1;
	case 1: return tCatchAll_1;
    }
    return 0;
}
abstract_phylum impl_tPartner_Partner::subphylum(int no) const
{
    switch(no){
	case 0: return tPartnerLink_list_1;
    }
    return 0;
}
abstract_phylum impl_tPartner_list::subphylum(int no) const
{
    switch(no){
	case 0: return tPartner_1;
	case 1: return tPartner_list_1;
    }
    return 0;
}
abstract_phylum impl_tPartnerLink_list::subphylum(int no) const
{
    switch(no){
	case 0: return tPartnerLink_1;
	case 1: return tPartnerLink_list_1;
    }
    return 0;
}
abstract_phylum impl_activity_activityCompensate::subphylum(int no) const
{
    switch(no){
	case 0: return tCompensate_1;
    }
    return 0;
}
abstract_phylum impl_activity_activityScope::subphylum(int no) const
{
    switch(no){
	case 0: return tScope_1;
    }
    return 0;
}
abstract_phylum impl_activity_activityPick::subphylum(int no) const
{
    switch(no){
	case 0: return tPick_1;
    }
    return 0;
}
abstract_phylum impl_activity_activitySequence::subphylum(int no) const
{
    switch(no){
	case 0: return tSequence_1;
    }
    return 0;
}
abstract_phylum impl_activity_activityWhile::subphylum(int no) const
{
    switch(no){
	case 0: return tWhile_1;
    }
    return 0;
}
abstract_phylum impl_activity_activitySwitch::subphylum(int no) const
{
    switch(no){
	case 0: return tSwitch_1;
    }
    return 0;
}
abstract_phylum impl_activity_activityFlow::subphylum(int no) const
{
    switch(no){
	case 0: return tFlow_1;
    }
    return 0;
}
abstract_phylum impl_activity_activityTerminate::subphylum(int no) const
{
    switch(no){
	case 0: return tTerminate_1;
    }
    return 0;
}
abstract_phylum impl_activity_activityThrow::subphylum(int no) const
{
    switch(no){
	case 0: return tThrow_1;
    }
    return 0;
}
abstract_phylum impl_activity_activityWait::subphylum(int no) const
{
    switch(no){
	case 0: return tWait_1;
    }
    return 0;
}
abstract_phylum impl_activity_activityAssign::subphylum(int no) const
{
    switch(no){
	case 0: return tAssign_1;
    }
    return 0;
}
abstract_phylum impl_activity_activityReply::subphylum(int no) const
{
    switch(no){
	case 0: return tReply_1;
    }
    return 0;
}
abstract_phylum impl_activity_activityReceive::subphylum(int no) const
{
    switch(no){
	case 0: return tReceive_1;
    }
    return 0;
}
abstract_phylum impl_activity_activityInvoke::subphylum(int no) const
{
    switch(no){
	case 0: return tInvoke_1;
    }
    return 0;
}
abstract_phylum impl_activity_activityEmpty::subphylum(int no) const
{
    switch(no){
	case 0: return tEmpty_1;
    }
    return 0;
}
abstract_phylum impl_tProcess_Process::subphylum(int no) const
{
    switch(no){
	case 0: return tPartnerLink_list_1;
	case 1: return tPartner_list_1;
	case 2: return tVariable_list_1;
	case 3: return tCorrelationSet_list_1;
	case 4: return tFaultHandlers_1;
	case 5: return tCompensationHandler_1;
	case 6: return tEventHandlers_1;
	case 7: return tStop_1;
	case 8: return activity_1;
    }
    return 0;
}
void impl_tSource_list::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tSource_1 = dynamic_cast<tSource>(val);break;
	case 1: newval = tSource_list_1 = dynamic_cast<tSource_list>(val);break;
    }
    assertNonNull(newval);
}
void impl_tTarget_list::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tTarget_1 = dynamic_cast<tTarget>(val);break;
	case 1: newval = tTarget_list_1 = dynamic_cast<tTarget_list>(val);break;
    }
    assertNonNull(newval);
}
void impl_standardElements_StandardElements::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tTarget_list_1 = dynamic_cast<tTarget_list>(val);break;
	case 1: newval = tSource_list_1 = dynamic_cast<tSource_list>(val);break;
    }
    assertNonNull(newval);
}
void impl_tScope_Scope::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = standardElements_1 = dynamic_cast<standardElements>(val);break;
	case 1: newval = tVariable_list_1 = dynamic_cast<tVariable_list>(val);break;
	case 2: newval = tFaultHandlers_1 = dynamic_cast<tFaultHandlers>(val);break;
	case 3: newval = tCompensationHandler_1 = dynamic_cast<tCompensationHandler>(val);break;
	case 4: newval = tEventHandlers_1 = dynamic_cast<tEventHandlers>(val);break;
	case 5: newval = tStop_1 = dynamic_cast<tStop>(val);break;
	case 6: newval = activity_1 = dynamic_cast<activity>(val);break;
    }
    assertNonNull(newval);
}
void impl_tPick_Pick::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = standardElements_1 = dynamic_cast<standardElements>(val);break;
	case 1: newval = tOnMessage_list_1 = dynamic_cast<tOnMessage_list>(val);break;
	case 2: newval = tOnAlarm_list_1 = dynamic_cast<tOnAlarm_list>(val);break;
    }
    assertNonNull(newval);
}
void impl_tSequence_Sequence::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = standardElements_1 = dynamic_cast<standardElements>(val);break;
	case 1: newval = activity_list_1 = dynamic_cast<activity_list>(val);break;
    }
    assertNonNull(newval);
}
void impl_tWhile_While::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = standardElements_1 = dynamic_cast<standardElements>(val);break;
	case 1: newval = activity_1 = dynamic_cast<activity>(val);break;
    }
    assertNonNull(newval);
}
void impl_tOtherwise_Otherwise::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = activity_1 = dynamic_cast<activity>(val);break;
    }
    assertNonNull(newval);
}
void impl_tCase_Case::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = activity_1 = dynamic_cast<activity>(val);break;
    }
    assertNonNull(newval);
}
void impl_tCase_list::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tCase_1 = dynamic_cast<tCase>(val);break;
	case 1: newval = tCase_list_1 = dynamic_cast<tCase_list>(val);break;
    }
    assertNonNull(newval);
}
void impl_tSwitch_Switch::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = standardElements_1 = dynamic_cast<standardElements>(val);break;
	case 1: newval = tCase_list_1 = dynamic_cast<tCase_list>(val);break;
	case 2: newval = tOtherwise_1 = dynamic_cast<tOtherwise>(val);break;
    }
    assertNonNull(newval);
}
void impl_tLink_list::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tLink_1 = dynamic_cast<tLink>(val);break;
	case 1: newval = tLink_list_1 = dynamic_cast<tLink_list>(val);break;
    }
    assertNonNull(newval);
}
void impl_activity_list::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = activity_1 = dynamic_cast<activity>(val);break;
	case 1: newval = activity_list_1 = dynamic_cast<activity_list>(val);break;
    }
    assertNonNull(newval);
}
void impl_tFlow_Flow::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = standardElements_1 = dynamic_cast<standardElements>(val);break;
	case 1: newval = tLink_list_1 = dynamic_cast<tLink_list>(val);break;
	case 2: newval = activity_list_1 = dynamic_cast<activity_list>(val);break;
    }
    assertNonNull(newval);
}
void impl_tTerminate_Terminate::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = standardElements_1 = dynamic_cast<standardElements>(val);break;
    }
    assertNonNull(newval);
}
void impl_tCompensate_Compensate::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = standardElements_1 = dynamic_cast<standardElements>(val);break;
    }
    assertNonNull(newval);
}
void impl_tThrow_Throw::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = standardElements_1 = dynamic_cast<standardElements>(val);break;
    }
    assertNonNull(newval);
}
void impl_tWait_WaitUntil::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = standardElements_1 = dynamic_cast<standardElements>(val);break;
    }
    assertNonNull(newval);
}
void impl_tWait_WaitFor::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = standardElements_1 = dynamic_cast<standardElements>(val);break;
    }
    assertNonNull(newval);
}
void impl_tCopy_Copy::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tFrom_1 = dynamic_cast<tFrom>(val);break;
	case 1: newval = tTo_1 = dynamic_cast<tTo>(val);break;
    }
    assertNonNull(newval);
}
void impl_tCopy_list::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tCopy_1 = dynamic_cast<tCopy>(val);break;
	case 1: newval = tCopy_list_1 = dynamic_cast<tCopy_list>(val);break;
    }
    assertNonNull(newval);
}
void impl_tAssign_Assign::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = standardElements_1 = dynamic_cast<standardElements>(val);break;
	case 1: newval = tCopy_list_1 = dynamic_cast<tCopy_list>(val);break;
    }
    assertNonNull(newval);
}
void impl_tReply_Reply::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = standardElements_1 = dynamic_cast<standardElements>(val);break;
	case 1: newval = tCorrelation_list_1 = dynamic_cast<tCorrelation_list>(val);break;
    }
    assertNonNull(newval);
}
void impl_tReceive_Receive::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = standardElements_1 = dynamic_cast<standardElements>(val);break;
	case 1: newval = tCorrelation_list_1 = dynamic_cast<tCorrelation_list>(val);break;
    }
    assertNonNull(newval);
}
void impl_tInvoke_Invoke::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = standardElements_1 = dynamic_cast<standardElements>(val);break;
	case 1: newval = tCorrelation_list_1 = dynamic_cast<tCorrelation_list>(val);break;
    }
    assertNonNull(newval);
}
void impl_tEmpty_Empty::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = standardElements_1 = dynamic_cast<standardElements>(val);break;
    }
    assertNonNull(newval);
}
void impl_tCorrelation_list::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tCorrelation_1 = dynamic_cast<tCorrelation>(val);break;
	case 1: newval = tCorrelation_list_1 = dynamic_cast<tCorrelation_list>(val);break;
    }
    assertNonNull(newval);
}
void impl_tCorrelationSet_list::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tCorrelationSet_1 = dynamic_cast<tCorrelationSet>(val);break;
	case 1: newval = tCorrelationSet_list_1 = dynamic_cast<tCorrelationSet_list>(val);break;
    }
    assertNonNull(newval);
}
void impl_tVariable_list::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tVariable_1 = dynamic_cast<tVariable>(val);break;
	case 1: newval = tVariable_list_1 = dynamic_cast<tVariable_list>(val);break;
    }
    assertNonNull(newval);
}
void impl_tCompensationHandler_userDefinedCompensationHandler::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = activity_1 = dynamic_cast<activity>(val);break;
    }
    assertNonNull(newval);
}
void impl_tOnAlarm_OnAlarm::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = activity_1 = dynamic_cast<activity>(val);break;
    }
    assertNonNull(newval);
}
void impl_tOnMessage_OnMessage::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = activity_1 = dynamic_cast<activity>(val);break;
    }
    assertNonNull(newval);
}
void impl_tOnAlarm_list::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tOnAlarm_1 = dynamic_cast<tOnAlarm>(val);break;
	case 1: newval = tOnAlarm_list_1 = dynamic_cast<tOnAlarm_list>(val);break;
    }
    assertNonNull(newval);
}
void impl_tOnMessage_list::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tOnMessage_1 = dynamic_cast<tOnMessage>(val);break;
	case 1: newval = tOnMessage_list_1 = dynamic_cast<tOnMessage_list>(val);break;
    }
    assertNonNull(newval);
}
void impl_tEventHandlers_userDefinedEventHandler::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tOnMessage_list_1 = dynamic_cast<tOnMessage_list>(val);break;
	case 1: newval = tOnAlarm_list_1 = dynamic_cast<tOnAlarm_list>(val);break;
    }
    assertNonNull(newval);
}
void impl_tCatchAll_CatchAll::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = activity_1 = dynamic_cast<activity>(val);break;
    }
    assertNonNull(newval);
}
void impl_tCatch_Catch::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = activity_1 = dynamic_cast<activity>(val);break;
    }
    assertNonNull(newval);
}
void impl_tCatch_list::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tCatch_1 = dynamic_cast<tCatch>(val);break;
	case 1: newval = tCatch_list_1 = dynamic_cast<tCatch_list>(val);break;
    }
    assertNonNull(newval);
}
void impl_tFaultHandlers_userDefinedFaultHandler::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tCatch_list_1 = dynamic_cast<tCatch_list>(val);break;
	case 1: newval = tCatchAll_1 = dynamic_cast<tCatchAll>(val);break;
    }
    assertNonNull(newval);
}
void impl_tPartner_Partner::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tPartnerLink_list_1 = dynamic_cast<tPartnerLink_list>(val);break;
    }
    assertNonNull(newval);
}
void impl_tPartner_list::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tPartner_1 = dynamic_cast<tPartner>(val);break;
	case 1: newval = tPartner_list_1 = dynamic_cast<tPartner_list>(val);break;
    }
    assertNonNull(newval);
}
void impl_tPartnerLink_list::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tPartnerLink_1 = dynamic_cast<tPartnerLink>(val);break;
	case 1: newval = tPartnerLink_list_1 = dynamic_cast<tPartnerLink_list>(val);break;
    }
    assertNonNull(newval);
}
void impl_activity_activityCompensate::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tCompensate_1 = dynamic_cast<tCompensate>(val);break;
    }
    assertNonNull(newval);
}
void impl_activity_activityScope::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tScope_1 = dynamic_cast<tScope>(val);break;
    }
    assertNonNull(newval);
}
void impl_activity_activityPick::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tPick_1 = dynamic_cast<tPick>(val);break;
    }
    assertNonNull(newval);
}
void impl_activity_activitySequence::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tSequence_1 = dynamic_cast<tSequence>(val);break;
    }
    assertNonNull(newval);
}
void impl_activity_activityWhile::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tWhile_1 = dynamic_cast<tWhile>(val);break;
    }
    assertNonNull(newval);
}
void impl_activity_activitySwitch::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tSwitch_1 = dynamic_cast<tSwitch>(val);break;
    }
    assertNonNull(newval);
}
void impl_activity_activityFlow::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tFlow_1 = dynamic_cast<tFlow>(val);break;
    }
    assertNonNull(newval);
}
void impl_activity_activityTerminate::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tTerminate_1 = dynamic_cast<tTerminate>(val);break;
    }
    assertNonNull(newval);
}
void impl_activity_activityThrow::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tThrow_1 = dynamic_cast<tThrow>(val);break;
    }
    assertNonNull(newval);
}
void impl_activity_activityWait::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tWait_1 = dynamic_cast<tWait>(val);break;
    }
    assertNonNull(newval);
}
void impl_activity_activityAssign::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tAssign_1 = dynamic_cast<tAssign>(val);break;
    }
    assertNonNull(newval);
}
void impl_activity_activityReply::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tReply_1 = dynamic_cast<tReply>(val);break;
    }
    assertNonNull(newval);
}
void impl_activity_activityReceive::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tReceive_1 = dynamic_cast<tReceive>(val);break;
    }
    assertNonNull(newval);
}
void impl_activity_activityInvoke::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tInvoke_1 = dynamic_cast<tInvoke>(val);break;
    }
    assertNonNull(newval);
}
void impl_activity_activityEmpty::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tEmpty_1 = dynamic_cast<tEmpty>(val);break;
    }
    assertNonNull(newval);
}
void impl_tProcess_Process::set_subphylum(int no, abstract_phylum val)
{
    abstract_phylum newval=0;
    switch(no) {
	case 0: newval = tPartnerLink_list_1 = dynamic_cast<tPartnerLink_list>(val);break;
	case 1: newval = tPartner_list_1 = dynamic_cast<tPartner_list>(val);break;
	case 2: newval = tVariable_list_1 = dynamic_cast<tVariable_list>(val);break;
	case 3: newval = tCorrelationSet_list_1 = dynamic_cast<tCorrelationSet_list>(val);break;
	case 4: newval = tFaultHandlers_1 = dynamic_cast<tFaultHandlers>(val);break;
	case 5: newval = tCompensationHandler_1 = dynamic_cast<tCompensationHandler>(val);break;
	case 6: newval = tEventHandlers_1 = dynamic_cast<tEventHandlers>(val);break;
	case 7: newval = tStop_1 = dynamic_cast<tStop>(val);break;
	case 8: newval = activity_1 = dynamic_cast<activity>(val);break;
    }
    assertNonNull(newval);
}

void
copy_attributes(enum_phyla copyPhy, c_abstract_phylum kc_p1, abstract_phylum kc_p2)
{
    switch(copyPhy) {
    case phylum_tProcess:
	dynamic_cast<tProcess>(kc_p2)->id = dynamic_cast<c_tProcess>(kc_p1)->id;
	break;
    case phylum_activity: {
	c_activity p1 = dynamic_cast<c_activity>(kc_p1);
	activity p2 = dynamic_cast<activity>(kc_p2);
	p2->id = p1->id;
	p2->negativeControlFlow = p1->negativeControlFlow;
	p2->dpe = p1->dpe;
	break;
    }
    case phylum_tPartnerLink:
	dynamic_cast<tPartnerLink>(kc_p2)->id = dynamic_cast<c_tPartnerLink>(kc_p1)->id;
	break;
    case phylum_tPartner:
	dynamic_cast<tPartner>(kc_p2)->id = dynamic_cast<c_tPartner>(kc_p1)->id;
	break;
    case phylum_tFaultHandlers: {
	c_tFaultHandlers p1 = dynamic_cast<c_tFaultHandlers>(kc_p1);
	tFaultHandlers p2 = dynamic_cast<tFaultHandlers>(kc_p2);
	p2->inProcess = p1->inProcess;
	p2->parentScopeId = p1->parentScopeId;
	p2->hasCatchAll = p1->hasCatchAll;
	p2->id = p1->id;
	break;
    }
    case phylum_tCatch: {
	c_tCatch p1 = dynamic_cast<c_tCatch>(kc_p1);
	tCatch p2 = dynamic_cast<tCatch>(kc_p2);
	p2->faultName = p1->faultName;
	p2->id = p1->id;
	break;
    }
    case phylum_tCatchAll:
	dynamic_cast<tCatchAll>(kc_p2)->id = dynamic_cast<c_tCatchAll>(kc_p1)->id;
	break;
    case phylum_tEventHandlers: {
	c_tEventHandlers p1 = dynamic_cast<c_tEventHandlers>(kc_p1);
	tEventHandlers p2 = dynamic_cast<tEventHandlers>(kc_p2);
	p2->parentScopeId = p1->parentScopeId;
	p2->id = p1->id;
	break;
    }
    case phylum_tOnMessage_list:
	dynamic_cast<tOnMessage_list>(kc_p2)->dpe = dynamic_cast<c_tOnMessage_list>(kc_p1)->dpe;
	break;
    case phylum_tOnAlarm_list:
	dynamic_cast<tOnAlarm_list>(kc_p2)->dpe = dynamic_cast<c_tOnAlarm_list>(kc_p1)->dpe;
	break;
    case phylum_tOnMessage: {
	c_tOnMessage p1 = dynamic_cast<c_tOnMessage>(kc_p1);
	tOnMessage p2 = dynamic_cast<tOnMessage>(kc_p2);
	p2->dpe = p1->dpe;
	p2->id = p1->id;
	break;
    }
    case phylum_tOnAlarm: {
	c_tOnAlarm p1 = dynamic_cast<c_tOnAlarm>(kc_p1);
	tOnAlarm p2 = dynamic_cast<tOnAlarm>(kc_p2);
	p2->For = p1->For;
	p2->until = p1->until;
	p2->dpe = p1->dpe;
	p2->id = p1->id;
	break;
    }
    case phylum_tCompensationHandler: {
	c_tCompensationHandler p1 = dynamic_cast<c_tCompensationHandler>(kc_p1);
	tCompensationHandler p2 = dynamic_cast<tCompensationHandler>(kc_p2);
	p2->parentScopeId = p1->parentScopeId;
	p2->compensateWithoutScope = p1->compensateWithoutScope;
	p2->compensateWithScope = p1->compensateWithScope;
	p2->id = p1->id;
	break;
    }
    case phylum_tVariable:
	dynamic_cast<tVariable>(kc_p2)->id = dynamic_cast<c_tVariable>(kc_p1)->id;
	break;
    case phylum_tCorrelationSet:
	dynamic_cast<tCorrelationSet>(kc_p2)->id = dynamic_cast<c_tCorrelationSet>(kc_p1)->id;
	break;
    case phylum_tCorrelation:
	dynamic_cast<tCorrelation>(kc_p2)->id = dynamic_cast<c_tCorrelation>(kc_p1)->id;
	break;
    case phylum_tEmpty: {
	c_tEmpty p1 = dynamic_cast<c_tEmpty>(kc_p1);
	tEmpty p2 = dynamic_cast<tEmpty>(kc_p2);
	p2->negativeControlFlow = p1->negativeControlFlow;
	p2->id = p1->id;
	break;
    }
    case phylum_tInvoke: {
	c_tInvoke p1 = dynamic_cast<c_tInvoke>(kc_p1);
	tInvoke p2 = dynamic_cast<tInvoke>(kc_p2);
	p2->dpe = p1->dpe;
	p2->negativeControlFlow = p1->negativeControlFlow;
	p2->id = p1->id;
	break;
    }
    case phylum_tReceive: {
	c_tReceive p1 = dynamic_cast<c_tReceive>(kc_p1);
	tReceive p2 = dynamic_cast<tReceive>(kc_p2);
	p2->negativeControlFlow = p1->negativeControlFlow;
	p2->id = p1->id;
	break;
    }
    case phylum_tReply: {
	c_tReply p1 = dynamic_cast<c_tReply>(kc_p1);
	tReply p2 = dynamic_cast<tReply>(kc_p2);
	p2->negativeControlFlow = p1->negativeControlFlow;
	p2->id = p1->id;
	break;
    }
    case phylum_tAssign: {
	c_tAssign p1 = dynamic_cast<c_tAssign>(kc_p1);
	tAssign p2 = dynamic_cast<tAssign>(kc_p2);
	p2->negativeControlFlow = p1->negativeControlFlow;
	p2->id = p1->id;
	break;
    }
    case phylum_tFrom:
	dynamic_cast<tFrom>(kc_p2)->id = dynamic_cast<c_tFrom>(kc_p1)->id;
	break;
    case phylum_tTo:
	dynamic_cast<tTo>(kc_p2)->id = dynamic_cast<c_tTo>(kc_p1)->id;
	break;
    case phylum_tWait: {
	c_tWait p1 = dynamic_cast<c_tWait>(kc_p1);
	tWait p2 = dynamic_cast<tWait>(kc_p2);
	p2->negativeControlFlow = p1->negativeControlFlow;
	p2->id = p1->id;
	break;
    }
    case phylum_tThrow: {
	c_tThrow p1 = dynamic_cast<c_tThrow>(kc_p1);
	tThrow p2 = dynamic_cast<tThrow>(kc_p2);
	p2->negativeControlFlow = p1->negativeControlFlow;
	p2->id = p1->id;
	break;
    }
    case phylum_tCompensate: {
	c_tCompensate p1 = dynamic_cast<c_tCompensate>(kc_p1);
	tCompensate p2 = dynamic_cast<tCompensate>(kc_p2);
	p2->inFaultHandler = p1->inFaultHandler;
	p2->negativeControlFlow = p1->negativeControlFlow;
	p2->id = p1->id;
	break;
    }
    case phylum_tTerminate: {
	c_tTerminate p1 = dynamic_cast<c_tTerminate>(kc_p1);
	tTerminate p2 = dynamic_cast<tTerminate>(kc_p2);
	p2->negativeControlFlow = p1->negativeControlFlow;
	p2->id = p1->id;
	break;
    }
    case phylum_tFlow: {
	c_tFlow p1 = dynamic_cast<c_tFlow>(kc_p1);
	tFlow p2 = dynamic_cast<tFlow>(kc_p2);
	p2->dpe = p1->dpe;
	p2->negativeControlFlow = p1->negativeControlFlow;
	p2->id = p1->id;
	break;
    }
    case phylum_activity_list:
	dynamic_cast<activity_list>(kc_p2)->dpe = dynamic_cast<c_activity_list>(kc_p1)->dpe;
	break;
    case phylum_tLink:
	dynamic_cast<tLink>(kc_p2)->id = dynamic_cast<c_tLink>(kc_p1)->id;
	break;
    case phylum_tSwitch: {
	c_tSwitch p1 = dynamic_cast<c_tSwitch>(kc_p1);
	tSwitch p2 = dynamic_cast<tSwitch>(kc_p2);
	p2->dpe = p1->dpe;
	p2->negativeControlFlow = p1->negativeControlFlow;
	p2->id = p1->id;
	break;
    }
    case phylum_tCase_list:
	dynamic_cast<tCase_list>(kc_p2)->dpe = dynamic_cast<c_tCase_list>(kc_p1)->dpe;
	break;
    case phylum_tCase: {
	c_tCase p1 = dynamic_cast<c_tCase>(kc_p1);
	tCase p2 = dynamic_cast<tCase>(kc_p2);
	p2->condition = p1->condition;
	p2->dpe = p1->dpe;
	p2->id = p1->id;
	break;
    }
    case phylum_tOtherwise:
	dynamic_cast<tOtherwise>(kc_p2)->dpe = dynamic_cast<c_tOtherwise>(kc_p1)->dpe;
	break;
    case phylum_tWhile: {
	c_tWhile p1 = dynamic_cast<c_tWhile>(kc_p1);
	tWhile p2 = dynamic_cast<tWhile>(kc_p2);
	p2->condition = p1->condition;
	p2->negativeControlFlow = p1->negativeControlFlow;
	p2->id = p1->id;
	break;
    }
    case phylum_tSequence: {
	c_tSequence p1 = dynamic_cast<c_tSequence>(kc_p1);
	tSequence p2 = dynamic_cast<tSequence>(kc_p2);
	p2->negativeControlFlow = p1->negativeControlFlow;
	p2->id = p1->id;
	p2->dpe = p1->dpe;
	break;
    }
    case phylum_tPick: {
	c_tPick p1 = dynamic_cast<c_tPick>(kc_p1);
	tPick p2 = dynamic_cast<tPick>(kc_p2);
	p2->dpe = p1->dpe;
	p2->negativeControlFlow = p1->negativeControlFlow;
	p2->id = p1->id;
	break;
    }
    case phylum_tScope: {
	c_tScope p1 = dynamic_cast<c_tScope>(kc_p1);
	tScope p2 = dynamic_cast<tScope>(kc_p2);
	p2->negativeControlFlow = p1->negativeControlFlow;
	p2->id = p1->id;
	p2->parentScopeId = p1->parentScopeId;
	p2->dpe = p1->dpe;
	break;
    }
    case phylum_standardElements: {
	c_standardElements p1 = dynamic_cast<c_standardElements>(kc_p1);
	standardElements p2 = dynamic_cast<standardElements>(kc_p2);
	p2->parentId = p1->parentId;
	p2->suppressJoinFailure = p1->suppressJoinFailure;
	p2->dpe = p1->dpe;
	p2->negativeControlFlow = p1->negativeControlFlow;
	p2->hasTarget = p1->hasTarget;
	break;
    }
    case phylum_tTarget_list:
	dynamic_cast<tTarget_list>(kc_p2)->hasTarget = dynamic_cast<c_tTarget_list>(kc_p1)->hasTarget;
	break;
    case phylum_tTarget: {
	c_tTarget p1 = dynamic_cast<c_tTarget>(kc_p1);
	tTarget p2 = dynamic_cast<tTarget>(kc_p2);
	p2->negativeControlFlow = p1->negativeControlFlow;
	p2->id = p1->id;
	break;
    }
    case phylum_tSource_list:
	dynamic_cast<tSource_list>(kc_p2)->dpe = dynamic_cast<c_tSource_list>(kc_p1)->dpe;
	break;
    case phylum_tSource: {
	c_tSource p1 = dynamic_cast<c_tSource>(kc_p1);
	tSource p2 = dynamic_cast<tSource>(kc_p2);
	p2->dpe = p1->dpe;
	p2->negativeControlFlow = p1->negativeControlFlow;
	p2->id = p1->id;
	break;
    }
    case one_before_first_phylum: // just to avoid a warning about missing case if empty
    default:
	break; // it's alright, no attributes to copy
    }
    enum_operators copyOp=kc_p1->prod_sel();
    for (int i=operator_info[copyOp].no_attrs-1; i>=0; --i)
	attributeOf(kc_p2, i)=attributeOf(const_cast<abstract_phylum>(kc_p1), i);
}

KC_PHYLUM_INFO phylum_info[] = {
    { "", one_before_first_operator, one_before_first_operator, (kc_storageclass_t)0 }, /* dummy element */
    { "nocasestring", sel_NoCaseStr, sel_NoCaseStr, uniq },
    { "casestring", sel__Str, sel__Str, uniq },
    { "real", sel__Real, sel__Real, uniq },
    { "integer", sel__Int, sel__Int, uniq },
    { "voidptr", sel__VoidPtr, sel__VoidPtr, uniq },
    { "tProcess", sel_Process, sel_Process, kc_not_uniq },
    { "tStop", sel_StopInProcess, sel_StopInScope, kc_not_uniq },
    { "activity", sel_activityEmpty, sel_activityCompensate, kc_not_uniq },
    { "tPartnerLink_list", sel_NiltPartnerLink_list, sel_ConstPartnerLink_list, kc_not_uniq },
    { "tPartnerLink", sel_PartnerLink, sel_PartnerLink, kc_not_uniq },
    { "tPartner_list", sel_NiltPartner_list, sel_ConstPartner_list, kc_not_uniq },
    { "tPartner", sel_Partner, sel_Partner, kc_not_uniq },
    { "tFaultHandlers", sel_userDefinedFaultHandler, sel_implicitFaultHandler, kc_not_uniq },
    { "tCatch_list", sel_NiltCatch_list, sel_ConstCatch_list, kc_not_uniq },
    { "tCatch", sel_Catch, sel_Catch, kc_not_uniq },
    { "tCatchAll", sel_CatchAll, sel_NoCatchAll, kc_not_uniq },
    { "tEventHandlers", sel_implicitEventHandler, sel_userDefinedEventHandler, kc_not_uniq },
    { "tOnMessage_list", sel_NiltOnMessage_list, sel_ConstOnMessage_list, kc_not_uniq },
    { "tOnAlarm_list", sel_NiltOnAlarm_list, sel_ConstOnAlarm_list, kc_not_uniq },
    { "tOnMessage", sel_OnMessage, sel_OnMessage, kc_not_uniq },
    { "tOnAlarm", sel_OnAlarm, sel_OnAlarm, kc_not_uniq },
    { "tCompensationHandler", sel_implicitCompensationHandler, sel_processCompensationHandler, kc_not_uniq },
    { "tVariable_list", sel_NiltVariable_list, sel_ConstVariable_list, kc_not_uniq },
    { "tVariable", sel_Variable, sel_Variable, kc_not_uniq },
    { "tCorrelationSet_list", sel_NiltCorrelationSet_list, sel_ConstCorrelationSet_list, kc_not_uniq },
    { "tCorrelationSet", sel_CorrelationSet, sel_CorrelationSet, kc_not_uniq },
    { "tCorrelation_list", sel_NiltCorrelation_list, sel_ConstCorrelation_list, kc_not_uniq },
    { "tCorrelation", sel_Correlation, sel_Correlation, kc_not_uniq },
    { "tEmpty", sel_Empty, sel_Empty, kc_not_uniq },
    { "tInvoke", sel_Invoke, sel_Invoke, kc_not_uniq },
    { "tReceive", sel_Receive, sel_Receive, kc_not_uniq },
    { "tReply", sel_Reply, sel_Reply, kc_not_uniq },
    { "tAssign", sel_Assign, sel_Assign, kc_not_uniq },
    { "tCopy_list", sel_NiltCopy_list, sel_ConstCopy_list, kc_not_uniq },
    { "tCopy", sel_Copy, sel_Copy, kc_not_uniq },
    { "tFrom", sel_From, sel_From, kc_not_uniq },
    { "tTo", sel_To, sel_To, kc_not_uniq },
    { "tWait", sel_WaitFor, sel_WaitUntil, kc_not_uniq },
    { "tThrow", sel_Throw, sel_Throw, kc_not_uniq },
    { "tCompensate", sel_Compensate, sel_Compensate, kc_not_uniq },
    { "tTerminate", sel_Terminate, sel_Terminate, kc_not_uniq },
    { "tFlow", sel_Flow, sel_Flow, kc_not_uniq },
    { "activity_list", sel_Nilactivity_list, sel_Consactivity_list, kc_not_uniq },
    { "tLink_list", sel_NiltLink_list, sel_ConstLink_list, kc_not_uniq },
    { "tLink", sel_Link, sel_Link, kc_not_uniq },
    { "tSwitch", sel_Switch, sel_Switch, kc_not_uniq },
    { "tCase_list", sel_NiltCase_list, sel_ConstCase_list, kc_not_uniq },
    { "tCase", sel_Case, sel_Case, kc_not_uniq },
    { "tOtherwise", sel_Otherwise, sel_Otherwise, kc_not_uniq },
    { "tWhile", sel_While, sel_While, kc_not_uniq },
    { "tSequence", sel_Sequence, sel_Sequence, kc_not_uniq },
    { "tPick", sel_Pick, sel_Pick, kc_not_uniq },
    { "tScope", sel_Scope, sel_Scope, kc_not_uniq },
    { "standardElements", sel_StandardElements, sel_StandardElements, kc_not_uniq },
    { "tTarget_list", sel_NiltTarget_list, sel_ConstTarget_list, kc_not_uniq },
    { "tTarget", sel_Target, sel_Target, kc_not_uniq },
    { "tSource_list", sel_NiltSource_list, sel_ConstSource_list, kc_not_uniq },
    { "tSource", sel_Source, sel_Source, kc_not_uniq },
    { "", one_before_first_operator, one_before_first_operator, (kc_storageclass_t)0 } /* last element */
};

static enum_phyla kc_subphyla_Process[] = { phylum_tPartnerLink_list, phylum_tPartner_list, phylum_tVariable_list, phylum_tCorrelationSet_list, phylum_tFaultHandlers, phylum_tCompensationHandler, phylum_tEventHandlers, phylum_tStop, phylum_activity };
static enum_phyla kc_subphyla_activityEmpty[] = { phylum_tEmpty };
static enum_phyla kc_subphyla_activityInvoke[] = { phylum_tInvoke };
static enum_phyla kc_subphyla_activityReceive[] = { phylum_tReceive };
static enum_phyla kc_subphyla_activityReply[] = { phylum_tReply };
static enum_phyla kc_subphyla_activityAssign[] = { phylum_tAssign };
static enum_phyla kc_subphyla_activityWait[] = { phylum_tWait };
static enum_phyla kc_subphyla_activityThrow[] = { phylum_tThrow };
static enum_phyla kc_subphyla_activityTerminate[] = { phylum_tTerminate };
static enum_phyla kc_subphyla_activityFlow[] = { phylum_tFlow };
static enum_phyla kc_subphyla_activitySwitch[] = { phylum_tSwitch };
static enum_phyla kc_subphyla_activityWhile[] = { phylum_tWhile };
static enum_phyla kc_subphyla_activitySequence[] = { phylum_tSequence };
static enum_phyla kc_subphyla_activityPick[] = { phylum_tPick };
static enum_phyla kc_subphyla_activityScope[] = { phylum_tScope };
static enum_phyla kc_subphyla_activityCompensate[] = { phylum_tCompensate };
static enum_phyla kc_subphyla_ConstPartnerLink_list[] = { phylum_tPartnerLink, phylum_tPartnerLink_list };
static enum_phyla kc_subphyla_ConstPartner_list[] = { phylum_tPartner, phylum_tPartner_list };
static enum_phyla kc_subphyla_Partner[] = { phylum_tPartnerLink_list };
static enum_phyla kc_subphyla_userDefinedFaultHandler[] = { phylum_tCatch_list, phylum_tCatchAll };
static enum_phyla kc_subphyla_ConstCatch_list[] = { phylum_tCatch, phylum_tCatch_list };
static enum_phyla kc_subphyla_Catch[] = { phylum_activity };
static enum_phyla kc_subphyla_CatchAll[] = { phylum_activity };
static enum_phyla kc_subphyla_userDefinedEventHandler[] = { phylum_tOnMessage_list, phylum_tOnAlarm_list };
static enum_phyla kc_subphyla_ConstOnMessage_list[] = { phylum_tOnMessage, phylum_tOnMessage_list };
static enum_phyla kc_subphyla_ConstOnAlarm_list[] = { phylum_tOnAlarm, phylum_tOnAlarm_list };
static enum_phyla kc_subphyla_OnMessage[] = { phylum_activity };
static enum_phyla kc_subphyla_OnAlarm[] = { phylum_activity };
static enum_phyla kc_subphyla_userDefinedCompensationHandler[] = { phylum_activity };
static enum_phyla kc_subphyla_ConstVariable_list[] = { phylum_tVariable, phylum_tVariable_list };
static enum_phyla kc_subphyla_ConstCorrelationSet_list[] = { phylum_tCorrelationSet, phylum_tCorrelationSet_list };
static enum_phyla kc_subphyla_ConstCorrelation_list[] = { phylum_tCorrelation, phylum_tCorrelation_list };
static enum_phyla kc_subphyla_Empty[] = { phylum_standardElements };
static enum_phyla kc_subphyla_Invoke[] = { phylum_standardElements, phylum_tCorrelation_list };
static enum_phyla kc_subphyla_Receive[] = { phylum_standardElements, phylum_tCorrelation_list };
static enum_phyla kc_subphyla_Reply[] = { phylum_standardElements, phylum_tCorrelation_list };
static enum_phyla kc_subphyla_Assign[] = { phylum_standardElements, phylum_tCopy_list };
static enum_phyla kc_subphyla_ConstCopy_list[] = { phylum_tCopy, phylum_tCopy_list };
static enum_phyla kc_subphyla_Copy[] = { phylum_tFrom, phylum_tTo };
static enum_phyla kc_subphyla_WaitFor[] = { phylum_standardElements };
static enum_phyla kc_subphyla_WaitUntil[] = { phylum_standardElements };
static enum_phyla kc_subphyla_Throw[] = { phylum_standardElements };
static enum_phyla kc_subphyla_Compensate[] = { phylum_standardElements };
static enum_phyla kc_subphyla_Terminate[] = { phylum_standardElements };
static enum_phyla kc_subphyla_Flow[] = { phylum_standardElements, phylum_tLink_list, phylum_activity_list };
static enum_phyla kc_subphyla_Consactivity_list[] = { phylum_activity, phylum_activity_list };
static enum_phyla kc_subphyla_ConstLink_list[] = { phylum_tLink, phylum_tLink_list };
static enum_phyla kc_subphyla_Switch[] = { phylum_standardElements, phylum_tCase_list, phylum_tOtherwise };
static enum_phyla kc_subphyla_ConstCase_list[] = { phylum_tCase, phylum_tCase_list };
static enum_phyla kc_subphyla_Case[] = { phylum_activity };
static enum_phyla kc_subphyla_Otherwise[] = { phylum_activity };
static enum_phyla kc_subphyla_While[] = { phylum_standardElements, phylum_activity };
static enum_phyla kc_subphyla_Sequence[] = { phylum_standardElements, phylum_activity_list };
static enum_phyla kc_subphyla_Pick[] = { phylum_standardElements, phylum_tOnMessage_list, phylum_tOnAlarm_list };
static enum_phyla kc_subphyla_Scope[] = { phylum_standardElements, phylum_tVariable_list, phylum_tFaultHandlers, phylum_tCompensationHandler, phylum_tEventHandlers, phylum_tStop, phylum_activity };
static enum_phyla kc_subphyla_StandardElements[] = { phylum_tTarget_list, phylum_tSource_list };
static enum_phyla kc_subphyla_ConstTarget_list[] = { phylum_tTarget, phylum_tTarget_list };
static enum_phyla kc_subphyla_ConstSource_list[] = { phylum_tSource, phylum_tSource_list };


KC_OPERATOR_INFO operator_info[] = {
    { "", 0, 0, one_before_first_phylum, 0, 0, 0, 0 }, /* dummy element */
    { "NoCaseStr", 0, true, phylum_nocasestring, 0, 0, 0, sizeof(impl_nocasestring_NoCaseStr) },
    { "_Str", 0, true, phylum_casestring, 0, 0, 0, sizeof(impl_casestring__Str) },
    { "_Real", 0, true, phylum_real, 0, 0, 0, sizeof(impl_real__Real) },
    { "_Int", 0, true, phylum_integer, 0, 0, 0, sizeof(impl_integer__Int) },
    { "_VoidPtr", 0, true, phylum_voidptr, 0, 0, 0, sizeof(impl_voidptr__VoidPtr) },
    { "Process", 9, false, phylum_tProcess, kc_subphyla_Process, 0, 0, sizeof(impl_tProcess_Process) },
    { "StopInProcess", 0, false, phylum_tStop, 0, 0, 0, sizeof(impl_tStop_StopInProcess) },
    { "StopInScope", 0, false, phylum_tStop, 0, 0, 0, sizeof(impl_tStop_StopInScope) },
    { "activityEmpty", 1, false, phylum_activity, kc_subphyla_activityEmpty, 0, 0, sizeof(impl_activity_activityEmpty) },
    { "activityInvoke", 1, false, phylum_activity, kc_subphyla_activityInvoke, 0, 0, sizeof(impl_activity_activityInvoke) },
    { "activityReceive", 1, false, phylum_activity, kc_subphyla_activityReceive, 0, 0, sizeof(impl_activity_activityReceive) },
    { "activityReply", 1, false, phylum_activity, kc_subphyla_activityReply, 0, 0, sizeof(impl_activity_activityReply) },
    { "activityAssign", 1, false, phylum_activity, kc_subphyla_activityAssign, 0, 0, sizeof(impl_activity_activityAssign) },
    { "activityWait", 1, false, phylum_activity, kc_subphyla_activityWait, 0, 0, sizeof(impl_activity_activityWait) },
    { "activityThrow", 1, false, phylum_activity, kc_subphyla_activityThrow, 0, 0, sizeof(impl_activity_activityThrow) },
    { "activityTerminate", 1, false, phylum_activity, kc_subphyla_activityTerminate, 0, 0, sizeof(impl_activity_activityTerminate) },
    { "activityFlow", 1, false, phylum_activity, kc_subphyla_activityFlow, 0, 0, sizeof(impl_activity_activityFlow) },
    { "activitySwitch", 1, false, phylum_activity, kc_subphyla_activitySwitch, 0, 0, sizeof(impl_activity_activitySwitch) },
    { "activityWhile", 1, false, phylum_activity, kc_subphyla_activityWhile, 0, 0, sizeof(impl_activity_activityWhile) },
    { "activitySequence", 1, false, phylum_activity, kc_subphyla_activitySequence, 0, 0, sizeof(impl_activity_activitySequence) },
    { "activityPick", 1, false, phylum_activity, kc_subphyla_activityPick, 0, 0, sizeof(impl_activity_activityPick) },
    { "activityScope", 1, false, phylum_activity, kc_subphyla_activityScope, 0, 0, sizeof(impl_activity_activityScope) },
    { "activityCompensate", 1, false, phylum_activity, kc_subphyla_activityCompensate, 0, 0, sizeof(impl_activity_activityCompensate) },
    { "NiltPartnerLink_list", 0, false, phylum_tPartnerLink_list, 0, 0, 0, sizeof(impl_tPartnerLink_list) },
    { "ConstPartnerLink_list", 2, false, phylum_tPartnerLink_list, kc_subphyla_ConstPartnerLink_list, 0, 0, sizeof(impl_tPartnerLink_list) },
    { "PartnerLink", 0, false, phylum_tPartnerLink, 0, 0, 0, sizeof(impl_tPartnerLink_PartnerLink) },
    { "NiltPartner_list", 0, false, phylum_tPartner_list, 0, 0, 0, sizeof(impl_tPartner_list) },
    { "ConstPartner_list", 2, false, phylum_tPartner_list, kc_subphyla_ConstPartner_list, 0, 0, sizeof(impl_tPartner_list) },
    { "Partner", 1, false, phylum_tPartner, kc_subphyla_Partner, 0, 0, sizeof(impl_tPartner_Partner) },
    { "userDefinedFaultHandler", 2, false, phylum_tFaultHandlers, kc_subphyla_userDefinedFaultHandler, 0, 0, sizeof(impl_tFaultHandlers_userDefinedFaultHandler) },
    { "implicitFaultHandler", 0, false, phylum_tFaultHandlers, 0, 0, 0, sizeof(impl_tFaultHandlers_implicitFaultHandler) },
    { "NiltCatch_list", 0, false, phylum_tCatch_list, 0, 0, 0, sizeof(impl_tCatch_list) },
    { "ConstCatch_list", 2, false, phylum_tCatch_list, kc_subphyla_ConstCatch_list, 0, 0, sizeof(impl_tCatch_list) },
    { "Catch", 1, false, phylum_tCatch, kc_subphyla_Catch, 0, 0, sizeof(impl_tCatch_Catch) },
    { "CatchAll", 1, false, phylum_tCatchAll, kc_subphyla_CatchAll, 0, 0, sizeof(impl_tCatchAll_CatchAll) },
    { "NoCatchAll", 0, false, phylum_tCatchAll, 0, 0, 0, sizeof(impl_tCatchAll_NoCatchAll) },
    { "implicitEventHandler", 0, false, phylum_tEventHandlers, 0, 0, 0, sizeof(impl_tEventHandlers_implicitEventHandler) },
    { "userDefinedEventHandler", 2, false, phylum_tEventHandlers, kc_subphyla_userDefinedEventHandler, 0, 0, sizeof(impl_tEventHandlers_userDefinedEventHandler) },
    { "NiltOnMessage_list", 0, false, phylum_tOnMessage_list, 0, 0, 0, sizeof(impl_tOnMessage_list) },
    { "ConstOnMessage_list", 2, false, phylum_tOnMessage_list, kc_subphyla_ConstOnMessage_list, 0, 0, sizeof(impl_tOnMessage_list) },
    { "NiltOnAlarm_list", 0, false, phylum_tOnAlarm_list, 0, 0, 0, sizeof(impl_tOnAlarm_list) },
    { "ConstOnAlarm_list", 2, false, phylum_tOnAlarm_list, kc_subphyla_ConstOnAlarm_list, 0, 0, sizeof(impl_tOnAlarm_list) },
    { "OnMessage", 1, false, phylum_tOnMessage, kc_subphyla_OnMessage, 0, 0, sizeof(impl_tOnMessage_OnMessage) },
    { "OnAlarm", 1, false, phylum_tOnAlarm, kc_subphyla_OnAlarm, 0, 0, sizeof(impl_tOnAlarm_OnAlarm) },
    { "implicitCompensationHandler", 0, false, phylum_tCompensationHandler, 0, 0, 0, sizeof(impl_tCompensationHandler_implicitCompensationHandler) },
    { "userDefinedCompensationHandler", 1, false, phylum_tCompensationHandler, kc_subphyla_userDefinedCompensationHandler, 0, 0, sizeof(impl_tCompensationHandler_userDefinedCompensationHandler) },
    { "processCompensationHandler", 0, false, phylum_tCompensationHandler, 0, 0, 0, sizeof(impl_tCompensationHandler_processCompensationHandler) },
    { "NiltVariable_list", 0, false, phylum_tVariable_list, 0, 0, 0, sizeof(impl_tVariable_list) },
    { "ConstVariable_list", 2, false, phylum_tVariable_list, kc_subphyla_ConstVariable_list, 0, 0, sizeof(impl_tVariable_list) },
    { "Variable", 0, false, phylum_tVariable, 0, 0, 0, sizeof(impl_tVariable_Variable) },
    { "NiltCorrelationSet_list", 0, false, phylum_tCorrelationSet_list, 0, 0, 0, sizeof(impl_tCorrelationSet_list) },
    { "ConstCorrelationSet_list", 2, false, phylum_tCorrelationSet_list, kc_subphyla_ConstCorrelationSet_list, 0, 0, sizeof(impl_tCorrelationSet_list) },
    { "CorrelationSet", 0, false, phylum_tCorrelationSet, 0, 0, 0, sizeof(impl_tCorrelationSet_CorrelationSet) },
    { "NiltCorrelation_list", 0, false, phylum_tCorrelation_list, 0, 0, 0, sizeof(impl_tCorrelation_list) },
    { "ConstCorrelation_list", 2, false, phylum_tCorrelation_list, kc_subphyla_ConstCorrelation_list, 0, 0, sizeof(impl_tCorrelation_list) },
    { "Correlation", 0, false, phylum_tCorrelation, 0, 0, 0, sizeof(impl_tCorrelation_Correlation) },
    { "Empty", 1, false, phylum_tEmpty, kc_subphyla_Empty, 0, 0, sizeof(impl_tEmpty_Empty) },
    { "Invoke", 2, false, phylum_tInvoke, kc_subphyla_Invoke, 0, 0, sizeof(impl_tInvoke_Invoke) },
    { "Receive", 2, false, phylum_tReceive, kc_subphyla_Receive, 0, 0, sizeof(impl_tReceive_Receive) },
    { "Reply", 2, false, phylum_tReply, kc_subphyla_Reply, 0, 0, sizeof(impl_tReply_Reply) },
    { "Assign", 2, false, phylum_tAssign, kc_subphyla_Assign, 0, 0, sizeof(impl_tAssign_Assign) },
    { "NiltCopy_list", 0, false, phylum_tCopy_list, 0, 0, 0, sizeof(impl_tCopy_list) },
    { "ConstCopy_list", 2, false, phylum_tCopy_list, kc_subphyla_ConstCopy_list, 0, 0, sizeof(impl_tCopy_list) },
    { "Copy", 2, false, phylum_tCopy, kc_subphyla_Copy, 0, 0, sizeof(impl_tCopy_Copy) },
    { "From", 0, false, phylum_tFrom, 0, 0, 0, sizeof(impl_tFrom_From) },
    { "To", 0, false, phylum_tTo, 0, 0, 0, sizeof(impl_tTo_To) },
    { "WaitFor", 1, false, phylum_tWait, kc_subphyla_WaitFor, 0, 0, sizeof(impl_tWait_WaitFor) },
    { "WaitUntil", 1, false, phylum_tWait, kc_subphyla_WaitUntil, 0, 0, sizeof(impl_tWait_WaitUntil) },
    { "Throw", 1, false, phylum_tThrow, kc_subphyla_Throw, 0, 0, sizeof(impl_tThrow_Throw) },
    { "Compensate", 1, false, phylum_tCompensate, kc_subphyla_Compensate, 0, 0, sizeof(impl_tCompensate_Compensate) },
    { "Terminate", 1, false, phylum_tTerminate, kc_subphyla_Terminate, 0, 0, sizeof(impl_tTerminate_Terminate) },
    { "Flow", 3, false, phylum_tFlow, kc_subphyla_Flow, 0, 0, sizeof(impl_tFlow_Flow) },
    { "Nilactivity_list", 0, false, phylum_activity_list, 0, 0, 0, sizeof(impl_activity_list) },
    { "Consactivity_list", 2, false, phylum_activity_list, kc_subphyla_Consactivity_list, 0, 0, sizeof(impl_activity_list) },
    { "NiltLink_list", 0, false, phylum_tLink_list, 0, 0, 0, sizeof(impl_tLink_list) },
    { "ConstLink_list", 2, false, phylum_tLink_list, kc_subphyla_ConstLink_list, 0, 0, sizeof(impl_tLink_list) },
    { "Link", 0, false, phylum_tLink, 0, 0, 0, sizeof(impl_tLink_Link) },
    { "Switch", 3, false, phylum_tSwitch, kc_subphyla_Switch, 0, 0, sizeof(impl_tSwitch_Switch) },
    { "NiltCase_list", 0, false, phylum_tCase_list, 0, 0, 0, sizeof(impl_tCase_list) },
    { "ConstCase_list", 2, false, phylum_tCase_list, kc_subphyla_ConstCase_list, 0, 0, sizeof(impl_tCase_list) },
    { "Case", 1, false, phylum_tCase, kc_subphyla_Case, 0, 0, sizeof(impl_tCase_Case) },
    { "Otherwise", 1, false, phylum_tOtherwise, kc_subphyla_Otherwise, 0, 0, sizeof(impl_tOtherwise_Otherwise) },
    { "While", 2, false, phylum_tWhile, kc_subphyla_While, 0, 0, sizeof(impl_tWhile_While) },
    { "Sequence", 2, false, phylum_tSequence, kc_subphyla_Sequence, 0, 0, sizeof(impl_tSequence_Sequence) },
    { "Pick", 3, false, phylum_tPick, kc_subphyla_Pick, 0, 0, sizeof(impl_tPick_Pick) },
    { "Scope", 7, false, phylum_tScope, kc_subphyla_Scope, 0, 0, sizeof(impl_tScope_Scope) },
    { "StandardElements", 2, false, phylum_standardElements, kc_subphyla_StandardElements, 0, 0, sizeof(impl_standardElements_StandardElements) },
    { "NiltTarget_list", 0, false, phylum_tTarget_list, 0, 0, 0, sizeof(impl_tTarget_list) },
    { "ConstTarget_list", 2, false, phylum_tTarget_list, kc_subphyla_ConstTarget_list, 0, 0, sizeof(impl_tTarget_list) },
    { "Target", 0, false, phylum_tTarget, 0, 0, 0, sizeof(impl_tTarget_Target) },
    { "NiltSource_list", 0, false, phylum_tSource_list, 0, 0, 0, sizeof(impl_tSource_list) },
    { "ConstSource_list", 2, false, phylum_tSource_list, kc_subphyla_ConstSource_list, 0, 0, sizeof(impl_tSource_list) },
    { "Source", 0, false, phylum_tSource, 0, 0, 0, sizeof(impl_tSource_Source) },
    { "", 0, 0, one_before_first_phylum, 0, 0, 0, 0 } /* last element */
};

static enum_phyla phylumstorageclass_uniq[] = { one_before_first_phylum, phylum_nocasestring, phylum_casestring, phylum_real, phylum_integer, phylum_voidptr, last_phylum };

KC_UNIQ_INFO kc_UniqInfo[] = {
    (KC_UNIQ_INFO)0,
    phylumstorageclass_uniq
};

} // namespace kc

namespace kc {

void
kc_no_default_in_with( const char *kc_func, int kc_line, const char *kc_file )
{
    fflush(stdout);
#ifdef _AFX
    USES_CONVERSION;
    const _TCHAR* format=A2CT(KC_NO_DEFAULT_IN_WITH);
    const _TCHAR* tkc_func=A2CT(kc_func);
    const _TCHAR* tkc_file=A2CT(kc_file);
    TRACE( format, tkc_func, tkc_file, kc_line );
#ifdef _DEBUG
    if (AfxAssertFailedLine(kc_file, kc_line))
#endif
	AfxDebugBreak();
#else
    fprintf( stderr, KC_NO_DEFAULT_IN_WITH, kc_func, kc_file, kc_line );
#ifndef KC_NODEFAULT_NO_ABORT
    abort();
#else
    exit( 1 );
#endif
#endif
}

void
kc_returnless_function( const char *kc_func, int kc_line, const char *kc_file )
{
    fflush(stdout);
#ifdef _AFX
    USES_CONVERSION;
    const _TCHAR* format=_T("Internal Error: function %s does not return a value, at %s:%d");
    const _TCHAR* tkc_func=A2CT(kc_func);
    const _TCHAR* tkc_file=A2CT(kc_file);
    TRACE( format, tkc_func, tkc_file, kc_line );
#ifdef _DEBUG
    if (AfxAssertFailedLine(kc_file, kc_line))
#endif
	AfxDebugBreak();
#else
    fprintf( stderr, "Internal Error: function %s does not return a value, at %s:%d", kc_func, kc_file, kc_line );
#ifndef KC_NODEFAULT_NO_ABORT
    abort();
#else
    exit( 1 );
#endif
#endif
}

void
kc_assertionFailed(const char *kc_fn, int kc_l)
{
    fflush(stdout);
#ifdef _AFX
    USES_CONVERSION;
    const _TCHAR* format=_T("Internal Error: Assertion failed at %s:%d\n");
    const _TCHAR* tkc_func=A2CT(kc_fn);
    TRACE( format, tkc_func, kc_l );
#ifdef _DEBUG
    if (AfxAssertFailedLine(kc_fn, kc_l))
#endif
	AfxDebugBreak();
#else
    fprintf( stderr, "Internal Error: Assertion failed at %s:%d\n", kc_fn, kc_l );
#ifndef KC_ASSERT_NO_ABORT
    abort();
#else
    exit( 1 );
#endif
#endif
}

void
kc_assertionReasonFailed(const char *kc_fn, int kc_l, const char *kc_s)
{
    fflush(stdout);
#ifdef _AFX
    USES_CONVERSION;
    const _TCHAR* format=_T("Internal Error: Assertion failed at file %s:%d: %s\n");
    const _TCHAR* tkc_func=A2CT(kc_fn);
    const _TCHAR* tkc_s=A2CT(kc_s);
    TRACE( format, tkc_func, kc_l, tkc_s );
#ifdef _DEBUG
    if (AfxAssertFailedLine(kc_fn, kc_l))
#endif
	AfxDebugBreak();
#else
    fprintf( stderr, "Internal Error: Assertion failed at file %s:%d: %s\n", kc_fn, kc_l, kc_s );
#ifndef KC_ASSERT_NO_ABORT
    abort();
#else
    exit( 1 );
#endif
#endif
}

void
kc_assertionNonNullFailed(const char *kc_fn, int kc_l, const char *kc_str)
{
    fflush(stdout);
#ifdef _AFX
    USES_CONVERSION;
    const _TCHAR* format=_T("Internal Error: Assertion failed at %s:%d: pointer %s is NULL\n");
    const _TCHAR* tkc_func=A2CT(kc_fn);
    const _TCHAR* tkc_s=A2CT(kc_str);
    TRACE( format , tkc_func, kc_l, tkc_s);
#ifdef _DEBUG
    if (AfxAssertFailedLine(kc_fn, kc_l))
#endif
	AfxDebugBreak();
#else
    fprintf( stderr, "Internal Error: Assertion failed at %s:%d: pointer %s is NULL\n", kc_fn, kc_l, kc_str );
#ifndef KC_ASSERT_NO_ABORT
    abort();
#else
    exit( 1 );
#endif
#endif
}

void
kc_assertionOperatorInPhylumFailed(int kc_op, const char *kc_str1, const char *kc_str2, const char *kc_phy, const char *kc_fn, int kc_l)
{
    fflush(stdout);
#ifdef _AFX
    USES_CONVERSION;
    const _TCHAR* format=_T("Internal Error: Assertion failed at %s:%d: illegal value for (%s) %s%s: %d not a valid operator\n");
    const _TCHAR* tkc_func=A2CT(kc_fn);
    const _TCHAR* tkc_s1=A2CT(kc_str1);
    const _TCHAR* tkc_s2=A2CT(kc_str2);
    const _TCHAR* tname=A2CT(kc_phy);
    if ((kc_op <= one_before_first_operator) || (kc_op >= last_operator)) {
	TRACE (format, tkc_func, kc_l, tname, tkc_s1, tkc_s2, kc_op );
    } else {
	format=_T("Internal Error: Assertion failed at %s:%d: illegal value for (%s) %s%s: %s (%d) is a value of %s\n");
	const _TCHAR* tname2=A2CT(operator_info[kc_op].name);
	const _TCHAR* tname3=A2CT(phylum_info[operator_info[kc_op].phylum].name);
	TRACE(format,tkc_func, kc_l, tname, tkc_s1, tkc_s2, tname2, kc_op, tname3 );
    }
#ifdef _DEBUG
    if (AfxAssertFailedLine(kc_fn, kc_l))
#endif
	AfxDebugBreak();
#else
    if ((kc_op <= one_before_first_operator) || (kc_op >= last_operator)) {
	fprintf( stderr, "Internal Error: Assertion failed at %s:%d: illegal value for (%s) %s%s: %d not a valid operator\n",
	    kc_fn, kc_l, kc_phy, kc_str1, kc_str2, kc_op );
    } else {
	fprintf( stderr, "Internal Error: Assertion failed at %s:%d: illegal value for (%s) %s%s: %s (%d) is a value of %s\n",
	    kc_fn, kc_l, kc_phy, kc_str1, kc_str2, operator_info[kc_op].name, kc_op, phylum_info[operator_info[kc_op].phylum].name );
    }
#ifndef KC_ASSERT_NO_ABORT
    abort();
#else
    exit( 1 );
#endif
#endif
}

void kc_invalid_operator( const char *kc_func_prefix, enum_phyla kc_phy, int kc_line, const char *kc_file, enum_operators kc_oper )
{
    fflush(stdout);
#ifdef _AFX
    USES_CONVERSION;
    const _TCHAR* format=_T("Internal Error: invalid operator code in %s%s at %s:%d: %s\n");
    const _TCHAR* tkc_func=A2CT(kc_func_prefix);
    const _TCHAR* tkc_file=A2CT(kc_file);
    const _TCHAR* ts1=A2CT(phylumname_or_error( kc_phy ));
    const _TCHAR* ts2=A2CT(kc_operatorname_or_error( kc_oper ));
    TRACE( format, tkc_func, ts1, tkc_file, kc_line, ts2);
#ifdef _DEBUG
    if (AfxAssertFailedLine(kc_file, kc_line))
#endif
	AfxDebugBreak();
#else
    fprintf( stderr, "Internal Error: invalid operator code in %s%s at %s:%d: %s\n", kc_func_prefix, phylumname_or_error( kc_phy ), kc_file, kc_line, kc_operatorname_or_error( kc_oper ));
#ifndef KC_INVALID_OPERATOR_NO_ABORT
    abort();
#else
    exit( 1 );
#endif
#endif
}
const enum_phyla impl_nocasestring::phylum_sel_ = phylum_nocasestring;
const enum_phyla impl_casestring::phylum_sel_ = phylum_casestring;
const enum_phyla impl_real::phylum_sel_ = phylum_real;
impl_real__Real::impl_real__Real(REAL _value)
    : value(_value) { }
const enum_phyla impl_integer::phylum_sel_ = phylum_integer;
impl_integer__Int::impl_integer__Int(INTEGER _value)
    : value(_value) { }
const enum_phyla impl_voidptr::phylum_sel_ = phylum_voidptr;
impl_voidptr__VoidPtr::impl_voidptr__VoidPtr(void* _pointer)
    : pointer(_pointer) { }
const enum_phyla impl_tProcess::phylum_sel_ = phylum_tProcess;
impl_tProcess_Process::impl_tProcess_Process(tPartnerLink_list _tPartnerLink_list_1, tPartner_list _tPartner_list_1, tVariable_list _tVariable_list_1, tCorrelationSet_list _tCorrelationSet_list_1, tFaultHandlers _tFaultHandlers_1, tCompensationHandler _tCompensationHandler_1, tEventHandlers _tEventHandlers_1, tStop _tStop_1, activity _activity_1)
    : tPartnerLink_list_1(_tPartnerLink_list_1), tPartner_list_1(_tPartner_list_1), tVariable_list_1(_tVariable_list_1), tCorrelationSet_list_1(_tCorrelationSet_list_1), tFaultHandlers_1(_tFaultHandlers_1), tCompensationHandler_1(_tCompensationHandler_1), tEventHandlers_1(_tEventHandlers_1), tStop_1(_tStop_1), activity_1(_activity_1) { }
const enum_phyla impl_tStop::phylum_sel_ = phylum_tStop;
impl_tStop_StopInScope::impl_tStop_StopInScope()
    { }
impl_tStop_StopInProcess::impl_tStop_StopInProcess()
    { }
const enum_phyla impl_activity::phylum_sel_ = phylum_activity;
impl_activity_activityCompensate::impl_activity_activityCompensate(tCompensate _tCompensate_1)
    : tCompensate_1(_tCompensate_1) { }
impl_activity_activityScope::impl_activity_activityScope(tScope _tScope_1)
    : tScope_1(_tScope_1) { }
impl_activity_activityPick::impl_activity_activityPick(tPick _tPick_1)
    : tPick_1(_tPick_1) { }
impl_activity_activitySequence::impl_activity_activitySequence(tSequence _tSequence_1)
    : tSequence_1(_tSequence_1) { }
impl_activity_activityWhile::impl_activity_activityWhile(tWhile _tWhile_1)
    : tWhile_1(_tWhile_1) { }
impl_activity_activitySwitch::impl_activity_activitySwitch(tSwitch _tSwitch_1)
    : tSwitch_1(_tSwitch_1) { }
impl_activity_activityFlow::impl_activity_activityFlow(tFlow _tFlow_1)
    : tFlow_1(_tFlow_1) { }
impl_activity_activityTerminate::impl_activity_activityTerminate(tTerminate _tTerminate_1)
    : tTerminate_1(_tTerminate_1) { }
impl_activity_activityThrow::impl_activity_activityThrow(tThrow _tThrow_1)
    : tThrow_1(_tThrow_1) { }
impl_activity_activityWait::impl_activity_activityWait(tWait _tWait_1)
    : tWait_1(_tWait_1) { }
impl_activity_activityAssign::impl_activity_activityAssign(tAssign _tAssign_1)
    : tAssign_1(_tAssign_1) { }
impl_activity_activityReply::impl_activity_activityReply(tReply _tReply_1)
    : tReply_1(_tReply_1) { }
impl_activity_activityReceive::impl_activity_activityReceive(tReceive _tReceive_1)
    : tReceive_1(_tReceive_1) { }
impl_activity_activityInvoke::impl_activity_activityInvoke(tInvoke _tInvoke_1)
    : tInvoke_1(_tInvoke_1) { }
impl_activity_activityEmpty::impl_activity_activityEmpty(tEmpty _tEmpty_1)
    : tEmpty_1(_tEmpty_1) { }
const enum_phyla impl_tPartnerLink_list::phylum_sel_ = phylum_tPartnerLink_list;
impl_tPartnerLink_list::impl_tPartnerLink_list(tPartnerLink p1 , tPartnerLink_list p2)
    : tPartnerLink_1(p1), tPartnerLink_list_1(p2) { }
const enum_phyla impl_tPartnerLink::phylum_sel_ = phylum_tPartnerLink;
impl_tPartnerLink_PartnerLink::impl_tPartnerLink_PartnerLink()
    { }
const enum_phyla impl_tPartner_list::phylum_sel_ = phylum_tPartner_list;
impl_tPartner_list::impl_tPartner_list(tPartner p1 , tPartner_list p2)
    : tPartner_1(p1), tPartner_list_1(p2) { }
const enum_phyla impl_tPartner::phylum_sel_ = phylum_tPartner;
impl_tPartner_Partner::impl_tPartner_Partner(tPartnerLink_list _tPartnerLink_list_1)
    : tPartnerLink_list_1(_tPartnerLink_list_1) { }
const enum_phyla impl_tFaultHandlers::phylum_sel_ = phylum_tFaultHandlers;
impl_tFaultHandlers_implicitFaultHandler::impl_tFaultHandlers_implicitFaultHandler()
    { }
impl_tFaultHandlers_userDefinedFaultHandler::impl_tFaultHandlers_userDefinedFaultHandler(tCatch_list _tCatch_list_1, tCatchAll _tCatchAll_1)
    : tCatch_list_1(_tCatch_list_1), tCatchAll_1(_tCatchAll_1) { }
const enum_phyla impl_tCatch_list::phylum_sel_ = phylum_tCatch_list;
impl_tCatch_list::impl_tCatch_list(tCatch p1 , tCatch_list p2)
    : tCatch_1(p1), tCatch_list_1(p2) { }
const enum_phyla impl_tCatch::phylum_sel_ = phylum_tCatch;
impl_tCatch_Catch::impl_tCatch_Catch(activity _activity_1)
    : activity_1(_activity_1) { }
const enum_phyla impl_tCatchAll::phylum_sel_ = phylum_tCatchAll;
impl_tCatchAll_NoCatchAll::impl_tCatchAll_NoCatchAll()
    { }
impl_tCatchAll_CatchAll::impl_tCatchAll_CatchAll(activity _activity_1)
    : activity_1(_activity_1) { }
const enum_phyla impl_tEventHandlers::phylum_sel_ = phylum_tEventHandlers;
impl_tEventHandlers_userDefinedEventHandler::impl_tEventHandlers_userDefinedEventHandler(tOnMessage_list _tOnMessage_list_1, tOnAlarm_list _tOnAlarm_list_1)
    : tOnMessage_list_1(_tOnMessage_list_1), tOnAlarm_list_1(_tOnAlarm_list_1) { }
impl_tEventHandlers_implicitEventHandler::impl_tEventHandlers_implicitEventHandler()
    { }
const enum_phyla impl_tOnMessage_list::phylum_sel_ = phylum_tOnMessage_list;
impl_tOnMessage_list::impl_tOnMessage_list(tOnMessage p1 , tOnMessage_list p2)
    : tOnMessage_1(p1), tOnMessage_list_1(p2) { }
const enum_phyla impl_tOnAlarm_list::phylum_sel_ = phylum_tOnAlarm_list;
impl_tOnAlarm_list::impl_tOnAlarm_list(tOnAlarm p1 , tOnAlarm_list p2)
    : tOnAlarm_1(p1), tOnAlarm_list_1(p2) { }
const enum_phyla impl_tOnMessage::phylum_sel_ = phylum_tOnMessage;
impl_tOnMessage_OnMessage::impl_tOnMessage_OnMessage(activity _activity_1)
    : activity_1(_activity_1) { }
const enum_phyla impl_tOnAlarm::phylum_sel_ = phylum_tOnAlarm;
impl_tOnAlarm_OnAlarm::impl_tOnAlarm_OnAlarm(activity _activity_1)
    : activity_1(_activity_1) { }
const enum_phyla impl_tCompensationHandler::phylum_sel_ = phylum_tCompensationHandler;
impl_tCompensationHandler_processCompensationHandler::impl_tCompensationHandler_processCompensationHandler()
    { }
impl_tCompensationHandler_userDefinedCompensationHandler::impl_tCompensationHandler_userDefinedCompensationHandler(activity _activity_1)
    : activity_1(_activity_1) { }
impl_tCompensationHandler_implicitCompensationHandler::impl_tCompensationHandler_implicitCompensationHandler()
    { }
const enum_phyla impl_tVariable_list::phylum_sel_ = phylum_tVariable_list;
impl_tVariable_list::impl_tVariable_list(tVariable p1 , tVariable_list p2)
    : tVariable_1(p1), tVariable_list_1(p2) { }
const enum_phyla impl_tVariable::phylum_sel_ = phylum_tVariable;
impl_tVariable_Variable::impl_tVariable_Variable()
    { }
const enum_phyla impl_tCorrelationSet_list::phylum_sel_ = phylum_tCorrelationSet_list;
impl_tCorrelationSet_list::impl_tCorrelationSet_list(tCorrelationSet p1 , tCorrelationSet_list p2)
    : tCorrelationSet_1(p1), tCorrelationSet_list_1(p2) { }
const enum_phyla impl_tCorrelationSet::phylum_sel_ = phylum_tCorrelationSet;
impl_tCorrelationSet_CorrelationSet::impl_tCorrelationSet_CorrelationSet()
    { }
const enum_phyla impl_tCorrelation_list::phylum_sel_ = phylum_tCorrelation_list;
impl_tCorrelation_list::impl_tCorrelation_list(tCorrelation p1 , tCorrelation_list p2)
    : tCorrelation_1(p1), tCorrelation_list_1(p2) { }
const enum_phyla impl_tCorrelation::phylum_sel_ = phylum_tCorrelation;
impl_tCorrelation_Correlation::impl_tCorrelation_Correlation()
    { }
const enum_phyla impl_tEmpty::phylum_sel_ = phylum_tEmpty;
impl_tEmpty_Empty::impl_tEmpty_Empty(standardElements _standardElements_1)
    : standardElements_1(_standardElements_1) { }
const enum_phyla impl_tInvoke::phylum_sel_ = phylum_tInvoke;
impl_tInvoke_Invoke::impl_tInvoke_Invoke(standardElements _standardElements_1, tCorrelation_list _tCorrelation_list_1)
    : standardElements_1(_standardElements_1), tCorrelation_list_1(_tCorrelation_list_1) { }
const enum_phyla impl_tReceive::phylum_sel_ = phylum_tReceive;
impl_tReceive_Receive::impl_tReceive_Receive(standardElements _standardElements_1, tCorrelation_list _tCorrelation_list_1)
    : standardElements_1(_standardElements_1), tCorrelation_list_1(_tCorrelation_list_1) { }
const enum_phyla impl_tReply::phylum_sel_ = phylum_tReply;
impl_tReply_Reply::impl_tReply_Reply(standardElements _standardElements_1, tCorrelation_list _tCorrelation_list_1)
    : standardElements_1(_standardElements_1), tCorrelation_list_1(_tCorrelation_list_1) { }
const enum_phyla impl_tAssign::phylum_sel_ = phylum_tAssign;
impl_tAssign_Assign::impl_tAssign_Assign(standardElements _standardElements_1, tCopy_list _tCopy_list_1)
    : standardElements_1(_standardElements_1), tCopy_list_1(_tCopy_list_1) { }
const enum_phyla impl_tCopy_list::phylum_sel_ = phylum_tCopy_list;
impl_tCopy_list::impl_tCopy_list(tCopy p1 , tCopy_list p2)
    : tCopy_1(p1), tCopy_list_1(p2) { }
const enum_phyla impl_tCopy::phylum_sel_ = phylum_tCopy;
impl_tCopy_Copy::impl_tCopy_Copy(tFrom _tFrom_1, tTo _tTo_1)
    : tFrom_1(_tFrom_1), tTo_1(_tTo_1) { }
const enum_phyla impl_tFrom::phylum_sel_ = phylum_tFrom;
impl_tFrom_From::impl_tFrom_From()
    { }
const enum_phyla impl_tTo::phylum_sel_ = phylum_tTo;
impl_tTo_To::impl_tTo_To()
    { }
const enum_phyla impl_tWait::phylum_sel_ = phylum_tWait;
impl_tWait_WaitUntil::impl_tWait_WaitUntil(standardElements _standardElements_1)
    : standardElements_1(_standardElements_1) { }
impl_tWait_WaitFor::impl_tWait_WaitFor(standardElements _standardElements_1)
    : standardElements_1(_standardElements_1) { }
const enum_phyla impl_tThrow::phylum_sel_ = phylum_tThrow;
impl_tThrow_Throw::impl_tThrow_Throw(standardElements _standardElements_1)
    : standardElements_1(_standardElements_1) { }
const enum_phyla impl_tCompensate::phylum_sel_ = phylum_tCompensate;
impl_tCompensate_Compensate::impl_tCompensate_Compensate(standardElements _standardElements_1)
    : standardElements_1(_standardElements_1) { }
const enum_phyla impl_tTerminate::phylum_sel_ = phylum_tTerminate;
impl_tTerminate_Terminate::impl_tTerminate_Terminate(standardElements _standardElements_1)
    : standardElements_1(_standardElements_1) { }
const enum_phyla impl_tFlow::phylum_sel_ = phylum_tFlow;
impl_tFlow_Flow::impl_tFlow_Flow(standardElements _standardElements_1, tLink_list _tLink_list_1, activity_list _activity_list_1)
    : standardElements_1(_standardElements_1), tLink_list_1(_tLink_list_1), activity_list_1(_activity_list_1) { }
const enum_phyla impl_activity_list::phylum_sel_ = phylum_activity_list;
impl_activity_list::impl_activity_list(activity p1 , activity_list p2)
    : activity_1(p1), activity_list_1(p2) { }
const enum_phyla impl_tLink_list::phylum_sel_ = phylum_tLink_list;
impl_tLink_list::impl_tLink_list(tLink p1 , tLink_list p2)
    : tLink_1(p1), tLink_list_1(p2) { }
const enum_phyla impl_tLink::phylum_sel_ = phylum_tLink;
impl_tLink_Link::impl_tLink_Link()
    { }
const enum_phyla impl_tSwitch::phylum_sel_ = phylum_tSwitch;
impl_tSwitch_Switch::impl_tSwitch_Switch(standardElements _standardElements_1, tCase_list _tCase_list_1, tOtherwise _tOtherwise_1)
    : standardElements_1(_standardElements_1), tCase_list_1(_tCase_list_1), tOtherwise_1(_tOtherwise_1) { }
const enum_phyla impl_tCase_list::phylum_sel_ = phylum_tCase_list;
impl_tCase_list::impl_tCase_list(tCase p1 , tCase_list p2)
    : tCase_1(p1), tCase_list_1(p2) { }
const enum_phyla impl_tCase::phylum_sel_ = phylum_tCase;
impl_tCase_Case::impl_tCase_Case(activity _activity_1)
    : activity_1(_activity_1) { }
const enum_phyla impl_tOtherwise::phylum_sel_ = phylum_tOtherwise;
impl_tOtherwise_Otherwise::impl_tOtherwise_Otherwise(activity _activity_1)
    : activity_1(_activity_1) { }
const enum_phyla impl_tWhile::phylum_sel_ = phylum_tWhile;
impl_tWhile_While::impl_tWhile_While(standardElements _standardElements_1, activity _activity_1)
    : standardElements_1(_standardElements_1), activity_1(_activity_1) { }
const enum_phyla impl_tSequence::phylum_sel_ = phylum_tSequence;
impl_tSequence_Sequence::impl_tSequence_Sequence(standardElements _standardElements_1, activity_list _activity_list_1)
    : standardElements_1(_standardElements_1), activity_list_1(_activity_list_1) { }
const enum_phyla impl_tPick::phylum_sel_ = phylum_tPick;
impl_tPick_Pick::impl_tPick_Pick(standardElements _standardElements_1, tOnMessage_list _tOnMessage_list_1, tOnAlarm_list _tOnAlarm_list_1)
    : standardElements_1(_standardElements_1), tOnMessage_list_1(_tOnMessage_list_1), tOnAlarm_list_1(_tOnAlarm_list_1) { }
const enum_phyla impl_tScope::phylum_sel_ = phylum_tScope;
impl_tScope_Scope::impl_tScope_Scope(standardElements _standardElements_1, tVariable_list _tVariable_list_1, tFaultHandlers _tFaultHandlers_1, tCompensationHandler _tCompensationHandler_1, tEventHandlers _tEventHandlers_1, tStop _tStop_1, activity _activity_1)
    : standardElements_1(_standardElements_1), tVariable_list_1(_tVariable_list_1), tFaultHandlers_1(_tFaultHandlers_1), tCompensationHandler_1(_tCompensationHandler_1), tEventHandlers_1(_tEventHandlers_1), tStop_1(_tStop_1), activity_1(_activity_1) { }
const enum_phyla impl_standardElements::phylum_sel_ = phylum_standardElements;
impl_standardElements_StandardElements::impl_standardElements_StandardElements(tTarget_list _tTarget_list_1, tSource_list _tSource_list_1)
    : tTarget_list_1(_tTarget_list_1), tSource_list_1(_tSource_list_1) { }
const enum_phyla impl_tTarget_list::phylum_sel_ = phylum_tTarget_list;
impl_tTarget_list::impl_tTarget_list(tTarget p1 , tTarget_list p2)
    : tTarget_1(p1), tTarget_list_1(p2) { }
const enum_phyla impl_tTarget::phylum_sel_ = phylum_tTarget;
impl_tTarget_Target::impl_tTarget_Target()
    { }
const enum_phyla impl_tSource_list::phylum_sel_ = phylum_tSource_list;
impl_tSource_list::impl_tSource_list(tSource p1 , tSource_list p2)
    : tSource_1(p1), tSource_list_1(p2) { }
const enum_phyla impl_tSource::phylum_sel_ = phylum_tSource;
impl_tSource_Source::impl_tSource_Source()
    { }

#ifdef KC_STATISTICS
KC_OPERATOR_STATISTICS operator_statistics[KC_NO_OF_OPERATORS];
static int kc_casestring_strlen =0;
static int kc_nocasestring_strlen =0;
#  define KC_COLLECT_STATS0(v) v
#else
#  define KC_COLLECT_STATS0(v)
#endif

#ifndef KC_CREATE_STATS
#  define KC_CREATE_STATS(oper) operator_statistics[oper].created++;
#endif
#ifndef KC_EXISTINGNOTFOUND_STATS
#  define KC_EXISTINGNOTFOUND_STATS(oper) operator_statistics[oper].existing_not_found++;
#endif

#ifndef KC_FREE_CALLED_STATS
#  define KC_FREE_CALLED_STATS(oper,rec) operator_statistics[oper].free_called[(rec?true:false)]++;
#endif

#ifndef KC_FREED_STATS
#  define KC_FREED_STATS(oper,rec) operator_statistics[oper].freed[(rec?true:false)]++;
#endif
static hashtable_struct_t kc_not_uniq_static_hashtable;
static hashtable_struct_t uniq_static_hashtable;

bool kc_storageclass_still_uniq[] = {
    true, true };

hashtable_t hashtables[] = {
    &kc_not_uniq_static_hashtable,
    &uniq_static_hashtable,
};

const char* kc_storageclassnames[] = { "kc_not_uniq", "uniq" };

namespace { // all local to k.cc

activity kc_initialize_activity(activity kc_x)
{
#line 115 "bpel-abstract.k"
    kc_x->dpe =  mkinteger(0);

#line  2200 "bpel-kc-k.cc"
    return kc_x;
}

tOnMessage_list kc_initialize_tOnMessage_list(tOnMessage_list kc_x)
{
#line 207 "bpel-abstract.k"
    kc_x->dpe =  mkinteger(0);

#line  2209 "bpel-kc-k.cc"
    return kc_x;
}

tOnAlarm_list kc_initialize_tOnAlarm_list(tOnAlarm_list kc_x)
{
#line 215 "bpel-abstract.k"
    kc_x->dpe =  mkinteger(0);

#line  2218 "bpel-kc-k.cc"
    return kc_x;
}

tOnMessage kc_initialize_tOnMessage(tOnMessage kc_x)
{
#line 223 "bpel-abstract.k"
    kc_x->dpe =  mkinteger(0);

#line  2227 "bpel-kc-k.cc"
    return kc_x;
}

tOnAlarm kc_initialize_tOnAlarm(tOnAlarm kc_x)
{
#line 236 "bpel-abstract.k"
    kc_x->dpe =  mkinteger(0);

#line  2236 "bpel-kc-k.cc"
    return kc_x;
}

tCompensationHandler kc_initialize_tCompensationHandler(tCompensationHandler kc_x)
{
#line 255 "bpel-abstract.k"
    kc_x->compensateWithoutScope =  false;
#line 258 "bpel-abstract.k"
    kc_x->compensateWithScope =  false;

#line  2247 "bpel-kc-k.cc"
    return kc_x;
}

tInvoke kc_initialize_tInvoke(tInvoke kc_x)
{
#line 332 "bpel-abstract.k"
    kc_x->dpe =  mkinteger(0);

#line  2256 "bpel-kc-k.cc"
    return kc_x;
}

tCompensate kc_initialize_tCompensate(tCompensate kc_x)
{
#line 436 "bpel-abstract.k"
    kc_x->inFaultHandler =  true;

#line  2265 "bpel-kc-k.cc"
    return kc_x;
}

tFlow kc_initialize_tFlow(tFlow kc_x)
{
#line 465 "bpel-abstract.k"
    kc_x->dpe =  mkinteger(0);

#line  2274 "bpel-kc-k.cc"
    return kc_x;
}

activity_list kc_initialize_activity_list(activity_list kc_x)
{
#line 475 "bpel-abstract.k"
    kc_x->dpe =  mkinteger(0);

#line  2283 "bpel-kc-k.cc"
    return kc_x;
}

tSwitch kc_initialize_tSwitch(tSwitch kc_x)
{
#line 499 "bpel-abstract.k"
    kc_x->dpe =  mkinteger(0);

#line  2292 "bpel-kc-k.cc"
    return kc_x;
}

tCase_list kc_initialize_tCase_list(tCase_list kc_x)
{
#line 510 "bpel-abstract.k"
    kc_x->dpe =  mkinteger(0);

#line  2301 "bpel-kc-k.cc"
    return kc_x;
}

tCase kc_initialize_tCase(tCase kc_x)
{
#line 520 "bpel-abstract.k"
    kc_x->dpe =  mkinteger(0);

#line  2310 "bpel-kc-k.cc"
    return kc_x;
}

tOtherwise kc_initialize_tOtherwise(tOtherwise kc_x)
{
#line 530 "bpel-abstract.k"
    kc_x->dpe =  mkinteger(0);

#line  2319 "bpel-kc-k.cc"
    return kc_x;
}

tSequence kc_initialize_tSequence(tSequence kc_x)
{
#line 560 "bpel-abstract.k"
    kc_x->dpe =  mkinteger(0);

#line  2328 "bpel-kc-k.cc"
    return kc_x;
}

tPick kc_initialize_tPick(tPick kc_x)
{
#line 573 "bpel-abstract.k"
    kc_x->dpe =  mkinteger(0);

#line  2337 "bpel-kc-k.cc"
    return kc_x;
}

tScope kc_initialize_tScope(tScope kc_x)
{
#line 603 "bpel-abstract.k"
    kc_x->dpe =  mkinteger(0);

#line  2346 "bpel-kc-k.cc"
    return kc_x;
}

standardElements kc_initialize_standardElements(standardElements kc_x)
{
#line 620 "bpel-abstract.k"
    kc_x->dpe =  mkinteger(0);
#line 626 "bpel-abstract.k"
    kc_x->hasTarget =  false;

#line  2357 "bpel-kc-k.cc"
    return kc_x;
}

tTarget_list kc_initialize_tTarget_list(tTarget_list kc_x)
{
#line 633 "bpel-abstract.k"
    kc_x->hasTarget =  false;

#line  2366 "bpel-kc-k.cc"
    return kc_x;
}

tSource_list kc_initialize_tSource_list(tSource_list kc_x)
{
#line 654 "bpel-abstract.k"
    kc_x->dpe =  mkinteger(0);

#line  2375 "bpel-kc-k.cc"
    return kc_x;
}

tSource kc_initialize_tSource(tSource kc_x)
{
#line 665 "bpel-abstract.k"
    kc_x->dpe =  mkinteger(0);

#line  2384 "bpel-kc-k.cc"
    return kc_x;
}


} // namespace

enum_phyla
impl_abstract_phylum::phylum() const {
    return operator_info[prod_sel()].phylum;
}

const char*
impl_abstract_phylum::phylum_name() const {
    return phylum_info[phylum()].name;
}

const char*
impl_abstract_phylum::op_name() const {
    return operator_info[prod_sel()].name;
}

casestring
mkcasestring(const kc_char_t *kc_s, int length)
{
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel__Str));

    casestring kc_x=new impl_casestring__Str(kc_s);
    if(length>=0) 
	kc_x->make_own(length);

    casestring unique_kc_x=hashtables[uniq]->ht_check_insert((casestring)kc_x);
    if(unique_kc_x!=kc_x) {
	if(length<0) 
	    kc_x->name=0;

	delete kc_x;
	kc_x=unique_kc_x;
    } else {
	KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel__Str));
	if(length<0) 
	    kc_x->make_own(static_cast<int>(kc_strlen(kc_s)));

	kc_x->post_create();
    }
    return kc_x;
}

nocasestring
mknocasestring(const kc_char_t *kc_s, int length)
{
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NoCaseStr));

    nocasestring kc_x=new impl_nocasestring_NoCaseStr(kc_s);
    if(length>=0)
	kc_x->make_own(length);
    nocasestring unique_kc_x=hashtables[uniq]->ht_check_insert((nocasestring)kc_x);
    if(unique_kc_x!=kc_x) {
	if(length<0)
	    kc_x->name=0;
	delete kc_x;
	kc_x=unique_kc_x;
    } else {
	KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NoCaseStr));
	if(length<0)
	    kc_x->make_own(static_cast<int>(kc_strlen(kc_s)));
	kc_x->post_create();
    }

    return kc_x;
}

integer
mkinteger(const INTEGER kc_i)
{
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel__Int));

    integer kc_x =new impl_integer__Int(kc_i);
    integer unique_kc_x=hashtables[uniq]->ht_check_insert(kc_x);
    if(unique_kc_x!=kc_x) {
	delete kc_x;
	kc_x=unique_kc_x;
    } else {
	KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel__Int));
	kc_x->post_create();
    }

    return kc_x;
}

real
mkreal(const REAL kc_r)
{
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel__Real));

    real kc_x=new impl_real__Real(kc_r);
    real unique_kc_x=hashtables[uniq]->ht_check_insert(kc_x);
    if(unique_kc_x!=kc_x) {
	delete kc_x;
	kc_x=unique_kc_x;
    } else {
	KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel__Real));
	kc_x->post_create();
    }

    return kc_x;
}

voidptr
mkvoidptr(void *kc_p)
{
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel__VoidPtr));
    voidptr kc_x=new impl_voidptr__VoidPtr(kc_p);
    voidptr unique_kc_x=hashtables[uniq]->ht_check_insert(kc_x);
    if(unique_kc_x!=kc_x) {
	delete kc_x;
	kc_x=unique_kc_x;
    } else {
	KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel__VoidPtr));
	kc_x->post_create();
    }
    return kc_x;
}

impl_tProcess_Process*
Process(tPartnerLink_list _tPartnerLink_list_1, tPartner_list _tPartner_list_1, tVariable_list _tVariable_list_1, tCorrelationSet_list _tCorrelationSet_list_1, tFaultHandlers _tFaultHandlers_1, tCompensationHandler _tCompensationHandler_1, tEventHandlers _tEventHandlers_1, tStop _tStop_1, activity _activity_1) {
    assertPhylum(_tPartnerLink_list_1, phylum_tPartnerLink_list);
    assertPhylum(_tPartner_list_1, phylum_tPartner_list);
    assertPhylum(_tVariable_list_1, phylum_tVariable_list);
    assertPhylum(_tCorrelationSet_list_1, phylum_tCorrelationSet_list);
    assertPhylum(_tFaultHandlers_1, phylum_tFaultHandlers);
    assertPhylum(_tCompensationHandler_1, phylum_tCompensationHandler);
    assertPhylum(_tEventHandlers_1, phylum_tEventHandlers);
    assertPhylum(_tStop_1, phylum_tStop);
    assertPhylum(_activity_1, phylum_activity);
    tProcess kc_x = new impl_tProcess_Process(_tPartnerLink_list_1, _tPartner_list_1, _tVariable_list_1, _tCorrelationSet_list_1, _tFaultHandlers_1, _tCompensationHandler_1, _tEventHandlers_1, _tStop_1, _activity_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Process));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Process));
    kc_x->post_create();
    return static_cast<impl_tProcess_Process*>(kc_x);
}

impl_tStop_StopInProcess*
StopInProcess() {
    tStop kc_x = new impl_tStop_StopInProcess();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_StopInProcess));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_StopInProcess));
    kc_x->post_create();
    return static_cast<impl_tStop_StopInProcess*>(kc_x);
}

impl_tStop_StopInScope*
StopInScope() {
    tStop kc_x = new impl_tStop_StopInScope();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_StopInScope));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_StopInScope));
    kc_x->post_create();
    return static_cast<impl_tStop_StopInScope*>(kc_x);
}

impl_activity_activityEmpty*
activityEmpty(tEmpty _tEmpty_1) {
    assertPhylum(_tEmpty_1, phylum_tEmpty);
    activity kc_x = new impl_activity_activityEmpty(_tEmpty_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_activityEmpty));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_activityEmpty));
    kc_x->post_create();
    kc_x = kc_initialize_activity(kc_x);
    return static_cast<impl_activity_activityEmpty*>(kc_x);
}

impl_activity_activityInvoke*
activityInvoke(tInvoke _tInvoke_1) {
    assertPhylum(_tInvoke_1, phylum_tInvoke);
    activity kc_x = new impl_activity_activityInvoke(_tInvoke_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_activityInvoke));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_activityInvoke));
    kc_x->post_create();
    kc_x = kc_initialize_activity(kc_x);
    return static_cast<impl_activity_activityInvoke*>(kc_x);
}

impl_activity_activityReceive*
activityReceive(tReceive _tReceive_1) {
    assertPhylum(_tReceive_1, phylum_tReceive);
    activity kc_x = new impl_activity_activityReceive(_tReceive_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_activityReceive));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_activityReceive));
    kc_x->post_create();
    kc_x = kc_initialize_activity(kc_x);
    return static_cast<impl_activity_activityReceive*>(kc_x);
}

impl_activity_activityReply*
activityReply(tReply _tReply_1) {
    assertPhylum(_tReply_1, phylum_tReply);
    activity kc_x = new impl_activity_activityReply(_tReply_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_activityReply));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_activityReply));
    kc_x->post_create();
    kc_x = kc_initialize_activity(kc_x);
    return static_cast<impl_activity_activityReply*>(kc_x);
}

impl_activity_activityAssign*
activityAssign(tAssign _tAssign_1) {
    assertPhylum(_tAssign_1, phylum_tAssign);
    activity kc_x = new impl_activity_activityAssign(_tAssign_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_activityAssign));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_activityAssign));
    kc_x->post_create();
    kc_x = kc_initialize_activity(kc_x);
    return static_cast<impl_activity_activityAssign*>(kc_x);
}

impl_activity_activityWait*
activityWait(tWait _tWait_1) {
    assertPhylum(_tWait_1, phylum_tWait);
    activity kc_x = new impl_activity_activityWait(_tWait_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_activityWait));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_activityWait));
    kc_x->post_create();
    kc_x = kc_initialize_activity(kc_x);
    return static_cast<impl_activity_activityWait*>(kc_x);
}

impl_activity_activityThrow*
activityThrow(tThrow _tThrow_1) {
    assertPhylum(_tThrow_1, phylum_tThrow);
    activity kc_x = new impl_activity_activityThrow(_tThrow_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_activityThrow));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_activityThrow));
    kc_x->post_create();
    kc_x = kc_initialize_activity(kc_x);
    return static_cast<impl_activity_activityThrow*>(kc_x);
}

impl_activity_activityTerminate*
activityTerminate(tTerminate _tTerminate_1) {
    assertPhylum(_tTerminate_1, phylum_tTerminate);
    activity kc_x = new impl_activity_activityTerminate(_tTerminate_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_activityTerminate));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_activityTerminate));
    kc_x->post_create();
    kc_x = kc_initialize_activity(kc_x);
    return static_cast<impl_activity_activityTerminate*>(kc_x);
}

impl_activity_activityFlow*
activityFlow(tFlow _tFlow_1) {
    assertPhylum(_tFlow_1, phylum_tFlow);
    activity kc_x = new impl_activity_activityFlow(_tFlow_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_activityFlow));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_activityFlow));
    kc_x->post_create();
    kc_x = kc_initialize_activity(kc_x);
    return static_cast<impl_activity_activityFlow*>(kc_x);
}

impl_activity_activitySwitch*
activitySwitch(tSwitch _tSwitch_1) {
    assertPhylum(_tSwitch_1, phylum_tSwitch);
    activity kc_x = new impl_activity_activitySwitch(_tSwitch_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_activitySwitch));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_activitySwitch));
    kc_x->post_create();
    kc_x = kc_initialize_activity(kc_x);
    return static_cast<impl_activity_activitySwitch*>(kc_x);
}

impl_activity_activityWhile*
activityWhile(tWhile _tWhile_1) {
    assertPhylum(_tWhile_1, phylum_tWhile);
    activity kc_x = new impl_activity_activityWhile(_tWhile_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_activityWhile));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_activityWhile));
    kc_x->post_create();
    kc_x = kc_initialize_activity(kc_x);
    return static_cast<impl_activity_activityWhile*>(kc_x);
}

impl_activity_activitySequence*
activitySequence(tSequence _tSequence_1) {
    assertPhylum(_tSequence_1, phylum_tSequence);
    activity kc_x = new impl_activity_activitySequence(_tSequence_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_activitySequence));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_activitySequence));
    kc_x->post_create();
    kc_x = kc_initialize_activity(kc_x);
    return static_cast<impl_activity_activitySequence*>(kc_x);
}

impl_activity_activityPick*
activityPick(tPick _tPick_1) {
    assertPhylum(_tPick_1, phylum_tPick);
    activity kc_x = new impl_activity_activityPick(_tPick_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_activityPick));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_activityPick));
    kc_x->post_create();
    kc_x = kc_initialize_activity(kc_x);
    return static_cast<impl_activity_activityPick*>(kc_x);
}

impl_activity_activityScope*
activityScope(tScope _tScope_1) {
    assertPhylum(_tScope_1, phylum_tScope);
    activity kc_x = new impl_activity_activityScope(_tScope_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_activityScope));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_activityScope));
    kc_x->post_create();
    kc_x = kc_initialize_activity(kc_x);
    return static_cast<impl_activity_activityScope*>(kc_x);
}

impl_activity_activityCompensate*
activityCompensate(tCompensate _tCompensate_1) {
    assertPhylum(_tCompensate_1, phylum_tCompensate);
    activity kc_x = new impl_activity_activityCompensate(_tCompensate_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_activityCompensate));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_activityCompensate));
    kc_x->post_create();
    kc_x = kc_initialize_activity(kc_x);
    return static_cast<impl_activity_activityCompensate*>(kc_x);
}

impl_tPartnerLink_list*
NiltPartnerLink_list() {
    tPartnerLink_list kc_x = new impl_tPartnerLink_list();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NiltPartnerLink_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NiltPartnerLink_list));
    kc_x->post_create();
    return static_cast<impl_tPartnerLink_list*>(kc_x);
}

impl_tPartnerLink_list*
ConstPartnerLink_list(tPartnerLink _tPartnerLink_1, tPartnerLink_list _tPartnerLink_list_1) {
    assertPhylum(_tPartnerLink_1, phylum_tPartnerLink);
    assertPhylum(_tPartnerLink_list_1, phylum_tPartnerLink_list);
    tPartnerLink_list kc_x = new impl_tPartnerLink_list(_tPartnerLink_1, _tPartnerLink_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ConstPartnerLink_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ConstPartnerLink_list));
    kc_x->post_create();
    return static_cast<impl_tPartnerLink_list*>(kc_x);
}

impl_tPartnerLink_PartnerLink*
PartnerLink() {
    tPartnerLink kc_x = new impl_tPartnerLink_PartnerLink();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_PartnerLink));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_PartnerLink));
    kc_x->post_create();
    return static_cast<impl_tPartnerLink_PartnerLink*>(kc_x);
}

impl_tPartner_list*
NiltPartner_list() {
    tPartner_list kc_x = new impl_tPartner_list();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NiltPartner_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NiltPartner_list));
    kc_x->post_create();
    return static_cast<impl_tPartner_list*>(kc_x);
}

impl_tPartner_list*
ConstPartner_list(tPartner _tPartner_1, tPartner_list _tPartner_list_1) {
    assertPhylum(_tPartner_1, phylum_tPartner);
    assertPhylum(_tPartner_list_1, phylum_tPartner_list);
    tPartner_list kc_x = new impl_tPartner_list(_tPartner_1, _tPartner_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ConstPartner_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ConstPartner_list));
    kc_x->post_create();
    return static_cast<impl_tPartner_list*>(kc_x);
}

impl_tPartner_Partner*
Partner(tPartnerLink_list _tPartnerLink_list_1) {
    assertPhylum(_tPartnerLink_list_1, phylum_tPartnerLink_list);
    tPartner kc_x = new impl_tPartner_Partner(_tPartnerLink_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Partner));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Partner));
    kc_x->post_create();
    return static_cast<impl_tPartner_Partner*>(kc_x);
}

impl_tFaultHandlers_userDefinedFaultHandler*
userDefinedFaultHandler(tCatch_list _tCatch_list_1, tCatchAll _tCatchAll_1) {
    assertPhylum(_tCatch_list_1, phylum_tCatch_list);
    assertPhylum(_tCatchAll_1, phylum_tCatchAll);
    tFaultHandlers kc_x = new impl_tFaultHandlers_userDefinedFaultHandler(_tCatch_list_1, _tCatchAll_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_userDefinedFaultHandler));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_userDefinedFaultHandler));
    kc_x->post_create();
    return static_cast<impl_tFaultHandlers_userDefinedFaultHandler*>(kc_x);
}

impl_tFaultHandlers_implicitFaultHandler*
implicitFaultHandler() {
    tFaultHandlers kc_x = new impl_tFaultHandlers_implicitFaultHandler();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_implicitFaultHandler));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_implicitFaultHandler));
    kc_x->post_create();
    return static_cast<impl_tFaultHandlers_implicitFaultHandler*>(kc_x);
}

impl_tCatch_list*
NiltCatch_list() {
    tCatch_list kc_x = new impl_tCatch_list();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NiltCatch_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NiltCatch_list));
    kc_x->post_create();
    return static_cast<impl_tCatch_list*>(kc_x);
}

impl_tCatch_list*
ConstCatch_list(tCatch _tCatch_1, tCatch_list _tCatch_list_1) {
    assertPhylum(_tCatch_1, phylum_tCatch);
    assertPhylum(_tCatch_list_1, phylum_tCatch_list);
    tCatch_list kc_x = new impl_tCatch_list(_tCatch_1, _tCatch_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ConstCatch_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ConstCatch_list));
    kc_x->post_create();
    return static_cast<impl_tCatch_list*>(kc_x);
}

impl_tCatch_Catch*
Catch(activity _activity_1) {
    assertPhylum(_activity_1, phylum_activity);
    tCatch kc_x = new impl_tCatch_Catch(_activity_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Catch));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Catch));
    kc_x->post_create();
    return static_cast<impl_tCatch_Catch*>(kc_x);
}

impl_tCatchAll_CatchAll*
CatchAll(activity _activity_1) {
    assertPhylum(_activity_1, phylum_activity);
    tCatchAll kc_x = new impl_tCatchAll_CatchAll(_activity_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_CatchAll));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_CatchAll));
    kc_x->post_create();
    return static_cast<impl_tCatchAll_CatchAll*>(kc_x);
}

impl_tCatchAll_NoCatchAll*
NoCatchAll() {
    tCatchAll kc_x = new impl_tCatchAll_NoCatchAll();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NoCatchAll));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NoCatchAll));
    kc_x->post_create();
    return static_cast<impl_tCatchAll_NoCatchAll*>(kc_x);
}

impl_tEventHandlers_implicitEventHandler*
implicitEventHandler() {
    tEventHandlers kc_x = new impl_tEventHandlers_implicitEventHandler();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_implicitEventHandler));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_implicitEventHandler));
    kc_x->post_create();
    return static_cast<impl_tEventHandlers_implicitEventHandler*>(kc_x);
}

impl_tEventHandlers_userDefinedEventHandler*
userDefinedEventHandler(tOnMessage_list _tOnMessage_list_1, tOnAlarm_list _tOnAlarm_list_1) {
    assertPhylum(_tOnMessage_list_1, phylum_tOnMessage_list);
    assertPhylum(_tOnAlarm_list_1, phylum_tOnAlarm_list);
    tEventHandlers kc_x = new impl_tEventHandlers_userDefinedEventHandler(_tOnMessage_list_1, _tOnAlarm_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_userDefinedEventHandler));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_userDefinedEventHandler));
    kc_x->post_create();
    return static_cast<impl_tEventHandlers_userDefinedEventHandler*>(kc_x);
}

impl_tOnMessage_list*
NiltOnMessage_list() {
    tOnMessage_list kc_x = new impl_tOnMessage_list();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NiltOnMessage_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NiltOnMessage_list));
    kc_x->post_create();
    kc_x = kc_initialize_tOnMessage_list(kc_x);
    return static_cast<impl_tOnMessage_list*>(kc_x);
}

impl_tOnMessage_list*
ConstOnMessage_list(tOnMessage _tOnMessage_1, tOnMessage_list _tOnMessage_list_1) {
    assertPhylum(_tOnMessage_1, phylum_tOnMessage);
    assertPhylum(_tOnMessage_list_1, phylum_tOnMessage_list);
    tOnMessage_list kc_x = new impl_tOnMessage_list(_tOnMessage_1, _tOnMessage_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ConstOnMessage_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ConstOnMessage_list));
    kc_x->post_create();
    kc_x = kc_initialize_tOnMessage_list(kc_x);
    return static_cast<impl_tOnMessage_list*>(kc_x);
}

impl_tOnAlarm_list*
NiltOnAlarm_list() {
    tOnAlarm_list kc_x = new impl_tOnAlarm_list();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NiltOnAlarm_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NiltOnAlarm_list));
    kc_x->post_create();
    kc_x = kc_initialize_tOnAlarm_list(kc_x);
    return static_cast<impl_tOnAlarm_list*>(kc_x);
}

impl_tOnAlarm_list*
ConstOnAlarm_list(tOnAlarm _tOnAlarm_1, tOnAlarm_list _tOnAlarm_list_1) {
    assertPhylum(_tOnAlarm_1, phylum_tOnAlarm);
    assertPhylum(_tOnAlarm_list_1, phylum_tOnAlarm_list);
    tOnAlarm_list kc_x = new impl_tOnAlarm_list(_tOnAlarm_1, _tOnAlarm_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ConstOnAlarm_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ConstOnAlarm_list));
    kc_x->post_create();
    kc_x = kc_initialize_tOnAlarm_list(kc_x);
    return static_cast<impl_tOnAlarm_list*>(kc_x);
}

impl_tOnMessage_OnMessage*
OnMessage(activity _activity_1) {
    assertPhylum(_activity_1, phylum_activity);
    tOnMessage kc_x = new impl_tOnMessage_OnMessage(_activity_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_OnMessage));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_OnMessage));
    kc_x->post_create();
    kc_x = kc_initialize_tOnMessage(kc_x);
    return static_cast<impl_tOnMessage_OnMessage*>(kc_x);
}

impl_tOnAlarm_OnAlarm*
OnAlarm(activity _activity_1) {
    assertPhylum(_activity_1, phylum_activity);
    tOnAlarm kc_x = new impl_tOnAlarm_OnAlarm(_activity_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_OnAlarm));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_OnAlarm));
    kc_x->post_create();
    kc_x = kc_initialize_tOnAlarm(kc_x);
    return static_cast<impl_tOnAlarm_OnAlarm*>(kc_x);
}

impl_tCompensationHandler_implicitCompensationHandler*
implicitCompensationHandler() {
    tCompensationHandler kc_x = new impl_tCompensationHandler_implicitCompensationHandler();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_implicitCompensationHandler));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_implicitCompensationHandler));
    kc_x->post_create();
    kc_x = kc_initialize_tCompensationHandler(kc_x);
    return static_cast<impl_tCompensationHandler_implicitCompensationHandler*>(kc_x);
}

impl_tCompensationHandler_userDefinedCompensationHandler*
userDefinedCompensationHandler(activity _activity_1) {
    assertPhylum(_activity_1, phylum_activity);
    tCompensationHandler kc_x = new impl_tCompensationHandler_userDefinedCompensationHandler(_activity_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_userDefinedCompensationHandler));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_userDefinedCompensationHandler));
    kc_x->post_create();
    kc_x = kc_initialize_tCompensationHandler(kc_x);
    return static_cast<impl_tCompensationHandler_userDefinedCompensationHandler*>(kc_x);
}

impl_tCompensationHandler_processCompensationHandler*
processCompensationHandler() {
    tCompensationHandler kc_x = new impl_tCompensationHandler_processCompensationHandler();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_processCompensationHandler));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_processCompensationHandler));
    kc_x->post_create();
    kc_x = kc_initialize_tCompensationHandler(kc_x);
    return static_cast<impl_tCompensationHandler_processCompensationHandler*>(kc_x);
}

impl_tVariable_list*
NiltVariable_list() {
    tVariable_list kc_x = new impl_tVariable_list();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NiltVariable_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NiltVariable_list));
    kc_x->post_create();
    return static_cast<impl_tVariable_list*>(kc_x);
}

impl_tVariable_list*
ConstVariable_list(tVariable _tVariable_1, tVariable_list _tVariable_list_1) {
    assertPhylum(_tVariable_1, phylum_tVariable);
    assertPhylum(_tVariable_list_1, phylum_tVariable_list);
    tVariable_list kc_x = new impl_tVariable_list(_tVariable_1, _tVariable_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ConstVariable_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ConstVariable_list));
    kc_x->post_create();
    return static_cast<impl_tVariable_list*>(kc_x);
}

impl_tVariable_Variable*
Variable() {
    tVariable kc_x = new impl_tVariable_Variable();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Variable));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Variable));
    kc_x->post_create();
    return static_cast<impl_tVariable_Variable*>(kc_x);
}

impl_tCorrelationSet_list*
NiltCorrelationSet_list() {
    tCorrelationSet_list kc_x = new impl_tCorrelationSet_list();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NiltCorrelationSet_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NiltCorrelationSet_list));
    kc_x->post_create();
    return static_cast<impl_tCorrelationSet_list*>(kc_x);
}

impl_tCorrelationSet_list*
ConstCorrelationSet_list(tCorrelationSet _tCorrelationSet_1, tCorrelationSet_list _tCorrelationSet_list_1) {
    assertPhylum(_tCorrelationSet_1, phylum_tCorrelationSet);
    assertPhylum(_tCorrelationSet_list_1, phylum_tCorrelationSet_list);
    tCorrelationSet_list kc_x = new impl_tCorrelationSet_list(_tCorrelationSet_1, _tCorrelationSet_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ConstCorrelationSet_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ConstCorrelationSet_list));
    kc_x->post_create();
    return static_cast<impl_tCorrelationSet_list*>(kc_x);
}

impl_tCorrelationSet_CorrelationSet*
CorrelationSet() {
    tCorrelationSet kc_x = new impl_tCorrelationSet_CorrelationSet();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_CorrelationSet));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_CorrelationSet));
    kc_x->post_create();
    return static_cast<impl_tCorrelationSet_CorrelationSet*>(kc_x);
}

impl_tCorrelation_list*
NiltCorrelation_list() {
    tCorrelation_list kc_x = new impl_tCorrelation_list();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NiltCorrelation_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NiltCorrelation_list));
    kc_x->post_create();
    return static_cast<impl_tCorrelation_list*>(kc_x);
}

impl_tCorrelation_list*
ConstCorrelation_list(tCorrelation _tCorrelation_1, tCorrelation_list _tCorrelation_list_1) {
    assertPhylum(_tCorrelation_1, phylum_tCorrelation);
    assertPhylum(_tCorrelation_list_1, phylum_tCorrelation_list);
    tCorrelation_list kc_x = new impl_tCorrelation_list(_tCorrelation_1, _tCorrelation_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ConstCorrelation_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ConstCorrelation_list));
    kc_x->post_create();
    return static_cast<impl_tCorrelation_list*>(kc_x);
}

impl_tCorrelation_Correlation*
Correlation() {
    tCorrelation kc_x = new impl_tCorrelation_Correlation();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Correlation));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Correlation));
    kc_x->post_create();
    return static_cast<impl_tCorrelation_Correlation*>(kc_x);
}

impl_tEmpty_Empty*
Empty(standardElements _standardElements_1) {
    assertPhylum(_standardElements_1, phylum_standardElements);
    tEmpty kc_x = new impl_tEmpty_Empty(_standardElements_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Empty));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Empty));
    kc_x->post_create();
    return static_cast<impl_tEmpty_Empty*>(kc_x);
}

impl_tInvoke_Invoke*
Invoke(standardElements _standardElements_1, tCorrelation_list _tCorrelation_list_1) {
    assertPhylum(_standardElements_1, phylum_standardElements);
    assertPhylum(_tCorrelation_list_1, phylum_tCorrelation_list);
    tInvoke kc_x = new impl_tInvoke_Invoke(_standardElements_1, _tCorrelation_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Invoke));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Invoke));
    kc_x->post_create();
    kc_x = kc_initialize_tInvoke(kc_x);
    return static_cast<impl_tInvoke_Invoke*>(kc_x);
}

impl_tReceive_Receive*
Receive(standardElements _standardElements_1, tCorrelation_list _tCorrelation_list_1) {
    assertPhylum(_standardElements_1, phylum_standardElements);
    assertPhylum(_tCorrelation_list_1, phylum_tCorrelation_list);
    tReceive kc_x = new impl_tReceive_Receive(_standardElements_1, _tCorrelation_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Receive));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Receive));
    kc_x->post_create();
    return static_cast<impl_tReceive_Receive*>(kc_x);
}

impl_tReply_Reply*
Reply(standardElements _standardElements_1, tCorrelation_list _tCorrelation_list_1) {
    assertPhylum(_standardElements_1, phylum_standardElements);
    assertPhylum(_tCorrelation_list_1, phylum_tCorrelation_list);
    tReply kc_x = new impl_tReply_Reply(_standardElements_1, _tCorrelation_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Reply));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Reply));
    kc_x->post_create();
    return static_cast<impl_tReply_Reply*>(kc_x);
}

impl_tAssign_Assign*
Assign(standardElements _standardElements_1, tCopy_list _tCopy_list_1) {
    assertPhylum(_standardElements_1, phylum_standardElements);
    assertPhylum(_tCopy_list_1, phylum_tCopy_list);
    tAssign kc_x = new impl_tAssign_Assign(_standardElements_1, _tCopy_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Assign));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Assign));
    kc_x->post_create();
    return static_cast<impl_tAssign_Assign*>(kc_x);
}

impl_tCopy_list*
NiltCopy_list() {
    tCopy_list kc_x = new impl_tCopy_list();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NiltCopy_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NiltCopy_list));
    kc_x->post_create();
    return static_cast<impl_tCopy_list*>(kc_x);
}

impl_tCopy_list*
ConstCopy_list(tCopy _tCopy_1, tCopy_list _tCopy_list_1) {
    assertPhylum(_tCopy_1, phylum_tCopy);
    assertPhylum(_tCopy_list_1, phylum_tCopy_list);
    tCopy_list kc_x = new impl_tCopy_list(_tCopy_1, _tCopy_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ConstCopy_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ConstCopy_list));
    kc_x->post_create();
    return static_cast<impl_tCopy_list*>(kc_x);
}

impl_tCopy_Copy*
Copy(tFrom _tFrom_1, tTo _tTo_1) {
    assertPhylum(_tFrom_1, phylum_tFrom);
    assertPhylum(_tTo_1, phylum_tTo);
    tCopy kc_x = new impl_tCopy_Copy(_tFrom_1, _tTo_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Copy));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Copy));
    kc_x->post_create();
    return static_cast<impl_tCopy_Copy*>(kc_x);
}

impl_tFrom_From*
From() {
    tFrom kc_x = new impl_tFrom_From();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_From));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_From));
    kc_x->post_create();
    return static_cast<impl_tFrom_From*>(kc_x);
}

impl_tTo_To*
To() {
    tTo kc_x = new impl_tTo_To();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_To));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_To));
    kc_x->post_create();
    return static_cast<impl_tTo_To*>(kc_x);
}

impl_tWait_WaitFor*
WaitFor(standardElements _standardElements_1) {
    assertPhylum(_standardElements_1, phylum_standardElements);
    tWait kc_x = new impl_tWait_WaitFor(_standardElements_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_WaitFor));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_WaitFor));
    kc_x->post_create();
    return static_cast<impl_tWait_WaitFor*>(kc_x);
}

impl_tWait_WaitUntil*
WaitUntil(standardElements _standardElements_1) {
    assertPhylum(_standardElements_1, phylum_standardElements);
    tWait kc_x = new impl_tWait_WaitUntil(_standardElements_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_WaitUntil));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_WaitUntil));
    kc_x->post_create();
    return static_cast<impl_tWait_WaitUntil*>(kc_x);
}

impl_tThrow_Throw*
Throw(standardElements _standardElements_1) {
    assertPhylum(_standardElements_1, phylum_standardElements);
    tThrow kc_x = new impl_tThrow_Throw(_standardElements_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Throw));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Throw));
    kc_x->post_create();
    return static_cast<impl_tThrow_Throw*>(kc_x);
}

impl_tCompensate_Compensate*
Compensate(standardElements _standardElements_1) {
    assertPhylum(_standardElements_1, phylum_standardElements);
    tCompensate kc_x = new impl_tCompensate_Compensate(_standardElements_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Compensate));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Compensate));
    kc_x->post_create();
    kc_x = kc_initialize_tCompensate(kc_x);
    return static_cast<impl_tCompensate_Compensate*>(kc_x);
}

impl_tTerminate_Terminate*
Terminate(standardElements _standardElements_1) {
    assertPhylum(_standardElements_1, phylum_standardElements);
    tTerminate kc_x = new impl_tTerminate_Terminate(_standardElements_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Terminate));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Terminate));
    kc_x->post_create();
    return static_cast<impl_tTerminate_Terminate*>(kc_x);
}

impl_tFlow_Flow*
Flow(standardElements _standardElements_1, tLink_list _tLink_list_1, activity_list _activity_list_1) {
    assertPhylum(_standardElements_1, phylum_standardElements);
    assertPhylum(_tLink_list_1, phylum_tLink_list);
    assertPhylum(_activity_list_1, phylum_activity_list);
    tFlow kc_x = new impl_tFlow_Flow(_standardElements_1, _tLink_list_1, _activity_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Flow));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Flow));
    kc_x->post_create();
    kc_x = kc_initialize_tFlow(kc_x);
    return static_cast<impl_tFlow_Flow*>(kc_x);
}

impl_activity_list*
Nilactivity_list() {
    activity_list kc_x = new impl_activity_list();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Nilactivity_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Nilactivity_list));
    kc_x->post_create();
    kc_x = kc_initialize_activity_list(kc_x);
    return static_cast<impl_activity_list*>(kc_x);
}

impl_activity_list*
Consactivity_list(activity _activity_1, activity_list _activity_list_1) {
    assertPhylum(_activity_1, phylum_activity);
    assertPhylum(_activity_list_1, phylum_activity_list);
    activity_list kc_x = new impl_activity_list(_activity_1, _activity_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Consactivity_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Consactivity_list));
    kc_x->post_create();
    kc_x = kc_initialize_activity_list(kc_x);
    return static_cast<impl_activity_list*>(kc_x);
}

impl_tLink_list*
NiltLink_list() {
    tLink_list kc_x = new impl_tLink_list();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NiltLink_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NiltLink_list));
    kc_x->post_create();
    return static_cast<impl_tLink_list*>(kc_x);
}

impl_tLink_list*
ConstLink_list(tLink _tLink_1, tLink_list _tLink_list_1) {
    assertPhylum(_tLink_1, phylum_tLink);
    assertPhylum(_tLink_list_1, phylum_tLink_list);
    tLink_list kc_x = new impl_tLink_list(_tLink_1, _tLink_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ConstLink_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ConstLink_list));
    kc_x->post_create();
    return static_cast<impl_tLink_list*>(kc_x);
}

impl_tLink_Link*
Link() {
    tLink kc_x = new impl_tLink_Link();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Link));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Link));
    kc_x->post_create();
    return static_cast<impl_tLink_Link*>(kc_x);
}

impl_tSwitch_Switch*
Switch(standardElements _standardElements_1, tCase_list _tCase_list_1, tOtherwise _tOtherwise_1) {
    assertPhylum(_standardElements_1, phylum_standardElements);
    assertPhylum(_tCase_list_1, phylum_tCase_list);
    assertPhylum(_tOtherwise_1, phylum_tOtherwise);
    tSwitch kc_x = new impl_tSwitch_Switch(_standardElements_1, _tCase_list_1, _tOtherwise_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Switch));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Switch));
    kc_x->post_create();
    kc_x = kc_initialize_tSwitch(kc_x);
    return static_cast<impl_tSwitch_Switch*>(kc_x);
}

impl_tCase_list*
NiltCase_list() {
    tCase_list kc_x = new impl_tCase_list();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NiltCase_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NiltCase_list));
    kc_x->post_create();
    kc_x = kc_initialize_tCase_list(kc_x);
    return static_cast<impl_tCase_list*>(kc_x);
}

impl_tCase_list*
ConstCase_list(tCase _tCase_1, tCase_list _tCase_list_1) {
    assertPhylum(_tCase_1, phylum_tCase);
    assertPhylum(_tCase_list_1, phylum_tCase_list);
    tCase_list kc_x = new impl_tCase_list(_tCase_1, _tCase_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ConstCase_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ConstCase_list));
    kc_x->post_create();
    kc_x = kc_initialize_tCase_list(kc_x);
    return static_cast<impl_tCase_list*>(kc_x);
}

impl_tCase_Case*
Case(activity _activity_1) {
    assertPhylum(_activity_1, phylum_activity);
    tCase kc_x = new impl_tCase_Case(_activity_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Case));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Case));
    kc_x->post_create();
    kc_x = kc_initialize_tCase(kc_x);
    return static_cast<impl_tCase_Case*>(kc_x);
}

impl_tOtherwise_Otherwise*
Otherwise(activity _activity_1) {
    assertPhylum(_activity_1, phylum_activity);
    tOtherwise kc_x = new impl_tOtherwise_Otherwise(_activity_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Otherwise));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Otherwise));
    kc_x->post_create();
    kc_x = kc_initialize_tOtherwise(kc_x);
    return static_cast<impl_tOtherwise_Otherwise*>(kc_x);
}

impl_tWhile_While*
While(standardElements _standardElements_1, activity _activity_1) {
    assertPhylum(_standardElements_1, phylum_standardElements);
    assertPhylum(_activity_1, phylum_activity);
    tWhile kc_x = new impl_tWhile_While(_standardElements_1, _activity_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_While));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_While));
    kc_x->post_create();
    return static_cast<impl_tWhile_While*>(kc_x);
}

impl_tSequence_Sequence*
Sequence(standardElements _standardElements_1, activity_list _activity_list_1) {
    assertPhylum(_standardElements_1, phylum_standardElements);
    assertPhylum(_activity_list_1, phylum_activity_list);
    tSequence kc_x = new impl_tSequence_Sequence(_standardElements_1, _activity_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Sequence));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Sequence));
    kc_x->post_create();
    kc_x = kc_initialize_tSequence(kc_x);
    return static_cast<impl_tSequence_Sequence*>(kc_x);
}

impl_tPick_Pick*
Pick(standardElements _standardElements_1, tOnMessage_list _tOnMessage_list_1, tOnAlarm_list _tOnAlarm_list_1) {
    assertPhylum(_standardElements_1, phylum_standardElements);
    assertPhylum(_tOnMessage_list_1, phylum_tOnMessage_list);
    assertPhylum(_tOnAlarm_list_1, phylum_tOnAlarm_list);
    tPick kc_x = new impl_tPick_Pick(_standardElements_1, _tOnMessage_list_1, _tOnAlarm_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Pick));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Pick));
    kc_x->post_create();
    kc_x = kc_initialize_tPick(kc_x);
    return static_cast<impl_tPick_Pick*>(kc_x);
}

impl_tScope_Scope*
Scope(standardElements _standardElements_1, tVariable_list _tVariable_list_1, tFaultHandlers _tFaultHandlers_1, tCompensationHandler _tCompensationHandler_1, tEventHandlers _tEventHandlers_1, tStop _tStop_1, activity _activity_1) {
    assertPhylum(_standardElements_1, phylum_standardElements);
    assertPhylum(_tVariable_list_1, phylum_tVariable_list);
    assertPhylum(_tFaultHandlers_1, phylum_tFaultHandlers);
    assertPhylum(_tCompensationHandler_1, phylum_tCompensationHandler);
    assertPhylum(_tEventHandlers_1, phylum_tEventHandlers);
    assertPhylum(_tStop_1, phylum_tStop);
    assertPhylum(_activity_1, phylum_activity);
    tScope kc_x = new impl_tScope_Scope(_standardElements_1, _tVariable_list_1, _tFaultHandlers_1, _tCompensationHandler_1, _tEventHandlers_1, _tStop_1, _activity_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Scope));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Scope));
    kc_x->post_create();
    kc_x = kc_initialize_tScope(kc_x);
    return static_cast<impl_tScope_Scope*>(kc_x);
}

impl_standardElements_StandardElements*
StandardElements(tTarget_list _tTarget_list_1, tSource_list _tSource_list_1) {
    assertPhylum(_tTarget_list_1, phylum_tTarget_list);
    assertPhylum(_tSource_list_1, phylum_tSource_list);
    standardElements kc_x = new impl_standardElements_StandardElements(_tTarget_list_1, _tSource_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_StandardElements));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_StandardElements));
    kc_x->post_create();
    kc_x = kc_initialize_standardElements(kc_x);
    return static_cast<impl_standardElements_StandardElements*>(kc_x);
}

impl_tTarget_list*
NiltTarget_list() {
    tTarget_list kc_x = new impl_tTarget_list();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NiltTarget_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NiltTarget_list));
    kc_x->post_create();
    kc_x = kc_initialize_tTarget_list(kc_x);
    return static_cast<impl_tTarget_list*>(kc_x);
}

impl_tTarget_list*
ConstTarget_list(tTarget _tTarget_1, tTarget_list _tTarget_list_1) {
    assertPhylum(_tTarget_1, phylum_tTarget);
    assertPhylum(_tTarget_list_1, phylum_tTarget_list);
    tTarget_list kc_x = new impl_tTarget_list(_tTarget_1, _tTarget_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ConstTarget_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ConstTarget_list));
    kc_x->post_create();
    kc_x = kc_initialize_tTarget_list(kc_x);
    return static_cast<impl_tTarget_list*>(kc_x);
}

impl_tTarget_Target*
Target() {
    tTarget kc_x = new impl_tTarget_Target();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Target));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Target));
    kc_x->post_create();
    return static_cast<impl_tTarget_Target*>(kc_x);
}

impl_tSource_list*
NiltSource_list() {
    tSource_list kc_x = new impl_tSource_list();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_NiltSource_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_NiltSource_list));
    kc_x->post_create();
    kc_x = kc_initialize_tSource_list(kc_x);
    return static_cast<impl_tSource_list*>(kc_x);
}

impl_tSource_list*
ConstSource_list(tSource _tSource_1, tSource_list _tSource_list_1) {
    assertPhylum(_tSource_1, phylum_tSource);
    assertPhylum(_tSource_list_1, phylum_tSource_list);
    tSource_list kc_x = new impl_tSource_list(_tSource_1, _tSource_list_1);
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_ConstSource_list));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_ConstSource_list));
    kc_x->post_create();
    kc_x = kc_initialize_tSource_list(kc_x);
    return static_cast<impl_tSource_list*>(kc_x);
}

impl_tSource_Source*
Source() {
    tSource kc_x = new impl_tSource_Source();
    KC_COLLECT_STATS0(KC_CREATE_STATS(sel_Source));
    KC_COLLECT_STATS0(KC_EXISTINGNOTFOUND_STATS(sel_Source));
    kc_x->post_create();
    kc_x = kc_initialize_tSource(kc_x);
    return static_cast<impl_tSource_Source*>(kc_x);
}


abstract_phylum
kc_create(enum_operators createOp, abstract_phylum kc_p1, abstract_phylum kc_p2, abstract_phylum kc_p3, abstract_phylum kc_p4, abstract_phylum kc_p5, abstract_phylum kc_p6, abstract_phylum kc_p7, abstract_phylum kc_p8, abstract_phylum kc_p9)
{
    switch(createOp) {
    case sel__VoidPtr:
    case sel__Int:
    case sel__Real:
    case sel__Str:
    case sel_NoCaseStr:
	assertionFailed("Cannot create this kind of phylum - predefined phyla must be handled seperately");break;
    case sel_Source:
	return Source();
    case sel_ConstSource_list:
	return ConstSource_list(phylum_cast<tSource>(kc_p1), phylum_cast<tSource_list>(kc_p2));
    case sel_NiltSource_list:
	return NiltSource_list();
    case sel_Target:
	return Target();
    case sel_ConstTarget_list:
	return ConstTarget_list(phylum_cast<tTarget>(kc_p1), phylum_cast<tTarget_list>(kc_p2));
    case sel_NiltTarget_list:
	return NiltTarget_list();
    case sel_StandardElements:
	return StandardElements(phylum_cast<tTarget_list>(kc_p1), phylum_cast<tSource_list>(kc_p2));
    case sel_Scope:
	return Scope(phylum_cast<standardElements>(kc_p1), phylum_cast<tVariable_list>(kc_p2), phylum_cast<tFaultHandlers>(kc_p3), phylum_cast<tCompensationHandler>(kc_p4), phylum_cast<tEventHandlers>(kc_p5), phylum_cast<tStop>(kc_p6), phylum_cast<activity>(kc_p7));
    case sel_Pick:
	return Pick(phylum_cast<standardElements>(kc_p1), phylum_cast<tOnMessage_list>(kc_p2), phylum_cast<tOnAlarm_list>(kc_p3));
    case sel_Sequence:
	return Sequence(phylum_cast<standardElements>(kc_p1), phylum_cast<activity_list>(kc_p2));
    case sel_While:
	return While(phylum_cast<standardElements>(kc_p1), phylum_cast<activity>(kc_p2));
    case sel_Otherwise:
	return Otherwise(phylum_cast<activity>(kc_p1));
    case sel_Case:
	return Case(phylum_cast<activity>(kc_p1));
    case sel_ConstCase_list:
	return ConstCase_list(phylum_cast<tCase>(kc_p1), phylum_cast<tCase_list>(kc_p2));
    case sel_NiltCase_list:
	return NiltCase_list();
    case sel_Switch:
	return Switch(phylum_cast<standardElements>(kc_p1), phylum_cast<tCase_list>(kc_p2), phylum_cast<tOtherwise>(kc_p3));
    case sel_Link:
	return Link();
    case sel_ConstLink_list:
	return ConstLink_list(phylum_cast<tLink>(kc_p1), phylum_cast<tLink_list>(kc_p2));
    case sel_NiltLink_list:
	return NiltLink_list();
    case sel_Consactivity_list:
	return Consactivity_list(phylum_cast<activity>(kc_p1), phylum_cast<activity_list>(kc_p2));
    case sel_Nilactivity_list:
	return Nilactivity_list();
    case sel_Flow:
	return Flow(phylum_cast<standardElements>(kc_p1), phylum_cast<tLink_list>(kc_p2), phylum_cast<activity_list>(kc_p3));
    case sel_Terminate:
	return Terminate(phylum_cast<standardElements>(kc_p1));
    case sel_Compensate:
	return Compensate(phylum_cast<standardElements>(kc_p1));
    case sel_Throw:
	return Throw(phylum_cast<standardElements>(kc_p1));
    case sel_WaitUntil:
	return WaitUntil(phylum_cast<standardElements>(kc_p1));
    case sel_WaitFor:
	return WaitFor(phylum_cast<standardElements>(kc_p1));
    case sel_To:
	return To();
    case sel_From:
	return From();
    case sel_Copy:
	return Copy(phylum_cast<tFrom>(kc_p1), phylum_cast<tTo>(kc_p2));
    case sel_ConstCopy_list:
	return ConstCopy_list(phylum_cast<tCopy>(kc_p1), phylum_cast<tCopy_list>(kc_p2));
    case sel_NiltCopy_list:
	return NiltCopy_list();
    case sel_Assign:
	return Assign(phylum_cast<standardElements>(kc_p1), phylum_cast<tCopy_list>(kc_p2));
    case sel_Reply:
	return Reply(phylum_cast<standardElements>(kc_p1), phylum_cast<tCorrelation_list>(kc_p2));
    case sel_Receive:
	return Receive(phylum_cast<standardElements>(kc_p1), phylum_cast<tCorrelation_list>(kc_p2));
    case sel_Invoke:
	return Invoke(phylum_cast<standardElements>(kc_p1), phylum_cast<tCorrelation_list>(kc_p2));
    case sel_Empty:
	return Empty(phylum_cast<standardElements>(kc_p1));
    case sel_Correlation:
	return Correlation();
    case sel_ConstCorrelation_list:
	return ConstCorrelation_list(phylum_cast<tCorrelation>(kc_p1), phylum_cast<tCorrelation_list>(kc_p2));
    case sel_NiltCorrelation_list:
	return NiltCorrelation_list();
    case sel_CorrelationSet:
	return CorrelationSet();
    case sel_ConstCorrelationSet_list:
	return ConstCorrelationSet_list(phylum_cast<tCorrelationSet>(kc_p1), phylum_cast<tCorrelationSet_list>(kc_p2));
    case sel_NiltCorrelationSet_list:
	return NiltCorrelationSet_list();
    case sel_Variable:
	return Variable();
    case sel_ConstVariable_list:
	return ConstVariable_list(phylum_cast<tVariable>(kc_p1), phylum_cast<tVariable_list>(kc_p2));
    case sel_NiltVariable_list:
	return NiltVariable_list();
    case sel_processCompensationHandler:
	return processCompensationHandler();
    case sel_userDefinedCompensationHandler:
	return userDefinedCompensationHandler(phylum_cast<activity>(kc_p1));
    case sel_implicitCompensationHandler:
	return implicitCompensationHandler();
    case sel_OnAlarm:
	return OnAlarm(phylum_cast<activity>(kc_p1));
    case sel_OnMessage:
	return OnMessage(phylum_cast<activity>(kc_p1));
    case sel_ConstOnAlarm_list:
	return ConstOnAlarm_list(phylum_cast<tOnAlarm>(kc_p1), phylum_cast<tOnAlarm_list>(kc_p2));
    case sel_NiltOnAlarm_list:
	return NiltOnAlarm_list();
    case sel_ConstOnMessage_list:
	return ConstOnMessage_list(phylum_cast<tOnMessage>(kc_p1), phylum_cast<tOnMessage_list>(kc_p2));
    case sel_NiltOnMessage_list:
	return NiltOnMessage_list();
    case sel_userDefinedEventHandler:
	return userDefinedEventHandler(phylum_cast<tOnMessage_list>(kc_p1), phylum_cast<tOnAlarm_list>(kc_p2));
    case sel_implicitEventHandler:
	return implicitEventHandler();
    case sel_NoCatchAll:
	return NoCatchAll();
    case sel_CatchAll:
	return CatchAll(phylum_cast<activity>(kc_p1));
    case sel_Catch:
	return Catch(phylum_cast<activity>(kc_p1));
    case sel_ConstCatch_list:
	return ConstCatch_list(phylum_cast<tCatch>(kc_p1), phylum_cast<tCatch_list>(kc_p2));
    case sel_NiltCatch_list:
	return NiltCatch_list();
    case sel_implicitFaultHandler:
	return implicitFaultHandler();
    case sel_userDefinedFaultHandler:
	return userDefinedFaultHandler(phylum_cast<tCatch_list>(kc_p1), phylum_cast<tCatchAll>(kc_p2));
    case sel_Partner:
	return Partner(phylum_cast<tPartnerLink_list>(kc_p1));
    case sel_ConstPartner_list:
	return ConstPartner_list(phylum_cast<tPartner>(kc_p1), phylum_cast<tPartner_list>(kc_p2));
    case sel_NiltPartner_list:
	return NiltPartner_list();
    case sel_PartnerLink:
	return PartnerLink();
    case sel_ConstPartnerLink_list:
	return ConstPartnerLink_list(phylum_cast<tPartnerLink>(kc_p1), phylum_cast<tPartnerLink_list>(kc_p2));
    case sel_NiltPartnerLink_list:
	return NiltPartnerLink_list();
    case sel_activityCompensate:
	return activityCompensate(phylum_cast<tCompensate>(kc_p1));
    case sel_activityScope:
	return activityScope(phylum_cast<tScope>(kc_p1));
    case sel_activityPick:
	return activityPick(phylum_cast<tPick>(kc_p1));
    case sel_activitySequence:
	return activitySequence(phylum_cast<tSequence>(kc_p1));
    case sel_activityWhile:
	return activityWhile(phylum_cast<tWhile>(kc_p1));
    case sel_activitySwitch:
	return activitySwitch(phylum_cast<tSwitch>(kc_p1));
    case sel_activityFlow:
	return activityFlow(phylum_cast<tFlow>(kc_p1));
    case sel_activityTerminate:
	return activityTerminate(phylum_cast<tTerminate>(kc_p1));
    case sel_activityThrow:
	return activityThrow(phylum_cast<tThrow>(kc_p1));
    case sel_activityWait:
	return activityWait(phylum_cast<tWait>(kc_p1));
    case sel_activityAssign:
	return activityAssign(phylum_cast<tAssign>(kc_p1));
    case sel_activityReply:
	return activityReply(phylum_cast<tReply>(kc_p1));
    case sel_activityReceive:
	return activityReceive(phylum_cast<tReceive>(kc_p1));
    case sel_activityInvoke:
	return activityInvoke(phylum_cast<tInvoke>(kc_p1));
    case sel_activityEmpty:
	return activityEmpty(phylum_cast<tEmpty>(kc_p1));
    case sel_StopInScope:
	return StopInScope();
    case sel_StopInProcess:
	return StopInProcess();
    case sel_Process:
	return Process(phylum_cast<tPartnerLink_list>(kc_p1), phylum_cast<tPartner_list>(kc_p2), phylum_cast<tVariable_list>(kc_p3), phylum_cast<tCorrelationSet_list>(kc_p4), phylum_cast<tFaultHandlers>(kc_p5), phylum_cast<tCompensationHandler>(kc_p6), phylum_cast<tEventHandlers>(kc_p7), phylum_cast<tStop>(kc_p8), phylum_cast<activity>(kc_p9));
    default:
	assertionFailed("Cannot create this kind of phylum - unkown operator id");
    }
    NORETURN
}

abstract_phylum&
attributeOf(abstract_phylum kc_p, int no)
{
    assertionFailed("Cannot select attribute for this kind of phylum - has no attributes");
    NORETURN
}

abstract_phylum
impl_abstract_phylum::subphylum(int) const
{
    return 0;
}

void
impl_abstract_phylum::set_subphylum(int,abstract_phylum)
{
}

void
impl_abstract_phylum::free(bool kc_rec)
{
    KC_COLLECT_STATS0(KC_FREE_CALLED_STATS(prod_sel(), kc_rec));
    if (!phylum_info[phylum()].uniq_stored) {
	if (kc_rec) {
	    abstract_phylum son;
	    for (int kc_i=0; (son = subphylum(kc_i)); kc_i++)
	    {
		if (son!=0) son->free(kc_rec);
		son=0;
	    }
	}
	KC_COLLECT_STATS0(KC_FREED_STATS(prod_sel(), kc_rec));
	delete this;
    }
}

bool
impl_abstract_phylum::eq(c_abstract_phylum kc_p2) const
{
    if (this == kc_p2)
	return true;
    if (prod_sel() != kc_p2->prod_sel())
	return false;

    int kc_st = phylum_info[phylum()].uniq_stored;
    if (kc_st && kc_storageclass_still_uniq[kc_st])
	return false;

    c_abstract_phylum son1;
    for (int kc_i=0; (son1 = subphylum(kc_i)); kc_i++) {
	if (!son1->eq(kc_p2->subphylum(kc_i)))
	    return false;
    }

    return true;
}

static string kc_indentation = "";
static const char *kc_printformat_not_nullary_open = "%s%s(\n";
static const char *kc_printformat_list_open = "%s%s\n";

static const char *kc_printformat_not_nullary_close = "%s)\n";
static const char *kc_printformat_nullary = "%s%s()\n";

void
impl_abstract_phylum::fprint(FILE*kc_f)
{
    int kc_i;

    if (!kc_f) kc_f = stdout;
    abstract_list al = dynamic_cast<abstract_list>(this);
    if (al != 0 && !al->is_nil()) {
	fprintf(kc_f, kc_printformat_list_open, kc_indentation.c_str(), op_name());
	kc_indentation+="| ";
	subphylum(0)->fprint(kc_f);
	kc_indentation=kc_indentation.substr(0, kc_indentation.length()-2);
	phylum_cast<abstract_list>(subphylum(1))->fprint_list(kc_f);
	kc_indentation=kc_indentation.substr(0, kc_indentation.length()-2);
    } else // not list
	switch(phylum()) {
	case phylum_voidptr:
	    fprintf(kc_f, "%s%p\n", kc_indentation.c_str(), static_cast<voidptr>(this)->pointer);
	    break;
	case phylum_casestring:
	case phylum_nocasestring:
	    fprintf(kc_f, "%s%s\n", kc_indentation.c_str(), static_cast<casestring>(this)->name);
	    break;
	case phylum_integer:
	    fprintf(kc_f, "%s%i\n", kc_indentation.c_str(), static_cast<integer>(this)->value);
	    break;
	case phylum_real:
	    fprintf(kc_f, "%s%f\n", kc_indentation.c_str(), static_cast<real>(this)->value);
	    break;
	default:
	    if (!subphylum(0)) {
		fprintf(kc_f, kc_printformat_nullary, kc_indentation.c_str(), op_name());
	    } else {
		fprintf(kc_f, kc_printformat_not_nullary_open, kc_indentation.c_str(), op_name());
		kc_indentation+="  ";
		abstract_phylum son;
		for (kc_i=0; (son = subphylum(kc_i)); kc_i++) {
		    son->fprint(kc_f);
		}
		kc_indentation=kc_indentation.substr(0, kc_indentation.length()-2);
		fprintf(kc_f, kc_printformat_not_nullary_close, kc_indentation.c_str());
	    }
    }
}

void 
impl_abstract_phylum::print()
{
    fprint(stdout);
}

void 
impl_abstract_list::fprint_list(FILE*kc_f)
{
    if (!kc_f)
	kc_f = stdout;
    if (this->is_nil()) {
	kc_indentation+="`-";
	fprintf(kc_f, kc_printformat_nullary, kc_indentation.c_str(), op_name());
    } else {
	kc_indentation+="|-";
	fprintf(kc_f, kc_printformat_list_open, kc_indentation.c_str(), op_name());
	kc_indentation=kc_indentation.substr(0, kc_indentation.length()-2);
	kc_indentation+="| ";
	subphylum(0)->fprint(kc_f);
	kc_indentation=kc_indentation.substr(0, kc_indentation.length()-2);
	phylum_cast<abstract_list>(subphylum(1))->fprint_list(kc_f);
    }
}

int
impl_abstract_list::length() const
{
    int kc_length = 0;
    c_abstract_phylum kc_p = this;
    while((kc_p = kc_p->subphylum(1)))
	kc_length++;
    return kc_length;
}
void impl_abstract_list::freelist()
{
    abstract_phylum kc_p = this, kc_tmp_p;
    do {
	kc_tmp_p=kc_p->subphylum(1);
	kc_p->free(false);
	kc_p=kc_tmp_p;
    } while(kc_p);
}
abstract_phylum
impl_abstract_list::do_concat(c_abstract_phylum kc_p2, enum_operators mk) const
{
    abstract_phylum next = subphylum(1);
    if(!next)
	return const_cast<abstract_phylum>(kc_p2);
    return kc_create(mk, subphylum(0), static_cast<abstract_list>(next)->do_concat(kc_p2, mk));
}

abstract_phylum
impl_abstract_list::do_reverse(c_abstract_phylum tail, enum_operators mk) const
{
    for (impl_abstract_list const* iterator_ = this; iterator_->subphylum(1) != 0;
	iterator_ = static_cast<impl_abstract_list const*>(iterator_->subphylum(1)) )
    tail = kc_create(mk, iterator_->subphylum(0), const_cast<abstract_phylum>(tail));
    return const_cast<abstract_phylum>(tail);
}

abstract_phylum
impl_abstract_list::last() const
{
    c_abstract_phylum kc_p = this, next = subphylum(1), nextnext;
#ifdef _AFX
    ASSERT(next);
    if(!next)
	return NULL;
#else
    if(!next){
	fflush(stdout);
	fprintf(stderr, "Internal Error: list::last was called with argument Nil%s\n", phylum_name());
	exit(1);
    }
#endif
    while ((nextnext = next->subphylum(1))) {
	kc_p = next;
	next = nextnext;
    }
    return const_cast<abstract_phylum>(kc_p->subphylum(0));/* XXX remove cast */
}

abstract_phylum
impl_abstract_list::do_map(abstract_phylum (*kc_fp)(abstract_phylum), enum_operators mk)
{
    abstract_phylum el = subphylum(0);
    if (!el)
	return this;
    abstract_list next = static_cast<abstract_list>(subphylum(1));
    return kc_create(mk, kc_fp(el), next->do_map(kc_fp, mk));
}

abstract_phylum
impl_abstract_list::do_filter(bool (*kc_fp)(abstract_phylum), enum_operators mk)
{
    abstract_phylum el = subphylum(0);
    if (!el)
	return this;
    abstract_list next = static_cast<abstract_list>(subphylum(1));
    if ((*kc_fp)(el)) {
	return kc_create(mk, el, next->do_filter(kc_fp, mk));
    } else {
	return next->do_filter(kc_fp, mk);
    }
}

abstract_list
impl_abstract_list::do_append(abstract_phylum new_last, abstract_list eol)
{
    abstract_list next = this;
    while (!next->is_nil())
	next = phylum_cast<abstract_list>(next->subphylum(1));
    next->set_subphylum(0, new_last);
    next->set_subphylum(1, eol);
    return next;
}

abstract_phylum
impl_abstract_list::do_merge(abstract_list second,abstract_phylum(*kc_fp)(abstract_phylum,abstract_phylum), enum_operators mk)
{
    abstract_phylum el = subphylum(0);
    if (!el)
	return this;
    abstract_phylum el2 = second->subphylum(0);
    if (!el2)
	return el2;
    abstract_list next = static_cast<abstract_list>(subphylum(1));
    abstract_list next2 = static_cast<abstract_list>(second->subphylum(1));
    return kc_create(mk, kc_fp(el,el2), next->do_merge(next2, kc_fp, mk));
}

abstract_phylum
impl_abstract_list::do_reduce(abstract_phylum neutral, abstract_phylum(*kc_fp)(abstract_phylum,abstract_phylum)) {
    abstract_phylum el = subphylum(0);
    if (!el)
	return neutral;
    abstract_list next = static_cast<abstract_list>(subphylum(1));
    return kc_fp(el,next->do_reduce(neutral,kc_fp));
}


extern const char* kc_storageclassnames[];

#ifdef KC_STATISTICS
void do_print_operator_statistics(FILE * kc_f)
{
    unsigned int kc_i;
    assertNonNull( kc_f );
    fprintf(kc_f, "%-*s| %-*s| %-*s| %-*s| %-*s| %-*s| %-*s| %-*s| %-*s| %-*s\n", 38 , "Operator", 3, "Sz", 8, "#oper", 8, "#new", 8, "#exist", 8, "#frnrec", 8, "#frrec", 8, "#freed", 8, "#rem", 9, "total (bytes)");
    fprintf(kc_f, "%-*s|%*s |%*d |%*d |%*d |%*d |%*d |%*d |%*d |%*d\n", 38, "case sensitive strings", 3, "-", 8, operator_statistics[sel__Str].created, 8, operator_statistics[sel__Str].existing_not_found, 8, operator_statistics[sel__Str].created-operator_statistics[sel__Str].existing_not_found, 8, 0, 8, 0, 8, 0, 8, 0, 9, kc_casestring_strlen);
    fprintf(kc_f, "%-*s|%*s |%*d |%*d |%*d |%*d |%*d |%*d |%*d |%*d\n", 38, "case insensitive strings", 3, "-", 8, operator_statistics[sel_NoCaseStr].created, 8, operator_statistics[sel_NoCaseStr].existing_not_found, 8, operator_statistics[sel_NoCaseStr].created-operator_statistics[sel_NoCaseStr].existing_not_found, 8, 0, 8, 0, 8, 0, 8, 0, 9, kc_nocasestring_strlen);
    for (kc_i = one_before_first_operator+1; kc_i < last_operator; kc_i++) {
	fprintf(kc_f, "%-*s|%*d |%*d |%*d |%*d |%*d |%*d |%*d |%*d |%*d\n", 38, operator_info[kc_i].name, 3, operator_info[kc_i].size, 8, operator_statistics[kc_i].created, 8, operator_statistics[kc_i].existing_not_found, 8, operator_statistics[kc_i].created-operator_statistics[kc_i].existing_not_found, 8, operator_statistics[kc_i].free_called[false], 8, operator_statistics[kc_i].free_called[true], 8, operator_statistics[kc_i].freed[false]+operator_statistics[kc_i].freed[true], 8, operator_statistics[kc_i].existing_not_found-(operator_statistics[kc_i].freed[false]+operator_statistics[kc_i].freed[true]), 9, operator_info[kc_i].size*(operator_statistics[kc_i].existing_not_found-(operator_statistics[kc_i].freed[false]+operator_statistics[kc_i].freed[true])));
    }
}
#endif // KC_STATISTICS


void
ht_static(kc_storageclass_t kc_a_storageclass_t)
{
    hashtables[kc_a_storageclass_t]->ht_static();
}

void
ht_dynamic(kc_storageclass_t kc_a_storageclass_t)
{
    hashtables[kc_a_storageclass_t]->ht_dynamic();
}

void
ht_inc_level(kc_storageclass_t kc_a_storageclass_t)
{
    hashtables[kc_a_storageclass_t]->ht_inc_level();
}

void
ht_dec_level(kc_storageclass_t kc_a_storageclass_t)
{
    hashtables[kc_a_storageclass_t]->ht_dec_level();
}

void
ht_free_level(kc_storageclass_t kc_a_storageclass_t)
{
    hashtables[kc_a_storageclass_t]->ht_free_level();
}

hashtable_t
ht_create_simple()
{
    hashtable_t kc_ht=new hashtable_struct_t;
    kc_ht->set_to_be_freed();
    return kc_ht;
}

hashtable_t
ht_assign(hashtable_t kc_a_hashtable_t, kc_storageclass_t kc_a_storageclass_t, bool still_unique)
{
    hashtable_t kc_tmp = hashtables[kc_a_storageclass_t];
    hashtables[kc_a_storageclass_t] = kc_a_hashtable_t;
    kc_storageclass_still_uniq[kc_a_storageclass_t] = still_unique;
    return kc_tmp;
}

hashtable_t
ht_assigned(kc_storageclass_t kc_a_storageclass_t)
{
    return hashtables[kc_a_storageclass_t];
}

void
ht_clear(hashtable_t kc_a_hashtable_t)
{
    kc_a_hashtable_t->ht_clear();
}

void
ht_delete(hashtable_t kc_a_hashtable_t)
{
    if(kc_a_hashtable_t->to_be_freed())
	delete kc_a_hashtable_t;
}
const char*
phylumname_or_error(enum_phyla kc_phy)
{
    if ((kc_phy <= one_before_first_phylum) || (kc_phy >= last_phylum)) {
	char *kc_strof_error;
	sprintf((kc_strof_error=new char[69]), "Internal Error: unknown phylum number: %d", kc_phy);
	return kc_strof_error;
    } else {
	return phylum_info[kc_phy].name;
    }   }


const char*
kc_operatorname_or_error(enum_operators kc_operator)
{
    if ((kc_operator <= one_before_first_operator) || (kc_operator >= last_operator)) {
	char *kc_strof_error;
	sprintf((kc_strof_error=new char[71]), "Internal Error: unknown operator number: %d", kc_operator);
	return kc_strof_error;
    } else {
	return operator_info[kc_operator].name;
    }   }

tPartnerLink_list
concat(c_tPartnerLink_list kc_p1, c_tPartnerLink_list kc_p2)
{ return dynamic_cast<tPartnerLink_list>(kc_p1->do_concat(kc_p2, sel_ConstPartnerLink_list)); }

tPartnerLink_list
impl_tPartnerLink_list::reverse() const
{ return dynamic_cast<tPartnerLink_list>(do_reverse(NiltPartnerLink_list(), sel_ConstPartnerLink_list)); }

tPartnerLink
impl_tPartnerLink_list::last() const
{ return dynamic_cast<tPartnerLink>(impl_abstract_list::last()); }

bool
impl_tPartnerLink_list::is_nil() const
{
    return tPartnerLink_1==0 && tPartnerLink_list_1==0;
}

tPartnerLink_list
impl_tPartnerLink_list::map(tPartnerLink (*kc_fp)(tPartnerLink))
{ return dynamic_cast<tPartnerLink_list>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_ConstPartnerLink_list)); }
tPartnerLink_list
impl_tPartnerLink_list::filter(bool (*kc_fp)(tPartnerLink))
{ return dynamic_cast<tPartnerLink_list>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_ConstPartnerLink_list)); }

tPartnerLink_list
impl_tPartnerLink_list::append(tPartnerLink new_last)
{
    return dynamic_cast<tPartnerLink_list>(do_append(new_last, NiltPartnerLink_list()));
}
tPartnerLink_list
impl_tPartnerLink_list::merge( tPartnerLink_list second, tPartnerLink (*kc_fp)(tPartnerLink, tPartnerLink))
{
    return dynamic_cast<tPartnerLink_list>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_ConstPartnerLink_list));
}
tPartnerLink
impl_tPartnerLink_list::reduce( tPartnerLink neutral, tPartnerLink (*kc_fp)(tPartnerLink, tPartnerLink))
{
    return dynamic_cast<tPartnerLink>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

tPartner_list
concat(c_tPartner_list kc_p1, c_tPartner_list kc_p2)
{ return dynamic_cast<tPartner_list>(kc_p1->do_concat(kc_p2, sel_ConstPartner_list)); }

tPartner_list
impl_tPartner_list::reverse() const
{ return dynamic_cast<tPartner_list>(do_reverse(NiltPartner_list(), sel_ConstPartner_list)); }

tPartner
impl_tPartner_list::last() const
{ return dynamic_cast<tPartner>(impl_abstract_list::last()); }

bool
impl_tPartner_list::is_nil() const
{
    return tPartner_1==0 && tPartner_list_1==0;
}

tPartner_list
impl_tPartner_list::map(tPartner (*kc_fp)(tPartner))
{ return dynamic_cast<tPartner_list>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_ConstPartner_list)); }
tPartner_list
impl_tPartner_list::filter(bool (*kc_fp)(tPartner))
{ return dynamic_cast<tPartner_list>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_ConstPartner_list)); }

tPartner_list
impl_tPartner_list::append(tPartner new_last)
{
    return dynamic_cast<tPartner_list>(do_append(new_last, NiltPartner_list()));
}
tPartner_list
impl_tPartner_list::merge( tPartner_list second, tPartner (*kc_fp)(tPartner, tPartner))
{
    return dynamic_cast<tPartner_list>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_ConstPartner_list));
}
tPartner
impl_tPartner_list::reduce( tPartner neutral, tPartner (*kc_fp)(tPartner, tPartner))
{
    return dynamic_cast<tPartner>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

tCatch_list
concat(c_tCatch_list kc_p1, c_tCatch_list kc_p2)
{ return dynamic_cast<tCatch_list>(kc_p1->do_concat(kc_p2, sel_ConstCatch_list)); }

tCatch_list
impl_tCatch_list::reverse() const
{ return dynamic_cast<tCatch_list>(do_reverse(NiltCatch_list(), sel_ConstCatch_list)); }

tCatch
impl_tCatch_list::last() const
{ return dynamic_cast<tCatch>(impl_abstract_list::last()); }

bool
impl_tCatch_list::is_nil() const
{
    return tCatch_1==0 && tCatch_list_1==0;
}

tCatch_list
impl_tCatch_list::map(tCatch (*kc_fp)(tCatch))
{ return dynamic_cast<tCatch_list>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_ConstCatch_list)); }
tCatch_list
impl_tCatch_list::filter(bool (*kc_fp)(tCatch))
{ return dynamic_cast<tCatch_list>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_ConstCatch_list)); }

tCatch_list
impl_tCatch_list::append(tCatch new_last)
{
    return dynamic_cast<tCatch_list>(do_append(new_last, NiltCatch_list()));
}
tCatch_list
impl_tCatch_list::merge( tCatch_list second, tCatch (*kc_fp)(tCatch, tCatch))
{
    return dynamic_cast<tCatch_list>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_ConstCatch_list));
}
tCatch
impl_tCatch_list::reduce( tCatch neutral, tCatch (*kc_fp)(tCatch, tCatch))
{
    return dynamic_cast<tCatch>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

tOnMessage_list
concat(c_tOnMessage_list kc_p1, c_tOnMessage_list kc_p2)
{ return dynamic_cast<tOnMessage_list>(kc_p1->do_concat(kc_p2, sel_ConstOnMessage_list)); }

tOnMessage_list
impl_tOnMessage_list::reverse() const
{ return dynamic_cast<tOnMessage_list>(do_reverse(NiltOnMessage_list(), sel_ConstOnMessage_list)); }

tOnMessage
impl_tOnMessage_list::last() const
{ return dynamic_cast<tOnMessage>(impl_abstract_list::last()); }

bool
impl_tOnMessage_list::is_nil() const
{
    return tOnMessage_1==0 && tOnMessage_list_1==0;
}

tOnMessage_list
impl_tOnMessage_list::map(tOnMessage (*kc_fp)(tOnMessage))
{ return dynamic_cast<tOnMessage_list>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_ConstOnMessage_list)); }
tOnMessage_list
impl_tOnMessage_list::filter(bool (*kc_fp)(tOnMessage))
{ return dynamic_cast<tOnMessage_list>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_ConstOnMessage_list)); }

tOnMessage_list
impl_tOnMessage_list::append(tOnMessage new_last)
{
    return dynamic_cast<tOnMessage_list>(do_append(new_last, NiltOnMessage_list()));
}
tOnMessage_list
impl_tOnMessage_list::merge( tOnMessage_list second, tOnMessage (*kc_fp)(tOnMessage, tOnMessage))
{
    return dynamic_cast<tOnMessage_list>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_ConstOnMessage_list));
}
tOnMessage
impl_tOnMessage_list::reduce( tOnMessage neutral, tOnMessage (*kc_fp)(tOnMessage, tOnMessage))
{
    return dynamic_cast<tOnMessage>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

tOnAlarm_list
concat(c_tOnAlarm_list kc_p1, c_tOnAlarm_list kc_p2)
{ return dynamic_cast<tOnAlarm_list>(kc_p1->do_concat(kc_p2, sel_ConstOnAlarm_list)); }

tOnAlarm_list
impl_tOnAlarm_list::reverse() const
{ return dynamic_cast<tOnAlarm_list>(do_reverse(NiltOnAlarm_list(), sel_ConstOnAlarm_list)); }

tOnAlarm
impl_tOnAlarm_list::last() const
{ return dynamic_cast<tOnAlarm>(impl_abstract_list::last()); }

bool
impl_tOnAlarm_list::is_nil() const
{
    return tOnAlarm_1==0 && tOnAlarm_list_1==0;
}

tOnAlarm_list
impl_tOnAlarm_list::map(tOnAlarm (*kc_fp)(tOnAlarm))
{ return dynamic_cast<tOnAlarm_list>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_ConstOnAlarm_list)); }
tOnAlarm_list
impl_tOnAlarm_list::filter(bool (*kc_fp)(tOnAlarm))
{ return dynamic_cast<tOnAlarm_list>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_ConstOnAlarm_list)); }

tOnAlarm_list
impl_tOnAlarm_list::append(tOnAlarm new_last)
{
    return dynamic_cast<tOnAlarm_list>(do_append(new_last, NiltOnAlarm_list()));
}
tOnAlarm_list
impl_tOnAlarm_list::merge( tOnAlarm_list second, tOnAlarm (*kc_fp)(tOnAlarm, tOnAlarm))
{
    return dynamic_cast<tOnAlarm_list>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_ConstOnAlarm_list));
}
tOnAlarm
impl_tOnAlarm_list::reduce( tOnAlarm neutral, tOnAlarm (*kc_fp)(tOnAlarm, tOnAlarm))
{
    return dynamic_cast<tOnAlarm>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

tVariable_list
concat(c_tVariable_list kc_p1, c_tVariable_list kc_p2)
{ return dynamic_cast<tVariable_list>(kc_p1->do_concat(kc_p2, sel_ConstVariable_list)); }

tVariable_list
impl_tVariable_list::reverse() const
{ return dynamic_cast<tVariable_list>(do_reverse(NiltVariable_list(), sel_ConstVariable_list)); }

tVariable
impl_tVariable_list::last() const
{ return dynamic_cast<tVariable>(impl_abstract_list::last()); }

bool
impl_tVariable_list::is_nil() const
{
    return tVariable_1==0 && tVariable_list_1==0;
}

tVariable_list
impl_tVariable_list::map(tVariable (*kc_fp)(tVariable))
{ return dynamic_cast<tVariable_list>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_ConstVariable_list)); }
tVariable_list
impl_tVariable_list::filter(bool (*kc_fp)(tVariable))
{ return dynamic_cast<tVariable_list>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_ConstVariable_list)); }

tVariable_list
impl_tVariable_list::append(tVariable new_last)
{
    return dynamic_cast<tVariable_list>(do_append(new_last, NiltVariable_list()));
}
tVariable_list
impl_tVariable_list::merge( tVariable_list second, tVariable (*kc_fp)(tVariable, tVariable))
{
    return dynamic_cast<tVariable_list>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_ConstVariable_list));
}
tVariable
impl_tVariable_list::reduce( tVariable neutral, tVariable (*kc_fp)(tVariable, tVariable))
{
    return dynamic_cast<tVariable>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

tCorrelationSet_list
concat(c_tCorrelationSet_list kc_p1, c_tCorrelationSet_list kc_p2)
{ return dynamic_cast<tCorrelationSet_list>(kc_p1->do_concat(kc_p2, sel_ConstCorrelationSet_list)); }

tCorrelationSet_list
impl_tCorrelationSet_list::reverse() const
{ return dynamic_cast<tCorrelationSet_list>(do_reverse(NiltCorrelationSet_list(), sel_ConstCorrelationSet_list)); }

tCorrelationSet
impl_tCorrelationSet_list::last() const
{ return dynamic_cast<tCorrelationSet>(impl_abstract_list::last()); }

bool
impl_tCorrelationSet_list::is_nil() const
{
    return tCorrelationSet_1==0 && tCorrelationSet_list_1==0;
}

tCorrelationSet_list
impl_tCorrelationSet_list::map(tCorrelationSet (*kc_fp)(tCorrelationSet))
{ return dynamic_cast<tCorrelationSet_list>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_ConstCorrelationSet_list)); }
tCorrelationSet_list
impl_tCorrelationSet_list::filter(bool (*kc_fp)(tCorrelationSet))
{ return dynamic_cast<tCorrelationSet_list>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_ConstCorrelationSet_list)); }

tCorrelationSet_list
impl_tCorrelationSet_list::append(tCorrelationSet new_last)
{
    return dynamic_cast<tCorrelationSet_list>(do_append(new_last, NiltCorrelationSet_list()));
}
tCorrelationSet_list
impl_tCorrelationSet_list::merge( tCorrelationSet_list second, tCorrelationSet (*kc_fp)(tCorrelationSet, tCorrelationSet))
{
    return dynamic_cast<tCorrelationSet_list>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_ConstCorrelationSet_list));
}
tCorrelationSet
impl_tCorrelationSet_list::reduce( tCorrelationSet neutral, tCorrelationSet (*kc_fp)(tCorrelationSet, tCorrelationSet))
{
    return dynamic_cast<tCorrelationSet>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

tCorrelation_list
concat(c_tCorrelation_list kc_p1, c_tCorrelation_list kc_p2)
{ return dynamic_cast<tCorrelation_list>(kc_p1->do_concat(kc_p2, sel_ConstCorrelation_list)); }

tCorrelation_list
impl_tCorrelation_list::reverse() const
{ return dynamic_cast<tCorrelation_list>(do_reverse(NiltCorrelation_list(), sel_ConstCorrelation_list)); }

tCorrelation
impl_tCorrelation_list::last() const
{ return dynamic_cast<tCorrelation>(impl_abstract_list::last()); }

bool
impl_tCorrelation_list::is_nil() const
{
    return tCorrelation_1==0 && tCorrelation_list_1==0;
}

tCorrelation_list
impl_tCorrelation_list::map(tCorrelation (*kc_fp)(tCorrelation))
{ return dynamic_cast<tCorrelation_list>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_ConstCorrelation_list)); }
tCorrelation_list
impl_tCorrelation_list::filter(bool (*kc_fp)(tCorrelation))
{ return dynamic_cast<tCorrelation_list>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_ConstCorrelation_list)); }

tCorrelation_list
impl_tCorrelation_list::append(tCorrelation new_last)
{
    return dynamic_cast<tCorrelation_list>(do_append(new_last, NiltCorrelation_list()));
}
tCorrelation_list
impl_tCorrelation_list::merge( tCorrelation_list second, tCorrelation (*kc_fp)(tCorrelation, tCorrelation))
{
    return dynamic_cast<tCorrelation_list>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_ConstCorrelation_list));
}
tCorrelation
impl_tCorrelation_list::reduce( tCorrelation neutral, tCorrelation (*kc_fp)(tCorrelation, tCorrelation))
{
    return dynamic_cast<tCorrelation>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

tCopy_list
concat(c_tCopy_list kc_p1, c_tCopy_list kc_p2)
{ return dynamic_cast<tCopy_list>(kc_p1->do_concat(kc_p2, sel_ConstCopy_list)); }

tCopy_list
impl_tCopy_list::reverse() const
{ return dynamic_cast<tCopy_list>(do_reverse(NiltCopy_list(), sel_ConstCopy_list)); }

tCopy
impl_tCopy_list::last() const
{ return dynamic_cast<tCopy>(impl_abstract_list::last()); }

bool
impl_tCopy_list::is_nil() const
{
    return tCopy_1==0 && tCopy_list_1==0;
}

tCopy_list
impl_tCopy_list::map(tCopy (*kc_fp)(tCopy))
{ return dynamic_cast<tCopy_list>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_ConstCopy_list)); }
tCopy_list
impl_tCopy_list::filter(bool (*kc_fp)(tCopy))
{ return dynamic_cast<tCopy_list>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_ConstCopy_list)); }

tCopy_list
impl_tCopy_list::append(tCopy new_last)
{
    return dynamic_cast<tCopy_list>(do_append(new_last, NiltCopy_list()));
}
tCopy_list
impl_tCopy_list::merge( tCopy_list second, tCopy (*kc_fp)(tCopy, tCopy))
{
    return dynamic_cast<tCopy_list>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_ConstCopy_list));
}
tCopy
impl_tCopy_list::reduce( tCopy neutral, tCopy (*kc_fp)(tCopy, tCopy))
{
    return dynamic_cast<tCopy>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

activity_list
concat(c_activity_list kc_p1, c_activity_list kc_p2)
{ return dynamic_cast<activity_list>(kc_p1->do_concat(kc_p2, sel_Consactivity_list)); }

activity_list
impl_activity_list::reverse() const
{ return dynamic_cast<activity_list>(do_reverse(Nilactivity_list(), sel_Consactivity_list)); }

activity
impl_activity_list::last() const
{ return dynamic_cast<activity>(impl_abstract_list::last()); }

bool
impl_activity_list::is_nil() const
{
    return activity_1==0 && activity_list_1==0;
}

activity_list
impl_activity_list::map(activity (*kc_fp)(activity))
{ return dynamic_cast<activity_list>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_Consactivity_list)); }
activity_list
impl_activity_list::filter(bool (*kc_fp)(activity))
{ return dynamic_cast<activity_list>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_Consactivity_list)); }

activity_list
impl_activity_list::append(activity new_last)
{
    return dynamic_cast<activity_list>(do_append(new_last, Nilactivity_list()));
}
activity_list
impl_activity_list::merge( activity_list second, activity (*kc_fp)(activity, activity))
{
    return dynamic_cast<activity_list>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_Consactivity_list));
}
activity
impl_activity_list::reduce( activity neutral, activity (*kc_fp)(activity, activity))
{
    return dynamic_cast<activity>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

tLink_list
concat(c_tLink_list kc_p1, c_tLink_list kc_p2)
{ return dynamic_cast<tLink_list>(kc_p1->do_concat(kc_p2, sel_ConstLink_list)); }

tLink_list
impl_tLink_list::reverse() const
{ return dynamic_cast<tLink_list>(do_reverse(NiltLink_list(), sel_ConstLink_list)); }

tLink
impl_tLink_list::last() const
{ return dynamic_cast<tLink>(impl_abstract_list::last()); }

bool
impl_tLink_list::is_nil() const
{
    return tLink_1==0 && tLink_list_1==0;
}

tLink_list
impl_tLink_list::map(tLink (*kc_fp)(tLink))
{ return dynamic_cast<tLink_list>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_ConstLink_list)); }
tLink_list
impl_tLink_list::filter(bool (*kc_fp)(tLink))
{ return dynamic_cast<tLink_list>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_ConstLink_list)); }

tLink_list
impl_tLink_list::append(tLink new_last)
{
    return dynamic_cast<tLink_list>(do_append(new_last, NiltLink_list()));
}
tLink_list
impl_tLink_list::merge( tLink_list second, tLink (*kc_fp)(tLink, tLink))
{
    return dynamic_cast<tLink_list>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_ConstLink_list));
}
tLink
impl_tLink_list::reduce( tLink neutral, tLink (*kc_fp)(tLink, tLink))
{
    return dynamic_cast<tLink>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

tCase_list
concat(c_tCase_list kc_p1, c_tCase_list kc_p2)
{ return dynamic_cast<tCase_list>(kc_p1->do_concat(kc_p2, sel_ConstCase_list)); }

tCase_list
impl_tCase_list::reverse() const
{ return dynamic_cast<tCase_list>(do_reverse(NiltCase_list(), sel_ConstCase_list)); }

tCase
impl_tCase_list::last() const
{ return dynamic_cast<tCase>(impl_abstract_list::last()); }

bool
impl_tCase_list::is_nil() const
{
    return tCase_1==0 && tCase_list_1==0;
}

tCase_list
impl_tCase_list::map(tCase (*kc_fp)(tCase))
{ return dynamic_cast<tCase_list>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_ConstCase_list)); }
tCase_list
impl_tCase_list::filter(bool (*kc_fp)(tCase))
{ return dynamic_cast<tCase_list>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_ConstCase_list)); }

tCase_list
impl_tCase_list::append(tCase new_last)
{
    return dynamic_cast<tCase_list>(do_append(new_last, NiltCase_list()));
}
tCase_list
impl_tCase_list::merge( tCase_list second, tCase (*kc_fp)(tCase, tCase))
{
    return dynamic_cast<tCase_list>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_ConstCase_list));
}
tCase
impl_tCase_list::reduce( tCase neutral, tCase (*kc_fp)(tCase, tCase))
{
    return dynamic_cast<tCase>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

tTarget_list
concat(c_tTarget_list kc_p1, c_tTarget_list kc_p2)
{ return dynamic_cast<tTarget_list>(kc_p1->do_concat(kc_p2, sel_ConstTarget_list)); }

tTarget_list
impl_tTarget_list::reverse() const
{ return dynamic_cast<tTarget_list>(do_reverse(NiltTarget_list(), sel_ConstTarget_list)); }

tTarget
impl_tTarget_list::last() const
{ return dynamic_cast<tTarget>(impl_abstract_list::last()); }

bool
impl_tTarget_list::is_nil() const
{
    return tTarget_1==0 && tTarget_list_1==0;
}

tTarget_list
impl_tTarget_list::map(tTarget (*kc_fp)(tTarget))
{ return dynamic_cast<tTarget_list>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_ConstTarget_list)); }
tTarget_list
impl_tTarget_list::filter(bool (*kc_fp)(tTarget))
{ return dynamic_cast<tTarget_list>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_ConstTarget_list)); }

tTarget_list
impl_tTarget_list::append(tTarget new_last)
{
    return dynamic_cast<tTarget_list>(do_append(new_last, NiltTarget_list()));
}
tTarget_list
impl_tTarget_list::merge( tTarget_list second, tTarget (*kc_fp)(tTarget, tTarget))
{
    return dynamic_cast<tTarget_list>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_ConstTarget_list));
}
tTarget
impl_tTarget_list::reduce( tTarget neutral, tTarget (*kc_fp)(tTarget, tTarget))
{
    return dynamic_cast<tTarget>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

tSource_list
concat(c_tSource_list kc_p1, c_tSource_list kc_p2)
{ return dynamic_cast<tSource_list>(kc_p1->do_concat(kc_p2, sel_ConstSource_list)); }

tSource_list
impl_tSource_list::reverse() const
{ return dynamic_cast<tSource_list>(do_reverse(NiltSource_list(), sel_ConstSource_list)); }

tSource
impl_tSource_list::last() const
{ return dynamic_cast<tSource>(impl_abstract_list::last()); }

bool
impl_tSource_list::is_nil() const
{
    return tSource_1==0 && tSource_list_1==0;
}

tSource_list
impl_tSource_list::map(tSource (*kc_fp)(tSource))
{ return dynamic_cast<tSource_list>(do_map((abstract_phylum (*)(abstract_phylum))kc_fp, sel_ConstSource_list)); }
tSource_list
impl_tSource_list::filter(bool (*kc_fp)(tSource))
{ return dynamic_cast<tSource_list>(do_filter((bool (*)(abstract_phylum))kc_fp, sel_ConstSource_list)); }

tSource_list
impl_tSource_list::append(tSource new_last)
{
    return dynamic_cast<tSource_list>(do_append(new_last, NiltSource_list()));
}
tSource_list
impl_tSource_list::merge( tSource_list second, tSource (*kc_fp)(tSource, tSource))
{
    return dynamic_cast<tSource_list>(do_merge(second,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp, sel_ConstSource_list));
}
tSource
impl_tSource_list::reduce( tSource neutral, tSource (*kc_fp)(tSource, tSource))
{
    return dynamic_cast<tSource>(do_reduce(neutral,(abstract_phylum(*)(abstract_phylum,abstract_phylum))kc_fp));
}

abstract_phylum
impl_abstract_phylum::copy(bool kc_copy_attributes) const
{
    enum_phyla kc_phy = phylum(); // XXX - implement special cases in subclasses - MvL
    KC_OPERATOR_INFO *kc_op_info = &operator_info[prod_sel()];
    kc_storageclass_t kc_st = phylum_info[kc_op_info->phylum].uniq_stored;
    if (kc_st && kc_storageclass_still_uniq[kc_st])
	return const_cast<abstract_phylum>(this);
    abstract_phylum kc_answer=0;
    if (kc_phy == phylum_casestring) {
	kc_answer=mkcasestring((dynamic_cast<c_casestring>(this))->name);
    } else if (kc_phy == phylum_nocasestring) {
	kc_answer=mknocasestring((dynamic_cast<c_nocasestring>(this))->name);
    } else if (kc_phy == phylum_voidptr) {
	kc_answer=mkvoidptr((dynamic_cast<c_voidptr>(this))->pointer);
    } else if (kc_phy == phylum_integer) {
	kc_answer=mkinteger((dynamic_cast<c_integer>(this))->value);
    } else if (kc_phy == phylum_real) {
	kc_answer=mkreal((dynamic_cast<c_real>(this))->value);
    } else {
	abstract_phylum kc_subtmp[9], child;
	for (int kc_i = 0; (child = subphylum(kc_i)); kc_i++) {
	    kc_subtmp[kc_i] = child->copy(kc_copy_attributes);
	}
	switch(kc_op_info->no_sons) {
	    case 0: kc_answer = kc_create(prod_sel()); break;
	    case 1: kc_answer = kc_create(prod_sel(), kc_subtmp[0]); break;
	    case 2: kc_answer = kc_create(prod_sel(), kc_subtmp[0], kc_subtmp[1]); break;
	    case 3: kc_answer = kc_create(prod_sel(), kc_subtmp[0], kc_subtmp[1], kc_subtmp[2]); break;
	    case 7: kc_answer = kc_create(prod_sel(), kc_subtmp[0], kc_subtmp[1], kc_subtmp[2], kc_subtmp[3], kc_subtmp[4], kc_subtmp[5], kc_subtmp[6]); break;
	    case 9: kc_answer = kc_create(prod_sel(), kc_subtmp[0], kc_subtmp[1], kc_subtmp[2], kc_subtmp[3], kc_subtmp[4], kc_subtmp[5], kc_subtmp[6], kc_subtmp[7], kc_subtmp[8]); break;
	    default: assertionFailed("unexpected number of sub-phyla");
	}
    }
    if (kc_copy_attributes)
	copy_attributes(kc_phy, this, kc_answer);
    return kc_answer;
}


} // namespace kc
