.\" Copyright (c) 1993, 1994  X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included in
.\" all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
.\" WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF
.\" OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
.\" SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall not
.\" be used in advertising or otherwise to promote the sale, use or other
.\" dealing in this Software without prior written authorization from the
.\" X Consortium.
.\"
.ds tk X Toolkit
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xI Intrinsics
.ds xW X Toolkit Athena Widgets \- C Language Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.ds Rn 3
.ds Vn 2.2
.hw XtApp-Set-Fallback-Resources wid-get
.na
.TH XtAppSetFallbackResources __libmansuffix__ __xorgversion__ "XT FUNCTIONS"
.SH NAME
XtAppSetFallbackResources \- set fallback resources
.SH SYNTAX
#include <X11/Intrinsic.h>
.HP
void XtAppSetFallbackResources(XtAppContext \fIapp_context\fP, String*
\fIspecification_list\fP);
.SH ARGUMENTS
.IP \fIapp_context\fP 1i
Specifies the application context.
.IP \fIspecification_list\fP 1i
Specifies a NULL-terminated list of resource specifications to pre-load
the database, or NULL.
.SH DESCRIPTION
Each entry in \fIspecification_list\fP points to a string in the format
.BR XrmPutLineResource .
following a call to
.BR XtAppSetFallbackResources ,
when a resource database is being created for a particular screen and
the Intrinsics are not able to find or read an application-specific
class resource file and if \fIspecification_list\fP is not NULL the
resource specification in \fIspecification_list\fP will be merged
into the screen resource database in place of the application-specific
class resource file.
.B XtAppSetFallbackResources
is not required to copy \fIspecification_list\fP; the caller must
ensure that the contents of the list and the strings addressed by the
list remain valid until all displays are initialized or until
.B XtAppSetFallbackResources
is called again.
The value NULL for \fIspecification_list\fP removes
any previous fallback resource specification for the application context.
The intended use for fallback resources is to provide a minimal number
of resources that will make the application usable (or at least terminate
with helpful diagnostic messages) when some problem exists in finding
and loading the application defaults file.
.SH "SEE ALSO"
.br
\fI\*(xT\fP
.br
\fI\*(xL\fP
