/*
 * Decompiled with CFR 0.152.
 */
package org.libreoffice.report.pentaho;

import java.io.IOException;
import org.libreoffice.report.OutputRepository;

public class DefaultNameGenerator {
    private final OutputRepository outputRepository;

    public DefaultNameGenerator(OutputRepository outputRepository) {
        if (outputRepository == null) {
            throw new NullPointerException();
        }
        this.outputRepository = outputRepository;
    }

    public String generateName(String string, String string2) throws IOException {
        return this.generateName(string, string2, true);
    }

    public String generateStorageName(String string, String string2) throws IOException {
        return this.generateName(string, string2, false);
    }

    private String generateName(String string, String string2, boolean bl) throws IOException {
        String string3;
        String string4 = string != null ? string : "file";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string4);
        if (string2 != null) {
            string3 = this.getSuffixForType(string2);
            stringBuffer.append('.');
            stringBuffer.append(string3);
        } else {
            string3 = null;
        }
        String string5 = stringBuffer.toString();
        boolean bl2 = bl ? this.outputRepository.exists(string5) : this.outputRepository.existsStorage(string5);
        if (bl2) {
            int n = 0;
            while (bl2) {
                if (n < 0) {
                    throw new IOException();
                }
                stringBuffer.delete(0, stringBuffer.length());
                stringBuffer.append(string4);
                stringBuffer.append(n);
                if (string3 != null) {
                    stringBuffer.append('.');
                    stringBuffer.append(string3);
                }
                string5 = stringBuffer.toString();
                bl2 = bl ? this.outputRepository.exists(string5) : this.outputRepository.existsStorage(string5);
                ++n;
            }
        }
        return string5;
    }

    private String getSuffixForType(String string) {
        if ("image/png".equals(string)) {
            return "png";
        }
        if ("image/jpeg".equals(string)) {
            return "jpg";
        }
        if ("image/gif".equals(string)) {
            return "gif";
        }
        return "dat";
    }
}

