/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.spider.parser;

import java.io.ByteArrayInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.htmlparser.jericho.Source;
import org.apache.logging.log4j.LogManager;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpStatusCode;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.zaproxy.zap.spider.SpiderParam;
import org.zaproxy.zap.spider.parser.SpiderParser;
import org.zaproxy.zap.utils.XmlUtils;

public class SpiderSitemapXMLParser
extends SpiderParser {
    private Pattern SITEMAP_XML_FILENAME_PATTERN = Pattern.compile("/sitemap\\.xml$");
    private static final Pattern xmlPattern = Pattern.compile("^<\\?xml\\s+version\\s*=\\s*\"[0-9.]+\"\\s+encoding\\s*=\\s*\"[^\"]+\"\\s*\\?>");
    private SpiderParam params;
    private static DocumentBuilder dBuilder;
    private static XPathExpression xpathLocationExpression;

    public SpiderSitemapXMLParser(SpiderParam params) {
        if (params == null) {
            throw new IllegalArgumentException("Parameter params must not be null.");
        }
        this.params = params;
    }

    @Override
    public boolean parseResource(HttpMessage message, Source source, int depth) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Parsing a sitemap.xml resource...");
        }
        if (message == null || !this.params.isParseSitemapXml() || !message.getResponseHeader().isXml() || HttpStatusCode.isClientError(message.getResponseHeader().getStatusCode()) || HttpStatusCode.isServerError(message.getResponseHeader().getStatusCode())) {
            return false;
        }
        byte[] response = message.getResponseBody().getBytes();
        String baseURL = message.getRequestHeader().getURI().toString();
        Matcher xmlFormatMatcher = xmlPattern.matcher(new String(response));
        if (xmlFormatMatcher.find()) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("The format matches XML");
            }
            try {
                Document xmldoc = dBuilder.parse(new InputSource(new ByteArrayInputStream(response)));
                NodeList locationNodes = (NodeList)xpathLocationExpression.evaluate(xmldoc, XPathConstants.NODESET);
                for (int i = 0; i < locationNodes.getLength(); ++i) {
                    this.processURL(message, depth, locationNodes.item(i).getNodeValue(), baseURL);
                }
            }
            catch (Exception e) {
                this.getLogger().error("An error occurred trying to parse sitemap.xml", (Throwable)e);
                return false;
            }
            return true;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("The content of the response from '" + baseURL + "' does not match the expected content for a sitemap.xml file. Ignoring it.");
        }
        return false;
    }

    @Override
    public boolean canParseResource(HttpMessage message, String path, boolean wasAlreadyParsed) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("canParseResource called on '" + path + "'");
        }
        Matcher matcher = this.SITEMAP_XML_FILENAME_PATTERN.matcher(path);
        return matcher.find();
    }

    static {
        try {
            dBuilder = XmlUtils.newXxeDisabledDocumentBuilderFactory().newDocumentBuilder();
            XPath xpath = XPathFactory.newInstance().newXPath();
            xpathLocationExpression = xpath.compile("/urlset/url/loc/text()");
        }
        catch (ParserConfigurationException | XPathExpressionException e) {
            LogManager.getLogger(SpiderSitemapXMLParser.class).error(e);
        }
    }
}

