/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.infinispan.multimap.impl.ScoredValue;
import org.infinispan.multimap.impl.SortedSetBucket;
import org.infinispan.multimap.impl.internal.MultimapObjectWrapper;

public interface BaseSetBucket<E> {
    default public Collection<ScoredValue<E>> union(Collection<ScoredValue<E>> input, double weight, SortedSetBucket.AggregateFunction function) {
        Double existing;
        TreeSet<ScoredValue<ScoredValue<E>>> output = new TreeSet<ScoredValue<ScoredValue<E>>>();
        HashMap<MultimapObjectWrapper<E>, Double> merge = new HashMap<MultimapObjectWrapper<E>, Double>();
        if (input != null) {
            for (ScoredValue<E> element : input) {
                existing = this.getScore(element.wrappedValue());
                Double unionScore = existing == null ? element.score() : Double.valueOf(function.apply(element.score(), SetUtil.calculate(existing, weight)));
                output.add(new ScoredValue<E>(unionScore, element.wrappedValue()));
                merge.put(element.wrappedValue(), unionScore);
            }
        }
        for (ScoredValue<E> element : this.getAsSet()) {
            existing = (Double)merge.get(element.wrappedValue());
            if (existing != null) continue;
            output.add(new ScoredValue<E>(SetUtil.calculate(element.score(), weight), element.wrappedValue()));
        }
        return output;
    }

    default public Collection<ScoredValue<E>> inter(Collection<ScoredValue<E>> input, double weight, SortedSetBucket.AggregateFunction function) {
        if (input == null) {
            return this.getAsSet().stream().map(s -> new ScoredValue(SetUtil.calculate(s.score(), weight), s.wrappedValue())).toList();
        }
        TreeSet<ScoredValue<ScoredValue<E>>> output = new TreeSet<ScoredValue<ScoredValue<E>>>();
        for (ScoredValue<E> element : input) {
            Double existing = this.getScore(element.wrappedValue());
            if (existing == null) continue;
            double score = function.apply(element.score(), SetUtil.calculate(existing, weight));
            output.add(new ScoredValue<E>(score, element.wrappedValue()));
        }
        return output;
    }

    public Set<ScoredValue<E>> getAsSet();

    public List<ScoredValue<E>> getAsList();

    public Double getScore(MultimapObjectWrapper<E> var1);

    public static final class SetUtil {
        private SetUtil() {
        }

        private static double calculate(Double existing, double weight) {
            return weight == 0.0 ? 0.0 : existing * weight;
        }
    }
}

