/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import CH.ifa.draw.util.Storable;
import java.awt.Color;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Vector;

public class StorableOutput {
    private PrintWriter fStream;
    private Vector fMap;
    private int fIndent;

    public StorableOutput(OutputStream outputStream) {
        this.fStream = new PrintWriter(outputStream);
        this.fMap = new Vector();
        this.fIndent = 0;
    }

    public void writeStorable(Storable storable) {
        if (storable == null) {
            this.fStream.print("NULL");
            this.space();
            return;
        }
        if (this.mapped(storable)) {
            this.writeRef(storable);
            return;
        }
        this.incrementIndent();
        this.startNewLine();
        this.map(storable);
        this.fStream.print(storable.getClass().getName());
        this.space();
        storable.write(this);
        this.space();
        this.decrementIndent();
    }

    public void writeInt(int n) {
        this.fStream.print(n);
        this.space();
    }

    public void writeColor(Color color) {
        this.writeInt(color.getRed());
        this.writeInt(color.getGreen());
        this.writeInt(color.getBlue());
    }

    public void writeDouble(double d) {
        this.fStream.print(d);
        this.space();
    }

    public void writeBoolean(boolean bl) {
        if (bl) {
            this.fStream.print(1);
        } else {
            this.fStream.print(0);
        }
        this.space();
    }

    public void writeString(String string) {
        this.fStream.print('\"');
        block6: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': {
                    this.fStream.print('\\');
                    this.fStream.print('n');
                    continue block6;
                }
                case '\"': {
                    this.fStream.print('\\');
                    this.fStream.print('\"');
                    continue block6;
                }
                case '\\': {
                    this.fStream.print('\\');
                    this.fStream.print('\\');
                    continue block6;
                }
                case '\t': {
                    this.fStream.print('\\');
                    this.fStream.print('\t');
                    continue block6;
                }
                default: {
                    this.fStream.print(c);
                }
            }
        }
        this.fStream.print('\"');
        this.space();
    }

    public void close() {
        this.fStream.close();
    }

    private boolean mapped(Storable storable) {
        return this.fMap.contains(storable);
    }

    private void map(Storable storable) {
        if (!this.fMap.contains(storable)) {
            this.fMap.addElement(storable);
        }
    }

    private void writeRef(Storable storable) {
        int n = this.fMap.indexOf(storable);
        this.fStream.print("REF");
        this.space();
        this.fStream.print(n);
        this.space();
    }

    private void incrementIndent() {
        this.fIndent += 4;
    }

    private void decrementIndent() {
        this.fIndent -= 4;
        if (this.fIndent < 0) {
            this.fIndent = 0;
        }
    }

    private void startNewLine() {
        this.fStream.println();
        for (int i = 0; i < this.fIndent; ++i) {
            this.space();
        }
    }

    private void space() {
        this.fStream.print(' ');
    }
}

