/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.script.runtime.internal.engine;

import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.module.script.ScriptEngineFactory;
import org.openhab.core.automation.module.script.ScriptExtensionAccessor;
import org.openhab.core.model.script.engine.ScriptEngine;
import org.openhab.core.model.script.runtime.DSLScriptContextProvider;
import org.openhab.core.model.script.runtime.internal.engine.DSLScriptEngine;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@NonNullByDefault
@Component(service={ScriptEngineFactory.class})
public class DSLScriptEngineFactory
implements ScriptEngineFactory {
    private static final String SCRIPT_TYPE = "dsl";
    private final ScriptEngine scriptEngine;
    private final ScriptExtensionAccessor scriptExtensionAccessor;
    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policyOption=ReferencePolicyOption.GREEDY)
    protected @Nullable DSLScriptContextProvider contextProvider;

    @Activate
    public DSLScriptEngineFactory(@Reference ScriptEngine scriptEngine, @Reference ScriptExtensionAccessor scriptExtensionAccessor) {
        this.scriptEngine = scriptEngine;
        this.scriptExtensionAccessor = scriptExtensionAccessor;
    }

    public List<String> getScriptTypes() {
        return List.of(SCRIPT_TYPE, "application/vnd.openhab.dsl.rule");
    }

    public void scopeValues(javax.script.ScriptEngine scriptEngine, Map<String, Object> scopeValues) {
    }

    public @Nullable javax.script.ScriptEngine createScriptEngine(String scriptType) {
        return new DSLScriptEngine(this.scriptEngine, this.contextProvider, this.scriptExtensionAccessor);
    }
}

