/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.auth.totp.user;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.auth.totp.user.TOTPUser;
import org.apache.guacamole.auth.totp.usergroup.TOTPUserGroup;
import org.apache.guacamole.form.Form;
import org.apache.guacamole.net.auth.DecoratingDirectory;
import org.apache.guacamole.net.auth.DelegatingUserContext;
import org.apache.guacamole.net.auth.Directory;
import org.apache.guacamole.net.auth.User;
import org.apache.guacamole.net.auth.UserContext;
import org.apache.guacamole.net.auth.UserGroup;

public class TOTPUserContext
extends DelegatingUserContext {
    public TOTPUserContext(UserContext userContext) {
        super(userContext);
    }

    public Directory<User> getUserDirectory() throws GuacamoleException {
        return new DecoratingDirectory<User>(super.getUserDirectory()){

            protected User decorate(User object) {
                return new TOTPUser(object);
            }

            protected User undecorate(User object) {
                assert (object instanceof TOTPUser);
                return ((TOTPUser)object).getUndecorated();
            }
        };
    }

    public Directory<UserGroup> getUserGroupDirectory() throws GuacamoleException {
        return new DecoratingDirectory<UserGroup>(super.getUserGroupDirectory()){

            protected UserGroup decorate(UserGroup object) {
                return new TOTPUserGroup(object);
            }

            protected UserGroup undecorate(UserGroup object) {
                assert (object instanceof TOTPUserGroup);
                return ((TOTPUserGroup)object).getUndecorated();
            }
        };
    }

    public Collection<Form> getUserAttributes() {
        HashSet<Form> userAttrs = new HashSet<Form>(super.getUserAttributes());
        userAttrs.add(TOTPUser.TOTP_ENROLLMENT_STATUS);
        return Collections.unmodifiableCollection(userAttrs);
    }

    public Collection<Form> getUserGroupAttributes() {
        HashSet<Form> userGroupAttrs = new HashSet<Form>(super.getUserGroupAttributes());
        userGroupAttrs.add(TOTPUserGroup.TOTP_USER_GROUP_CONFIG);
        return Collections.unmodifiableCollection(userGroupAttrs);
    }
}

