/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.recomp;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.tasks.compile.GroovyJavaJointCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.incremental.recomp.AbstractRecompilationSpecProvider;
import org.gradle.api.internal.tasks.compile.incremental.recomp.CurrentCompilation;
import org.gradle.api.internal.tasks.compile.incremental.recomp.RecompilationSpec;
import org.gradle.api.internal.tasks.compile.incremental.recomp.SourceFileChangeProcessor;
import org.gradle.api.internal.tasks.compile.incremental.recomp.SourceFileClassNameConverter;
import org.gradle.internal.file.Deleter;
import org.gradle.work.FileChange;

public class GroovyRecompilationSpecProvider
extends AbstractRecompilationSpecProvider {
    private static final Set<String> SUPPORTED_FILE_EXTENSIONS = ImmutableSet.of((Object)".java", (Object)".groovy");

    public GroovyRecompilationSpecProvider(Deleter deleter, FileOperations fileOperations, FileTree sources, boolean incremental, Iterable<FileChange> sourceChanges) {
        super(deleter, fileOperations, sources, sourceChanges, incremental);
    }

    protected void processCompilerSpecificDependencies(JavaCompileSpec spec, RecompilationSpec recompilationSpec, SourceFileChangeProcessor sourceFileChangeProcessor, SourceFileClassNameConverter sourceFileClassNameConverter) {
        if (!this.supportsGroovyJavaJointCompilation(spec)) {
            return;
        }
        Set classesWithJavaSource = recompilationSpec.getClassesToCompile().stream().flatMap(classToCompile -> sourceFileClassNameConverter.getRelativeSourcePaths(classToCompile).stream()).filter(sourcePath -> sourcePath.endsWith(".java")).flatMap(sourcePath -> sourceFileClassNameConverter.getClassNames(sourcePath).stream()).collect(Collectors.toSet());
        if (!classesWithJavaSource.isEmpty()) {
            sourceFileChangeProcessor.processOnlyAccessibleChangeOfClasses(classesWithJavaSource, recompilationSpec);
        }
    }

    private boolean supportsGroovyJavaJointCompilation(JavaCompileSpec spec) {
        return spec instanceof GroovyJavaJointCompileSpec && ((GroovyJavaJointCompileSpec)spec).getGroovyCompileOptions().getFileExtensions().contains("java");
    }

    protected Set<String> getFileExtensions() {
        return SUPPORTED_FILE_EXTENSIONS;
    }

    protected boolean isIncrementalOnResourceChanges(CurrentCompilation currentCompilation) {
        return false;
    }
}

