/*
 * Decompiled with CFR 0.152.
 */
package org.projectlibre.print;

import com.projectlibre1.graphic.configuration.GraphicConfiguration;
import com.projectlibre1.pm.graphic.graph.GraphParams;
import com.projectlibre1.pm.graphic.spreadsheet.SpreadSheetParams;
import com.projectlibre1.pm.graphic.spreadsheet.SpreadSheetParamsImpl;
import com.projectlibre1.print.ExtendedPrintService;
import java.util.Enumeration;
import javax.swing.table.TableColumn;

public class ProjectLibrePrintServiceImpl
implements ExtendedPrintService {
    @Override
    public double getWRatio(int n, double d, GraphParams graphParams) {
        double d2;
        if (!(graphParams instanceof SpreadSheetParamsImpl) || !graphParams.isLeftPartVisible()) {
            d2 = graphParams.getDrawingBounds().getWidth() / (double)n;
        } else {
            SpreadSheetParamsImpl spreadSheetParamsImpl = (SpreadSheetParamsImpl)graphParams;
            double d3 = this.getWidthWithPaging(-1.0, spreadSheetParamsImpl);
            double d4 = d3 / (double)n;
            double d5 = d3;
            d2 = (d4 + d5) / 2.0;
            while (d5 - d4 > 0.5) {
                double d6 = this.getWidthWithPaging(d2, spreadSheetParamsImpl);
                if (d6 < d2 * (double)n) {
                    d5 = d2;
                } else if (d6 > d2 * (double)n) {
                    d4 = d2;
                } else {
                    d5 = d2;
                    break;
                }
                d2 = (d4 + d5) / 2.0;
            }
            d2 = d5;
        }
        double d7 = d / d2;
        double d8 = 1.0;
        if (d7 < 1.0) {
            d7 = d / (d2 + d8 / d7);
        }
        return d7;
    }

    @Override
    public double getHRatio(int n, double d, GraphParams graphParams) {
        if (graphParams == null || !(graphParams instanceof SpreadSheetParams)) {
            return -1.0;
        }
        SpreadSheetParams spreadSheetParams = (SpreadSheetParams)graphParams;
        double d2 = Math.ceil((double)graphParams.getCache().getSize() / (double)n) * (double)spreadSheetParams.getRowHeight() + (double)GraphicConfiguration.getInstance().getColumnHeaderHeight() + (double)GraphicConfiguration.getInstance().getPrintFooterHeight();
        return d / d2;
    }

    protected double getWidthWithPaging(double d, SpreadSheetParamsImpl spreadSheetParamsImpl) {
        return this.getSpreadSheetWidthWithPaging(d, spreadSheetParamsImpl) + this.getGanttWidthWithPaging(spreadSheetParamsImpl);
    }

    protected double getSpreadSheetWidthWithPaging(double d, SpreadSheetParamsImpl spreadSheetParamsImpl) {
        double d2 = 0.0;
        if (d < 0.0) {
            d2 = spreadSheetParamsImpl.getSpreadSheetWidth();
        } else {
            double d3 = GraphicConfiguration.getInstance().getRowHeaderWidth() + 2 * spreadSheetParamsImpl.getIdColMargin();
            Enumeration<TableColumn> enumeration = spreadSheetParamsImpl.getColumnModel().getColumns();
            while (enumeration.hasMoreElements()) {
                TableColumn tableColumn = enumeration.nextElement();
                int n = tableColumn.getPreferredWidth() + 2 * spreadSheetParamsImpl.getColMargin();
                if (d3 + (double)n > d) {
                    d2 += d;
                    d3 = 0.0;
                }
                d3 += (double)n;
            }
            d2 += d3;
        }
        return d2;
    }

    protected double getGanttWidthWithPaging(SpreadSheetParamsImpl spreadSheetParamsImpl) {
        if (spreadSheetParamsImpl.isRightPartVisible()) {
            return spreadSheetParamsImpl.getGanttBounds().getWidth();
        }
        return 0.0;
    }
}

