/* rygel-player-controller.c generated by valac 0.20.1, the Vala compiler
 * generated from rygel-player-controller.vala, do not modify */

/*
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <libgupnp-av/gupnp-av.h>
#include <rygel-core.h>


#define RYGEL_TYPE_PLAYER_CONTROLLER (rygel_player_controller_get_type ())
#define RYGEL_PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAYER_CONTROLLER, RygelPlayerController))
#define RYGEL_PLAYER_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAYER_CONTROLLER, RygelPlayerControllerClass))
#define RYGEL_IS_PLAYER_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAYER_CONTROLLER))
#define RYGEL_IS_PLAYER_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAYER_CONTROLLER))
#define RYGEL_PLAYER_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAYER_CONTROLLER, RygelPlayerControllerClass))

typedef struct _RygelPlayerController RygelPlayerController;
typedef struct _RygelPlayerControllerClass RygelPlayerControllerClass;
typedef struct _RygelPlayerControllerPrivate RygelPlayerControllerPrivate;

#define RYGEL_TYPE_MEDIA_PLAYER (rygel_media_player_get_type ())
#define RYGEL_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayer))
#define RYGEL_IS_MEDIA_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_PLAYER))
#define RYGEL_MEDIA_PLAYER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_MEDIA_PLAYER, RygelMediaPlayerIface))

typedef struct _RygelMediaPlayer RygelMediaPlayer;
typedef struct _RygelMediaPlayerIface RygelMediaPlayerIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _RygelPlayerController {
	GObject parent_instance;
	RygelPlayerControllerPrivate * priv;
};

struct _RygelPlayerControllerClass {
	GObjectClass parent_class;
};

struct _RygelMediaPlayerIface {
	GTypeInterface parent_iface;
	gboolean (*seek) (RygelMediaPlayer* self, gint64 time);
	gchar** (*get_protocols) (RygelMediaPlayer* self, int* result_length1);
	gchar** (*get_mime_types) (RygelMediaPlayer* self, int* result_length1);
	gchar* (*get_playback_state) (RygelMediaPlayer* self);
	void (*set_playback_state) (RygelMediaPlayer* self, const gchar* value);
	gchar** (*get_allowed_playback_speeds) (RygelMediaPlayer* self, int* result_length1);
	gchar* (*get_playback_speed) (RygelMediaPlayer* self);
	void (*set_playback_speed) (RygelMediaPlayer* self, const gchar* value);
	gchar* (*get_uri) (RygelMediaPlayer* self);
	void (*set_uri) (RygelMediaPlayer* self, const gchar* value);
	gdouble (*get_volume) (RygelMediaPlayer* self);
	void (*set_volume) (RygelMediaPlayer* self, gdouble value);
	gint64 (*get_duration) (RygelMediaPlayer* self);
	gchar* (*get_metadata) (RygelMediaPlayer* self);
	void (*set_metadata) (RygelMediaPlayer* self, const gchar* value);
	gchar* (*get_mime_type) (RygelMediaPlayer* self);
	void (*set_mime_type) (RygelMediaPlayer* self, const gchar* value);
	gboolean (*get_can_seek) (RygelMediaPlayer* self);
	gchar* (*get_content_features) (RygelMediaPlayer* self);
	void (*set_content_features) (RygelMediaPlayer* self, const gchar* value);
	gint64 (*get_position) (RygelMediaPlayer* self);
};

struct _RygelPlayerControllerPrivate {
	RygelMediaPlayer* _player;
	gchar* _protocol_info;
	guint _n_tracks;
	gchar* _uri;
	GUPnPMediaCollection* collection;
	GList* collection_items;
	guint timeout_id;
	guint default_image_timeout;
	RygelConfiguration* config;
	gchar* _metadata;
	guint _track;
	gchar* _playback_state;
};


static gpointer rygel_player_controller_parent_class = NULL;

GType rygel_player_controller_get_type (void) G_GNUC_CONST;
GType rygel_media_player_get_type (void) G_GNUC_CONST;
#define RYGEL_PLAYER_CONTROLLER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_PLAYER_CONTROLLER, RygelPlayerControllerPrivate))
enum  {
	RYGEL_PLAYER_CONTROLLER_DUMMY_PROPERTY,
	RYGEL_PLAYER_CONTROLLER_PLAYER,
	RYGEL_PLAYER_CONTROLLER_PROTOCOL_INFO,
	RYGEL_PLAYER_CONTROLLER_PLAYBACK_STATE,
	RYGEL_PLAYER_CONTROLLER_N_TRACKS,
	RYGEL_PLAYER_CONTROLLER_TRACK,
	RYGEL_PLAYER_CONTROLLER_URI,
	RYGEL_PLAYER_CONTROLLER_METADATA,
	RYGEL_PLAYER_CONTROLLER_CURRENT_TRANSPORT_ACTIONS
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
#define RYGEL_PLAYER_CONTROLLER_DEFAULT_IMAGE_TIMEOUT 15
#define RYGEL_PLAYER_CONTROLLER_CONFIG_SECTION "Renderer"
#define RYGEL_PLAYER_CONTROLLER_TIMEOUT_KEY "image-timeout"
#define RYGEL_PLAYER_CONTROLLER_DIDL_FRAME_TEMPLATE "<DIDL-Lite " "xmlns:dc=\"http://purl.org/dc/elements/1.1/\" " "xmlns:upnp=\"urn:schemas-upnp-org:metadata-1-0/upnp/\" " "xmlns:dlna=\"urn:schemas-dlna-org:metadata-1-0/\" " "xmlns=\"urn:schemas-upnp-org:metadata-1-0/DIDL-Lite/\">" "%s</DIDL-Lite>"
RygelPlayerController* rygel_player_controller_new (RygelMediaPlayer* player, const gchar* protocol_info);
RygelPlayerController* rygel_player_controller_construct (GType object_type, RygelMediaPlayer* player, const gchar* protocol_info);
static void rygel_player_controller_real_constructed (GObject* base);
static RygelMediaPlayer* rygel_player_controller_get_player (RygelPlayerController* self);
static void rygel_player_controller_notify_state_cb (RygelPlayerController* self, GObject* player, GParamSpec* p);
static void _rygel_player_controller_notify_state_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void rygel_player_controller_on_setting_changed (RygelPlayerController* self, const gchar* section, const gchar* key);
static void _rygel_player_controller_on_setting_changed_rygel_configuration_setting_changed (RygelConfiguration* _sender, const gchar* section, const gchar* key, gpointer self);
gboolean rygel_player_controller_next (RygelPlayerController* self);
guint rygel_player_controller_get_track (RygelPlayerController* self);
guint rygel_player_controller_get_n_tracks (RygelPlayerController* self);
void rygel_player_controller_set_track (RygelPlayerController* self, guint value);
gboolean rygel_player_controller_previous (RygelPlayerController* self);
void rygel_player_controller_set_playlist (RygelPlayerController* self, GUPnPMediaCollection* collection);
void rygel_player_controller_set_n_tracks (RygelPlayerController* self, guint value);
gchar* rygel_media_player_get_playback_state (RygelMediaPlayer* self);
static gboolean ____lambda2_ (RygelPlayerController* self);
void rygel_media_player_set_playback_state (RygelMediaPlayer* self, const gchar* value);
static gboolean _____lambda2__gsource_func (gpointer self);
static void rygel_player_controller_reset (RygelPlayerController* self);
void rygel_player_controller_set_playback_state (RygelPlayerController* self, const gchar* value);
static void rygel_player_controller_apply_track (RygelPlayerController* self);
static const gchar* rygel_player_controller_get_protocol_info (RygelPlayerController* self);
void rygel_media_player_set_metadata (RygelMediaPlayer* self, const gchar* value);
void rygel_media_player_set_uri (RygelMediaPlayer* self, const gchar* value);
static void rygel_player_controller_setup_image_timeouts (RygelPlayerController* self, glong lifetime);
static gboolean __lambda3_ (RygelPlayerController* self);
static gboolean ___lambda3__gsource_func (gpointer self);
static gchar* rygel_player_controller_unescape (RygelPlayerController* self, const gchar* input);
static void rygel_player_controller_set_player (RygelPlayerController* self, RygelMediaPlayer* value);
static void rygel_player_controller_set_protocol_info (RygelPlayerController* self, const gchar* value);
const gchar* rygel_player_controller_get_playback_state (RygelPlayerController* self);
const gchar* rygel_player_controller_get_uri (RygelPlayerController* self);
void rygel_player_controller_set_uri (RygelPlayerController* self, const gchar* value);
gchar* rygel_player_controller_get_metadata (RygelPlayerController* self);
void rygel_player_controller_set_metadata (RygelPlayerController* self, const gchar* value);
gchar* rygel_player_controller_get_current_transport_actions (RygelPlayerController* self);
gboolean rygel_media_player_get_can_seek (RygelMediaPlayer* self);
gchar** rygel_media_player_get_allowed_playback_speeds (RygelMediaPlayer* self, int* result_length1);
static void rygel_player_controller_finalize (GObject* obj);
static void _vala_rygel_player_controller_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_rygel_player_controller_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _g_object_unref0_ (gpointer var) {
#line 121 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 180 "rygel-player-controller.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 121 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 121 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_list_free (self);
#line 189 "rygel-player-controller.c"
}


RygelPlayerController* rygel_player_controller_construct (GType object_type, RygelMediaPlayer* player, const gchar* protocol_info) {
	RygelPlayerController * self = NULL;
	RygelMediaPlayer* _tmp0_;
	const gchar* _tmp1_;
#line 131 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_val_if_fail (player != NULL, NULL);
#line 131 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_val_if_fail (protocol_info != NULL, NULL);
#line 132 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp0_ = player;
#line 132 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp1_ = protocol_info;
#line 132 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	self = (RygelPlayerController*) g_object_new (object_type, "player", _tmp0_, "protocol-info", _tmp1_, NULL);
#line 131 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	return self;
#line 209 "rygel-player-controller.c"
}


RygelPlayerController* rygel_player_controller_new (RygelMediaPlayer* player, const gchar* protocol_info) {
#line 131 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	return rygel_player_controller_construct (RYGEL_TYPE_PLAYER_CONTROLLER, player, protocol_info);
#line 216 "rygel-player-controller.c"
}


static void _rygel_player_controller_notify_state_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 138 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	rygel_player_controller_notify_state_cb (self, _sender, pspec);
#line 223 "rygel-player-controller.c"
}


static void _rygel_player_controller_on_setting_changed_rygel_configuration_setting_changed (RygelConfiguration* _sender, const gchar* section, const gchar* key, gpointer self) {
#line 141 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	rygel_player_controller_on_setting_changed (self, section, key);
#line 230 "rygel-player-controller.c"
}


static void rygel_player_controller_real_constructed (GObject* base) {
	RygelPlayerController * self;
	RygelMediaPlayer* _tmp0_;
	RygelMetaConfig* _tmp1_ = NULL;
	RygelConfiguration* _tmp2_;
#line 135 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	self = (RygelPlayerController*) base;
#line 136 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	G_OBJECT_CLASS (rygel_player_controller_parent_class)->constructed (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject));
#line 138 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp0_ = self->priv->_player;
#line 138 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_signal_connect_object ((GObject*) _tmp0_, "notify::playback-state", (GCallback) _rygel_player_controller_notify_state_cb_g_object_notify, self, 0);
#line 140 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp1_ = rygel_meta_config_get_default ();
#line 140 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_g_object_unref0 (self->priv->config);
#line 140 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	self->priv->config = (RygelConfiguration*) _tmp1_;
#line 141 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp2_ = self->priv->config;
#line 141 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_signal_connect_object (_tmp2_, "setting-changed", (GCallback) _rygel_player_controller_on_setting_changed_rygel_configuration_setting_changed, self, 0);
#line 142 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	self->priv->default_image_timeout = (guint) RYGEL_PLAYER_CONTROLLER_DEFAULT_IMAGE_TIMEOUT;
#line 143 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	rygel_player_controller_on_setting_changed (self, RYGEL_PLAYER_CONTROLLER_CONFIG_SECTION, RYGEL_PLAYER_CONTROLLER_TIMEOUT_KEY);
#line 261 "rygel-player-controller.c"
}


gboolean rygel_player_controller_next (RygelPlayerController* self) {
	gboolean result = FALSE;
	guint _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
#line 146 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 147 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp0_ = rygel_player_controller_get_track (self);
#line 147 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp1_ = _tmp0_;
#line 147 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp2_ = self->priv->_n_tracks;
#line 147 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	if ((_tmp1_ + 1) > _tmp2_) {
#line 148 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		result = FALSE;
#line 148 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		return result;
#line 286 "rygel-player-controller.c"
	}
#line 151 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp3_ = rygel_player_controller_get_track (self);
#line 151 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp4_ = _tmp3_;
#line 151 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	rygel_player_controller_set_track (self, _tmp4_ + 1);
#line 153 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	result = TRUE;
#line 153 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	return result;
#line 298 "rygel-player-controller.c"
}


gboolean rygel_player_controller_previous (RygelPlayerController* self) {
	gboolean result = FALSE;
	guint _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
#line 156 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 157 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp0_ = rygel_player_controller_get_track (self);
#line 157 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp1_ = _tmp0_;
#line 157 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	if (_tmp1_ <= ((guint) 1)) {
#line 158 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		result = FALSE;
#line 158 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		return result;
#line 320 "rygel-player-controller.c"
	}
#line 161 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp2_ = rygel_player_controller_get_track (self);
#line 161 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp3_ = _tmp2_;
#line 161 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	rygel_player_controller_set_track (self, _tmp3_ - 1);
#line 163 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	result = TRUE;
#line 163 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	return result;
#line 332 "rygel-player-controller.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 167 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	return self ? g_object_ref (self) : NULL;
#line 339 "rygel-player-controller.c"
}


void rygel_player_controller_set_playlist (RygelPlayerController* self, GUPnPMediaCollection* collection) {
	GUPnPMediaCollection* _tmp0_;
	GUPnPMediaCollection* _tmp1_;
	guint _tmp2_;
	GUPnPMediaCollection* _tmp4_;
#line 166 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_if_fail (self != NULL);
#line 167 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp0_ = collection;
#line 167 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 167 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_g_object_unref0 (self->priv->collection);
#line 167 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	self->priv->collection = _tmp1_;
#line 168 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp2_ = self->priv->timeout_id;
#line 168 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	if (_tmp2_ != ((guint) 0)) {
#line 362 "rygel-player-controller.c"
		guint _tmp3_;
#line 169 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		self->priv->timeout_id = (guint) 0;
#line 170 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp3_ = self->priv->timeout_id;
#line 170 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		g_source_remove (_tmp3_);
#line 370 "rygel-player-controller.c"
	}
#line 173 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp4_ = self->priv->collection;
#line 173 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	if (_tmp4_ != NULL) {
#line 376 "rygel-player-controller.c"
		GUPnPMediaCollection* _tmp5_;
		GList* _tmp6_ = NULL;
		GList* _tmp7_;
		guint _tmp8_ = 0U;
#line 174 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp5_ = collection;
#line 174 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp6_ = gupnp_media_collection_get_items (_tmp5_);
#line 174 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		__g_list_free__g_object_unref0_0 (self->priv->collection_items);
#line 174 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		self->priv->collection_items = _tmp6_;
#line 175 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp7_ = self->priv->collection_items;
#line 175 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp8_ = g_list_length (_tmp7_);
#line 175 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		rygel_player_controller_set_n_tracks (self, _tmp8_);
#line 176 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		rygel_player_controller_set_track (self, (guint) 1);
#line 397 "rygel-player-controller.c"
	} else {
#line 178 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		__g_list_free__g_object_unref0_0 (self->priv->collection_items);
#line 178 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		self->priv->collection_items = NULL;
#line 403 "rygel-player-controller.c"
	}
}


static gboolean ____lambda2_ (RygelPlayerController* self) {
	gboolean result = FALSE;
	RygelMediaPlayer* _tmp0_;
#line 188 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp0_ = self->priv->_player;
#line 188 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	rygel_media_player_set_playback_state (_tmp0_, "STOPPED");
#line 190 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	result = FALSE;
#line 190 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	return result;
#line 419 "rygel-player-controller.c"
}


static gboolean _____lambda2__gsource_func (gpointer self) {
	gboolean result;
	result = ____lambda2_ (self);
#line 187 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	return result;
#line 428 "rygel-player-controller.c"
}


static void rygel_player_controller_notify_state_cb (RygelPlayerController* self, GObject* player, GParamSpec* p) {
	RygelMediaPlayer* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* state;
	const gchar* _tmp3_;
#line 182 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_if_fail (self != NULL);
#line 182 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_if_fail (player != NULL);
#line 182 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_if_fail (p != NULL);
#line 183 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp0_ = self->priv->_player;
#line 183 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp1_ = rygel_media_player_get_playback_state (_tmp0_);
#line 183 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp2_ = _tmp1_;
#line 183 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	state = _tmp2_;
#line 184 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp3_ = state;
#line 184 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	if (g_strcmp0 (_tmp3_, "EOS") == 0) {
#line 456 "rygel-player-controller.c"
		GUPnPMediaCollection* _tmp4_;
#line 185 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp4_ = self->priv->collection;
#line 185 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		if (_tmp4_ == NULL) {
#line 187 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
			g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _____lambda2__gsource_func, g_object_ref (self), g_object_unref);
#line 193 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
			_g_free0 (state);
#line 193 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
			return;
#line 468 "rygel-player-controller.c"
		} else {
			gboolean _tmp5_ = FALSE;
#line 196 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
			_tmp5_ = rygel_player_controller_next (self);
#line 196 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
			if (!_tmp5_) {
#line 199 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
				rygel_player_controller_reset (self);
#line 477 "rygel-player-controller.c"
			}
		}
	} else {
		const gchar* _tmp6_;
#line 204 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp6_ = state;
#line 204 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		rygel_player_controller_set_playback_state (self, _tmp6_);
#line 486 "rygel-player-controller.c"
	}
#line 182 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_g_free0 (state);
#line 490 "rygel-player-controller.c"
}


static void rygel_player_controller_apply_track (RygelPlayerController* self) {
	GList* _tmp0_;
#line 208 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_if_fail (self != NULL);
#line 210 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp0_ = self->priv->collection_items;
#line 210 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	if (_tmp0_ != NULL) {
#line 502 "rygel-player-controller.c"
		GList* _tmp1_;
		guint _tmp2_;
		guint _tmp3_;
		GList* _tmp4_ = NULL;
		gconstpointer _tmp5_;
		GUPnPDIDLLiteItem* _tmp6_;
		GUPnPDIDLLiteItem* item;
		GUPnPDIDLLiteItem* _tmp7_;
		const gchar* _tmp8_;
		GUPnPDIDLLiteResource* _tmp9_ = NULL;
		GUPnPDIDLLiteResource* res;
		RygelMediaPlayer* _tmp10_;
		GUPnPDIDLLiteItem* _tmp11_;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		RygelMediaPlayer* _tmp16_;
		GUPnPDIDLLiteResource* _tmp17_;
		const gchar* _tmp18_ = NULL;
		gboolean _tmp19_ = FALSE;
		GUPnPDIDLLiteItem* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		gboolean _tmp23_ = FALSE;
		gboolean _tmp25_;
#line 211 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp1_ = self->priv->collection_items;
#line 211 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp2_ = rygel_player_controller_get_track (self);
#line 211 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp3_ = _tmp2_;
#line 211 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp4_ = g_list_nth (_tmp1_, _tmp3_ - 1);
#line 211 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp5_ = _tmp4_->data;
#line 211 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp6_ = _g_object_ref0 ((GUPnPDIDLLiteItem*) _tmp5_);
#line 211 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		item = _tmp6_;
#line 213 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp7_ = item;
#line 213 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp8_ = self->priv->_protocol_info;
#line 213 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp9_ = gupnp_didl_lite_object_get_compat_resource ((GUPnPDIDLLiteObject*) _tmp7_, _tmp8_, TRUE);
#line 213 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		res = _tmp9_;
#line 214 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp10_ = self->priv->_player;
#line 214 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp11_ = item;
#line 214 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp12_ = gupnp_didl_lite_object_get_xml_string ((GUPnPDIDLLiteObject*) _tmp11_);
#line 214 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp13_ = _tmp12_;
#line 214 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp14_ = g_strdup_printf (RYGEL_PLAYER_CONTROLLER_DIDL_FRAME_TEMPLATE, _tmp13_);
#line 214 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp15_ = _tmp14_;
#line 214 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		rygel_media_player_set_metadata (_tmp10_, _tmp15_);
#line 214 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_g_free0 (_tmp15_);
#line 214 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_g_free0 (_tmp13_);
#line 216 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp16_ = self->priv->_player;
#line 216 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp17_ = res;
#line 216 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp18_ = gupnp_didl_lite_resource_get_uri (_tmp17_);
#line 216 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		rygel_media_player_set_uri (_tmp16_, _tmp18_);
#line 217 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp20_ = item;
#line 217 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp21_ = gupnp_didl_lite_object_get_upnp_class ((GUPnPDIDLLiteObject*) _tmp20_);
#line 217 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp22_ = _tmp21_;
#line 217 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp23_ = g_str_has_prefix (_tmp22_, "object.item.image");
#line 217 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		if (_tmp23_) {
#line 587 "rygel-player-controller.c"
			GUPnPMediaCollection* _tmp24_;
#line 218 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
			_tmp24_ = self->priv->collection;
#line 218 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
			_tmp19_ = _tmp24_ != NULL;
#line 593 "rygel-player-controller.c"
		} else {
#line 217 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
			_tmp19_ = FALSE;
#line 597 "rygel-player-controller.c"
		}
#line 217 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp25_ = _tmp19_;
#line 217 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		if (_tmp25_) {
#line 603 "rygel-player-controller.c"
			GUPnPDIDLLiteItem* _tmp26_;
			glong _tmp27_;
			glong _tmp28_;
#line 219 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
			_tmp26_ = item;
#line 219 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
			_tmp27_ = gupnp_didl_lite_item_get_lifetime (_tmp26_);
#line 219 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
			_tmp28_ = _tmp27_;
#line 219 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
			rygel_player_controller_setup_image_timeouts (self, _tmp28_);
#line 615 "rygel-player-controller.c"
		}
#line 210 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_g_object_unref0 (res);
#line 210 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_g_object_unref0 (item);
#line 621 "rygel-player-controller.c"
	}
}


static void rygel_player_controller_reset (RygelPlayerController* self) {
	RygelMediaPlayer* _tmp0_;
#line 224 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_if_fail (self != NULL);
#line 225 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp0_ = self->priv->_player;
#line 225 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	rygel_media_player_set_playback_state (_tmp0_, "STOPPED");
#line 226 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	rygel_player_controller_set_track (self, (guint) 1);
#line 636 "rygel-player-controller.c"
}


static gboolean __lambda3_ (RygelPlayerController* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
#line 245 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	self->priv->timeout_id = (guint) 0;
#line 246 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp0_ = rygel_player_controller_next (self);
#line 246 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	if (!_tmp0_) {
#line 247 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		rygel_player_controller_reset (self);
#line 651 "rygel-player-controller.c"
	}
#line 250 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	result = FALSE;
#line 250 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	return result;
#line 657 "rygel-player-controller.c"
}


static gboolean ___lambda3__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda3_ (self);
#line 244 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	return result;
#line 666 "rygel-player-controller.c"
}


static void rygel_player_controller_setup_image_timeouts (RygelPlayerController* self, glong lifetime) {
	guint _tmp0_;
	guint timeout;
	glong _tmp1_;
	guint _tmp3_;
	guint _tmp4_;
	guint _tmp6_;
	guint _tmp7_ = 0U;
#line 229 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_if_fail (self != NULL);
#line 233 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp0_ = self->priv->default_image_timeout;
#line 233 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	timeout = _tmp0_;
#line 234 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp1_ = lifetime;
#line 234 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	if (_tmp1_ > ((glong) 0)) {
#line 688 "rygel-player-controller.c"
		glong _tmp2_;
#line 235 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp2_ = lifetime;
#line 235 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		timeout = (guint) _tmp2_;
#line 694 "rygel-player-controller.c"
	}
#line 238 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp3_ = timeout;
#line 238 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_debug ("rygel-player-controller.vala:238: Item is image, setup timer: %ld", (glong) _tmp3_);
#line 240 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp4_ = self->priv->timeout_id;
#line 240 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	if (_tmp4_ != ((guint) 0)) {
#line 704 "rygel-player-controller.c"
		guint _tmp5_;
#line 241 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp5_ = self->priv->timeout_id;
#line 241 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		g_source_remove (_tmp5_);
#line 710 "rygel-player-controller.c"
	}
#line 244 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp6_ = timeout;
#line 244 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp7_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) _tmp6_, ___lambda3__gsource_func, g_object_ref (self), g_object_unref);
#line 244 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	self->priv->timeout_id = _tmp7_;
#line 718 "rygel-player-controller.c"
}


static void rygel_player_controller_on_setting_changed (RygelPlayerController* self, const gchar* section, const gchar* key) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp3_;
	guint _tmp8_;
	GError * _inner_error_ = NULL;
#line 254 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_if_fail (self != NULL);
#line 254 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_if_fail (section != NULL);
#line 254 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_if_fail (key != NULL);
#line 255 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp1_ = section;
#line 255 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	if (g_strcmp0 (_tmp1_, RYGEL_PLAYER_CONTROLLER_CONFIG_SECTION) != 0) {
#line 738 "rygel-player-controller.c"
		const gchar* _tmp2_;
#line 255 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp2_ = key;
#line 255 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp0_ = g_strcmp0 (_tmp2_, RYGEL_PLAYER_CONTROLLER_TIMEOUT_KEY) != 0;
#line 744 "rygel-player-controller.c"
	} else {
#line 255 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp0_ = FALSE;
#line 748 "rygel-player-controller.c"
	}
#line 255 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp3_ = _tmp0_;
#line 255 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	if (_tmp3_) {
#line 256 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		return;
#line 756 "rygel-player-controller.c"
	}
	{
		RygelConfiguration* _tmp4_;
		gint _tmp5_;
		gint _tmp6_ = 0;
		gint _tmp7_;
#line 260 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp4_ = self->priv->config;
#line 260 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp5_ = G_MAXINT;
#line 260 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp6_ = rygel_configuration_get_int (_tmp4_, RYGEL_PLAYER_CONTROLLER_CONFIG_SECTION, RYGEL_PLAYER_CONTROLLER_TIMEOUT_KEY, 0, _tmp5_, &_inner_error_);
#line 260 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp7_ = _tmp6_;
#line 260 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		if (_inner_error_ != NULL) {
#line 773 "rygel-player-controller.c"
			goto __catch1_g_error;
		}
#line 260 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		self->priv->default_image_timeout = (guint) _tmp7_;
#line 778 "rygel-player-controller.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* _error_ = NULL;
#line 259 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_error_ = _inner_error_;
#line 259 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_inner_error_ = NULL;
#line 265 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		self->priv->default_image_timeout = (guint) RYGEL_PLAYER_CONTROLLER_DEFAULT_IMAGE_TIMEOUT;
#line 259 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_g_error_free0 (_error_);
#line 792 "rygel-player-controller.c"
	}
	__finally1:
#line 259 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	if (_inner_error_ != NULL) {
#line 259 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 259 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		g_clear_error (&_inner_error_);
#line 259 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		return;
#line 803 "rygel-player-controller.c"
	}
#line 268 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp8_ = self->priv->default_image_timeout;
#line 268 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_debug ("rygel-player-controller.vala:268: New image timeout: %lu", (gulong) _tmp8_);
#line 809 "rygel-player-controller.c"
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
#line 1242 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1242 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1242 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 822 "rygel-player-controller.c"
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp0_ = old;
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_g_free0 (_tmp2_);
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		regex = _tmp4_;
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 852 "rygel-player-controller.c"
				goto __catch2_g_regex_error;
			}
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1244 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			return NULL;
#line 861 "rygel-player-controller.c"
		}
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp5_ = regex;
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp6_ = replacement;
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_tmp8_ = _tmp7_;
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		if (_inner_error_ != NULL) {
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			if (_inner_error_->domain == G_REGEX_ERROR) {
#line 877 "rygel-player-controller.c"
				goto __catch2_g_regex_error;
			}
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			g_clear_error (&_inner_error_);
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
			return NULL;
#line 888 "rygel-player-controller.c"
		}
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		result = _tmp8_;
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1245 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		return result;
#line 896 "rygel-player-controller.c"
	}
	goto __finally2;
	__catch2_g_regex_error:
	{
		GError* e = NULL;
#line 1243 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		e = _inner_error_;
#line 1243 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_inner_error_ = NULL;
#line 1247 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		g_assert_not_reached ();
#line 1243 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		_g_error_free0 (e);
#line 910 "rygel-player-controller.c"
	}
	__finally2:
#line 1243 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
	if (_inner_error_ != NULL) {
#line 1243 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 1243 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		g_clear_error (&_inner_error_);
#line 1243 "/usr/share/vala-0.20/vapi/glib-2.0.vapi"
		return NULL;
#line 921 "rygel-player-controller.c"
	}
}


static gchar* rygel_player_controller_unescape (RygelPlayerController* self, const gchar* input) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* _result_;
	const gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
#line 271 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 271 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_val_if_fail (input != NULL, NULL);
#line 272 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp0_ = input;
#line 272 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp1_ = string_replace (_tmp0_, "&quot;", "\"");
#line 272 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_result_ = _tmp1_;
#line 273 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp2_ = _result_;
#line 273 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp3_ = string_replace (_tmp2_, "&lt;", "<");
#line 273 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_g_free0 (_result_);
#line 273 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_result_ = _tmp3_;
#line 274 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp4_ = _result_;
#line 274 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp5_ = string_replace (_tmp4_, "&gt;", ">");
#line 274 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_g_free0 (_result_);
#line 274 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_result_ = _tmp5_;
#line 275 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp6_ = _result_;
#line 275 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp7_ = string_replace (_tmp6_, "&apos;", "'");
#line 275 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_g_free0 (_result_);
#line 275 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_result_ = _tmp7_;
#line 276 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp8_ = _result_;
#line 276 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp9_ = string_replace (_tmp8_, "&amp;", "&");
#line 276 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_g_free0 (_result_);
#line 276 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_result_ = _tmp9_;
#line 278 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	result = _result_;
#line 278 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	return result;
#line 985 "rygel-player-controller.c"
}


static RygelMediaPlayer* rygel_player_controller_get_player (RygelPlayerController* self) {
	RygelMediaPlayer* result;
	RygelMediaPlayer* _tmp0_;
#line 50 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 50 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp0_ = self->priv->_player;
#line 50 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	result = _tmp0_;
#line 50 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	return result;
#line 1000 "rygel-player-controller.c"
}


static void rygel_player_controller_set_player (RygelPlayerController* self, RygelMediaPlayer* value) {
	RygelMediaPlayer* _tmp0_;
	RygelMediaPlayer* _tmp1_;
#line 50 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_if_fail (self != NULL);
#line 50 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp0_ = value;
#line 50 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 50 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_g_object_unref0 (self->priv->_player);
#line 50 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	self->priv->_player = _tmp1_;
#line 50 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_object_notify ((GObject *) self, "player");
#line 1019 "rygel-player-controller.c"
}


static const gchar* rygel_player_controller_get_protocol_info (RygelPlayerController* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 51 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 51 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp0_ = self->priv->_protocol_info;
#line 51 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	result = _tmp0_;
#line 51 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	return result;
#line 1034 "rygel-player-controller.c"
}


static void rygel_player_controller_set_protocol_info (RygelPlayerController* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 51 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_if_fail (self != NULL);
#line 51 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp0_ = value;
#line 51 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 51 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_g_free0 (self->priv->_protocol_info);
#line 51 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	self->priv->_protocol_info = _tmp1_;
#line 51 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_object_notify ((GObject *) self, "protocol-info");
#line 1053 "rygel-player-controller.c"
}


const gchar* rygel_player_controller_get_playback_state (RygelPlayerController* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 56 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 56 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp0_ = self->priv->_playback_state;
#line 56 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	result = _tmp0_;
#line 56 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	return result;
#line 1068 "rygel-player-controller.c"
}


void rygel_player_controller_set_playback_state (RygelPlayerController* self, const gchar* value) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
#line 57 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_if_fail (self != NULL);
#line 58 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp0_ = self->priv->_playback_state;
#line 58 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp1_ = value;
#line 58 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	if (g_strcmp0 (_tmp0_, _tmp1_) != 0) {
#line 1083 "rygel-player-controller.c"
		const gchar* _tmp2_;
		gchar* _tmp3_;
#line 59 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp2_ = value;
#line 59 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp3_ = g_strdup (_tmp2_);
#line 59 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_g_free0 (self->priv->_playback_state);
#line 59 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		self->priv->_playback_state = _tmp3_;
#line 60 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		g_object_notify ((GObject*) self, "playback-state");
#line 1096 "rygel-player-controller.c"
	}
}


guint rygel_player_controller_get_n_tracks (RygelPlayerController* self) {
	guint result;
	guint _tmp0_;
#line 65 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 65 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp0_ = self->priv->_n_tracks;
#line 65 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	result = _tmp0_;
#line 65 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	return result;
#line 1112 "rygel-player-controller.c"
}


void rygel_player_controller_set_n_tracks (RygelPlayerController* self, guint value) {
	guint _tmp0_;
#line 65 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_if_fail (self != NULL);
#line 65 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp0_ = value;
#line 65 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	self->priv->_n_tracks = _tmp0_;
#line 65 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_object_notify ((GObject *) self, "n-tracks");
#line 1126 "rygel-player-controller.c"
}


guint rygel_player_controller_get_track (RygelPlayerController* self) {
	guint result;
	guint _tmp0_;
#line 67 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 67 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp0_ = self->priv->_track;
#line 67 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	result = _tmp0_;
#line 67 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	return result;
#line 1141 "rygel-player-controller.c"
}


void rygel_player_controller_set_track (RygelPlayerController* self, guint value) {
	guint _tmp0_;
#line 68 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_if_fail (self != NULL);
#line 68 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp0_ = value;
#line 68 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	self->priv->_track = _tmp0_;
#line 68 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	rygel_player_controller_apply_track (self);
#line 68 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_object_notify ((GObject *) self, "track");
#line 1157 "rygel-player-controller.c"
}


const gchar* rygel_player_controller_get_uri (RygelPlayerController* self) {
	const gchar* result;
	const gchar* _tmp0_;
#line 71 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 71 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp0_ = self->priv->_uri;
#line 71 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	result = _tmp0_;
#line 71 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	return result;
#line 1172 "rygel-player-controller.c"
}


void rygel_player_controller_set_uri (RygelPlayerController* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 71 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_if_fail (self != NULL);
#line 71 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp0_ = value;
#line 71 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 71 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_g_free0 (self->priv->_uri);
#line 71 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	self->priv->_uri = _tmp1_;
#line 71 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_object_notify ((GObject *) self, "uri");
#line 1191 "rygel-player-controller.c"
}


gchar* rygel_player_controller_get_metadata (RygelPlayerController* self) {
	gchar* result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
#line 73 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 73 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp0_ = self->priv->_metadata;
#line 73 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 73 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp2_ = _tmp1_;
#line 73 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp3_ = _tmp2_;
#line 73 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	if (_tmp3_ == NULL) {
#line 1213 "rygel-player-controller.c"
		gchar* _tmp4_;
#line 73 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp4_ = g_strdup ("");
#line 73 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_g_free0 (_tmp2_);
#line 73 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp2_ = _tmp4_;
#line 1221 "rygel-player-controller.c"
	}
#line 73 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	result = _tmp2_;
#line 73 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	return result;
#line 1227 "rygel-player-controller.c"
}


void rygel_player_controller_set_metadata (RygelPlayerController* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
#line 74 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_if_fail (self != NULL);
#line 74 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp0_ = value;
#line 74 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp1_ = rygel_player_controller_unescape (self, _tmp0_);
#line 74 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_g_free0 (self->priv->_metadata);
#line 74 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	self->priv->_metadata = _tmp1_;
#line 74 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_object_notify ((GObject *) self, "metadata");
#line 1246 "rygel-player-controller.c"
}


gchar* rygel_player_controller_get_current_transport_actions (RygelPlayerController* self) {
	gchar* result;
	gchar* actions;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
#line 81 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	static GQuark _tmp2_label0 = 0;
#line 81 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	static GQuark _tmp2_label1 = 0;
#line 81 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	static GQuark _tmp2_label2 = 0;
#line 81 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	static GQuark _tmp2_label3 = 0;
#line 1264 "rygel-player-controller.c"
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_;
	gboolean _tmp12_;
	const gchar* _tmp32_;
#line 79 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 80 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	actions = NULL;
#line 81 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp0_ = self->priv->_playback_state;
#line 81 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp1_ = _tmp0_;
#line 81 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 81 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	if ((_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("PLAYING")))) || (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("TRANSITIONING"))))) {
#line 81 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		switch (0) {
#line 1283 "rygel-player-controller.c"
			default:
			{
				gchar* _tmp4_;
#line 84 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
				_tmp4_ = g_strdup ("Stop,Seek,Pause");
#line 84 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
				_g_free0 (actions);
#line 84 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
				actions = _tmp4_;
#line 85 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
				break;
#line 1295 "rygel-player-controller.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("STOPPED")))) {
#line 81 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		switch (0) {
#line 1301 "rygel-player-controller.c"
			default:
			{
				gchar* _tmp5_;
#line 87 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
				_tmp5_ = g_strdup ("Play");
#line 87 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
				_g_free0 (actions);
#line 87 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
				actions = _tmp5_;
#line 88 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
				break;
#line 1313 "rygel-player-controller.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("PAUSED_PLAYBACK")))) {
#line 81 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		switch (0) {
#line 1319 "rygel-player-controller.c"
			default:
			{
				gchar* _tmp6_;
#line 90 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
				_tmp6_ = g_strdup ("Stop,Play,Seek");
#line 90 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
				_g_free0 (actions);
#line 90 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
				actions = _tmp6_;
#line 91 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
				break;
#line 1331 "rygel-player-controller.c"
			}
		}
	} else {
#line 81 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		switch (0) {
#line 1337 "rygel-player-controller.c"
			default:
			{
#line 93 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
				break;
#line 1342 "rygel-player-controller.c"
			}
		}
	}
#line 95 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp8_ = actions;
#line 95 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	if (_tmp8_ != NULL) {
#line 1350 "rygel-player-controller.c"
		RygelMediaPlayer* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
#line 95 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp9_ = self->priv->_player;
#line 95 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp10_ = rygel_media_player_get_can_seek (_tmp9_);
#line 95 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp11_ = _tmp10_;
#line 95 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp7_ = _tmp11_;
#line 1362 "rygel-player-controller.c"
	} else {
#line 95 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp7_ = FALSE;
#line 1366 "rygel-player-controller.c"
	}
#line 95 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp12_ = _tmp7_;
#line 95 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	if (_tmp12_) {
#line 1372 "rygel-player-controller.c"
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* play_speeds;
		RygelMediaPlayer* _tmp16_;
		gchar** _tmp17_;
		gint _tmp17__length1;
		gchar** _tmp18_;
		gint _tmp18__length1;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		gchar* _tmp31_;
#line 96 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp13_ = actions;
#line 96 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp14_ = g_strconcat (_tmp13_, ",X_DLNA_SeekTime", NULL);
#line 96 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_g_free0 (actions);
#line 96 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		actions = _tmp14_;
#line 98 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp15_ = g_strdup ("");
#line 98 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		play_speeds = _tmp15_;
#line 99 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp16_ = self->priv->_player;
#line 99 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp17_ = rygel_media_player_get_allowed_playback_speeds (_tmp16_, &_tmp17__length1);
#line 99 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp18_ = _tmp17_;
#line 99 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp18__length1 = _tmp17__length1;
#line 1405 "rygel-player-controller.c"
		{
			gchar** speed_collection = NULL;
			gint speed_collection_length1 = 0;
			gint _speed_collection_size_ = 0;
			gint speed_it = 0;
#line 99 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
			speed_collection = _tmp18_;
#line 99 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
			speed_collection_length1 = _tmp18__length1;
#line 99 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
			for (speed_it = 0; speed_it < _tmp18__length1; speed_it = speed_it + 1) {
#line 1417 "rygel-player-controller.c"
				gchar* _tmp19_;
				gchar* speed = NULL;
#line 99 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
				_tmp19_ = g_strdup (speed_collection[speed_it]);
#line 99 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
				speed = _tmp19_;
#line 1424 "rygel-player-controller.c"
				{
					const gchar* _tmp20_;
#line 100 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
					_tmp20_ = speed;
#line 100 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
					if (g_strcmp0 (_tmp20_, "1") != 0) {
#line 1431 "rygel-player-controller.c"
						const gchar* _tmp21_;
#line 101 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
						_tmp21_ = play_speeds;
#line 101 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
						if (g_strcmp0 (_tmp21_, "") == 0) {
#line 1437 "rygel-player-controller.c"
							const gchar* _tmp22_;
							gchar* _tmp23_;
#line 102 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
							_tmp22_ = speed;
#line 102 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
							_tmp23_ = g_strconcat (",X_DLNA_PS=", _tmp22_, NULL);
#line 102 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
							_g_free0 (play_speeds);
#line 102 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
							play_speeds = _tmp23_;
#line 1448 "rygel-player-controller.c"
						} else {
							const gchar* _tmp24_;
							const gchar* _tmp25_;
							gchar* _tmp26_;
							gchar* _tmp27_;
							gchar* _tmp28_;
#line 104 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
							_tmp24_ = play_speeds;
#line 104 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
							_tmp25_ = speed;
#line 104 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
							_tmp26_ = g_strconcat ("\\,", _tmp25_, NULL);
#line 104 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
							_tmp27_ = _tmp26_;
#line 104 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
							_tmp28_ = g_strconcat (_tmp24_, _tmp27_, NULL);
#line 104 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
							_g_free0 (play_speeds);
#line 104 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
							play_speeds = _tmp28_;
#line 104 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
							_g_free0 (_tmp27_);
#line 1471 "rygel-player-controller.c"
						}
					}
#line 99 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
					_g_free0 (speed);
#line 1476 "rygel-player-controller.c"
				}
			}
#line 99 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
			speed_collection = (_vala_array_free (speed_collection, speed_collection_length1, (GDestroyNotify) g_free), NULL);
#line 1481 "rygel-player-controller.c"
		}
#line 108 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp29_ = actions;
#line 108 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp30_ = play_speeds;
#line 108 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp31_ = g_strconcat (_tmp29_, _tmp30_, NULL);
#line 108 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_g_free0 (actions);
#line 108 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		actions = _tmp31_;
#line 95 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_g_free0 (play_speeds);
#line 1495 "rygel-player-controller.c"
	}
#line 111 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp32_ = actions;
#line 111 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	if (_tmp32_ == NULL) {
#line 1501 "rygel-player-controller.c"
		gchar* _tmp33_;
#line 112 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_tmp33_ = g_strdup ("");
#line 112 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		result = _tmp33_;
#line 112 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		_g_free0 (actions);
#line 112 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		return result;
#line 1511 "rygel-player-controller.c"
	}
#line 115 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	result = actions;
#line 115 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	return result;
#line 1517 "rygel-player-controller.c"
}


static void rygel_player_controller_class_init (RygelPlayerControllerClass * klass) {
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	rygel_player_controller_parent_class = g_type_class_peek_parent (klass);
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_type_class_add_private (klass, sizeof (RygelPlayerControllerPrivate));
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	G_OBJECT_CLASS (klass)->constructed = rygel_player_controller_real_constructed;
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_rygel_player_controller_get_property;
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_rygel_player_controller_set_property;
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	G_OBJECT_CLASS (klass)->finalize = rygel_player_controller_finalize;
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYER_CONTROLLER_PLAYER, g_param_spec_object ("player", "player", "player", RYGEL_TYPE_MEDIA_PLAYER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYER_CONTROLLER_PROTOCOL_INFO, g_param_spec_string ("protocol-info", "protocol-info", "protocol-info", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYER_CONTROLLER_PLAYBACK_STATE, g_param_spec_string ("playback-state", "playback-state", "playback-state", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYER_CONTROLLER_N_TRACKS, g_param_spec_uint ("n-tracks", "n-tracks", "n-tracks", 0, G_MAXUINT, (guint) 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYER_CONTROLLER_TRACK, g_param_spec_uint ("track", "track", "track", 0, G_MAXUINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYER_CONTROLLER_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYER_CONTROLLER_METADATA, g_param_spec_string ("metadata", "metadata", "metadata", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_PLAYER_CONTROLLER_CURRENT_TRANSPORT_ACTIONS, g_param_spec_string ("current-transport-actions", "current-transport-actions", "current-transport-actions", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 1550 "rygel-player-controller.c"
}


static void rygel_player_controller_instance_init (RygelPlayerController * self) {
	gchar* _tmp0_;
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	self->priv = RYGEL_PLAYER_CONTROLLER_GET_PRIVATE (self);
#line 65 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	self->priv->_n_tracks = (guint) 0;
#line 71 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_tmp0_ = g_strdup ("");
#line 71 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	self->priv->_uri = _tmp0_;
#line 1564 "rygel-player-controller.c"
}


static void rygel_player_controller_finalize (GObject* obj) {
	RygelPlayerController * self;
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_PLAYER_CONTROLLER, RygelPlayerController);
#line 50 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_g_object_unref0 (self->priv->_player);
#line 51 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_g_free0 (self->priv->_protocol_info);
#line 71 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_g_free0 (self->priv->_uri);
#line 120 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_g_object_unref0 (self->priv->collection);
#line 121 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	__g_list_free__g_object_unref0_0 (self->priv->collection_items);
#line 124 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_g_object_unref0 (self->priv->config);
#line 127 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_g_free0 (self->priv->_metadata);
#line 129 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	_g_free0 (self->priv->_playback_state);
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	G_OBJECT_CLASS (rygel_player_controller_parent_class)->finalize (obj);
#line 1590 "rygel-player-controller.c"
}


/**
 * This class keeps track of global states that are not dependant on the
 * RygelMediaPlayer.
 *
 * These states are:
 * # URI
 * # MetaData
 * # Number of tracks
 * # Current track
 * # Playback state
 *
 * In case of playlists this class will also control the player. It needs to
 * proxy the playback state to react on end of item to be able to switch to
 * the next item.
 */
GType rygel_player_controller_get_type (void) {
	static volatile gsize rygel_player_controller_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_player_controller_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelPlayerControllerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_player_controller_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelPlayerController), 0, (GInstanceInitFunc) rygel_player_controller_instance_init, NULL };
		GType rygel_player_controller_type_id;
		rygel_player_controller_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelPlayerController", &g_define_type_info, 0);
		g_once_init_leave (&rygel_player_controller_type_id__volatile, rygel_player_controller_type_id);
	}
	return rygel_player_controller_type_id__volatile;
}


static void _vala_rygel_player_controller_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelPlayerController * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_PLAYER_CONTROLLER, RygelPlayerController);
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	switch (property_id) {
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		case RYGEL_PLAYER_CONTROLLER_PLAYER:
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		g_value_set_object (value, rygel_player_controller_get_player (self));
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		break;
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		case RYGEL_PLAYER_CONTROLLER_PROTOCOL_INFO:
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		g_value_set_string (value, rygel_player_controller_get_protocol_info (self));
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		break;
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		case RYGEL_PLAYER_CONTROLLER_PLAYBACK_STATE:
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		g_value_set_string (value, rygel_player_controller_get_playback_state (self));
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		break;
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		case RYGEL_PLAYER_CONTROLLER_N_TRACKS:
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		g_value_set_uint (value, rygel_player_controller_get_n_tracks (self));
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		break;
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		case RYGEL_PLAYER_CONTROLLER_TRACK:
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		g_value_set_uint (value, rygel_player_controller_get_track (self));
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		break;
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		case RYGEL_PLAYER_CONTROLLER_URI:
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		g_value_set_string (value, rygel_player_controller_get_uri (self));
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		break;
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		case RYGEL_PLAYER_CONTROLLER_METADATA:
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		g_value_take_string (value, rygel_player_controller_get_metadata (self));
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		break;
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		case RYGEL_PLAYER_CONTROLLER_CURRENT_TRANSPORT_ACTIONS:
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		g_value_take_string (value, rygel_player_controller_get_current_transport_actions (self));
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		break;
#line 1674 "rygel-player-controller.c"
		default:
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		break;
#line 1680 "rygel-player-controller.c"
	}
}


static void _vala_rygel_player_controller_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelPlayerController * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, RYGEL_TYPE_PLAYER_CONTROLLER, RygelPlayerController);
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
	switch (property_id) {
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		case RYGEL_PLAYER_CONTROLLER_PLAYER:
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		rygel_player_controller_set_player (self, g_value_get_object (value));
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		break;
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		case RYGEL_PLAYER_CONTROLLER_PROTOCOL_INFO:
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		rygel_player_controller_set_protocol_info (self, g_value_get_string (value));
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		break;
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		case RYGEL_PLAYER_CONTROLLER_PLAYBACK_STATE:
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		rygel_player_controller_set_playback_state (self, g_value_get_string (value));
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		break;
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		case RYGEL_PLAYER_CONTROLLER_N_TRACKS:
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		rygel_player_controller_set_n_tracks (self, g_value_get_uint (value));
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		break;
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		case RYGEL_PLAYER_CONTROLLER_TRACK:
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		rygel_player_controller_set_track (self, g_value_get_uint (value));
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		break;
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		case RYGEL_PLAYER_CONTROLLER_URI:
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		rygel_player_controller_set_uri (self, g_value_get_string (value));
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		break;
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		case RYGEL_PLAYER_CONTROLLER_METADATA:
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		rygel_player_controller_set_metadata (self, g_value_get_string (value));
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		break;
#line 1732 "rygel-player-controller.c"
		default:
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 38 "/home/jens/Source/rygel/src/librygel-renderer/rygel-player-controller.vala"
		break;
#line 1738 "rygel-player-controller.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



