/* iagno.c generated by valac 0.22.0.17-a7395, the Vala compiler
 * generated from iagno.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <canberra-gtk.h>
#include <canberra.h>
#include <locale.h>


#define TYPE_IAGNO (iagno_get_type ())
#define IAGNO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IAGNO, Iagno))
#define IAGNO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IAGNO, IagnoClass))
#define IS_IAGNO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IAGNO))
#define IS_IAGNO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IAGNO))
#define IAGNO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IAGNO, IagnoClass))

typedef struct _Iagno Iagno;
typedef struct _IagnoClass IagnoClass;
typedef struct _IagnoPrivate IagnoPrivate;

#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;

#define TYPE_COMPUTER_PLAYER (computer_player_get_type ())
#define COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayer))
#define COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))
#define IS_COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPUTER_PLAYER))
#define IS_COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPUTER_PLAYER))
#define COMPUTER_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))

typedef struct _ComputerPlayer ComputerPlayer;
typedef struct _ComputerPlayerClass ComputerPlayerClass;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _computer_player_unref0(var) ((var == NULL) ? NULL : (var = (computer_player_unref (var), NULL)))
#define _game_unref0(var) ((var == NULL) ? NULL : (var = (game_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_PLAYER (player_get_type ())
typedef struct _IagnoShowMessageData IagnoShowMessageData;
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))

struct _Iagno {
	GtkApplication parent_instance;
	IagnoPrivate * priv;
};

struct _IagnoClass {
	GtkApplicationClass parent_class;
};

struct _IagnoPrivate {
	GSettings* settings;
	GtkWindow* window;
	gint window_width;
	gint window_height;
	gboolean is_fullscreen;
	gboolean is_maximized;
	GtkInfoBar* infobar;
	GtkStatusbar* statusbar;
	guint statusbar_id;
	GameView* view;
	GtkLabel* infobar_label;
	GtkLabel* dark_label;
	GtkLabel* light_label;
	GtkLabel* dark_score_label;
	GtkLabel* light_score_label;
	GSimpleAction* undo_action;
	ComputerPlayer* light_computer;
	ComputerPlayer* dark_computer;
	guint computer_timer;
	Game* game;
	gboolean was_pass;
};

typedef enum  {
	PLAYER_NONE,
	PLAYER_LIGHT,
	PLAYER_DARK
} Player;

struct _IagnoShowMessageData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Iagno* self;
	gchar* message;
	GtkMessageType type;
	GtkInfoBar* _tmp0_;
	GtkInfoBar* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GtkInfoBar* _tmp4_;
	GtkMessageType _tmp5_;
	GtkLabel* _tmp6_;
	const gchar* _tmp7_;
	GtkInfoBar* _tmp8_;
};


static gpointer iagno_parent_class = NULL;

GType iagno_get_type (void) G_GNUC_CONST;
GType game_view_get_type (void) G_GNUC_CONST;
gpointer computer_player_ref (gpointer instance);
void computer_player_unref (gpointer instance);
GParamSpec* param_spec_computer_player (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_computer_player (GValue* value, gpointer v_object);
void value_take_computer_player (GValue* value, gpointer v_object);
gpointer value_get_computer_player (const GValue* value);
GType computer_player_get_type (void) G_GNUC_CONST;
gpointer game_ref (gpointer instance);
void game_unref (gpointer instance);
GParamSpec* param_spec_game (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_game (GValue* value, gpointer v_object);
void value_take_game (GValue* value, gpointer v_object);
gpointer value_get_game (const GValue* value);
GType game_get_type (void) G_GNUC_CONST;
#define IAGNO_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_IAGNO, IagnoPrivate))
enum  {
	IAGNO_DUMMY_PROPERTY
};
static void iagno_new_game_cb (Iagno* self);
static void _iagno_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_undo_move_cb (Iagno* self);
static void _iagno_undo_move_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_preferences_cb (Iagno* self);
static void _iagno_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_help_cb (Iagno* self);
static void _iagno_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_about_cb (Iagno* self);
static void _iagno_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_quit_cb (Iagno* self);
static void _iagno_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void iagno_real_startup (GApplication* base);
Iagno* iagno_new (void);
Iagno* iagno_construct (GType object_type);
static void iagno_real_activate (GApplication* base);
static gboolean iagno_window_configure_event_cb (Iagno* self, GdkEventConfigure* event);
static gboolean _iagno_window_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self);
static gboolean iagno_window_state_event_cb (Iagno* self, GdkEventWindowState* event);
static gboolean _iagno_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
GameView* game_view_new (void);
GameView* game_view_construct (GType object_type);
void game_view_set_game (GameView* self, Game* value);
static void iagno_player_move_cb (Iagno* self, gint x, gint y);
static void _iagno_player_move_cb_game_view_move (GameView* _sender, gint x, gint y, gpointer self);
void game_view_set_show_grid (GameView* self, gboolean value);
void game_view_set_flip_final_result (GameView* self, gboolean value);
void game_view_set_theme (GameView* self, const gchar* value);
static void iagno_start_game (Iagno* self);
static void iagno_real_shutdown (GApplication* base);
static void iagno_cancel_pending_computer_moves (Iagno* self);
Game* game_new (gint width, gint height);
Game* game_construct (GType object_type, gint width, gint height);
static void iagno_game_move_cb (Iagno* self, Game* g);
static void _iagno_game_move_cb_game_move (Game* _sender, gpointer self);
static void iagno_game_complete_cb (Iagno* self);
static void _iagno_game_complete_cb_game_complete (Game* _sender, gpointer self);
ComputerPlayer* computer_player_new (Game* game, gint level);
ComputerPlayer* computer_player_construct (GType object_type, Game* game, gint level);
static void iagno_update_ui (Iagno* self);
static gboolean iagno_computer_move_cb (Iagno* self);
static gboolean _iagno_computer_move_cb_gsource_func (gpointer self);
gboolean game_get_can_undo (Game* self);
GType player_get_type (void) G_GNUC_CONST;
Player game_get_current_color (Game* self);
static void iagno_show_message (Iagno* self, const gchar* message, GtkMessageType type, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void iagno_show_message_finish (Iagno* self, GAsyncResult* _res_);
gint game_get_n_dark_tiles (Game* self);
gint game_get_n_light_tiles (Game* self);
void game_undo (Game* self, gint count);
gboolean game_get_can_move (Game* self);
static void iagno_show_preferences_dialog (Iagno* self);
static void iagno_show_message_data_free (gpointer _data);
static gboolean iagno_show_message_co (IagnoShowMessageData* _data_);
static gboolean _iagno_show_message_co_gsource_func (gpointer self);
static void iagno_play_sound (Iagno* self, const gchar* name);
void game_pass (Game* self);
void computer_player_move (ComputerPlayer* self);
gint game_place_tile (Game* self, gint x, gint y);
static void iagno_dark_level_changed_cb (Iagno* self, GtkComboBox* combo);
static void iagno_light_level_changed_cb (Iagno* self, GtkComboBox* combo);
static void iagno_sound_select (Iagno* self, GtkToggleButton* widget);
static void iagno_grid_toggled_cb (Iagno* self, GtkToggleButton* widget);
gboolean game_view_get_show_grid (GameView* self);
static void iagno_flip_final_toggled_cb (Iagno* self, GtkToggleButton* widget);
gboolean game_view_get_flip_final_result (GameView* self);
static void iagno_propbox_response_cb (Iagno* self, GtkWidget* widget, gint response_id);
static gboolean iagno_propbox_close_cb (Iagno* self, GtkWidget* widget, GdkEventAny* event);
static void iagno_theme_changed_cb (Iagno* self, GtkComboBox* widget);
void game_view_redraw (GameView* self);
static void _iagno_propbox_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static gboolean _iagno_propbox_close_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self);
static void _iagno_dark_level_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void _iagno_light_level_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void _iagno_sound_select_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void _iagno_grid_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void _iagno_flip_final_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
static void _iagno_theme_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
gint iagno_main (gchar** args, int args_length1);
static void iagno_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GActionEntry IAGNO_app_actions[6] = {{"new-game", _iagno_new_game_cb_gsimple_action_activate_callback}, {"undo-move", _iagno_undo_move_cb_gsimple_action_activate_callback}, {"preferences", _iagno_preferences_cb_gsimple_action_activate_callback}, {"help", _iagno_help_cb_gsimple_action_activate_callback}, {"about", _iagno_about_cb_gsimple_action_activate_callback}, {"quit", _iagno_quit_cb_gsimple_action_activate_callback}};

static void _iagno_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	iagno_new_game_cb (self);
}


static void _iagno_undo_move_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	iagno_undo_move_cb (self);
}


static void _iagno_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	iagno_preferences_cb (self);
}


static void _iagno_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	iagno_help_cb (self);
}


static void _iagno_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	iagno_about_cb (self);
}


static void _iagno_quit_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	iagno_quit_cb (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void iagno_real_startup (GApplication* base) {
	Iagno * self;
	GAction* _tmp0_ = NULL;
	GSimpleAction* _tmp1_ = NULL;
	self = (Iagno*) base;
	G_APPLICATION_CLASS (iagno_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_APPLICATION, GtkApplication));
	g_action_map_add_action_entries ((GActionMap*) self, IAGNO_app_actions, G_N_ELEMENTS (IAGNO_app_actions), self);
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) self, "undo-move");
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, g_simple_action_get_type ()) ? ((GSimpleAction*) _tmp0_) : NULL);
	_g_object_unref0 (self->priv->undo_action);
	self->priv->undo_action = _tmp1_;
}


Iagno* iagno_construct (GType object_type) {
	Iagno * self = NULL;
	self = (Iagno*) g_object_new (object_type, "application-id", "org.gnome.iagno", "flags", G_APPLICATION_FLAGS_NONE, NULL);
	return self;
}


Iagno* iagno_new (void) {
	return iagno_construct (TYPE_IAGNO);
}


static gboolean _iagno_window_configure_event_cb_gtk_widget_configure_event (GtkWidget* _sender, GdkEventConfigure* event, gpointer self) {
	gboolean result;
	result = iagno_window_configure_event_cb (self, event);
	return result;
}


static gboolean _iagno_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = iagno_window_state_event_cb (self, event);
	return result;
}


static void _iagno_player_move_cb_game_view_move (GameView* _sender, gint x, gint y, gpointer self) {
	iagno_player_move_cb (self, x, y);
}


static void iagno_real_activate (GApplication* base) {
	Iagno * self;
	GtkWindow* _tmp0_ = NULL;
	GSettings* _tmp2_ = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp3_ = NULL;
	GtkBuilder* _tmp8_ = NULL;
	GObject* _tmp9_ = NULL;
	GtkGrid* top_grid = NULL;
	GtkBuilder* _tmp10_ = NULL;
	GObject* _tmp11_ = NULL;
	GtkGrid* _tmp12_ = NULL;
	GtkBuilder* _tmp13_ = NULL;
	GObject* _tmp14_ = NULL;
	GtkWindow* _tmp15_ = NULL;
	GtkWindow* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	GtkWindow* _tmp18_ = NULL;
	GtkWindow* _tmp19_ = NULL;
	GtkWindow* _tmp20_ = NULL;
	GSettings* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	GSettings* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	GSettings* _tmp25_ = NULL;
	gboolean _tmp26_ = FALSE;
	GtkWindow* _tmp31_ = NULL;
	GSimpleAction* _tmp32_ = NULL;
	GameView* _tmp33_ = NULL;
	GameView* _tmp34_ = NULL;
	GameView* _tmp35_ = NULL;
	GameView* _tmp36_ = NULL;
	Game* _tmp37_ = NULL;
	GameView* _tmp38_ = NULL;
	GameView* _tmp39_ = NULL;
	GSettings* _tmp40_ = NULL;
	gboolean _tmp41_ = FALSE;
	GameView* _tmp42_ = NULL;
	GSettings* _tmp43_ = NULL;
	gboolean _tmp44_ = FALSE;
	gchar* tile_set = NULL;
	GSettings* _tmp45_ = NULL;
	gchar* _tmp46_ = NULL;
	GameView* _tmp47_ = NULL;
	const gchar* _tmp48_ = NULL;
	gchar* _tmp49_ = NULL;
	gchar* _tmp50_ = NULL;
	GameView* _tmp51_ = NULL;
	GtkGrid* _tmp52_ = NULL;
	GameView* _tmp53_ = NULL;
	GtkInfoBar* _tmp54_ = NULL;
	GtkGrid* _tmp55_ = NULL;
	GtkInfoBar* _tmp56_ = NULL;
	GtkLabel* _tmp57_ = NULL;
	GtkLabel* _tmp58_ = NULL;
	GtkInfoBar* _tmp59_ = NULL;
	GtkLabel* _tmp60_ = NULL;
	GtkStatusbar* _tmp61_ = NULL;
	GtkStatusbar* _tmp62_ = NULL;
	GtkToolbar* toolbar = NULL;
	GtkBuilder* _tmp63_ = NULL;
	GObject* _tmp64_ = NULL;
	GtkToolbar* _tmp65_ = NULL;
	GtkToolbar* _tmp66_ = NULL;
	GtkToolbar* _tmp67_ = NULL;
	GtkStyleContext* _tmp68_ = NULL;
	GtkToolbar* _tmp69_ = NULL;
	GtkSeparatorToolItem* _tmp70_ = NULL;
	GtkSeparatorToolItem* _tmp71_ = NULL;
	GtkToolItem* status_item = NULL;
	GtkToolItem* _tmp72_ = NULL;
	GtkToolItem* _tmp73_ = NULL;
	GtkToolItem* _tmp74_ = NULL;
	GtkAlignment* status_alignment = NULL;
	GtkAlignment* _tmp75_ = NULL;
	GtkAlignment* _tmp76_ = NULL;
	GtkStatusbar* _tmp77_ = NULL;
	GtkToolItem* _tmp78_ = NULL;
	GtkAlignment* _tmp79_ = NULL;
	GtkToolbar* _tmp80_ = NULL;
	GtkToolItem* _tmp81_ = NULL;
	GtkToolbar* _tmp82_ = NULL;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp83_ = NULL;
	GtkGrid* _tmp84_ = NULL;
	GtkGrid* _tmp85_ = NULL;
	GtkStatusbar* _tmp86_ = NULL;
	GtkGrid* _tmp87_ = NULL;
	const gchar* _tmp88_ = NULL;
	GtkLabel* _tmp89_ = NULL;
	GtkLabel* _tmp90_ = NULL;
	GtkGrid* _tmp91_ = NULL;
	GtkLabel* _tmp92_ = NULL;
	GtkLabel* _tmp93_ = NULL;
	GtkLabel* _tmp94_ = NULL;
	GtkGrid* _tmp95_ = NULL;
	GtkLabel* _tmp96_ = NULL;
	const gchar* _tmp97_ = NULL;
	GtkLabel* _tmp98_ = NULL;
	GtkLabel* _tmp99_ = NULL;
	GtkGrid* _tmp100_ = NULL;
	GtkLabel* _tmp101_ = NULL;
	GtkLabel* _tmp102_ = NULL;
	GtkLabel* _tmp103_ = NULL;
	GtkGrid* _tmp104_ = NULL;
	GtkLabel* _tmp105_ = NULL;
	GtkStatusbar* _tmp106_ = NULL;
	guint _tmp107_ = 0U;
	GtkWindow* _tmp108_ = NULL;
	GError * _inner_error_ = NULL;
	self = (Iagno*) base;
	_tmp0_ = self->priv->window;
	if (_tmp0_ != NULL) {
		GtkWindow* _tmp1_ = NULL;
		_tmp1_ = self->priv->window;
		gtk_widget_show ((GtkWidget*) _tmp1_);
		return;
	}
	_tmp2_ = g_settings_new ("org.gnome.iagno");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp2_;
	_tmp3_ = gtk_builder_new ();
	builder = _tmp3_;
	{
		GtkBuilder* _tmp4_ = NULL;
		_tmp4_ = builder;
		gtk_builder_add_from_file (_tmp4_, DATA_DIRECTORY "/iagno.ui", &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		FILE* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = stderr;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		fprintf (_tmp5_, "Could not load UI: %s\n", _tmp7_);
		_g_error_free0 (e);
		_g_object_unref0 (builder);
		return;
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (builder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp8_ = builder;
	_tmp9_ = gtk_builder_get_object (_tmp8_, "iagno-menu");
	gtk_application_set_app_menu ((GtkApplication*) self, G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, g_menu_model_get_type ()) ? ((GMenuModel*) _tmp9_) : NULL);
	_tmp10_ = builder;
	_tmp11_ = gtk_builder_get_object (_tmp10_, "grid");
	_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, GTK_TYPE_GRID) ? ((GtkGrid*) _tmp11_) : NULL);
	top_grid = _tmp12_;
	_tmp13_ = builder;
	_tmp14_ = gtk_builder_get_object (_tmp13_, "window");
	_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, GTK_TYPE_WINDOW) ? ((GtkWindow*) _tmp14_) : NULL);
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp15_;
	_tmp16_ = self->priv->window;
	_tmp17_ = _ ("Iagno");
	gtk_window_set_title (_tmp16_, _tmp17_);
	_tmp18_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp18_, "configure-event", (GCallback) _iagno_window_configure_event_cb_gtk_widget_configure_event, self, 0);
	_tmp19_ = self->priv->window;
	g_signal_connect_object ((GtkWidget*) _tmp19_, "window-state-event", (GCallback) _iagno_window_state_event_cb_gtk_widget_window_state_event, self, 0);
	_tmp20_ = self->priv->window;
	_tmp21_ = self->priv->settings;
	_tmp22_ = g_settings_get_int (_tmp21_, "window-width");
	_tmp23_ = self->priv->settings;
	_tmp24_ = g_settings_get_int (_tmp23_, "window-height");
	gtk_window_set_default_size (_tmp20_, _tmp22_, _tmp24_);
	_tmp25_ = self->priv->settings;
	_tmp26_ = g_settings_get_boolean (_tmp25_, "window-is-fullscreen");
	if (_tmp26_) {
		GtkWindow* _tmp27_ = NULL;
		_tmp27_ = self->priv->window;
		gtk_window_fullscreen (_tmp27_);
	} else {
		GSettings* _tmp28_ = NULL;
		gboolean _tmp29_ = FALSE;
		_tmp28_ = self->priv->settings;
		_tmp29_ = g_settings_get_boolean (_tmp28_, "window-is-maximized");
		if (_tmp29_) {
			GtkWindow* _tmp30_ = NULL;
			_tmp30_ = self->priv->window;
			gtk_window_maximize (_tmp30_);
		}
	}
	_tmp31_ = self->priv->window;
	gtk_application_add_window ((GtkApplication*) self, _tmp31_);
	_tmp32_ = self->priv->undo_action;
	g_simple_action_set_enabled (_tmp32_, TRUE);
	_tmp33_ = game_view_new ();
	g_object_ref_sink (_tmp33_);
	_g_object_unref0 (self->priv->view);
	self->priv->view = _tmp33_;
	_tmp34_ = self->priv->view;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp34_, TRUE);
	_tmp35_ = self->priv->view;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp35_, TRUE);
	_tmp36_ = self->priv->view;
	_tmp37_ = self->priv->game;
	game_view_set_game (_tmp36_, _tmp37_);
	_tmp38_ = self->priv->view;
	g_signal_connect_object (_tmp38_, "move", (GCallback) _iagno_player_move_cb_game_view_move, self, 0);
	_tmp39_ = self->priv->view;
	_tmp40_ = self->priv->settings;
	_tmp41_ = g_settings_get_boolean (_tmp40_, "show-grid");
	game_view_set_show_grid (_tmp39_, _tmp41_);
	_tmp42_ = self->priv->view;
	_tmp43_ = self->priv->settings;
	_tmp44_ = g_settings_get_boolean (_tmp43_, "flip-final-results");
	game_view_set_flip_final_result (_tmp42_, _tmp44_);
	_tmp45_ = self->priv->settings;
	_tmp46_ = g_settings_get_string (_tmp45_, "tileset");
	tile_set = _tmp46_;
	_tmp47_ = self->priv->view;
	_tmp48_ = tile_set;
	_tmp49_ = g_build_filename (DATA_DIRECTORY, "themes", _tmp48_, NULL);
	_tmp50_ = _tmp49_;
	game_view_set_theme (_tmp47_, _tmp50_);
	_g_free0 (_tmp50_);
	_tmp51_ = self->priv->view;
	gtk_widget_show ((GtkWidget*) _tmp51_);
	_tmp52_ = top_grid;
	_tmp53_ = self->priv->view;
	gtk_grid_attach (_tmp52_, (GtkWidget*) _tmp53_, 0, 3, 1, 1);
	_tmp54_ = (GtkInfoBar*) gtk_info_bar_new ();
	g_object_ref_sink (_tmp54_);
	_g_object_unref0 (self->priv->infobar);
	self->priv->infobar = _tmp54_;
	_tmp55_ = top_grid;
	_tmp56_ = self->priv->infobar;
	gtk_grid_attach (_tmp55_, (GtkWidget*) _tmp56_, 0, 2, 1, 1);
	_tmp57_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp57_);
	_g_object_unref0 (self->priv->infobar_label);
	self->priv->infobar_label = _tmp57_;
	_tmp58_ = self->priv->infobar_label;
	gtk_widget_show ((GtkWidget*) _tmp58_);
	_tmp59_ = self->priv->infobar;
	_tmp60_ = self->priv->infobar_label;
	gtk_container_add ((GtkContainer*) _tmp59_, (GtkWidget*) _tmp60_);
	_tmp61_ = (GtkStatusbar*) gtk_statusbar_new ();
	g_object_ref_sink (_tmp61_);
	_g_object_unref0 (self->priv->statusbar);
	self->priv->statusbar = _tmp61_;
	_tmp62_ = self->priv->statusbar;
	gtk_widget_show ((GtkWidget*) _tmp62_);
	_tmp63_ = builder;
	_tmp64_ = gtk_builder_get_object (_tmp63_, "toolbar");
	_tmp65_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp64_, GTK_TYPE_TOOLBAR) ? ((GtkToolbar*) _tmp64_) : NULL);
	toolbar = _tmp65_;
	_tmp66_ = toolbar;
	gtk_toolbar_set_show_arrow (_tmp66_, FALSE);
	_tmp67_ = toolbar;
	_tmp68_ = gtk_widget_get_style_context ((GtkWidget*) _tmp67_);
	gtk_style_context_add_class (_tmp68_, GTK_STYLE_CLASS_PRIMARY_TOOLBAR);
	_tmp69_ = toolbar;
	_tmp70_ = (GtkSeparatorToolItem*) gtk_separator_tool_item_new ();
	g_object_ref_sink (_tmp70_);
	_tmp71_ = _tmp70_;
	gtk_toolbar_insert (_tmp69_, (GtkToolItem*) _tmp71_, -1);
	_g_object_unref0 (_tmp71_);
	_tmp72_ = gtk_tool_item_new ();
	g_object_ref_sink (_tmp72_);
	status_item = _tmp72_;
	_tmp73_ = status_item;
	gtk_tool_item_set_visible_horizontal (_tmp73_, TRUE);
	_tmp74_ = status_item;
	gtk_tool_item_set_expand (_tmp74_, TRUE);
	_tmp75_ = (GtkAlignment*) gtk_alignment_new (1.0f, 0.5f, 0.0f, 0.0f);
	g_object_ref_sink (_tmp75_);
	status_alignment = _tmp75_;
	_tmp76_ = status_alignment;
	_tmp77_ = self->priv->statusbar;
	gtk_container_add ((GtkContainer*) _tmp76_, (GtkWidget*) _tmp77_);
	_tmp78_ = status_item;
	_tmp79_ = status_alignment;
	gtk_container_add ((GtkContainer*) _tmp78_, (GtkWidget*) _tmp79_);
	_tmp80_ = toolbar;
	_tmp81_ = status_item;
	gtk_toolbar_insert (_tmp80_, _tmp81_, -1);
	_tmp82_ = toolbar;
	gtk_widget_show_all ((GtkWidget*) _tmp82_);
	_tmp83_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp83_);
	grid = _tmp83_;
	_tmp84_ = grid;
	gtk_grid_set_column_spacing (_tmp84_, (guint) 6);
	_tmp85_ = grid;
	gtk_widget_show ((GtkWidget*) _tmp85_);
	_tmp86_ = self->priv->statusbar;
	_tmp87_ = grid;
	gtk_box_pack_start ((GtkBox*) _tmp86_, (GtkWidget*) _tmp87_, FALSE, TRUE, (guint) 0);
	_tmp88_ = _ ("Dark:");
	_tmp89_ = (GtkLabel*) gtk_label_new (_tmp88_);
	g_object_ref_sink (_tmp89_);
	_g_object_unref0 (self->priv->dark_label);
	self->priv->dark_label = _tmp89_;
	_tmp90_ = self->priv->dark_label;
	gtk_widget_show ((GtkWidget*) _tmp90_);
	_tmp91_ = grid;
	_tmp92_ = self->priv->dark_label;
	gtk_grid_attach (_tmp91_, (GtkWidget*) _tmp92_, 1, 0, 1, 1);
	_tmp93_ = (GtkLabel*) gtk_label_new ("00");
	g_object_ref_sink (_tmp93_);
	_g_object_unref0 (self->priv->dark_score_label);
	self->priv->dark_score_label = _tmp93_;
	_tmp94_ = self->priv->dark_score_label;
	gtk_widget_show ((GtkWidget*) _tmp94_);
	_tmp95_ = grid;
	_tmp96_ = self->priv->dark_score_label;
	gtk_grid_attach (_tmp95_, (GtkWidget*) _tmp96_, 2, 0, 1, 1);
	_tmp97_ = _ ("Light:");
	_tmp98_ = (GtkLabel*) gtk_label_new (_tmp97_);
	g_object_ref_sink (_tmp98_);
	_g_object_unref0 (self->priv->light_label);
	self->priv->light_label = _tmp98_;
	_tmp99_ = self->priv->light_label;
	gtk_widget_show ((GtkWidget*) _tmp99_);
	_tmp100_ = grid;
	_tmp101_ = self->priv->light_label;
	gtk_grid_attach (_tmp100_, (GtkWidget*) _tmp101_, 4, 0, 1, 1);
	_tmp102_ = (GtkLabel*) gtk_label_new ("00");
	g_object_ref_sink (_tmp102_);
	_g_object_unref0 (self->priv->light_score_label);
	self->priv->light_score_label = _tmp102_;
	_tmp103_ = self->priv->light_score_label;
	gtk_widget_show ((GtkWidget*) _tmp103_);
	_tmp104_ = grid;
	_tmp105_ = self->priv->light_score_label;
	gtk_grid_attach (_tmp104_, (GtkWidget*) _tmp105_, 5, 0, 1, 1);
	_tmp106_ = self->priv->statusbar;
	_tmp107_ = gtk_statusbar_get_context_id (_tmp106_, "iagno");
	self->priv->statusbar_id = _tmp107_;
	iagno_start_game (self);
	_tmp108_ = self->priv->window;
	gtk_widget_show ((GtkWidget*) _tmp108_);
	_g_object_unref0 (grid);
	_g_object_unref0 (status_alignment);
	_g_object_unref0 (status_item);
	_g_object_unref0 (toolbar);
	_g_free0 (tile_set);
	_g_object_unref0 (top_grid);
	_g_object_unref0 (builder);
}


static void iagno_real_shutdown (GApplication* base) {
	Iagno * self;
	GSettings* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GSettings* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GSettings* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	self = (Iagno*) base;
	G_APPLICATION_CLASS (iagno_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, GTK_TYPE_APPLICATION, GtkApplication));
	_tmp0_ = self->priv->settings;
	_tmp1_ = self->priv->window_width;
	g_settings_set_int (_tmp0_, "window-width", _tmp1_);
	_tmp2_ = self->priv->settings;
	_tmp3_ = self->priv->window_height;
	g_settings_set_int (_tmp2_, "window-height", _tmp3_);
	_tmp4_ = self->priv->settings;
	_tmp5_ = self->priv->is_maximized;
	g_settings_set_boolean (_tmp4_, "window-is-maximized", _tmp5_);
	_tmp6_ = self->priv->settings;
	_tmp7_ = self->priv->is_fullscreen;
	g_settings_set_boolean (_tmp6_, "window-is-fullscreen", _tmp7_);
}


static gboolean iagno_window_configure_event_cb (Iagno* self, GdkEventConfigure* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = self->priv->is_maximized;
	if (!_tmp1_) {
		gboolean _tmp2_ = FALSE;
		_tmp2_ = self->priv->is_fullscreen;
		_tmp0_ = !_tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		GdkEventConfigure _tmp4_ = {0};
		gint _tmp5_ = 0;
		GdkEventConfigure _tmp6_ = {0};
		gint _tmp7_ = 0;
		_tmp4_ = *event;
		_tmp5_ = _tmp4_.width;
		self->priv->window_width = _tmp5_;
		_tmp6_ = *event;
		_tmp7_ = _tmp6_.height;
		self->priv->window_height = _tmp7_;
	}
	result = FALSE;
	return result;
}


static gboolean iagno_window_state_event_cb (Iagno* self, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState _tmp0_ = {0};
	GdkWindowState _tmp1_ = 0;
	GdkEventWindowState _tmp4_ = {0};
	GdkWindowState _tmp5_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = *event;
	_tmp1_ = _tmp0_.changed_mask;
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
		GdkEventWindowState _tmp2_ = {0};
		GdkWindowState _tmp3_ = 0;
		_tmp2_ = *event;
		_tmp3_ = _tmp2_.new_window_state;
		self->priv->is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
	}
	_tmp4_ = *event;
	_tmp5_ = _tmp4_.changed_mask;
	if ((_tmp5_ & GDK_WINDOW_STATE_FULLSCREEN) != 0) {
		GdkEventWindowState _tmp6_ = {0};
		GdkWindowState _tmp7_ = 0;
		_tmp6_ = *event;
		_tmp7_ = _tmp6_.new_window_state;
		self->priv->is_fullscreen = (_tmp7_ & GDK_WINDOW_STATE_FULLSCREEN) != 0;
	}
	result = FALSE;
	return result;
}


static void iagno_quit_cb (Iagno* self) {
	GtkWindow* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->window;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}


static void iagno_new_game_cb (Iagno* self) {
	g_return_if_fail (self != NULL);
	iagno_start_game (self);
}


static void _iagno_game_move_cb_game_move (Game* _sender, gpointer self) {
	iagno_game_move_cb (self, _sender);
}


static void _iagno_game_complete_cb_game_complete (Game* _sender, gpointer self) {
	iagno_game_complete_cb (self);
}


static gboolean _iagno_computer_move_cb_gsource_func (gpointer self) {
	gboolean result;
	result = iagno_computer_move_cb (self);
	return result;
}


static void iagno_start_game (Iagno* self) {
	Game* _tmp0_ = NULL;
	Game* _tmp2_ = NULL;
	Game* _tmp3_ = NULL;
	Game* _tmp4_ = NULL;
	GameView* _tmp5_ = NULL;
	Game* _tmp6_ = NULL;
	gint dark_level = 0;
	GSettings* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint light_level = 0;
	GSettings* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	ComputerPlayer* _tmp19_ = NULL;
	g_return_if_fail (self != NULL);
	iagno_cancel_pending_computer_moves (self);
	_tmp0_ = self->priv->game;
	if (_tmp0_ != NULL) {
		Game* _tmp1_ = NULL;
		_tmp1_ = self->priv->game;
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
	}
	_tmp2_ = game_new (8, 8);
	_game_unref0 (self->priv->game);
	self->priv->game = _tmp2_;
	_tmp3_ = self->priv->game;
	g_signal_connect_object (_tmp3_, "move", (GCallback) _iagno_game_move_cb_game_move, self, 0);
	_tmp4_ = self->priv->game;
	g_signal_connect_object (_tmp4_, "complete", (GCallback) _iagno_game_complete_cb_game_complete, self, 0);
	_tmp5_ = self->priv->view;
	_tmp6_ = self->priv->game;
	game_view_set_game (_tmp5_, _tmp6_);
	_tmp7_ = self->priv->settings;
	_tmp8_ = g_settings_get_int (_tmp7_, "black-level");
	dark_level = _tmp8_;
	_tmp9_ = dark_level;
	if (_tmp9_ > 0) {
		Game* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		ComputerPlayer* _tmp12_ = NULL;
		_tmp10_ = self->priv->game;
		_tmp11_ = dark_level;
		_tmp12_ = computer_player_new (_tmp10_, _tmp11_);
		_computer_player_unref0 (self->priv->dark_computer);
		self->priv->dark_computer = _tmp12_;
	} else {
		_computer_player_unref0 (self->priv->dark_computer);
		self->priv->dark_computer = NULL;
	}
	_tmp13_ = self->priv->settings;
	_tmp14_ = g_settings_get_int (_tmp13_, "white-level");
	light_level = _tmp14_;
	_tmp15_ = light_level;
	if (_tmp15_ > 0) {
		Game* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		ComputerPlayer* _tmp18_ = NULL;
		_tmp16_ = self->priv->game;
		_tmp17_ = light_level;
		_tmp18_ = computer_player_new (_tmp16_, _tmp17_);
		_computer_player_unref0 (self->priv->light_computer);
		self->priv->light_computer = _tmp18_;
	} else {
		_computer_player_unref0 (self->priv->light_computer);
		self->priv->light_computer = NULL;
	}
	iagno_update_ui (self);
	_tmp19_ = self->priv->dark_computer;
	if (_tmp19_ != NULL) {
		guint _tmp20_ = 0U;
		_tmp20_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 1000, _iagno_computer_move_cb_gsource_func, g_object_ref (self), g_object_unref);
		self->priv->computer_timer = _tmp20_;
	}
}


static void iagno_update_ui (Iagno* self) {
	GtkInfoBar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	ComputerPlayer* _tmp2_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp10_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->infobar;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	_tmp2_ = self->priv->light_computer;
	if (_tmp2_ != NULL) {
		ComputerPlayer* _tmp3_ = NULL;
		_tmp3_ = self->priv->dark_computer;
		_tmp1_ = _tmp3_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp4_ = _tmp1_;
	if (_tmp4_) {
		GSimpleAction* _tmp5_ = NULL;
		_tmp5_ = self->priv->undo_action;
		g_simple_action_set_enabled (_tmp5_, FALSE);
	} else {
		GSimpleAction* _tmp6_ = NULL;
		Game* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		_tmp6_ = self->priv->undo_action;
		_tmp7_ = self->priv->game;
		_tmp8_ = game_get_can_undo (_tmp7_);
		_tmp9_ = _tmp8_;
		g_simple_action_set_enabled (_tmp6_, _tmp9_);
	}
	_tmp10_ = self->priv->was_pass;
	if (_tmp10_) {
		Game* _tmp11_ = NULL;
		Player _tmp12_ = 0;
		Player _tmp13_ = 0;
		_tmp11_ = self->priv->game;
		_tmp12_ = game_get_current_color (_tmp11_);
		_tmp13_ = _tmp12_;
		if (_tmp13_ == PLAYER_DARK) {
			const gchar* _tmp14_ = NULL;
			_tmp14_ = _ ("Light must pass, Dark's move");
			iagno_show_message (self, _tmp14_, GTK_MESSAGE_INFO, NULL, NULL);
		} else {
			const gchar* _tmp15_ = NULL;
			_tmp15_ = _ ("Dark must pass, Light's move");
			iagno_show_message (self, _tmp15_, GTK_MESSAGE_INFO, NULL, NULL);
		}
	} else {
		Game* _tmp16_ = NULL;
		Player _tmp17_ = 0;
		Player _tmp18_ = 0;
		_tmp16_ = self->priv->game;
		_tmp17_ = game_get_current_color (_tmp16_);
		_tmp18_ = _tmp17_;
		if (_tmp18_ == PLAYER_DARK) {
			GtkLabel* _tmp19_ = NULL;
			const gchar* _tmp20_ = NULL;
			gchar* _tmp21_ = NULL;
			gchar* _tmp22_ = NULL;
			gchar* _tmp23_ = NULL;
			gchar* _tmp24_ = NULL;
			GtkLabel* _tmp25_ = NULL;
			const gchar* _tmp26_ = NULL;
			gchar* _tmp27_ = NULL;
			gchar* _tmp28_ = NULL;
			gchar* _tmp29_ = NULL;
			gchar* _tmp30_ = NULL;
			GtkLabel* _tmp31_ = NULL;
			const gchar* _tmp32_ = NULL;
			Game* _tmp33_ = NULL;
			gint _tmp34_ = 0;
			gint _tmp35_ = 0;
			gchar* _tmp36_ = NULL;
			gchar* _tmp37_ = NULL;
			gchar* _tmp38_ = NULL;
			gchar* _tmp39_ = NULL;
			gchar* _tmp40_ = NULL;
			gchar* _tmp41_ = NULL;
			GtkLabel* _tmp42_ = NULL;
			const gchar* _tmp43_ = NULL;
			Game* _tmp44_ = NULL;
			gint _tmp45_ = 0;
			gint _tmp46_ = 0;
			gchar* _tmp47_ = NULL;
			gchar* _tmp48_ = NULL;
			gchar* _tmp49_ = NULL;
			gchar* _tmp50_ = NULL;
			gchar* _tmp51_ = NULL;
			gchar* _tmp52_ = NULL;
			_tmp19_ = self->priv->dark_label;
			_tmp20_ = _ ("Dark:");
			_tmp21_ = g_strconcat ("<span font_weight='bold'>", _tmp20_, NULL);
			_tmp22_ = _tmp21_;
			_tmp23_ = g_strconcat (_tmp22_, "</span>", NULL);
			_tmp24_ = _tmp23_;
			gtk_label_set_markup (_tmp19_, _tmp24_);
			_g_free0 (_tmp24_);
			_g_free0 (_tmp22_);
			_tmp25_ = self->priv->light_label;
			_tmp26_ = _ ("Light:");
			_tmp27_ = g_strconcat ("<span font_weight='normal'>", _tmp26_, NULL);
			_tmp28_ = _tmp27_;
			_tmp29_ = g_strconcat (_tmp28_, "</span>", NULL);
			_tmp30_ = _tmp29_;
			gtk_label_set_markup (_tmp25_, _tmp30_);
			_g_free0 (_tmp30_);
			_g_free0 (_tmp28_);
			_tmp31_ = self->priv->dark_score_label;
			_tmp32_ = _ ("%.2d");
			_tmp33_ = self->priv->game;
			_tmp34_ = game_get_n_dark_tiles (_tmp33_);
			_tmp35_ = _tmp34_;
			_tmp36_ = g_strdup_printf (_tmp32_, _tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = g_strconcat ("<span font_weight='bold'>", _tmp37_, NULL);
			_tmp39_ = _tmp38_;
			_tmp40_ = g_strconcat (_tmp39_, "</span>", NULL);
			_tmp41_ = _tmp40_;
			gtk_label_set_markup (_tmp31_, _tmp41_);
			_g_free0 (_tmp41_);
			_g_free0 (_tmp39_);
			_g_free0 (_tmp37_);
			_tmp42_ = self->priv->light_score_label;
			_tmp43_ = _ ("%.2d");
			_tmp44_ = self->priv->game;
			_tmp45_ = game_get_n_light_tiles (_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = g_strdup_printf (_tmp43_, _tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = g_strconcat ("<span font_weight='normal'>", _tmp48_, NULL);
			_tmp50_ = _tmp49_;
			_tmp51_ = g_strconcat (_tmp50_, "</span>", NULL);
			_tmp52_ = _tmp51_;
			gtk_label_set_markup (_tmp42_, _tmp52_);
			_g_free0 (_tmp52_);
			_g_free0 (_tmp50_);
			_g_free0 (_tmp48_);
		} else {
			Game* _tmp53_ = NULL;
			Player _tmp54_ = 0;
			Player _tmp55_ = 0;
			_tmp53_ = self->priv->game;
			_tmp54_ = game_get_current_color (_tmp53_);
			_tmp55_ = _tmp54_;
			if (_tmp55_ == PLAYER_LIGHT) {
				GtkLabel* _tmp56_ = NULL;
				const gchar* _tmp57_ = NULL;
				gchar* _tmp58_ = NULL;
				gchar* _tmp59_ = NULL;
				gchar* _tmp60_ = NULL;
				gchar* _tmp61_ = NULL;
				GtkLabel* _tmp62_ = NULL;
				const gchar* _tmp63_ = NULL;
				gchar* _tmp64_ = NULL;
				gchar* _tmp65_ = NULL;
				gchar* _tmp66_ = NULL;
				gchar* _tmp67_ = NULL;
				GtkLabel* _tmp68_ = NULL;
				const gchar* _tmp69_ = NULL;
				Game* _tmp70_ = NULL;
				gint _tmp71_ = 0;
				gint _tmp72_ = 0;
				gchar* _tmp73_ = NULL;
				gchar* _tmp74_ = NULL;
				gchar* _tmp75_ = NULL;
				gchar* _tmp76_ = NULL;
				gchar* _tmp77_ = NULL;
				gchar* _tmp78_ = NULL;
				GtkLabel* _tmp79_ = NULL;
				const gchar* _tmp80_ = NULL;
				Game* _tmp81_ = NULL;
				gint _tmp82_ = 0;
				gint _tmp83_ = 0;
				gchar* _tmp84_ = NULL;
				gchar* _tmp85_ = NULL;
				gchar* _tmp86_ = NULL;
				gchar* _tmp87_ = NULL;
				gchar* _tmp88_ = NULL;
				gchar* _tmp89_ = NULL;
				_tmp56_ = self->priv->dark_label;
				_tmp57_ = _ ("Dark:");
				_tmp58_ = g_strconcat ("<span font_weight='normal'>", _tmp57_, NULL);
				_tmp59_ = _tmp58_;
				_tmp60_ = g_strconcat (_tmp59_, "</span>", NULL);
				_tmp61_ = _tmp60_;
				gtk_label_set_markup (_tmp56_, _tmp61_);
				_g_free0 (_tmp61_);
				_g_free0 (_tmp59_);
				_tmp62_ = self->priv->light_label;
				_tmp63_ = _ ("Light:");
				_tmp64_ = g_strconcat ("<span font_weight='bold'>", _tmp63_, NULL);
				_tmp65_ = _tmp64_;
				_tmp66_ = g_strconcat (_tmp65_, "</span>", NULL);
				_tmp67_ = _tmp66_;
				gtk_label_set_markup (_tmp62_, _tmp67_);
				_g_free0 (_tmp67_);
				_g_free0 (_tmp65_);
				_tmp68_ = self->priv->dark_score_label;
				_tmp69_ = _ ("%.2d");
				_tmp70_ = self->priv->game;
				_tmp71_ = game_get_n_dark_tiles (_tmp70_);
				_tmp72_ = _tmp71_;
				_tmp73_ = g_strdup_printf (_tmp69_, _tmp72_);
				_tmp74_ = _tmp73_;
				_tmp75_ = g_strconcat ("<span font_weight='normal'>", _tmp74_, NULL);
				_tmp76_ = _tmp75_;
				_tmp77_ = g_strconcat (_tmp76_, "</span>", NULL);
				_tmp78_ = _tmp77_;
				gtk_label_set_markup (_tmp68_, _tmp78_);
				_g_free0 (_tmp78_);
				_g_free0 (_tmp76_);
				_g_free0 (_tmp74_);
				_tmp79_ = self->priv->light_score_label;
				_tmp80_ = _ ("%.2d");
				_tmp81_ = self->priv->game;
				_tmp82_ = game_get_n_light_tiles (_tmp81_);
				_tmp83_ = _tmp82_;
				_tmp84_ = g_strdup_printf (_tmp80_, _tmp83_);
				_tmp85_ = _tmp84_;
				_tmp86_ = g_strconcat ("<span font_weight='bold'>", _tmp85_, NULL);
				_tmp87_ = _tmp86_;
				_tmp88_ = g_strconcat (_tmp87_, "</span>", NULL);
				_tmp89_ = _tmp88_;
				gtk_label_set_markup (_tmp79_, _tmp89_);
				_g_free0 (_tmp89_);
				_g_free0 (_tmp87_);
				_g_free0 (_tmp85_);
			}
		}
	}
}


static void iagno_undo_move_cb (Iagno* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Game* _tmp2_ = NULL;
	Player _tmp3_ = 0;
	Player _tmp4_ = 0;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp13_ = FALSE;
	Game* _tmp20_ = NULL;
	g_return_if_fail (self != NULL);
	iagno_cancel_pending_computer_moves (self);
	_tmp2_ = self->priv->game;
	_tmp3_ = game_get_current_color (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == PLAYER_DARK) {
		ComputerPlayer* _tmp5_ = NULL;
		_tmp5_ = self->priv->dark_computer;
		_tmp1_ = _tmp5_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp6_ = _tmp1_;
	if (_tmp6_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp7_ = FALSE;
		Game* _tmp8_ = NULL;
		Player _tmp9_ = 0;
		Player _tmp10_ = 0;
		gboolean _tmp12_ = FALSE;
		_tmp8_ = self->priv->game;
		_tmp9_ = game_get_current_color (_tmp8_);
		_tmp10_ = _tmp9_;
		if (_tmp10_ == PLAYER_LIGHT) {
			ComputerPlayer* _tmp11_ = NULL;
			_tmp11_ = self->priv->light_computer;
			_tmp7_ = _tmp11_ != NULL;
		} else {
			_tmp7_ = FALSE;
		}
		_tmp12_ = _tmp7_;
		_tmp0_ = _tmp12_;
	}
	_tmp13_ = _tmp0_;
	if (_tmp13_) {
		Game* _tmp14_ = NULL;
		_tmp14_ = self->priv->game;
		game_undo (_tmp14_, 1);
	} else {
		Game* _tmp15_ = NULL;
		_tmp15_ = self->priv->game;
		game_undo (_tmp15_, 2);
	}
	while (TRUE) {
		Game* _tmp16_ = NULL;
		gboolean _tmp17_ = FALSE;
		gboolean _tmp18_ = FALSE;
		Game* _tmp19_ = NULL;
		_tmp16_ = self->priv->game;
		_tmp17_ = game_get_can_move (_tmp16_);
		_tmp18_ = _tmp17_;
		if (!(!_tmp18_)) {
			break;
		}
		_tmp19_ = self->priv->game;
		game_undo (_tmp19_, 2);
	}
	_tmp20_ = self->priv->game;
	iagno_game_move_cb (self, _tmp20_);
}


static void iagno_about_cb (Iagno* self) {
	gchar** authors = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint authors_length1 = 0;
	gint _authors_size_ = 0;
	gchar** documenters = NULL;
	gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint documenters_length1 = 0;
	gint _documenters_size_ = 0;
	gchar* license = NULL;
	gchar* _tmp5_ = NULL;
	GtkWindow* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("Ian Peters");
	_tmp1_ = g_strdup ("Robert Ancell");
	_tmp2_ = g_new0 (gchar*, 3 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	_tmp2_[2] = NULL;
	authors = _tmp2_;
	authors_length1 = 3;
	_authors_size_ = authors_length1;
	_tmp3_ = g_strdup ("Eric Baudais");
	_tmp4_ = g_new0 (gchar*, 2 + 1);
	_tmp4_[0] = _tmp3_;
	_tmp4_[1] = NULL;
	documenters = _tmp4_;
	documenters_length1 = 2;
	_documenters_size_ = documenters_length1;
	_tmp5_ = g_strdup ("Iagno is free software; you can redistribute it and/or modify it under" \
" the terms of the GNU General Public License as published by the Free " \
"Software Foundation; either version 2 of the License, or (at your opti" \
"on) any later version.\n" \
"\n" \
"Iagno is distributed in the hope that it will be useful, but WITHOUT A" \
"NY WARRANTY; without even the implied warranty of MERCHANTABILITY or F" \
"ITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License fo" \
"r more details.\n" \
"\n" \
"You should have received a copy of the GNU General Public License alon" \
"g with Iagno; if not, write to the Free Software Foundation, Inc., 51 " \
"Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA");
	license = _tmp5_;
	_tmp6_ = self->priv->window;
	_tmp7_ = _ ("Iagno");
	_tmp8_ = _ ("A disk flipping game derived from Reversi.\n" \
"\n" \
"Iagno is a part of GNOME Games.");
	_tmp9_ = _ ("translator-credits");
	_tmp10_ = _ ("GNOME Games web site");
	gtk_show_about_dialog (_tmp6_, "name", _tmp7_, "version", VERSION, "copyright", "Copyright \xc2\xa9 1998-2008 Ian Peters", "license", license, "comments", _tmp8_, "authors", authors, "documenters", documenters, "translator-credits", _tmp9_, "logo-icon-name", "iagno", "website-label", _tmp10_, "website", "http://www.gnome.org/projects/gnome-games/", "wrap-license", TRUE, NULL, NULL);
	_g_free0 (license);
	documenters = (_vala_array_free (documenters, documenters_length1, (GDestroyNotify) g_free), NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
}


static void iagno_preferences_cb (Iagno* self) {
	g_return_if_fail (self != NULL);
	iagno_show_preferences_dialog (self);
}


static void iagno_show_message_data_free (gpointer _data) {
	IagnoShowMessageData* _data_;
	_data_ = _data;
	_g_free0 (_data_->message);
	_g_object_unref0 (_data_->self);
	g_slice_free (IagnoShowMessageData, _data_);
}


static void iagno_show_message (Iagno* self, const gchar* message, GtkMessageType type, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	IagnoShowMessageData* _data_;
	Iagno* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GtkMessageType _tmp3_ = 0;
	_data_ = g_slice_new0 (IagnoShowMessageData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, iagno_show_message);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, iagno_show_message_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = message;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->message);
	_data_->message = _tmp2_;
	_tmp3_ = type;
	_data_->type = _tmp3_;
	iagno_show_message_co (_data_);
}


static void iagno_show_message_finish (Iagno* self, GAsyncResult* _res_) {
	IagnoShowMessageData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean _iagno_show_message_co_gsource_func (gpointer self) {
	gboolean result;
	result = iagno_show_message_co (self);
	return result;
}


static gboolean iagno_show_message_co (IagnoShowMessageData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->infobar;
	gtk_widget_hide ((GtkWidget*) _data_->_tmp0_);
	while (TRUE) {
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = _data_->self->priv->infobar;
		_data_->_tmp2_ = FALSE;
		_data_->_tmp2_ = gtk_widget_get_visible ((GtkWidget*) _data_->_tmp1_);
		_data_->_tmp3_ = FALSE;
		_data_->_tmp3_ = _data_->_tmp2_;
		if (!_data_->_tmp3_) {
			break;
		}
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _iagno_show_message_co_gsource_func, _data_, NULL);
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
	}
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->self->priv->infobar;
	_data_->_tmp5_ = 0;
	_data_->_tmp5_ = _data_->type;
	gtk_info_bar_set_message_type (_data_->_tmp4_, _data_->_tmp5_);
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->self->priv->infobar_label;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _data_->message;
	gtk_label_set_label (_data_->_tmp6_, _data_->_tmp7_);
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->self->priv->infobar;
	gtk_widget_show ((GtkWidget*) _data_->_tmp8_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void iagno_help_cb (Iagno* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GtkWindow* _tmp0_ = NULL;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
		_tmp0_ = self->priv->window;
		_tmp1_ = gtk_window_get_screen (_tmp0_);
		_tmp2_ = gtk_get_current_event_time ();
		gtk_show_uri (_tmp1_, "help:iagno", _tmp2_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("iagno.vala:347: Failed to show help: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void iagno_game_move_cb (Iagno* self, Game* g) {
	Game* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	Game* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	Game* _tmp8_ = NULL;
	Player _tmp9_ = 0;
	Player _tmp10_ = 0;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp19_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (g != NULL);
	_tmp0_ = g;
	_tmp1_ = self->priv->game;
	g_return_if_fail (_tmp0_ == _tmp1_);
	iagno_play_sound (self, "flip-piece");
	_tmp2_ = self->priv->game;
	_tmp3_ = game_get_can_move (_tmp2_);
	_tmp4_ = _tmp3_;
	if (!_tmp4_) {
		Game* _tmp5_ = NULL;
		self->priv->was_pass = TRUE;
		_tmp5_ = self->priv->game;
		game_pass (_tmp5_);
		return;
	}
	iagno_update_ui (self);
	self->priv->was_pass = FALSE;
	_tmp8_ = self->priv->game;
	_tmp9_ = game_get_current_color (_tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_ == PLAYER_LIGHT) {
		ComputerPlayer* _tmp11_ = NULL;
		_tmp11_ = self->priv->light_computer;
		_tmp7_ = _tmp11_ != NULL;
	} else {
		_tmp7_ = FALSE;
	}
	_tmp12_ = _tmp7_;
	if (_tmp12_) {
		_tmp6_ = TRUE;
	} else {
		gboolean _tmp13_ = FALSE;
		Game* _tmp14_ = NULL;
		Player _tmp15_ = 0;
		Player _tmp16_ = 0;
		gboolean _tmp18_ = FALSE;
		_tmp14_ = self->priv->game;
		_tmp15_ = game_get_current_color (_tmp14_);
		_tmp16_ = _tmp15_;
		if (_tmp16_ == PLAYER_DARK) {
			ComputerPlayer* _tmp17_ = NULL;
			_tmp17_ = self->priv->dark_computer;
			_tmp13_ = _tmp17_ != NULL;
		} else {
			_tmp13_ = FALSE;
		}
		_tmp18_ = _tmp13_;
		_tmp6_ = _tmp18_;
	}
	_tmp19_ = _tmp6_;
	if (_tmp19_) {
		guint _tmp20_ = 0U;
		_tmp20_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 1000, _iagno_computer_move_cb_gsource_func, g_object_ref (self), g_object_unref);
		self->priv->computer_timer = _tmp20_;
	}
}


static gboolean iagno_computer_move_cb (Iagno* self) {
	gboolean result = FALSE;
	Game* _tmp0_ = NULL;
	Player _tmp1_ = 0;
	Player _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	iagno_cancel_pending_computer_moves (self);
	_tmp0_ = self->priv->game;
	_tmp1_ = game_get_current_color (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == PLAYER_LIGHT) {
		ComputerPlayer* _tmp3_ = NULL;
		_tmp3_ = self->priv->light_computer;
		computer_player_move (_tmp3_);
	} else {
		ComputerPlayer* _tmp4_ = NULL;
		_tmp4_ = self->priv->dark_computer;
		computer_player_move (_tmp4_);
	}
	result = FALSE;
	return result;
}


static void iagno_cancel_pending_computer_moves (Iagno* self) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->computer_timer;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = self->priv->computer_timer;
		g_source_remove (_tmp1_);
		self->priv->computer_timer = (guint) 0;
	}
}


static void iagno_game_complete_cb (Iagno* self) {
	Game* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	Game* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	Game* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	Game* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	Game* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	Game* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	g_return_if_fail (self != NULL);
	iagno_update_ui (self);
	_tmp0_ = self->priv->game;
	_tmp1_ = game_get_n_light_tiles (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->game;
	_tmp4_ = game_get_n_dark_tiles (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp2_ > _tmp5_) {
		const gchar* _tmp6_ = NULL;
		_tmp6_ = _ ("Light player wins!");
		iagno_show_message (self, _tmp6_, GTK_MESSAGE_INFO, NULL, NULL);
	}
	_tmp7_ = self->priv->game;
	_tmp8_ = game_get_n_dark_tiles (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = self->priv->game;
	_tmp11_ = game_get_n_light_tiles (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp9_ > _tmp12_) {
		const gchar* _tmp13_ = NULL;
		_tmp13_ = _ ("Dark player wins!");
		iagno_show_message (self, _tmp13_, GTK_MESSAGE_INFO, NULL, NULL);
	}
	_tmp14_ = self->priv->game;
	_tmp15_ = game_get_n_light_tiles (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = self->priv->game;
	_tmp18_ = game_get_n_dark_tiles (_tmp17_);
	_tmp19_ = _tmp18_;
	if (_tmp16_ == _tmp19_) {
		const gchar* _tmp20_ = NULL;
		_tmp20_ = _ ("The game was a draw.");
		iagno_show_message (self, _tmp20_, GTK_MESSAGE_INFO, NULL, NULL);
	}
	iagno_play_sound (self, "gameover");
}


static void iagno_play_sound (Iagno* self, const gchar* name) {
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GameView* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_boolean (_tmp0_, "sound");
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->view;
	_tmp3_ = name;
	_tmp4_ = name;
	_tmp5_ = g_strdup_printf ("%s.ogg", _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_build_filename (SOUND_DIRECTORY, _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	ca_gtk_play_for_widget ((GtkWidget*) _tmp2_, (guint32) 0, CA_PROP_MEDIA_NAME, _tmp3_, CA_PROP_MEDIA_FILENAME, _tmp8_, NULL);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
}


static void iagno_player_move_cb (Iagno* self, gint x, gint y) {
	gboolean _tmp0_ = FALSE;
	Game* _tmp1_ = NULL;
	Player _tmp2_ = 0;
	Player _tmp3_ = 0;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	Game* _tmp8_ = NULL;
	Player _tmp9_ = 0;
	Player _tmp10_ = 0;
	gboolean _tmp13_ = FALSE;
	Game* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->game;
	_tmp2_ = game_get_current_color (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == PLAYER_LIGHT) {
		GSettings* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		_tmp4_ = self->priv->settings;
		_tmp5_ = g_settings_get_int (_tmp4_, "white-level");
		_tmp0_ = _tmp5_ > 0;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp6_ = _tmp0_;
	if (_tmp6_) {
		return;
	}
	_tmp8_ = self->priv->game;
	_tmp9_ = game_get_current_color (_tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_ == PLAYER_DARK) {
		GSettings* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		_tmp11_ = self->priv->settings;
		_tmp12_ = g_settings_get_int (_tmp11_, "black-level");
		_tmp7_ = _tmp12_ > 0;
	} else {
		_tmp7_ = FALSE;
	}
	_tmp13_ = _tmp7_;
	if (_tmp13_) {
		return;
	}
	_tmp14_ = self->priv->game;
	_tmp15_ = x;
	_tmp16_ = y;
	_tmp17_ = game_place_tile (_tmp14_, _tmp15_, _tmp16_);
	if (_tmp17_ == 0) {
		const gchar* _tmp18_ = NULL;
		_tmp18_ = _ ("Invalid move.");
		iagno_show_message (self, _tmp18_, GTK_MESSAGE_ERROR, NULL, NULL);
	}
}


static void iagno_dark_level_changed_cb (Iagno* self, GtkComboBox* combo) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gint level = 0;
	GtkComboBox* _tmp2_ = NULL;
	GtkTreeModel* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	GSettings* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	_tmp2_ = combo;
	_tmp3_ = gtk_combo_box_get_model (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = iter;
	gtk_tree_model_get (_tmp4_, &_tmp5_, 1, &level, -1);
	_tmp6_ = self->priv->settings;
	g_settings_set_int (_tmp6_, "black-level", level);
}


static void iagno_light_level_changed_cb (Iagno* self, GtkComboBox* combo) {
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gint level = 0;
	GtkComboBox* _tmp2_ = NULL;
	GtkTreeModel* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeIter _tmp5_ = {0};
	GSettings* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (combo != NULL);
	_tmp0_ = combo;
	gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	_tmp2_ = combo;
	_tmp3_ = gtk_combo_box_get_model (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = iter;
	gtk_tree_model_get (_tmp4_, &_tmp5_, 1, &level, -1);
	_tmp6_ = self->priv->settings;
	g_settings_set_int (_tmp6_, "white-level", level);
}


static void iagno_sound_select (Iagno* self, GtkToggleButton* widget) {
	gboolean play_sounds = FALSE;
	GtkToggleButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GSettings* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = gtk_toggle_button_get_active (_tmp0_);
	play_sounds = _tmp1_;
	_tmp2_ = self->priv->settings;
	g_settings_set_boolean (_tmp2_, "sound", play_sounds);
}


static void iagno_grid_toggled_cb (Iagno* self, GtkToggleButton* widget) {
	GameView* _tmp0_ = NULL;
	GtkToggleButton* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GSettings* _tmp3_ = NULL;
	GameView* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->view;
	_tmp1_ = widget;
	_tmp2_ = gtk_toggle_button_get_active (_tmp1_);
	game_view_set_show_grid (_tmp0_, _tmp2_);
	_tmp3_ = self->priv->settings;
	_tmp4_ = self->priv->view;
	_tmp5_ = game_view_get_show_grid (_tmp4_);
	_tmp6_ = _tmp5_;
	g_settings_set_boolean (_tmp3_, "show-grid", _tmp6_);
}


static void iagno_flip_final_toggled_cb (Iagno* self, GtkToggleButton* widget) {
	GameView* _tmp0_ = NULL;
	GtkToggleButton* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GSettings* _tmp3_ = NULL;
	GameView* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = self->priv->view;
	_tmp1_ = widget;
	_tmp2_ = gtk_toggle_button_get_active (_tmp1_);
	game_view_set_flip_final_result (_tmp0_, _tmp2_);
	_tmp3_ = self->priv->settings;
	_tmp4_ = self->priv->view;
	_tmp5_ = game_view_get_flip_final_result (_tmp4_);
	_tmp6_ = _tmp5_;
	g_settings_set_boolean (_tmp3_, "flip-final-results", _tmp6_);
}


static void iagno_propbox_response_cb (Iagno* self, GtkWidget* widget, gint response_id) {
	GtkWidget* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	gtk_widget_hide (_tmp0_);
}


static gboolean iagno_propbox_close_cb (Iagno* self, GtkWidget* widget, GdkEventAny* event) {
	gboolean result = FALSE;
	GtkWidget* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = widget;
	gtk_widget_hide (_tmp0_);
	result = TRUE;
	return result;
}


static void iagno_theme_changed_cb (Iagno* self, GtkComboBox* widget) {
	GtkTreeModel* model = NULL;
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	gchar* tile_set = NULL;
	GtkTreeModel* _tmp6_ = NULL;
	GtkTreeIter _tmp7_ = {0};
	GSettings* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GameView* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	GameView* _tmp14_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (widget != NULL);
	_tmp0_ = widget;
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	model = _tmp2_;
	_tmp3_ = widget;
	_tmp5_ = gtk_combo_box_get_active_iter (_tmp3_, &_tmp4_);
	iter = _tmp4_;
	if (!_tmp5_) {
		_g_object_unref0 (model);
		return;
	}
	_tmp6_ = model;
	_tmp7_ = iter;
	gtk_tree_model_get (_tmp6_, &_tmp7_, 1, &tile_set, -1);
	_tmp8_ = self->priv->settings;
	_tmp9_ = tile_set;
	g_settings_set_string (_tmp8_, "tileset", _tmp9_);
	_tmp10_ = self->priv->view;
	_tmp11_ = tile_set;
	_tmp12_ = g_build_filename (DATA_DIRECTORY, "themes", _tmp11_, NULL);
	_tmp13_ = _tmp12_;
	game_view_set_theme (_tmp10_, _tmp13_);
	_g_free0 (_tmp13_);
	_tmp14_ = self->priv->view;
	game_view_redraw (_tmp14_);
	_g_free0 (tile_set);
	_g_object_unref0 (model);
}


static void _iagno_propbox_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	iagno_propbox_response_cb (self, _sender, response_id);
}


static gboolean _iagno_propbox_close_cb_gtk_widget_delete_event (GtkWidget* _sender, GdkEventAny* event, gpointer self) {
	gboolean result;
	result = iagno_propbox_close_cb (self, _sender, event);
	return result;
}


static void _iagno_dark_level_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	iagno_dark_level_changed_cb (self, _sender);
}


static void _iagno_light_level_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	iagno_light_level_changed_cb (self, _sender);
}


static void _iagno_sound_select_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	iagno_sound_select (self, _sender);
}


static void _iagno_grid_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	iagno_grid_toggled_cb (self, _sender);
}


static void _iagno_flip_final_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	iagno_flip_final_toggled_cb (self, _sender);
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch5_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) (-1), 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch5_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp5_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally5;
	__catch5_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gint string_last_index_of_char (const gchar* self, gunichar c, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gunichar _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = c;
	_tmp2_ = g_utf8_strrchr (((gchar*) self) + _tmp0_, (gssize) (-1), _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_ = 0L;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	gboolean _tmp3_ = FALSE;
	glong _tmp9_ = 0L;
	glong _tmp15_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	glong _tmp22_ = 0L;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_ = 0L;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		glong _tmp12_ = 0L;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_ = 0L;
		glong _tmp14_ = 0L;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_ = 0L;
		glong _tmp17_ = 0L;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


static void _iagno_theme_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	iagno_theme_changed_cb (self, _sender);
}


static void iagno_show_preferences_dialog (Iagno* self) {
	GtkDialog* propbox = NULL;
	const gchar* _tmp0_ = NULL;
	GtkWindow* _tmp1_ = NULL;
	GtkDialog* _tmp2_ = NULL;
	GtkDialog* _tmp3_ = NULL;
	GtkBox* box = NULL;
	GtkDialog* _tmp4_ = NULL;
	GtkBox* _tmp5_ = NULL;
	GtkBox* _tmp6_ = NULL;
	GtkBox* _tmp7_ = NULL;
	GtkDialog* _tmp8_ = NULL;
	GtkDialog* _tmp9_ = NULL;
	GtkDialog* _tmp10_ = NULL;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp11_ = NULL;
	GtkGrid* _tmp12_ = NULL;
	GtkGrid* _tmp13_ = NULL;
	GtkGrid* _tmp14_ = NULL;
	GtkBox* _tmp15_ = NULL;
	GtkGrid* _tmp16_ = NULL;
	GtkLabel* label = NULL;
	const gchar* _tmp17_ = NULL;
	GtkLabel* _tmp18_ = NULL;
	GtkLabel* _tmp19_ = NULL;
	GtkLabel* _tmp20_ = NULL;
	GtkGrid* _tmp21_ = NULL;
	GtkLabel* _tmp22_ = NULL;
	GtkComboBox* combo = NULL;
	GtkComboBox* _tmp23_ = NULL;
	GtkComboBox* _tmp24_ = NULL;
	GtkCellRendererText* renderer = NULL;
	GtkCellRendererText* _tmp25_ = NULL;
	GtkComboBox* _tmp26_ = NULL;
	GtkCellRendererText* _tmp27_ = NULL;
	GtkComboBox* _tmp28_ = NULL;
	GtkCellRendererText* _tmp29_ = NULL;
	GtkListStore* model = NULL;
	GtkListStore* _tmp30_ = NULL;
	GtkComboBox* _tmp31_ = NULL;
	GtkListStore* _tmp32_ = NULL;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp33_ = NULL;
	GtkTreeIter _tmp34_ = {0};
	GtkListStore* _tmp35_ = NULL;
	GtkTreeIter _tmp36_ = {0};
	const gchar* _tmp37_ = NULL;
	GSettings* _tmp38_ = NULL;
	gint _tmp39_ = 0;
	GtkListStore* _tmp42_ = NULL;
	GtkTreeIter _tmp43_ = {0};
	GtkListStore* _tmp44_ = NULL;
	GtkTreeIter _tmp45_ = {0};
	const gchar* _tmp46_ = NULL;
	GSettings* _tmp47_ = NULL;
	gint _tmp48_ = 0;
	GtkListStore* _tmp51_ = NULL;
	GtkTreeIter _tmp52_ = {0};
	GtkListStore* _tmp53_ = NULL;
	GtkTreeIter _tmp54_ = {0};
	const gchar* _tmp55_ = NULL;
	GSettings* _tmp56_ = NULL;
	gint _tmp57_ = 0;
	GtkListStore* _tmp60_ = NULL;
	GtkTreeIter _tmp61_ = {0};
	GtkListStore* _tmp62_ = NULL;
	GtkTreeIter _tmp63_ = {0};
	const gchar* _tmp64_ = NULL;
	GSettings* _tmp65_ = NULL;
	gint _tmp66_ = 0;
	GtkGrid* _tmp69_ = NULL;
	GtkComboBox* _tmp70_ = NULL;
	const gchar* _tmp71_ = NULL;
	GtkLabel* _tmp72_ = NULL;
	GtkLabel* _tmp73_ = NULL;
	GtkLabel* _tmp74_ = NULL;
	GtkGrid* _tmp75_ = NULL;
	GtkLabel* _tmp76_ = NULL;
	GtkComboBox* _tmp77_ = NULL;
	GtkComboBox* _tmp78_ = NULL;
	GtkCellRendererText* _tmp79_ = NULL;
	GtkComboBox* _tmp80_ = NULL;
	GtkCellRendererText* _tmp81_ = NULL;
	GtkComboBox* _tmp82_ = NULL;
	GtkCellRendererText* _tmp83_ = NULL;
	GtkListStore* _tmp84_ = NULL;
	GtkComboBox* _tmp85_ = NULL;
	GtkListStore* _tmp86_ = NULL;
	GtkListStore* _tmp87_ = NULL;
	GtkTreeIter _tmp88_ = {0};
	GtkListStore* _tmp89_ = NULL;
	GtkTreeIter _tmp90_ = {0};
	const gchar* _tmp91_ = NULL;
	GSettings* _tmp92_ = NULL;
	gint _tmp93_ = 0;
	GtkListStore* _tmp96_ = NULL;
	GtkTreeIter _tmp97_ = {0};
	GtkListStore* _tmp98_ = NULL;
	GtkTreeIter _tmp99_ = {0};
	const gchar* _tmp100_ = NULL;
	GSettings* _tmp101_ = NULL;
	gint _tmp102_ = 0;
	GtkListStore* _tmp105_ = NULL;
	GtkTreeIter _tmp106_ = {0};
	GtkListStore* _tmp107_ = NULL;
	GtkTreeIter _tmp108_ = {0};
	const gchar* _tmp109_ = NULL;
	GSettings* _tmp110_ = NULL;
	gint _tmp111_ = 0;
	GtkListStore* _tmp114_ = NULL;
	GtkTreeIter _tmp115_ = {0};
	GtkListStore* _tmp116_ = NULL;
	GtkTreeIter _tmp117_ = {0};
	const gchar* _tmp118_ = NULL;
	GSettings* _tmp119_ = NULL;
	gint _tmp120_ = 0;
	GtkGrid* _tmp123_ = NULL;
	GtkComboBox* _tmp124_ = NULL;
	GtkCheckButton* enable_sounds_button = NULL;
	const gchar* _tmp125_ = NULL;
	GtkCheckButton* _tmp126_ = NULL;
	GtkCheckButton* _tmp127_ = NULL;
	GSettings* _tmp128_ = NULL;
	gboolean _tmp129_ = FALSE;
	GtkCheckButton* _tmp130_ = NULL;
	GtkGrid* _tmp131_ = NULL;
	GtkCheckButton* _tmp132_ = NULL;
	GtkCheckButton* grid_button = NULL;
	const gchar* _tmp133_ = NULL;
	GtkCheckButton* _tmp134_ = NULL;
	GtkCheckButton* _tmp135_ = NULL;
	GSettings* _tmp136_ = NULL;
	gboolean _tmp137_ = FALSE;
	GtkCheckButton* _tmp138_ = NULL;
	GtkGrid* _tmp139_ = NULL;
	GtkCheckButton* _tmp140_ = NULL;
	GtkCheckButton* flip_final_button = NULL;
	const gchar* _tmp141_ = NULL;
	GtkCheckButton* _tmp142_ = NULL;
	GtkCheckButton* _tmp143_ = NULL;
	GSettings* _tmp144_ = NULL;
	gboolean _tmp145_ = FALSE;
	GtkCheckButton* _tmp146_ = NULL;
	GtkGrid* _tmp147_ = NULL;
	GtkCheckButton* _tmp148_ = NULL;
	const gchar* _tmp149_ = NULL;
	GtkLabel* _tmp150_ = NULL;
	GtkLabel* _tmp151_ = NULL;
	GtkLabel* _tmp152_ = NULL;
	GtkGrid* _tmp153_ = NULL;
	GtkLabel* _tmp154_ = NULL;
	GtkComboBox* theme_combo = NULL;
	GtkComboBox* _tmp155_ = NULL;
	GtkCellRendererText* _tmp156_ = NULL;
	GtkComboBox* _tmp157_ = NULL;
	GtkCellRendererText* _tmp158_ = NULL;
	GtkComboBox* _tmp159_ = NULL;
	GtkCellRendererText* _tmp160_ = NULL;
	GtkListStore* _tmp161_ = NULL;
	GtkComboBox* _tmp162_ = NULL;
	GtkListStore* _tmp163_ = NULL;
	GDir* dir = NULL;
	GList* dirlist = NULL;
	GList* _tmp178_ = NULL;
	GtkLabel* _tmp203_ = NULL;
	GtkComboBox* _tmp204_ = NULL;
	GtkComboBox* _tmp205_ = NULL;
	GtkGrid* _tmp206_ = NULL;
	GtkComboBox* _tmp207_ = NULL;
	GtkDialog* _tmp208_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = _ ("Iagno Preferences");
	_tmp1_ = self->priv->window;
	_tmp2_ = (GtkDialog*) gtk_dialog_new_with_buttons (_tmp0_, _tmp1_, 0, GTK_STOCK_CLOSE, GTK_RESPONSE_CLOSE, NULL, NULL);
	g_object_ref_sink (_tmp2_);
	propbox = _tmp2_;
	_tmp3_ = propbox;
	gtk_container_set_border_width ((GtkContainer*) _tmp3_, (guint) 5);
	_tmp4_ = propbox;
	_tmp5_ = (GtkBox*) gtk_dialog_get_content_area (_tmp4_);
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GTK_TYPE_BOX, GtkBox));
	box = _tmp6_;
	_tmp7_ = box;
	gtk_box_set_spacing (_tmp7_, 2);
	_tmp8_ = propbox;
	gtk_window_set_resizable ((GtkWindow*) _tmp8_, FALSE);
	_tmp9_ = propbox;
	g_signal_connect_object (_tmp9_, "response", (GCallback) _iagno_propbox_response_cb_gtk_dialog_response, self, 0);
	_tmp10_ = propbox;
	g_signal_connect_object ((GtkWidget*) _tmp10_, "delete-event", (GCallback) _iagno_propbox_close_cb_gtk_widget_delete_event, self, 0);
	_tmp11_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp11_);
	grid = _tmp11_;
	_tmp12_ = grid;
	gtk_container_set_border_width ((GtkContainer*) _tmp12_, (guint) 6);
	_tmp13_ = grid;
	gtk_grid_set_row_spacing (_tmp13_, (guint) 6);
	_tmp14_ = grid;
	gtk_grid_set_column_spacing (_tmp14_, (guint) 18);
	_tmp15_ = box;
	_tmp16_ = grid;
	gtk_container_add ((GtkContainer*) _tmp15_, (GtkWidget*) _tmp16_);
	_tmp17_ = _ ("Dark Player:");
	_tmp18_ = (GtkLabel*) gtk_label_new (_tmp17_);
	g_object_ref_sink (_tmp18_);
	label = _tmp18_;
	_tmp19_ = label;
	gtk_misc_set_alignment ((GtkMisc*) _tmp19_, 0.0f, 0.5f);
	_tmp20_ = label;
	g_object_set ((GtkWidget*) _tmp20_, "expand", TRUE, NULL);
	_tmp21_ = grid;
	_tmp22_ = label;
	gtk_grid_attach (_tmp21_, (GtkWidget*) _tmp22_, 0, 0, 1, 1);
	_tmp23_ = (GtkComboBox*) gtk_combo_box_new ();
	g_object_ref_sink (_tmp23_);
	combo = _tmp23_;
	_tmp24_ = combo;
	g_signal_connect_object (_tmp24_, "changed", (GCallback) _iagno_dark_level_changed_cb_gtk_combo_box_changed, self, 0);
	_tmp25_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp25_);
	renderer = _tmp25_;
	_tmp26_ = combo;
	_tmp27_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp26_, (GtkCellRenderer*) _tmp27_, TRUE);
	_tmp28_ = combo;
	_tmp29_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp28_, (GtkCellRenderer*) _tmp29_, "text", 0);
	_tmp30_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_INT);
	model = _tmp30_;
	_tmp31_ = combo;
	_tmp32_ = model;
	gtk_combo_box_set_model (_tmp31_, (GtkTreeModel*) _tmp32_);
	_tmp33_ = model;
	gtk_list_store_append (_tmp33_, &_tmp34_);
	iter = _tmp34_;
	_tmp35_ = model;
	_tmp36_ = iter;
	_tmp37_ = _ ("Human");
	gtk_list_store_set (_tmp35_, &_tmp36_, 0, _tmp37_, 1, 0, -1);
	_tmp38_ = self->priv->settings;
	_tmp39_ = g_settings_get_int (_tmp38_, "black-level");
	if (_tmp39_ == 0) {
		GtkComboBox* _tmp40_ = NULL;
		GtkTreeIter _tmp41_ = {0};
		_tmp40_ = combo;
		_tmp41_ = iter;
		gtk_combo_box_set_active_iter (_tmp40_, &_tmp41_);
	}
	_tmp42_ = model;
	gtk_list_store_append (_tmp42_, &_tmp43_);
	iter = _tmp43_;
	_tmp44_ = model;
	_tmp45_ = iter;
	_tmp46_ = _ ("Level one");
	gtk_list_store_set (_tmp44_, &_tmp45_, 0, _tmp46_, 1, 1, -1);
	_tmp47_ = self->priv->settings;
	_tmp48_ = g_settings_get_int (_tmp47_, "black-level");
	if (_tmp48_ == 1) {
		GtkComboBox* _tmp49_ = NULL;
		GtkTreeIter _tmp50_ = {0};
		_tmp49_ = combo;
		_tmp50_ = iter;
		gtk_combo_box_set_active_iter (_tmp49_, &_tmp50_);
	}
	_tmp51_ = model;
	gtk_list_store_append (_tmp51_, &_tmp52_);
	iter = _tmp52_;
	_tmp53_ = model;
	_tmp54_ = iter;
	_tmp55_ = _ ("Level two");
	gtk_list_store_set (_tmp53_, &_tmp54_, 0, _tmp55_, 1, 2, -1);
	_tmp56_ = self->priv->settings;
	_tmp57_ = g_settings_get_int (_tmp56_, "black-level");
	if (_tmp57_ == 2) {
		GtkComboBox* _tmp58_ = NULL;
		GtkTreeIter _tmp59_ = {0};
		_tmp58_ = combo;
		_tmp59_ = iter;
		gtk_combo_box_set_active_iter (_tmp58_, &_tmp59_);
	}
	_tmp60_ = model;
	gtk_list_store_append (_tmp60_, &_tmp61_);
	iter = _tmp61_;
	_tmp62_ = model;
	_tmp63_ = iter;
	_tmp64_ = _ ("Level three");
	gtk_list_store_set (_tmp62_, &_tmp63_, 0, _tmp64_, 1, 3, -1);
	_tmp65_ = self->priv->settings;
	_tmp66_ = g_settings_get_int (_tmp65_, "black-level");
	if (_tmp66_ == 3) {
		GtkComboBox* _tmp67_ = NULL;
		GtkTreeIter _tmp68_ = {0};
		_tmp67_ = combo;
		_tmp68_ = iter;
		gtk_combo_box_set_active_iter (_tmp67_, &_tmp68_);
	}
	_tmp69_ = grid;
	_tmp70_ = combo;
	gtk_grid_attach (_tmp69_, (GtkWidget*) _tmp70_, 1, 0, 1, 1);
	_tmp71_ = _ ("Light Player:");
	_tmp72_ = (GtkLabel*) gtk_label_new (_tmp71_);
	g_object_ref_sink (_tmp72_);
	_g_object_unref0 (label);
	label = _tmp72_;
	_tmp73_ = label;
	gtk_misc_set_alignment ((GtkMisc*) _tmp73_, 0.0f, 0.5f);
	_tmp74_ = label;
	g_object_set ((GtkWidget*) _tmp74_, "expand", TRUE, NULL);
	_tmp75_ = grid;
	_tmp76_ = label;
	gtk_grid_attach (_tmp75_, (GtkWidget*) _tmp76_, 0, 1, 1, 1);
	_tmp77_ = (GtkComboBox*) gtk_combo_box_new ();
	g_object_ref_sink (_tmp77_);
	_g_object_unref0 (combo);
	combo = _tmp77_;
	_tmp78_ = combo;
	g_signal_connect_object (_tmp78_, "changed", (GCallback) _iagno_light_level_changed_cb_gtk_combo_box_changed, self, 0);
	_tmp79_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp79_);
	_g_object_unref0 (renderer);
	renderer = _tmp79_;
	_tmp80_ = combo;
	_tmp81_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp80_, (GtkCellRenderer*) _tmp81_, TRUE);
	_tmp82_ = combo;
	_tmp83_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp82_, (GtkCellRenderer*) _tmp83_, "text", 0);
	_tmp84_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_INT);
	_g_object_unref0 (model);
	model = _tmp84_;
	_tmp85_ = combo;
	_tmp86_ = model;
	gtk_combo_box_set_model (_tmp85_, (GtkTreeModel*) _tmp86_);
	_tmp87_ = model;
	gtk_list_store_append (_tmp87_, &_tmp88_);
	iter = _tmp88_;
	_tmp89_ = model;
	_tmp90_ = iter;
	_tmp91_ = _ ("Human");
	gtk_list_store_set (_tmp89_, &_tmp90_, 0, _tmp91_, 1, 0, -1);
	_tmp92_ = self->priv->settings;
	_tmp93_ = g_settings_get_int (_tmp92_, "white-level");
	if (_tmp93_ == 0) {
		GtkComboBox* _tmp94_ = NULL;
		GtkTreeIter _tmp95_ = {0};
		_tmp94_ = combo;
		_tmp95_ = iter;
		gtk_combo_box_set_active_iter (_tmp94_, &_tmp95_);
	}
	_tmp96_ = model;
	gtk_list_store_append (_tmp96_, &_tmp97_);
	iter = _tmp97_;
	_tmp98_ = model;
	_tmp99_ = iter;
	_tmp100_ = _ ("Level one");
	gtk_list_store_set (_tmp98_, &_tmp99_, 0, _tmp100_, 1, 1, -1);
	_tmp101_ = self->priv->settings;
	_tmp102_ = g_settings_get_int (_tmp101_, "white-level");
	if (_tmp102_ == 1) {
		GtkComboBox* _tmp103_ = NULL;
		GtkTreeIter _tmp104_ = {0};
		_tmp103_ = combo;
		_tmp104_ = iter;
		gtk_combo_box_set_active_iter (_tmp103_, &_tmp104_);
	}
	_tmp105_ = model;
	gtk_list_store_append (_tmp105_, &_tmp106_);
	iter = _tmp106_;
	_tmp107_ = model;
	_tmp108_ = iter;
	_tmp109_ = _ ("Level two");
	gtk_list_store_set (_tmp107_, &_tmp108_, 0, _tmp109_, 1, 2, -1);
	_tmp110_ = self->priv->settings;
	_tmp111_ = g_settings_get_int (_tmp110_, "white-level");
	if (_tmp111_ == 2) {
		GtkComboBox* _tmp112_ = NULL;
		GtkTreeIter _tmp113_ = {0};
		_tmp112_ = combo;
		_tmp113_ = iter;
		gtk_combo_box_set_active_iter (_tmp112_, &_tmp113_);
	}
	_tmp114_ = model;
	gtk_list_store_append (_tmp114_, &_tmp115_);
	iter = _tmp115_;
	_tmp116_ = model;
	_tmp117_ = iter;
	_tmp118_ = _ ("Level three");
	gtk_list_store_set (_tmp116_, &_tmp117_, 0, _tmp118_, 1, 3, -1);
	_tmp119_ = self->priv->settings;
	_tmp120_ = g_settings_get_int (_tmp119_, "white-level");
	if (_tmp120_ == 3) {
		GtkComboBox* _tmp121_ = NULL;
		GtkTreeIter _tmp122_ = {0};
		_tmp121_ = combo;
		_tmp122_ = iter;
		gtk_combo_box_set_active_iter (_tmp121_, &_tmp122_);
	}
	_tmp123_ = grid;
	_tmp124_ = combo;
	gtk_grid_attach (_tmp123_, (GtkWidget*) _tmp124_, 1, 1, 1, 1);
	_tmp125_ = _ ("E_nable sounds");
	_tmp126_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic (_tmp125_);
	g_object_ref_sink (_tmp126_);
	enable_sounds_button = _tmp126_;
	_tmp127_ = enable_sounds_button;
	_tmp128_ = self->priv->settings;
	_tmp129_ = g_settings_get_boolean (_tmp128_, "sound");
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp127_, _tmp129_);
	_tmp130_ = enable_sounds_button;
	g_signal_connect_object ((GtkToggleButton*) _tmp130_, "toggled", (GCallback) _iagno_sound_select_gtk_toggle_button_toggled, self, 0);
	_tmp131_ = grid;
	_tmp132_ = enable_sounds_button;
	gtk_grid_attach (_tmp131_, (GtkWidget*) _tmp132_, 0, 2, 2, 1);
	_tmp133_ = _ ("S_how grid");
	_tmp134_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic (_tmp133_);
	g_object_ref_sink (_tmp134_);
	grid_button = _tmp134_;
	_tmp135_ = grid_button;
	_tmp136_ = self->priv->settings;
	_tmp137_ = g_settings_get_boolean (_tmp136_, "show-grid");
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp135_, _tmp137_);
	_tmp138_ = grid_button;
	g_signal_connect_object ((GtkToggleButton*) _tmp138_, "toggled", (GCallback) _iagno_grid_toggled_cb_gtk_toggle_button_toggled, self, 0);
	_tmp139_ = grid;
	_tmp140_ = grid_button;
	gtk_grid_attach (_tmp139_, (GtkWidget*) _tmp140_, 0, 3, 2, 1);
	_tmp141_ = _ ("_Flip final results");
	_tmp142_ = (GtkCheckButton*) gtk_check_button_new_with_mnemonic (_tmp141_);
	g_object_ref_sink (_tmp142_);
	flip_final_button = _tmp142_;
	_tmp143_ = flip_final_button;
	_tmp144_ = self->priv->settings;
	_tmp145_ = g_settings_get_boolean (_tmp144_, "flip-final-results");
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp143_, _tmp145_);
	_tmp146_ = flip_final_button;
	g_signal_connect_object ((GtkToggleButton*) _tmp146_, "toggled", (GCallback) _iagno_flip_final_toggled_cb_gtk_toggle_button_toggled, self, 0);
	_tmp147_ = grid;
	_tmp148_ = flip_final_button;
	gtk_grid_attach (_tmp147_, (GtkWidget*) _tmp148_, 0, 4, 2, 1);
	_tmp149_ = _ ("_Tile set:");
	_tmp150_ = (GtkLabel*) gtk_label_new_with_mnemonic (_tmp149_);
	g_object_ref_sink (_tmp150_);
	_g_object_unref0 (label);
	label = _tmp150_;
	_tmp151_ = label;
	gtk_misc_set_alignment ((GtkMisc*) _tmp151_, 0.0f, 0.5f);
	_tmp152_ = label;
	g_object_set ((GtkWidget*) _tmp152_, "expand", TRUE, NULL);
	_tmp153_ = grid;
	_tmp154_ = label;
	gtk_grid_attach (_tmp153_, (GtkWidget*) _tmp154_, 0, 5, 1, 1);
	_tmp155_ = (GtkComboBox*) gtk_combo_box_new ();
	g_object_ref_sink (_tmp155_);
	theme_combo = _tmp155_;
	_tmp156_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp156_);
	_g_object_unref0 (renderer);
	renderer = _tmp156_;
	_tmp157_ = theme_combo;
	_tmp158_ = renderer;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp157_, (GtkCellRenderer*) _tmp158_, TRUE);
	_tmp159_ = theme_combo;
	_tmp160_ = renderer;
	gtk_cell_layout_add_attribute ((GtkCellLayout*) _tmp159_, (GtkCellRenderer*) _tmp160_, "text", 0);
	_tmp161_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING);
	_g_object_unref0 (model);
	model = _tmp161_;
	_tmp162_ = theme_combo;
	_tmp163_ = model;
	gtk_combo_box_set_model (_tmp162_, (GtkTreeModel*) _tmp163_);
	dirlist = NULL;
	{
		GDir* _tmp164_ = NULL;
		gchar* _tmp165_ = NULL;
		gchar* _tmp166_ = NULL;
		GDir* _tmp167_ = NULL;
		GDir* _tmp168_ = NULL;
		_tmp165_ = g_build_filename (DATA_DIRECTORY, "themes", NULL);
		_tmp166_ = _tmp165_;
		_tmp167_ = g_dir_open (_tmp166_, (guint) 0, &_inner_error_);
		_tmp168_ = _tmp167_;
		_g_free0 (_tmp166_);
		_tmp164_ = _tmp168_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch4_g_file_error;
			}
			__g_list_free__g_free0_0 (dirlist);
			_g_dir_close0 (dir);
			_g_object_unref0 (theme_combo);
			_g_object_unref0 (flip_final_button);
			_g_object_unref0 (grid_button);
			_g_object_unref0 (enable_sounds_button);
			_g_object_unref0 (model);
			_g_object_unref0 (renderer);
			_g_object_unref0 (combo);
			_g_object_unref0 (label);
			_g_object_unref0 (grid);
			_g_object_unref0 (box);
			_g_object_unref0 (propbox);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_dir_close0 (dir);
		dir = _tmp164_;
		while (TRUE) {
			gchar* filename = NULL;
			GDir* _tmp169_ = NULL;
			const gchar* _tmp170_ = NULL;
			gchar* _tmp171_ = NULL;
			const gchar* _tmp172_ = NULL;
			const gchar* _tmp173_ = NULL;
			gchar* _tmp174_ = NULL;
			GCompareFunc _tmp175_ = NULL;
			_tmp169_ = dir;
			_tmp170_ = g_dir_read_name (_tmp169_);
			_tmp171_ = g_strdup (_tmp170_);
			filename = _tmp171_;
			_tmp172_ = filename;
			if (_tmp172_ == NULL) {
				_g_free0 (filename);
				break;
			}
			_tmp173_ = filename;
			_tmp174_ = g_strdup (_tmp173_);
			_tmp175_ = g_strcmp0;
			dirlist = g_list_insert_sorted (dirlist, _tmp174_, _tmp175_);
			_g_free0 (filename);
		}
	}
	goto __finally4;
	__catch4_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp176_ = NULL;
		const gchar* _tmp177_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp176_ = e;
		_tmp177_ = _tmp176_->message;
		g_warning ("iagno.vala:612: Failed to load themes: %s", _tmp177_);
		_g_error_free0 (e);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		__g_list_free__g_free0_0 (dirlist);
		_g_dir_close0 (dir);
		_g_object_unref0 (theme_combo);
		_g_object_unref0 (flip_final_button);
		_g_object_unref0 (grid_button);
		_g_object_unref0 (enable_sounds_button);
		_g_object_unref0 (model);
		_g_object_unref0 (renderer);
		_g_object_unref0 (combo);
		_g_object_unref0 (label);
		_g_object_unref0 (grid);
		_g_object_unref0 (box);
		_g_object_unref0 (propbox);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp178_ = dirlist;
	{
		GList* filename_collection = NULL;
		GList* filename_it = NULL;
		filename_collection = _tmp178_;
		for (filename_it = filename_collection; filename_it != NULL; filename_it = filename_it->next) {
			gchar* _tmp179_ = NULL;
			gchar* filename = NULL;
			_tmp179_ = g_strdup ((const gchar*) filename_it->data);
			filename = _tmp179_;
			{
				GtkListStore* _tmp180_ = NULL;
				GtkTreeIter _tmp181_ = {0};
				gchar* label_text = NULL;
				const gchar* _tmp182_ = NULL;
				gchar* _tmp183_ = NULL;
				const gchar* _tmp184_ = NULL;
				gchar* _tmp185_ = NULL;
				gint extension_index = 0;
				const gchar* _tmp186_ = NULL;
				gint _tmp187_ = 0;
				gint _tmp188_ = 0;
				GtkListStore* _tmp192_ = NULL;
				GtkTreeIter _tmp193_ = {0};
				const gchar* _tmp194_ = NULL;
				const gchar* _tmp195_ = NULL;
				const gchar* _tmp196_ = NULL;
				GSettings* _tmp197_ = NULL;
				gchar* _tmp198_ = NULL;
				gchar* _tmp199_ = NULL;
				gboolean _tmp200_ = FALSE;
				_tmp180_ = model;
				gtk_list_store_append (_tmp180_, &_tmp181_);
				iter = _tmp181_;
				_tmp182_ = filename;
				_tmp183_ = g_strdup (_tmp182_);
				label_text = _tmp183_;
				_tmp184_ = label_text;
				_tmp185_ = string_replace (_tmp184_, "_", " ");
				_g_free0 (label_text);
				label_text = _tmp185_;
				_tmp186_ = label_text;
				_tmp187_ = string_last_index_of_char (_tmp186_, (gunichar) '.', 0);
				extension_index = _tmp187_;
				_tmp188_ = extension_index;
				if (_tmp188_ > 0) {
					const gchar* _tmp189_ = NULL;
					gint _tmp190_ = 0;
					gchar* _tmp191_ = NULL;
					_tmp189_ = label_text;
					_tmp190_ = extension_index;
					_tmp191_ = string_substring (_tmp189_, (glong) 0, (glong) _tmp190_);
					_g_free0 (label_text);
					label_text = _tmp191_;
				}
				_tmp192_ = model;
				_tmp193_ = iter;
				_tmp194_ = label_text;
				_tmp195_ = filename;
				gtk_list_store_set (_tmp192_, &_tmp193_, 0, _tmp194_, 1, _tmp195_, -1);
				_tmp196_ = filename;
				_tmp197_ = self->priv->settings;
				_tmp198_ = g_settings_get_string (_tmp197_, "tileset");
				_tmp199_ = _tmp198_;
				_tmp200_ = g_strcmp0 (_tmp196_, _tmp199_) == 0;
				_g_free0 (_tmp199_);
				if (_tmp200_) {
					GtkComboBox* _tmp201_ = NULL;
					GtkTreeIter _tmp202_ = {0};
					_tmp201_ = theme_combo;
					_tmp202_ = iter;
					gtk_combo_box_set_active_iter (_tmp201_, &_tmp202_);
				}
				_g_free0 (label_text);
				_g_free0 (filename);
			}
		}
	}
	_tmp203_ = label;
	_tmp204_ = theme_combo;
	gtk_label_set_mnemonic_widget (_tmp203_, (GtkWidget*) _tmp204_);
	_tmp205_ = theme_combo;
	g_signal_connect_object (_tmp205_, "changed", (GCallback) _iagno_theme_changed_cb_gtk_combo_box_changed, self, 0);
	_tmp206_ = grid;
	_tmp207_ = theme_combo;
	gtk_grid_attach (_tmp206_, (GtkWidget*) _tmp207_, 1, 5, 1, 1);
	_tmp208_ = propbox;
	gtk_widget_show_all ((GtkWidget*) _tmp208_);
	__g_list_free__g_free0_0 (dirlist);
	_g_dir_close0 (dir);
	_g_object_unref0 (theme_combo);
	_g_object_unref0 (flip_final_button);
	_g_object_unref0 (grid_button);
	_g_object_unref0 (enable_sounds_button);
	_g_object_unref0 (model);
	_g_object_unref0 (renderer);
	_g_object_unref0 (combo);
	_g_object_unref0 (label);
	_g_object_unref0 (grid);
	_g_object_unref0 (box);
	_g_object_unref0 (propbox);
}


gint iagno_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* context = NULL;
	GOptionContext* _tmp0_ = NULL;
	GOptionContext* _tmp1_ = NULL;
	GOptionContext* _tmp2_ = NULL;
	GOptionGroup* _tmp3_ = NULL;
	const gchar* _tmp8_ = NULL;
	Iagno* app = NULL;
	Iagno* _tmp9_ = NULL;
	gint _result_ = 0;
	Iagno* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = g_option_context_new (NULL);
	context = _tmp0_;
	_tmp1_ = context;
	g_option_context_set_translation_domain (_tmp1_, GETTEXT_PACKAGE);
	_tmp2_ = context;
	_tmp3_ = gtk_get_option_group (TRUE);
	g_option_context_add_group (_tmp2_, _tmp3_);
	{
		GOptionContext* _tmp4_ = NULL;
		_tmp4_ = context;
		g_option_context_parse (_tmp4_, &args_length1, &args, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		FILE* _tmp5_ = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = stderr;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		fprintf (_tmp5_, "%s\n", _tmp7_);
		result = EXIT_FAILURE;
		_g_error_free0 (e);
		_g_option_context_free0 (context);
		return result;
	}
	__finally6:
	if (_inner_error_ != NULL) {
		_g_option_context_free0 (context);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	_tmp8_ = _ ("Iagno");
	g_set_application_name (_tmp8_);
	gtk_window_set_default_icon_name ("iagno");
	_tmp9_ = iagno_new ();
	app = _tmp9_;
	_tmp10_ = app;
	_tmp11_ = g_application_run ((GApplication*) _tmp10_, 0, NULL);
	_result_ = _tmp11_;
	result = _result_;
	_g_object_unref0 (app);
	_g_option_context_free0 (context);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return iagno_main (argv, argc);
}


static void iagno_class_init (IagnoClass * klass) {
	iagno_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (IagnoPrivate));
	G_APPLICATION_CLASS (klass)->startup = iagno_real_startup;
	G_APPLICATION_CLASS (klass)->activate = iagno_real_activate;
	G_APPLICATION_CLASS (klass)->shutdown = iagno_real_shutdown;
	G_OBJECT_CLASS (klass)->finalize = iagno_finalize;
}


static void iagno_instance_init (Iagno * self) {
	self->priv = IAGNO_GET_PRIVATE (self);
	self->priv->light_computer = NULL;
	self->priv->dark_computer = NULL;
	self->priv->computer_timer = (guint) 0;
	self->priv->game = NULL;
	self->priv->was_pass = FALSE;
}


static void iagno_finalize (GObject* obj) {
	Iagno * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_IAGNO, Iagno);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->window);
	_g_object_unref0 (self->priv->infobar);
	_g_object_unref0 (self->priv->statusbar);
	_g_object_unref0 (self->priv->view);
	_g_object_unref0 (self->priv->infobar_label);
	_g_object_unref0 (self->priv->dark_label);
	_g_object_unref0 (self->priv->light_label);
	_g_object_unref0 (self->priv->dark_score_label);
	_g_object_unref0 (self->priv->light_score_label);
	_g_object_unref0 (self->priv->undo_action);
	_computer_player_unref0 (self->priv->light_computer);
	_computer_player_unref0 (self->priv->dark_computer);
	_game_unref0 (self->priv->game);
	G_OBJECT_CLASS (iagno_parent_class)->finalize (obj);
}


GType iagno_get_type (void) {
	static volatile gsize iagno_type_id__volatile = 0;
	if (g_once_init_enter (&iagno_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IagnoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) iagno_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Iagno), 0, (GInstanceInitFunc) iagno_instance_init, NULL };
		GType iagno_type_id;
		iagno_type_id = g_type_register_static (GTK_TYPE_APPLICATION, "Iagno", &g_define_type_info, 0);
		g_once_init_leave (&iagno_type_id__volatile, iagno_type_id);
	}
	return iagno_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



