/* computer-player.c generated by valac 0.22.0.22-b05f, the Vala compiler
 * generated from computer-player.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <string.h>


#define TYPE_COMPUTER_PLAYER (computer_player_get_type ())
#define COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayer))
#define COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))
#define IS_COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPUTER_PLAYER))
#define IS_COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPUTER_PLAYER))
#define COMPUTER_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))

typedef struct _ComputerPlayer ComputerPlayer;
typedef struct _ComputerPlayerClass ComputerPlayerClass;
typedef struct _ComputerPlayerPrivate ComputerPlayerPrivate;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;

#define COMPUTER_PLAYER_TYPE_STRATEGY (computer_player_strategy_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_PLAYER (player_get_type ())

#define COMPUTER_PLAYER_TYPE_POSSIBLE_MOVE (computer_player_possible_move_get_type ())
typedef struct _ComputerPlayerPossibleMove ComputerPlayerPossibleMove;
#define __g_list_free__computer_player_possible_move_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__computer_player_possible_move_free0_ (var), NULL)))
#define _computer_player_possible_move_free0(var) ((var == NULL) ? NULL : (var = (computer_player_possible_move_free (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

struct _ComputerPlayer {
	GObject parent_instance;
	ComputerPlayerPrivate * priv;
};

struct _ComputerPlayerClass {
	GObjectClass parent_class;
};

struct _ComputerPlayerPrivate {
	Game* game;
	gint _level;
};

typedef enum  {
	COMPUTER_PLAYER_STRATEGY_PERFECT,
	COMPUTER_PLAYER_STRATEGY_VICTORY,
	COMPUTER_PLAYER_STRATEGY_BEST
} ComputerPlayerStrategy;

typedef enum  {
	PLAYER_NONE,
	PLAYER_LIGHT,
	PLAYER_DARK
} Player;

struct _ComputerPlayerPossibleMove {
	gint x;
	gint y;
	gint n_tiles;
};


static gpointer computer_player_parent_class = NULL;

GType computer_player_get_type (void) G_GNUC_CONST;
GType game_get_type (void) G_GNUC_CONST;
#define COMPUTER_PLAYER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_COMPUTER_PLAYER, ComputerPlayerPrivate))
enum  {
	COMPUTER_PLAYER_DUMMY_PROPERTY,
	COMPUTER_PLAYER_LEVEL
};
static GType computer_player_strategy_get_type (void) G_GNUC_UNUSED;
ComputerPlayer* computer_player_new (Game* game, gint level);
ComputerPlayer* computer_player_construct (GType object_type, Game* game, gint level);
static void computer_player_set_level (ComputerPlayer* self, gint value);
void computer_player_move (ComputerPlayer* self);
GType player_get_type (void) G_GNUC_CONST;
gboolean game_can_move (Game* self, Player color);
Player game_get_current_color (Game* self);
gint game_get_n_tiles (Game* self);
static void computer_player_random_select (Game* g, gint* move_x, gint* move_y);
gint game_place_tile (Game* self, gint x, gint y);
gint computer_player_get_level (ComputerPlayer* self);
static gint computer_player_search (Game* g, ComputerPlayerStrategy strategy, gint depth, gint a, gint b, gint p, gint* move_x, gint* move_y);
Game* game_new_copy (Game* game);
Game* game_construct_copy (GType object_type, Game* game);
gboolean game_is_complete (Game* self);
static gint computer_player_calculate_heuristic (Game* g, ComputerPlayerStrategy strategy);
static GType computer_player_possible_move_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ComputerPlayerPossibleMove* computer_player_possible_move_dup (const ComputerPlayerPossibleMove* self);
static void computer_player_possible_move_free (ComputerPlayerPossibleMove* self);
gint game_count_tiles (Game* self, Player color);
Player player_flip_color (Player p);
void game_undo (Game* self, gint count);
static void _computer_player_possible_move_free0_ (gpointer var);
static void _g_list_free__computer_player_possible_move_free0_ (GList* self);
static void computer_player_possible_move_init (ComputerPlayerPossibleMove *self, gint x, gint y, gint n_tiles);
static gint computer_player_compare_move (ComputerPlayerPossibleMove* a, ComputerPlayerPossibleMove* b);
static gint _computer_player_compare_move_gcompare_func (gconstpointer a, gconstpointer b);
void game_pass (Game* self);
gint game_get_n_dark_tiles (Game* self);
gint game_get_n_light_tiles (Game* self);
static gint computer_player_around (Game* g);
static gint computer_player_eval_heuristic (Game* g);
Player game_get_owner (Game* self, gint x, gint y);
static gint computer_player_is_empty (Game* g, gint x, gint y);
gboolean game_can_place (Game* self, gint x, gint y, Player color);
static void computer_player_finalize (GObject* obj);
static void _vala_computer_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_computer_player_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const gint COMPUTER_PLAYER_heuristic[64] = {65, -3, 6, 4, 4, 6, -3, 65, -3, -29, 3, 1, 1, 3, -29, -3, 6, 3, 5, 3, 3, 5, 3, 6, 4, 1, 3, 1, 1, 3, 1, 4, 4, 1, 3, 1, 1, 3, 1, 4, 6, 3, 5, 3, 3, 5, 3, 6, -3, -29, 3, 1, 1, 3, -29, -3, 65, -3, 6, 4, 4, 6, -3, 65};

static GType computer_player_strategy_get_type (void) {
	static volatile gsize computer_player_strategy_type_id__volatile = 0;
	if (g_once_init_enter (&computer_player_strategy_type_id__volatile)) {
		static const GEnumValue values[] = {{COMPUTER_PLAYER_STRATEGY_PERFECT, "COMPUTER_PLAYER_STRATEGY_PERFECT", "perfect"}, {COMPUTER_PLAYER_STRATEGY_VICTORY, "COMPUTER_PLAYER_STRATEGY_VICTORY", "victory"}, {COMPUTER_PLAYER_STRATEGY_BEST, "COMPUTER_PLAYER_STRATEGY_BEST", "best"}, {0, NULL, NULL}};
		GType computer_player_strategy_type_id;
		computer_player_strategy_type_id = g_enum_register_static ("ComputerPlayerStrategy", values);
		g_once_init_leave (&computer_player_strategy_type_id__volatile, computer_player_strategy_type_id);
	}
	return computer_player_strategy_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


ComputerPlayer* computer_player_construct (GType object_type, Game* game, gint level) {
	ComputerPlayer * self = NULL;
	Game* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	g_return_val_if_fail (game != NULL, NULL);
	self = (ComputerPlayer*) g_object_new (object_type, NULL);
	_tmp0_ = game;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->game);
	self->priv->game = _tmp1_;
	_tmp2_ = level;
	computer_player_set_level (self, _tmp2_);
	return self;
}


ComputerPlayer* computer_player_new (Game* game, gint level) {
	return computer_player_construct (TYPE_COMPUTER_PLAYER, game, level);
}


void computer_player_move (ComputerPlayer* self) {
	Game* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	Player _tmp2_ = 0;
	Player _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	Game* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint depth = 0;
	gint _tmp14_ = 0;
	gint tiles_remaining = 0;
	Game* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	ComputerPlayerStrategy _tmp18_ = 0;
	gint _tmp19_ = 0;
	ComputerPlayerStrategy strategy = 0;
	ComputerPlayerStrategy _tmp20_ = 0;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	gint x = 0;
	gint y = 0;
	Game* _tmp25_ = NULL;
	Game* _tmp26_ = NULL;
	Game* _tmp27_ = NULL;
	ComputerPlayerStrategy _tmp28_ = 0;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
	Game* _tmp32_ = NULL;
	gint _tmp33_ = 0;
	gint _tmp34_ = 0;
	gint _tmp35_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->game;
	_tmp1_ = self->priv->game;
	_tmp2_ = game_get_current_color (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = game_can_move (_tmp0_, _tmp3_);
	g_return_if_fail (_tmp4_);
	_tmp5_ = self->priv->game;
	_tmp6_ = game_get_n_tiles (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ < 8) {
		gint x = 0;
		gint y = 0;
		Game* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		Game* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		_tmp8_ = self->priv->game;
		computer_player_random_select (_tmp8_, &_tmp9_, &_tmp10_);
		x = _tmp9_;
		y = _tmp10_;
		_tmp11_ = self->priv->game;
		_tmp12_ = x;
		_tmp13_ = y;
		game_place_tile (_tmp11_, _tmp12_, _tmp13_);
		return;
	}
	_tmp14_ = self->priv->_level;
	depth = 7 - ((3 - _tmp14_) * 2);
	_tmp15_ = self->priv->game;
	_tmp16_ = game_get_n_tiles (_tmp15_);
	_tmp17_ = _tmp16_;
	tiles_remaining = 64 - _tmp17_;
	_tmp19_ = self->priv->_level;
	if (_tmp19_ == 1) {
		_tmp18_ = COMPUTER_PLAYER_STRATEGY_PERFECT;
	} else {
		_tmp18_ = COMPUTER_PLAYER_STRATEGY_BEST;
	}
	_tmp20_ = _tmp18_;
	strategy = _tmp20_;
	_tmp21_ = tiles_remaining;
	_tmp22_ = depth;
	if (_tmp21_ <= (_tmp22_ + 10)) {
		strategy = COMPUTER_PLAYER_STRATEGY_PERFECT;
	} else {
		gint _tmp23_ = 0;
		gint _tmp24_ = 0;
		_tmp23_ = tiles_remaining;
		_tmp24_ = depth;
		if (_tmp23_ <= (_tmp24_ + 12)) {
			strategy = COMPUTER_PLAYER_STRATEGY_VICTORY;
		}
	}
	x = 0;
	y = 0;
	_tmp25_ = self->priv->game;
	_tmp26_ = game_new_copy (_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = strategy;
	_tmp29_ = depth;
	_tmp30_ = G_MININT;
	_tmp31_ = G_MAXINT;
	computer_player_search (_tmp27_, _tmp28_, _tmp29_, _tmp30_, _tmp31_, 1, &x, &y);
	_g_object_unref0 (_tmp27_);
	_tmp32_ = self->priv->game;
	_tmp33_ = x;
	_tmp34_ = y;
	_tmp35_ = game_place_tile (_tmp32_, _tmp33_, _tmp34_);
	if (_tmp35_ == 0) {
		gint _tmp36_ = 0;
		gint _tmp37_ = 0;
		_tmp36_ = x;
		_tmp37_ = y;
		g_critical ("computer-player.vala:93: Computer chose an invalid move: %d,%d", _tmp36_, _tmp37_);
	}
}


static void _computer_player_possible_move_free0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (computer_player_possible_move_free (var), NULL));
}


static void _g_list_free__computer_player_possible_move_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _computer_player_possible_move_free0_, NULL);
	g_list_free (self);
}


static gpointer _computer_player_possible_move_dup0 (gpointer self) {
	return self ? computer_player_possible_move_dup (self) : NULL;
}


static gint _computer_player_compare_move_gcompare_func (gconstpointer a, gconstpointer b) {
	gint result;
	result = computer_player_compare_move (a, b);
	return result;
}


static gint computer_player_search (Game* g, ComputerPlayerStrategy strategy, gint depth, gint a, gint b, gint p, gint* move_x, gint* move_y) {
	gint result = 0;
	Game* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	GList* moves = NULL;
	GList* _tmp56_ = NULL;
	GList* _tmp59_ = NULL;
	gint _tmp109_ = 0;
	g_return_val_if_fail (g != NULL, 0);
	_tmp0_ = g;
	_tmp1_ = game_is_complete (_tmp0_);
	g_return_val_if_fail (!_tmp1_, 0);
	_tmp2_ = p;
	_tmp3_ = p;
	g_return_val_if_fail ((_tmp2_ == 1) || (_tmp3_ == (-1)), 0);
	_tmp4_ = a;
	_tmp5_ = b;
	g_return_val_if_fail (_tmp4_ < _tmp5_, 0);
	_tmp6_ = depth;
	if (_tmp6_ == 0) {
		Game* _tmp7_ = NULL;
		ComputerPlayerStrategy _tmp8_ = 0;
		gint _tmp9_ = 0;
		_tmp7_ = g;
		_tmp8_ = strategy;
		_tmp9_ = computer_player_calculate_heuristic (_tmp7_, _tmp8_);
		result = _tmp9_;
		return result;
	}
	moves = NULL;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp10_ = FALSE;
			_tmp10_ = TRUE;
			while (TRUE) {
				gboolean _tmp11_ = FALSE;
				gint _tmp13_ = 0;
				_tmp11_ = _tmp10_;
				if (!_tmp11_) {
					gint _tmp12_ = 0;
					_tmp12_ = x;
					x = _tmp12_ + 1;
				}
				_tmp10_ = FALSE;
				_tmp13_ = x;
				if (!(_tmp13_ < 8)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp14_ = FALSE;
						_tmp14_ = TRUE;
						while (TRUE) {
							gboolean _tmp15_ = FALSE;
							gint _tmp17_ = 0;
							gint n_tiles = 0;
							Game* _tmp18_ = NULL;
							gint _tmp19_ = 0;
							gint _tmp20_ = 0;
							gint _tmp21_ = 0;
							Game* _tmp22_ = NULL;
							gboolean _tmp23_ = FALSE;
							_tmp15_ = _tmp14_;
							if (!_tmp15_) {
								gint _tmp16_ = 0;
								_tmp16_ = y;
								y = _tmp16_ + 1;
							}
							_tmp14_ = FALSE;
							_tmp17_ = y;
							if (!(_tmp17_ < 8)) {
								break;
							}
							_tmp18_ = g;
							_tmp19_ = x;
							_tmp20_ = y;
							_tmp21_ = game_place_tile (_tmp18_, _tmp19_, _tmp20_);
							n_tiles = _tmp21_;
							_tmp22_ = g;
							_tmp23_ = game_is_complete (_tmp22_);
							if (_tmp23_) {
								gint _tmp24_ = 0;
								gint _tmp25_ = 0;
								Game* _tmp26_ = NULL;
								Game* _tmp27_ = NULL;
								Player _tmp28_ = 0;
								Player _tmp29_ = 0;
								gint _tmp30_ = 0;
								Game* _tmp31_ = NULL;
								Game* _tmp32_ = NULL;
								Player _tmp33_ = 0;
								Player _tmp34_ = 0;
								Player _tmp35_ = 0;
								gint _tmp36_ = 0;
								_tmp24_ = x;
								*move_x = _tmp24_;
								_tmp25_ = y;
								*move_y = _tmp25_;
								_tmp26_ = g;
								_tmp27_ = g;
								_tmp28_ = game_get_current_color (_tmp27_);
								_tmp29_ = _tmp28_;
								_tmp30_ = game_count_tiles (_tmp26_, _tmp29_);
								_tmp31_ = g;
								_tmp32_ = g;
								_tmp33_ = game_get_current_color (_tmp32_);
								_tmp34_ = _tmp33_;
								_tmp35_ = player_flip_color (_tmp34_);
								_tmp36_ = game_count_tiles (_tmp31_, _tmp35_);
								if (_tmp30_ > _tmp36_) {
									Game* _tmp37_ = NULL;
									gint _tmp38_ = 0;
									gint _tmp39_ = 0;
									gint _tmp42_ = 0;
									_tmp37_ = g;
									game_undo (_tmp37_, 1);
									_tmp39_ = p;
									if (_tmp39_ > 0) {
										gint _tmp40_ = 0;
										_tmp40_ = G_MAXINT;
										_tmp38_ = _tmp40_;
									} else {
										gint _tmp41_ = 0;
										_tmp41_ = G_MININT;
										_tmp38_ = _tmp41_;
									}
									_tmp42_ = _tmp38_;
									result = _tmp42_;
									__g_list_free__computer_player_possible_move_free0_0 (moves);
									return result;
								} else {
									Game* _tmp43_ = NULL;
									gint _tmp44_ = 0;
									gint _tmp45_ = 0;
									gint _tmp48_ = 0;
									_tmp43_ = g;
									game_undo (_tmp43_, 1);
									_tmp45_ = p;
									if (_tmp45_ > 0) {
										gint _tmp46_ = 0;
										_tmp46_ = G_MININT;
										_tmp44_ = _tmp46_;
									} else {
										gint _tmp47_ = 0;
										_tmp47_ = G_MAXINT;
										_tmp44_ = _tmp47_;
									}
									_tmp48_ = _tmp44_;
									result = _tmp48_;
									__g_list_free__computer_player_possible_move_free0_0 (moves);
									return result;
								}
							} else {
								gint _tmp49_ = 0;
								_tmp49_ = n_tiles;
								if (_tmp49_ > 0) {
									ComputerPlayerPossibleMove move = {0};
									gint _tmp50_ = 0;
									gint _tmp51_ = 0;
									gint _tmp52_ = 0;
									ComputerPlayerPossibleMove _tmp53_ = {0};
									ComputerPlayerPossibleMove* _tmp54_ = NULL;
									Game* _tmp55_ = NULL;
									_tmp50_ = x;
									_tmp51_ = y;
									_tmp52_ = n_tiles;
									computer_player_possible_move_init (&move, _tmp50_, _tmp51_, _tmp52_);
									_tmp53_ = move;
									_tmp54_ = _computer_player_possible_move_dup0 (&_tmp53_);
									moves = g_list_insert_sorted (moves, _tmp54_, _computer_player_compare_move_gcompare_func);
									_tmp55_ = g;
									game_undo (_tmp55_, 1);
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp56_ = moves;
	if (_tmp56_ == NULL) {
		ComputerPlayerPossibleMove move = {0};
		ComputerPlayerPossibleMove _tmp57_ = {0};
		ComputerPlayerPossibleMove* _tmp58_ = NULL;
		computer_player_possible_move_init (&move, 0, 0, 0);
		_tmp57_ = move;
		_tmp58_ = _computer_player_possible_move_dup0 (&_tmp57_);
		moves = g_list_append (moves, _tmp58_);
	}
	_tmp59_ = moves;
	{
		GList* move_collection = NULL;
		GList* move_it = NULL;
		move_collection = _tmp59_;
		for (move_it = move_collection; move_it != NULL; move_it = move_it->next) {
			ComputerPlayerPossibleMove* _tmp60_ = NULL;
			ComputerPlayerPossibleMove* move = NULL;
			_tmp60_ = _computer_player_possible_move_dup0 ((ComputerPlayerPossibleMove*) move_it->data);
			move = _tmp60_;
			{
				ComputerPlayerPossibleMove* _tmp61_ = NULL;
				gint _tmp62_ = 0;
				gint _tmp77_ = 0;
				Game* _tmp106_ = NULL;
				gint _tmp107_ = 0;
				gint _tmp108_ = 0;
				_tmp61_ = move;
				_tmp62_ = (*_tmp61_).n_tiles;
				if (_tmp62_ == 0) {
					Game* _tmp63_ = NULL;
					_tmp63_ = g;
					game_pass (_tmp63_);
				} else {
					Game* _tmp64_ = NULL;
					ComputerPlayerPossibleMove* _tmp65_ = NULL;
					gint _tmp66_ = 0;
					ComputerPlayerPossibleMove* _tmp67_ = NULL;
					gint _tmp68_ = 0;
					gint _tmp69_ = 0;
					_tmp64_ = g;
					_tmp65_ = move;
					_tmp66_ = (*_tmp65_).x;
					_tmp67_ = move;
					_tmp68_ = (*_tmp67_).y;
					_tmp69_ = game_place_tile (_tmp64_, _tmp66_, _tmp68_);
					if (_tmp69_ == 0) {
						gint _tmp70_ = 0;
						ComputerPlayerPossibleMove* _tmp71_ = NULL;
						gint _tmp72_ = 0;
						ComputerPlayerPossibleMove* _tmp73_ = NULL;
						gint _tmp74_ = 0;
						ComputerPlayerPossibleMove* _tmp75_ = NULL;
						gint _tmp76_ = 0;
						_tmp70_ = depth;
						_tmp71_ = move;
						_tmp72_ = (*_tmp71_).x;
						_tmp73_ = move;
						_tmp74_ = (*_tmp73_).y;
						_tmp75_ = move;
						_tmp76_ = (*_tmp75_).n_tiles;
						g_warning ("computer-player.vala:155: Computer marked move (depth %d, %d,%d, %d fl" \
"ips) as valid, but is invalid when checking", _tmp70_, _tmp72_, _tmp74_, _tmp76_);
						_computer_player_possible_move_free0 (move);
						continue;
					}
				}
				_tmp77_ = p;
				if (_tmp77_ > 0) {
					gint next_x_move = 0;
					gint next_y_move = 0;
					gint a_new = 0;
					Game* _tmp78_ = NULL;
					ComputerPlayerStrategy _tmp79_ = 0;
					gint _tmp80_ = 0;
					gint _tmp81_ = 0;
					gint _tmp82_ = 0;
					gint _tmp83_ = 0;
					gint _tmp84_ = 0;
					gint _tmp85_ = 0;
					gint _tmp86_ = 0;
					next_x_move = 0;
					next_y_move = 0;
					_tmp78_ = g;
					_tmp79_ = strategy;
					_tmp80_ = depth;
					_tmp81_ = a;
					_tmp82_ = b;
					_tmp83_ = p;
					_tmp84_ = computer_player_search (_tmp78_, _tmp79_, _tmp80_ - 1, _tmp81_, _tmp82_, -_tmp83_, &next_x_move, &next_y_move);
					a_new = _tmp84_;
					_tmp85_ = a_new;
					_tmp86_ = a;
					if (_tmp85_ >= _tmp86_) {
						gint _tmp87_ = 0;
						ComputerPlayerPossibleMove* _tmp88_ = NULL;
						gint _tmp89_ = 0;
						ComputerPlayerPossibleMove* _tmp90_ = NULL;
						gint _tmp91_ = 0;
						_tmp87_ = a_new;
						a = _tmp87_;
						_tmp88_ = move;
						_tmp89_ = (*_tmp88_).x;
						*move_x = _tmp89_;
						_tmp90_ = move;
						_tmp91_ = (*_tmp90_).y;
						*move_y = _tmp91_;
					}
				} else {
					gint next_x_move = 0;
					gint next_y_move = 0;
					gint b_new = 0;
					Game* _tmp92_ = NULL;
					ComputerPlayerStrategy _tmp93_ = 0;
					gint _tmp94_ = 0;
					gint _tmp95_ = 0;
					gint _tmp96_ = 0;
					gint _tmp97_ = 0;
					gint _tmp98_ = 0;
					gint _tmp99_ = 0;
					gint _tmp100_ = 0;
					next_x_move = 0;
					next_y_move = 0;
					_tmp92_ = g;
					_tmp93_ = strategy;
					_tmp94_ = depth;
					_tmp95_ = a;
					_tmp96_ = b;
					_tmp97_ = p;
					_tmp98_ = computer_player_search (_tmp92_, _tmp93_, _tmp94_ - 1, _tmp95_, _tmp96_, -_tmp97_, &next_x_move, &next_y_move);
					b_new = _tmp98_;
					_tmp99_ = b_new;
					_tmp100_ = b;
					if (_tmp99_ <= _tmp100_) {
						gint _tmp101_ = 0;
						ComputerPlayerPossibleMove* _tmp102_ = NULL;
						gint _tmp103_ = 0;
						ComputerPlayerPossibleMove* _tmp104_ = NULL;
						gint _tmp105_ = 0;
						_tmp101_ = b_new;
						b = _tmp101_;
						_tmp102_ = move;
						_tmp103_ = (*_tmp102_).x;
						*move_x = _tmp103_;
						_tmp104_ = move;
						_tmp105_ = (*_tmp104_).y;
						*move_y = _tmp105_;
					}
				}
				_tmp106_ = g;
				game_undo (_tmp106_, 1);
				_tmp107_ = b;
				_tmp108_ = a;
				if (_tmp107_ <= _tmp108_) {
					_computer_player_possible_move_free0 (move);
					break;
				}
				_computer_player_possible_move_free0 (move);
			}
		}
	}
	_tmp109_ = p;
	if (_tmp109_ > 0) {
		gint _tmp110_ = 0;
		_tmp110_ = a;
		result = _tmp110_;
		__g_list_free__computer_player_possible_move_free0_0 (moves);
		return result;
	} else {
		gint _tmp111_ = 0;
		_tmp111_ = b;
		result = _tmp111_;
		__g_list_free__computer_player_possible_move_free0_0 (moves);
		return result;
	}
	__g_list_free__computer_player_possible_move_free0_0 (moves);
}


static gint computer_player_compare_move (ComputerPlayerPossibleMove* a, ComputerPlayerPossibleMove* b) {
	gint result = 0;
	ComputerPlayerPossibleMove* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	ComputerPlayerPossibleMove* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	_tmp0_ = b;
	_tmp1_ = (*_tmp0_).n_tiles;
	_tmp2_ = a;
	_tmp3_ = (*_tmp2_).n_tiles;
	result = _tmp1_ - _tmp3_;
	return result;
}


static gint computer_player_calculate_heuristic (Game* g, ComputerPlayerStrategy strategy) {
	gint result = 0;
	gint tile_difference = 0;
	Game* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	Game* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	Game* _tmp6_ = NULL;
	Player _tmp7_ = 0;
	Player _tmp8_ = 0;
	ComputerPlayerStrategy _tmp10_ = 0;
	g_return_val_if_fail (g != NULL, 0);
	_tmp0_ = g;
	_tmp1_ = game_get_n_dark_tiles (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g;
	_tmp4_ = game_get_n_light_tiles (_tmp3_);
	_tmp5_ = _tmp4_;
	tile_difference = _tmp2_ - _tmp5_;
	_tmp6_ = g;
	_tmp7_ = game_get_current_color (_tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ == PLAYER_DARK) {
		gint _tmp9_ = 0;
		_tmp9_ = tile_difference;
		tile_difference = -_tmp9_;
	}
	_tmp10_ = strategy;
	switch (_tmp10_) {
		case COMPUTER_PLAYER_STRATEGY_PERFECT:
		{
			result = tile_difference;
			return result;
		}
		case COMPUTER_PLAYER_STRATEGY_VICTORY:
		{
			gint _tmp11_ = 0;
			gint _tmp12_ = 0;
			_tmp11_ = tile_difference;
			_tmp12_ = CLAMP (_tmp11_, -1, 1);
			result = _tmp12_;
			return result;
		}
		default:
		{
			gint _tmp13_ = 0;
			Game* _tmp14_ = NULL;
			gint _tmp15_ = 0;
			Game* _tmp16_ = NULL;
			gint _tmp17_ = 0;
			_tmp13_ = tile_difference;
			_tmp14_ = g;
			_tmp15_ = computer_player_around (_tmp14_);
			_tmp16_ = g;
			_tmp17_ = computer_player_eval_heuristic (_tmp16_);
			result = (_tmp13_ - _tmp15_) - _tmp17_;
			return result;
		}
	}
}


static gint computer_player_eval_heuristic (Game* g) {
	gint result = 0;
	gint count = 0;
	g_return_val_if_fail (g != NULL, 0);
	count = 0;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = x;
					x = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = x;
				if (!(_tmp3_ < 8)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gboolean _tmp5_ = FALSE;
							gint _tmp7_ = 0;
							gint h = 0;
							gint _tmp8_ = 0;
							gint _tmp9_ = 0;
							gint _tmp10_ = 0;
							Game* _tmp11_ = NULL;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							Player _tmp14_ = 0;
							Game* _tmp15_ = NULL;
							Player _tmp16_ = 0;
							Player _tmp17_ = 0;
							gint _tmp19_ = 0;
							gint _tmp20_ = 0;
							_tmp5_ = _tmp4_;
							if (!_tmp5_) {
								gint _tmp6_ = 0;
								_tmp6_ = y;
								y = _tmp6_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp7_ = y;
							if (!(_tmp7_ < 8)) {
								break;
							}
							_tmp8_ = y;
							_tmp9_ = x;
							_tmp10_ = COMPUTER_PLAYER_heuristic[(_tmp8_ * 8) + _tmp9_];
							h = _tmp10_;
							_tmp11_ = g;
							_tmp12_ = x;
							_tmp13_ = y;
							_tmp14_ = game_get_owner (_tmp11_, _tmp12_, _tmp13_);
							_tmp15_ = g;
							_tmp16_ = game_get_current_color (_tmp15_);
							_tmp17_ = _tmp16_;
							if (_tmp14_ != _tmp17_) {
								gint _tmp18_ = 0;
								_tmp18_ = h;
								h = -_tmp18_;
							}
							_tmp19_ = count;
							_tmp20_ = h;
							count = _tmp19_ + _tmp20_;
						}
					}
				}
			}
		}
	}
	result = count;
	return result;
}


static gint computer_player_around (Game* g) {
	gint result = 0;
	gint count = 0;
	g_return_val_if_fail (g != NULL, 0);
	count = 0;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = x;
					x = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = x;
				if (!(_tmp3_ < 8)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gboolean _tmp5_ = FALSE;
							gint _tmp7_ = 0;
							gint a = 0;
							gint _tmp8_ = 0;
							Game* _tmp9_ = NULL;
							gint _tmp10_ = 0;
							gint _tmp11_ = 0;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							Game* _tmp14_ = NULL;
							gint _tmp15_ = 0;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							gint _tmp18_ = 0;
							Game* _tmp19_ = NULL;
							gint _tmp20_ = 0;
							gint _tmp21_ = 0;
							gint _tmp22_ = 0;
							gint _tmp23_ = 0;
							Game* _tmp24_ = NULL;
							gint _tmp25_ = 0;
							gint _tmp26_ = 0;
							gint _tmp27_ = 0;
							gint _tmp28_ = 0;
							Game* _tmp29_ = NULL;
							gint _tmp30_ = 0;
							gint _tmp31_ = 0;
							gint _tmp32_ = 0;
							gint _tmp33_ = 0;
							Game* _tmp34_ = NULL;
							gint _tmp35_ = 0;
							gint _tmp36_ = 0;
							gint _tmp37_ = 0;
							gint _tmp38_ = 0;
							Game* _tmp39_ = NULL;
							gint _tmp40_ = 0;
							gint _tmp41_ = 0;
							gint _tmp42_ = 0;
							gint _tmp43_ = 0;
							Game* _tmp44_ = NULL;
							gint _tmp45_ = 0;
							gint _tmp46_ = 0;
							gint _tmp47_ = 0;
							gint _tmp48_ = 0;
							Game* _tmp49_ = NULL;
							gint _tmp50_ = 0;
							gint _tmp51_ = 0;
							Player _tmp52_ = 0;
							Game* _tmp53_ = NULL;
							Player _tmp54_ = 0;
							Player _tmp55_ = 0;
							gint _tmp57_ = 0;
							gint _tmp58_ = 0;
							_tmp5_ = _tmp4_;
							if (!_tmp5_) {
								gint _tmp6_ = 0;
								_tmp6_ = y;
								y = _tmp6_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp7_ = y;
							if (!(_tmp7_ < 8)) {
								break;
							}
							a = 0;
							_tmp8_ = a;
							_tmp9_ = g;
							_tmp10_ = x;
							_tmp11_ = y;
							_tmp12_ = computer_player_is_empty (_tmp9_, _tmp10_ + 1, _tmp11_);
							a = _tmp8_ + _tmp12_;
							_tmp13_ = a;
							_tmp14_ = g;
							_tmp15_ = x;
							_tmp16_ = y;
							_tmp17_ = computer_player_is_empty (_tmp14_, _tmp15_ + 1, _tmp16_ + 1);
							a = _tmp13_ + _tmp17_;
							_tmp18_ = a;
							_tmp19_ = g;
							_tmp20_ = x;
							_tmp21_ = y;
							_tmp22_ = computer_player_is_empty (_tmp19_, _tmp20_, _tmp21_ + 1);
							a = _tmp18_ + _tmp22_;
							_tmp23_ = a;
							_tmp24_ = g;
							_tmp25_ = x;
							_tmp26_ = y;
							_tmp27_ = computer_player_is_empty (_tmp24_, _tmp25_ - 1, _tmp26_ + 1);
							a = _tmp23_ + _tmp27_;
							_tmp28_ = a;
							_tmp29_ = g;
							_tmp30_ = x;
							_tmp31_ = y;
							_tmp32_ = computer_player_is_empty (_tmp29_, _tmp30_ - 1, _tmp31_);
							a = _tmp28_ + _tmp32_;
							_tmp33_ = a;
							_tmp34_ = g;
							_tmp35_ = x;
							_tmp36_ = y;
							_tmp37_ = computer_player_is_empty (_tmp34_, _tmp35_ - 1, _tmp36_ - 1);
							a = _tmp33_ + _tmp37_;
							_tmp38_ = a;
							_tmp39_ = g;
							_tmp40_ = x;
							_tmp41_ = y;
							_tmp42_ = computer_player_is_empty (_tmp39_, _tmp40_, _tmp41_ - 1);
							a = _tmp38_ + _tmp42_;
							_tmp43_ = a;
							_tmp44_ = g;
							_tmp45_ = x;
							_tmp46_ = y;
							_tmp47_ = computer_player_is_empty (_tmp44_, _tmp45_ + 1, _tmp46_ - 1);
							a = _tmp43_ + _tmp47_;
							_tmp48_ = a;
							if (_tmp48_ == 0) {
								a = 2;
							}
							_tmp49_ = g;
							_tmp50_ = x;
							_tmp51_ = y;
							_tmp52_ = game_get_owner (_tmp49_, _tmp50_, _tmp51_);
							_tmp53_ = g;
							_tmp54_ = game_get_current_color (_tmp53_);
							_tmp55_ = _tmp54_;
							if (_tmp52_ != _tmp55_) {
								gint _tmp56_ = 0;
								_tmp56_ = a;
								a = -_tmp56_;
							}
							_tmp57_ = count;
							_tmp58_ = a;
							count = _tmp57_ + _tmp58_;
						}
					}
				}
			}
		}
	}
	result = count;
	return result;
}


static gint computer_player_is_empty (Game* g, gint x, gint y) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gint _tmp4_ = 0;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp15_ = FALSE;
	g_return_val_if_fail (g != NULL, 0);
	_tmp4_ = x;
	if (_tmp4_ < 0) {
		_tmp3_ = TRUE;
	} else {
		gint _tmp5_ = 0;
		_tmp5_ = x;
		_tmp3_ = _tmp5_ >= 8;
	}
	_tmp6_ = _tmp3_;
	if (_tmp6_) {
		_tmp2_ = TRUE;
	} else {
		gint _tmp7_ = 0;
		_tmp7_ = y;
		_tmp2_ = _tmp7_ < 0;
	}
	_tmp8_ = _tmp2_;
	if (_tmp8_) {
		_tmp1_ = TRUE;
	} else {
		gint _tmp9_ = 0;
		_tmp9_ = y;
		_tmp1_ = _tmp9_ >= 8;
	}
	_tmp10_ = _tmp1_;
	if (_tmp10_) {
		_tmp0_ = TRUE;
	} else {
		Game* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		Player _tmp14_ = 0;
		_tmp11_ = g;
		_tmp12_ = x;
		_tmp13_ = y;
		_tmp14_ = game_get_owner (_tmp11_, _tmp12_, _tmp13_);
		_tmp0_ = _tmp14_ != PLAYER_NONE;
	}
	_tmp15_ = _tmp0_;
	if (_tmp15_) {
		result = 0;
		return result;
	}
	result = 1;
	return result;
}


static void computer_player_random_select (Game* g, gint* move_x, gint* move_y) {
	gint _vala_move_x = 0;
	gint _vala_move_y = 0;
	GList* moves = NULL;
	GList* _tmp17_ = NULL;
	g_return_if_fail (g != NULL);
	moves = NULL;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_ = FALSE;
				gint _tmp3_ = 0;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = x;
					x = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = x;
				if (!(_tmp3_ < 8)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gboolean _tmp5_ = FALSE;
							gint _tmp7_ = 0;
							Game* _tmp8_ = NULL;
							gint _tmp9_ = 0;
							gint _tmp10_ = 0;
							Game* _tmp11_ = NULL;
							Player _tmp12_ = 0;
							Player _tmp13_ = 0;
							gboolean _tmp14_ = FALSE;
							_tmp5_ = _tmp4_;
							if (!_tmp5_) {
								gint _tmp6_ = 0;
								_tmp6_ = y;
								y = _tmp6_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp7_ = y;
							if (!(_tmp7_ < 8)) {
								break;
							}
							_tmp8_ = g;
							_tmp9_ = x;
							_tmp10_ = y;
							_tmp11_ = g;
							_tmp12_ = game_get_current_color (_tmp11_);
							_tmp13_ = _tmp12_;
							_tmp14_ = game_can_place (_tmp8_, _tmp9_, _tmp10_, _tmp13_);
							if (_tmp14_) {
								gint _tmp15_ = 0;
								gint _tmp16_ = 0;
								_tmp15_ = x;
								_tmp16_ = y;
								moves = g_list_append (moves, (gpointer) ((gintptr) ((_tmp15_ * 8) + _tmp16_)));
							}
						}
					}
				}
			}
		}
	}
	_tmp17_ = moves;
	if (_tmp17_ != NULL) {
		gint32 i = 0;
		GList* _tmp18_ = NULL;
		guint _tmp19_ = 0U;
		gint32 _tmp20_ = 0;
		gint xy = 0;
		GList* _tmp21_ = NULL;
		gint32 _tmp22_ = 0;
		gconstpointer _tmp23_ = NULL;
		gint _tmp24_ = 0;
		gint _tmp25_ = 0;
		_tmp18_ = moves;
		_tmp19_ = g_list_length (_tmp18_);
		_tmp20_ = g_random_int_range ((gint32) 0, (gint32) ((gint) _tmp19_));
		i = _tmp20_;
		_tmp21_ = moves;
		_tmp22_ = i;
		_tmp23_ = g_list_nth_data (_tmp21_, (guint) _tmp22_);
		xy = (gint) ((gintptr) _tmp23_);
		_tmp24_ = xy;
		_vala_move_x = _tmp24_ / 8;
		_tmp25_ = xy;
		_vala_move_y = _tmp25_ % 8;
	} else {
		gint _tmp26_ = 0;
		_vala_move_y = 0;
		_tmp26_ = _vala_move_y;
		_vala_move_x = _tmp26_;
	}
	_g_list_free0 (moves);
	if (move_x) {
		*move_x = _vala_move_x;
	}
	if (move_y) {
		*move_y = _vala_move_y;
	}
}


gint computer_player_get_level (ComputerPlayer* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_level;
	result = _tmp0_;
	return result;
}


static void computer_player_set_level (ComputerPlayer* self, gint value) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_level = _tmp0_;
	g_object_notify ((GObject *) self, "level");
}


static void computer_player_possible_move_init (ComputerPlayerPossibleMove *self, gint x, gint y, gint n_tiles) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	memset (self, 0, sizeof (ComputerPlayerPossibleMove));
	_tmp0_ = x;
	(*self).x = _tmp0_;
	_tmp1_ = y;
	(*self).y = _tmp1_;
	_tmp2_ = n_tiles;
	(*self).n_tiles = _tmp2_;
}


static ComputerPlayerPossibleMove* computer_player_possible_move_dup (const ComputerPlayerPossibleMove* self) {
	ComputerPlayerPossibleMove* dup;
	dup = g_new0 (ComputerPlayerPossibleMove, 1);
	memcpy (dup, self, sizeof (ComputerPlayerPossibleMove));
	return dup;
}


static void computer_player_possible_move_free (ComputerPlayerPossibleMove* self) {
	g_free (self);
}


static GType computer_player_possible_move_get_type (void) {
	static volatile gsize computer_player_possible_move_type_id__volatile = 0;
	if (g_once_init_enter (&computer_player_possible_move_type_id__volatile)) {
		GType computer_player_possible_move_type_id;
		computer_player_possible_move_type_id = g_boxed_type_register_static ("ComputerPlayerPossibleMove", (GBoxedCopyFunc) computer_player_possible_move_dup, (GBoxedFreeFunc) computer_player_possible_move_free);
		g_once_init_leave (&computer_player_possible_move_type_id__volatile, computer_player_possible_move_type_id);
	}
	return computer_player_possible_move_type_id__volatile;
}


static void computer_player_class_init (ComputerPlayerClass * klass) {
	computer_player_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ComputerPlayerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_computer_player_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_computer_player_set_property;
	G_OBJECT_CLASS (klass)->finalize = computer_player_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPUTER_PLAYER_LEVEL, g_param_spec_int ("level", "level", "level", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void computer_player_instance_init (ComputerPlayer * self) {
	self->priv = COMPUTER_PLAYER_GET_PRIVATE (self);
}


static void computer_player_finalize (GObject* obj) {
	ComputerPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COMPUTER_PLAYER, ComputerPlayer);
	_g_object_unref0 (self->priv->game);
	G_OBJECT_CLASS (computer_player_parent_class)->finalize (obj);
}


GType computer_player_get_type (void) {
	static volatile gsize computer_player_type_id__volatile = 0;
	if (g_once_init_enter (&computer_player_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ComputerPlayerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) computer_player_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ComputerPlayer), 0, (GInstanceInitFunc) computer_player_instance_init, NULL };
		GType computer_player_type_id;
		computer_player_type_id = g_type_register_static (G_TYPE_OBJECT, "ComputerPlayer", &g_define_type_info, 0);
		g_once_init_leave (&computer_player_type_id__volatile, computer_player_type_id);
	}
	return computer_player_type_id__volatile;
}


static void _vala_computer_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ComputerPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_COMPUTER_PLAYER, ComputerPlayer);
	switch (property_id) {
		case COMPUTER_PLAYER_LEVEL:
		g_value_set_int (value, computer_player_get_level (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_computer_player_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ComputerPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_COMPUTER_PLAYER, ComputerPlayer);
	switch (property_id) {
		case COMPUTER_PLAYER_LEVEL:
		computer_player_set_level (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



