/* rygel-http-playlist-handler.c generated by valac 0.22.0.18-aa6c, the Vala compiler
 * generated from rygel-http-playlist-handler.vala, do not modify */

/*
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Jens Georg <jensg@openismus.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libsoup/soup.h>
#include <libgupnp-av/gupnp-av.h>
#include <rygel-core.h>


#define RYGEL_TYPE_DATA_SOURCE (rygel_data_source_get_type ())
#define RYGEL_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSource))
#define RYGEL_IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DATA_SOURCE))
#define RYGEL_DATA_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_DATA_SOURCE, RygelDataSourceIface))

typedef struct _RygelDataSource RygelDataSource;
typedef struct _RygelDataSourceIface RygelDataSourceIface;

#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;

#define RYGEL_TYPE_PLAYLIST_DATASOURCE (rygel_playlist_datasource_get_type ())
#define RYGEL_PLAYLIST_DATASOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_PLAYLIST_DATASOURCE, RygelPlaylistDatasource))
#define RYGEL_PLAYLIST_DATASOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_PLAYLIST_DATASOURCE, RygelPlaylistDatasourceClass))
#define RYGEL_IS_PLAYLIST_DATASOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_PLAYLIST_DATASOURCE))
#define RYGEL_IS_PLAYLIST_DATASOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_PLAYLIST_DATASOURCE))
#define RYGEL_PLAYLIST_DATASOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_PLAYLIST_DATASOURCE, RygelPlaylistDatasourceClass))

typedef struct _RygelPlaylistDatasource RygelPlaylistDatasource;
typedef struct _RygelPlaylistDatasourceClass RygelPlaylistDatasourceClass;
typedef struct _RygelPlaylistDatasourcePrivate RygelPlaylistDatasourcePrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;

#define RYGEL_TYPE_CLIENT_HACKS (rygel_client_hacks_get_type ())
#define RYGEL_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacks))
#define RYGEL_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))
#define RYGEL_IS_CLIENT_HACKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_IS_CLIENT_HACKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CLIENT_HACKS))
#define RYGEL_CLIENT_HACKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CLIENT_HACKS, RygelClientHacksClass))

typedef struct _RygelClientHacks RygelClientHacks;
typedef struct _RygelClientHacksClass RygelClientHacksClass;

#define TYPE_SERIALIZER_TYPE (serializer_type_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block5Data Block5Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_MEDIA_OBJECTS (rygel_media_objects_get_type ())
#define RYGEL_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjects))
#define RYGEL_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))
#define RYGEL_IS_MEDIA_OBJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_IS_MEDIA_OBJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECTS))
#define RYGEL_MEDIA_OBJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECTS, RygelMediaObjectsClass))

typedef struct _RygelMediaObjects RygelMediaObjects;
typedef struct _RygelMediaObjectsClass RygelMediaObjectsClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_TYPE_SERIALIZER (rygel_serializer_get_type ())
#define RYGEL_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializer))
#define RYGEL_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))
#define RYGEL_IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SERIALIZER))
#define RYGEL_IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SERIALIZER))
#define RYGEL_SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SERIALIZER, RygelSerializerClass))

typedef struct _RygelSerializer RygelSerializer;
typedef struct _RygelSerializerClass RygelSerializerClass;
typedef struct _RygelPlaylistDatasourceGenerateDataData RygelPlaylistDatasourceGenerateDataData;

#define RYGEL_TYPE_HTTP_GET_HANDLER (rygel_http_get_handler_get_type ())
#define RYGEL_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler))
#define RYGEL_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))
#define RYGEL_IS_HTTP_GET_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_IS_HTTP_GET_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET_HANDLER))
#define RYGEL_HTTP_GET_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandlerClass))

typedef struct _RygelHTTPGetHandler RygelHTTPGetHandler;
typedef struct _RygelHTTPGetHandlerClass RygelHTTPGetHandlerClass;
typedef struct _RygelHTTPGetHandlerPrivate RygelHTTPGetHandlerPrivate;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;

#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;

#define RYGEL_TYPE_HTTP_PLAYLIST_HANDLER (rygel_http_playlist_handler_get_type ())
#define RYGEL_HTTP_PLAYLIST_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_PLAYLIST_HANDLER, RygelHTTPPlaylistHandler))
#define RYGEL_HTTP_PLAYLIST_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_PLAYLIST_HANDLER, RygelHTTPPlaylistHandlerClass))
#define RYGEL_IS_HTTP_PLAYLIST_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_PLAYLIST_HANDLER))
#define RYGEL_IS_HTTP_PLAYLIST_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_PLAYLIST_HANDLER))
#define RYGEL_HTTP_PLAYLIST_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_PLAYLIST_HANDLER, RygelHTTPPlaylistHandlerClass))

typedef struct _RygelHTTPPlaylistHandler RygelHTTPPlaylistHandler;
typedef struct _RygelHTTPPlaylistHandlerClass RygelHTTPPlaylistHandlerClass;
typedef struct _RygelHTTPPlaylistHandlerPrivate RygelHTTPPlaylistHandlerPrivate;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;

struct _RygelDataSourceIface {
	GTypeInterface parent_iface;
	void (*start) (RygelDataSource* self, RygelHTTPSeek* offsets, GError** error);
	void (*freeze) (RygelDataSource* self);
	void (*thaw) (RygelDataSource* self);
	void (*stop) (RygelDataSource* self);
};

struct _RygelPlaylistDatasource {
	GObject parent_instance;
	RygelPlaylistDatasourcePrivate * priv;
};

struct _RygelPlaylistDatasourceClass {
	GObjectClass parent_class;
};

typedef enum  {
	SERIALIZER_TYPE_GENERIC_DIDL,
	SERIALIZER_TYPE_DIDL_S,
	SERIALIZER_TYPE_M3UEXT
} SerializerType;

struct _RygelPlaylistDatasourcePrivate {
	RygelMediaContainer* container;
	guint8* data;
	gint data_length1;
	gint _data_size_;
	RygelHTTPServer* server;
	RygelClientHacks* hacks;
	SerializerType playlist_type;
};

struct _Block5Data {
	int _ref_count_;
	RygelPlaylistDatasource * self;
	RygelHTTPSeek* offsets;
};

typedef enum  {
	RYGEL_DATA_SOURCE_ERROR_GENERAL,
	RYGEL_DATA_SOURCE_ERROR_SEEK_FAILED
} RygelDataSourceError;
#define RYGEL_DATA_SOURCE_ERROR rygel_data_source_error_quark ()
struct _RygelPlaylistDatasourceGenerateDataData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelPlaylistDatasource* self;
	gchar* sort_criteria;
	RygelMediaContainer* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gint count;
	RygelMediaContainer* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	RygelMediaObjects* children;
	RygelMediaContainer* _tmp7_;
	gint _tmp8_;
	const gchar* _tmp9_;
	RygelMediaObjects* _tmp10_;
	RygelMediaObjects* _tmp11_;
	RygelSerializer* serializer;
	SerializerType _tmp12_;
	RygelSerializer* _tmp13_;
	RygelMediaObjects* _tmp14_;
	RygelSerializer* _tmp15_;
	RygelHTTPServer* _tmp16_;
	RygelClientHacks* _tmp17_;
	gchar* xml;
	RygelSerializer* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	guint8* _tmp21_;
	gint _tmp21__length1;
	guint8* _tmp22_;
	gint _tmp22__length1;
	guint8* _tmp23_;
	gint _tmp23__length1;
	const gchar* _tmp24_;
	GError* _tmp25_;
	GError* _tmp26_;
	GError* _error_;
	GError* _tmp27_;
	const gchar* _tmp28_;
	GError* _tmp29_;
	GError * _inner_error_;
};

typedef enum  {
	RYGEL_HTTP_REQUEST_ERROR_UNACCEPTABLE = SOUP_STATUS_NOT_ACCEPTABLE,
	RYGEL_HTTP_REQUEST_ERROR_BAD_REQUEST = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND = SOUP_STATUS_NOT_FOUND,
	RYGEL_HTTP_REQUEST_ERROR_INTERNAL_SERVER_ERROR = SOUP_STATUS_INTERNAL_SERVER_ERROR
} RygelHTTPRequestError;
#define RYGEL_HTTP_REQUEST_ERROR rygel_http_request_error_quark ()
struct _RygelHTTPGetHandler {
	GObject parent_instance;
	RygelHTTPGetHandlerPrivate * priv;
};

struct _RygelHTTPGetHandlerClass {
	GObjectClass parent_class;
	void (*add_response_headers) (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
	gboolean (*knows_size) (RygelHTTPGetHandler* self, RygelHTTPGet* request);
	RygelHTTPResponse* (*render_body) (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
	GUPnPDIDLLiteResource* (*add_resource) (RygelHTTPGetHandler* self, GUPnPDIDLLiteObject* didl_object, RygelHTTPGet* request, GError** error);
};

struct _RygelHTTPPlaylistHandler {
	RygelHTTPGetHandler parent_instance;
	RygelHTTPPlaylistHandlerPrivate * priv;
};

struct _RygelHTTPPlaylistHandlerClass {
	RygelHTTPGetHandlerClass parent_class;
};

struct _RygelHTTPPlaylistHandlerPrivate {
	SerializerType playlist_type;
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaObject* object;
	RygelClientHacks* hack;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_, GError** error);
};


static gpointer rygel_playlist_datasource_parent_class = NULL;
static RygelDataSourceIface* rygel_playlist_datasource_rygel_data_source_parent_iface = NULL;
static gpointer rygel_http_playlist_handler_parent_class = NULL;

GType rygel_http_seek_get_type (void) G_GNUC_CONST;
GType rygel_data_source_get_type (void) G_GNUC_CONST;
GType rygel_playlist_datasource_get_type (void) G_GNUC_CONST;
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_container_get_type (void) G_GNUC_CONST;
GType rygel_transcode_manager_get_type (void) G_GNUC_CONST;
GType rygel_http_server_get_type (void) G_GNUC_CONST;
GType rygel_client_hacks_get_type (void) G_GNUC_CONST;
GType serializer_type_get_type (void) G_GNUC_CONST;
#define RYGEL_PLAYLIST_DATASOURCE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_PLAYLIST_DATASOURCE, RygelPlaylistDatasourcePrivate))
enum  {
	RYGEL_PLAYLIST_DATASOURCE_DUMMY_PROPERTY
};
RygelPlaylistDatasource* rygel_playlist_datasource_new (SerializerType playlist_type, RygelMediaContainer* container, RygelHTTPServer* server, RygelClientHacks* hacks);
RygelPlaylistDatasource* rygel_playlist_datasource_construct (GType object_type, SerializerType playlist_type, RygelMediaContainer* container, RygelHTTPServer* server, RygelClientHacks* hacks);
void rygel_playlist_datasource_generate_data (RygelPlaylistDatasource* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_playlist_datasource_generate_data_finish (RygelPlaylistDatasource* self, GAsyncResult* _res_);
static void rygel_playlist_datasource_real_start (RygelDataSource* base, RygelHTTPSeek* offsets, GError** error);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
GQuark rygel_data_source_error_quark (void);
static void ___lambda14_ (Block5Data* _data5_);
void rygel_data_source_start (RygelDataSource* self, RygelHTTPSeek* offsets, GError** error);
static void ____lambda14__rygel_playlist_datasource_data_ready (RygelPlaylistDatasource* _sender, gpointer self);
static gboolean __lambda15_ (RygelPlaylistDatasource* self);
static gboolean ___lambda15__gsource_func (gpointer self);
static void rygel_playlist_datasource_real_freeze (RygelDataSource* base);
static void rygel_playlist_datasource_real_thaw (RygelDataSource* base);
static void rygel_playlist_datasource_real_stop (RygelDataSource* base);
static void rygel_playlist_datasource_generate_data_data_free (gpointer _data);
static gboolean rygel_playlist_datasource_generate_data_co (RygelPlaylistDatasourceGenerateDataData* _data_);
const gchar* rygel_media_container_get_sort_criteria (RygelMediaContainer* self);
gint rygel_media_container_get_child_count (RygelMediaContainer* self);
GType rygel_media_objects_get_type (void) G_GNUC_CONST;
void rygel_media_container_get_children (RygelMediaContainer* self, guint offset, guint max_count, const gchar* sort_criteria, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
RygelMediaObjects* rygel_media_container_get_children_finish (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
static void rygel_playlist_datasource_generate_data_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GType rygel_serializer_get_type (void) G_GNUC_CONST;
RygelSerializer* rygel_serializer_new (SerializerType type);
RygelSerializer* rygel_serializer_construct (GType object_type, SerializerType type);
void rygel_media_objects_serialize (RygelMediaObjects* self, RygelSerializer* serializer, RygelHTTPServer* http_server, RygelClientHacks* hacks, GError** error);
gchar* rygel_serializer_get_string (RygelSerializer* self);
static guint8* _vala_array_dup1 (guint8* self, int length);
static void rygel_playlist_datasource_finalize (GObject* obj);
GType rygel_http_get_handler_get_type (void) G_GNUC_CONST;
GType rygel_http_request_get_type (void) G_GNUC_CONST;
GType rygel_http_get_get_type (void) G_GNUC_CONST;
GQuark rygel_http_request_error_quark (void);
GType rygel_http_response_get_type (void) G_GNUC_CONST;
GType rygel_http_playlist_handler_get_type (void) G_GNUC_CONST;
#define RYGEL_HTTP_PLAYLIST_HANDLER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_PLAYLIST_HANDLER, RygelHTTPPlaylistHandlerPrivate))
enum  {
	RYGEL_HTTP_PLAYLIST_HANDLER_DUMMY_PROPERTY
};
gboolean rygel_http_playlist_handler_is_supported (const gchar* playlist_format);
RygelHTTPPlaylistHandler* rygel_http_playlist_handler_new (const gchar* playlist_format, GCancellable* cancellable);
RygelHTTPPlaylistHandler* rygel_http_playlist_handler_construct (GType object_type, const gchar* playlist_format, GCancellable* cancellable);
RygelHTTPGetHandler* rygel_http_get_handler_construct (GType object_type);
void rygel_http_get_handler_set_cancellable (RygelHTTPGetHandler* self, GCancellable* value);
static void rygel_http_playlist_handler_real_add_response_headers (RygelHTTPGetHandler* base, RygelHTTPGet* request, GError** error);
GType rygel_http_item_uri_get_type (void) G_GNUC_CONST;
void rygel_http_get_handler_add_response_headers (RygelHTTPGetHandler* self, RygelHTTPGet* request, GError** error);
static RygelHTTPResponse* rygel_http_playlist_handler_real_render_body (RygelHTTPGetHandler* base, RygelHTTPGet* request, GError** error);
RygelHTTPResponse* rygel_http_response_new (RygelHTTPGet* request, RygelHTTPGetHandler* request_handler, RygelDataSource* src, GError** error);
RygelHTTPResponse* rygel_http_response_construct (GType object_type, RygelHTTPGet* request, RygelHTTPGetHandler* request_handler, RygelDataSource* src, GError** error);
static GUPnPDIDLLiteResource* rygel_http_playlist_handler_real_add_resource (RygelHTTPGetHandler* base, GUPnPDIDLLiteObject* didl_object, RygelHTTPGet* request, GError** error);
gchar* rygel_transcode_manager_get_protocol (RygelTranscodeManager* self);
GUPnPDIDLLiteResource* rygel_media_object_add_resource (RygelMediaObject* self, GUPnPDIDLLiteObject* object, const gchar* uri, const gchar* protocol, const gchar* import_uri, GError** error);
static void rygel_http_playlist_handler_finalize (GObject* obj);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelPlaylistDatasource* rygel_playlist_datasource_construct (GType object_type, SerializerType playlist_type, RygelMediaContainer* container, RygelHTTPServer* server, RygelClientHacks* hacks) {
	RygelPlaylistDatasource * self = NULL;
	SerializerType _tmp0_ = 0;
	RygelMediaContainer* _tmp1_ = NULL;
	RygelMediaContainer* _tmp2_ = NULL;
	RygelHTTPServer* _tmp3_ = NULL;
	RygelHTTPServer* _tmp4_ = NULL;
	RygelClientHacks* _tmp5_ = NULL;
	RygelClientHacks* _tmp6_ = NULL;
	g_return_val_if_fail (container != NULL, NULL);
	g_return_val_if_fail (server != NULL, NULL);
	self = (RygelPlaylistDatasource*) g_object_new (object_type, NULL);
	_tmp0_ = playlist_type;
	self->priv->playlist_type = _tmp0_;
	_tmp1_ = container;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->container);
	self->priv->container = _tmp2_;
	_tmp3_ = server;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->server);
	self->priv->server = _tmp4_;
	_tmp5_ = hacks;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_g_object_unref0 (self->priv->hacks);
	self->priv->hacks = _tmp6_;
	rygel_playlist_datasource_generate_data (self, NULL, NULL);
	return self;
}


RygelPlaylistDatasource* rygel_playlist_datasource_new (SerializerType playlist_type, RygelMediaContainer* container, RygelHTTPServer* server, RygelClientHacks* hacks) {
	return rygel_playlist_datasource_construct (RYGEL_TYPE_PLAYLIST_DATASOURCE, playlist_type, container, server, hacks);
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		RygelPlaylistDatasource * self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->offsets);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}


static void ___lambda14_ (Block5Data* _data5_) {
	RygelPlaylistDatasource * self;
	GError * _inner_error_ = NULL;
	self = _data5_->self;
	{
		RygelHTTPSeek* _tmp0_ = NULL;
		_tmp0_ = _data5_->offsets;
		rygel_data_source_start ((RygelDataSource*) self, _tmp0_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch33_g_error;
		}
	}
	goto __finally33;
	__catch33_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally33:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ____lambda14__rygel_playlist_datasource_data_ready (RygelPlaylistDatasource* _sender, gpointer self) {
	___lambda14_ (self);
}


static gboolean __lambda15_ (RygelPlaylistDatasource* self) {
	gboolean result = FALSE;
	guint8* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	_tmp0_ = self->priv->data;
	_tmp0__length1 = self->priv->data_length1;
	g_signal_emit_by_name ((RygelDataSource*) self, "data-available", _tmp0_, _tmp0__length1);
	g_signal_emit_by_name ((RygelDataSource*) self, "done");
	result = FALSE;
	return result;
}


static gboolean ___lambda15__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda15_ (self);
	return result;
}


static void rygel_playlist_datasource_real_start (RygelDataSource* base, RygelHTTPSeek* offsets, GError** error) {
	RygelPlaylistDatasource * self;
	Block5Data* _data5_;
	RygelHTTPSeek* _tmp0_ = NULL;
	RygelHTTPSeek* _tmp1_ = NULL;
	RygelHTTPSeek* _tmp2_ = NULL;
	guint8* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	GError * _inner_error_ = NULL;
	self = (RygelPlaylistDatasource*) base;
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = offsets;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data5_->offsets);
	_data5_->offsets = _tmp1_;
	_tmp2_ = _data5_->offsets;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_ = NULL;
		_tmp3_ = _ ("Seeking not supported");
		_tmp4_ = g_error_new_literal (RYGEL_DATA_SOURCE_ERROR, RYGEL_DATA_SOURCE_ERROR_SEEK_FAILED, _tmp3_);
		_inner_error_ = _tmp4_;
		g_propagate_error (error, _inner_error_);
		block5_data_unref (_data5_);
		_data5_ = NULL;
		return;
	}
	_tmp5_ = self->priv->data;
	_tmp5__length1 = self->priv->data_length1;
	if (_tmp5_ == NULL) {
		g_signal_connect_data (self, "data-ready", (GCallback) ____lambda14__rygel_playlist_datasource_data_ready, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
		block5_data_unref (_data5_);
		_data5_ = NULL;
		return;
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda15__gsource_func, g_object_ref (self), g_object_unref);
	block5_data_unref (_data5_);
	_data5_ = NULL;
}


static void rygel_playlist_datasource_real_freeze (RygelDataSource* base) {
	RygelPlaylistDatasource * self;
	self = (RygelPlaylistDatasource*) base;
}


static void rygel_playlist_datasource_real_thaw (RygelDataSource* base) {
	RygelPlaylistDatasource * self;
	self = (RygelPlaylistDatasource*) base;
}


static void rygel_playlist_datasource_real_stop (RygelDataSource* base) {
	RygelPlaylistDatasource * self;
	self = (RygelPlaylistDatasource*) base;
}


static void rygel_playlist_datasource_generate_data_data_free (gpointer _data) {
	RygelPlaylistDatasourceGenerateDataData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (RygelPlaylistDatasourceGenerateDataData, _data_);
}


void rygel_playlist_datasource_generate_data (RygelPlaylistDatasource* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelPlaylistDatasourceGenerateDataData* _data_;
	RygelPlaylistDatasource* _tmp0_ = NULL;
	_data_ = g_slice_new0 (RygelPlaylistDatasourceGenerateDataData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_playlist_datasource_generate_data);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_playlist_datasource_generate_data_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	rygel_playlist_datasource_generate_data_co (_data_);
}


void rygel_playlist_datasource_generate_data_finish (RygelPlaylistDatasource* self, GAsyncResult* _res_) {
	RygelPlaylistDatasourceGenerateDataData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_playlist_datasource_generate_data_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelPlaylistDatasourceGenerateDataData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	rygel_playlist_datasource_generate_data_co (_data_);
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res = NULL;
	gint res_length1 = 0;
	gint _res_size_ = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guint8* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static guint8* _vala_array_dup1 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


static gboolean rygel_playlist_datasource_generate_data_co (RygelPlaylistDatasourceGenerateDataData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = NULL;
		_data_->_tmp0_ = _data_->self->priv->container;
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = rygel_media_container_get_sort_criteria (_data_->_tmp0_);
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = _data_->_tmp1_;
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = g_strdup (_data_->_tmp2_);
		_data_->sort_criteria = _data_->_tmp3_;
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->self->priv->container;
		_data_->_tmp5_ = 0;
		_data_->_tmp5_ = rygel_media_container_get_child_count (_data_->_tmp4_);
		_data_->_tmp6_ = 0;
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->count = _data_->_tmp6_;
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _data_->self->priv->container;
		_data_->_tmp8_ = 0;
		_data_->_tmp8_ = _data_->count;
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _data_->sort_criteria;
		_data_->_state_ = 1;
		rygel_media_container_get_children (_data_->_tmp7_, (guint) 0, (guint) _data_->_tmp8_, _data_->_tmp9_, NULL, rygel_playlist_datasource_generate_data_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = rygel_media_container_get_children_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error_);
		_data_->children = _data_->_tmp10_;
		if (_data_->_inner_error_ != NULL) {
			_g_free0 (_data_->sort_criteria);
			goto __catch34_g_error;
		}
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _data_->children;
		if (_data_->_tmp11_ != NULL) {
			_data_->_tmp12_ = 0;
			_data_->_tmp12_ = _data_->self->priv->playlist_type;
			_data_->_tmp13_ = NULL;
			_data_->_tmp13_ = rygel_serializer_new (_data_->_tmp12_);
			_data_->serializer = _data_->_tmp13_;
			_data_->_tmp14_ = NULL;
			_data_->_tmp14_ = _data_->children;
			_data_->_tmp15_ = NULL;
			_data_->_tmp15_ = _data_->serializer;
			_data_->_tmp16_ = NULL;
			_data_->_tmp16_ = _data_->self->priv->server;
			_data_->_tmp17_ = NULL;
			_data_->_tmp17_ = _data_->self->priv->hacks;
			rygel_media_objects_serialize (_data_->_tmp14_, _data_->_tmp15_, _data_->_tmp16_, _data_->_tmp17_, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				_g_object_unref0 (_data_->serializer);
				_g_object_unref0 (_data_->children);
				_g_free0 (_data_->sort_criteria);
				goto __catch34_g_error;
			}
			_data_->_tmp18_ = NULL;
			_data_->_tmp18_ = _data_->serializer;
			_data_->_tmp19_ = NULL;
			_data_->_tmp19_ = rygel_serializer_get_string (_data_->_tmp18_);
			_data_->xml = _data_->_tmp19_;
			_data_->_tmp20_ = NULL;
			_data_->_tmp20_ = _data_->xml;
			_data_->_tmp21_ = NULL;
			_data_->_tmp21__length1 = 0;
			_data_->_tmp21_ = string_get_data (_data_->_tmp20_, &_data_->_tmp21__length1);
			_data_->_tmp22_ = NULL;
			_data_->_tmp22__length1 = 0;
			_data_->_tmp22_ = _data_->_tmp21_;
			_data_->_tmp22__length1 = _data_->_tmp21__length1;
			_data_->_tmp23_ = NULL;
			_data_->_tmp23__length1 = 0;
			_data_->_tmp23_ = (_data_->_tmp22_ != NULL) ? _vala_array_dup1 (_data_->_tmp22_, _data_->_tmp22__length1) : ((gpointer) _data_->_tmp22_);
			_data_->_tmp23__length1 = _data_->_tmp22__length1;
			_data_->self->priv->data = (g_free (_data_->self->priv->data), NULL);
			_data_->self->priv->data = _data_->_tmp23_;
			_data_->self->priv->data_length1 = _data_->_tmp23__length1;
			_data_->self->priv->_data_size_ = _data_->self->priv->data_length1;
			g_signal_emit_by_name (_data_->self, "data-ready");
			_g_free0 (_data_->xml);
			_g_object_unref0 (_data_->serializer);
		} else {
			_data_->_tmp24_ = NULL;
			_data_->_tmp24_ = _ ("Failed to generate playlist");
			_data_->_tmp25_ = NULL;
			_data_->_tmp25_ = g_error_new_literal (RYGEL_DATA_SOURCE_ERROR, RYGEL_DATA_SOURCE_ERROR_GENERAL, _data_->_tmp24_);
			_data_->_tmp26_ = NULL;
			_data_->_tmp26_ = _data_->_tmp25_;
			g_signal_emit_by_name ((RygelDataSource*) _data_->self, "error", _data_->_tmp26_);
			_g_error_free0 (_data_->_tmp26_);
		}
		_g_object_unref0 (_data_->children);
		_g_free0 (_data_->sort_criteria);
	}
	goto __finally34;
	__catch34_g_error:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp27_ = NULL;
		_data_->_tmp27_ = _data_->_error_;
		_data_->_tmp28_ = NULL;
		_data_->_tmp28_ = _data_->_tmp27_->message;
		g_warning ("rygel-http-playlist-handler.vala:100: Could not generate playlist: %s", _data_->_tmp28_);
		_data_->_tmp29_ = NULL;
		_data_->_tmp29_ = _data_->_error_;
		g_signal_emit_by_name ((RygelDataSource*) _data_->self, "error", _data_->_tmp29_);
		_g_error_free0 (_data_->_error_);
	}
	__finally34:
	if (_data_->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void rygel_playlist_datasource_class_init (RygelPlaylistDatasourceClass * klass) {
	rygel_playlist_datasource_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelPlaylistDatasourcePrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_playlist_datasource_finalize;
	g_signal_new ("data_ready", RYGEL_TYPE_PLAYLIST_DATASOURCE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void rygel_playlist_datasource_rygel_data_source_interface_init (RygelDataSourceIface * iface) {
	rygel_playlist_datasource_rygel_data_source_parent_iface = g_type_interface_peek_parent (iface);
	iface->start = (void (*)(RygelDataSource*, RygelHTTPSeek*, GError**)) rygel_playlist_datasource_real_start;
	iface->freeze = (void (*)(RygelDataSource*)) rygel_playlist_datasource_real_freeze;
	iface->thaw = (void (*)(RygelDataSource*)) rygel_playlist_datasource_real_thaw;
	iface->stop = (void (*)(RygelDataSource*)) rygel_playlist_datasource_real_stop;
}


static void rygel_playlist_datasource_instance_init (RygelPlaylistDatasource * self) {
	self->priv = RYGEL_PLAYLIST_DATASOURCE_GET_PRIVATE (self);
}


static void rygel_playlist_datasource_finalize (GObject* obj) {
	RygelPlaylistDatasource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_PLAYLIST_DATASOURCE, RygelPlaylistDatasource);
	_g_object_unref0 (self->priv->container);
	self->priv->data = (g_free (self->priv->data), NULL);
	_g_object_unref0 (self->priv->server);
	_g_object_unref0 (self->priv->hacks);
	G_OBJECT_CLASS (rygel_playlist_datasource_parent_class)->finalize (obj);
}


/**
 * Implementation of RygelDataSource to serve generated playlists to a client.
 */
GType rygel_playlist_datasource_get_type (void) {
	static volatile gsize rygel_playlist_datasource_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_playlist_datasource_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelPlaylistDatasourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_playlist_datasource_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelPlaylistDatasource), 0, (GInstanceInitFunc) rygel_playlist_datasource_instance_init, NULL };
		static const GInterfaceInfo rygel_data_source_info = { (GInterfaceInitFunc) rygel_playlist_datasource_rygel_data_source_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_playlist_datasource_type_id;
		rygel_playlist_datasource_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelPlaylistDatasource", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_playlist_datasource_type_id, RYGEL_TYPE_DATA_SOURCE, &rygel_data_source_info);
		g_once_init_leave (&rygel_playlist_datasource_type_id__volatile, rygel_playlist_datasource_type_id);
	}
	return rygel_playlist_datasource_type_id__volatile;
}


gboolean rygel_http_playlist_handler_is_supported (const gchar* playlist_format) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (playlist_format != NULL, FALSE);
	_tmp1_ = playlist_format;
	if (g_strcmp0 (_tmp1_, "DIDL_S") == 0) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = playlist_format;
		_tmp0_ = g_strcmp0 (_tmp2_, "M3U") == 0;
	}
	_tmp3_ = _tmp0_;
	result = _tmp3_;
	return result;
}


RygelHTTPPlaylistHandler* rygel_http_playlist_handler_construct (GType object_type, const gchar* playlist_format, GCancellable* cancellable) {
	RygelHTTPPlaylistHandler * self = NULL;
	const gchar* _tmp0_ = NULL;
	GCancellable* _tmp2_ = NULL;
	g_return_val_if_fail (playlist_format != NULL, NULL);
	self = (RygelHTTPPlaylistHandler*) rygel_http_get_handler_construct (object_type);
	_tmp0_ = playlist_format;
	if (g_strcmp0 (_tmp0_, "DIDL_S") == 0) {
		self->priv->playlist_type = SERIALIZER_TYPE_DIDL_S;
	} else {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = playlist_format;
		if (g_strcmp0 (_tmp1_, "M3U") == 0) {
			self->priv->playlist_type = SERIALIZER_TYPE_M3UEXT;
		}
	}
	_tmp2_ = cancellable;
	rygel_http_get_handler_set_cancellable ((RygelHTTPGetHandler*) self, _tmp2_);
	return self;
}


RygelHTTPPlaylistHandler* rygel_http_playlist_handler_new (const gchar* playlist_format, GCancellable* cancellable) {
	return rygel_http_playlist_handler_construct (RYGEL_TYPE_HTTP_PLAYLIST_HANDLER, playlist_format, cancellable);
}


static void rygel_http_playlist_handler_real_add_response_headers (RygelHTTPGetHandler* base, RygelHTTPGet* request, GError** error) {
	RygelHTTPPlaylistHandler * self;
	SerializerType _tmp0_ = 0;
	RygelHTTPGet* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelHTTPPlaylistHandler*) base;
	g_return_if_fail (request != NULL);
	_tmp0_ = self->priv->playlist_type;
	switch (_tmp0_) {
		case SERIALIZER_TYPE_DIDL_S:
		{
			RygelHTTPGet* _tmp1_ = NULL;
			SoupMessage* _tmp2_ = NULL;
			SoupMessageHeaders* _tmp3_ = NULL;
			_tmp1_ = request;
			_tmp2_ = ((RygelHTTPRequest*) _tmp1_)->msg;
			_tmp3_ = _tmp2_->response_headers;
			soup_message_headers_append (_tmp3_, "Content-Type", "text/xml");
			break;
		}
		case SERIALIZER_TYPE_M3UEXT:
		{
			RygelHTTPGet* _tmp4_ = NULL;
			SoupMessage* _tmp5_ = NULL;
			SoupMessageHeaders* _tmp6_ = NULL;
			_tmp4_ = request;
			_tmp5_ = ((RygelHTTPRequest*) _tmp4_)->msg;
			_tmp6_ = _tmp5_->response_headers;
			soup_message_headers_append (_tmp6_, "ContentType", "audio/x-mpegurl");
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_tmp7_ = request;
	RYGEL_HTTP_GET_HANDLER_CLASS (rygel_http_playlist_handler_parent_class)->add_response_headers (G_TYPE_CHECK_INSTANCE_CAST (self, RYGEL_TYPE_HTTP_GET_HANDLER, RygelHTTPGetHandler), _tmp7_, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static RygelHTTPResponse* rygel_http_playlist_handler_real_render_body (RygelHTTPGetHandler* base, RygelHTTPGet* request, GError** error) {
	RygelHTTPPlaylistHandler * self;
	RygelHTTPResponse* result = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelHTTPPlaylistHandler*) base;
	g_return_val_if_fail (request != NULL, NULL);
	{
		RygelPlaylistDatasource* source = NULL;
		SerializerType _tmp0_ = 0;
		RygelHTTPGet* _tmp1_ = NULL;
		RygelMediaObject* _tmp2_ = NULL;
		RygelHTTPGet* _tmp3_ = NULL;
		RygelHTTPServer* _tmp4_ = NULL;
		RygelHTTPGet* _tmp5_ = NULL;
		RygelClientHacks* _tmp6_ = NULL;
		RygelPlaylistDatasource* _tmp7_ = NULL;
		RygelHTTPResponse* _tmp8_ = NULL;
		RygelHTTPGet* _tmp9_ = NULL;
		RygelPlaylistDatasource* _tmp10_ = NULL;
		RygelHTTPResponse* _tmp11_ = NULL;
		_tmp0_ = self->priv->playlist_type;
		_tmp1_ = request;
		_tmp2_ = ((RygelHTTPRequest*) _tmp1_)->object;
		_tmp3_ = request;
		_tmp4_ = ((RygelHTTPRequest*) _tmp3_)->http_server;
		_tmp5_ = request;
		_tmp6_ = ((RygelHTTPRequest*) _tmp5_)->hack;
		_tmp7_ = rygel_playlist_datasource_new (_tmp0_, G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, RYGEL_TYPE_MEDIA_CONTAINER) ? ((RygelMediaContainer*) _tmp2_) : NULL, _tmp4_, _tmp6_);
		source = _tmp7_;
		_tmp9_ = request;
		_tmp10_ = source;
		_tmp11_ = rygel_http_response_new (_tmp9_, (RygelHTTPGetHandler*) self, (RygelDataSource*) _tmp10_, &_inner_error_);
		_tmp8_ = _tmp11_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (source);
			goto __catch35_g_error;
		}
		result = _tmp8_;
		_g_object_unref0 (source);
		return result;
	}
	goto __finally35;
	__catch35_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		GError* _tmp14_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = _error_;
		_tmp13_ = _tmp12_->message;
		_tmp14_ = g_error_new_literal (RYGEL_HTTP_REQUEST_ERROR, RYGEL_HTTP_REQUEST_ERROR_NOT_FOUND, _tmp13_);
		_inner_error_ = _tmp14_;
		_g_error_free0 (_error_);
		goto __finally35;
	}
	__finally35:
	if (_inner_error_->domain == RYGEL_HTTP_REQUEST_ERROR) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static GUPnPDIDLLiteResource* rygel_http_playlist_handler_real_add_resource (RygelHTTPGetHandler* base, GUPnPDIDLLiteObject* didl_object, RygelHTTPGet* request, GError** error) {
	RygelHTTPPlaylistHandler * self;
	GUPnPDIDLLiteResource* result = NULL;
	gchar* protocol = NULL;
	RygelHTTPGet* _tmp0_ = NULL;
	RygelHTTPServer* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelHTTPPlaylistHandler*) base;
	g_return_val_if_fail (didl_object != NULL, NULL);
	g_return_val_if_fail (request != NULL, NULL);
	_tmp0_ = request;
	_tmp1_ = ((RygelHTTPRequest*) _tmp0_)->http_server;
	_tmp2_ = rygel_transcode_manager_get_protocol ((RygelTranscodeManager*) _tmp1_);
	protocol = _tmp2_;
	{
		GUPnPDIDLLiteResource* res = NULL;
		RygelHTTPGet* _tmp3_ = NULL;
		RygelMediaObject* _tmp4_ = NULL;
		GUPnPDIDLLiteObject* _tmp5_ = NULL;
		GUPnPDIDLLiteResource* _tmp6_ = NULL;
		SerializerType _tmp7_ = 0;
		_tmp3_ = request;
		_tmp4_ = ((RygelHTTPRequest*) _tmp3_)->object;
		_tmp5_ = didl_object;
		_tmp6_ = rygel_media_object_add_resource (_tmp4_, _tmp5_, NULL, protocol, NULL, &_inner_error_);
		res = _tmp6_;
		if (_inner_error_ != NULL) {
			goto __catch36_g_error;
		}
		_tmp7_ = self->priv->playlist_type;
		if (_tmp7_ == SERIALIZER_TYPE_DIDL_S) {
			GUPnPProtocolInfo* _tmp8_ = NULL;
			GUPnPProtocolInfo* _tmp9_ = NULL;
			_tmp8_ = gupnp_didl_lite_resource_get_protocol_info (res);
			_tmp9_ = _tmp8_;
			gupnp_protocol_info_set_dlna_profile (_tmp9_, "DIDL_S");
		}
		result = res;
		_g_free0 (protocol);
		return result;
	}
	goto __finally36;
	__catch36_g_error:
	{
		GError* _error_ = NULL;
		gpointer _tmp10_ = NULL;
		GUPnPDIDLLiteResource* _tmp11_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = NULL;
		_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, gupnp_didl_lite_resource_get_type ()) ? ((GUPnPDIDLLiteResource*) _tmp10_) : NULL);
		result = _tmp11_;
		_g_error_free0 (_error_);
		_g_free0 (protocol);
		return result;
	}
	__finally36:
	_g_free0 (protocol);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
	g_clear_error (&_inner_error_);
	return NULL;
}


static void rygel_http_playlist_handler_class_init (RygelHTTPPlaylistHandlerClass * klass) {
	rygel_http_playlist_handler_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPPlaylistHandlerPrivate));
	RYGEL_HTTP_GET_HANDLER_CLASS (klass)->add_response_headers = rygel_http_playlist_handler_real_add_response_headers;
	RYGEL_HTTP_GET_HANDLER_CLASS (klass)->render_body = rygel_http_playlist_handler_real_render_body;
	RYGEL_HTTP_GET_HANDLER_CLASS (klass)->add_resource = rygel_http_playlist_handler_real_add_resource;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_playlist_handler_finalize;
}


static void rygel_http_playlist_handler_instance_init (RygelHTTPPlaylistHandler * self) {
	self->priv = RYGEL_HTTP_PLAYLIST_HANDLER_GET_PRIVATE (self);
}


static void rygel_http_playlist_handler_finalize (GObject* obj) {
	RygelHTTPPlaylistHandler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_HTTP_PLAYLIST_HANDLER, RygelHTTPPlaylistHandler);
	G_OBJECT_CLASS (rygel_http_playlist_handler_parent_class)->finalize (obj);
}


/**
 * RygelHTTPPlaylistHandler implements a special handler for generating XML
 * playlists (DIDL_S format as defined by DLNA) on-the-fly.
 */
GType rygel_http_playlist_handler_get_type (void) {
	static volatile gsize rygel_http_playlist_handler_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_playlist_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPPlaylistHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_playlist_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPPlaylistHandler), 0, (GInstanceInitFunc) rygel_http_playlist_handler_instance_init, NULL };
		GType rygel_http_playlist_handler_type_id;
		rygel_http_playlist_handler_type_id = g_type_register_static (RYGEL_TYPE_HTTP_GET_HANDLER, "RygelHTTPPlaylistHandler", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_playlist_handler_type_id__volatile, rygel_http_playlist_handler_type_id);
	}
	return rygel_http_playlist_handler_type_id__volatile;
}



