/* print-dialog.c generated by valac 0.26.0.21-afb3, the Vala compiler
 * generated from print-dialog.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "libsudoku.h"
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gee.h>


#define TYPE_PRINT_DIALOG (print_dialog_get_type ())
#define PRINT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PRINT_DIALOG, PrintDialog))
#define PRINT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PRINT_DIALOG, PrintDialogClass))
#define IS_PRINT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PRINT_DIALOG))
#define IS_PRINT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PRINT_DIALOG))
#define PRINT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PRINT_DIALOG, PrintDialogClass))

typedef struct _PrintDialog PrintDialog;
typedef struct _PrintDialogClass PrintDialogClass;
typedef struct _PrintDialogPrivate PrintDialogPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block5Data Block5Data;

#define TYPE_SUDOKU_PRINTER (sudoku_printer_get_type ())
#define SUDOKU_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_PRINTER, SudokuPrinter))
#define SUDOKU_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_PRINTER, SudokuPrinterClass))
#define IS_SUDOKU_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_PRINTER))
#define IS_SUDOKU_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_PRINTER))
#define SUDOKU_PRINTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_PRINTER, SudokuPrinterClass))

typedef struct _SudokuPrinter SudokuPrinter;
typedef struct _SudokuPrinterClass SudokuPrinterClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _PrintDialog {
	GtkDialog parent_instance;
	PrintDialogPrivate * priv;
};

struct _PrintDialogClass {
	GtkDialogClass parent_class;
};

struct _PrintDialogPrivate {
	SudokuSaver* saver;
	GSettings* settings;
	GtkSpinButton* n_sudokus_button;
	GtkRadioButton* easy_radio_button;
	GtkRadioButton* medium_radio_button;
	GtkRadioButton* hard_radio_button;
	GtkRadioButton* very_hard_radio_button;
	GtkSpinner* spinner;
	gboolean once;
};

struct _Block5Data {
	int _ref_count_;
	PrintDialog* self;
	gchar* key_name;
	GtkAdjustment* action;
};


static gpointer print_dialog_parent_class = NULL;

GType print_dialog_get_type (void) G_GNUC_CONST;
#define PRINT_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PRINT_DIALOG, PrintDialogPrivate))
enum  {
	PRINT_DIALOG_DUMMY_PROPERTY
};
#define PRINT_DIALOG_DIFFICULTY_KEY_NAME "print-multiple-sudoku-difficulty"
PrintDialog* print_dialog_new (SudokuSaver* saver, GtkWindow* window);
PrintDialog* print_dialog_construct (GType object_type, SudokuSaver* saver, GtkWindow* window);
static void print_dialog_wrap_adjustment (PrintDialog* self, const gchar* key_name, GtkAdjustment* action);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda18_ (Block5Data* _data5_);
static void ___lambda18__gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self);
static void print_dialog_real_response (GtkDialog* base, gint response);
static void __lambda19_ (PrintDialog* self, GObject* obj, GAsyncResult* res);
GType sudoku_printer_get_type (void) G_GNUC_CONST;
SudokuPrinter* sudoku_printer_new (GeeList* boards, GtkWindow* window);
SudokuPrinter* sudoku_printer_construct (GType object_type, GeeList* boards, GtkWindow* window);
GtkPrintOperationResult sudoku_printer_print_sudoku (SudokuPrinter* self);
static void ___lambda19__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void print_dialog_finalize (GObject* obj);


static gpointer _g_object_ref0 (gpointer self) {
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	return self ? g_object_ref (self) : NULL;
#line 120 "print-dialog.c"
}


PrintDialog* print_dialog_construct (GType object_type, SudokuSaver* saver, GtkWindow* window) {
	PrintDialog * self = NULL;
	gint _tmp0_ = 0;
	GtkSettings* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	SudokuSaver* _tmp4_ = NULL;
	SudokuSaver* _tmp5_ = NULL;
	GSettings* _tmp6_ = NULL;
	GtkWindow* _tmp7_ = NULL;
	GtkSpinner* _tmp8_ = NULL;
	GtkSpinner* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	DifficultyCategory saved_difficulty = 0;
	GSettings* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	DifficultyCategory _tmp16_ = 0;
	GtkSpinButton* _tmp24_ = NULL;
	GtkAdjustment* _tmp25_ = NULL;
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	g_return_val_if_fail (saver != NULL, NULL);
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	g_return_val_if_fail (window != NULL, NULL);
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp1_ = gtk_settings_get_default ();
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	g_object_get (_tmp1_, "gtk-dialogs-use-header", &_tmp2_, NULL);
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp3_ = _tmp2_;
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	if (_tmp3_) {
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_tmp0_ = 1;
#line 158 "print-dialog.c"
	} else {
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_tmp0_ = 0;
#line 162 "print-dialog.c"
	}
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	self = (PrintDialog*) g_object_new (object_type, "use-header-bar", _tmp0_, NULL);
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp4_ = saver;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_g_object_unref0 (self->priv->saver);
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	self->priv->saver = _tmp5_;
#line 52 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp6_ = g_settings_new ("org.gnome.sudoku");
#line 52 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_g_object_unref0 (self->priv->settings);
#line 52 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	self->priv->settings = _tmp6_;
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp7_ = window;
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	gtk_window_set_transient_for ((GtkWindow*) self, _tmp7_);
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp8_ = (GtkSpinner*) gtk_spinner_new ();
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	g_object_ref_sink (_tmp8_);
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_g_object_unref0 (self->priv->spinner);
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	self->priv->spinner = _tmp8_;
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp9_ = self->priv->spinner;
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp9_, GTK_ALIGN_CENTER);
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	g_object_get ((GtkDialog*) self, "use-header-bar", &_tmp10_, NULL);
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp11_ = _tmp10_;
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	if (_tmp11_ == 1) {
#line 202 "print-dialog.c"
		GtkWidget* _tmp12_ = NULL;
		GtkSpinner* _tmp13_ = NULL;
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_tmp12_ = gtk_dialog_get_header_bar ((GtkDialog*) self);
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_tmp13_ = self->priv->spinner;
#line 59 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		gtk_header_bar_pack_end (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_header_bar_get_type (), GtkHeaderBar), (GtkWidget*) _tmp13_);
#line 211 "print-dialog.c"
	}
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp14_ = self->priv->settings;
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp15_ = g_settings_get_enum (_tmp14_, PRINT_DIALOG_DIFFICULTY_KEY_NAME);
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	saved_difficulty = (DifficultyCategory) _tmp15_;
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp16_ = saved_difficulty;
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	if (_tmp16_ == DIFFICULTY_CATEGORY_EASY) {
#line 223 "print-dialog.c"
		GtkRadioButton* _tmp17_ = NULL;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_tmp17_ = self->priv->easy_radio_button;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp17_, TRUE);
#line 229 "print-dialog.c"
	} else {
		DifficultyCategory _tmp18_ = 0;
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_tmp18_ = saved_difficulty;
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		if (_tmp18_ == DIFFICULTY_CATEGORY_MEDIUM) {
#line 236 "print-dialog.c"
			GtkRadioButton* _tmp19_ = NULL;
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
			_tmp19_ = self->priv->medium_radio_button;
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp19_, TRUE);
#line 242 "print-dialog.c"
		} else {
			DifficultyCategory _tmp20_ = 0;
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
			_tmp20_ = saved_difficulty;
#line 66 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
			if (_tmp20_ == DIFFICULTY_CATEGORY_HARD) {
#line 249 "print-dialog.c"
				GtkRadioButton* _tmp21_ = NULL;
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
				_tmp21_ = self->priv->hard_radio_button;
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
				gtk_toggle_button_set_active ((GtkToggleButton*) _tmp21_, TRUE);
#line 255 "print-dialog.c"
			} else {
				DifficultyCategory _tmp22_ = 0;
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
				_tmp22_ = saved_difficulty;
#line 68 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
				if (_tmp22_ == DIFFICULTY_CATEGORY_VERY_HARD) {
#line 262 "print-dialog.c"
					GtkRadioButton* _tmp23_ = NULL;
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
					_tmp23_ = self->priv->very_hard_radio_button;
#line 69 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
					gtk_toggle_button_set_active ((GtkToggleButton*) _tmp23_, TRUE);
#line 268 "print-dialog.c"
				} else {
#line 71 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
					g_assert_not_reached ();
#line 272 "print-dialog.c"
				}
			}
		}
	}
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp24_ = self->priv->n_sudokus_button;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp25_ = gtk_spin_button_get_adjustment (_tmp24_);
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	print_dialog_wrap_adjustment (self, "print-multiple-sudokus-to-print", _tmp25_);
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	return self;
#line 285 "print-dialog.c"
}


PrintDialog* print_dialog_new (SudokuSaver* saver, GtkWindow* window) {
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	return print_dialog_construct (TYPE_PRINT_DIALOG, saver, window);
#line 292 "print-dialog.c"
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	g_atomic_int_inc (&_data5_->_ref_count_);
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	return _data5_;
#line 301 "print-dialog.c"
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
#line 310 "print-dialog.c"
		PrintDialog* self;
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		self = _data5_->self;
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_g_free0 (_data5_->key_name);
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_g_object_unref0 (_data5_->action);
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_g_object_unref0 (self);
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		g_slice_free (Block5Data, _data5_);
#line 322 "print-dialog.c"
	}
}


static void __lambda18_ (Block5Data* _data5_) {
	PrintDialog* self;
	GSettings* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkAdjustment* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	self = _data5_->self;
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp0_ = self->priv->settings;
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp1_ = _data5_->key_name;
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp2_ = _data5_->action;
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp3_ = gtk_adjustment_get_value (_tmp2_);
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	g_settings_set_int (_tmp0_, _tmp1_, (gint) _tmp3_);
#line 345 "print-dialog.c"
}


static void ___lambda18__gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self) {
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	__lambda18_ (self);
#line 352 "print-dialog.c"
}


static void print_dialog_wrap_adjustment (PrintDialog* self, const gchar* key_name, GtkAdjustment* action) {
	Block5Data* _data5_;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GtkAdjustment* _tmp2_ = NULL;
	GtkAdjustment* _tmp3_ = NULL;
	GtkAdjustment* _tmp4_ = NULL;
	GSettings* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	GtkAdjustment* _tmp8_ = NULL;
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	g_return_if_fail (self != NULL);
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	g_return_if_fail (key_name != NULL);
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	g_return_if_fail (action != NULL);
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_data5_ = g_slice_new0 (Block5Data);
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_data5_->_ref_count_ = 1;
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_data5_->self = g_object_ref (self);
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp0_ = key_name;
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_g_free0 (_data5_->key_name);
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_data5_->key_name = _tmp1_;
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp2_ = action;
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_g_object_unref0 (_data5_->action);
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_data5_->action = _tmp3_;
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp4_ = _data5_->action;
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp5_ = self->priv->settings;
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp6_ = _data5_->key_name;
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp7_ = g_settings_get_int (_tmp5_, _tmp6_);
#line 85 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	gtk_adjustment_set_value (_tmp4_, (gdouble) _tmp7_);
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp8_ = _data5_->action;
#line 86 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	g_signal_connect_data (_tmp8_, "value-changed", (GCallback) ___lambda18__gtk_adjustment_value_changed, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	block5_data_unref (_data5_);
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_data5_ = NULL;
#line 413 "print-dialog.c"
}


static void __lambda19_ (PrintDialog* self, GObject* obj, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	g_return_if_fail (res != NULL);
#line 421 "print-dialog.c"
	{
		GeeList* boards = NULL;
		GAsyncResult* _tmp0_ = NULL;
		GeeList* _tmp1_ = NULL;
		GtkSpinner* _tmp2_ = NULL;
		GtkSpinner* _tmp3_ = NULL;
		SudokuPrinter* printer = NULL;
		SudokuPrinter* _tmp4_ = NULL;
		SudokuPrinter* _tmp5_ = NULL;
		GtkPrintOperationResult _tmp6_ = 0;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_tmp0_ = res;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_tmp1_ = sudoku_generator_generate_boards_finish (_tmp0_, &_inner_error_);
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		boards = _tmp1_;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
			if (_inner_error_->domain == G_THREAD_ERROR) {
#line 442 "print-dialog.c"
				goto __catch4_g_thread_error;
			}
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
			g_clear_error (&_inner_error_);
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
			return;
#line 451 "print-dialog.c"
		}
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_tmp2_ = self->priv->spinner;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		gtk_spinner_stop (_tmp2_);
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_tmp3_ = self->priv->spinner;
#line 129 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		gtk_widget_hide ((GtkWidget*) _tmp3_);
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		gtk_widget_set_sensitive ((GtkWidget*) self, TRUE);
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_tmp4_ = sudoku_printer_new (boards, (GtkWindow*) self);
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		printer = _tmp4_;
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_tmp5_ = printer;
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_tmp6_ = sudoku_printer_print_sudoku (_tmp5_);
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		if (_tmp6_ == GTK_PRINT_OPERATION_RESULT_APPLY) {
#line 473 "print-dialog.c"
			{
				GeeList* _board_list = NULL;
				GeeList* _tmp7_ = NULL;
				gint _board_size = 0;
				GeeList* _tmp8_ = NULL;
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				gint _board_index = 0;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
				_tmp7_ = _g_object_ref0 (boards);
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
				_board_list = _tmp7_;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
				_tmp8_ = _board_list;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
				_tmp9_ = gee_collection_get_size ((GeeCollection*) _tmp8_);
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
				_tmp10_ = _tmp9_;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
				_board_size = _tmp10_;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
				_board_index = -1;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
				while (TRUE) {
#line 498 "print-dialog.c"
					gint _tmp11_ = 0;
					gint _tmp12_ = 0;
					gint _tmp13_ = 0;
					SudokuBoard* board = NULL;
					GeeList* _tmp14_ = NULL;
					gint _tmp15_ = 0;
					gpointer _tmp16_ = NULL;
					SudokuSaver* _tmp17_ = NULL;
					SudokuBoard* _tmp18_ = NULL;
					SudokuGame* _tmp19_ = NULL;
					SudokuGame* _tmp20_ = NULL;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
					_tmp11_ = _board_index;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
					_board_index = _tmp11_ + 1;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
					_tmp12_ = _board_index;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
					_tmp13_ = _board_size;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
					if (!(_tmp12_ < _tmp13_)) {
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
						break;
#line 522 "print-dialog.c"
					}
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
					_tmp14_ = _board_list;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
					_tmp15_ = _board_index;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
					_tmp16_ = gee_list_get (_tmp14_, _tmp15_);
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
					board = (SudokuBoard*) _tmp16_;
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
					_tmp17_ = self->priv->saver;
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
					_tmp18_ = board;
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
					_tmp19_ = sudoku_game_new (_tmp18_);
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
					_tmp20_ = _tmp19_;
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
					sudoku_saver_add_game_to_finished (_tmp17_, _tmp20_, FALSE);
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
					_g_object_unref0 (_tmp20_);
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
					_g_object_unref0 (board);
#line 546 "print-dialog.c"
				}
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
				_g_object_unref0 (_board_list);
#line 550 "print-dialog.c"
			}
		}
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_g_object_unref0 (printer);
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_g_object_unref0 (boards);
#line 557 "print-dialog.c"
	}
	goto __finally4;
	__catch4_g_thread_error:
	{
		GError* e = NULL;
		const gchar* _tmp21_ = NULL;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		e = _inner_error_;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_inner_error_ = NULL;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_tmp21_ = e->message;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		g_error ("print-dialog.vala:141: Thread error: %s\n", _tmp21_);
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_g_error_free0 (e);
#line 574 "print-dialog.c"
	}
	__finally4:
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		g_clear_error (&_inner_error_);
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		return;
#line 585 "print-dialog.c"
	}
#line 144 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	g_signal_emit_by_name (self, "finished");
#line 589 "print-dialog.c"
}


static void ___lambda19__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	__lambda19_ ((PrintDialog*) self, source_object, res);
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	g_object_unref (self);
#line 598 "print-dialog.c"
}


static void print_dialog_real_response (GtkDialog* base, gint response) {
	PrintDialog * self;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	gint nsudokus = 0;
	GtkSpinButton* _tmp2_ = NULL;
	GtkAdjustment* _tmp3_ = NULL;
	gdouble _tmp4_ = 0.0;
	DifficultyCategory level = 0;
	GtkRadioButton* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	GSettings* _tmp13_ = NULL;
	DifficultyCategory _tmp14_ = 0;
	GtkSpinner* _tmp15_ = NULL;
	GtkSpinner* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	DifficultyCategory _tmp18_ = 0;
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	self = (PrintDialog*) base;
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp0_ = self->priv->once;
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	if (_tmp0_) {
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		return;
#line 627 "print-dialog.c"
	}
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	self->priv->once = TRUE;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp1_ = response;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	if (_tmp1_ != ((gint) GTK_RESPONSE_OK)) {
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		g_signal_emit_by_name (self, "finished");
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		return;
#line 639 "print-dialog.c"
	}
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp2_ = self->priv->n_sudokus_button;
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp3_ = gtk_spin_button_get_adjustment (_tmp2_);
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp4_ = gtk_adjustment_get_value (_tmp3_);
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	nsudokus = (gint) _tmp4_;
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp5_ = self->priv->easy_radio_button;
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp6_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp5_);
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	if (_tmp6_) {
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		level = DIFFICULTY_CATEGORY_EASY;
#line 657 "print-dialog.c"
	} else {
		GtkRadioButton* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_tmp7_ = self->priv->medium_radio_button;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_tmp8_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp7_);
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		if (_tmp8_) {
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
			level = DIFFICULTY_CATEGORY_MEDIUM;
#line 669 "print-dialog.c"
		} else {
			GtkRadioButton* _tmp9_ = NULL;
			gboolean _tmp10_ = FALSE;
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
			_tmp9_ = self->priv->hard_radio_button;
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
			_tmp10_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp9_);
#line 109 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
			if (_tmp10_) {
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
				level = DIFFICULTY_CATEGORY_HARD;
#line 681 "print-dialog.c"
			} else {
				GtkRadioButton* _tmp11_ = NULL;
				gboolean _tmp12_ = FALSE;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
				_tmp11_ = self->priv->very_hard_radio_button;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
				_tmp12_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp11_);
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
				if (_tmp12_) {
#line 112 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
					level = DIFFICULTY_CATEGORY_VERY_HARD;
#line 693 "print-dialog.c"
				} else {
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
					g_assert_not_reached ();
#line 697 "print-dialog.c"
				}
			}
		}
	}
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp13_ = self->priv->settings;
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp14_ = level;
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	g_settings_set_enum (_tmp13_, PRINT_DIALOG_DIFFICULTY_KEY_NAME, (gint) _tmp14_);
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp15_ = self->priv->spinner;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	gtk_widget_show ((GtkWidget*) _tmp15_);
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp16_ = self->priv->spinner;
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	gtk_spinner_start (_tmp16_);
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	gtk_widget_set_sensitive ((GtkWidget*) self, FALSE);
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp17_ = nsudokus;
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp18_ = level;
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	sudoku_generator_generate_boards_async (_tmp17_, _tmp18_, ___lambda19__gasync_ready_callback, g_object_ref (self));
#line 724 "print-dialog.c"
}


static void print_dialog_class_init (PrintDialogClass * klass) {
	gint PrintDialog_private_offset;
#line 23 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	print_dialog_parent_class = g_type_class_peek_parent (klass);
#line 23 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	g_type_class_add_private (klass, sizeof (PrintDialogPrivate));
#line 23 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	((GtkDialogClass *) klass)->response = print_dialog_real_response;
#line 23 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	G_OBJECT_CLASS (klass)->finalize = print_dialog_finalize;
#line 23 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	PrintDialog_private_offset = g_type_class_get_instance_private_offset (klass);
#line 23 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/sudoku/ui/../data/print-dialog.ui");
#line 23 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	g_signal_new ("finished", TYPE_PRINT_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 23 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "n_sudokus_button", FALSE, PrintDialog_private_offset + G_STRUCT_OFFSET (PrintDialogPrivate, n_sudokus_button));
#line 23 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "easy_radio_button", FALSE, PrintDialog_private_offset + G_STRUCT_OFFSET (PrintDialogPrivate, easy_radio_button));
#line 23 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "medium_radio_button", FALSE, PrintDialog_private_offset + G_STRUCT_OFFSET (PrintDialogPrivate, medium_radio_button));
#line 23 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "hard_radio_button", FALSE, PrintDialog_private_offset + G_STRUCT_OFFSET (PrintDialogPrivate, hard_radio_button));
#line 23 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "very_hard_radio_button", FALSE, PrintDialog_private_offset + G_STRUCT_OFFSET (PrintDialogPrivate, very_hard_radio_button));
#line 754 "print-dialog.c"
}


static void print_dialog_instance_init (PrintDialog * self) {
#line 23 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	self->priv = PRINT_DIALOG_GET_PRIVATE (self);
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	self->priv->once = FALSE;
#line 23 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	gtk_widget_init_template (GTK_WIDGET (self));
#line 765 "print-dialog.c"
}


static void print_dialog_finalize (GObject* obj) {
	PrintDialog * self;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 23 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PRINT_DIALOG, PrintDialog);
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	g_object_get ((GtkDialog*) self, "use-header-bar", &_tmp0_, NULL);
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_tmp1_ = _tmp0_;
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	if (_tmp1_ != 1) {
#line 781 "print-dialog.c"
		GtkSpinner* _tmp2_ = NULL;
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		_tmp2_ = self->priv->spinner;
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
		gtk_widget_destroy ((GtkWidget*) _tmp2_);
#line 787 "print-dialog.c"
	}
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_g_object_unref0 (self->priv->saver);
#line 26 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_g_object_unref0 (self->priv->settings);
#line 29 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_g_object_unref0 (self->priv->n_sudokus_button);
#line 31 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_g_object_unref0 (self->priv->easy_radio_button);
#line 33 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_g_object_unref0 (self->priv->medium_radio_button);
#line 35 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_g_object_unref0 (self->priv->hard_radio_button);
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_g_object_unref0 (self->priv->very_hard_radio_button);
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	_g_object_unref0 (self->priv->spinner);
#line 23 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/print-dialog.vala"
	G_OBJECT_CLASS (print_dialog_parent_class)->finalize (obj);
#line 807 "print-dialog.c"
}


GType print_dialog_get_type (void) {
	static volatile gsize print_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&print_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PrintDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) print_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PrintDialog), 0, (GInstanceInitFunc) print_dialog_instance_init, NULL };
		GType print_dialog_type_id;
		print_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "PrintDialog", &g_define_type_info, 0);
		g_once_init_leave (&print_dialog_type_id__volatile, print_dialog_type_id);
	}
	return print_dialog_type_id__volatile;
}



