/* libsudoku.vapi generated by valac 0.29.2.10-328ea, do not modify. */

[CCode (cheader_filename = "libsudoku.h")]
public enum House {
	ROW,
	COLUMN,
	BLOCK
}
[CCode (cheader_filename = "libsudoku.h")]
public enum DifficultyCategory {
	UNKNOWN,
	EASY,
	MEDIUM,
	HARD,
	VERY_HARD,
	CUSTOM;
	public string to_string ();
	public string to_untranslated_string ();
	public static DifficultyCategory from_string (string input);
}
[CCode (cheader_filename = "libsudoku.h")]
public enum GameMode {
	PLAY,
	CREATE
}
[CCode (cheader_filename = "libsudoku.h")]
public class SudokuBoard : GLib.Object {
	public Gee.Set<Coord?> broken_coords;
	protected int[,] cells;
	public Gee.Map<Coord?,Gee.List<Coord?>> coords_for_block;
	public Gee.List<Gee.List<Coord?>> coords_for_col;
	public Gee.List<Gee.List<Coord?>> coords_for_row;
	public bool[,] is_fixed;
	public SudokuBoard (int block_rows = 3, int block_cols = 3);
	public bool block_contains (Coord block, int val);
	public Gee.HashMap<Coord?,Gee.List<int>> calculate_open_squares ();
	public SudokuBoard clone ();
	public bool col_contains (int col, int val);
	public int count_possibilities (int row, int col);
	public int count_solutions_limited ();
	public void disable_all_earmarks (int row, int column);
	public void disable_earmark (int row, int column, int digit);
	public void enable_earmark (int row, int column, int digit);
	public new int @get (int row, int col);
	public Coord get_block_for (int row, int col);
	public int[,] get_cells ();
	public string get_earmarks_string (int row, int col);
	public Gee.Set<Coord?> get_occurances (Gee.List<Coord?> coords, int val);
	public int[] get_possibilities (int row, int col);
	public bool[] get_possibilities_as_bool_array (int row, int col);
	public void get_string ();
	public void insert (int row, int col, int val, bool is_fixed = false);
	public bool is_earmark_enabled (int row, int column, int digit);
	public bool is_empty ();
	public bool is_finished ();
	public bool is_fully_filled ();
	public bool is_possible (int row, int col, int val);
	public void print (int indent = 0);
	public void remove (int row, int col, bool is_fixed = false);
	public bool row_contains (int row, int val);
	public new void @set (int row, int col, int val);
	public void to_initial_state ();
	public string to_string (bool get_original_state = false);
	public int block_cols { get; private set; }
	public int block_rows { get; private set; }
	public bool broken { get; }
	public int cols { get; private set; }
	public bool complete { get; }
	public DifficultyCategory difficulty_category { get; set; }
	public int filled { get; private set; }
	public int fixed { get; private set; }
	public int max_val { get; }
	public double previous_played_time { get; set; }
	public int rows { get; private set; }
	public int size { get; }
	public signal void completed ();
}
[CCode (cheader_filename = "libsudoku.h")]
public class SudokuGame : GLib.Object {
	public SudokuBoard board;
	public GameMode mode;
	public GLib.Timer timer;
	public SudokuGame (SudokuBoard board);
	public void cell_changed_cb (int row, int col, int old_val, int new_val);
	public double get_total_time_played ();
	public void insert (int row, int col, int val);
	public bool is_empty ();
	public bool is_redostack_null ();
	public bool is_undostack_null ();
	public void redo ();
	public void remove (int row, int col);
	public void reset ();
	public void resume_clock ();
	public void start_clock ();
	public void stop_clock ();
	public void undo ();
	public void update_undo (int row, int col, int old_val, int new_val);
	public bool paused { get; private set; }
	public signal void cell_changed (int row, int col, int old_val, int new_val);
	public signal void paused_changed ();
	public signal void tick ();
}
[CCode (cheader_filename = "libsudoku.h")]
public class SudokuSaver : GLib.Object {
	public SudokuSaver ();
	public void add_game_to_finished (SudokuGame game, bool delete_savegame = false);
	public SudokuGame? get_savedgame ();
	public void save_game (SudokuGame game);
	public static string finishgame_dir { get; private set; }
	public static string savegame_file { get; private set; }
}
[CCode (cheader_filename = "libsudoku.h")]
public class SudokuGenerator : GLib.Object {
	public static async Gee.List<SudokuBoard> generate_boards_async (int nboards, DifficultyCategory category, GLib.Cancellable? cancellable) throws GLib.ThreadError, GLib.IOError;
	public static void print_stats (SudokuBoard board);
	public static string qqwing_version ();
}
[CCode (cheader_filename = "libsudoku.h")]
public struct Coord {
	public int row;
	public int col;
	public Coord (int row, int col);
	public static bool equal (Coord a, Coord b);
	public static int hash (Coord coord);
}
[CCode (cheader_filename = "libsudoku.h")]
public struct Cell {
	public Coord coord;
	public int val;
	public Cell (Coord coord, int val);
	public static bool equal (Cell a, Cell b);
	public static int hash (Cell cell);
}
