/* game-view.c generated by valac 0.29.3.1-0bdcc, the Vala compiler
 * generated from game-view.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This file is part of Iagno.
 *
 * Iagno is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Iagno is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Iagno. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <cairo.h>
#include <gdk/gdk.h>
#include <librsvg/rsvg.h>
#include <gdk-pixbuf/gdk-pixbuf.h>


#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;
typedef struct _GameViewPrivate GameViewPrivate;

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))

#define TYPE_PLAYER (player_get_type ())
typedef struct _Block2Data Block2Data;
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))

struct _GameView {
	GtkDrawingArea parent_instance;
	GameViewPrivate * priv;
};

struct _GameViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _GameViewPrivate {
	GtkDrawingArea* _scoreboard;
	gchar* pieces_file;
	gdouble background_red;
	gdouble background_green;
	gdouble background_blue;
	gint background_radius;
	gdouble mark_red;
	gdouble mark_green;
	gdouble mark_blue;
	gint mark_width;
	gdouble border_red;
	gdouble border_green;
	gdouble border_blue;
	gint border_width;
	gdouble spacing_red;
	gdouble spacing_green;
	gdouble spacing_blue;
	gint spacing_width;
	gdouble highlight_red;
	gdouble highlight_green;
	gdouble highlight_blue;
	gdouble highlight_alpha;
	gchar* _sound_flip;
	gchar* _sound_gameover;
	gint paving_size;
	gint tile_size;
	gint board_size;
	gboolean show_highlight;
	gint highlight_x;
	gint highlight_y;
	gint highlight_state;
	guint render_size;
	cairo_pattern_t* tiles_pattern;
	cairo_pattern_t* scoreboard_tiles_pattern;
	gint* pixmaps;
	gint pixmaps_length1;
	gint pixmaps_length2;
	guint animate_timeout;
	gint current_player_number;
	gboolean flip_final_result_now;
	Game* _game;
	gchar* _theme;
};

typedef enum  {
	PLAYER_NONE,
	PLAYER_DARK,
	PLAYER_LIGHT
} Player;

struct _Block2Data {
	int _ref_count_;
	GameView* self;
	gint x;
	gint y;
};


static gpointer game_view_parent_class = NULL;

GType game_view_get_type (void) G_GNUC_CONST;
GType game_get_type (void) G_GNUC_CONST;
#define GAME_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GAME_VIEW, GameViewPrivate))
enum  {
	GAME_VIEW_DUMMY_PROPERTY,
	GAME_VIEW_SCOREBOARD,
	GAME_VIEW_SOUND_FLIP,
	GAME_VIEW_SOUND_GAMEOVER,
	GAME_VIEW_GAME,
	GAME_VIEW_THEME
};
#define GAME_VIEW_HIGHLIGHT_MAX 5
#define GAME_VIEW_PIXMAP_FLIP_DELAY 20
static void game_view_set_default_theme (GameView* self, GKeyFile** key);
static void game_view_load_theme (GameView* self, GKeyFile* key);
static void game_view_set_sound_flip (GameView* self, const gchar* value);
static void game_view_set_sound_gameover (GameView* self, const gchar* value);
GameView* game_view_new (void);
GameView* game_view_construct (GType object_type);
static void game_view_calculate (GameView* self);
Game* game_view_get_game (GameView* self);
gint game_get_size (Game* self);
static gboolean game_view_real_draw (GtkWidget* base, cairo_t* cr);
static void game_view_load_image (GameView* self, cairo_t* c, gint width, gint height);
static gint game_view_get_board_x (GameView* self);
static gint game_view_get_board_y (GameView* self);
static void game_view_rounded_square (GameView* self, cairo_t* cr, gdouble x, gdouble y, gint size, gdouble width, gdouble radius_percent);
gboolean game_get_is_complete (Game* self);
GType player_get_type (void) G_GNUC_CONST;
static void game_view_square_changed_cb (GameView* self, gint x, gint y, Player replacement);
static void game_view_update_square (GameView* self, gint x, gint y);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static gint game_view_get_pixmap (GameView* self, Player color);
Player game_get_owner (Game* self, gint x, gint y);
gint game_get_n_light_tiles (Game* self);
gint game_get_n_dark_tiles (Game* self);
static void game_view_set_square (GameView* self, gint x, gint y, gint pixmap);
static gboolean ___lambda6_ (Block2Data* _data2_);
static gboolean ____lambda6__gsource_func (gpointer self);
static gboolean game_view_animate_cb (GameView* self);
static gboolean _game_view_animate_cb_gsource_func (gpointer self);
static gboolean game_view_real_button_press_event (GtkWidget* base, GdkEventButton* event);
static gboolean game_view_real_key_press_event (GtkWidget* base, GdkEventKey* event);
static gboolean game_view_draw_scoreboard (GameView* self, cairo_t* cr);
static GtkDrawingArea* game_view_get_scoreboard (GameView* self);
void game_view_update_scoreboard (GameView* self);
Player game_get_current_color (Game* self);
void game_view_set_scoreboard (GameView* self, GtkDrawingArea* value);
static gboolean _game_view_draw_scoreboard_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self);
const gchar* game_view_get_sound_flip (GameView* self);
const gchar* game_view_get_sound_gameover (GameView* self);
void game_view_set_game (GameView* self, Game* value);
static void _game_view_square_changed_cb_game_square_changed (Game* _sender, gint x, gint y, Player new_color, gpointer self);
const gchar* game_view_get_theme (GameView* self);
void game_view_set_theme (GameView* self, const gchar* value);
static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void game_view_finalize (GObject* obj);
static void _vala_game_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_game_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gpointer _g_object_ref0 (gpointer self) {
#line 167 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	return self ? g_object_ref (self) : NULL;
#line 204 "game-view.c"
}


static void game_view_set_default_theme (GameView* self, GKeyFile** key) {
	GtkSettings* defaults = NULL;
	GtkSettings* _tmp0_ = NULL;
	GtkSettings* _tmp1_ = NULL;
	gchar* filename = NULL;
	GtkSettings* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gchar* filepath = NULL;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	GError * _inner_error_ = NULL;
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_if_fail (*key != NULL);
#line 167 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp0_ = gtk_settings_get_default ();
#line 167 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 167 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	defaults = _tmp1_;
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp2_ = defaults;
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_object_get (_tmp2_, "gtk-theme-name", &_tmp3_, NULL);
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp4_ = _tmp3_;
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp5_ = _tmp4_;
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp6_ = g_strcmp0 (_tmp5_, "HighContrast") == 0;
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_g_free0 (_tmp5_);
#line 170 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (_tmp6_) {
#line 246 "game-view.c"
		gchar* _tmp7_ = NULL;
#line 171 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp7_ = g_strdup ("high_contrast.theme");
#line 171 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_g_free0 (filename);
#line 171 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		filename = _tmp7_;
#line 254 "game-view.c"
	} else {
		GtkSettings* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp8_ = defaults;
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_object_get (_tmp8_, "gtk-application-prefer-dark-theme", &_tmp9_, NULL);
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp10_ = _tmp9_;
#line 172 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (_tmp10_ == TRUE) {
#line 267 "game-view.c"
			gchar* _tmp11_ = NULL;
#line 173 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp11_ = g_strdup ("adwaita.theme");
#line 173 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (filename);
#line 173 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			filename = _tmp11_;
#line 275 "game-view.c"
		} else {
			gchar* _tmp12_ = NULL;
#line 175 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp12_ = g_strdup ("classic.theme");
#line 175 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (filename);
#line 175 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			filename = _tmp12_;
#line 284 "game-view.c"
		}
	}
#line 177 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp13_ = filename;
#line 177 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp14_ = g_build_filename (DATA_DIRECTORY, "themes", "key", _tmp13_, NULL);
#line 177 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	filepath = _tmp14_;
#line 293 "game-view.c"
	{
		GKeyFile* _tmp15_ = NULL;
#line 180 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp15_ = *key;
#line 180 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_key_file_load_from_file (_tmp15_, filepath, G_KEY_FILE_NONE, &_inner_error_);
#line 180 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 302 "game-view.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_clear_error (&_inner_error_);
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_inner_error_ = NULL;
#line 182 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_assert_not_reached ();
#line 315 "game-view.c"
	}
	__finally0:
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_g_free0 (filepath);
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_g_free0 (filename);
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_g_object_unref0 (defaults);
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_clear_error (&_inner_error_);
#line 178 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		return;
#line 332 "game-view.c"
	}
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_g_free0 (filepath);
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_g_free0 (filename);
#line 165 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_g_object_unref0 (defaults);
#line 340 "game-view.c"
}


static void game_view_load_theme (GameView* self, GKeyFile* key) {
	GError * _inner_error_ = NULL;
#line 185 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 185 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_if_fail (key != NULL);
#line 350 "game-view.c"
	{
		gchar* svg_path = NULL;
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		GKeyFile* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		gdouble _tmp14_ = 0.0;
		GKeyFile* _tmp15_ = NULL;
		gdouble _tmp16_ = 0.0;
		gdouble _tmp17_ = 0.0;
		GKeyFile* _tmp18_ = NULL;
		gdouble _tmp19_ = 0.0;
		gdouble _tmp20_ = 0.0;
		GKeyFile* _tmp21_ = NULL;
		gdouble _tmp22_ = 0.0;
		gint _tmp23_ = 0;
		GKeyFile* _tmp24_ = NULL;
		gint _tmp25_ = 0;
		gdouble _tmp26_ = 0.0;
		GKeyFile* _tmp27_ = NULL;
		gdouble _tmp28_ = 0.0;
		gdouble _tmp29_ = 0.0;
		GKeyFile* _tmp30_ = NULL;
		gdouble _tmp31_ = 0.0;
		gdouble _tmp32_ = 0.0;
		GKeyFile* _tmp33_ = NULL;
		gdouble _tmp34_ = 0.0;
		gint _tmp35_ = 0;
		GKeyFile* _tmp36_ = NULL;
		gint _tmp37_ = 0;
		gdouble _tmp38_ = 0.0;
		GKeyFile* _tmp39_ = NULL;
		gdouble _tmp40_ = 0.0;
		gdouble _tmp41_ = 0.0;
		GKeyFile* _tmp42_ = NULL;
		gdouble _tmp43_ = 0.0;
		gdouble _tmp44_ = 0.0;
		GKeyFile* _tmp45_ = NULL;
		gdouble _tmp46_ = 0.0;
		gint _tmp47_ = 0;
		GKeyFile* _tmp48_ = NULL;
		gint _tmp49_ = 0;
		gdouble _tmp50_ = 0.0;
		GKeyFile* _tmp51_ = NULL;
		gdouble _tmp52_ = 0.0;
		gdouble _tmp53_ = 0.0;
		GKeyFile* _tmp54_ = NULL;
		gdouble _tmp55_ = 0.0;
		gdouble _tmp56_ = 0.0;
		GKeyFile* _tmp57_ = NULL;
		gdouble _tmp58_ = 0.0;
		gint _tmp59_ = 0;
		GKeyFile* _tmp60_ = NULL;
		gint _tmp61_ = 0;
		gdouble _tmp62_ = 0.0;
		GKeyFile* _tmp63_ = NULL;
		gdouble _tmp64_ = 0.0;
		gdouble _tmp65_ = 0.0;
		GKeyFile* _tmp66_ = NULL;
		gdouble _tmp67_ = 0.0;
		gdouble _tmp68_ = 0.0;
		GKeyFile* _tmp69_ = NULL;
		gdouble _tmp70_ = 0.0;
		gdouble _tmp71_ = 0.0;
		GKeyFile* _tmp72_ = NULL;
		gdouble _tmp73_ = 0.0;
		gchar* _tmp74_ = NULL;
		GKeyFile* _tmp75_ = NULL;
		gchar* _tmp76_ = NULL;
		gchar* _tmp77_ = NULL;
		GKeyFile* _tmp78_ = NULL;
		gchar* _tmp79_ = NULL;
#line 189 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp0_ = g_build_filename (DATA_DIRECTORY, "themes", "svg", NULL);
#line 189 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		svg_path = _tmp0_;
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp2_ = key;
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp3_ = g_key_file_get_string (_tmp2_, "Pieces", "File", &_inner_error_);
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp1_ = _tmp3_;
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 447 "game-view.c"
				goto __catch1_g_key_file_error;
			}
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_clear_error (&_inner_error_);
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			return;
#line 458 "game-view.c"
		}
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp4_ = svg_path;
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp5_ = _tmp1_;
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp1_ = NULL;
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp6_ = g_build_filename (_tmp4_, _tmp5_, NULL);
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_g_free0 (self->priv->pieces_file);
#line 190 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		self->priv->pieces_file = _tmp6_;
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp7_ = self->priv->pieces_file;
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp8_ = g_path_get_dirname (_tmp7_);
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp9_ = _tmp8_;
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp10_ = svg_path;
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp11_ = g_strcmp0 (_tmp9_, _tmp10_) != 0;
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_g_free0 (_tmp9_);
#line 191 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (_tmp11_) {
#line 486 "game-view.c"
			const gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
#line 192 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp12_ = svg_path;
#line 192 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp13_ = g_build_filename (_tmp12_, "black_and_white.svg", NULL);
#line 192 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (self->priv->pieces_file);
#line 192 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			self->priv->pieces_file = _tmp13_;
#line 497 "game-view.c"
		}
#line 194 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp15_ = key;
#line 194 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp16_ = g_key_file_get_double (_tmp15_, "Background", "Red", &_inner_error_);
#line 194 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp14_ = _tmp16_;
#line 194 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 194 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 194 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 194 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 513 "game-view.c"
				goto __catch1_g_key_file_error;
			}
#line 194 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 194 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 194 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 194 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_clear_error (&_inner_error_);
#line 194 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			return;
#line 526 "game-view.c"
		}
#line 194 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		self->priv->background_red = _tmp14_;
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp18_ = key;
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp19_ = g_key_file_get_double (_tmp18_, "Background", "Green", &_inner_error_);
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp17_ = _tmp19_;
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 544 "game-view.c"
				goto __catch1_g_key_file_error;
			}
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_clear_error (&_inner_error_);
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			return;
#line 557 "game-view.c"
		}
#line 195 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		self->priv->background_green = _tmp17_;
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp21_ = key;
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp22_ = g_key_file_get_double (_tmp21_, "Background", "Blue", &_inner_error_);
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp20_ = _tmp22_;
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 575 "game-view.c"
				goto __catch1_g_key_file_error;
			}
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_clear_error (&_inner_error_);
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			return;
#line 588 "game-view.c"
		}
#line 196 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		self->priv->background_blue = _tmp20_;
#line 197 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp24_ = key;
#line 197 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp25_ = g_key_file_get_integer (_tmp24_, "Background", "Radius", &_inner_error_);
#line 197 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp23_ = _tmp25_;
#line 197 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 197 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 197 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 197 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 606 "game-view.c"
				goto __catch1_g_key_file_error;
			}
#line 197 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 197 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 197 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 197 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_clear_error (&_inner_error_);
#line 197 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			return;
#line 619 "game-view.c"
		}
#line 197 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		self->priv->background_radius = _tmp23_;
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp27_ = key;
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp28_ = g_key_file_get_double (_tmp27_, "Mark", "Red", &_inner_error_);
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp26_ = _tmp28_;
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 637 "game-view.c"
				goto __catch1_g_key_file_error;
			}
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_clear_error (&_inner_error_);
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			return;
#line 650 "game-view.c"
		}
#line 199 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		self->priv->mark_red = _tmp26_;
#line 200 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp30_ = key;
#line 200 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp31_ = g_key_file_get_double (_tmp30_, "Mark", "Green", &_inner_error_);
#line 200 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp29_ = _tmp31_;
#line 200 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 200 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 200 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 200 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 668 "game-view.c"
				goto __catch1_g_key_file_error;
			}
#line 200 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 200 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 200 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 200 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_clear_error (&_inner_error_);
#line 200 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			return;
#line 681 "game-view.c"
		}
#line 200 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		self->priv->mark_green = _tmp29_;
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp33_ = key;
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp34_ = g_key_file_get_double (_tmp33_, "Mark", "Blue", &_inner_error_);
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp32_ = _tmp34_;
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 699 "game-view.c"
				goto __catch1_g_key_file_error;
			}
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_clear_error (&_inner_error_);
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			return;
#line 712 "game-view.c"
		}
#line 201 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		self->priv->mark_blue = _tmp32_;
#line 202 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp36_ = key;
#line 202 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp37_ = g_key_file_get_integer (_tmp36_, "Mark", "Width", &_inner_error_);
#line 202 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp35_ = _tmp37_;
#line 202 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 202 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 202 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 202 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 730 "game-view.c"
				goto __catch1_g_key_file_error;
			}
#line 202 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 202 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 202 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 202 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_clear_error (&_inner_error_);
#line 202 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			return;
#line 743 "game-view.c"
		}
#line 202 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		self->priv->mark_width = _tmp35_;
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp39_ = key;
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp40_ = g_key_file_get_double (_tmp39_, "Border", "Red", &_inner_error_);
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp38_ = _tmp40_;
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 761 "game-view.c"
				goto __catch1_g_key_file_error;
			}
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_clear_error (&_inner_error_);
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			return;
#line 774 "game-view.c"
		}
#line 204 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		self->priv->border_red = _tmp38_;
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp42_ = key;
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp43_ = g_key_file_get_double (_tmp42_, "Border", "Green", &_inner_error_);
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp41_ = _tmp43_;
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 792 "game-view.c"
				goto __catch1_g_key_file_error;
			}
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_clear_error (&_inner_error_);
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			return;
#line 805 "game-view.c"
		}
#line 205 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		self->priv->border_green = _tmp41_;
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp45_ = key;
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp46_ = g_key_file_get_double (_tmp45_, "Border", "Blue", &_inner_error_);
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp44_ = _tmp46_;
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 823 "game-view.c"
				goto __catch1_g_key_file_error;
			}
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_clear_error (&_inner_error_);
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			return;
#line 836 "game-view.c"
		}
#line 206 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		self->priv->border_blue = _tmp44_;
#line 207 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp48_ = key;
#line 207 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp49_ = g_key_file_get_integer (_tmp48_, "Border", "Width", &_inner_error_);
#line 207 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp47_ = _tmp49_;
#line 207 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 207 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 207 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 207 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 854 "game-view.c"
				goto __catch1_g_key_file_error;
			}
#line 207 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 207 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 207 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 207 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_clear_error (&_inner_error_);
#line 207 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			return;
#line 867 "game-view.c"
		}
#line 207 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		self->priv->border_width = _tmp47_;
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp51_ = key;
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp52_ = g_key_file_get_double (_tmp51_, "Spacing", "Red", &_inner_error_);
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp50_ = _tmp52_;
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 885 "game-view.c"
				goto __catch1_g_key_file_error;
			}
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_clear_error (&_inner_error_);
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			return;
#line 898 "game-view.c"
		}
#line 209 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		self->priv->spacing_red = _tmp50_;
#line 210 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp54_ = key;
#line 210 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp55_ = g_key_file_get_double (_tmp54_, "Spacing", "Green", &_inner_error_);
#line 210 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp53_ = _tmp55_;
#line 210 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 210 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 210 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 210 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 916 "game-view.c"
				goto __catch1_g_key_file_error;
			}
#line 210 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 210 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 210 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 210 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_clear_error (&_inner_error_);
#line 210 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			return;
#line 929 "game-view.c"
		}
#line 210 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		self->priv->spacing_green = _tmp53_;
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp57_ = key;
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp58_ = g_key_file_get_double (_tmp57_, "Spacing", "Blue", &_inner_error_);
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp56_ = _tmp58_;
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 947 "game-view.c"
				goto __catch1_g_key_file_error;
			}
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_clear_error (&_inner_error_);
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			return;
#line 960 "game-view.c"
		}
#line 211 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		self->priv->spacing_blue = _tmp56_;
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp60_ = key;
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp61_ = g_key_file_get_integer (_tmp60_, "Spacing", "Width", &_inner_error_);
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp59_ = _tmp61_;
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 978 "game-view.c"
				goto __catch1_g_key_file_error;
			}
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_clear_error (&_inner_error_);
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			return;
#line 991 "game-view.c"
		}
#line 212 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		self->priv->spacing_width = _tmp59_;
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp63_ = key;
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp64_ = g_key_file_get_double (_tmp63_, "Highlight", "Red", &_inner_error_);
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp62_ = _tmp64_;
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 1009 "game-view.c"
				goto __catch1_g_key_file_error;
			}
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_clear_error (&_inner_error_);
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			return;
#line 1022 "game-view.c"
		}
#line 214 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		self->priv->highlight_red = _tmp62_;
#line 215 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp66_ = key;
#line 215 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp67_ = g_key_file_get_double (_tmp66_, "Highlight", "Green", &_inner_error_);
#line 215 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp65_ = _tmp67_;
#line 215 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 215 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 215 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 215 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 1040 "game-view.c"
				goto __catch1_g_key_file_error;
			}
#line 215 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 215 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 215 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 215 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_clear_error (&_inner_error_);
#line 215 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			return;
#line 1053 "game-view.c"
		}
#line 215 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		self->priv->highlight_green = _tmp65_;
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp69_ = key;
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp70_ = g_key_file_get_double (_tmp69_, "Highlight", "Blue", &_inner_error_);
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp68_ = _tmp70_;
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 1071 "game-view.c"
				goto __catch1_g_key_file_error;
			}
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_clear_error (&_inner_error_);
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			return;
#line 1084 "game-view.c"
		}
#line 216 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		self->priv->highlight_blue = _tmp68_;
#line 217 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp72_ = key;
#line 217 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp73_ = g_key_file_get_double (_tmp72_, "Highlight", "Alpha", &_inner_error_);
#line 217 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp71_ = _tmp73_;
#line 217 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 217 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 217 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 217 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 1102 "game-view.c"
				goto __catch1_g_key_file_error;
			}
#line 217 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 217 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 217 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 217 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_clear_error (&_inner_error_);
#line 217 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			return;
#line 1115 "game-view.c"
		}
#line 217 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		self->priv->highlight_alpha = _tmp71_;
#line 221 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp75_ = key;
#line 221 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp76_ = g_key_file_get_string (_tmp75_, "Sound", "Flip", &_inner_error_);
#line 221 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp74_ = _tmp76_;
#line 221 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 221 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 221 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 221 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 1133 "game-view.c"
				goto __catch1_g_key_file_error;
			}
#line 221 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 221 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 221 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 221 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_clear_error (&_inner_error_);
#line 221 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			return;
#line 1146 "game-view.c"
		}
#line 221 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		game_view_set_sound_flip (self, _tmp74_);
#line 222 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp78_ = key;
#line 222 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp79_ = g_key_file_get_string (_tmp78_, "Sound", "GameOver", &_inner_error_);
#line 222 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp77_ = _tmp79_;
#line 222 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 222 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp74_);
#line 222 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 222 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 222 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_inner_error_->domain == G_KEY_FILE_ERROR) {
#line 1166 "game-view.c"
				goto __catch1_g_key_file_error;
			}
#line 222 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp74_);
#line 222 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp1_);
#line 222 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (svg_path);
#line 222 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 222 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_clear_error (&_inner_error_);
#line 222 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			return;
#line 1181 "game-view.c"
		}
#line 222 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		game_view_set_sound_gameover (self, _tmp77_);
#line 187 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_g_free0 (_tmp77_);
#line 187 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_g_free0 (_tmp74_);
#line 187 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_g_free0 (_tmp1_);
#line 187 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_g_free0 (svg_path);
#line 1193 "game-view.c"
	}
	goto __finally1;
	__catch1_g_key_file_error:
	{
		GError* e = NULL;
		GError* _tmp80_ = NULL;
		const gchar* _tmp81_ = NULL;
#line 187 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		e = _inner_error_;
#line 187 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_inner_error_ = NULL;
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp80_ = e;
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp81_ = _tmp80_->message;
#line 226 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_warning ("game-view.vala:226: Errors when loading theme: %s", _tmp81_);
#line 187 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_g_error_free0 (e);
#line 1213 "game-view.c"
	}
	__finally1:
#line 187 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 187 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 187 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_clear_error (&_inner_error_);
#line 187 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		return;
#line 1224 "game-view.c"
	}
}


GameView* game_view_construct (GType object_type) {
	GameView * self = NULL;
#line 230 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self = (GameView*) g_object_new (object_type, NULL);
#line 232 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	gtk_widget_set_events ((GtkWidget*) self, (gint) (GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK));
#line 233 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	gtk_widget_set_size_request ((GtkWidget*) self, 350, 350);
#line 230 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	return self;
#line 1239 "game-view.c"
}


GameView* game_view_new (void) {
#line 230 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	return game_view_construct (TYPE_GAME_VIEW);
#line 1246 "game-view.c"
}


static void game_view_calculate (GameView* self) {
	gint size = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	Game* _tmp5_ = NULL;
	Game* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	Game* _tmp12_ = NULL;
	Game* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
#line 236 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp1_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp2_ = MIN (_tmp0_, _tmp1_);
#line 238 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	size = _tmp2_;
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp3_ = self->priv->border_width;
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp4_ = self->priv->spacing_width;
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp5_ = game_view_get_game (self);
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp6_ = _tmp5_;
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp7_ = game_get_size (_tmp6_);
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp8_ = _tmp7_;
#line 239 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->paving_size = ((size - (2 * _tmp3_)) + _tmp4_) / _tmp8_;
#line 240 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp9_ = self->priv->paving_size;
#line 240 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp10_ = self->priv->spacing_width;
#line 240 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->tile_size = _tmp9_ - _tmp10_;
#line 242 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp11_ = self->priv->paving_size;
#line 242 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp12_ = game_view_get_game (self);
#line 242 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp13_ = _tmp12_;
#line 242 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp14_ = game_get_size (_tmp13_);
#line 242 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp15_ = _tmp14_;
#line 242 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp16_ = self->priv->spacing_width;
#line 242 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->board_size = (_tmp11_ * _tmp15_) - _tmp16_;
#line 1313 "game-view.c"
}


static gboolean game_view_real_draw (GtkWidget* base, cairo_t* cr) {
	GameView * self;
	gboolean result = FALSE;
	Game* _tmp0_ = NULL;
	Game* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	cairo_pattern_t* _tmp3_ = NULL;
	cairo_t* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	cairo_t* _tmp24_ = NULL;
	gdouble _tmp25_ = 0.0;
	gdouble _tmp26_ = 0.0;
	gdouble _tmp27_ = 0.0;
	cairo_t* _tmp28_ = NULL;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	gint _tmp33_ = 0;
	gint _tmp34_ = 0;
	cairo_t* _tmp35_ = NULL;
	cairo_t* _tmp36_ = NULL;
	gdouble _tmp37_ = 0.0;
	gdouble _tmp38_ = 0.0;
	gdouble _tmp39_ = 0.0;
	cairo_t* _tmp40_ = NULL;
	gint _tmp41_ = 0;
	cairo_t* _tmp42_ = NULL;
#line 245 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self = (GameView*) base;
#line 245 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_val_if_fail (cr != NULL, FALSE);
#line 247 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp0_ = game_view_get_game (self);
#line 247 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp1_ = _tmp0_;
#line 247 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (_tmp1_ == NULL) {
#line 248 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		result = FALSE;
#line 248 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		return result;
#line 1362 "game-view.c"
	}
#line 250 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	game_view_calculate (self);
#line 252 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp3_ = self->priv->tiles_pattern;
#line 252 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (_tmp3_ == NULL) {
#line 252 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp2_ = TRUE;
#line 1372 "game-view.c"
	} else {
		guint _tmp4_ = 0U;
		gint _tmp5_ = 0;
#line 252 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp4_ = self->priv->render_size;
#line 252 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp5_ = self->priv->tile_size;
#line 252 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp2_ = _tmp4_ != ((guint) _tmp5_);
#line 1382 "game-view.c"
	}
#line 252 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (_tmp2_) {
#line 1386 "game-view.c"
		gint _tmp6_ = 0;
		cairo_surface_t* surface = NULL;
		cairo_t* _tmp7_ = NULL;
		cairo_surface_t* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		cairo_surface_t* _tmp11_ = NULL;
		cairo_t* c = NULL;
		cairo_surface_t* _tmp12_ = NULL;
		cairo_t* _tmp13_ = NULL;
		cairo_t* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		cairo_surface_t* _tmp17_ = NULL;
		cairo_pattern_t* _tmp18_ = NULL;
#line 254 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp6_ = self->priv->tile_size;
#line 254 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		self->priv->render_size = (guint) _tmp6_;
#line 255 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp7_ = cr;
#line 255 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp8_ = cairo_get_target (_tmp7_);
#line 255 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp9_ = self->priv->tile_size;
#line 255 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp10_ = self->priv->tile_size;
#line 255 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp11_ = cairo_surface_create_similar (_tmp8_, CAIRO_CONTENT_COLOR_ALPHA, _tmp9_ * 8, _tmp10_ * 4);
#line 255 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		surface = _tmp11_;
#line 256 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp12_ = surface;
#line 256 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp13_ = cairo_create (_tmp12_);
#line 256 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		c = _tmp13_;
#line 257 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp14_ = c;
#line 257 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp15_ = self->priv->tile_size;
#line 257 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp16_ = self->priv->tile_size;
#line 257 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		game_view_load_image (self, _tmp14_, _tmp15_ * 8, _tmp16_ * 4);
#line 258 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp17_ = surface;
#line 258 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp18_ = cairo_pattern_create_for_surface (_tmp17_);
#line 258 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_cairo_pattern_destroy0 (self->priv->tiles_pattern);
#line 258 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		self->priv->tiles_pattern = _tmp18_;
#line 252 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_cairo_destroy0 (c);
#line 252 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_cairo_surface_destroy0 (surface);
#line 1444 "game-view.c"
	}
#line 261 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp19_ = cr;
#line 261 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp20_ = game_view_get_board_x (self);
#line 261 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp21_ = _tmp20_;
#line 261 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp22_ = game_view_get_board_y (self);
#line 261 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp23_ = _tmp22_;
#line 261 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_translate (_tmp19_, (gdouble) _tmp21_, (gdouble) _tmp23_);
#line 264 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp24_ = cr;
#line 264 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp25_ = self->priv->spacing_red;
#line 264 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp26_ = self->priv->spacing_green;
#line 264 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp27_ = self->priv->spacing_blue;
#line 264 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_set_source_rgba (_tmp24_, _tmp25_, _tmp26_, _tmp27_, 1.0);
#line 265 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp28_ = cr;
#line 265 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp29_ = self->priv->border_width;
#line 265 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp30_ = self->priv->border_width;
#line 265 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp31_ = self->priv->board_size;
#line 265 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp32_ = self->priv->border_width;
#line 265 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp33_ = self->priv->board_size;
#line 265 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp34_ = self->priv->border_width;
#line 265 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_rectangle (_tmp28_, (-_tmp29_) / 2.0, (-_tmp30_) / 2.0, (gdouble) (_tmp31_ + _tmp32_), (gdouble) (_tmp33_ + _tmp34_));
#line 266 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp35_ = cr;
#line 266 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_fill_preserve (_tmp35_);
#line 267 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp36_ = cr;
#line 267 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp37_ = self->priv->border_red;
#line 267 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp38_ = self->priv->border_green;
#line 267 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp39_ = self->priv->border_blue;
#line 267 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_set_source_rgba (_tmp36_, _tmp37_, _tmp38_, _tmp39_, 1.0);
#line 268 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp40_ = cr;
#line 268 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp41_ = self->priv->border_width;
#line 268 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_set_line_width (_tmp40_, (gdouble) _tmp41_);
#line 269 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp42_ = cr;
#line 269 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_stroke (_tmp42_);
#line 1508 "game-view.c"
	{
		gint x = 0;
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		x = 0;
#line 1513 "game-view.c"
		{
			gboolean _tmp43_ = FALSE;
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp43_ = TRUE;
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			while (TRUE) {
#line 1520 "game-view.c"
				gint _tmp45_ = 0;
				Game* _tmp46_ = NULL;
				Game* _tmp47_ = NULL;
				gint _tmp48_ = 0;
				gint _tmp49_ = 0;
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				if (!_tmp43_) {
#line 1528 "game-view.c"
					gint _tmp44_ = 0;
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
					_tmp44_ = x;
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
					x = _tmp44_ + 1;
#line 1534 "game-view.c"
				}
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp43_ = FALSE;
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp45_ = x;
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp46_ = game_view_get_game (self);
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp47_ = _tmp46_;
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp48_ = game_get_size (_tmp47_);
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp49_ = _tmp48_;
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				if (!(_tmp45_ < _tmp49_)) {
#line 272 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
					break;
#line 1552 "game-view.c"
				}
				{
					gint y = 0;
#line 274 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
					y = 0;
#line 1558 "game-view.c"
					{
						gboolean _tmp50_ = FALSE;
#line 274 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
						_tmp50_ = TRUE;
#line 274 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
						while (TRUE) {
#line 1565 "game-view.c"
							gint _tmp52_ = 0;
							Game* _tmp53_ = NULL;
							Game* _tmp54_ = NULL;
							gint _tmp55_ = 0;
							gint _tmp56_ = 0;
							gint tile_x = 0;
							gint _tmp57_ = 0;
							gint _tmp58_ = 0;
							gint tile_y = 0;
							gint _tmp59_ = 0;
							gint _tmp60_ = 0;
							cairo_t* _tmp61_ = NULL;
							gdouble _tmp62_ = 0.0;
							gdouble _tmp63_ = 0.0;
							gdouble _tmp64_ = 0.0;
							cairo_t* _tmp65_ = NULL;
							gint _tmp66_ = 0;
							gint _tmp67_ = 0;
							gint _tmp68_ = 0;
							gint _tmp69_ = 0;
							cairo_t* _tmp70_ = NULL;
							gboolean _tmp71_ = FALSE;
							gboolean _tmp72_ = FALSE;
							gboolean _tmp73_ = FALSE;
							gint _tmp74_ = 0;
							gint _tmp75_ = 0;
							gint* _tmp116_ = NULL;
							gint _tmp116__length1 = 0;
							gint _tmp116__length2 = 0;
							gint _tmp117_ = 0;
							gint _tmp118_ = 0;
							gint _tmp119_ = 0;
							gint texture_x = 0;
							gint* _tmp120_ = NULL;
							gint _tmp120__length1 = 0;
							gint _tmp120__length2 = 0;
							gint _tmp121_ = 0;
							gint _tmp122_ = 0;
							gint _tmp123_ = 0;
							gint _tmp124_ = 0;
							gint texture_y = 0;
							gint* _tmp125_ = NULL;
							gint _tmp125__length1 = 0;
							gint _tmp125__length2 = 0;
							gint _tmp126_ = 0;
							gint _tmp127_ = 0;
							gint _tmp128_ = 0;
							gint _tmp129_ = 0;
							cairo_matrix_t matrix = {0};
							gint _tmp130_ = 0;
							gint _tmp131_ = 0;
							gint _tmp132_ = 0;
							gint _tmp133_ = 0;
							cairo_pattern_t* _tmp134_ = NULL;
							cairo_matrix_t _tmp135_ = {0};
							cairo_t* _tmp136_ = NULL;
							cairo_pattern_t* _tmp137_ = NULL;
							cairo_t* _tmp138_ = NULL;
							gint _tmp139_ = 0;
							gint _tmp140_ = 0;
							gint _tmp141_ = 0;
							gint _tmp142_ = 0;
							cairo_t* _tmp143_ = NULL;
#line 274 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							if (!_tmp50_) {
#line 1631 "game-view.c"
								gint _tmp51_ = 0;
#line 274 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp51_ = y;
#line 274 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								y = _tmp51_ + 1;
#line 1637 "game-view.c"
							}
#line 274 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp50_ = FALSE;
#line 274 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp52_ = y;
#line 274 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp53_ = game_view_get_game (self);
#line 274 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp54_ = _tmp53_;
#line 274 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp55_ = game_get_size (_tmp54_);
#line 274 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp56_ = _tmp55_;
#line 274 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							if (!(_tmp52_ < _tmp56_)) {
#line 274 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								break;
#line 1655 "game-view.c"
							}
#line 276 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp57_ = x;
#line 276 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp58_ = self->priv->paving_size;
#line 276 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							tile_x = _tmp57_ * _tmp58_;
#line 277 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp59_ = y;
#line 277 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp60_ = self->priv->paving_size;
#line 277 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							tile_y = _tmp59_ * _tmp60_;
#line 280 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp61_ = cr;
#line 280 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp62_ = self->priv->background_red;
#line 280 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp63_ = self->priv->background_green;
#line 280 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp64_ = self->priv->background_blue;
#line 280 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							cairo_set_source_rgba (_tmp61_, _tmp62_, _tmp63_, _tmp64_, 1.0);
#line 281 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp65_ = cr;
#line 281 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp66_ = tile_x;
#line 281 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp67_ = tile_y;
#line 281 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp68_ = self->priv->tile_size;
#line 281 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp69_ = self->priv->background_radius;
#line 281 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							game_view_rounded_square (self, _tmp65_, (gdouble) _tmp66_, (gdouble) _tmp67_, _tmp68_, (gdouble) 0, (gdouble) _tmp69_);
#line 282 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp70_ = cr;
#line 282 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							cairo_fill (_tmp70_);
#line 284 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp74_ = self->priv->highlight_x;
#line 284 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp75_ = x;
#line 284 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							if (_tmp74_ == _tmp75_) {
#line 1701 "game-view.c"
								gint _tmp76_ = 0;
								gint _tmp77_ = 0;
#line 284 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp76_ = self->priv->highlight_y;
#line 284 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp77_ = y;
#line 284 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp73_ = _tmp76_ == _tmp77_;
#line 1710 "game-view.c"
							} else {
#line 284 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp73_ = FALSE;
#line 1714 "game-view.c"
							}
#line 284 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							if (_tmp73_) {
#line 1718 "game-view.c"
								gboolean _tmp78_ = FALSE;
								gboolean _tmp79_ = FALSE;
#line 284 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp79_ = self->priv->show_highlight;
#line 284 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								if (_tmp79_) {
#line 284 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
									_tmp78_ = TRUE;
#line 1727 "game-view.c"
								} else {
									gint _tmp80_ = 0;
#line 284 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
									_tmp80_ = self->priv->highlight_state;
#line 284 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
									_tmp78_ = _tmp80_ != 0;
#line 1734 "game-view.c"
								}
#line 284 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp72_ = _tmp78_;
#line 1738 "game-view.c"
							} else {
#line 284 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp72_ = FALSE;
#line 1742 "game-view.c"
							}
#line 284 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							if (_tmp72_) {
#line 1746 "game-view.c"
								Game* _tmp81_ = NULL;
								Game* _tmp82_ = NULL;
								gboolean _tmp83_ = FALSE;
								gboolean _tmp84_ = FALSE;
#line 284 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp81_ = game_view_get_game (self);
#line 284 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp82_ = _tmp81_;
#line 284 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp83_ = game_get_is_complete (_tmp82_);
#line 284 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp84_ = _tmp83_;
#line 284 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp71_ = !_tmp84_;
#line 1761 "game-view.c"
							} else {
#line 284 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp71_ = FALSE;
#line 1765 "game-view.c"
							}
#line 284 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							if (_tmp71_) {
#line 1769 "game-view.c"
								gboolean _tmp85_ = FALSE;
								gboolean _tmp86_ = FALSE;
								cairo_t* _tmp100_ = NULL;
								gdouble _tmp101_ = 0.0;
								gdouble _tmp102_ = 0.0;
								gdouble _tmp103_ = 0.0;
								gdouble _tmp104_ = 0.0;
								cairo_t* _tmp105_ = NULL;
								gint _tmp106_ = 0;
								gint _tmp107_ = 0;
								gint _tmp108_ = 0;
								gint _tmp109_ = 0;
								gint _tmp110_ = 0;
								gint _tmp111_ = 0;
								gint _tmp112_ = 0;
								gint _tmp113_ = 0;
								gint _tmp114_ = 0;
								cairo_t* _tmp115_ = NULL;
#line 287 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp86_ = self->priv->show_highlight;
#line 287 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								if (_tmp86_) {
#line 1792 "game-view.c"
									gint _tmp87_ = 0;
#line 287 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
									_tmp87_ = self->priv->highlight_state;
#line 287 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
									_tmp85_ = _tmp87_ != GAME_VIEW_HIGHLIGHT_MAX;
#line 1798 "game-view.c"
								} else {
#line 287 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
									_tmp85_ = FALSE;
#line 1802 "game-view.c"
								}
#line 287 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								if (_tmp85_) {
#line 1806 "game-view.c"
									gint _tmp88_ = 0;
									gint _tmp89_ = 0;
									gint _tmp90_ = 0;
									gint _tmp91_ = 0;
									gint _tmp92_ = 0;
									gint _tmp93_ = 0;
									gint _tmp94_ = 0;
									gint _tmp95_ = 0;
									gint _tmp96_ = 0;
#line 289 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
									_tmp88_ = self->priv->highlight_state;
#line 289 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
									self->priv->highlight_state = _tmp88_ + 1;
#line 290 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
									_tmp89_ = game_view_get_board_x (self);
#line 290 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
									_tmp90_ = _tmp89_;
#line 290 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
									_tmp91_ = tile_x;
#line 290 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
									_tmp92_ = game_view_get_board_y (self);
#line 290 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
									_tmp93_ = _tmp92_;
#line 290 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
									_tmp94_ = tile_y;
#line 290 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
									_tmp95_ = self->priv->tile_size;
#line 290 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
									_tmp96_ = self->priv->tile_size;
#line 290 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
									gtk_widget_queue_draw_area ((GtkWidget*) self, _tmp90_ + _tmp91_, _tmp93_ + _tmp94_, _tmp95_, _tmp96_);
#line 1838 "game-view.c"
								} else {
									gboolean _tmp97_ = FALSE;
									gboolean _tmp98_ = FALSE;
#line 292 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
									_tmp98_ = self->priv->show_highlight;
#line 292 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
									if (!_tmp98_) {
#line 1846 "game-view.c"
										gint _tmp99_ = 0;
#line 292 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
										_tmp99_ = self->priv->highlight_state;
#line 292 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
										_tmp97_ = _tmp99_ != 0;
#line 1852 "game-view.c"
									} else {
#line 292 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
										_tmp97_ = FALSE;
#line 1856 "game-view.c"
									}
#line 292 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
									if (_tmp97_) {
#line 293 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
										self->priv->highlight_state = 0;
#line 1862 "game-view.c"
									}
								}
#line 296 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp100_ = cr;
#line 296 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp101_ = self->priv->highlight_red;
#line 296 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp102_ = self->priv->highlight_green;
#line 296 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp103_ = self->priv->highlight_blue;
#line 296 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp104_ = self->priv->highlight_alpha;
#line 296 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								cairo_set_source_rgba (_tmp100_, _tmp101_, _tmp102_, _tmp103_, _tmp104_);
#line 297 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp105_ = cr;
#line 297 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp106_ = tile_x;
#line 297 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp107_ = self->priv->tile_size;
#line 297 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp108_ = self->priv->highlight_state;
#line 297 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp109_ = tile_y;
#line 297 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp110_ = self->priv->tile_size;
#line 297 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp111_ = self->priv->highlight_state;
#line 297 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp112_ = self->priv->tile_size;
#line 297 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp113_ = self->priv->highlight_state;
#line 297 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp114_ = self->priv->background_radius;
#line 297 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								game_view_rounded_square (self, _tmp105_, (gdouble) (_tmp106_ + ((_tmp107_ * (GAME_VIEW_HIGHLIGHT_MAX - _tmp108_)) / (2 * GAME_VIEW_HIGHLIGHT_MAX))), (gdouble) (_tmp109_ + ((_tmp110_ * (GAME_VIEW_HIGHLIGHT_MAX - _tmp111_)) / (2 * GAME_VIEW_HIGHLIGHT_MAX))), (_tmp112_ * _tmp113_) / GAME_VIEW_HIGHLIGHT_MAX, (gdouble) 0, (gdouble) _tmp114_);
#line 303 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp115_ = cr;
#line 303 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								cairo_fill (_tmp115_);
#line 1903 "game-view.c"
							}
#line 307 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp116_ = self->priv->pixmaps;
#line 307 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp116__length1 = self->priv->pixmaps_length1;
#line 307 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp116__length2 = self->priv->pixmaps_length2;
#line 307 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp117_ = x;
#line 307 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp118_ = y;
#line 307 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp119_ = _tmp116_[(_tmp117_ * _tmp116__length2) + _tmp118_];
#line 307 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							if (_tmp119_ == 0) {
#line 308 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								continue;
#line 1921 "game-view.c"
							}
#line 310 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp120_ = self->priv->pixmaps;
#line 310 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp120__length1 = self->priv->pixmaps_length1;
#line 310 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp120__length2 = self->priv->pixmaps_length2;
#line 310 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp121_ = x;
#line 310 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp122_ = y;
#line 310 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp123_ = _tmp120_[(_tmp121_ * _tmp120__length2) + _tmp122_];
#line 310 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp124_ = self->priv->tile_size;
#line 310 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							texture_x = (_tmp123_ % 8) * _tmp124_;
#line 311 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp125_ = self->priv->pixmaps;
#line 311 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp125__length1 = self->priv->pixmaps_length1;
#line 311 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp125__length2 = self->priv->pixmaps_length2;
#line 311 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp126_ = x;
#line 311 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp127_ = y;
#line 311 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp128_ = _tmp125_[(_tmp126_ * _tmp125__length2) + _tmp127_];
#line 311 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp129_ = self->priv->tile_size;
#line 311 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							texture_y = (_tmp128_ / 8) * _tmp129_;
#line 313 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							cairo_matrix_init_identity (&matrix);
#line 314 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp130_ = texture_x;
#line 314 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp131_ = tile_x;
#line 314 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp132_ = texture_y;
#line 314 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp133_ = tile_y;
#line 314 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							cairo_matrix_translate (&matrix, (gdouble) (_tmp130_ - _tmp131_), (gdouble) (_tmp132_ - _tmp133_));
#line 315 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp134_ = self->priv->tiles_pattern;
#line 315 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp135_ = matrix;
#line 315 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							cairo_pattern_set_matrix (_tmp134_, &_tmp135_);
#line 316 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp136_ = cr;
#line 316 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp137_ = self->priv->tiles_pattern;
#line 316 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							cairo_set_source (_tmp136_, _tmp137_);
#line 317 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp138_ = cr;
#line 317 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp139_ = tile_x;
#line 317 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp140_ = tile_y;
#line 317 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp141_ = self->priv->tile_size;
#line 317 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp142_ = self->priv->tile_size;
#line 317 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							cairo_rectangle (_tmp138_, (gdouble) _tmp139_, (gdouble) _tmp140_, (gdouble) _tmp141_, (gdouble) _tmp142_);
#line 318 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp143_ = cr;
#line 318 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							cairo_fill (_tmp143_);
#line 1995 "game-view.c"
						}
					}
				}
			}
		}
	}
#line 321 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	result = FALSE;
#line 321 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	return result;
#line 2006 "game-view.c"
}


static void game_view_rounded_square (GameView* self, cairo_t* cr, gdouble x, gdouble y, gint size, gdouble width, gdouble radius_percent) {
	gdouble _tmp0_ = 0.0;
	gdouble _tmp10_ = 0.0;
	gdouble radius_border = 0.0;
	gdouble _tmp11_ = 0.0;
	gint _tmp12_ = 0;
	gdouble radius_arc = 0.0;
	gdouble _tmp13_ = 0.0;
	gdouble _tmp14_ = 0.0;
	gdouble x1 = 0.0;
	gdouble _tmp15_ = 0.0;
	gdouble _tmp16_ = 0.0;
	gdouble y1 = 0.0;
	gdouble _tmp17_ = 0.0;
	gdouble _tmp18_ = 0.0;
	gdouble x2 = 0.0;
	gdouble _tmp19_ = 0.0;
	gint _tmp20_ = 0;
	gdouble _tmp21_ = 0.0;
	gdouble y2 = 0.0;
	gdouble _tmp22_ = 0.0;
	gint _tmp23_ = 0;
	gdouble _tmp24_ = 0.0;
	cairo_t* _tmp25_ = NULL;
	gdouble _tmp26_ = 0.0;
	gdouble _tmp27_ = 0.0;
	gdouble _tmp28_ = 0.0;
	cairo_t* _tmp29_ = NULL;
	gdouble _tmp30_ = 0.0;
	gdouble _tmp31_ = 0.0;
	gdouble _tmp32_ = 0.0;
	cairo_t* _tmp33_ = NULL;
	gdouble _tmp34_ = 0.0;
	gdouble _tmp35_ = 0.0;
	gdouble _tmp36_ = 0.0;
	cairo_t* _tmp37_ = NULL;
	gdouble _tmp38_ = 0.0;
	gdouble _tmp39_ = 0.0;
	gdouble _tmp40_ = 0.0;
	cairo_t* _tmp41_ = NULL;
	gdouble _tmp42_ = 0.0;
	gdouble _tmp43_ = 0.0;
	gdouble _tmp44_ = 0.0;
#line 324 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 324 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_if_fail (cr != NULL);
#line 326 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp0_ = radius_percent;
#line 326 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (_tmp0_ <= ((gdouble) 0)) {
#line 2061 "game-view.c"
		cairo_t* _tmp1_ = NULL;
		gdouble _tmp2_ = 0.0;
		gdouble _tmp3_ = 0.0;
		gdouble _tmp4_ = 0.0;
		gdouble _tmp5_ = 0.0;
		gint _tmp6_ = 0;
		gdouble _tmp7_ = 0.0;
		gint _tmp8_ = 0;
		gdouble _tmp9_ = 0.0;
#line 328 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp1_ = cr;
#line 328 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp2_ = x;
#line 328 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp3_ = width;
#line 328 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp4_ = y;
#line 328 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp5_ = width;
#line 328 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp6_ = size;
#line 328 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp7_ = width;
#line 328 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp8_ = size;
#line 328 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp9_ = width;
#line 328 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		cairo_rectangle (_tmp1_, _tmp2_ + (_tmp3_ / 2.0), _tmp4_ + (_tmp5_ / 2.0), _tmp6_ + _tmp7_, _tmp8_ + _tmp9_);
#line 329 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		return;
#line 2093 "game-view.c"
	}
#line 332 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp10_ = radius_percent;
#line 332 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (_tmp10_ > ((gdouble) 50)) {
#line 333 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		radius_percent = (gdouble) 50;
#line 2101 "game-view.c"
	}
#line 334 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp11_ = radius_percent;
#line 334 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp12_ = size;
#line 334 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	radius_border = (_tmp11_ * _tmp12_) / 100.0;
#line 335 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp13_ = radius_border;
#line 335 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp14_ = width;
#line 335 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	radius_arc = _tmp13_ - (_tmp14_ / 2.0);
#line 336 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp15_ = x;
#line 336 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp16_ = radius_border;
#line 336 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	x1 = _tmp15_ + _tmp16_;
#line 337 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp17_ = y;
#line 337 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp18_ = radius_border;
#line 337 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	y1 = _tmp17_ + _tmp18_;
#line 338 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp19_ = x;
#line 338 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp20_ = size;
#line 338 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp21_ = radius_border;
#line 338 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	x2 = (_tmp19_ + _tmp20_) - _tmp21_;
#line 339 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp22_ = y;
#line 339 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp23_ = size;
#line 339 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp24_ = radius_border;
#line 339 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	y2 = (_tmp22_ + _tmp23_) - _tmp24_;
#line 341 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp25_ = cr;
#line 341 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp26_ = x1;
#line 341 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp27_ = y1;
#line 341 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp28_ = radius_arc;
#line 341 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_arc (_tmp25_, _tmp26_, _tmp27_, _tmp28_, G_PI, (G_PI * 3) / 2.0);
#line 342 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp29_ = cr;
#line 342 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp30_ = x2;
#line 342 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp31_ = y1;
#line 342 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp32_ = radius_arc;
#line 342 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_arc (_tmp29_, _tmp30_, _tmp31_, _tmp32_, (G_PI * 3) / 2.0, (gdouble) 0);
#line 343 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp33_ = cr;
#line 343 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp34_ = x2;
#line 343 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp35_ = y2;
#line 343 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp36_ = radius_arc;
#line 343 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_arc (_tmp33_, _tmp34_, _tmp35_, _tmp36_, (gdouble) 0, G_PI / 2.0);
#line 344 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp37_ = cr;
#line 344 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp38_ = x1;
#line 344 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp39_ = y2;
#line 344 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp40_ = radius_arc;
#line 344 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_arc (_tmp37_, _tmp38_, _tmp39_, _tmp40_, G_PI / 2.0, G_PI);
#line 345 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp41_ = cr;
#line 345 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp42_ = x1;
#line 345 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp43_ = y1;
#line 345 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp44_ = radius_arc;
#line 345 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_arc (_tmp41_, _tmp42_, _tmp43_, _tmp44_, G_PI, (G_PI * 3) / 2.0);
#line 2193 "game-view.c"
}


static void game_view_load_image (GameView* self, cairo_t* c, gint width, gint height) {
	GError * _inner_error_ = NULL;
#line 348 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 348 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_if_fail (c != NULL);
#line 2203 "game-view.c"
	{
		RsvgHandle* h = NULL;
		const gchar* _tmp0_ = NULL;
		RsvgHandle* _tmp1_ = NULL;
		cairo_matrix_t m = {0};
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		cairo_t* _tmp8_ = NULL;
		cairo_matrix_t _tmp9_ = {0};
		cairo_t* _tmp10_ = NULL;
#line 352 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp0_ = self->priv->pieces_file;
#line 352 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp1_ = rsvg_handle_new_from_file (_tmp0_, &_inner_error_);
#line 352 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		h = _tmp1_;
#line 352 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2226 "game-view.c"
			goto __catch2_g_error;
		}
#line 354 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		cairo_matrix_init_identity (&m);
#line 355 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp2_ = width;
#line 355 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_object_get (h, "width", &_tmp3_, NULL);
#line 355 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp4_ = _tmp3_;
#line 355 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp5_ = height;
#line 355 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_object_get (h, "height", &_tmp6_, NULL);
#line 355 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp7_ = _tmp6_;
#line 355 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		cairo_matrix_scale (&m, ((gdouble) _tmp2_) / _tmp4_, ((gdouble) _tmp5_) / _tmp7_);
#line 356 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp8_ = c;
#line 356 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp9_ = m;
#line 356 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		cairo_set_matrix (_tmp8_, &_tmp9_);
#line 357 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp10_ = c;
#line 357 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		rsvg_handle_render_cairo (h, _tmp10_);
#line 359 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_g_object_unref0 (h);
#line 359 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		return;
#line 2259 "game-view.c"
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
#line 350 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		e = _inner_error_;
#line 350 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_inner_error_ = NULL;
#line 350 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_g_error_free0 (e);
#line 2271 "game-view.c"
	}
	__finally2:
#line 350 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 350 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 350 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_clear_error (&_inner_error_);
#line 350 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		return;
#line 2282 "game-view.c"
	}
	{
		GdkPixbuf* p = NULL;
		const gchar* _tmp11_ = NULL;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		GdkPixbuf* _tmp14_ = NULL;
		cairo_t* _tmp15_ = NULL;
		GdkPixbuf* _tmp16_ = NULL;
		cairo_t* _tmp17_ = NULL;
#line 368 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp11_ = self->priv->pieces_file;
#line 368 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp12_ = width;
#line 368 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp13_ = height;
#line 368 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp14_ = gdk_pixbuf_new_from_file_at_scale (_tmp11_, _tmp12_, _tmp13_, FALSE, &_inner_error_);
#line 368 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		p = _tmp14_;
#line 368 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2305 "game-view.c"
			goto __catch3_g_error;
		}
#line 369 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp15_ = c;
#line 369 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp16_ = p;
#line 369 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		gdk_cairo_set_source_pixbuf (_tmp15_, _tmp16_, (gdouble) 0, (gdouble) 0);
#line 370 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp17_ = c;
#line 370 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		cairo_paint (_tmp17_);
#line 366 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_g_object_unref0 (p);
#line 2320 "game-view.c"
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp18_ = NULL;
		GError* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
#line 366 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		e = _inner_error_;
#line 366 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_inner_error_ = NULL;
#line 374 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp18_ = self->priv->pieces_file;
#line 374 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp19_ = e;
#line 374 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp20_ = _tmp19_->message;
#line 374 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_warning ("game-view.vala:374: Failed to load theme image %s: %s", _tmp18_, _tmp20_);
#line 366 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_g_error_free0 (e);
#line 2343 "game-view.c"
	}
	__finally3:
#line 366 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 366 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 366 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_clear_error (&_inner_error_);
#line 366 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		return;
#line 2354 "game-view.c"
	}
}


static void game_view_square_changed_cb (GameView* self, gint x, gint y, Player replacement) {
	Player _tmp0_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
#line 378 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 380 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp0_ = replacement;
#line 380 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (_tmp0_ == PLAYER_NONE) {
#line 2369 "game-view.c"
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
#line 382 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp1_ = x;
#line 382 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		self->priv->highlight_x = _tmp1_;
#line 383 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp2_ = y;
#line 383 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		self->priv->highlight_y = _tmp2_;
#line 2380 "game-view.c"
	}
#line 385 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp3_ = x;
#line 385 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp4_ = y;
#line 385 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	game_view_update_square (self, _tmp3_, _tmp4_);
#line 2388 "game-view.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	return _data2_;
#line 2397 "game-view.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 2406 "game-view.c"
		GameView* self;
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		self = _data2_->self;
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_g_object_unref0 (self);
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_slice_free (Block2Data, _data2_);
#line 2414 "game-view.c"
	}
}


static gboolean ___lambda6_ (Block2Data* _data2_) {
	GameView* self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 429 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self = _data2_->self;
#line 430 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->flip_final_result_now = TRUE;
#line 431 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp0_ = _data2_->x;
#line 431 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp1_ = _data2_->y;
#line 431 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	game_view_update_square (self, _tmp0_, _tmp1_);
#line 432 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	result = G_SOURCE_REMOVE;
#line 432 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	return result;
#line 2438 "game-view.c"
}


static gboolean ____lambda6__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda6_ (self);
#line 429 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	return result;
#line 2447 "game-view.c"
}


static void game_view_update_square (GameView* self, gint x, gint y) {
	Block2Data* _data2_;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint pixmap = 0;
	Game* _tmp2_ = NULL;
	Game* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	Player _tmp6_ = 0;
	gint _tmp7_ = 0;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gint _tmp44_ = 0;
	gint _tmp45_ = 0;
	gint _tmp46_ = 0;
	gboolean _tmp47_ = FALSE;
	gboolean _tmp48_ = FALSE;
	Game* _tmp49_ = NULL;
	Game* _tmp50_ = NULL;
	gboolean _tmp51_ = FALSE;
	gboolean _tmp52_ = FALSE;
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_data2_ = g_slice_new0 (Block2Data);
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_data2_->_ref_count_ = 1;
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_data2_->self = g_object_ref (self);
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp0_ = x;
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_data2_->x = _tmp0_;
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp1_ = y;
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_data2_->y = _tmp1_;
#line 390 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp2_ = game_view_get_game (self);
#line 390 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp3_ = _tmp2_;
#line 390 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp4_ = _data2_->x;
#line 390 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp5_ = _data2_->y;
#line 390 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp6_ = game_get_owner (_tmp3_, _tmp4_, _tmp5_);
#line 390 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp7_ = game_view_get_pixmap (self, _tmp6_);
#line 390 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	pixmap = _tmp7_;
#line 393 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp9_ = self->priv->flip_final_result_now;
#line 393 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (_tmp9_) {
#line 2507 "game-view.c"
		Game* _tmp10_ = NULL;
		Game* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
#line 393 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp10_ = game_view_get_game (self);
#line 393 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp11_ = _tmp10_;
#line 393 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp12_ = game_get_is_complete (_tmp11_);
#line 393 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp13_ = _tmp12_;
#line 393 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp8_ = _tmp13_;
#line 2522 "game-view.c"
	} else {
#line 393 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp8_ = FALSE;
#line 2526 "game-view.c"
	}
#line 393 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (_tmp8_) {
#line 2530 "game-view.c"
		gint n = 0;
		gint _tmp14_ = 0;
		Game* _tmp15_ = NULL;
		Game* _tmp16_ = NULL;
		gint _tmp17_ = 0;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		Player winning_color = 0;
		Player losing_color = 0;
		gint n_winning_tiles = 0;
		Game* _tmp20_ = NULL;
		Game* _tmp21_ = NULL;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
		gint n_losing_tiles = 0;
		Game* _tmp24_ = NULL;
		Game* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
		gint _tmp28_ = 0;
		gint _tmp29_ = 0;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
#line 395 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp14_ = _data2_->y;
#line 395 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp15_ = game_view_get_game (self);
#line 395 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp16_ = _tmp15_;
#line 395 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp17_ = game_get_size (_tmp16_);
#line 395 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp18_ = _tmp17_;
#line 395 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp19_ = _data2_->x;
#line 395 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		n = (_tmp14_ * _tmp18_) + _tmp19_;
#line 396 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		winning_color = PLAYER_LIGHT;
#line 397 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		losing_color = PLAYER_DARK;
#line 398 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp20_ = game_view_get_game (self);
#line 398 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp21_ = _tmp20_;
#line 398 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp22_ = game_get_n_light_tiles (_tmp21_);
#line 398 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp23_ = _tmp22_;
#line 398 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		n_winning_tiles = _tmp23_;
#line 399 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp24_ = game_view_get_game (self);
#line 399 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp25_ = _tmp24_;
#line 399 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp26_ = game_get_n_dark_tiles (_tmp25_);
#line 399 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp27_ = _tmp26_;
#line 399 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		n_losing_tiles = _tmp27_;
#line 400 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp28_ = n_losing_tiles;
#line 400 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp29_ = n_winning_tiles;
#line 400 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (_tmp28_ > _tmp29_) {
#line 2598 "game-view.c"
			gint t = 0;
			gint _tmp30_ = 0;
			gint _tmp31_ = 0;
			gint _tmp32_ = 0;
#line 402 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			winning_color = PLAYER_DARK;
#line 403 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			losing_color = PLAYER_LIGHT;
#line 404 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp30_ = n_winning_tiles;
#line 404 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			t = _tmp30_;
#line 405 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp31_ = n_losing_tiles;
#line 405 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			n_winning_tiles = _tmp31_;
#line 406 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp32_ = t;
#line 406 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			n_losing_tiles = _tmp32_;
#line 2619 "game-view.c"
		}
#line 408 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp33_ = n;
#line 408 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp34_ = n_winning_tiles;
#line 408 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (_tmp33_ < _tmp34_) {
#line 2627 "game-view.c"
			Player _tmp35_ = 0;
			gint _tmp36_ = 0;
#line 409 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp35_ = winning_color;
#line 409 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp36_ = game_view_get_pixmap (self, _tmp35_);
#line 409 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			pixmap = _tmp36_;
#line 2636 "game-view.c"
		} else {
			gint _tmp37_ = 0;
			gint _tmp38_ = 0;
			gint _tmp39_ = 0;
#line 410 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp37_ = n;
#line 410 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp38_ = n_winning_tiles;
#line 410 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp39_ = n_losing_tiles;
#line 410 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_tmp37_ < (_tmp38_ + _tmp39_)) {
#line 2649 "game-view.c"
				Player _tmp40_ = 0;
				gint _tmp41_ = 0;
#line 411 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp40_ = losing_color;
#line 411 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp41_ = game_view_get_pixmap (self, _tmp40_);
#line 411 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				pixmap = _tmp41_;
#line 2658 "game-view.c"
			} else {
				gint _tmp42_ = 0;
#line 413 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp42_ = game_view_get_pixmap (self, PLAYER_NONE);
#line 413 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				pixmap = _tmp42_;
#line 2665 "game-view.c"
			}
		}
	} else {
		gboolean _tmp43_ = FALSE;
#line 416 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp43_ = self->priv->flip_final_result_now;
#line 416 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (_tmp43_) {
#line 418 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			self->priv->flip_final_result_now = FALSE;
#line 2676 "game-view.c"
		}
	}
#line 421 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp44_ = _data2_->x;
#line 421 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp45_ = _data2_->y;
#line 421 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp46_ = pixmap;
#line 421 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	game_view_set_square (self, _tmp44_, _tmp45_, _tmp46_);
#line 423 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp49_ = game_view_get_game (self);
#line 423 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp50_ = _tmp49_;
#line 423 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp51_ = game_get_is_complete (_tmp50_);
#line 423 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp52_ = _tmp51_;
#line 423 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (_tmp52_) {
#line 2697 "game-view.c"
		Game* _tmp53_ = NULL;
		Game* _tmp54_ = NULL;
		gint _tmp55_ = 0;
		gint _tmp56_ = 0;
#line 423 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp53_ = game_view_get_game (self);
#line 423 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp54_ = _tmp53_;
#line 423 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp55_ = game_get_n_light_tiles (_tmp54_);
#line 423 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp56_ = _tmp55_;
#line 423 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp48_ = _tmp56_ > 0;
#line 2712 "game-view.c"
	} else {
#line 423 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp48_ = FALSE;
#line 2716 "game-view.c"
	}
#line 423 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (_tmp48_) {
#line 2720 "game-view.c"
		Game* _tmp57_ = NULL;
		Game* _tmp58_ = NULL;
		gint _tmp59_ = 0;
		gint _tmp60_ = 0;
#line 423 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp57_ = game_view_get_game (self);
#line 423 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp58_ = _tmp57_;
#line 423 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp59_ = game_get_n_dark_tiles (_tmp58_);
#line 423 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp60_ = _tmp59_;
#line 423 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp47_ = _tmp60_ > 0;
#line 2735 "game-view.c"
	} else {
#line 423 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp47_ = FALSE;
#line 2739 "game-view.c"
	}
#line 423 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (_tmp47_) {
#line 429 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 2, ____lambda6__gsource_func, block2_data_ref (_data2_), block2_data_unref);
#line 2745 "game-view.c"
	}
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	block2_data_unref (_data2_);
#line 388 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_data2_ = NULL;
#line 2751 "game-view.c"
}


static gboolean _game_view_animate_cb_gsource_func (gpointer self) {
	gboolean result;
	result = game_view_animate_cb ((GameView*) self);
#line 451 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	return result;
#line 2760 "game-view.c"
}


static void game_view_set_square (GameView* self, gint x, gint y, gint pixmap) {
	gint* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gboolean _tmp5_ = FALSE;
	gint _tmp6_ = 0;
	gint _tmp31_ = 0;
	gint _tmp32_ = 0;
	gint _tmp33_ = 0;
	gint _tmp34_ = 0;
	gint _tmp35_ = 0;
	gint _tmp36_ = 0;
	gint _tmp37_ = 0;
	gint _tmp38_ = 0;
	gint _tmp39_ = 0;
	gint _tmp40_ = 0;
#line 437 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 439 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp0_ = self->priv->pixmaps;
#line 439 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp0__length1 = self->priv->pixmaps_length1;
#line 439 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp0__length2 = self->priv->pixmaps_length2;
#line 439 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp1_ = x;
#line 439 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp2_ = y;
#line 439 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
#line 439 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp4_ = pixmap;
#line 439 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (_tmp3_ == _tmp4_) {
#line 440 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		return;
#line 2804 "game-view.c"
	}
#line 442 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp6_ = pixmap;
#line 442 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (_tmp6_ == 0) {
#line 442 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp5_ = TRUE;
#line 2812 "game-view.c"
	} else {
		gint* _tmp7_ = NULL;
		gint _tmp7__length1 = 0;
		gint _tmp7__length2 = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
#line 442 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp7_ = self->priv->pixmaps;
#line 442 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp7__length1 = self->priv->pixmaps_length1;
#line 442 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp7__length2 = self->priv->pixmaps_length2;
#line 442 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp8_ = x;
#line 442 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp9_ = y;
#line 442 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp10_ = _tmp7_[(_tmp8_ * _tmp7__length2) + _tmp9_];
#line 442 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp5_ = _tmp10_ == 0;
#line 2834 "game-view.c"
	}
#line 442 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (_tmp5_) {
#line 2838 "game-view.c"
		gint* _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
		gint _tmp11__length2 = 0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
#line 443 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp11_ = self->priv->pixmaps;
#line 443 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp11__length1 = self->priv->pixmaps_length1;
#line 443 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp11__length2 = self->priv->pixmaps_length2;
#line 443 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp12_ = x;
#line 443 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp13_ = y;
#line 443 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp14_ = pixmap;
#line 443 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp11_[(_tmp12_ * _tmp11__length2) + _tmp13_] = _tmp14_;
#line 443 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp15_ = _tmp11_[(_tmp12_ * _tmp11__length2) + _tmp13_];
#line 2862 "game-view.c"
	} else {
		gint _tmp16_ = 0;
		gint* _tmp17_ = NULL;
		gint _tmp17__length1 = 0;
		gint _tmp17__length2 = 0;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		guint _tmp29_ = 0U;
#line 446 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp16_ = pixmap;
#line 446 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp17_ = self->priv->pixmaps;
#line 446 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp17__length1 = self->priv->pixmaps_length1;
#line 446 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp17__length2 = self->priv->pixmaps_length2;
#line 446 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp18_ = x;
#line 446 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp19_ = y;
#line 446 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp20_ = _tmp17_[(_tmp18_ * _tmp17__length2) + _tmp19_];
#line 446 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (_tmp16_ > _tmp20_) {
#line 2888 "game-view.c"
			gint* _tmp21_ = NULL;
			gint _tmp21__length1 = 0;
			gint _tmp21__length2 = 0;
			gint _tmp22_ = 0;
			gint _tmp23_ = 0;
			gint _tmp24_ = 0;
#line 447 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp21_ = self->priv->pixmaps;
#line 447 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp21__length1 = self->priv->pixmaps_length1;
#line 447 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp21__length2 = self->priv->pixmaps_length2;
#line 447 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp22_ = x;
#line 447 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp23_ = y;
#line 447 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp24_ = _tmp21_[(_tmp22_ * _tmp21__length2) + _tmp23_];
#line 447 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp21_[(_tmp22_ * _tmp21__length2) + _tmp23_] = _tmp24_ + 1;
#line 2909 "game-view.c"
		} else {
			gint* _tmp25_ = NULL;
			gint _tmp25__length1 = 0;
			gint _tmp25__length2 = 0;
			gint _tmp26_ = 0;
			gint _tmp27_ = 0;
			gint _tmp28_ = 0;
#line 449 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp25_ = self->priv->pixmaps;
#line 449 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp25__length1 = self->priv->pixmaps_length1;
#line 449 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp25__length2 = self->priv->pixmaps_length2;
#line 449 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp26_ = x;
#line 449 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp27_ = y;
#line 449 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp28_ = _tmp25_[(_tmp26_ * _tmp25__length2) + _tmp27_];
#line 449 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp25_[(_tmp26_ * _tmp25__length2) + _tmp27_] = _tmp28_ - 1;
#line 2931 "game-view.c"
		}
#line 450 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp29_ = self->priv->animate_timeout;
#line 450 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (_tmp29_ == ((guint) 0)) {
#line 2937 "game-view.c"
			guint _tmp30_ = 0U;
#line 451 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp30_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) GAME_VIEW_PIXMAP_FLIP_DELAY, _game_view_animate_cb_gsource_func, g_object_ref (self), g_object_unref);
#line 451 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			self->priv->animate_timeout = _tmp30_;
#line 2943 "game-view.c"
		}
	}
#line 453 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp31_ = game_view_get_board_x (self);
#line 453 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp32_ = _tmp31_;
#line 453 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp33_ = x;
#line 453 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp34_ = self->priv->paving_size;
#line 453 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp35_ = game_view_get_board_y (self);
#line 453 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp36_ = _tmp35_;
#line 453 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp37_ = y;
#line 453 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp38_ = self->priv->paving_size;
#line 453 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp39_ = self->priv->tile_size;
#line 453 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp40_ = self->priv->tile_size;
#line 453 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	gtk_widget_queue_draw_area ((GtkWidget*) self, _tmp32_ + (_tmp33_ * _tmp34_), _tmp36_ + (_tmp37_ * _tmp38_), _tmp39_, _tmp40_);
#line 2968 "game-view.c"
}


static gboolean game_view_animate_cb (GameView* self) {
	gboolean result = FALSE;
	gboolean animating = FALSE;
	gboolean _tmp25_ = FALSE;
#line 456 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 458 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	animating = FALSE;
#line 2980 "game-view.c"
	{
		gint x = 0;
#line 460 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		x = 0;
#line 2985 "game-view.c"
		{
			gboolean _tmp0_ = FALSE;
#line 460 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp0_ = TRUE;
#line 460 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			while (TRUE) {
#line 2992 "game-view.c"
				gint _tmp2_ = 0;
				Game* _tmp3_ = NULL;
				Game* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
#line 460 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				if (!_tmp0_) {
#line 3000 "game-view.c"
					gint _tmp1_ = 0;
#line 460 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
					_tmp1_ = x;
#line 460 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
					x = _tmp1_ + 1;
#line 3006 "game-view.c"
				}
#line 460 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp0_ = FALSE;
#line 460 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp2_ = x;
#line 460 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp3_ = game_view_get_game (self);
#line 460 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp4_ = _tmp3_;
#line 460 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp5_ = game_get_size (_tmp4_);
#line 460 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp6_ = _tmp5_;
#line 460 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				if (!(_tmp2_ < _tmp6_)) {
#line 460 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
					break;
#line 3024 "game-view.c"
				}
				{
					gint y = 0;
#line 462 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
					y = 0;
#line 3030 "game-view.c"
					{
						gboolean _tmp7_ = FALSE;
#line 462 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
						_tmp7_ = TRUE;
#line 462 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
						while (TRUE) {
#line 3037 "game-view.c"
							gint _tmp9_ = 0;
							Game* _tmp10_ = NULL;
							Game* _tmp11_ = NULL;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							gint old = 0;
							gint* _tmp14_ = NULL;
							gint _tmp14__length1 = 0;
							gint _tmp14__length2 = 0;
							gint _tmp15_ = 0;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							gint _tmp18_ = 0;
							gint _tmp19_ = 0;
							gint* _tmp20_ = NULL;
							gint _tmp20__length1 = 0;
							gint _tmp20__length2 = 0;
							gint _tmp21_ = 0;
							gint _tmp22_ = 0;
							gint _tmp23_ = 0;
							gint _tmp24_ = 0;
#line 462 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							if (!_tmp7_) {
#line 3061 "game-view.c"
								gint _tmp8_ = 0;
#line 462 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp8_ = y;
#line 462 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								y = _tmp8_ + 1;
#line 3067 "game-view.c"
							}
#line 462 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp7_ = FALSE;
#line 462 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp9_ = y;
#line 462 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp10_ = game_view_get_game (self);
#line 462 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp11_ = _tmp10_;
#line 462 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp12_ = game_get_size (_tmp11_);
#line 462 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp13_ = _tmp12_;
#line 462 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							if (!(_tmp9_ < _tmp13_)) {
#line 462 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								break;
#line 3085 "game-view.c"
							}
#line 464 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp14_ = self->priv->pixmaps;
#line 464 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp14__length1 = self->priv->pixmaps_length1;
#line 464 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp14__length2 = self->priv->pixmaps_length2;
#line 464 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp15_ = x;
#line 464 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp16_ = y;
#line 464 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp17_ = _tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_];
#line 464 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							old = _tmp17_;
#line 465 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp18_ = x;
#line 465 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp19_ = y;
#line 465 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							game_view_update_square (self, _tmp18_, _tmp19_);
#line 466 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp20_ = self->priv->pixmaps;
#line 466 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp20__length1 = self->priv->pixmaps_length1;
#line 466 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp20__length2 = self->priv->pixmaps_length2;
#line 466 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp21_ = x;
#line 466 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp22_ = y;
#line 466 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp23_ = _tmp20_[(_tmp21_ * _tmp20__length2) + _tmp22_];
#line 466 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp24_ = old;
#line 466 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							if (_tmp23_ != _tmp24_) {
#line 467 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								animating = TRUE;
#line 3125 "game-view.c"
							}
						}
					}
				}
			}
		}
	}
#line 471 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp25_ = animating;
#line 471 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (!_tmp25_) {
#line 473 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		self->priv->animate_timeout = (guint) 0;
#line 474 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		result = G_SOURCE_REMOVE;
#line 474 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		return result;
#line 3143 "game-view.c"
	}
#line 477 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	result = G_SOURCE_CONTINUE;
#line 477 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	return result;
#line 3149 "game-view.c"
}


static gint game_view_get_pixmap (GameView* self, Player color) {
	gint result = 0;
	Player _tmp0_ = 0;
#line 480 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 482 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp0_ = color;
#line 482 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	switch (_tmp0_) {
#line 3162 "game-view.c"
		default:
#line 482 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		case PLAYER_NONE:
#line 3166 "game-view.c"
		{
#line 486 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			result = 0;
#line 486 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			return result;
#line 3172 "game-view.c"
		}
#line 482 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		case PLAYER_DARK:
#line 3176 "game-view.c"
		{
#line 488 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			result = 1;
#line 488 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			return result;
#line 3182 "game-view.c"
		}
#line 482 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		case PLAYER_LIGHT:
#line 3186 "game-view.c"
		{
#line 490 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			result = 31;
#line 490 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			return result;
#line 3192 "game-view.c"
		}
	}
}


static gboolean game_view_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	GameView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventButton* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
#line 494 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self = (GameView*) base;
#line 494 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 496 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp1_ = event;
#line 496 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp2_ = _tmp1_->button;
#line 496 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (_tmp2_ == ((guint) GDK_BUTTON_PRIMARY)) {
#line 496 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp0_ = TRUE;
#line 3216 "game-view.c"
	} else {
		GdkEventButton* _tmp3_ = NULL;
		guint _tmp4_ = 0U;
#line 496 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp3_ = event;
#line 496 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp4_ = _tmp3_->button;
#line 496 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp0_ = _tmp4_ == ((guint) GDK_BUTTON_SECONDARY);
#line 3226 "game-view.c"
	}
#line 496 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (_tmp0_) {
#line 3230 "game-view.c"
		gint x = 0;
		GdkEventButton* _tmp5_ = NULL;
		gdouble _tmp6_ = 0.0;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint y = 0;
		GdkEventButton* _tmp10_ = NULL;
		gdouble _tmp11_ = 0.0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gboolean _tmp15_ = FALSE;
		gboolean _tmp16_ = FALSE;
		gboolean _tmp17_ = FALSE;
		gint _tmp18_ = 0;
#line 498 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp5_ = event;
#line 498 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp6_ = _tmp5_->x;
#line 498 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp7_ = game_view_get_board_x (self);
#line 498 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp8_ = _tmp7_;
#line 498 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp9_ = self->priv->paving_size;
#line 498 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		x = ((gint) (_tmp6_ - _tmp8_)) / _tmp9_;
#line 499 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp10_ = event;
#line 499 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp11_ = _tmp10_->y;
#line 499 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp12_ = game_view_get_board_y (self);
#line 499 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp13_ = _tmp12_;
#line 499 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp14_ = self->priv->paving_size;
#line 499 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		y = ((gint) (_tmp11_ - _tmp13_)) / _tmp14_;
#line 500 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp18_ = x;
#line 500 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (_tmp18_ >= 0) {
#line 3275 "game-view.c"
			gint _tmp19_ = 0;
			Game* _tmp20_ = NULL;
			Game* _tmp21_ = NULL;
			gint _tmp22_ = 0;
			gint _tmp23_ = 0;
#line 500 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp19_ = x;
#line 500 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp20_ = game_view_get_game (self);
#line 500 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp21_ = _tmp20_;
#line 500 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp22_ = game_get_size (_tmp21_);
#line 500 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp23_ = _tmp22_;
#line 500 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp17_ = _tmp19_ < _tmp23_;
#line 3293 "game-view.c"
		} else {
#line 500 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp17_ = FALSE;
#line 3297 "game-view.c"
		}
#line 500 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (_tmp17_) {
#line 3301 "game-view.c"
			gint _tmp24_ = 0;
#line 500 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp24_ = y;
#line 500 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp16_ = _tmp24_ >= 0;
#line 3307 "game-view.c"
		} else {
#line 500 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp16_ = FALSE;
#line 3311 "game-view.c"
		}
#line 500 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (_tmp16_) {
#line 3315 "game-view.c"
			gint _tmp25_ = 0;
			Game* _tmp26_ = NULL;
			Game* _tmp27_ = NULL;
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
#line 500 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp25_ = y;
#line 500 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp26_ = game_view_get_game (self);
#line 500 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp27_ = _tmp26_;
#line 500 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp28_ = game_get_size (_tmp27_);
#line 500 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp29_ = _tmp28_;
#line 500 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp15_ = _tmp25_ < _tmp29_;
#line 3333 "game-view.c"
		} else {
#line 500 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp15_ = FALSE;
#line 3337 "game-view.c"
		}
#line 500 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (_tmp15_) {
#line 3341 "game-view.c"
			gint _tmp30_ = 0;
			gint _tmp31_ = 0;
			gint _tmp32_ = 0;
			gint _tmp33_ = 0;
#line 502 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			self->priv->show_highlight = FALSE;
#line 503 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			gtk_widget_queue_draw ((GtkWidget*) self);
#line 504 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp30_ = x;
#line 504 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			self->priv->highlight_x = _tmp30_;
#line 505 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp31_ = y;
#line 505 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			self->priv->highlight_y = _tmp31_;
#line 506 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp32_ = x;
#line 506 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp33_ = y;
#line 506 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_signal_emit_by_name (self, "move", _tmp32_, _tmp33_);
#line 3364 "game-view.c"
		}
	}
#line 510 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	result = TRUE;
#line 510 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	return result;
#line 3371 "game-view.c"
}


static gboolean game_view_real_key_press_event (GtkWidget* base, GdkEventKey* event) {
	GameView * self;
	gboolean result = FALSE;
	gchar* key = NULL;
	GdkEventKey* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	Game* _tmp19_ = NULL;
	Game* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	const gchar* _tmp78_ = NULL;
	const gchar* _tmp79_ = NULL;
	GQuark _tmp81_ = 0U;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label0 = 0;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label1 = 0;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label2 = 0;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label3 = 0;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label4 = 0;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label5 = 0;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label6 = 0;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label7 = 0;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label8 = 0;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label9 = 0;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label10 = 0;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label11 = 0;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label12 = 0;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label13 = 0;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label14 = 0;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label15 = 0;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label16 = 0;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label17 = 0;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label18 = 0;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label19 = 0;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label20 = 0;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label21 = 0;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label22 = 0;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label23 = 0;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label24 = 0;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label25 = 0;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label26 = 0;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label27 = 0;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label28 = 0;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label29 = 0;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label30 = 0;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label31 = 0;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label32 = 0;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label33 = 0;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label34 = 0;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label35 = 0;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label36 = 0;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label37 = 0;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label38 = 0;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label39 = 0;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label40 = 0;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label41 = 0;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label42 = 0;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label43 = 0;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label44 = 0;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label45 = 0;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label46 = 0;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label47 = 0;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label48 = 0;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	static GQuark _tmp80_label49 = 0;
#line 3498 "game-view.c"
	const gchar* _tmp106_ = NULL;
#line 513 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self = (GameView*) base;
#line 513 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 515 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp0_ = event;
#line 515 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp1_ = _tmp0_->keyval;
#line 515 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp2_ = gdk_keyval_name (_tmp1_);
#line 515 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 515 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	key = _tmp3_;
#line 517 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp5_ = self->priv->show_highlight;
#line 517 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (_tmp5_) {
#line 3518 "game-view.c"
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		const gchar* _tmp8_ = NULL;
#line 517 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp8_ = key;
#line 517 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (g_strcmp0 (_tmp8_, "space") == 0) {
#line 517 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp7_ = TRUE;
#line 3528 "game-view.c"
		} else {
			const gchar* _tmp9_ = NULL;
#line 517 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp9_ = key;
#line 517 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp7_ = g_strcmp0 (_tmp9_, "Return") == 0;
#line 3535 "game-view.c"
		}
#line 517 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (_tmp7_) {
#line 517 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp6_ = TRUE;
#line 3541 "game-view.c"
		} else {
			const gchar* _tmp10_ = NULL;
#line 517 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp10_ = key;
#line 517 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp6_ = g_strcmp0 (_tmp10_, "KP_Enter") == 0;
#line 3548 "game-view.c"
		}
#line 517 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp4_ = _tmp6_;
#line 3552 "game-view.c"
	} else {
#line 517 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp4_ = FALSE;
#line 3556 "game-view.c"
	}
#line 517 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (_tmp4_) {
#line 3560 "game-view.c"
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
#line 519 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp11_ = self->priv->highlight_x;
#line 519 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp12_ = self->priv->highlight_y;
#line 519 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_signal_emit_by_name (self, "move", _tmp11_, _tmp12_);
#line 520 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		result = TRUE;
#line 520 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_g_free0 (key);
#line 520 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		return result;
#line 3575 "game-view.c"
	}
#line 523 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp19_ = game_view_get_game (self);
#line 523 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp20_ = _tmp19_;
#line 523 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp21_ = game_get_size (_tmp20_);
#line 523 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp22_ = _tmp21_;
#line 523 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (_tmp22_ <= 4) {
#line 3587 "game-view.c"
		gboolean _tmp23_ = FALSE;
		gboolean _tmp24_ = FALSE;
		const gchar* _tmp25_ = NULL;
#line 523 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp25_ = key;
#line 523 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (g_strcmp0 (_tmp25_, "e") == 0) {
#line 523 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp24_ = TRUE;
#line 3597 "game-view.c"
		} else {
			const gchar* _tmp26_ = NULL;
#line 523 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp26_ = key;
#line 523 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp24_ = g_strcmp0 (_tmp26_, "5") == 0;
#line 3604 "game-view.c"
		}
#line 523 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (_tmp24_) {
#line 523 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp23_ = TRUE;
#line 3610 "game-view.c"
		} else {
			const gchar* _tmp27_ = NULL;
#line 523 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp27_ = key;
#line 523 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp23_ = g_strcmp0 (_tmp27_, "KP_5") == 0;
#line 3617 "game-view.c"
		}
#line 523 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp18_ = _tmp23_;
#line 3621 "game-view.c"
	} else {
#line 523 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp18_ = FALSE;
#line 3625 "game-view.c"
	}
#line 523 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (_tmp18_) {
#line 523 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp17_ = TRUE;
#line 3631 "game-view.c"
	} else {
		gboolean _tmp28_ = FALSE;
		Game* _tmp29_ = NULL;
		Game* _tmp30_ = NULL;
		gint _tmp31_ = 0;
		gint _tmp32_ = 0;
#line 524 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp29_ = game_view_get_game (self);
#line 524 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp30_ = _tmp29_;
#line 524 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp31_ = game_get_size (_tmp30_);
#line 524 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp32_ = _tmp31_;
#line 524 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (_tmp32_ <= 5) {
#line 3648 "game-view.c"
			gboolean _tmp33_ = FALSE;
			gboolean _tmp34_ = FALSE;
			const gchar* _tmp35_ = NULL;
#line 524 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp35_ = key;
#line 524 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (g_strcmp0 (_tmp35_, "f") == 0) {
#line 524 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp34_ = TRUE;
#line 3658 "game-view.c"
			} else {
				const gchar* _tmp36_ = NULL;
#line 524 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp36_ = key;
#line 524 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp34_ = g_strcmp0 (_tmp36_, "6") == 0;
#line 3665 "game-view.c"
			}
#line 524 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_tmp34_) {
#line 524 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp33_ = TRUE;
#line 3671 "game-view.c"
			} else {
				const gchar* _tmp37_ = NULL;
#line 524 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp37_ = key;
#line 524 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp33_ = g_strcmp0 (_tmp37_, "KP_6") == 0;
#line 3678 "game-view.c"
			}
#line 524 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp28_ = _tmp33_;
#line 3682 "game-view.c"
		} else {
#line 524 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp28_ = FALSE;
#line 3686 "game-view.c"
		}
#line 524 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp17_ = _tmp28_;
#line 3690 "game-view.c"
	}
#line 523 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (_tmp17_) {
#line 523 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp16_ = TRUE;
#line 3696 "game-view.c"
	} else {
		gboolean _tmp38_ = FALSE;
		Game* _tmp39_ = NULL;
		Game* _tmp40_ = NULL;
		gint _tmp41_ = 0;
		gint _tmp42_ = 0;
#line 525 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp39_ = game_view_get_game (self);
#line 525 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp40_ = _tmp39_;
#line 525 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp41_ = game_get_size (_tmp40_);
#line 525 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp42_ = _tmp41_;
#line 525 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (_tmp42_ <= 6) {
#line 3713 "game-view.c"
			gboolean _tmp43_ = FALSE;
			gboolean _tmp44_ = FALSE;
			const gchar* _tmp45_ = NULL;
#line 525 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp45_ = key;
#line 525 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (g_strcmp0 (_tmp45_, "g") == 0) {
#line 525 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp44_ = TRUE;
#line 3723 "game-view.c"
			} else {
				const gchar* _tmp46_ = NULL;
#line 525 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp46_ = key;
#line 525 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp44_ = g_strcmp0 (_tmp46_, "7") == 0;
#line 3730 "game-view.c"
			}
#line 525 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_tmp44_) {
#line 525 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp43_ = TRUE;
#line 3736 "game-view.c"
			} else {
				const gchar* _tmp47_ = NULL;
#line 525 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp47_ = key;
#line 525 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp43_ = g_strcmp0 (_tmp47_, "KP_7") == 0;
#line 3743 "game-view.c"
			}
#line 525 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp38_ = _tmp43_;
#line 3747 "game-view.c"
		} else {
#line 525 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp38_ = FALSE;
#line 3751 "game-view.c"
		}
#line 525 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp16_ = _tmp38_;
#line 3755 "game-view.c"
	}
#line 523 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (_tmp16_) {
#line 523 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp15_ = TRUE;
#line 3761 "game-view.c"
	} else {
		gboolean _tmp48_ = FALSE;
		Game* _tmp49_ = NULL;
		Game* _tmp50_ = NULL;
		gint _tmp51_ = 0;
		gint _tmp52_ = 0;
#line 526 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp49_ = game_view_get_game (self);
#line 526 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp50_ = _tmp49_;
#line 526 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp51_ = game_get_size (_tmp50_);
#line 526 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp52_ = _tmp51_;
#line 526 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (_tmp52_ <= 7) {
#line 3778 "game-view.c"
			gboolean _tmp53_ = FALSE;
			gboolean _tmp54_ = FALSE;
			const gchar* _tmp55_ = NULL;
#line 526 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp55_ = key;
#line 526 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (g_strcmp0 (_tmp55_, "h") == 0) {
#line 526 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp54_ = TRUE;
#line 3788 "game-view.c"
			} else {
				const gchar* _tmp56_ = NULL;
#line 526 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp56_ = key;
#line 526 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp54_ = g_strcmp0 (_tmp56_, "8") == 0;
#line 3795 "game-view.c"
			}
#line 526 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_tmp54_) {
#line 526 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp53_ = TRUE;
#line 3801 "game-view.c"
			} else {
				const gchar* _tmp57_ = NULL;
#line 526 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp57_ = key;
#line 526 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp53_ = g_strcmp0 (_tmp57_, "KP_8") == 0;
#line 3808 "game-view.c"
			}
#line 526 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp48_ = _tmp53_;
#line 3812 "game-view.c"
		} else {
#line 526 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp48_ = FALSE;
#line 3816 "game-view.c"
		}
#line 526 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp15_ = _tmp48_;
#line 3820 "game-view.c"
	}
#line 523 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (_tmp15_) {
#line 523 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp14_ = TRUE;
#line 3826 "game-view.c"
	} else {
		gboolean _tmp58_ = FALSE;
		Game* _tmp59_ = NULL;
		Game* _tmp60_ = NULL;
		gint _tmp61_ = 0;
		gint _tmp62_ = 0;
#line 527 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp59_ = game_view_get_game (self);
#line 527 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp60_ = _tmp59_;
#line 527 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp61_ = game_get_size (_tmp60_);
#line 527 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp62_ = _tmp61_;
#line 527 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (_tmp62_ <= 8) {
#line 3843 "game-view.c"
			gboolean _tmp63_ = FALSE;
			gboolean _tmp64_ = FALSE;
			const gchar* _tmp65_ = NULL;
#line 527 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp65_ = key;
#line 527 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (g_strcmp0 (_tmp65_, "i") == 0) {
#line 527 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp64_ = TRUE;
#line 3853 "game-view.c"
			} else {
				const gchar* _tmp66_ = NULL;
#line 527 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp66_ = key;
#line 527 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp64_ = g_strcmp0 (_tmp66_, "9") == 0;
#line 3860 "game-view.c"
			}
#line 527 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_tmp64_) {
#line 527 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp63_ = TRUE;
#line 3866 "game-view.c"
			} else {
				const gchar* _tmp67_ = NULL;
#line 527 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp67_ = key;
#line 527 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp63_ = g_strcmp0 (_tmp67_, "KP_9") == 0;
#line 3873 "game-view.c"
			}
#line 527 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp58_ = _tmp63_;
#line 3877 "game-view.c"
		} else {
#line 527 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp58_ = FALSE;
#line 3881 "game-view.c"
		}
#line 527 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp14_ = _tmp58_;
#line 3885 "game-view.c"
	}
#line 523 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (_tmp14_) {
#line 523 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp13_ = TRUE;
#line 3891 "game-view.c"
	} else {
		gboolean _tmp68_ = FALSE;
		Game* _tmp69_ = NULL;
		Game* _tmp70_ = NULL;
		gint _tmp71_ = 0;
		gint _tmp72_ = 0;
#line 528 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp69_ = game_view_get_game (self);
#line 528 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp70_ = _tmp69_;
#line 528 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp71_ = game_get_size (_tmp70_);
#line 528 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp72_ = _tmp71_;
#line 528 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (_tmp72_ <= 9) {
#line 3908 "game-view.c"
			gboolean _tmp73_ = FALSE;
			gboolean _tmp74_ = FALSE;
			const gchar* _tmp75_ = NULL;
#line 528 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp75_ = key;
#line 528 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (g_strcmp0 (_tmp75_, "j") == 0) {
#line 528 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp74_ = TRUE;
#line 3918 "game-view.c"
			} else {
				const gchar* _tmp76_ = NULL;
#line 528 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp76_ = key;
#line 528 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp74_ = g_strcmp0 (_tmp76_, "0") == 0;
#line 3925 "game-view.c"
			}
#line 528 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_tmp74_) {
#line 528 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp73_ = TRUE;
#line 3931 "game-view.c"
			} else {
				const gchar* _tmp77_ = NULL;
#line 528 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp77_ = key;
#line 528 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp73_ = g_strcmp0 (_tmp77_, "KP_0") == 0;
#line 3938 "game-view.c"
			}
#line 528 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp68_ = _tmp73_;
#line 3942 "game-view.c"
		} else {
#line 528 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp68_ = FALSE;
#line 3946 "game-view.c"
		}
#line 528 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp13_ = _tmp68_;
#line 3950 "game-view.c"
	}
#line 523 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (_tmp13_) {
#line 529 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		result = FALSE;
#line 529 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_g_free0 (key);
#line 529 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		return result;
#line 3960 "game-view.c"
	}
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp78_ = key;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp79_ = _tmp78_;
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp81_ = (NULL == _tmp79_) ? 0 : g_quark_from_string (_tmp79_);
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if ((_tmp81_ == ((0 != _tmp80_label0) ? _tmp80_label0 : (_tmp80_label0 = g_quark_from_static_string ("Left")))) || (_tmp81_ == ((0 != _tmp80_label1) ? _tmp80_label1 : (_tmp80_label1 = g_quark_from_static_string ("KP_Left"))))) {
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		switch (0) {
#line 3972 "game-view.c"
			default:
			{
				gint _tmp82_ = 0;
#line 535 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp82_ = self->priv->highlight_x;
#line 535 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				if (_tmp82_ > 0) {
#line 3980 "game-view.c"
					gint _tmp83_ = 0;
#line 535 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
					_tmp83_ = self->priv->highlight_x;
#line 535 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
					self->priv->highlight_x = _tmp83_ - 1;
#line 3986 "game-view.c"
				}
#line 536 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				break;
#line 3990 "game-view.c"
			}
		}
	} else if ((_tmp81_ == ((0 != _tmp80_label2) ? _tmp80_label2 : (_tmp80_label2 = g_quark_from_static_string ("Right")))) || (_tmp81_ == ((0 != _tmp80_label3) ? _tmp80_label3 : (_tmp80_label3 = g_quark_from_static_string ("KP_Right"))))) {
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		switch (0) {
#line 3996 "game-view.c"
			default:
			{
				gint _tmp84_ = 0;
				Game* _tmp85_ = NULL;
				Game* _tmp86_ = NULL;
				gint _tmp87_ = 0;
				gint _tmp88_ = 0;
#line 539 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp84_ = self->priv->highlight_x;
#line 539 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp85_ = game_view_get_game (self);
#line 539 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp86_ = _tmp85_;
#line 539 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp87_ = game_get_size (_tmp86_);
#line 539 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp88_ = _tmp87_;
#line 539 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				if (_tmp84_ < (_tmp88_ - 1)) {
#line 4016 "game-view.c"
					gint _tmp89_ = 0;
#line 539 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
					_tmp89_ = self->priv->highlight_x;
#line 539 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
					self->priv->highlight_x = _tmp89_ + 1;
#line 4022 "game-view.c"
				}
#line 540 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				break;
#line 4026 "game-view.c"
			}
		}
	} else if ((_tmp81_ == ((0 != _tmp80_label4) ? _tmp80_label4 : (_tmp80_label4 = g_quark_from_static_string ("Up")))) || (_tmp81_ == ((0 != _tmp80_label5) ? _tmp80_label5 : (_tmp80_label5 = g_quark_from_static_string ("KP_Up"))))) {
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		switch (0) {
#line 4032 "game-view.c"
			default:
			{
				gint _tmp90_ = 0;
#line 543 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp90_ = self->priv->highlight_y;
#line 543 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				if (_tmp90_ > 0) {
#line 4040 "game-view.c"
					gint _tmp91_ = 0;
#line 543 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
					_tmp91_ = self->priv->highlight_y;
#line 543 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
					self->priv->highlight_y = _tmp91_ - 1;
#line 4046 "game-view.c"
				}
#line 544 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				break;
#line 4050 "game-view.c"
			}
		}
	} else if ((_tmp81_ == ((0 != _tmp80_label6) ? _tmp80_label6 : (_tmp80_label6 = g_quark_from_static_string ("Down")))) || (_tmp81_ == ((0 != _tmp80_label7) ? _tmp80_label7 : (_tmp80_label7 = g_quark_from_static_string ("KP_Down"))))) {
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		switch (0) {
#line 4056 "game-view.c"
			default:
			{
				gint _tmp92_ = 0;
				Game* _tmp93_ = NULL;
				Game* _tmp94_ = NULL;
				gint _tmp95_ = 0;
				gint _tmp96_ = 0;
#line 547 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp92_ = self->priv->highlight_y;
#line 547 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp93_ = game_view_get_game (self);
#line 547 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp94_ = _tmp93_;
#line 547 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp95_ = game_get_size (_tmp94_);
#line 547 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp96_ = _tmp95_;
#line 547 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				if (_tmp92_ < (_tmp96_ - 1)) {
#line 4076 "game-view.c"
					gint _tmp97_ = 0;
#line 547 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
					_tmp97_ = self->priv->highlight_y;
#line 547 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
					self->priv->highlight_y = _tmp97_ + 1;
#line 4082 "game-view.c"
				}
#line 548 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				break;
#line 4086 "game-view.c"
			}
		}
	} else if ((((_tmp81_ == ((0 != _tmp80_label8) ? _tmp80_label8 : (_tmp80_label8 = g_quark_from_static_string ("space")))) || (_tmp81_ == ((0 != _tmp80_label9) ? _tmp80_label9 : (_tmp80_label9 = g_quark_from_static_string ("Return"))))) || (_tmp81_ == ((0 != _tmp80_label10) ? _tmp80_label10 : (_tmp80_label10 = g_quark_from_static_string ("KP_Enter"))))) || (_tmp81_ == ((0 != _tmp80_label11) ? _tmp80_label11 : (_tmp80_label11 = g_quark_from_static_string ("Escape"))))) {
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		switch (0) {
#line 4092 "game-view.c"
			default:
			{
#line 554 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				break;
#line 4097 "game-view.c"
			}
		}
	} else if (_tmp81_ == ((0 != _tmp80_label12) ? _tmp80_label12 : (_tmp80_label12 = g_quark_from_static_string ("a")))) {
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		switch (0) {
#line 4103 "game-view.c"
			default:
			{
#line 556 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				self->priv->highlight_x = 0;
#line 556 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				break;
#line 4110 "game-view.c"
			}
		}
	} else if (_tmp81_ == ((0 != _tmp80_label13) ? _tmp80_label13 : (_tmp80_label13 = g_quark_from_static_string ("b")))) {
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		switch (0) {
#line 4116 "game-view.c"
			default:
			{
#line 557 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				self->priv->highlight_x = 1;
#line 557 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				break;
#line 4123 "game-view.c"
			}
		}
	} else if (_tmp81_ == ((0 != _tmp80_label14) ? _tmp80_label14 : (_tmp80_label14 = g_quark_from_static_string ("c")))) {
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		switch (0) {
#line 4129 "game-view.c"
			default:
			{
#line 558 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				self->priv->highlight_x = 2;
#line 558 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				break;
#line 4136 "game-view.c"
			}
		}
	} else if (_tmp81_ == ((0 != _tmp80_label15) ? _tmp80_label15 : (_tmp80_label15 = g_quark_from_static_string ("d")))) {
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		switch (0) {
#line 4142 "game-view.c"
			default:
			{
#line 559 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				self->priv->highlight_x = 3;
#line 559 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				break;
#line 4149 "game-view.c"
			}
		}
	} else if (_tmp81_ == ((0 != _tmp80_label16) ? _tmp80_label16 : (_tmp80_label16 = g_quark_from_static_string ("e")))) {
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		switch (0) {
#line 4155 "game-view.c"
			default:
			{
#line 560 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				self->priv->highlight_x = 4;
#line 560 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				break;
#line 4162 "game-view.c"
			}
		}
	} else if (_tmp81_ == ((0 != _tmp80_label17) ? _tmp80_label17 : (_tmp80_label17 = g_quark_from_static_string ("f")))) {
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		switch (0) {
#line 4168 "game-view.c"
			default:
			{
#line 561 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				self->priv->highlight_x = 5;
#line 561 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				break;
#line 4175 "game-view.c"
			}
		}
	} else if (_tmp81_ == ((0 != _tmp80_label18) ? _tmp80_label18 : (_tmp80_label18 = g_quark_from_static_string ("g")))) {
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		switch (0) {
#line 4181 "game-view.c"
			default:
			{
#line 562 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				self->priv->highlight_x = 6;
#line 562 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				break;
#line 4188 "game-view.c"
			}
		}
	} else if (_tmp81_ == ((0 != _tmp80_label19) ? _tmp80_label19 : (_tmp80_label19 = g_quark_from_static_string ("h")))) {
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		switch (0) {
#line 4194 "game-view.c"
			default:
			{
#line 563 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				self->priv->highlight_x = 7;
#line 563 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				break;
#line 4201 "game-view.c"
			}
		}
	} else if (_tmp81_ == ((0 != _tmp80_label20) ? _tmp80_label20 : (_tmp80_label20 = g_quark_from_static_string ("i")))) {
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		switch (0) {
#line 4207 "game-view.c"
			default:
			{
#line 564 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				self->priv->highlight_x = 8;
#line 564 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				break;
#line 4214 "game-view.c"
			}
		}
	} else if (_tmp81_ == ((0 != _tmp80_label21) ? _tmp80_label21 : (_tmp80_label21 = g_quark_from_static_string ("j")))) {
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		switch (0) {
#line 4220 "game-view.c"
			default:
			{
#line 565 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				self->priv->highlight_x = 9;
#line 565 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				break;
#line 4227 "game-view.c"
			}
		}
	} else if ((_tmp81_ == ((0 != _tmp80_label22) ? _tmp80_label22 : (_tmp80_label22 = g_quark_from_static_string ("1")))) || (_tmp81_ == ((0 != _tmp80_label23) ? _tmp80_label23 : (_tmp80_label23 = g_quark_from_static_string ("KP_1"))))) {
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		switch (0) {
#line 4233 "game-view.c"
			default:
			{
#line 567 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				self->priv->highlight_y = 0;
#line 567 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				break;
#line 4240 "game-view.c"
			}
		}
	} else if ((_tmp81_ == ((0 != _tmp80_label24) ? _tmp80_label24 : (_tmp80_label24 = g_quark_from_static_string ("2")))) || (_tmp81_ == ((0 != _tmp80_label25) ? _tmp80_label25 : (_tmp80_label25 = g_quark_from_static_string ("KP_2"))))) {
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		switch (0) {
#line 4246 "game-view.c"
			default:
			{
#line 568 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				self->priv->highlight_y = 1;
#line 568 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				break;
#line 4253 "game-view.c"
			}
		}
	} else if ((_tmp81_ == ((0 != _tmp80_label26) ? _tmp80_label26 : (_tmp80_label26 = g_quark_from_static_string ("3")))) || (_tmp81_ == ((0 != _tmp80_label27) ? _tmp80_label27 : (_tmp80_label27 = g_quark_from_static_string ("KP_3"))))) {
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		switch (0) {
#line 4259 "game-view.c"
			default:
			{
#line 569 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				self->priv->highlight_y = 2;
#line 569 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				break;
#line 4266 "game-view.c"
			}
		}
	} else if ((_tmp81_ == ((0 != _tmp80_label28) ? _tmp80_label28 : (_tmp80_label28 = g_quark_from_static_string ("4")))) || (_tmp81_ == ((0 != _tmp80_label29) ? _tmp80_label29 : (_tmp80_label29 = g_quark_from_static_string ("KP_4"))))) {
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		switch (0) {
#line 4272 "game-view.c"
			default:
			{
#line 570 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				self->priv->highlight_y = 3;
#line 570 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				break;
#line 4279 "game-view.c"
			}
		}
	} else if ((_tmp81_ == ((0 != _tmp80_label30) ? _tmp80_label30 : (_tmp80_label30 = g_quark_from_static_string ("5")))) || (_tmp81_ == ((0 != _tmp80_label31) ? _tmp80_label31 : (_tmp80_label31 = g_quark_from_static_string ("KP_5"))))) {
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		switch (0) {
#line 4285 "game-view.c"
			default:
			{
#line 571 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				self->priv->highlight_y = 4;
#line 571 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				break;
#line 4292 "game-view.c"
			}
		}
	} else if ((_tmp81_ == ((0 != _tmp80_label32) ? _tmp80_label32 : (_tmp80_label32 = g_quark_from_static_string ("6")))) || (_tmp81_ == ((0 != _tmp80_label33) ? _tmp80_label33 : (_tmp80_label33 = g_quark_from_static_string ("KP_6"))))) {
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		switch (0) {
#line 4298 "game-view.c"
			default:
			{
#line 572 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				self->priv->highlight_y = 5;
#line 572 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				break;
#line 4305 "game-view.c"
			}
		}
	} else if ((_tmp81_ == ((0 != _tmp80_label34) ? _tmp80_label34 : (_tmp80_label34 = g_quark_from_static_string ("7")))) || (_tmp81_ == ((0 != _tmp80_label35) ? _tmp80_label35 : (_tmp80_label35 = g_quark_from_static_string ("KP_7"))))) {
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		switch (0) {
#line 4311 "game-view.c"
			default:
			{
#line 573 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				self->priv->highlight_y = 6;
#line 573 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				break;
#line 4318 "game-view.c"
			}
		}
	} else if ((_tmp81_ == ((0 != _tmp80_label36) ? _tmp80_label36 : (_tmp80_label36 = g_quark_from_static_string ("8")))) || (_tmp81_ == ((0 != _tmp80_label37) ? _tmp80_label37 : (_tmp80_label37 = g_quark_from_static_string ("KP_8"))))) {
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		switch (0) {
#line 4324 "game-view.c"
			default:
			{
#line 574 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				self->priv->highlight_y = 7;
#line 574 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				break;
#line 4331 "game-view.c"
			}
		}
	} else if ((_tmp81_ == ((0 != _tmp80_label38) ? _tmp80_label38 : (_tmp80_label38 = g_quark_from_static_string ("9")))) || (_tmp81_ == ((0 != _tmp80_label39) ? _tmp80_label39 : (_tmp80_label39 = g_quark_from_static_string ("KP_9"))))) {
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		switch (0) {
#line 4337 "game-view.c"
			default:
			{
#line 575 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				self->priv->highlight_y = 8;
#line 575 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				break;
#line 4344 "game-view.c"
			}
		}
	} else if ((_tmp81_ == ((0 != _tmp80_label40) ? _tmp80_label40 : (_tmp80_label40 = g_quark_from_static_string ("0")))) || (_tmp81_ == ((0 != _tmp80_label41) ? _tmp80_label41 : (_tmp80_label41 = g_quark_from_static_string ("KP_0"))))) {
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		switch (0) {
#line 4350 "game-view.c"
			default:
			{
#line 576 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				self->priv->highlight_y = 9;
#line 576 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				break;
#line 4357 "game-view.c"
			}
		}
	} else if ((_tmp81_ == ((0 != _tmp80_label42) ? _tmp80_label42 : (_tmp80_label42 = g_quark_from_static_string ("Home")))) || (_tmp81_ == ((0 != _tmp80_label43) ? _tmp80_label43 : (_tmp80_label43 = g_quark_from_static_string ("KP_Home"))))) {
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		switch (0) {
#line 4363 "game-view.c"
			default:
			{
#line 580 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				self->priv->highlight_x = 0;
#line 581 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				break;
#line 4370 "game-view.c"
			}
		}
	} else if ((_tmp81_ == ((0 != _tmp80_label44) ? _tmp80_label44 : (_tmp80_label44 = g_quark_from_static_string ("End")))) || (_tmp81_ == ((0 != _tmp80_label45) ? _tmp80_label45 : (_tmp80_label45 = g_quark_from_static_string ("KP_End"))))) {
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		switch (0) {
#line 4376 "game-view.c"
			default:
			{
				Game* _tmp98_ = NULL;
				Game* _tmp99_ = NULL;
				gint _tmp100_ = 0;
				gint _tmp101_ = 0;
#line 584 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp98_ = game_view_get_game (self);
#line 584 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp99_ = _tmp98_;
#line 584 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp100_ = game_get_size (_tmp99_);
#line 584 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp101_ = _tmp100_;
#line 584 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				self->priv->highlight_x = _tmp101_ - 1;
#line 585 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				break;
#line 4395 "game-view.c"
			}
		}
	} else if ((_tmp81_ == ((0 != _tmp80_label46) ? _tmp80_label46 : (_tmp80_label46 = g_quark_from_static_string ("Page_Up")))) || (_tmp81_ == ((0 != _tmp80_label47) ? _tmp80_label47 : (_tmp80_label47 = g_quark_from_static_string ("KP_Page_Up"))))) {
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		switch (0) {
#line 4401 "game-view.c"
			default:
			{
#line 588 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				self->priv->highlight_y = 0;
#line 589 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				break;
#line 4408 "game-view.c"
			}
		}
	} else if ((_tmp81_ == ((0 != _tmp80_label48) ? _tmp80_label48 : (_tmp80_label48 = g_quark_from_static_string ("Page_Down")))) || (_tmp81_ == ((0 != _tmp80_label49) ? _tmp80_label49 : (_tmp80_label49 = g_quark_from_static_string ("KP_Next"))))) {
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		switch (0) {
#line 4414 "game-view.c"
			default:
			{
				Game* _tmp102_ = NULL;
				Game* _tmp103_ = NULL;
				gint _tmp104_ = 0;
				gint _tmp105_ = 0;
#line 592 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp102_ = game_view_get_game (self);
#line 592 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp103_ = _tmp102_;
#line 592 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp104_ = game_get_size (_tmp103_);
#line 592 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp105_ = _tmp104_;
#line 592 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				self->priv->highlight_y = _tmp105_ - 1;
#line 593 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				break;
#line 4433 "game-view.c"
			}
		}
	} else {
#line 531 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		switch (0) {
#line 4439 "game-view.c"
			default:
			{
#line 597 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				result = FALSE;
#line 597 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_g_free0 (key);
#line 597 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				return result;
#line 4448 "game-view.c"
			}
		}
	}
#line 600 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp106_ = key;
#line 600 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (g_strcmp0 (_tmp106_, "Escape") == 0) {
#line 601 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		self->priv->show_highlight = FALSE;
#line 4458 "game-view.c"
	} else {
		gboolean _tmp107_ = FALSE;
#line 602 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp107_ = self->priv->show_highlight;
#line 602 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (_tmp107_) {
#line 603 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			self->priv->highlight_state = GAME_VIEW_HIGHLIGHT_MAX;
#line 4467 "game-view.c"
		} else {
#line 605 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			self->priv->show_highlight = TRUE;
#line 4471 "game-view.c"
		}
	}
#line 607 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 608 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	result = TRUE;
#line 608 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_g_free0 (key);
#line 608 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	return result;
#line 4482 "game-view.c"
}


static gboolean game_view_draw_scoreboard (GameView* self, cairo_t* cr) {
	gboolean result = FALSE;
	gint height = 0;
	GtkDrawingArea* _tmp0_ = NULL;
	GtkDrawingArea* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint width = 0;
	GtkDrawingArea* _tmp3_ = NULL;
	GtkDrawingArea* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	cairo_t* _tmp6_ = NULL;
	cairo_t* _tmp7_ = NULL;
	cairo_t* _tmp8_ = NULL;
	cairo_t* _tmp9_ = NULL;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
	gdouble _tmp12_ = 0.0;
	cairo_t* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	cairo_t* _tmp15_ = NULL;
	gint _tmp16_ = 0;
	cairo_t* _tmp17_ = NULL;
	cairo_t* _tmp18_ = NULL;
	cairo_t* _tmp19_ = NULL;
	cairo_t* _tmp20_ = NULL;
	cairo_t* _tmp21_ = NULL;
	cairo_surface_t* surface = NULL;
	cairo_t* _tmp22_ = NULL;
	cairo_surface_t* _tmp23_ = NULL;
	cairo_surface_t* _tmp24_ = NULL;
	cairo_t* c = NULL;
	cairo_t* _tmp25_ = NULL;
	cairo_pattern_t* _tmp26_ = NULL;
	cairo_t* _tmp27_ = NULL;
	cairo_matrix_t matrix = {0};
	cairo_pattern_t* _tmp28_ = NULL;
	cairo_matrix_t _tmp29_ = {0};
	cairo_t* _tmp30_ = NULL;
	cairo_pattern_t* _tmp31_ = NULL;
	cairo_t* _tmp32_ = NULL;
	cairo_t* _tmp33_ = NULL;
	cairo_pattern_t* _tmp34_ = NULL;
	cairo_matrix_t _tmp35_ = {0};
	cairo_t* _tmp36_ = NULL;
	cairo_pattern_t* _tmp37_ = NULL;
	cairo_t* _tmp38_ = NULL;
	cairo_t* _tmp39_ = NULL;
#line 615 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 615 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_val_if_fail (cr != NULL, FALSE);
#line 617 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp0_ = game_view_get_scoreboard (self);
#line 617 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp1_ = _tmp0_;
#line 617 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp2_ = gtk_widget_get_allocated_height ((GtkWidget*) _tmp1_);
#line 617 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	height = _tmp2_;
#line 618 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp3_ = game_view_get_scoreboard (self);
#line 618 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp4_ = _tmp3_;
#line 618 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp5_ = gtk_widget_get_allocated_width ((GtkWidget*) _tmp4_);
#line 618 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	width = _tmp5_;
#line 620 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp6_ = cr;
#line 620 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_set_line_cap (_tmp6_, CAIRO_LINE_CAP_ROUND);
#line 621 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp7_ = cr;
#line 621 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_set_line_join (_tmp7_, CAIRO_LINE_JOIN_ROUND);
#line 623 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp8_ = cr;
#line 623 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_save (_tmp8_);
#line 625 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp9_ = cr;
#line 625 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp10_ = self->priv->mark_red;
#line 625 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp11_ = self->priv->mark_green;
#line 625 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp12_ = self->priv->mark_blue;
#line 625 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_set_source_rgba (_tmp9_, _tmp10_, _tmp11_, _tmp12_, 1.0);
#line 626 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp13_ = cr;
#line 626 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp14_ = self->priv->mark_width;
#line 626 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_set_line_width (_tmp13_, (gdouble) _tmp14_);
#line 628 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp15_ = cr;
#line 628 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp16_ = self->priv->current_player_number;
#line 628 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_translate (_tmp15_, (gdouble) 0, (_tmp16_ * height) / 2.0);
#line 629 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp17_ = cr;
#line 629 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_move_to (_tmp17_, height / 4.0, height / 8.0);
#line 630 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp18_ = cr;
#line 630 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_line_to (_tmp18_, width - ((5.0 * height) / 8.0), height / 4.0);
#line 631 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp19_ = cr;
#line 631 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_line_to (_tmp19_, height / 4.0, (3.0 * height) / 8.0);
#line 632 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp20_ = cr;
#line 632 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_stroke (_tmp20_);
#line 634 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp21_ = cr;
#line 634 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_restore (_tmp21_);
#line 639 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp22_ = cr;
#line 639 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp23_ = cairo_get_target (_tmp22_);
#line 639 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp24_ = cairo_surface_create_similar (_tmp23_, CAIRO_CONTENT_COLOR_ALPHA, height * 4, height * 2);
#line 639 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	surface = _tmp24_;
#line 640 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp25_ = cairo_create (surface);
#line 640 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	c = _tmp25_;
#line 641 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	game_view_load_image (self, c, height * 4, height * 2);
#line 642 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp26_ = cairo_pattern_create_for_surface (surface);
#line 642 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_cairo_pattern_destroy0 (self->priv->scoreboard_tiles_pattern);
#line 642 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->scoreboard_tiles_pattern = _tmp26_;
#line 644 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp27_ = cr;
#line 644 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_translate (_tmp27_, width - (height / 2.0), (gdouble) 0);
#line 645 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_matrix_init_identity (&matrix);
#line 648 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_matrix_translate (&matrix, height / 2.0, (gdouble) 0);
#line 649 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp28_ = self->priv->scoreboard_tiles_pattern;
#line 649 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp29_ = matrix;
#line 649 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_pattern_set_matrix (_tmp28_, &_tmp29_);
#line 650 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp30_ = cr;
#line 650 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp31_ = self->priv->scoreboard_tiles_pattern;
#line 650 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_set_source (_tmp30_, _tmp31_);
#line 651 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp32_ = cr;
#line 651 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_rectangle (_tmp32_, (gdouble) 0, (gdouble) 0, height / 2.0, height / 2.0);
#line 652 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp33_ = cr;
#line 652 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_fill (_tmp33_);
#line 655 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_matrix_translate (&matrix, (gdouble) (3 * height), (gdouble) height);
#line 656 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp34_ = self->priv->scoreboard_tiles_pattern;
#line 656 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp35_ = matrix;
#line 656 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_pattern_set_matrix (_tmp34_, &_tmp35_);
#line 657 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp36_ = cr;
#line 657 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp37_ = self->priv->scoreboard_tiles_pattern;
#line 657 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_set_source (_tmp36_, _tmp37_);
#line 658 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp38_ = cr;
#line 658 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_rectangle (_tmp38_, (gdouble) 0, height / 2.0, height / 2.0, height / 2.0);
#line 659 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp39_ = cr;
#line 659 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	cairo_fill (_tmp39_);
#line 678 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	result = TRUE;
#line 678 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_cairo_destroy0 (c);
#line 678 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_cairo_surface_destroy0 (surface);
#line 678 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	return result;
#line 4685 "game-view.c"
}


void game_view_update_scoreboard (GameView* self) {
	gint _tmp0_ = 0;
	Game* _tmp1_ = NULL;
	Game* _tmp2_ = NULL;
	Player _tmp3_ = 0;
	Player _tmp4_ = 0;
	GtkDrawingArea* _tmp5_ = NULL;
	GtkDrawingArea* _tmp6_ = NULL;
#line 681 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 683 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp1_ = game_view_get_game (self);
#line 683 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp2_ = _tmp1_;
#line 683 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp3_ = game_get_current_color (_tmp2_);
#line 683 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp4_ = _tmp3_;
#line 683 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (_tmp4_ == PLAYER_DARK) {
#line 683 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp0_ = 0;
#line 4711 "game-view.c"
	} else {
#line 683 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp0_ = 1;
#line 4715 "game-view.c"
	}
#line 683 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->current_player_number = _tmp0_;
#line 684 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp5_ = game_view_get_scoreboard (self);
#line 684 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp6_ = _tmp5_;
#line 684 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) _tmp6_);
#line 4725 "game-view.c"
}


static GtkDrawingArea* game_view_get_scoreboard (GameView* self) {
	GtkDrawingArea* result;
	GtkDrawingArea* _tmp0_ = NULL;
#line 25 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 25 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp0_ = self->priv->_scoreboard;
#line 25 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	result = _tmp0_;
#line 25 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	return result;
#line 4740 "game-view.c"
}


static gboolean _game_view_draw_scoreboard_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self) {
	gboolean result;
	result = game_view_draw_scoreboard ((GameView*) self, cr);
#line 29 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	return result;
#line 4749 "game-view.c"
}


void game_view_set_scoreboard (GameView* self, GtkDrawingArea* value) {
	GtkDrawingArea* _tmp0_ = NULL;
	GtkDrawingArea* _tmp1_ = NULL;
	GtkDrawingArea* _tmp2_ = NULL;
#line 26 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 28 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp0_ = value;
#line 28 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 28 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_g_object_unref0 (self->priv->_scoreboard);
#line 28 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->_scoreboard = _tmp1_;
#line 29 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp2_ = self->priv->_scoreboard;
#line 29 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_signal_connect_object ((GtkWidget*) _tmp2_, "draw", (GCallback) _game_view_draw_scoreboard_gtk_widget_draw, self, 0);
#line 26 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_object_notify ((GObject *) self, "scoreboard");
#line 4773 "game-view.c"
}


const gchar* game_view_get_sound_flip (GameView* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 63 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 63 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp0_ = self->priv->_sound_flip;
#line 63 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	result = _tmp0_;
#line 63 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	return result;
#line 4788 "game-view.c"
}


static void game_view_set_sound_flip (GameView* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 63 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 63 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp0_ = value;
#line 63 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 63 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_g_free0 (self->priv->_sound_flip);
#line 63 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->_sound_flip = _tmp1_;
#line 63 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_object_notify ((GObject *) self, "sound-flip");
#line 4807 "game-view.c"
}


const gchar* game_view_get_sound_gameover (GameView* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 64 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 64 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp0_ = self->priv->_sound_gameover;
#line 64 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	result = _tmp0_;
#line 64 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	return result;
#line 4822 "game-view.c"
}


static void game_view_set_sound_gameover (GameView* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
#line 64 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 64 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp0_ = value;
#line 64 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 64 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_g_free0 (self->priv->_sound_gameover);
#line 64 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->_sound_gameover = _tmp1_;
#line 64 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_object_notify ((GObject *) self, "sound-gameover");
#line 4841 "game-view.c"
}


static gint game_view_get_board_x (GameView* self) {
	gint result;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 70 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 70 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 70 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp1_ = self->priv->board_size;
#line 70 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	result = (_tmp0_ - _tmp1_) / 2;
#line 70 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	return result;
#line 4859 "game-view.c"
}


static gint game_view_get_board_y (GameView* self) {
	gint result;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 71 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 71 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp0_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 71 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp1_ = self->priv->board_size;
#line 71 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	result = (_tmp0_ - _tmp1_) / 2;
#line 71 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	return result;
#line 4877 "game-view.c"
}


Game* game_view_get_game (GameView* self) {
	Game* result;
	Game* _tmp0_ = NULL;
#line 105 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 105 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp0_ = self->priv->_game;
#line 105 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	result = _tmp0_;
#line 105 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	return result;
#line 4892 "game-view.c"
}


static void _game_view_square_changed_cb_game_square_changed (Game* _sender, gint x, gint y, Player new_color, gpointer self) {
#line 114 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	game_view_square_changed_cb ((GameView*) self, x, y, new_color);
#line 4899 "game-view.c"
}


void game_view_set_game (GameView* self, Game* value) {
	Game* _tmp0_ = NULL;
	Game* _tmp2_ = NULL;
	Game* _tmp3_ = NULL;
	Game* _tmp4_ = NULL;
	Game* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	Game* _tmp8_ = NULL;
	Game* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint* _tmp12_ = NULL;
	Game* _tmp13_ = NULL;
#line 106 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 108 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp0_ = self->priv->_game;
#line 108 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (_tmp0_ != NULL) {
#line 4923 "game-view.c"
		Game* _tmp1_ = NULL;
#line 109 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp1_ = self->priv->_game;
#line 109 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
#line 4929 "game-view.c"
	}
#line 110 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp2_ = value;
#line 110 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 110 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_g_object_unref0 (self->priv->_game);
#line 110 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->_game = _tmp3_;
#line 111 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp4_ = game_view_get_game (self);
#line 111 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp5_ = _tmp4_;
#line 111 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp6_ = game_get_size (_tmp5_);
#line 111 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp7_ = _tmp6_;
#line 111 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp8_ = game_view_get_game (self);
#line 111 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp9_ = _tmp8_;
#line 111 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp10_ = game_get_size (_tmp9_);
#line 111 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp11_ = _tmp10_;
#line 111 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp12_ = g_new0 (gint, _tmp7_ * _tmp11_);
#line 111 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->pixmaps = (g_free (self->priv->pixmaps), NULL);
#line 111 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->pixmaps = _tmp12_;
#line 111 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->pixmaps_length1 = _tmp7_;
#line 111 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->pixmaps_length2 = _tmp11_;
#line 112 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp13_ = self->priv->_game;
#line 112 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (_tmp13_ != NULL) {
#line 4969 "game-view.c"
		Game* _tmp14_ = NULL;
#line 114 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		_tmp14_ = self->priv->_game;
#line 114 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_signal_connect_object (_tmp14_, "square-changed", (GCallback) _game_view_square_changed_cb_game_square_changed, self, 0);
#line 4975 "game-view.c"
		{
			gint x = 0;
#line 115 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			x = 0;
#line 4980 "game-view.c"
			{
				gboolean _tmp15_ = FALSE;
#line 115 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp15_ = TRUE;
#line 115 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				while (TRUE) {
#line 4987 "game-view.c"
					gint _tmp17_ = 0;
					Game* _tmp18_ = NULL;
					Game* _tmp19_ = NULL;
					gint _tmp20_ = 0;
					gint _tmp21_ = 0;
#line 115 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
					if (!_tmp15_) {
#line 4995 "game-view.c"
						gint _tmp16_ = 0;
#line 115 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
						_tmp16_ = x;
#line 115 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
						x = _tmp16_ + 1;
#line 5001 "game-view.c"
					}
#line 115 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
					_tmp15_ = FALSE;
#line 115 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
					_tmp17_ = x;
#line 115 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
					_tmp18_ = game_view_get_game (self);
#line 115 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
					_tmp19_ = _tmp18_;
#line 115 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
					_tmp20_ = game_get_size (_tmp19_);
#line 115 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
					_tmp21_ = _tmp20_;
#line 115 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
					if (!(_tmp17_ < _tmp21_)) {
#line 115 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
						break;
#line 5019 "game-view.c"
					}
					{
						gint y = 0;
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
						y = 0;
#line 5025 "game-view.c"
						{
							gboolean _tmp22_ = FALSE;
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							_tmp22_ = TRUE;
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
							while (TRUE) {
#line 5032 "game-view.c"
								gint _tmp24_ = 0;
								Game* _tmp25_ = NULL;
								Game* _tmp26_ = NULL;
								gint _tmp27_ = 0;
								gint _tmp28_ = 0;
								gint* _tmp29_ = NULL;
								gint _tmp29__length1 = 0;
								gint _tmp29__length2 = 0;
								gint _tmp30_ = 0;
								gint _tmp31_ = 0;
								Game* _tmp32_ = NULL;
								gint _tmp33_ = 0;
								gint _tmp34_ = 0;
								Player _tmp35_ = 0;
								gint _tmp36_ = 0;
								gint _tmp37_ = 0;
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								if (!_tmp22_) {
#line 5051 "game-view.c"
									gint _tmp23_ = 0;
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
									_tmp23_ = y;
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
									y = _tmp23_ + 1;
#line 5057 "game-view.c"
								}
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp22_ = FALSE;
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp24_ = y;
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp25_ = game_view_get_game (self);
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp26_ = _tmp25_;
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp27_ = game_get_size (_tmp26_);
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp28_ = _tmp27_;
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								if (!(_tmp24_ < _tmp28_)) {
#line 116 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
									break;
#line 5075 "game-view.c"
								}
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp29_ = self->priv->pixmaps;
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp29__length1 = self->priv->pixmaps_length1;
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp29__length2 = self->priv->pixmaps_length2;
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp30_ = x;
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp31_ = y;
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp32_ = self->priv->_game;
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp33_ = x;
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp34_ = y;
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp35_ = game_get_owner (_tmp32_, _tmp33_, _tmp34_);
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp36_ = game_view_get_pixmap (self, _tmp35_);
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp29_[(_tmp30_ * _tmp29__length2) + _tmp31_] = _tmp36_;
#line 117 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
								_tmp37_ = _tmp29_[(_tmp30_ * _tmp29__length2) + _tmp31_];
#line 5101 "game-view.c"
							}
						}
					}
				}
			}
		}
	}
#line 120 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->show_highlight = FALSE;
#line 121 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->highlight_x = 3;
#line 122 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->highlight_y = 3;
#line 123 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->highlight_state = 0;
#line 125 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 106 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_object_notify ((GObject *) self, "game");
#line 5121 "game-view.c"
}


const gchar* game_view_get_theme (GameView* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp0_ = self->priv->_theme;
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	result = _tmp0_;
#line 132 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	return result;
#line 5136 "game-view.c"
}


void game_view_set_theme (GameView* self, const gchar* value) {
	GKeyFile* key = NULL;
	GKeyFile* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GKeyFile* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	GtkDrawingArea* _tmp19_ = NULL;
	GtkDrawingArea* _tmp20_ = NULL;
	GError * _inner_error_ = NULL;
#line 133 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_if_fail (self != NULL);
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp0_ = g_key_file_new ();
#line 134 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	key = _tmp0_;
#line 135 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp1_ = value;
#line 135 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (g_strcmp0 (_tmp1_, "default") == 0) {
#line 136 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		game_view_set_default_theme (self, &key);
#line 5162 "game-view.c"
	} else {
		{
			gchar* key_path = NULL;
			gchar* _tmp2_ = NULL;
			gchar* filepath = NULL;
			const gchar* _tmp3_ = NULL;
			const gchar* _tmp4_ = NULL;
			gchar* _tmp5_ = NULL;
			const gchar* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
			gchar* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			gboolean _tmp10_ = FALSE;
			GKeyFile* _tmp12_ = NULL;
			const gchar* _tmp13_ = NULL;
#line 140 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp2_ = g_build_filename (DATA_DIRECTORY, "themes", "key", NULL);
#line 140 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			key_path = _tmp2_;
#line 141 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp3_ = key_path;
#line 141 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp4_ = value;
#line 141 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp5_ = g_build_filename (_tmp3_, _tmp4_, NULL);
#line 141 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			filepath = _tmp5_;
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp6_ = filepath;
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp7_ = g_path_get_dirname (_tmp6_);
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp8_ = _tmp7_;
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp9_ = key_path;
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp10_ = g_strcmp0 (_tmp8_, _tmp9_) != 0;
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (_tmp8_);
#line 142 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (_tmp10_) {
#line 5204 "game-view.c"
				GError* _tmp11_ = NULL;
#line 143 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_tmp11_ = g_error_new_literal (G_FILE_ERROR, G_FILE_ERROR_FAILED, "Theme file is not in the \"key\" directory.");
#line 143 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_inner_error_ = _tmp11_;
#line 143 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_g_free0 (filepath);
#line 143 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_g_free0 (key_path);
#line 5214 "game-view.c"
				goto __catch4_g_error;
			}
#line 145 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp12_ = key;
#line 145 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp13_ = filepath;
#line 145 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_key_file_load_from_file (_tmp12_, _tmp13_, G_KEY_FILE_NONE, &_inner_error_);
#line 145 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 145 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_g_free0 (filepath);
#line 145 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
				_g_free0 (key_path);
#line 5229 "game-view.c"
				goto __catch4_g_error;
			}
#line 138 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (filepath);
#line 138 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_free0 (key_path);
#line 5236 "game-view.c"
		}
		goto __finally4;
		__catch4_g_error:
		{
			GError* e = NULL;
			GError* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
#line 138 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			e = _inner_error_;
#line 138 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_inner_error_ = NULL;
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp14_ = e;
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_tmp15_ = _tmp14_->message;
#line 149 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_warning ("game-view.vala:149: Failed to load theme: %s", _tmp15_);
#line 150 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			game_view_set_default_theme (self, &key);
#line 151 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			value = "default";
#line 138 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_error_free0 (e);
#line 5260 "game-view.c"
		}
		__finally4:
#line 138 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 138 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			_g_key_file_unref0 (key);
#line 138 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 138 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			g_clear_error (&_inner_error_);
#line 138 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
			return;
#line 5273 "game-view.c"
		}
	}
#line 154 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp16_ = key;
#line 154 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	game_view_load_theme (self, _tmp16_);
#line 155 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp17_ = value;
#line 155 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp18_ = g_strdup (_tmp17_);
#line 155 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_g_free0 (self->priv->_theme);
#line 155 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->_theme = _tmp18_;
#line 158 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_cairo_pattern_destroy0 (self->priv->tiles_pattern);
#line 158 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->tiles_pattern = NULL;
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp19_ = game_view_get_scoreboard (self);
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_tmp20_ = _tmp19_;
#line 160 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) _tmp20_);
#line 161 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 133 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_g_key_file_unref0 (key);
#line 133 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_object_notify ((GObject *) self, "theme");
#line 5304 "game-view.c"
}


static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT_INT) (gpointer data1, gint arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_return_if_fail (n_param_values == 3);
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		data1 = closure->data;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		data2 = param_values->data[0].v_pointer;
#line 5323 "game-view.c"
	} else {
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		data1 = param_values->data[0].v_pointer;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		data2 = closure->data;
#line 5329 "game-view.c"
	}
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	callback = (GMarshalFunc_VOID__INT_INT) (marshal_data ? marshal_data : cc->callback);
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), data2);
#line 5335 "game-view.c"
}


static void game_view_class_init (GameViewClass * klass) {
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	game_view_parent_class = g_type_class_peek_parent (klass);
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_type_class_add_private (klass, sizeof (GameViewPrivate));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	((GtkWidgetClass *) klass)->draw = game_view_real_draw;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	((GtkWidgetClass *) klass)->button_press_event = game_view_real_button_press_event;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	((GtkWidgetClass *) klass)->key_press_event = game_view_real_key_press_event;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_game_view_get_property;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_game_view_set_property;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	G_OBJECT_CLASS (klass)->finalize = game_view_finalize;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_SCOREBOARD, g_param_spec_object ("scoreboard", "scoreboard", "scoreboard", gtk_drawing_area_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_SOUND_FLIP, g_param_spec_string ("sound-flip", "sound-flip", "sound-flip", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_SOUND_GAMEOVER, g_param_spec_string ("sound-gameover", "sound-gameover", "sound-gameover", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_GAME, g_param_spec_object ("game", "game", "game", TYPE_GAME, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_VIEW_THEME, g_param_spec_string ("theme", "theme", "theme", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	g_signal_new ("move", TYPE_GAME_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_INT);
#line 5368 "game-view.c"
}


static void game_view_instance_init (GameView * self) {
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv = GAME_VIEW_GET_PRIVATE (self);
#line 36 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->background_red = 0.2;
#line 37 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->background_green = 0.6;
#line 38 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->background_blue = 0.4;
#line 39 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->background_radius = 0;
#line 41 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->mark_red = 0.2;
#line 42 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->mark_green = 0.6;
#line 43 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->mark_blue = 0.4;
#line 44 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->mark_width = 2;
#line 46 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->border_red = 0.1;
#line 47 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->border_green = 0.1;
#line 48 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->border_blue = 0.1;
#line 49 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->border_width = 3;
#line 51 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->spacing_red = 0.1;
#line 52 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->spacing_green = 0.3;
#line 53 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->spacing_blue = 0.2;
#line 54 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->spacing_width = 2;
#line 56 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->highlight_red = 0.1;
#line 57 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->highlight_green = 0.3;
#line 58 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->highlight_blue = 0.2;
#line 59 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->highlight_alpha = 0.4;
#line 84 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->render_size = (guint) 0;
#line 85 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->tiles_pattern = NULL;
#line 86 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->scoreboard_tiles_pattern = NULL;
#line 92 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->animate_timeout = (guint) 0;
#line 95 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->current_player_number = 0;
#line 100 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->flip_final_result_now = FALSE;
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->_game = NULL;
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->_theme = NULL;
#line 5431 "game-view.c"
}


static void game_view_finalize (GObject* obj) {
	GameView * self;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_VIEW, GameView);
#line 23 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_g_object_unref0 (self->priv->_scoreboard);
#line 34 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_g_free0 (self->priv->pieces_file);
#line 63 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_g_free0 (self->priv->_sound_flip);
#line 64 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_g_free0 (self->priv->_sound_gameover);
#line 85 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_cairo_pattern_destroy0 (self->priv->tiles_pattern);
#line 86 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_cairo_pattern_destroy0 (self->priv->scoreboard_tiles_pattern);
#line 89 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	self->priv->pixmaps = (g_free (self->priv->pixmaps), NULL);
#line 102 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_g_object_unref0 (self->priv->_game);
#line 129 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	_g_free0 (self->priv->_theme);
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	G_OBJECT_CLASS (game_view_parent_class)->finalize (obj);
#line 5459 "game-view.c"
}


GType game_view_get_type (void) {
	static volatile gsize game_view_type_id__volatile = 0;
	if (g_once_init_enter (&game_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GameViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameView), 0, (GInstanceInitFunc) game_view_instance_init, NULL };
		GType game_view_type_id;
		game_view_type_id = g_type_register_static (gtk_drawing_area_get_type (), "GameView", &g_define_type_info, 0);
		g_once_init_leave (&game_view_type_id__volatile, game_view_type_id);
	}
	return game_view_type_id__volatile;
}


static void _vala_game_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_VIEW, GameView);
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	switch (property_id) {
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		case GAME_VIEW_SCOREBOARD:
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_value_set_object (value, game_view_get_scoreboard (self));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		break;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		case GAME_VIEW_SOUND_FLIP:
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_value_set_string (value, game_view_get_sound_flip (self));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		break;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		case GAME_VIEW_SOUND_GAMEOVER:
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_value_set_string (value, game_view_get_sound_gameover (self));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		break;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		case GAME_VIEW_GAME:
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_value_set_object (value, game_view_get_game (self));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		break;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		case GAME_VIEW_THEME:
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		g_value_set_string (value, game_view_get_theme (self));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		break;
#line 5510 "game-view.c"
		default:
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		break;
#line 5516 "game-view.c"
	}
}


static void _vala_game_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GameView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_VIEW, GameView);
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
	switch (property_id) {
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		case GAME_VIEW_SCOREBOARD:
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		game_view_set_scoreboard (self, g_value_get_object (value));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		break;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		case GAME_VIEW_SOUND_FLIP:
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		game_view_set_sound_flip (self, g_value_get_string (value));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		break;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		case GAME_VIEW_SOUND_GAMEOVER:
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		game_view_set_sound_gameover (self, g_value_get_string (value));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		break;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		case GAME_VIEW_GAME:
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		game_view_set_game (self, g_value_get_object (value));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		break;
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		case GAME_VIEW_THEME:
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		game_view_set_theme (self, g_value_get_string (value));
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		break;
#line 5556 "game-view.c"
		default:
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 21 "/run/media/triton/gobelin/jhbuild/jhbuild/iagno/src/game-view.vala"
		break;
#line 5562 "game-view.c"
	}
}



