/* rygel-media-art-store.c generated by valac 0.32.0, the Vala compiler
 * generated from rygel-media-art-store.vala, do not modify */

/*
 * Copyright (C) 2010-2014 Jens Georg <mail@jensge.org>.
 * Copyright (C) 2012 Intel Corporation.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <libmediaart/mediaart.h>
#include <stdlib.h>
#include <string.h>
#include <rygel-core.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define RYGEL_TYPE_MEDIA_ART_STORE (rygel_media_art_store_get_type ())
#define RYGEL_MEDIA_ART_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStore))
#define RYGEL_MEDIA_ART_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStoreClass))
#define RYGEL_IS_MEDIA_ART_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ART_STORE))
#define RYGEL_IS_MEDIA_ART_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ART_STORE))
#define RYGEL_MEDIA_ART_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStoreClass))

typedef struct _RygelMediaArtStore RygelMediaArtStore;
typedef struct _RygelMediaArtStoreClass RygelMediaArtStoreClass;
typedef struct _RygelMediaArtStorePrivate RygelMediaArtStorePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_MEDIA_FILE_ITEM (rygel_media_file_item_get_type ())
#define RYGEL_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItem))
#define RYGEL_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))
#define RYGEL_IS_MEDIA_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_IS_MEDIA_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_FILE_ITEM))
#define RYGEL_MEDIA_FILE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_FILE_ITEM, RygelMediaFileItemClass))

typedef struct _RygelMediaFileItem RygelMediaFileItem;
typedef struct _RygelMediaFileItemClass RygelMediaFileItemClass;

#define RYGEL_TYPE_AUDIO_ITEM (rygel_audio_item_get_type ())
#define RYGEL_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItem))
#define RYGEL_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))
#define RYGEL_IS_AUDIO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_IS_AUDIO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_AUDIO_ITEM))
#define RYGEL_AUDIO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_AUDIO_ITEM, RygelAudioItemClass))

typedef struct _RygelAudioItem RygelAudioItem;
typedef struct _RygelAudioItemClass RygelAudioItemClass;

#define RYGEL_TYPE_MUSIC_ITEM (rygel_music_item_get_type ())
#define RYGEL_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItem))
#define RYGEL_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))
#define RYGEL_IS_MUSIC_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_IS_MUSIC_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MUSIC_ITEM))
#define RYGEL_MUSIC_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MUSIC_ITEM, RygelMusicItemClass))

typedef struct _RygelMusicItem RygelMusicItem;
typedef struct _RygelMusicItemClass RygelMusicItemClass;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))

typedef enum  {
	MEDIA_ART_STORE_ERROR_NO_DIR,
	MEDIA_ART_STORE_ERROR_NO_MEDIA_ART
} MediaArtStoreError;
#define MEDIA_ART_STORE_ERROR media_art_store_error_quark ()
struct _RygelMediaArtStore {
	GObject parent_instance;
	RygelMediaArtStorePrivate * priv;
};

struct _RygelMediaArtStoreClass {
	GObjectClass parent_class;
};

struct _RygelMediaArtStorePrivate {
	MediaArtProcess* media_art_process;
};


static gpointer rygel_media_art_store_parent_class = NULL;
static RygelMediaArtStore* rygel_media_art_store_media_art_store;
static RygelMediaArtStore* rygel_media_art_store_media_art_store = NULL;
static gboolean rygel_media_art_store_first_time;
static gboolean rygel_media_art_store_first_time = TRUE;

GQuark media_art_store_error_quark (void);
GType rygel_media_art_store_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_ART_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStorePrivate))
enum  {
	RYGEL_MEDIA_ART_STORE_DUMMY_PROPERTY
};
RygelMediaArtStore* rygel_media_art_store_get_default (void);
static RygelMediaArtStore* rygel_media_art_store_new (GError** error);
static RygelMediaArtStore* rygel_media_art_store_construct (GType object_type, GError** error);
GType rygel_media_object_get_type (void) G_GNUC_CONST;
GType rygel_media_item_get_type (void) G_GNUC_CONST;
GType rygel_media_file_item_get_type (void) G_GNUC_CONST;
GType rygel_audio_item_get_type (void) G_GNUC_CONST;
GType rygel_music_item_get_type (void) G_GNUC_CONST;
GType rygel_thumbnail_get_type (void) G_GNUC_CONST;
RygelThumbnail* rygel_media_art_store_lookup_media_art (RygelMediaArtStore* self, RygelMusicItem* item, GError** error);
const gchar* rygel_audio_item_get_album (RygelAudioItem* self);
const gchar* rygel_media_object_get_artist (RygelMediaObject* self);
const gchar* rygel_media_object_get_title (RygelMediaObject* self);
RygelThumbnail* rygel_thumbnail_new (const gchar* mime_type, const gchar* dlna_profile, const gchar* file_extension);
RygelThumbnail* rygel_thumbnail_construct (GType object_type, const gchar* mime_type, const gchar* dlna_profile, const gchar* file_extension);
void rygel_media_art_store_add (RygelMediaArtStore* self, RygelMusicItem* item, GFile* file, guint8* data, int data_length1, const gchar* mime);
void rygel_media_art_store_search_media_art_for_file (RygelMediaArtStore* self, RygelMusicItem* item, GFile* file);
static void rygel_media_art_store_finalize (GObject* obj);

static const gchar* RYGEL_MEDIA_ART_STORE_types[6] = {"track", "album", "artist", "podcast", "radio", "video"};

GQuark media_art_store_error_quark (void) {
	return g_quark_from_static_string ("media_art_store_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


RygelMediaArtStore* rygel_media_art_store_get_default (void) {
	RygelMediaArtStore* result = NULL;
	gboolean _tmp0_ = FALSE;
	RygelMediaArtStore* _tmp6_ = NULL;
	RygelMediaArtStore* _tmp7_ = NULL;
	GError * _inner_error_ = NULL;
	_tmp0_ = rygel_media_art_store_first_time;
	if (_tmp0_) {
		{
			RygelMediaArtStore* _tmp1_ = NULL;
			RygelMediaArtStore* _tmp2_ = NULL;
			RygelMediaArtStore* _tmp3_ = NULL;
			media_art_plugin_init (128);
			_tmp2_ = rygel_media_art_store_new (&_inner_error_);
			_tmp1_ = _tmp2_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == MEDIA_ART_STORE_ERROR) {
					goto __catch0_media_art_store_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_tmp3_ = _tmp1_;
			_tmp1_ = NULL;
			_g_object_unref0 (rygel_media_art_store_media_art_store);
			rygel_media_art_store_media_art_store = _tmp3_;
			_g_object_unref0 (_tmp1_);
		}
		goto __finally0;
		__catch0_media_art_store_error:
		{
			GError* _error_ = NULL;
			GError* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			_tmp4_ = _error_;
			_tmp5_ = _tmp4_->message;
			g_warning ("rygel-media-art-store.vala:47: No media art available: %s", _tmp5_);
			_g_error_free0 (_error_);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	rygel_media_art_store_first_time = FALSE;
	_tmp6_ = rygel_media_art_store_media_art_store;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	result = _tmp7_;
	return result;
}


RygelThumbnail* rygel_media_art_store_lookup_media_art (RygelMediaArtStore* self, RygelMusicItem* item, GError** error) {
	RygelThumbnail* result = NULL;
	GFile* file = NULL;
	GFile* _tmp33_ = NULL;
	GFileInfo* info = NULL;
	GFile* _tmp34_ = NULL;
	GFileInfo* _tmp35_ = NULL;
	GFileInfo* _tmp36_ = NULL;
	gboolean _tmp37_ = FALSE;
	RygelThumbnail* thumb = NULL;
	RygelThumbnail* _tmp38_ = NULL;
	RygelThumbnail* _tmp39_ = NULL;
	GFile* _tmp40_ = NULL;
	gchar* _tmp41_ = NULL;
	RygelThumbnail* _tmp42_ = NULL;
	GFileInfo* _tmp43_ = NULL;
	gint64 _tmp44_ = 0LL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item != NULL, NULL);
	file = NULL;
	{
		const gchar** type_collection = NULL;
		gint type_collection_length1 = 0;
		gint _type_collection_size_ = 0;
		gint type_it = 0;
		type_collection = RYGEL_MEDIA_ART_STORE_types;
		type_collection_length1 = G_N_ELEMENTS (RYGEL_MEDIA_ART_STORE_types);
		for (type_it = 0; type_it < G_N_ELEMENTS (RYGEL_MEDIA_ART_STORE_types); type_it = type_it + 1) {
			const gchar* type = NULL;
			type = type_collection[type_it];
			{
				gboolean _tmp0_ = FALSE;
				gboolean _tmp1_ = FALSE;
				const gchar* _tmp2_ = NULL;
				const gchar* _tmp16_ = NULL;
				const gchar* _tmp17_ = NULL;
				RygelMusicItem* _tmp24_ = NULL;
				const gchar* _tmp25_ = NULL;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_ = NULL;
				GFile* _tmp28_ = NULL;
				gboolean _tmp29_ = FALSE;
				GFile* _tmp30_ = NULL;
				_tmp2_ = type;
				if (g_strcmp0 (_tmp2_, "album") == 0) {
					RygelMusicItem* _tmp3_ = NULL;
					const gchar* _tmp4_ = NULL;
					const gchar* _tmp5_ = NULL;
					_tmp3_ = item;
					_tmp4_ = rygel_audio_item_get_album ((RygelAudioItem*) _tmp3_);
					_tmp5_ = _tmp4_;
					_tmp1_ = _tmp5_ == NULL;
				} else {
					_tmp1_ = FALSE;
				}
				if (_tmp1_) {
					RygelMusicItem* _tmp6_ = NULL;
					const gchar* _tmp7_ = NULL;
					const gchar* _tmp8_ = NULL;
					_tmp6_ = item;
					_tmp7_ = rygel_media_object_get_artist ((RygelMediaObject*) _tmp6_);
					_tmp8_ = _tmp7_;
					_tmp0_ = _tmp8_ == NULL;
				} else {
					_tmp0_ = FALSE;
				}
				if (_tmp0_) {
					continue;
				} else {
					gboolean _tmp9_ = FALSE;
					RygelMusicItem* _tmp10_ = NULL;
					const gchar* _tmp11_ = NULL;
					const gchar* _tmp12_ = NULL;
					_tmp10_ = item;
					_tmp11_ = rygel_media_object_get_artist ((RygelMediaObject*) _tmp10_);
					_tmp12_ = _tmp11_;
					if (_tmp12_ == NULL) {
						RygelMusicItem* _tmp13_ = NULL;
						const gchar* _tmp14_ = NULL;
						const gchar* _tmp15_ = NULL;
						_tmp13_ = item;
						_tmp14_ = rygel_media_object_get_title ((RygelMediaObject*) _tmp13_);
						_tmp15_ = _tmp14_;
						_tmp9_ = _tmp15_ == NULL;
					} else {
						_tmp9_ = FALSE;
					}
					if (_tmp9_) {
						continue;
					}
				}
				_tmp17_ = type;
				if (g_strcmp0 (_tmp17_, "album") == 0) {
					RygelMusicItem* _tmp18_ = NULL;
					const gchar* _tmp19_ = NULL;
					const gchar* _tmp20_ = NULL;
					_tmp18_ = item;
					_tmp19_ = rygel_audio_item_get_album ((RygelAudioItem*) _tmp18_);
					_tmp20_ = _tmp19_;
					_tmp16_ = _tmp20_;
				} else {
					RygelMusicItem* _tmp21_ = NULL;
					const gchar* _tmp22_ = NULL;
					const gchar* _tmp23_ = NULL;
					_tmp21_ = item;
					_tmp22_ = rygel_media_object_get_title ((RygelMediaObject*) _tmp21_);
					_tmp23_ = _tmp22_;
					_tmp16_ = _tmp23_;
				}
				_tmp24_ = item;
				_tmp25_ = rygel_media_object_get_artist ((RygelMediaObject*) _tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = type;
				media_art_get_file (_tmp26_, _tmp16_, _tmp27_, &_tmp28_);
				_g_object_unref0 (file);
				file = _tmp28_;
				_tmp30_ = file;
				if (_tmp30_ != NULL) {
					GFile* _tmp31_ = NULL;
					gboolean _tmp32_ = FALSE;
					_tmp31_ = file;
					_tmp32_ = g_file_query_exists (_tmp31_, NULL);
					_tmp29_ = _tmp32_;
				} else {
					_tmp29_ = FALSE;
				}
				if (_tmp29_) {
					break;
				} else {
					_g_object_unref0 (file);
					file = NULL;
				}
			}
		}
	}
	_tmp33_ = file;
	if (_tmp33_ == NULL) {
		result = NULL;
		_g_object_unref0 (file);
		return result;
	}
	_tmp34_ = file;
	_tmp35_ = g_file_query_info (_tmp34_, G_FILE_ATTRIBUTE_ACCESS_CAN_READ "," G_FILE_ATTRIBUTE_STANDARD_SIZE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
	info = _tmp35_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp36_ = info;
	_tmp37_ = g_file_info_get_attribute_boolean (_tmp36_, G_FILE_ATTRIBUTE_ACCESS_CAN_READ);
	if (!_tmp37_) {
		result = NULL;
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		return result;
	}
	_tmp38_ = rygel_thumbnail_new ("image/jpeg", "JPEG_TN", "jpg");
	thumb = _tmp38_;
	_tmp39_ = thumb;
	_tmp40_ = file;
	_tmp41_ = g_file_get_uri (_tmp40_);
	_g_free0 (((RygelIconInfo*) _tmp39_)->uri);
	((RygelIconInfo*) _tmp39_)->uri = _tmp41_;
	_tmp42_ = thumb;
	_tmp43_ = info;
	_tmp44_ = g_file_info_get_size (_tmp43_);
	((RygelIconInfo*) _tmp42_)->size = (gint64) _tmp44_;
	result = thumb;
	_g_object_unref0 (info);
	_g_object_unref0 (file);
	return result;
}


void rygel_media_art_store_add (RygelMediaArtStore* self, RygelMusicItem* item, GFile* file, guint8* data, int data_length1, const gchar* mime) {
	MediaArtProcess* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (mime != NULL);
	_tmp0_ = self->priv->media_art_process;
	if (_tmp0_ == NULL) {
		return;
	}
	{
		MediaArtProcess* _tmp1_ = NULL;
		GFile* _tmp2_ = NULL;
		guint8* _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
		const gchar* _tmp4_ = NULL;
		RygelMusicItem* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		RygelMusicItem* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		_tmp1_ = self->priv->media_art_process;
		_tmp2_ = file;
		_tmp3_ = data;
		_tmp3__length1 = data_length1;
		_tmp4_ = mime;
		_tmp5_ = item;
		_tmp6_ = rygel_media_object_get_artist ((RygelMediaObject*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = item;
		_tmp9_ = rygel_audio_item_get_album ((RygelAudioItem*) _tmp8_);
		_tmp10_ = _tmp9_;
		media_art_process_buffer (_tmp1_, MEDIA_ART_ALBUM, MEDIA_ART_PROCESS_FLAGS_NONE, _tmp2_, _tmp3_, (gsize) _tmp3__length1, _tmp4_, _tmp7_, _tmp10_, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp11_ = NULL;
		GFile* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
		GError* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = _ ("Failed to add album art for %s: %s");
		_tmp12_ = file;
		_tmp13_ = g_file_get_uri (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = _error_;
		_tmp16_ = _tmp15_->message;
		g_warning (_tmp11_, _tmp14_, _tmp16_);
		_g_free0 (_tmp14_);
		_g_error_free0 (_error_);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void rygel_media_art_store_search_media_art_for_file (RygelMediaArtStore* self, RygelMusicItem* item, GFile* file) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	g_return_if_fail (file != NULL);
	{
		MediaArtProcess* _tmp0_ = NULL;
		GFile* _tmp1_ = NULL;
		RygelMusicItem* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		RygelMusicItem* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		_tmp0_ = self->priv->media_art_process;
		_tmp1_ = file;
		_tmp2_ = item;
		_tmp3_ = rygel_media_object_get_artist ((RygelMediaObject*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = item;
		_tmp6_ = rygel_audio_item_get_album ((RygelAudioItem*) _tmp5_);
		_tmp7_ = _tmp6_;
		media_art_process_file (_tmp0_, MEDIA_ART_ALBUM, MEDIA_ART_PROCESS_FLAGS_NONE, _tmp1_, _tmp4_, _tmp7_, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* _error_ = NULL;
		const gchar* _tmp8_ = NULL;
		GFile* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		GError* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = _ ("Failed to find media art for %s: %s");
		_tmp9_ = file;
		_tmp10_ = g_file_get_uri (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = _error_;
		_tmp13_ = _tmp12_->message;
		g_warning (_tmp8_, _tmp11_, _tmp13_);
		_g_free0 (_tmp11_);
		_g_error_free0 (_error_);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static RygelMediaArtStore* rygel_media_art_store_construct (GType object_type, GError** error) {
	RygelMediaArtStore * self = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelMediaArtStore*) g_object_new (object_type, NULL);
	{
		MediaArtProcess* _tmp0_ = NULL;
		MediaArtProcess* _tmp1_ = NULL;
		MediaArtProcess* _tmp2_ = NULL;
		_tmp1_ = media_art_process_new (&_inner_error_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch3_g_error;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->media_art_process);
		self->priv->media_art_process = _tmp2_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_object_unref0 (self->priv->media_art_process);
		self->priv->media_art_process = NULL;
		_tmp3_ = _error_;
		_tmp4_ = _tmp3_->message;
		_tmp5_ = g_error_new (MEDIA_ART_STORE_ERROR, MEDIA_ART_STORE_ERROR_NO_MEDIA_ART, "%s", _tmp4_);
		_inner_error_ = _tmp5_;
		_g_error_free0 (_error_);
		goto __finally3;
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == MEDIA_ART_STORE_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	return self;
}


static RygelMediaArtStore* rygel_media_art_store_new (GError** error) {
	return rygel_media_art_store_construct (RYGEL_TYPE_MEDIA_ART_STORE, error);
}


static void rygel_media_art_store_class_init (RygelMediaArtStoreClass * klass) {
	rygel_media_art_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaArtStorePrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_media_art_store_finalize;
}


static void rygel_media_art_store_instance_init (RygelMediaArtStore * self) {
	self->priv = RYGEL_MEDIA_ART_STORE_GET_PRIVATE (self);
}


static void rygel_media_art_store_finalize (GObject* obj) {
	RygelMediaArtStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, RYGEL_TYPE_MEDIA_ART_STORE, RygelMediaArtStore);
	_g_object_unref0 (self->priv->media_art_process);
	G_OBJECT_CLASS (rygel_media_art_store_parent_class)->finalize (obj);
}


/**
 * This maps RygelMusicItem objects to their cached cover art,
 * implementing the GNOME
 * [[https://live.gnome.org/MediaArtStorageSpec|MediaArt storage specification]].
 */
GType rygel_media_art_store_get_type (void) {
	static volatile gsize rygel_media_art_store_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_art_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaArtStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_art_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaArtStore), 0, (GInstanceInitFunc) rygel_media_art_store_instance_init, NULL };
		GType rygel_media_art_store_type_id;
		rygel_media_art_store_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaArtStore", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_art_store_type_id__volatile, rygel_media_art_store_type_id);
	}
	return rygel_media_art_store_type_id__volatile;
}



