/* game.c generated by valac 0.32.0.1-80f0, the Vala compiler
 * generated from game.vala, do not modify */

/*
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <math.h>
#include <float.h>
#include <string.h>


#define TYPE_BLOCK (block_get_type ())
#define BLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BLOCK, Block))
#define BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BLOCK, BlockClass))
#define IS_BLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BLOCK))
#define IS_BLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BLOCK))
#define BLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BLOCK, BlockClass))

typedef struct _Block Block;
typedef struct _BlockClass BlockClass;
typedef struct _BlockPrivate BlockPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_SHAPE (shape_get_type ())
#define SHAPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SHAPE, Shape))
#define SHAPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SHAPE, ShapeClass))
#define IS_SHAPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SHAPE))
#define IS_SHAPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SHAPE))
#define SHAPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SHAPE, ShapeClass))

typedef struct _Shape Shape;
typedef struct _ShapeClass ShapeClass;
typedef struct _ShapePrivate ShapePrivate;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define TYPE_GAME (game_get_type ())
#define GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME, Game))
#define GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME, GameClass))
#define IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME))
#define IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME))
#define GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME, GameClass))

typedef struct _Game Game;
typedef struct _GameClass GameClass;
typedef struct _GamePrivate GamePrivate;

struct _Block {
	GObject parent_instance;
	BlockPrivate * priv;
	gint x;
	gint y;
	gint color;
};

struct _BlockClass {
	GObjectClass parent_class;
};

struct _Shape {
	GObject parent_instance;
	ShapePrivate * priv;
	gint x;
	gint y;
	gint rotation;
	gint type;
	GList* blocks;
};

struct _ShapeClass {
	GObjectClass parent_class;
};

struct _Game {
	GObject parent_instance;
	GamePrivate * priv;
	Shape* shape;
	Shape* next_shape;
	Block** blocks;
	gint blocks_length1;
	gint blocks_length2;
	gint n_lines_destroyed;
	gint score;
	gboolean game_over;
};

struct _GameClass {
	GObjectClass parent_class;
};

struct _GamePrivate {
	gint starting_level;
	gboolean pick_difficult_blocks;
	gboolean fast_forward;
	guint drop_timeout;
	gboolean has_started;
	gboolean _paused;
};


static gpointer block_parent_class = NULL;
static gpointer shape_parent_class = NULL;
static gpointer game_parent_class = NULL;

#define NCOLORS 7
GType block_get_type (void) G_GNUC_CONST;
enum  {
	BLOCK_DUMMY_PROPERTY
};
Block* block_copy (Block* self);
Block* block_new (void);
Block* block_construct (GType object_type);
static void block_finalize (GObject* obj);
GType shape_get_type (void) G_GNUC_CONST;
enum  {
	SHAPE_DUMMY_PROPERTY
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
Shape* shape_copy (Shape* self);
Shape* shape_new (void);
Shape* shape_construct (GType object_type);
static void shape_finalize (GObject* obj);
GType game_get_type (void) G_GNUC_CONST;
#define GAME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GAME, GamePrivate))
enum  {
	GAME_DUMMY_PROPERTY,
	GAME_WIDTH,
	GAME_HEIGHT,
	GAME_LEVEL,
	GAME_PAUSED,
	GAME_SHADOW_Y
};
Game* game_new (gint lines, gint columns, gint starting_level, gint filled_lines, gint fill_prob, gboolean pick_difficult_blocks);
Game* game_construct (GType object_type, gint lines, gint columns, gint starting_level, gint filled_lines, gint fill_prob, gboolean pick_difficult_blocks);
gint game_get_height (Game* self);
gint game_get_width (Game* self);
static Shape* game_pick_random_shape (Game* self);
Game* game_copy (Game* self);
void game_start (Game* self);
static void game_add_shape (Game* self);
static void game_setup_drop_timer (Game* self);
gboolean game_move_left (Game* self);
static gboolean game_move_shape (Game* self, gint x_step, gint y_step, gint r_step);
gboolean game_move_right (Game* self);
gboolean game_rotate_left (Game* self);
gboolean game_rotate_right (Game* self);
void game_set_fast_forward (Game* self, gboolean enable);
void game_drop (Game* self);
static gboolean game_fall_timeout_cb (Game* self);
void game_stop (Game* self);
gint game_get_level (Game* self);
gboolean game_get_paused (Game* self);
static gboolean _game_fall_timeout_cb_gsource_func (gpointer self);
static void game_land_shape (Game* self);
static Shape* game_pick_difficult_shape (Game* self);
static Shape* game_make_shape (Game* self, gint type, gint rotation);
static void game_rotate_shape (Game* self, gint r_step);
void game_set_paused (Game* self, gboolean value);
gint game_get_shadow_y (Game* self);
static void g_cclosure_user_marshal_VOID__POINTER_INT_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void game_finalize (GObject* obj);
static void _vala_game_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_game_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

const gint block_table[448] = {0, 0, 0, 0, 1, 1, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 1, 1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1, 0, 0, 0, 0, 0};

Block* block_copy (Block* self) {
	Block* result = NULL;
	Block* b = NULL;
	Block* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = block_new ();
	b = _tmp0_;
	_tmp1_ = self->x;
	b->x = _tmp1_;
	_tmp2_ = self->y;
	b->y = _tmp2_;
	_tmp3_ = self->color;
	b->color = _tmp3_;
	result = b;
	return result;
}


Block* block_construct (GType object_type) {
	Block * self = NULL;
	self = (Block*) g_object_new (object_type, NULL);
	return self;
}


Block* block_new (void) {
	return block_construct (TYPE_BLOCK);
}


static void block_class_init (BlockClass * klass) {
	block_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = block_finalize;
}


static void block_instance_init (Block * self) {
}


static void block_finalize (GObject* obj) {
	Block * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BLOCK, Block);
	G_OBJECT_CLASS (block_parent_class)->finalize (obj);
}


GType block_get_type (void) {
	static volatile gsize block_type_id__volatile = 0;
	if (g_once_init_enter (&block_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BlockClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) block_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Block), 0, (GInstanceInitFunc) block_instance_init, NULL };
		GType block_type_id;
		block_type_id = g_type_register_static (G_TYPE_OBJECT, "Block", &g_define_type_info, 0);
		g_once_init_leave (&block_type_id__volatile, block_type_id);
	}
	return block_type_id__volatile;
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


Shape* shape_copy (Shape* self) {
	Shape* result = NULL;
	Shape* s = NULL;
	Shape* _tmp0_ = NULL;
	Shape* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	Shape* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	Shape* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	Shape* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	GList* _tmp9_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = shape_new ();
	s = _tmp0_;
	_tmp1_ = s;
	_tmp2_ = self->x;
	_tmp1_->x = _tmp2_;
	_tmp3_ = s;
	_tmp4_ = self->y;
	_tmp3_->y = _tmp4_;
	_tmp5_ = s;
	_tmp6_ = self->rotation;
	_tmp5_->rotation = _tmp6_;
	_tmp7_ = s;
	_tmp8_ = self->type;
	_tmp7_->type = _tmp8_;
	_tmp9_ = self->blocks;
	{
		GList* b_collection = NULL;
		GList* b_it = NULL;
		b_collection = _tmp9_;
		for (b_it = b_collection; b_it != NULL; b_it = b_it->next) {
			Block* _tmp10_ = NULL;
			Block* b = NULL;
			_tmp10_ = _g_object_ref0 ((Block*) b_it->data);
			b = _tmp10_;
			{
				Shape* _tmp11_ = NULL;
				Block* _tmp12_ = NULL;
				Block* _tmp13_ = NULL;
				_tmp11_ = s;
				_tmp12_ = b;
				_tmp13_ = block_copy (_tmp12_);
				_tmp11_->blocks = g_list_append (_tmp11_->blocks, _tmp13_);
				_g_object_unref0 (b);
			}
		}
	}
	result = s;
	return result;
}


Shape* shape_construct (GType object_type) {
	Shape * self = NULL;
	self = (Shape*) g_object_new (object_type, NULL);
	return self;
}


Shape* shape_new (void) {
	return shape_construct (TYPE_SHAPE);
}


static void shape_class_init (ShapeClass * klass) {
	shape_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = shape_finalize;
}


static void shape_instance_init (Shape * self) {
	self->blocks = NULL;
}


static void shape_finalize (GObject* obj) {
	Shape * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SHAPE, Shape);
	__g_list_free__g_object_unref0_0 (self->blocks);
	G_OBJECT_CLASS (shape_parent_class)->finalize (obj);
}


GType shape_get_type (void) {
	static volatile gsize shape_type_id__volatile = 0;
	if (g_once_init_enter (&shape_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ShapeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) shape_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Shape), 0, (GInstanceInitFunc) shape_instance_init, NULL };
		GType shape_type_id;
		shape_type_id = g_type_register_static (G_TYPE_OBJECT, "Shape", &g_define_type_info, 0);
		g_once_init_leave (&shape_type_id__volatile, shape_type_id);
	}
	return shape_type_id__volatile;
}


Game* game_construct (GType object_type, gint lines, gint columns, gint starting_level, gint filled_lines, gint fill_prob, gboolean pick_difficult_blocks) {
	Game * self = NULL;
	gint _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	Block** _tmp4_ = NULL;
	gboolean _tmp52_ = FALSE;
	self = (Game*) g_object_new (object_type, NULL);
	_tmp0_ = starting_level;
	self->priv->starting_level = _tmp0_;
	_tmp1_ = pick_difficult_blocks;
	self->priv->pick_difficult_blocks = _tmp1_;
	_tmp2_ = columns;
	_tmp3_ = lines;
	_tmp4_ = g_new0 (Block*, (_tmp2_ * _tmp3_) + 1);
	self->blocks = (_vala_array_free (self->blocks, self->blocks_length1 * self->blocks_length2, (GDestroyNotify) g_object_unref), NULL);
	self->blocks = _tmp4_;
	self->blocks_length1 = _tmp2_;
	self->blocks_length2 = _tmp3_;
	{
		gint y = 0;
		y = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
				gint32 blank = 0;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				gint32 _tmp12_ = 0;
				if (!_tmp5_) {
					gint _tmp6_ = 0;
					_tmp6_ = y;
					y = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = y;
				_tmp8_ = game_get_height (self);
				_tmp9_ = _tmp8_;
				if (!(_tmp7_ < _tmp9_)) {
					break;
				}
				_tmp10_ = game_get_width (self);
				_tmp11_ = _tmp10_;
				_tmp12_ = g_random_int_range ((gint32) 0, (gint32) _tmp11_);
				blank = _tmp12_;
				{
					gint x = 0;
					x = 0;
					{
						gboolean _tmp13_ = FALSE;
						_tmp13_ = TRUE;
						while (TRUE) {
							gint _tmp15_ = 0;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							gboolean _tmp18_ = FALSE;
							gboolean _tmp19_ = FALSE;
							gint _tmp20_ = 0;
							gint _tmp21_ = 0;
							gint _tmp22_ = 0;
							gint _tmp23_ = 0;
							if (!_tmp13_) {
								gint _tmp14_ = 0;
								_tmp14_ = x;
								x = _tmp14_ + 1;
							}
							_tmp13_ = FALSE;
							_tmp15_ = x;
							_tmp16_ = game_get_width (self);
							_tmp17_ = _tmp16_;
							if (!(_tmp15_ < _tmp17_)) {
								break;
							}
							_tmp20_ = y;
							_tmp21_ = game_get_height (self);
							_tmp22_ = _tmp21_;
							_tmp23_ = filled_lines;
							if (_tmp20_ >= (_tmp22_ - _tmp23_)) {
								gint _tmp24_ = 0;
								gint32 _tmp25_ = 0;
								_tmp24_ = x;
								_tmp25_ = blank;
								_tmp19_ = _tmp24_ != ((gint) _tmp25_);
							} else {
								_tmp19_ = FALSE;
							}
							if (_tmp19_) {
								gint32 _tmp26_ = 0;
								gint _tmp27_ = 0;
								_tmp26_ = g_random_int_range ((gint32) 0, (gint32) 10);
								_tmp27_ = fill_prob;
								_tmp18_ = _tmp26_ < ((gint32) _tmp27_);
							} else {
								_tmp18_ = FALSE;
							}
							if (_tmp18_) {
								Block** _tmp28_ = NULL;
								gint _tmp28__length1 = 0;
								gint _tmp28__length2 = 0;
								gint _tmp29_ = 0;
								gint _tmp30_ = 0;
								Block* _tmp31_ = NULL;
								Block* _tmp32_ = NULL;
								Block** _tmp33_ = NULL;
								gint _tmp33__length1 = 0;
								gint _tmp33__length2 = 0;
								gint _tmp34_ = 0;
								gint _tmp35_ = 0;
								Block* _tmp36_ = NULL;
								gint _tmp37_ = 0;
								Block** _tmp38_ = NULL;
								gint _tmp38__length1 = 0;
								gint _tmp38__length2 = 0;
								gint _tmp39_ = 0;
								gint _tmp40_ = 0;
								Block* _tmp41_ = NULL;
								gint _tmp42_ = 0;
								Block** _tmp43_ = NULL;
								gint _tmp43__length1 = 0;
								gint _tmp43__length2 = 0;
								gint _tmp44_ = 0;
								gint _tmp45_ = 0;
								Block* _tmp46_ = NULL;
								gint32 _tmp47_ = 0;
								_tmp28_ = self->blocks;
								_tmp28__length1 = self->blocks_length1;
								_tmp28__length2 = self->blocks_length2;
								_tmp29_ = x;
								_tmp30_ = y;
								_tmp31_ = block_new ();
								_g_object_unref0 (_tmp28_[(_tmp29_ * _tmp28__length2) + _tmp30_]);
								_tmp28_[(_tmp29_ * _tmp28__length2) + _tmp30_] = _tmp31_;
								_tmp32_ = _tmp28_[(_tmp29_ * _tmp28__length2) + _tmp30_];
								_tmp33_ = self->blocks;
								_tmp33__length1 = self->blocks_length1;
								_tmp33__length2 = self->blocks_length2;
								_tmp34_ = x;
								_tmp35_ = y;
								_tmp36_ = _tmp33_[(_tmp34_ * _tmp33__length2) + _tmp35_];
								_tmp37_ = x;
								_tmp36_->x = _tmp37_;
								_tmp38_ = self->blocks;
								_tmp38__length1 = self->blocks_length1;
								_tmp38__length2 = self->blocks_length2;
								_tmp39_ = x;
								_tmp40_ = y;
								_tmp41_ = _tmp38_[(_tmp39_ * _tmp38__length2) + _tmp40_];
								_tmp42_ = y;
								_tmp41_->y = _tmp42_;
								_tmp43_ = self->blocks;
								_tmp43__length1 = self->blocks_length1;
								_tmp43__length2 = self->blocks_length2;
								_tmp44_ = x;
								_tmp45_ = y;
								_tmp46_ = _tmp43_[(_tmp44_ * _tmp43__length2) + _tmp45_];
								_tmp47_ = g_random_int_range ((gint32) 0, (gint32) NCOLORS);
								_tmp46_->color = (gint) _tmp47_;
							} else {
								Block** _tmp48_ = NULL;
								gint _tmp48__length1 = 0;
								gint _tmp48__length2 = 0;
								gint _tmp49_ = 0;
								gint _tmp50_ = 0;
								Block* _tmp51_ = NULL;
								_tmp48_ = self->blocks;
								_tmp48__length1 = self->blocks_length1;
								_tmp48__length2 = self->blocks_length2;
								_tmp49_ = x;
								_tmp50_ = y;
								_g_object_unref0 (_tmp48_[(_tmp49_ * _tmp48__length2) + _tmp50_]);
								_tmp48_[(_tmp49_ * _tmp48__length2) + _tmp50_] = NULL;
								_tmp51_ = _tmp48_[(_tmp49_ * _tmp48__length2) + _tmp50_];
							}
						}
					}
				}
			}
		}
	}
	_tmp52_ = pick_difficult_blocks;
	if (!_tmp52_) {
		Shape* _tmp53_ = NULL;
		_tmp53_ = game_pick_random_shape (self);
		_g_object_unref0 (self->next_shape);
		self->next_shape = _tmp53_;
	}
	return self;
}


Game* game_new (gint lines, gint columns, gint starting_level, gint filled_lines, gint fill_prob, gboolean pick_difficult_blocks) {
	return game_construct (TYPE_GAME, lines, columns, starting_level, filled_lines, fill_prob, pick_difficult_blocks);
}


Game* game_copy (Game* self) {
	Game* result = NULL;
	Game* g = NULL;
	Game* _tmp0_ = NULL;
	Shape* _tmp1_ = NULL;
	Shape* _tmp5_ = NULL;
	Game* _tmp33_ = NULL;
	gint _tmp34_ = 0;
	Game* _tmp35_ = NULL;
	gint _tmp36_ = 0;
	Game* _tmp37_ = NULL;
	gint _tmp38_ = 0;
	Game* _tmp39_ = NULL;
	gboolean _tmp40_ = FALSE;
	Game* _tmp41_ = NULL;
	gboolean _tmp42_ = FALSE;
	Game* _tmp43_ = NULL;
	gboolean _tmp44_ = FALSE;
	Game* _tmp45_ = NULL;
	gboolean _tmp46_ = FALSE;
	Game* _tmp47_ = NULL;
	gboolean _tmp48_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = game_new (20, 14, 1, 0, 5, FALSE);
	g = _tmp0_;
	_tmp1_ = self->shape;
	if (_tmp1_ != NULL) {
		Game* _tmp2_ = NULL;
		Shape* _tmp3_ = NULL;
		Shape* _tmp4_ = NULL;
		_tmp2_ = g;
		_tmp3_ = self->shape;
		_tmp4_ = shape_copy (_tmp3_);
		_g_object_unref0 (_tmp2_->shape);
		_tmp2_->shape = _tmp4_;
	}
	_tmp5_ = self->next_shape;
	if (_tmp5_ != NULL) {
		Game* _tmp6_ = NULL;
		Shape* _tmp7_ = NULL;
		Shape* _tmp8_ = NULL;
		_tmp6_ = g;
		_tmp7_ = self->next_shape;
		_tmp8_ = shape_copy (_tmp7_);
		_g_object_unref0 (_tmp6_->next_shape);
		_tmp6_->next_shape = _tmp8_;
	}
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
				gint _tmp13_ = 0;
				if (!_tmp9_) {
					gint _tmp10_ = 0;
					_tmp10_ = x;
					x = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp11_ = x;
				_tmp12_ = game_get_width (self);
				_tmp13_ = _tmp12_;
				if (!(_tmp11_ < _tmp13_)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp14_ = FALSE;
						_tmp14_ = TRUE;
						while (TRUE) {
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							gint _tmp18_ = 0;
							Block** _tmp19_ = NULL;
							gint _tmp19__length1 = 0;
							gint _tmp19__length2 = 0;
							gint _tmp20_ = 0;
							gint _tmp21_ = 0;
							Block* _tmp22_ = NULL;
							if (!_tmp14_) {
								gint _tmp15_ = 0;
								_tmp15_ = y;
								y = _tmp15_ + 1;
							}
							_tmp14_ = FALSE;
							_tmp16_ = y;
							_tmp17_ = game_get_height (self);
							_tmp18_ = _tmp17_;
							if (!(_tmp16_ < _tmp18_)) {
								break;
							}
							_tmp19_ = self->blocks;
							_tmp19__length1 = self->blocks_length1;
							_tmp19__length2 = self->blocks_length2;
							_tmp20_ = x;
							_tmp21_ = y;
							_tmp22_ = _tmp19_[(_tmp20_ * _tmp19__length2) + _tmp21_];
							if (_tmp22_ != NULL) {
								Game* _tmp23_ = NULL;
								Block** _tmp24_ = NULL;
								gint _tmp24__length1 = 0;
								gint _tmp24__length2 = 0;
								gint _tmp25_ = 0;
								gint _tmp26_ = 0;
								Block** _tmp27_ = NULL;
								gint _tmp27__length1 = 0;
								gint _tmp27__length2 = 0;
								gint _tmp28_ = 0;
								gint _tmp29_ = 0;
								Block* _tmp30_ = NULL;
								Block* _tmp31_ = NULL;
								Block* _tmp32_ = NULL;
								_tmp23_ = g;
								_tmp24_ = _tmp23_->blocks;
								_tmp24__length1 = _tmp23_->blocks_length1;
								_tmp24__length2 = _tmp23_->blocks_length2;
								_tmp25_ = x;
								_tmp26_ = y;
								_tmp27_ = self->blocks;
								_tmp27__length1 = self->blocks_length1;
								_tmp27__length2 = self->blocks_length2;
								_tmp28_ = x;
								_tmp29_ = y;
								_tmp30_ = _tmp27_[(_tmp28_ * _tmp27__length2) + _tmp29_];
								_tmp31_ = block_copy (_tmp30_);
								_g_object_unref0 (_tmp24_[(_tmp25_ * _tmp24__length2) + _tmp26_]);
								_tmp24_[(_tmp25_ * _tmp24__length2) + _tmp26_] = _tmp31_;
								_tmp32_ = _tmp24_[(_tmp25_ * _tmp24__length2) + _tmp26_];
							}
						}
					}
				}
			}
		}
	}
	_tmp33_ = g;
	_tmp34_ = self->n_lines_destroyed;
	_tmp33_->n_lines_destroyed = _tmp34_;
	_tmp35_ = g;
	_tmp36_ = self->score;
	_tmp35_->score = _tmp36_;
	_tmp37_ = g;
	_tmp38_ = self->priv->starting_level;
	_tmp37_->priv->starting_level = _tmp38_;
	_tmp39_ = g;
	_tmp40_ = self->priv->pick_difficult_blocks;
	_tmp39_->priv->pick_difficult_blocks = _tmp40_;
	_tmp41_ = g;
	_tmp42_ = self->priv->fast_forward;
	_tmp41_->priv->fast_forward = _tmp42_;
	_tmp43_ = g;
	_tmp44_ = self->priv->has_started;
	_tmp43_->priv->has_started = _tmp44_;
	_tmp45_ = g;
	_tmp46_ = self->priv->_paused;
	_tmp45_->priv->_paused = _tmp46_;
	_tmp47_ = g;
	_tmp48_ = self->game_over;
	_tmp47_->game_over = _tmp48_;
	result = g;
	return result;
}


void game_start (Game* self) {
	g_return_if_fail (self != NULL);
	self->priv->has_started = TRUE;
	game_add_shape (self);
	game_setup_drop_timer (self);
	g_signal_emit_by_name (self, "started");
	g_signal_emit_by_name (self, "pause-changed");
}


gboolean game_move_left (Game* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = game_move_shape (self, -1, 0, 0);
	result = _tmp0_;
	return result;
}


gboolean game_move_right (Game* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = game_move_shape (self, 1, 0, 0);
	result = _tmp0_;
	return result;
}


gboolean game_rotate_left (Game* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = game_move_shape (self, 0, 0, -1);
	result = _tmp0_;
	return result;
}


gboolean game_rotate_right (Game* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = game_move_shape (self, 0, 0, 1);
	result = _tmp0_;
	return result;
}


void game_set_fast_forward (Game* self, gboolean enable) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp6_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->fast_forward;
	_tmp2_ = enable;
	if (_tmp1_ == _tmp2_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp3_ = FALSE;
		_tmp3_ = self->game_over;
		_tmp0_ = _tmp3_;
	}
	if (_tmp0_) {
		return;
	}
	_tmp4_ = enable;
	if (_tmp4_) {
		gboolean _tmp5_ = FALSE;
		_tmp5_ = game_move_shape (self, 0, 1, 0);
		if (!_tmp5_) {
			return;
		}
	}
	_tmp6_ = enable;
	self->priv->fast_forward = _tmp6_;
	game_setup_drop_timer (self);
}


void game_drop (Game* self) {
	Shape* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->shape;
	if (_tmp0_ == NULL) {
		return;
	}
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		_tmp1_ = game_move_shape (self, 0, 1, 0);
		if (!_tmp1_) {
			break;
		}
	}
	game_fall_timeout_cb (self);
}


void game_stop (Game* self) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->drop_timeout;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = self->priv->drop_timeout;
		g_source_remove (_tmp1_);
	}
}


static gboolean _game_fall_timeout_cb_gsource_func (gpointer self) {
	gboolean result;
	result = game_fall_timeout_cb ((Game*) self);
	return result;
}


static void game_setup_drop_timer (Game* self) {
	gint timestep = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	guint _tmp7_ = 0U;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = game_get_level (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = pow (0.75, (gdouble) (_tmp1_ - 1));
	_tmp3_ = round (80 + (800.0 * _tmp2_));
	timestep = (gint) _tmp3_;
	_tmp4_ = timestep;
	_tmp5_ = MAX (10, _tmp4_);
	timestep = _tmp5_;
	_tmp6_ = self->priv->fast_forward;
	if (_tmp6_) {
		timestep = 80;
	}
	_tmp7_ = self->priv->drop_timeout;
	if (_tmp7_ != ((guint) 0)) {
		guint _tmp8_ = 0U;
		_tmp8_ = self->priv->drop_timeout;
		g_source_remove (_tmp8_);
	}
	self->priv->drop_timeout = (guint) 0;
	_tmp9_ = game_get_paused (self);
	_tmp10_ = _tmp9_;
	if (!_tmp10_) {
		gint _tmp11_ = 0;
		guint _tmp12_ = 0U;
		_tmp11_ = timestep;
		_tmp12_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) _tmp11_, _game_fall_timeout_cb_gsource_func, g_object_ref (self), g_object_unref);
		self->priv->drop_timeout = _tmp12_;
	}
}


static gboolean game_fall_timeout_cb (Game* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = game_move_shape (self, 0, 1, 0);
	if (!_tmp0_) {
		game_land_shape (self);
		game_add_shape (self);
	}
	result = TRUE;
	return result;
}


static void game_add_shape (Game* self) {
	gboolean _tmp0_ = FALSE;
	Shape* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pick_difficult_blocks;
	if (_tmp0_) {
		Shape* _tmp1_ = NULL;
		_tmp1_ = game_pick_difficult_shape (self);
		_g_object_unref0 (self->shape);
		self->shape = _tmp1_;
	} else {
		Shape* _tmp2_ = NULL;
		Shape* _tmp3_ = NULL;
		_tmp2_ = self->next_shape;
		self->next_shape = NULL;
		_g_object_unref0 (self->shape);
		self->shape = _tmp2_;
		_tmp3_ = game_pick_random_shape (self);
		_g_object_unref0 (self->next_shape);
		self->next_shape = _tmp3_;
	}
	_tmp4_ = self->shape;
	_tmp5_ = _tmp4_->blocks;
	{
		GList* b_collection = NULL;
		GList* b_it = NULL;
		b_collection = _tmp5_;
		for (b_it = b_collection; b_it != NULL; b_it = b_it->next) {
			Block* _tmp6_ = NULL;
			Block* b = NULL;
			_tmp6_ = _g_object_ref0 ((Block*) b_it->data);
			b = _tmp6_;
			{
				gint x = 0;
				Shape* _tmp7_ = NULL;
				gint _tmp8_ = 0;
				Block* _tmp9_ = NULL;
				gint _tmp10_ = 0;
				gint y = 0;
				Shape* _tmp11_ = NULL;
				gint _tmp12_ = 0;
				Block* _tmp13_ = NULL;
				gint _tmp14_ = 0;
				gboolean _tmp15_ = FALSE;
				gint _tmp16_ = 0;
				_tmp7_ = self->shape;
				_tmp8_ = _tmp7_->x;
				_tmp9_ = b;
				_tmp10_ = _tmp9_->x;
				x = _tmp8_ + _tmp10_;
				_tmp11_ = self->shape;
				_tmp12_ = _tmp11_->y;
				_tmp13_ = b;
				_tmp14_ = _tmp13_->y;
				y = _tmp12_ + _tmp14_;
				_tmp16_ = y;
				if (_tmp16_ >= 0) {
					Block** _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
					gint _tmp17__length2 = 0;
					gint _tmp18_ = 0;
					gint _tmp19_ = 0;
					Block* _tmp20_ = NULL;
					_tmp17_ = self->blocks;
					_tmp17__length1 = self->blocks_length1;
					_tmp17__length2 = self->blocks_length2;
					_tmp18_ = x;
					_tmp19_ = y;
					_tmp20_ = _tmp17_[(_tmp18_ * _tmp17__length2) + _tmp19_];
					_tmp15_ = _tmp20_ != NULL;
				} else {
					_tmp15_ = FALSE;
				}
				if (_tmp15_) {
					guint _tmp21_ = 0U;
					_tmp21_ = self->priv->drop_timeout;
					if (_tmp21_ != ((guint) 0)) {
						guint _tmp22_ = 0U;
						_tmp22_ = self->priv->drop_timeout;
						g_source_remove (_tmp22_);
					}
					self->priv->drop_timeout = (guint) 0;
					_g_object_unref0 (self->shape);
					self->shape = NULL;
					self->game_over = TRUE;
					g_signal_emit_by_name (self, "complete");
					_g_object_unref0 (b);
					return;
				}
				_g_object_unref0 (b);
			}
		}
	}
	g_signal_emit_by_name (self, "shape-added");
}


static Shape* game_pick_random_shape (Game* self) {
	Shape* result = NULL;
	gint32 _tmp0_ = 0;
	gint32 _tmp1_ = 0;
	Shape* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_random_int_range ((gint32) 0, (gint32) NCOLORS);
	_tmp1_ = g_random_int_range ((gint32) 0, (gint32) 4);
	_tmp2_ = game_make_shape (self, (gint) _tmp0_, (gint) _tmp1_);
	result = _tmp2_;
	return result;
}


static Shape* game_pick_difficult_shape (Game* self) {
	Shape* result = NULL;
	gint* metrics = NULL;
	gint* _tmp0_ = NULL;
	gint metrics_length1 = 0;
	gint _metrics_size_ = 0;
	gint* possible_types = NULL;
	gint* _tmp71_ = NULL;
	gint possible_types_length1 = 0;
	gint _possible_types_size_ = 0;
	gint32 rnd = 0;
	gint32 _tmp108_ = 0;
	gint32 _tmp109_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_new0 (gint, NCOLORS);
	metrics = _tmp0_;
	metrics_length1 = NCOLORS;
	_metrics_size_ = metrics_length1;
	{
		gint type = 0;
		type = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_ = 0;
				gint* _tmp4_ = NULL;
				gint _tmp4__length1 = 0;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = type;
					type = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = type;
				if (!(_tmp3_ < NCOLORS)) {
					break;
				}
				_tmp4_ = metrics;
				_tmp4__length1 = metrics_length1;
				_tmp5_ = type;
				_tmp4_[_tmp5_] = -32000;
				_tmp6_ = _tmp4_[_tmp5_];
				{
					gint rotation = 0;
					rotation = 0;
					{
						gboolean _tmp7_ = FALSE;
						_tmp7_ = TRUE;
						while (TRUE) {
							gint _tmp9_ = 0;
							if (!_tmp7_) {
								gint _tmp8_ = 0;
								_tmp8_ = rotation;
								rotation = _tmp8_ + 1;
							}
							_tmp7_ = FALSE;
							_tmp9_ = rotation;
							if (!(_tmp9_ < 4)) {
								break;
							}
							{
								gint pos = 0;
								pos = 0;
								{
									gboolean _tmp10_ = FALSE;
									_tmp10_ = TRUE;
									while (TRUE) {
										gint _tmp12_ = 0;
										gint _tmp13_ = 0;
										gint _tmp14_ = 0;
										Game* g = NULL;
										Game* _tmp15_ = NULL;
										Game* _tmp16_ = NULL;
										Game* _tmp17_ = NULL;
										gint _tmp18_ = 0;
										gint _tmp19_ = 0;
										Shape* _tmp20_ = NULL;
										gboolean valid_position = FALSE;
										gboolean _tmp29_ = FALSE;
										gint orig_lines = 0;
										Game* _tmp30_ = NULL;
										gint _tmp31_ = 0;
										Game* _tmp32_ = NULL;
										gint metric = 0;
										Game* _tmp33_ = NULL;
										gint _tmp34_ = 0;
										gint _tmp35_ = 0;
										gint _tmp55_ = 0;
										gint* _tmp56_ = NULL;
										gint _tmp56__length1 = 0;
										gint _tmp57_ = 0;
										gint _tmp58_ = 0;
										Game* _tmp63_ = NULL;
										if (!_tmp10_) {
											gint _tmp11_ = 0;
											_tmp11_ = pos;
											pos = _tmp11_ + 1;
										}
										_tmp10_ = FALSE;
										_tmp12_ = pos;
										_tmp13_ = game_get_width (self);
										_tmp14_ = _tmp13_;
										if (!(_tmp12_ < _tmp14_)) {
											break;
										}
										_tmp15_ = game_copy (self);
										g = _tmp15_;
										_tmp16_ = g;
										_tmp16_->priv->pick_difficult_blocks = FALSE;
										_tmp17_ = g;
										_tmp18_ = type;
										_tmp19_ = rotation;
										_tmp20_ = game_make_shape (self, _tmp18_, _tmp19_);
										_g_object_unref0 (_tmp17_->shape);
										_tmp17_->shape = _tmp20_;
										valid_position = TRUE;
										while (TRUE) {
											Game* _tmp21_ = NULL;
											gboolean _tmp22_ = FALSE;
											_tmp21_ = g;
											_tmp22_ = game_move_left (_tmp21_);
											if (!_tmp22_) {
												break;
											}
										}
										{
											gint x = 0;
											x = 0;
											{
												gboolean _tmp23_ = FALSE;
												_tmp23_ = TRUE;
												while (TRUE) {
													gint _tmp25_ = 0;
													gint _tmp26_ = 0;
													Game* _tmp27_ = NULL;
													gboolean _tmp28_ = FALSE;
													if (!_tmp23_) {
														gint _tmp24_ = 0;
														_tmp24_ = x;
														x = _tmp24_ + 1;
													}
													_tmp23_ = FALSE;
													_tmp25_ = x;
													_tmp26_ = pos;
													if (!(_tmp25_ < _tmp26_)) {
														break;
													}
													_tmp27_ = g;
													_tmp28_ = game_move_right (_tmp27_);
													if (!_tmp28_) {
														valid_position = FALSE;
														break;
													}
												}
											}
										}
										_tmp29_ = valid_position;
										if (!_tmp29_) {
											_g_object_unref0 (g);
											break;
										}
										_tmp30_ = g;
										_tmp31_ = _tmp30_->n_lines_destroyed;
										orig_lines = _tmp31_;
										_tmp32_ = g;
										game_drop (_tmp32_);
										_tmp33_ = g;
										_tmp34_ = _tmp33_->n_lines_destroyed;
										_tmp35_ = orig_lines;
										metric = (_tmp34_ - _tmp35_) * 5000;
										{
											gint x = 0;
											x = 0;
											{
												gboolean _tmp36_ = FALSE;
												_tmp36_ = TRUE;
												while (TRUE) {
													gint _tmp38_ = 0;
													gint _tmp39_ = 0;
													gint _tmp40_ = 0;
													gint y = 0;
													gint _tmp51_ = 0;
													gint _tmp52_ = 0;
													gint _tmp53_ = 0;
													gint _tmp54_ = 0;
													if (!_tmp36_) {
														gint _tmp37_ = 0;
														_tmp37_ = x;
														x = _tmp37_ + 1;
													}
													_tmp36_ = FALSE;
													_tmp38_ = x;
													_tmp39_ = game_get_width (self);
													_tmp40_ = _tmp39_;
													if (!(_tmp38_ < _tmp40_)) {
														break;
													}
													{
														gboolean _tmp41_ = FALSE;
														y = 0;
														_tmp41_ = TRUE;
														while (TRUE) {
															gint _tmp43_ = 0;
															gint _tmp44_ = 0;
															gint _tmp45_ = 0;
															Game* _tmp46_ = NULL;
															Block** _tmp47_ = NULL;
															gint _tmp47__length1 = 0;
															gint _tmp47__length2 = 0;
															gint _tmp48_ = 0;
															gint _tmp49_ = 0;
															Block* _tmp50_ = NULL;
															if (!_tmp41_) {
																gint _tmp42_ = 0;
																_tmp42_ = y;
																y = _tmp42_ + 1;
															}
															_tmp41_ = FALSE;
															_tmp43_ = y;
															_tmp44_ = game_get_height (self);
															_tmp45_ = _tmp44_;
															if (!(_tmp43_ < _tmp45_)) {
																break;
															}
															_tmp46_ = g;
															_tmp47_ = _tmp46_->blocks;
															_tmp47__length1 = _tmp46_->blocks_length1;
															_tmp47__length2 = _tmp46_->blocks_length2;
															_tmp48_ = x;
															_tmp49_ = y;
															_tmp50_ = _tmp47_[(_tmp48_ * _tmp47__length2) + _tmp49_];
															if (_tmp50_ != NULL) {
																break;
															}
														}
													}
													_tmp51_ = metric;
													_tmp52_ = game_get_height (self);
													_tmp53_ = _tmp52_;
													_tmp54_ = y;
													metric = _tmp51_ - (5 * (_tmp53_ - _tmp54_));
												}
											}
										}
										_tmp55_ = metric;
										_tmp56_ = metrics;
										_tmp56__length1 = metrics_length1;
										_tmp57_ = type;
										_tmp58_ = _tmp56_[_tmp57_];
										if (_tmp55_ > _tmp58_) {
											gint* _tmp59_ = NULL;
											gint _tmp59__length1 = 0;
											gint _tmp60_ = 0;
											gint _tmp61_ = 0;
											gint _tmp62_ = 0;
											_tmp59_ = metrics;
											_tmp59__length1 = metrics_length1;
											_tmp60_ = type;
											_tmp61_ = metric;
											_tmp59_[_tmp60_] = _tmp61_;
											_tmp62_ = _tmp59_[_tmp60_];
										}
										_tmp63_ = g;
										game_stop (_tmp63_);
										_g_object_unref0 (g);
									}
								}
							}
						}
					}
				}
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp64_ = FALSE;
			_tmp64_ = TRUE;
			while (TRUE) {
				gint _tmp66_ = 0;
				gint* _tmp67_ = NULL;
				gint _tmp67__length1 = 0;
				gint _tmp68_ = 0;
				gint32 _tmp69_ = 0;
				gint _tmp70_ = 0;
				if (!_tmp64_) {
					gint _tmp65_ = 0;
					_tmp65_ = i;
					i = _tmp65_ + 1;
				}
				_tmp64_ = FALSE;
				_tmp66_ = i;
				if (!(_tmp66_ < NCOLORS)) {
					break;
				}
				_tmp67_ = metrics;
				_tmp67__length1 = metrics_length1;
				_tmp68_ = i;
				_tmp69_ = g_random_int_range ((gint32) -2, (gint32) 2);
				_tmp67_[_tmp68_] += (gint) _tmp69_;
				_tmp70_ = _tmp67_[_tmp68_];
			}
		}
	}
	_tmp71_ = g_new0 (gint, NCOLORS);
	possible_types = _tmp71_;
	possible_types_length1 = NCOLORS;
	_possible_types_size_ = possible_types_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp72_ = FALSE;
			_tmp72_ = TRUE;
			while (TRUE) {
				gint _tmp74_ = 0;
				gint* _tmp75_ = NULL;
				gint _tmp75__length1 = 0;
				gint _tmp76_ = 0;
				gint _tmp77_ = 0;
				gint _tmp78_ = 0;
				if (!_tmp72_) {
					gint _tmp73_ = 0;
					_tmp73_ = i;
					i = _tmp73_ + 1;
				}
				_tmp72_ = FALSE;
				_tmp74_ = i;
				if (!(_tmp74_ < NCOLORS)) {
					break;
				}
				_tmp75_ = possible_types;
				_tmp75__length1 = possible_types_length1;
				_tmp76_ = i;
				_tmp77_ = i;
				_tmp75_[_tmp76_] = _tmp77_;
				_tmp78_ = _tmp75_[_tmp76_];
			}
		}
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp79_ = FALSE;
			_tmp79_ = TRUE;
			while (TRUE) {
				gint _tmp81_ = 0;
				if (!_tmp79_) {
					gint _tmp80_ = 0;
					_tmp80_ = i;
					i = _tmp80_ + 1;
				}
				_tmp79_ = FALSE;
				_tmp81_ = i;
				if (!(_tmp81_ < NCOLORS)) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp82_ = FALSE;
						_tmp82_ = TRUE;
						while (TRUE) {
							gint _tmp84_ = 0;
							gint* _tmp85_ = NULL;
							gint _tmp85__length1 = 0;
							gint* _tmp86_ = NULL;
							gint _tmp86__length1 = 0;
							gint _tmp87_ = 0;
							gint _tmp88_ = 0;
							gint _tmp89_ = 0;
							gint* _tmp90_ = NULL;
							gint _tmp90__length1 = 0;
							gint* _tmp91_ = NULL;
							gint _tmp91__length1 = 0;
							gint _tmp92_ = 0;
							gint _tmp93_ = 0;
							gint _tmp94_ = 0;
							if (!_tmp82_) {
								gint _tmp83_ = 0;
								_tmp83_ = j;
								j = _tmp83_ + 1;
							}
							_tmp82_ = FALSE;
							_tmp84_ = j;
							if (!(_tmp84_ < (NCOLORS - 1))) {
								break;
							}
							_tmp85_ = metrics;
							_tmp85__length1 = metrics_length1;
							_tmp86_ = possible_types;
							_tmp86__length1 = possible_types_length1;
							_tmp87_ = j;
							_tmp88_ = _tmp86_[_tmp87_];
							_tmp89_ = _tmp85_[_tmp88_];
							_tmp90_ = metrics;
							_tmp90__length1 = metrics_length1;
							_tmp91_ = possible_types;
							_tmp91__length1 = possible_types_length1;
							_tmp92_ = j;
							_tmp93_ = _tmp91_[_tmp92_ + 1];
							_tmp94_ = _tmp90_[_tmp93_];
							if (_tmp89_ > _tmp94_) {
								gint t = 0;
								gint* _tmp95_ = NULL;
								gint _tmp95__length1 = 0;
								gint _tmp96_ = 0;
								gint _tmp97_ = 0;
								gint* _tmp98_ = NULL;
								gint _tmp98__length1 = 0;
								gint _tmp99_ = 0;
								gint* _tmp100_ = NULL;
								gint _tmp100__length1 = 0;
								gint _tmp101_ = 0;
								gint _tmp102_ = 0;
								gint _tmp103_ = 0;
								gint* _tmp104_ = NULL;
								gint _tmp104__length1 = 0;
								gint _tmp105_ = 0;
								gint _tmp106_ = 0;
								gint _tmp107_ = 0;
								_tmp95_ = possible_types;
								_tmp95__length1 = possible_types_length1;
								_tmp96_ = j;
								_tmp97_ = _tmp95_[_tmp96_];
								t = _tmp97_;
								_tmp98_ = possible_types;
								_tmp98__length1 = possible_types_length1;
								_tmp99_ = j;
								_tmp100_ = possible_types;
								_tmp100__length1 = possible_types_length1;
								_tmp101_ = j;
								_tmp102_ = _tmp100_[_tmp101_ + 1];
								_tmp98_[_tmp99_] = _tmp102_;
								_tmp103_ = _tmp98_[_tmp99_];
								_tmp104_ = possible_types;
								_tmp104__length1 = possible_types_length1;
								_tmp105_ = j;
								_tmp106_ = t;
								_tmp104_[_tmp105_ + 1] = _tmp106_;
								_tmp107_ = _tmp104_[_tmp105_ + 1];
							}
						}
					}
				}
			}
		}
	}
	_tmp108_ = g_random_int_range ((gint32) 0, (gint32) 99);
	rnd = _tmp108_;
	_tmp109_ = rnd;
	if (_tmp109_ < ((gint32) 75)) {
		gint* _tmp110_ = NULL;
		gint _tmp110__length1 = 0;
		gint _tmp111_ = 0;
		gint32 _tmp112_ = 0;
		Shape* _tmp113_ = NULL;
		_tmp110_ = possible_types;
		_tmp110__length1 = possible_types_length1;
		_tmp111_ = _tmp110_[0];
		_tmp112_ = g_random_int_range ((gint32) 0, (gint32) 4);
		_tmp113_ = game_make_shape (self, _tmp111_, (gint) _tmp112_);
		result = _tmp113_;
		possible_types = (g_free (possible_types), NULL);
		metrics = (g_free (metrics), NULL);
		return result;
	} else {
		gint32 _tmp114_ = 0;
		_tmp114_ = rnd;
		if (_tmp114_ < ((gint32) 92)) {
			gint* _tmp115_ = NULL;
			gint _tmp115__length1 = 0;
			gint _tmp116_ = 0;
			gint32 _tmp117_ = 0;
			Shape* _tmp118_ = NULL;
			_tmp115_ = possible_types;
			_tmp115__length1 = possible_types_length1;
			_tmp116_ = _tmp115_[1];
			_tmp117_ = g_random_int_range ((gint32) 0, (gint32) 4);
			_tmp118_ = game_make_shape (self, _tmp116_, (gint) _tmp117_);
			result = _tmp118_;
			possible_types = (g_free (possible_types), NULL);
			metrics = (g_free (metrics), NULL);
			return result;
		} else {
			gint32 _tmp119_ = 0;
			_tmp119_ = rnd;
			if (_tmp119_ < ((gint32) 98)) {
				gint* _tmp120_ = NULL;
				gint _tmp120__length1 = 0;
				gint _tmp121_ = 0;
				gint32 _tmp122_ = 0;
				Shape* _tmp123_ = NULL;
				_tmp120_ = possible_types;
				_tmp120__length1 = possible_types_length1;
				_tmp121_ = _tmp120_[2];
				_tmp122_ = g_random_int_range ((gint32) 0, (gint32) 4);
				_tmp123_ = game_make_shape (self, _tmp121_, (gint) _tmp122_);
				result = _tmp123_;
				possible_types = (g_free (possible_types), NULL);
				metrics = (g_free (metrics), NULL);
				return result;
			} else {
				gint* _tmp124_ = NULL;
				gint _tmp124__length1 = 0;
				gint _tmp125_ = 0;
				gint32 _tmp126_ = 0;
				Shape* _tmp127_ = NULL;
				_tmp124_ = possible_types;
				_tmp124__length1 = possible_types_length1;
				_tmp125_ = _tmp124_[3];
				_tmp126_ = g_random_int_range ((gint32) 0, (gint32) 4);
				_tmp127_ = game_make_shape (self, _tmp125_, (gint) _tmp126_);
				result = _tmp127_;
				possible_types = (g_free (possible_types), NULL);
				metrics = (g_free (metrics), NULL);
				return result;
			}
		}
	}
	possible_types = (g_free (possible_types), NULL);
	metrics = (g_free (metrics), NULL);
}


static Shape* game_make_shape (Game* self, gint type, gint rotation) {
	Shape* result = NULL;
	Shape* shape = NULL;
	Shape* _tmp0_ = NULL;
	Shape* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	Shape* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint offset = 0;
	Shape* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	Shape* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint min_width = 0;
	gint max_width = 0;
	gint min_height = 0;
	gint max_height = 0;
	gint block_width = 0;
	gint _tmp42_ = 0;
	gint _tmp43_ = 0;
	Shape* _tmp44_ = NULL;
	gint _tmp45_ = 0;
	gint _tmp46_ = 0;
	gint _tmp47_ = 0;
	Shape* _tmp48_ = NULL;
	gint _tmp49_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = shape_new ();
	shape = _tmp0_;
	_tmp1_ = shape;
	_tmp2_ = type;
	_tmp1_->type = _tmp2_;
	_tmp3_ = shape;
	_tmp4_ = rotation;
	_tmp3_->rotation = _tmp4_;
	_tmp5_ = shape;
	_tmp6_ = _tmp5_->type;
	_tmp7_ = shape;
	_tmp8_ = _tmp7_->rotation;
	offset = (_tmp6_ * 64) + (_tmp8_ * 16);
	min_width = 4;
	max_width = 0;
	min_height = 4;
	max_height = 0;
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				gint _tmp11_ = 0;
				if (!_tmp9_) {
					gint _tmp10_ = 0;
					_tmp10_ = x;
					x = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp11_ = x;
				if (!(_tmp11_ < 4)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp12_ = FALSE;
						_tmp12_ = TRUE;
						while (TRUE) {
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							gint _tmp18_ = 0;
							gint _tmp19_ = 0;
							gint _tmp20_ = 0;
							gint _tmp21_ = 0;
							gint _tmp22_ = 0;
							gint _tmp23_ = 0;
							gint _tmp24_ = 0;
							gint _tmp25_ = 0;
							gint _tmp26_ = 0;
							gint _tmp27_ = 0;
							gint _tmp28_ = 0;
							gint _tmp29_ = 0;
							gint _tmp30_ = 0;
							Block* b = NULL;
							Block* _tmp31_ = NULL;
							Block* _tmp32_ = NULL;
							Shape* _tmp33_ = NULL;
							gint _tmp34_ = 0;
							Block* _tmp35_ = NULL;
							gint _tmp36_ = 0;
							Block* _tmp37_ = NULL;
							gint _tmp38_ = 0;
							Shape* _tmp39_ = NULL;
							Block* _tmp40_ = NULL;
							Block* _tmp41_ = NULL;
							if (!_tmp12_) {
								gint _tmp13_ = 0;
								_tmp13_ = y;
								y = _tmp13_ + 1;
							}
							_tmp12_ = FALSE;
							_tmp14_ = y;
							if (!(_tmp14_ < 4)) {
								break;
							}
							_tmp15_ = offset;
							_tmp16_ = y;
							_tmp17_ = x;
							_tmp18_ = block_table[(_tmp15_ + (_tmp16_ * 4)) + _tmp17_];
							if (_tmp18_ == 0) {
								continue;
							}
							_tmp19_ = x;
							_tmp20_ = min_width;
							_tmp21_ = MIN (_tmp19_, _tmp20_);
							min_width = _tmp21_;
							_tmp22_ = x;
							_tmp23_ = max_width;
							_tmp24_ = MAX (_tmp22_ + 1, _tmp23_);
							max_width = _tmp24_;
							_tmp25_ = y;
							_tmp26_ = min_height;
							_tmp27_ = MIN (_tmp25_, _tmp26_);
							min_height = _tmp27_;
							_tmp28_ = y;
							_tmp29_ = max_height;
							_tmp30_ = MAX (_tmp28_ + 1, _tmp29_);
							max_height = _tmp30_;
							_tmp31_ = block_new ();
							b = _tmp31_;
							_tmp32_ = b;
							_tmp33_ = shape;
							_tmp34_ = _tmp33_->type;
							_tmp32_->color = _tmp34_;
							_tmp35_ = b;
							_tmp36_ = x;
							_tmp35_->x = _tmp36_;
							_tmp37_ = b;
							_tmp38_ = y;
							_tmp37_->y = _tmp38_;
							_tmp39_ = shape;
							_tmp40_ = b;
							_tmp41_ = _g_object_ref0 (_tmp40_);
							_tmp39_->blocks = g_list_append (_tmp39_->blocks, _tmp41_);
							_g_object_unref0 (b);
						}
					}
				}
			}
		}
	}
	_tmp42_ = max_width;
	_tmp43_ = min_width;
	block_width = _tmp42_ - _tmp43_;
	_tmp44_ = shape;
	_tmp45_ = game_get_width (self);
	_tmp46_ = _tmp45_;
	_tmp47_ = min_width;
	_tmp44_->x = ((_tmp46_ - block_width) / 2) - _tmp47_;
	_tmp48_ = shape;
	_tmp49_ = min_height;
	_tmp48_->y = -_tmp49_;
	result = shape;
	return result;
}


static void game_land_shape (Game* self) {
	Shape* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	gint fall_distance = 0;
	gint* lines = NULL;
	gint* _tmp21_ = NULL;
	gint lines_length1 = 0;
	gint _lines_size_ = 0;
	gint n_lines = 0;
	gboolean base_line_destroyed = FALSE;
	gint _tmp45_ = 0;
	gint _tmp46_ = 0;
	GList* line_blocks = NULL;
	gint old_level = 0;
	gint _tmp105_ = 0;
	gint _tmp106_ = 0;
	gint _tmp107_ = 0;
	gint _tmp108_ = 0;
	gint _tmp109_ = 0;
	gboolean _tmp122_ = FALSE;
	gint _tmp126_ = 0;
	gint _tmp127_ = 0;
	gint _tmp128_ = 0;
	gint* _tmp129_ = NULL;
	gint _tmp129__length1 = 0;
	GList* _tmp130_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->shape;
	_tmp1_ = _tmp0_->blocks;
	{
		GList* b_collection = NULL;
		GList* b_it = NULL;
		b_collection = _tmp1_;
		for (b_it = b_collection; b_it != NULL; b_it = b_it->next) {
			Block* _tmp2_ = NULL;
			Block* b = NULL;
			_tmp2_ = _g_object_ref0 ((Block*) b_it->data);
			b = _tmp2_;
			{
				Block* _tmp3_ = NULL;
				Block* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				Shape* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				Block* _tmp8_ = NULL;
				Block* _tmp9_ = NULL;
				gint _tmp10_ = 0;
				Shape* _tmp11_ = NULL;
				gint _tmp12_ = 0;
				Block** _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gint _tmp13__length2 = 0;
				Block* _tmp14_ = NULL;
				gint _tmp15_ = 0;
				Block* _tmp16_ = NULL;
				gint _tmp17_ = 0;
				Block* _tmp18_ = NULL;
				Block* _tmp19_ = NULL;
				Block* _tmp20_ = NULL;
				_tmp3_ = b;
				_tmp4_ = b;
				_tmp5_ = _tmp4_->x;
				_tmp6_ = self->shape;
				_tmp7_ = _tmp6_->x;
				_tmp4_->x = _tmp5_ + _tmp7_;
				_tmp8_ = b;
				_tmp9_ = b;
				_tmp10_ = _tmp9_->y;
				_tmp11_ = self->shape;
				_tmp12_ = _tmp11_->y;
				_tmp9_->y = _tmp10_ + _tmp12_;
				_tmp13_ = self->blocks;
				_tmp13__length1 = self->blocks_length1;
				_tmp13__length2 = self->blocks_length2;
				_tmp14_ = b;
				_tmp15_ = _tmp14_->x;
				_tmp16_ = b;
				_tmp17_ = _tmp16_->y;
				_tmp18_ = b;
				_tmp19_ = _g_object_ref0 (_tmp18_);
				_g_object_unref0 (_tmp13_[(_tmp15_ * _tmp13__length2) + _tmp17_]);
				_tmp13_[(_tmp15_ * _tmp13__length2) + _tmp17_] = _tmp19_;
				_tmp20_ = _tmp13_[(_tmp15_ * _tmp13__length2) + _tmp17_];
				_g_object_unref0 (b);
			}
		}
	}
	fall_distance = 0;
	_tmp21_ = g_new0 (gint, 4);
	lines = _tmp21_;
	lines_length1 = 4;
	_lines_size_ = lines_length1;
	n_lines = 0;
	base_line_destroyed = FALSE;
	{
		gint y = 0;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
		_tmp22_ = game_get_height (self);
		_tmp23_ = _tmp22_;
		y = _tmp23_ - 1;
		{
			gboolean _tmp24_ = FALSE;
			_tmp24_ = TRUE;
			while (TRUE) {
				gint _tmp26_ = 0;
				gboolean explode = FALSE;
				gboolean _tmp36_ = FALSE;
				if (!_tmp24_) {
					gint _tmp25_ = 0;
					_tmp25_ = y;
					y = _tmp25_ - 1;
				}
				_tmp24_ = FALSE;
				_tmp26_ = y;
				if (!(_tmp26_ >= 0)) {
					break;
				}
				explode = TRUE;
				{
					gint x = 0;
					x = 0;
					{
						gboolean _tmp27_ = FALSE;
						_tmp27_ = TRUE;
						while (TRUE) {
							gint _tmp29_ = 0;
							gint _tmp30_ = 0;
							gint _tmp31_ = 0;
							Block** _tmp32_ = NULL;
							gint _tmp32__length1 = 0;
							gint _tmp32__length2 = 0;
							gint _tmp33_ = 0;
							gint _tmp34_ = 0;
							Block* _tmp35_ = NULL;
							if (!_tmp27_) {
								gint _tmp28_ = 0;
								_tmp28_ = x;
								x = _tmp28_ + 1;
							}
							_tmp27_ = FALSE;
							_tmp29_ = x;
							_tmp30_ = game_get_width (self);
							_tmp31_ = _tmp30_;
							if (!(_tmp29_ < _tmp31_)) {
								break;
							}
							_tmp32_ = self->blocks;
							_tmp32__length1 = self->blocks_length1;
							_tmp32__length2 = self->blocks_length2;
							_tmp33_ = x;
							_tmp34_ = y;
							_tmp35_ = _tmp32_[(_tmp33_ * _tmp32__length2) + _tmp34_];
							if (_tmp35_ == NULL) {
								explode = FALSE;
								break;
							}
						}
					}
				}
				_tmp36_ = explode;
				if (_tmp36_) {
					gint _tmp37_ = 0;
					gint _tmp38_ = 0;
					gint _tmp39_ = 0;
					gint* _tmp40_ = NULL;
					gint _tmp40__length1 = 0;
					gint _tmp41_ = 0;
					gint _tmp42_ = 0;
					gint _tmp43_ = 0;
					gint _tmp44_ = 0;
					_tmp37_ = y;
					_tmp38_ = game_get_height (self);
					_tmp39_ = _tmp38_;
					if (_tmp37_ == (_tmp39_ - 1)) {
						base_line_destroyed = TRUE;
					}
					_tmp40_ = lines;
					_tmp40__length1 = lines_length1;
					_tmp41_ = n_lines;
					_tmp42_ = y;
					_tmp40_[_tmp41_] = _tmp42_;
					_tmp43_ = _tmp40_[_tmp41_];
					_tmp44_ = n_lines;
					n_lines = _tmp44_ + 1;
				}
			}
		}
	}
	_tmp45_ = n_lines;
	_tmp46_ = _tmp45_;
	lines = g_renew (gint, lines, _tmp45_);
	(_tmp46_ > lines_length1) ? memset (lines + lines_length1, 0, sizeof (gint) * (_tmp46_ - lines_length1)) : NULL;
	lines_length1 = _tmp46_;
	_lines_size_ = _tmp46_;
	line_blocks = NULL;
	{
		gint y = 0;
		gint _tmp47_ = 0;
		gint _tmp48_ = 0;
		_tmp47_ = game_get_height (self);
		_tmp48_ = _tmp47_;
		y = _tmp48_ - 1;
		{
			gboolean _tmp49_ = FALSE;
			_tmp49_ = TRUE;
			while (TRUE) {
				gint _tmp51_ = 0;
				gboolean explode = FALSE;
				gboolean _tmp61_ = FALSE;
				if (!_tmp49_) {
					gint _tmp50_ = 0;
					_tmp50_ = y;
					y = _tmp50_ - 1;
				}
				_tmp49_ = FALSE;
				_tmp51_ = y;
				if (!(_tmp51_ >= 0)) {
					break;
				}
				explode = TRUE;
				{
					gint x = 0;
					x = 0;
					{
						gboolean _tmp52_ = FALSE;
						_tmp52_ = TRUE;
						while (TRUE) {
							gint _tmp54_ = 0;
							gint _tmp55_ = 0;
							gint _tmp56_ = 0;
							Block** _tmp57_ = NULL;
							gint _tmp57__length1 = 0;
							gint _tmp57__length2 = 0;
							gint _tmp58_ = 0;
							gint _tmp59_ = 0;
							Block* _tmp60_ = NULL;
							if (!_tmp52_) {
								gint _tmp53_ = 0;
								_tmp53_ = x;
								x = _tmp53_ + 1;
							}
							_tmp52_ = FALSE;
							_tmp54_ = x;
							_tmp55_ = game_get_width (self);
							_tmp56_ = _tmp55_;
							if (!(_tmp54_ < _tmp56_)) {
								break;
							}
							_tmp57_ = self->blocks;
							_tmp57__length1 = self->blocks_length1;
							_tmp57__length2 = self->blocks_length2;
							_tmp58_ = x;
							_tmp59_ = y;
							_tmp60_ = _tmp57_[(_tmp58_ * _tmp57__length2) + _tmp59_];
							if (_tmp60_ == NULL) {
								explode = FALSE;
								break;
							}
						}
					}
				}
				_tmp61_ = explode;
				if (_tmp61_) {
					gint _tmp76_ = 0;
					{
						gint x = 0;
						x = 0;
						{
							gboolean _tmp62_ = FALSE;
							_tmp62_ = TRUE;
							while (TRUE) {
								gint _tmp64_ = 0;
								gint _tmp65_ = 0;
								gint _tmp66_ = 0;
								Block** _tmp67_ = NULL;
								gint _tmp67__length1 = 0;
								gint _tmp67__length2 = 0;
								gint _tmp68_ = 0;
								gint _tmp69_ = 0;
								Block* _tmp70_ = NULL;
								Block* _tmp71_ = NULL;
								Block** _tmp72_ = NULL;
								gint _tmp72__length1 = 0;
								gint _tmp72__length2 = 0;
								gint _tmp73_ = 0;
								gint _tmp74_ = 0;
								Block* _tmp75_ = NULL;
								if (!_tmp62_) {
									gint _tmp63_ = 0;
									_tmp63_ = x;
									x = _tmp63_ + 1;
								}
								_tmp62_ = FALSE;
								_tmp64_ = x;
								_tmp65_ = game_get_width (self);
								_tmp66_ = _tmp65_;
								if (!(_tmp64_ < _tmp66_)) {
									break;
								}
								_tmp67_ = self->blocks;
								_tmp67__length1 = self->blocks_length1;
								_tmp67__length2 = self->blocks_length2;
								_tmp68_ = x;
								_tmp69_ = y;
								_tmp70_ = _tmp67_[(_tmp68_ * _tmp67__length2) + _tmp69_];
								_tmp71_ = _g_object_ref0 (_tmp70_);
								line_blocks = g_list_append (line_blocks, _tmp71_);
								_tmp72_ = self->blocks;
								_tmp72__length1 = self->blocks_length1;
								_tmp72__length2 = self->blocks_length2;
								_tmp73_ = x;
								_tmp74_ = y;
								_g_object_unref0 (_tmp72_[(_tmp73_ * _tmp72__length2) + _tmp74_]);
								_tmp72_[(_tmp73_ * _tmp72__length2) + _tmp74_] = NULL;
								_tmp75_ = _tmp72_[(_tmp73_ * _tmp72__length2) + _tmp74_];
							}
						}
					}
					_tmp76_ = fall_distance;
					fall_distance = _tmp76_ + 1;
				} else {
					gint _tmp77_ = 0;
					_tmp77_ = fall_distance;
					if (_tmp77_ > 0) {
						{
							gint x = 0;
							x = 0;
							{
								gboolean _tmp78_ = FALSE;
								_tmp78_ = TRUE;
								while (TRUE) {
									gint _tmp80_ = 0;
									gint _tmp81_ = 0;
									gint _tmp82_ = 0;
									Block* b = NULL;
									Block** _tmp83_ = NULL;
									gint _tmp83__length1 = 0;
									gint _tmp83__length2 = 0;
									gint _tmp84_ = 0;
									gint _tmp85_ = 0;
									Block* _tmp86_ = NULL;
									Block* _tmp87_ = NULL;
									Block* _tmp88_ = NULL;
									if (!_tmp78_) {
										gint _tmp79_ = 0;
										_tmp79_ = x;
										x = _tmp79_ + 1;
									}
									_tmp78_ = FALSE;
									_tmp80_ = x;
									_tmp81_ = game_get_width (self);
									_tmp82_ = _tmp81_;
									if (!(_tmp80_ < _tmp82_)) {
										break;
									}
									_tmp83_ = self->blocks;
									_tmp83__length1 = self->blocks_length1;
									_tmp83__length2 = self->blocks_length2;
									_tmp84_ = x;
									_tmp85_ = y;
									_tmp86_ = _tmp83_[(_tmp84_ * _tmp83__length2) + _tmp85_];
									_tmp87_ = _g_object_ref0 (_tmp86_);
									b = _tmp87_;
									_tmp88_ = b;
									if (_tmp88_ != NULL) {
										Block* _tmp89_ = NULL;
										Block* _tmp90_ = NULL;
										gint _tmp91_ = 0;
										gint _tmp92_ = 0;
										Block** _tmp93_ = NULL;
										gint _tmp93__length1 = 0;
										gint _tmp93__length2 = 0;
										Block* _tmp94_ = NULL;
										gint _tmp95_ = 0;
										Block* _tmp96_ = NULL;
										gint _tmp97_ = 0;
										Block* _tmp98_ = NULL;
										Block* _tmp99_ = NULL;
										Block* _tmp100_ = NULL;
										Block** _tmp101_ = NULL;
										gint _tmp101__length1 = 0;
										gint _tmp101__length2 = 0;
										gint _tmp102_ = 0;
										gint _tmp103_ = 0;
										Block* _tmp104_ = NULL;
										_tmp89_ = b;
										_tmp90_ = b;
										_tmp91_ = _tmp90_->y;
										_tmp92_ = fall_distance;
										_tmp90_->y = _tmp91_ + _tmp92_;
										_tmp93_ = self->blocks;
										_tmp93__length1 = self->blocks_length1;
										_tmp93__length2 = self->blocks_length2;
										_tmp94_ = b;
										_tmp95_ = _tmp94_->x;
										_tmp96_ = b;
										_tmp97_ = _tmp96_->y;
										_tmp98_ = b;
										_tmp99_ = _g_object_ref0 (_tmp98_);
										_g_object_unref0 (_tmp93_[(_tmp95_ * _tmp93__length2) + _tmp97_]);
										_tmp93_[(_tmp95_ * _tmp93__length2) + _tmp97_] = _tmp99_;
										_tmp100_ = _tmp93_[(_tmp95_ * _tmp93__length2) + _tmp97_];
										_tmp101_ = self->blocks;
										_tmp101__length1 = self->blocks_length1;
										_tmp101__length2 = self->blocks_length2;
										_tmp102_ = x;
										_tmp103_ = y;
										_g_object_unref0 (_tmp101_[(_tmp102_ * _tmp101__length2) + _tmp103_]);
										_tmp101_[(_tmp102_ * _tmp101__length2) + _tmp103_] = NULL;
										_tmp104_ = _tmp101_[(_tmp102_ * _tmp101__length2) + _tmp103_];
									}
									_g_object_unref0 (b);
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp105_ = game_get_level (self);
	_tmp106_ = _tmp105_;
	old_level = _tmp106_;
	_tmp107_ = self->n_lines_destroyed;
	_tmp108_ = n_lines;
	self->n_lines_destroyed = _tmp107_ + _tmp108_;
	_tmp109_ = n_lines;
	switch (_tmp109_) {
		case 0:
		{
			break;
		}
		case 1:
		{
			gint _tmp110_ = 0;
			gint _tmp111_ = 0;
			gint _tmp112_ = 0;
			_tmp110_ = self->score;
			_tmp111_ = game_get_level (self);
			_tmp112_ = _tmp111_;
			self->score = _tmp110_ + (40 * _tmp112_);
			break;
		}
		case 2:
		{
			gint _tmp113_ = 0;
			gint _tmp114_ = 0;
			gint _tmp115_ = 0;
			_tmp113_ = self->score;
			_tmp114_ = game_get_level (self);
			_tmp115_ = _tmp114_;
			self->score = _tmp113_ + (100 * _tmp115_);
			break;
		}
		case 3:
		{
			gint _tmp116_ = 0;
			gint _tmp117_ = 0;
			gint _tmp118_ = 0;
			_tmp116_ = self->score;
			_tmp117_ = game_get_level (self);
			_tmp118_ = _tmp117_;
			self->score = _tmp116_ + (300 * _tmp118_);
			break;
		}
		case 4:
		{
			gint _tmp119_ = 0;
			gint _tmp120_ = 0;
			gint _tmp121_ = 0;
			_tmp119_ = self->score;
			_tmp120_ = game_get_level (self);
			_tmp121_ = _tmp120_;
			self->score = _tmp119_ + (1200 * _tmp121_);
			break;
		}
		default:
		break;
	}
	_tmp122_ = base_line_destroyed;
	if (_tmp122_) {
		gint _tmp123_ = 0;
		gint _tmp124_ = 0;
		gint _tmp125_ = 0;
		_tmp123_ = self->score;
		_tmp124_ = game_get_level (self);
		_tmp125_ = _tmp124_;
		self->score = _tmp123_ + (10000 * _tmp125_);
	}
	_tmp126_ = game_get_level (self);
	_tmp127_ = _tmp126_;
	_tmp128_ = old_level;
	if (_tmp127_ != _tmp128_) {
		game_setup_drop_timer (self);
	}
	_tmp129_ = lines;
	_tmp129__length1 = lines_length1;
	_tmp130_ = line_blocks;
	g_signal_emit_by_name (self, "shape-landed", _tmp129_, _tmp129__length1, _tmp130_);
	_g_object_unref0 (self->shape);
	self->shape = NULL;
	__g_list_free__g_object_unref0_0 (line_blocks);
	lines = (g_free (lines), NULL);
}


static gboolean game_move_shape (Game* self, gint x_step, gint y_step, gint r_step) {
	gboolean result = FALSE;
	Shape* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gboolean can_move = FALSE;
	Shape* _tmp2_ = NULL;
	GList* _tmp3_ = NULL;
	gboolean _tmp29_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->shape;
	if (_tmp0_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp1_ = r_step;
	game_rotate_shape (self, _tmp1_);
	can_move = TRUE;
	_tmp2_ = self->shape;
	_tmp3_ = _tmp2_->blocks;
	{
		GList* b_collection = NULL;
		GList* b_it = NULL;
		b_collection = _tmp3_;
		for (b_it = b_collection; b_it != NULL; b_it = b_it->next) {
			Block* _tmp4_ = NULL;
			Block* b = NULL;
			_tmp4_ = _g_object_ref0 ((Block*) b_it->data);
			b = _tmp4_;
			{
				gint x = 0;
				Shape* _tmp5_ = NULL;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				Block* _tmp8_ = NULL;
				gint _tmp9_ = 0;
				gint y = 0;
				Shape* _tmp10_ = NULL;
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
				Block* _tmp13_ = NULL;
				gint _tmp14_ = 0;
				gboolean _tmp15_ = FALSE;
				gboolean _tmp16_ = FALSE;
				gboolean _tmp17_ = FALSE;
				gint _tmp18_ = 0;
				_tmp5_ = self->shape;
				_tmp6_ = _tmp5_->x;
				_tmp7_ = x_step;
				_tmp8_ = b;
				_tmp9_ = _tmp8_->x;
				x = (_tmp6_ + _tmp7_) + _tmp9_;
				_tmp10_ = self->shape;
				_tmp11_ = _tmp10_->y;
				_tmp12_ = y_step;
				_tmp13_ = b;
				_tmp14_ = _tmp13_->y;
				y = (_tmp11_ + _tmp12_) + _tmp14_;
				_tmp18_ = x;
				if (_tmp18_ < 0) {
					_tmp17_ = TRUE;
				} else {
					gint _tmp19_ = 0;
					gint _tmp20_ = 0;
					gint _tmp21_ = 0;
					_tmp19_ = x;
					_tmp20_ = game_get_width (self);
					_tmp21_ = _tmp20_;
					_tmp17_ = _tmp19_ >= _tmp21_;
				}
				if (_tmp17_) {
					_tmp16_ = TRUE;
				} else {
					gint _tmp22_ = 0;
					gint _tmp23_ = 0;
					gint _tmp24_ = 0;
					_tmp22_ = y;
					_tmp23_ = game_get_height (self);
					_tmp24_ = _tmp23_;
					_tmp16_ = _tmp22_ >= _tmp24_;
				}
				if (_tmp16_) {
					_tmp15_ = TRUE;
				} else {
					Block** _tmp25_ = NULL;
					gint _tmp25__length1 = 0;
					gint _tmp25__length2 = 0;
					gint _tmp26_ = 0;
					gint _tmp27_ = 0;
					Block* _tmp28_ = NULL;
					_tmp25_ = self->blocks;
					_tmp25__length1 = self->blocks_length1;
					_tmp25__length2 = self->blocks_length2;
					_tmp26_ = x;
					_tmp27_ = y;
					_tmp28_ = _tmp25_[(_tmp26_ * _tmp25__length2) + _tmp27_];
					_tmp15_ = _tmp28_ != NULL;
				}
				if (_tmp15_) {
					can_move = FALSE;
					_g_object_unref0 (b);
					break;
				}
				_g_object_unref0 (b);
			}
		}
	}
	_tmp29_ = can_move;
	if (_tmp29_) {
		Shape* _tmp30_ = NULL;
		Shape* _tmp31_ = NULL;
		gint _tmp32_ = 0;
		gint _tmp33_ = 0;
		Shape* _tmp34_ = NULL;
		Shape* _tmp35_ = NULL;
		gint _tmp36_ = 0;
		gint _tmp37_ = 0;
		gint _tmp38_ = 0;
		_tmp30_ = self->shape;
		_tmp31_ = self->shape;
		_tmp32_ = _tmp31_->x;
		_tmp33_ = x_step;
		_tmp31_->x = _tmp32_ + _tmp33_;
		_tmp34_ = self->shape;
		_tmp35_ = self->shape;
		_tmp36_ = _tmp35_->y;
		_tmp37_ = y_step;
		_tmp35_->y = _tmp36_ + _tmp37_;
		_tmp38_ = x_step;
		if (_tmp38_ != 0) {
			g_signal_emit_by_name (self, "shape-moved");
		} else {
			gint _tmp39_ = 0;
			_tmp39_ = y_step;
			if (_tmp39_ > 0) {
				g_signal_emit_by_name (self, "shape-dropped");
			} else {
				g_signal_emit_by_name (self, "shape-rotated");
			}
		}
	} else {
		gint _tmp40_ = 0;
		_tmp40_ = r_step;
		game_rotate_shape (self, -_tmp40_);
	}
	result = can_move;
	return result;
}


static void game_rotate_shape (Game* self, gint r_step) {
	gint r = 0;
	Shape* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp5_ = 0;
	gint _tmp7_ = 0;
	Shape* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	Shape* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	GList* b = NULL;
	Shape* _tmp12_ = NULL;
	GList* _tmp13_ = NULL;
	gint offset = 0;
	Shape* _tmp14_ = NULL;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->shape;
	_tmp1_ = _tmp0_->rotation;
	_tmp2_ = r_step;
	r = _tmp1_ + _tmp2_;
	_tmp3_ = r;
	if (_tmp3_ < 0) {
		gint _tmp4_ = 0;
		_tmp4_ = r;
		r = _tmp4_ + 4;
	}
	_tmp5_ = r;
	if (_tmp5_ >= 4) {
		gint _tmp6_ = 0;
		_tmp6_ = r;
		r = _tmp6_ - 4;
	}
	_tmp7_ = r;
	_tmp8_ = self->shape;
	_tmp9_ = _tmp8_->rotation;
	if (_tmp7_ == _tmp9_) {
		return;
	}
	_tmp10_ = self->shape;
	_tmp11_ = r;
	_tmp10_->rotation = _tmp11_;
	_tmp12_ = self->shape;
	_tmp13_ = _tmp12_->blocks;
	b = _tmp13_;
	_tmp14_ = self->shape;
	_tmp15_ = _tmp14_->type;
	_tmp16_ = r;
	offset = (_tmp15_ * 64) + (_tmp16_ * 16);
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp17_ = FALSE;
			_tmp17_ = TRUE;
			while (TRUE) {
				gint _tmp19_ = 0;
				if (!_tmp17_) {
					gint _tmp18_ = 0;
					_tmp18_ = x;
					x = _tmp18_ + 1;
				}
				_tmp17_ = FALSE;
				_tmp19_ = x;
				if (!(_tmp19_ < 4)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp20_ = FALSE;
						_tmp20_ = TRUE;
						while (TRUE) {
							gint _tmp22_ = 0;
							gint _tmp23_ = 0;
							gint _tmp24_ = 0;
							gint _tmp25_ = 0;
							gint _tmp26_ = 0;
							if (!_tmp20_) {
								gint _tmp21_ = 0;
								_tmp21_ = y;
								y = _tmp21_ + 1;
							}
							_tmp20_ = FALSE;
							_tmp22_ = y;
							if (!(_tmp22_ < 4)) {
								break;
							}
							_tmp23_ = offset;
							_tmp24_ = y;
							_tmp25_ = x;
							_tmp26_ = block_table[(_tmp23_ + (_tmp24_ * 4)) + _tmp25_];
							if (_tmp26_ != 0) {
								GList* _tmp27_ = NULL;
								gconstpointer _tmp28_ = NULL;
								gint _tmp29_ = 0;
								GList* _tmp30_ = NULL;
								gconstpointer _tmp31_ = NULL;
								gint _tmp32_ = 0;
								GList* _tmp33_ = NULL;
								GList* _tmp34_ = NULL;
								_tmp27_ = b;
								_tmp28_ = _tmp27_->data;
								_tmp29_ = x;
								((Block*) _tmp28_)->x = _tmp29_;
								_tmp30_ = b;
								_tmp31_ = _tmp30_->data;
								_tmp32_ = y;
								((Block*) _tmp31_)->y = _tmp32_;
								_tmp33_ = b;
								_tmp34_ = _tmp33_->next;
								b = _tmp34_;
							}
						}
					}
				}
			}
		}
	}
}


gint game_get_width (Game* self) {
	gint result;
	Block** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->blocks;
	_tmp0__length1 = self->blocks_length1;
	_tmp0__length2 = self->blocks_length2;
	_tmp1_ = _tmp0__length1;
	result = _tmp1_;
	return result;
}


gint game_get_height (Game* self) {
	gint result;
	Block** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->blocks;
	_tmp0__length1 = self->blocks_length1;
	_tmp0__length2 = self->blocks_length2;
	_tmp1_ = _tmp0__length2;
	result = _tmp1_;
	return result;
}


gint game_get_level (Game* self) {
	gint result;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->starting_level;
	_tmp1_ = self->n_lines_destroyed;
	result = _tmp0_ + (_tmp1_ / 10);
	return result;
}


gboolean game_get_paused (Game* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_paused;
	result = _tmp0_;
	return result;
}


void game_set_paused (Game* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_paused = _tmp0_;
	_tmp1_ = self->priv->has_started;
	if (_tmp1_) {
		game_setup_drop_timer (self);
	}
	g_signal_emit_by_name (self, "pause-changed");
	g_object_notify ((GObject *) self, "paused");
}


gint game_get_shadow_y (Game* self) {
	gint result;
	Shape* _tmp0_ = NULL;
	gint d = 0;
	Game* g = NULL;
	Game* _tmp1_ = NULL;
	Shape* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->shape;
	if (_tmp0_ == NULL) {
		result = 0;
		return result;
	}
	d = 0;
	_tmp1_ = game_copy (self);
	g = _tmp1_;
	while (TRUE) {
		Game* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gint _tmp4_ = 0;
		_tmp2_ = g;
		_tmp3_ = game_move_shape (_tmp2_, 0, 1, 0);
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = d;
		d = _tmp4_ + 1;
	}
	_tmp5_ = self->shape;
	_tmp6_ = _tmp5_->y;
	_tmp7_ = d;
	result = _tmp6_ + _tmp7_;
	_g_object_unref0 (g);
	return result;
}


static void g_cclosure_user_marshal_VOID__POINTER_INT_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__POINTER_INT_POINTER) (gpointer data1, gpointer arg_1, gint arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_VOID__POINTER_INT_POINTER callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__POINTER_INT_POINTER) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_pointer (param_values + 1), g_value_get_int (param_values + 2), g_value_get_pointer (param_values + 3), data2);
}


static void game_class_init (GameClass * klass) {
	game_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GamePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_game_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_game_set_property;
	G_OBJECT_CLASS (klass)->finalize = game_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_WIDTH, g_param_spec_int ("width", "width", "width", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_HEIGHT, g_param_spec_int ("height", "height", "height", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_LEVEL, g_param_spec_int ("level", "level", "level", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_PAUSED, g_param_spec_boolean ("paused", "paused", "paused", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_SHADOW_Y, g_param_spec_int ("shadow-y", "shadow-y", "shadow-y", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("started", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("shape_added", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("shape_moved", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("shape_dropped", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("shape_rotated", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("shape_landed", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__POINTER_INT_POINTER, G_TYPE_NONE, 3, G_TYPE_POINTER, G_TYPE_INT, G_TYPE_POINTER);
	g_signal_new ("pause_changed", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("complete", TYPE_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void game_instance_init (Game * self) {
	self->priv = GAME_GET_PRIVATE (self);
	self->shape = NULL;
	self->next_shape = NULL;
	self->n_lines_destroyed = 0;
	self->score = 0;
	self->priv->starting_level = 1;
	self->priv->pick_difficult_blocks = FALSE;
	self->priv->fast_forward = FALSE;
	self->priv->drop_timeout = (guint) 0;
	self->priv->has_started = FALSE;
	self->priv->_paused = FALSE;
	self->game_over = FALSE;
}


static void game_finalize (GObject* obj) {
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME, Game);
	_g_object_unref0 (self->shape);
	_g_object_unref0 (self->next_shape);
	self->blocks = (_vala_array_free (self->blocks, self->blocks_length1 * self->blocks_length2, (GDestroyNotify) g_object_unref), NULL);
	G_OBJECT_CLASS (game_parent_class)->finalize (obj);
}


GType game_get_type (void) {
	static volatile gsize game_type_id__volatile = 0;
	if (g_once_init_enter (&game_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Game), 0, (GInstanceInitFunc) game_instance_init, NULL };
		GType game_type_id;
		game_type_id = g_type_register_static (G_TYPE_OBJECT, "Game", &g_define_type_info, 0);
		g_once_init_leave (&game_type_id__volatile, game_type_id);
	}
	return game_type_id__volatile;
}


static void _vala_game_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME, Game);
	switch (property_id) {
		case GAME_WIDTH:
		g_value_set_int (value, game_get_width (self));
		break;
		case GAME_HEIGHT:
		g_value_set_int (value, game_get_height (self));
		break;
		case GAME_LEVEL:
		g_value_set_int (value, game_get_level (self));
		break;
		case GAME_PAUSED:
		g_value_set_boolean (value, game_get_paused (self));
		break;
		case GAME_SHADOW_Y:
		g_value_set_int (value, game_get_shadow_y (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_game_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Game * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME, Game);
	switch (property_id) {
		case GAME_PAUSED:
		game_set_paused (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



