/* worm.c generated by valac 0.32.0.32-d07e8, the Vala compiler
 * generated from worm.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 * Gnome Nibbles: Gnome Worm Game
 * Copyright (C) 2015 Iulian-Gabriel Radu <iulian.radu67@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/* This is a fairly literal translation of the GPLv2+ original by*/
/* Sean MacIsaac, Ian Peters, Guillaume Béland.*/

#include <glib.h>
#include <glib-object.h>
#include <string.h>
#include <gee.h>


#define TYPE_WORM_DIRECTION (worm_direction_get_type ())

#define TYPE_POSITION (position_get_type ())
typedef struct _Position Position;

#define TYPE_WORM_PROPERTIES (worm_properties_get_type ())
typedef struct _WormProperties WormProperties;

#define TYPE_WORM (worm_get_type ())
#define WORM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORM, Worm))
#define WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORM, WormClass))
#define IS_WORM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORM))
#define IS_WORM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORM))
#define WORM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORM, WormClass))

typedef struct _Worm Worm;
typedef struct _WormClass WormClass;
typedef struct _WormPrivate WormPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _position_free0(var) ((var == NULL) ? NULL : (var = (position_free (var), NULL)))

#define TYPE_WARP (warp_get_type ())
#define WARP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WARP, Warp))
#define WARP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WARP, WarpClass))
#define IS_WARP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WARP))
#define IS_WARP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WARP))
#define WARP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WARP, WarpClass))

typedef struct _Warp Warp;
typedef struct _WarpClass WarpClass;
typedef struct _WarpPrivate WarpPrivate;
#define _worm_properties_free0(var) ((var == NULL) ? NULL : (var = (worm_properties_free (var), NULL)))

#define TYPE_BONUS_TYPE (bonus_type_get_type ())
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef enum  {
	WORM_DIRECTION_NONE,
	WORM_DIRECTION_RIGHT,
	WORM_DIRECTION_DOWN,
	WORM_DIRECTION_LEFT,
	WORM_DIRECTION_UP
} WormDirection;

struct _Position {
	gint x;
	gint y;
};

struct _WormProperties {
	gint color;
	guint up;
	guint down;
	guint left;
	guint right;
};

struct _Worm {
	GObject parent_instance;
	WormPrivate * priv;
	gboolean is_human;
	gboolean keypress;
	gboolean is_stopped;
	gint change;
	WormDirection direction;
	WormDirection starting_direction;
};

struct _WormClass {
	GObjectClass parent_class;
};

struct _WormPrivate {
	Position _starting_position;
	gint _id;
	gboolean _is_materialized;
	gint rounds_dematerialized;
	gint _lives;
	gint _score;
	GeeArrayQueue* key_queue;
	GeeLinkedList* _list;
};

struct _Warp {
	GObject parent_instance;
	WarpPrivate * priv;
	gint x;
	gint y;
	gint wx;
	gint wy;
};

struct _WarpClass {
	GObjectClass parent_class;
};

typedef enum  {
	BONUS_TYPE_REGULAR,
	BONUS_TYPE_HALF,
	BONUS_TYPE_DOUBLE,
	BONUS_TYPE_LIFE,
	BONUS_TYPE_REVERSE,
	BONUS_TYPE_WARP
} BonusType;


static gpointer worm_parent_class = NULL;
static guint* worm_deadend_board;
static gint worm_deadend_board_length1;
static gint worm_deadend_board_length2;
static guint* worm_deadend_board = NULL;
static gint worm_deadend_board_length1 = 0;
static gint worm_deadend_board_length2 = 0;
static guint worm_deadend_runnumber;
static guint worm_deadend_runnumber = (guint) 0;

GType worm_direction_get_type (void) G_GNUC_CONST;
GType position_get_type (void) G_GNUC_CONST;
Position* position_dup (const Position* self);
void position_free (Position* self);
GType worm_properties_get_type (void) G_GNUC_CONST;
WormProperties* worm_properties_dup (const WormProperties* self);
void worm_properties_free (WormProperties* self);
GType worm_get_type (void) G_GNUC_CONST;
#define WORM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_WORM, WormPrivate))
enum  {
	WORM_DUMMY_PROPERTY,
	WORM_STARTING_POSITION,
	WORM_ID,
	WORM_IS_MATERIALIZED,
	WORM_LIVES,
	WORM_SCORE,
	WORM_LENGTH,
	WORM_HEAD,
	WORM_LIST
};
#define NIBBLES_GAME_WIDTH 92
#define NIBBLES_GAME_HEIGHT 66
#define WORM_STARTING_LENGTH 5
#define WORM_STARTING_LIVES 6
#define WORM_MAX_LIVES 12
#define WORM_GROW_FACTOR 4
Worm* worm_new (gint id);
Worm* worm_construct (GType object_type, gint id);
static void worm_set_id (Worm* self, gint value);
void worm_set_lives (Worm* self, gint value);
void worm_set_score (Worm* self, gint value);
static void worm_set_list (Worm* self, GeeLinkedList* value);
void worm_set_start (Worm* self, gint xhead, gint yhead, WormDirection direction);
GeeLinkedList* worm_get_list (Worm* self);
static void worm_set_starting_position (Worm* self, Position* value);
void worm_get_starting_position (Worm* self, Position* result);
void worm_move (Worm* self, gint* board, int board_length1, int board_length2);
void worm_get_head (Worm* self, Position* result);
#define NIBBLES_GAME_WARPCHAR 'W'
#define NIBBLES_GAME_EMPTYCHAR 'a'
gboolean worm_get_is_materialized (Worm* self);
#define NIBBLES_GAME_WORMCHAR 'w'
gint worm_get_id (Worm* self);
void worm_dequeue_keypress (Worm* self);
static void worm_materialize (Worm* self, gint* board, int board_length1, int board_length2);
void worm_reduce_tail (Worm* self, gint* board, int board_length1, int board_length2, gint erase_size);
void worm_reverse (Worm* self, gint* board, int board_length1, int board_length2);
GType warp_get_type (void) G_GNUC_CONST;
void worm_warp (Worm* self, Warp* warp);
static void worm_set_head (Worm* self, Position* value);
gboolean worm_can_move_to (Worm* self, gint* board, int board_length1, int board_length2, gint numworms);
static void worm_position_move (Worm* self, Position* result);
gboolean worm_will_collide_with_head (Worm* self, Worm* other_worm);
static gboolean _position_equal (const Position* s1, const Position* s2);
void worm_spawn (Worm* self, gint* board, int board_length1, int board_length2);
static void worm_set_is_materialized (Worm* self, gboolean value);
void worm_dematerialize (Worm* self, gint* board, int board_length1, int board_length2, gint rounds);
void worm_add_life (Worm* self);
gint worm_get_lives (Worm* self);
static void worm_lose_life (Worm* self);
void worm_reset (Worm* self, gint* board, int board_length1, int board_length2);
static void worm_direction_set (Worm* self, WormDirection dir);
void worm_queue_keypress (Worm* self, WormDirection dir);
static guint worm_upper_key (Worm* self, guint keyval);
void worm_handle_direction (Worm* self, WormDirection dir);
gboolean worm_handle_keypress (Worm* self, guint keyval, GeeHashMap* worm_props);
static gint worm_ai_deadend (gint* board, int board_length1, int board_length2, gint numworms, gint x, gint y, gint length_left);
static gint worm_ai_deadend_after (gint* board, int board_length1, int board_length2, GeeLinkedList* worms, gint numworms, gint x, gint y, gint dir, gint length);
static gboolean worm_ai_too_close (Worm* self, GeeLinkedList* worms, gint numworms);
static gboolean worm_ai_wander (gint* board, int board_length1, int board_length2, gint numworms, gint x, gint y, gint dir, gint ox, gint oy);
GType bonus_type_get_type (void) G_GNUC_CONST;
void worm_ai_move (Worm* self, gint* board, int board_length1, int board_length2, gint numworms, GeeLinkedList* worms);
#define NIBBLES_GAME_CAPACITY (NIBBLES_GAME_WIDTH * NIBBLES_GAME_HEIGHT)
gint worm_get_length (Worm* self);
gint worm_get_score (Worm* self);
void worm_set_length (Worm* self, gint value);
static void worm_finalize (GObject* obj);
static void _vala_worm_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_worm_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GType worm_direction_get_type (void) {
	static volatile gsize worm_direction_type_id__volatile = 0;
	if (g_once_init_enter (&worm_direction_type_id__volatile)) {
		static const GEnumValue values[] = {{WORM_DIRECTION_NONE, "WORM_DIRECTION_NONE", "none"}, {WORM_DIRECTION_RIGHT, "WORM_DIRECTION_RIGHT", "right"}, {WORM_DIRECTION_DOWN, "WORM_DIRECTION_DOWN", "down"}, {WORM_DIRECTION_LEFT, "WORM_DIRECTION_LEFT", "left"}, {WORM_DIRECTION_UP, "WORM_DIRECTION_UP", "up"}, {0, NULL, NULL}};
		GType worm_direction_type_id;
		worm_direction_type_id = g_enum_register_static ("WormDirection", values);
		g_once_init_leave (&worm_direction_type_id__volatile, worm_direction_type_id);
	}
	return worm_direction_type_id__volatile;
}


Position* position_dup (const Position* self) {
	Position* dup;
#line 31 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	dup = g_new0 (Position, 1);
#line 31 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	memcpy (dup, self, sizeof (Position));
#line 31 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	return dup;
#line 251 "worm.c"
}


void position_free (Position* self) {
#line 31 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_free (self);
#line 258 "worm.c"
}


GType position_get_type (void) {
	static volatile gsize position_type_id__volatile = 0;
	if (g_once_init_enter (&position_type_id__volatile)) {
		GType position_type_id;
		position_type_id = g_boxed_type_register_static ("Position", (GBoxedCopyFunc) position_dup, (GBoxedFreeFunc) position_free);
		g_once_init_leave (&position_type_id__volatile, position_type_id);
	}
	return position_type_id__volatile;
}


WormProperties* worm_properties_dup (const WormProperties* self) {
	WormProperties* dup;
#line 37 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	dup = g_new0 (WormProperties, 1);
#line 37 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	memcpy (dup, self, sizeof (WormProperties));
#line 37 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	return dup;
#line 281 "worm.c"
}


void worm_properties_free (WormProperties* self) {
#line 37 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_free (self);
#line 288 "worm.c"
}


GType worm_properties_get_type (void) {
	static volatile gsize worm_properties_type_id__volatile = 0;
	if (g_once_init_enter (&worm_properties_type_id__volatile)) {
		GType worm_properties_type_id;
		worm_properties_type_id = g_boxed_type_register_static ("WormProperties", (GBoxedCopyFunc) worm_properties_dup, (GBoxedFreeFunc) worm_properties_free);
		g_once_init_leave (&worm_properties_type_id__volatile, worm_properties_type_id);
	}
	return worm_properties_type_id__volatile;
}


Worm* worm_construct (GType object_type, gint id) {
	Worm * self = NULL;
	gint _tmp0_ = 0;
	GeeLinkedList* _tmp1_ = NULL;
	GeeLinkedList* _tmp2_ = NULL;
	GeeArrayQueue* _tmp3_ = NULL;
#line 106 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	self = (Worm*) g_object_new (object_type, NULL);
#line 108 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp0_ = id;
#line 108 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	worm_set_id (self, _tmp0_);
#line 109 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	worm_set_lives (self, WORM_STARTING_LIVES);
#line 110 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	worm_set_score (self, 0);
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	self->change = 0;
#line 112 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp1_ = gee_linked_list_new (TYPE_POSITION, (GBoxedCopyFunc) position_dup, position_free, NULL, NULL, NULL);
#line 112 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp2_ = _tmp1_;
#line 112 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	worm_set_list (self, _tmp2_);
#line 112 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_g_object_unref0 (_tmp2_);
#line 113 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp3_ = gee_array_queue_new (TYPE_WORM_DIRECTION, NULL, NULL, NULL, NULL, NULL);
#line 113 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_g_object_unref0 (self->priv->key_queue);
#line 113 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	self->priv->key_queue = _tmp3_;
#line 106 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	return self;
#line 337 "worm.c"
}


Worm* worm_new (gint id) {
#line 106 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	return worm_construct (TYPE_WORM, id);
#line 344 "worm.c"
}


void worm_set_start (Worm* self, gint xhead, gint yhead, WormDirection direction) {
	GeeLinkedList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	Position _tmp3_ = {0};
	GeeLinkedList* _tmp4_ = NULL;
	Position _tmp5_ = {0};
	WormDirection _tmp6_ = 0;
	WormDirection _tmp7_ = 0;
	GeeArrayQueue* _tmp8_ = NULL;
#line 116 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_return_if_fail (self != NULL);
#line 118 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp0_ = self->priv->_list;
#line 118 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
#line 120 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp1_ = xhead;
#line 120 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp2_ = yhead;
#line 120 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	memset (&_tmp3_, 0, sizeof (Position));
#line 120 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp3_.x = _tmp1_;
#line 120 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp3_.y = _tmp2_;
#line 120 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	worm_set_starting_position (self, &_tmp3_);
#line 125 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp4_ = self->priv->_list;
#line 125 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp5_ = self->priv->_starting_position;
#line 125 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp4_, &_tmp5_);
#line 127 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp6_ = direction;
#line 127 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	self->starting_direction = _tmp6_;
#line 128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp7_ = self->starting_direction;
#line 128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	self->direction = _tmp7_;
#line 129 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	self->change = 0;
#line 130 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp8_ = self->priv->key_queue;
#line 130 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp8_);
#line 396 "worm.c"
}


void worm_move (Worm* self, gint* board, int board_length1, int board_length2) {
	gboolean _tmp0_ = FALSE;
	Position position = {0};
	Position _tmp1_ = {0};
	Position _tmp2_ = {0};
	WormDirection _tmp3_ = 0;
	GeeLinkedList* _tmp36_ = NULL;
	Position _tmp37_ = {0};
	gint* _tmp38_ = NULL;
	gint _tmp38__length1 = 0;
	gint _tmp38__length2 = 0;
	Position _tmp39_ = {0};
	Position _tmp40_ = {0};
	gint _tmp41_ = 0;
	Position _tmp42_ = {0};
	Position _tmp43_ = {0};
	gint _tmp44_ = 0;
	gint _tmp45_ = 0;
	gint _tmp46_ = 0;
	gint* _tmp61_ = NULL;
	gint _tmp61__length1 = 0;
	gint _tmp61__length2 = 0;
	Position _tmp62_ = {0};
	Position _tmp63_ = {0};
	gint _tmp64_ = 0;
	Position _tmp65_ = {0};
	Position _tmp66_ = {0};
	gint _tmp67_ = 0;
	gint _tmp68_ = 0;
	gboolean _tmp69_ = FALSE;
	GeeArrayQueue* _tmp80_ = NULL;
	gboolean _tmp81_ = FALSE;
	gboolean _tmp82_ = FALSE;
	gint _tmp83_ = 0;
#line 133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_return_if_fail (self != NULL);
#line 135 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp0_ = self->is_human;
#line 135 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp0_) {
#line 136 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		self->keypress = FALSE;
#line 442 "worm.c"
	}
#line 138 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	worm_get_head (self, &_tmp1_);
#line 138 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp2_ = _tmp1_;
#line 138 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	position = _tmp2_;
#line 139 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp3_ = self->direction;
#line 139 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	switch (_tmp3_) {
#line 139 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		case WORM_DIRECTION_UP:
#line 456 "worm.c"
		{
			Position _tmp4_ = {0};
			Position _tmp5_ = {0};
			Position _tmp6_ = {0};
			Position _tmp7_ = {0};
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			Position _tmp10_ = {0};
			gint _tmp11_ = 0;
#line 142 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			worm_get_head (self, &_tmp4_);
#line 142 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp5_ = _tmp4_;
#line 142 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			worm_get_head (self, &_tmp6_);
#line 142 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp7_ = _tmp6_;
#line 142 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp8_ = _tmp7_.y;
#line 142 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp7_.y = _tmp8_ - 1;
#line 142 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp9_ = _tmp7_.y;
#line 142 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			position.y = _tmp9_;
#line 143 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp10_ = position;
#line 143 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp11_ = _tmp10_.y;
#line 143 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			if (_tmp11_ < 0) {
#line 144 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				position.y = NIBBLES_GAME_HEIGHT - 1;
#line 490 "worm.c"
			}
#line 145 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			break;
#line 494 "worm.c"
		}
#line 139 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		case WORM_DIRECTION_DOWN:
#line 498 "worm.c"
		{
			Position _tmp12_ = {0};
			Position _tmp13_ = {0};
			Position _tmp14_ = {0};
			Position _tmp15_ = {0};
			gint _tmp16_ = 0;
			gint _tmp17_ = 0;
			Position _tmp18_ = {0};
			gint _tmp19_ = 0;
#line 147 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			worm_get_head (self, &_tmp12_);
#line 147 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp13_ = _tmp12_;
#line 147 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			worm_get_head (self, &_tmp14_);
#line 147 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp15_ = _tmp14_;
#line 147 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp16_ = _tmp15_.y;
#line 147 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp15_.y = _tmp16_ + 1;
#line 147 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp17_ = _tmp15_.y;
#line 147 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			position.y = _tmp17_;
#line 148 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp18_ = position;
#line 148 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp19_ = _tmp18_.y;
#line 148 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			if (_tmp19_ >= NIBBLES_GAME_HEIGHT) {
#line 149 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				position.y = 0;
#line 532 "worm.c"
			}
#line 150 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			break;
#line 536 "worm.c"
		}
#line 139 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		case WORM_DIRECTION_LEFT:
#line 540 "worm.c"
		{
			Position _tmp20_ = {0};
			Position _tmp21_ = {0};
			Position _tmp22_ = {0};
			Position _tmp23_ = {0};
			gint _tmp24_ = 0;
			gint _tmp25_ = 0;
			Position _tmp26_ = {0};
			gint _tmp27_ = 0;
#line 152 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			worm_get_head (self, &_tmp20_);
#line 152 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp21_ = _tmp20_;
#line 152 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			worm_get_head (self, &_tmp22_);
#line 152 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp23_ = _tmp22_;
#line 152 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp24_ = _tmp23_.x;
#line 152 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp23_.x = _tmp24_ - 1;
#line 152 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp25_ = _tmp23_.x;
#line 152 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			position.x = _tmp25_;
#line 153 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp26_ = position;
#line 153 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp27_ = _tmp26_.x;
#line 153 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			if (_tmp27_ < 0) {
#line 154 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				position.x = NIBBLES_GAME_WIDTH - 1;
#line 574 "worm.c"
			}
#line 155 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			break;
#line 578 "worm.c"
		}
#line 139 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		case WORM_DIRECTION_RIGHT:
#line 582 "worm.c"
		{
			Position _tmp28_ = {0};
			Position _tmp29_ = {0};
			Position _tmp30_ = {0};
			Position _tmp31_ = {0};
			gint _tmp32_ = 0;
			gint _tmp33_ = 0;
			Position _tmp34_ = {0};
			gint _tmp35_ = 0;
#line 157 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			worm_get_head (self, &_tmp28_);
#line 157 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp29_ = _tmp28_;
#line 157 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			worm_get_head (self, &_tmp30_);
#line 157 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp31_ = _tmp30_;
#line 157 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp32_ = _tmp31_.x;
#line 157 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp31_.x = _tmp32_ + 1;
#line 157 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp33_ = _tmp31_.x;
#line 157 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			position.x = _tmp33_;
#line 158 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp34_ = position;
#line 158 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp35_ = _tmp34_.x;
#line 158 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			if (_tmp35_ >= NIBBLES_GAME_WIDTH) {
#line 159 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				position.x = 0;
#line 616 "worm.c"
			}
#line 160 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			break;
#line 620 "worm.c"
		}
		default:
		{
#line 162 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			break;
#line 626 "worm.c"
		}
	}
#line 166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp36_ = self->priv->_list;
#line 166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp37_ = position;
#line 166 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	gee_deque_offer_head ((GeeDeque*) _tmp36_, &_tmp37_);
#line 168 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp38_ = board;
#line 168 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp38__length1 = board_length1;
#line 168 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp38__length2 = board_length2;
#line 168 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	worm_get_head (self, &_tmp39_);
#line 168 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp40_ = _tmp39_;
#line 168 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp41_ = _tmp40_.x;
#line 168 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	worm_get_head (self, &_tmp42_);
#line 168 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp43_ = _tmp42_;
#line 168 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp44_ = _tmp43_.y;
#line 168 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp45_ = _tmp38_[(_tmp41_ * _tmp38__length2) + _tmp44_];
#line 168 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp45_ == ((gint) NIBBLES_GAME_WARPCHAR)) {
#line 169 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		g_signal_emit_by_name (self, "warp-found");
#line 659 "worm.c"
	}
#line 171 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp46_ = self->change;
#line 171 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp46_ > 0) {
#line 665 "worm.c"
		gint _tmp47_ = 0;
#line 173 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp47_ = self->change;
#line 173 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		self->change = _tmp47_ - 1;
#line 174 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		g_signal_emit_by_name (self, "added");
#line 673 "worm.c"
	} else {
		gint* _tmp48_ = NULL;
		gint _tmp48__length1 = 0;
		gint _tmp48__length2 = 0;
		GeeLinkedList* _tmp49_ = NULL;
		gpointer _tmp50_ = NULL;
		Position* _tmp51_ = NULL;
		gint _tmp52_ = 0;
		GeeLinkedList* _tmp53_ = NULL;
		gpointer _tmp54_ = NULL;
		Position* _tmp55_ = NULL;
		gint _tmp56_ = 0;
		gint _tmp57_ = 0;
		GeeLinkedList* _tmp58_ = NULL;
		gpointer _tmp59_ = NULL;
		Position* _tmp60_ = NULL;
#line 178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp48_ = board;
#line 178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp48__length1 = board_length1;
#line 178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp48__length2 = board_length2;
#line 178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp49_ = self->priv->_list;
#line 178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp50_ = gee_linked_list_last (_tmp49_);
#line 178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp51_ = (Position*) _tmp50_;
#line 178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp52_ = (*_tmp51_).x;
#line 178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp53_ = self->priv->_list;
#line 178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp54_ = gee_linked_list_last (_tmp53_);
#line 178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp55_ = (Position*) _tmp54_;
#line 178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp56_ = (*_tmp55_).y;
#line 178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp48_[(_tmp52_ * _tmp48__length2) + _tmp56_] = (gint) NIBBLES_GAME_EMPTYCHAR;
#line 178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp57_ = _tmp48_[(_tmp52_ * _tmp48__length2) + _tmp56_];
#line 178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_position_free0 (_tmp55_);
#line 178 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_position_free0 (_tmp51_);
#line 179 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp58_ = self->priv->_list;
#line 179 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp59_ = gee_deque_poll_tail ((GeeDeque*) _tmp58_);
#line 179 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp60_ = (Position*) _tmp59_;
#line 179 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_position_free0 (_tmp60_);
#line 180 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		g_signal_emit_by_name (self, "moved");
#line 730 "worm.c"
	}
#line 184 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp61_ = board;
#line 184 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp61__length1 = board_length1;
#line 184 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp61__length2 = board_length2;
#line 184 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	worm_get_head (self, &_tmp62_);
#line 184 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp63_ = _tmp62_;
#line 184 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp64_ = _tmp63_.x;
#line 184 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	worm_get_head (self, &_tmp65_);
#line 184 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp66_ = _tmp65_;
#line 184 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp67_ = _tmp66_.y;
#line 184 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp68_ = _tmp61_[(_tmp64_ * _tmp61__length2) + _tmp67_];
#line 184 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp68_ != ((gint) NIBBLES_GAME_EMPTYCHAR)) {
#line 185 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		g_signal_emit_by_name (self, "bonus-found");
#line 756 "worm.c"
	}
#line 188 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp69_ = self->priv->_is_materialized;
#line 188 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp69_) {
#line 762 "worm.c"
		gint* _tmp70_ = NULL;
		gint _tmp70__length1 = 0;
		gint _tmp70__length2 = 0;
		Position _tmp71_ = {0};
		Position _tmp72_ = {0};
		gint _tmp73_ = 0;
		Position _tmp74_ = {0};
		Position _tmp75_ = {0};
		gint _tmp76_ = 0;
		gint _tmp77_ = 0;
		gint _tmp78_ = 0;
#line 189 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp70_ = board;
#line 189 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp70__length1 = board_length1;
#line 189 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp70__length2 = board_length2;
#line 189 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		worm_get_head (self, &_tmp71_);
#line 189 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp72_ = _tmp71_;
#line 189 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp73_ = _tmp72_.x;
#line 189 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		worm_get_head (self, &_tmp74_);
#line 189 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp75_ = _tmp74_;
#line 189 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp76_ = _tmp75_.y;
#line 189 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp77_ = self->priv->_id;
#line 189 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp70_[(_tmp73_ * _tmp70__length2) + _tmp76_] = NIBBLES_GAME_WORMCHAR + _tmp77_;
#line 189 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp78_ = _tmp70_[(_tmp73_ * _tmp70__length2) + _tmp76_];
#line 798 "worm.c"
	} else {
		gint _tmp79_ = 0;
#line 191 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp79_ = self->priv->rounds_dematerialized;
#line 191 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		self->priv->rounds_dematerialized = _tmp79_ - 1;
#line 805 "worm.c"
	}
#line 193 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp80_ = self->priv->key_queue;
#line 193 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp81_ = gee_array_queue_get_is_empty (_tmp80_);
#line 193 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp82_ = _tmp81_;
#line 193 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (!_tmp82_) {
#line 194 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		worm_dequeue_keypress (self);
#line 817 "worm.c"
	}
#line 196 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp83_ = self->priv->rounds_dematerialized;
#line 196 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp83_ == 1) {
#line 823 "worm.c"
		gint* _tmp84_ = NULL;
		gint _tmp84__length1 = 0;
		gint _tmp84__length2 = 0;
#line 197 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp84_ = board;
#line 197 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp84__length1 = board_length1;
#line 197 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp84__length2 = board_length2;
#line 197 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		worm_materialize (self, _tmp84_, _tmp84__length1, _tmp84__length2);
#line 835 "worm.c"
	}
}


void worm_reduce_tail (Worm* self, gint* board, int board_length1, int board_length2, gint erase_size) {
	gint _tmp0_ = 0;
#line 200 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_return_if_fail (self != NULL);
#line 202 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp0_ = erase_size;
#line 202 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp0_ > 0) {
#line 848 "worm.c"
		gint _tmp18_ = 0;
		{
			gint i = 0;
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			i = 0;
#line 854 "worm.c"
			{
				gboolean _tmp1_ = FALSE;
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp1_ = TRUE;
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				while (TRUE) {
#line 861 "worm.c"
					gint _tmp3_ = 0;
					gint _tmp4_ = 0;
					gint* _tmp5_ = NULL;
					gint _tmp5__length1 = 0;
					gint _tmp5__length2 = 0;
					GeeLinkedList* _tmp6_ = NULL;
					gpointer _tmp7_ = NULL;
					Position* _tmp8_ = NULL;
					gint _tmp9_ = 0;
					GeeLinkedList* _tmp10_ = NULL;
					gpointer _tmp11_ = NULL;
					Position* _tmp12_ = NULL;
					gint _tmp13_ = 0;
					gint _tmp14_ = 0;
					GeeLinkedList* _tmp15_ = NULL;
					gpointer _tmp16_ = NULL;
					Position* _tmp17_ = NULL;
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					if (!_tmp1_) {
#line 881 "worm.c"
						gint _tmp2_ = 0;
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
						_tmp2_ = i;
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
						i = _tmp2_ + 1;
#line 887 "worm.c"
					}
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp1_ = FALSE;
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp3_ = i;
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp4_ = erase_size;
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					if (!(_tmp3_ < _tmp4_)) {
#line 204 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
						break;
#line 899 "worm.c"
					}
#line 206 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp5_ = board;
#line 206 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp5__length1 = board_length1;
#line 206 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp5__length2 = board_length2;
#line 206 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp6_ = self->priv->_list;
#line 206 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp7_ = gee_linked_list_last (_tmp6_);
#line 206 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp8_ = (Position*) _tmp7_;
#line 206 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp9_ = (*_tmp8_).x;
#line 206 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp10_ = self->priv->_list;
#line 206 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp11_ = gee_linked_list_last (_tmp10_);
#line 206 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp12_ = (Position*) _tmp11_;
#line 206 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp13_ = (*_tmp12_).y;
#line 206 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp5_[(_tmp9_ * _tmp5__length2) + _tmp13_] = (gint) NIBBLES_GAME_EMPTYCHAR;
#line 206 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp14_ = _tmp5_[(_tmp9_ * _tmp5__length2) + _tmp13_];
#line 206 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_position_free0 (_tmp12_);
#line 206 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_position_free0 (_tmp8_);
#line 207 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp15_ = self->priv->_list;
#line 207 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp16_ = gee_deque_poll_tail ((GeeDeque*) _tmp15_);
#line 207 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp17_ = (Position*) _tmp16_;
#line 207 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_position_free0 (_tmp17_);
#line 939 "worm.c"
				}
			}
		}
#line 209 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp18_ = erase_size;
#line 209 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		g_signal_emit_by_name (self, "tail-reduced", _tmp18_);
#line 947 "worm.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	return self ? g_object_ref (self) : NULL;
#line 955 "worm.c"
}


void worm_reverse (Worm* self, gint* board, int board_length1, int board_length2) {
	GeeLinkedList* reversed_list = NULL;
	GeeLinkedList* _tmp0_ = NULL;
	GeeLinkedList* _tmp14_ = NULL;
	GeeLinkedList* _tmp15_ = NULL;
	gpointer _tmp16_ = NULL;
	Position* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	GeeLinkedList* _tmp19_ = NULL;
	gpointer _tmp20_ = NULL;
	Position* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	gboolean _tmp23_ = FALSE;
#line 213 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_return_if_fail (self != NULL);
#line 215 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp0_ = gee_linked_list_new (TYPE_POSITION, (GBoxedCopyFunc) position_dup, position_free, NULL, NULL, NULL);
#line 215 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	reversed_list = _tmp0_;
#line 978 "worm.c"
	{
		GeeLinkedList* _pos_list = NULL;
		GeeLinkedList* _tmp1_ = NULL;
		GeeLinkedList* _tmp2_ = NULL;
		gint _pos_size = 0;
		GeeLinkedList* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _pos_index = 0;
#line 216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp1_ = self->priv->_list;
#line 216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_pos_list = _tmp2_;
#line 216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp3_ = _pos_list;
#line 216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
#line 216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp5_ = _tmp4_;
#line 216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_pos_size = _tmp5_;
#line 216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_pos_index = -1;
#line 216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		while (TRUE) {
#line 1006 "worm.c"
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			Position* pos = NULL;
			GeeLinkedList* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gpointer _tmp11_ = NULL;
			GeeLinkedList* _tmp12_ = NULL;
			Position* _tmp13_ = NULL;
#line 216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp6_ = _pos_index;
#line 216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_pos_index = _tmp6_ + 1;
#line 216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp7_ = _pos_index;
#line 216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp8_ = _pos_size;
#line 216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			if (!(_tmp7_ < _tmp8_)) {
#line 216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				break;
#line 1028 "worm.c"
			}
#line 216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp9_ = _pos_list;
#line 216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp10_ = _pos_index;
#line 216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
#line 216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			pos = (Position*) _tmp11_;
#line 217 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp12_ = reversed_list;
#line 217 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp13_ = pos;
#line 217 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			gee_deque_offer_head ((GeeDeque*) _tmp12_, _tmp13_);
#line 216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_position_free0 (pos);
#line 1046 "worm.c"
		}
#line 216 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_g_object_unref0 (_pos_list);
#line 1050 "worm.c"
	}
#line 219 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_signal_emit_by_name (self, "reversed");
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp14_ = reversed_list;
#line 220 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	worm_set_list (self, _tmp14_);
#line 223 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp15_ = self->priv->_list;
#line 223 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, 0);
#line 223 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp17_ = (Position*) _tmp16_;
#line 223 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp18_ = (*_tmp17_).y;
#line 223 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp19_ = self->priv->_list;
#line 223 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, 1);
#line 223 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp21_ = (Position*) _tmp20_;
#line 223 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp22_ = (*_tmp21_).y;
#line 223 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp23_ = _tmp18_ == _tmp22_;
#line 223 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_position_free0 (_tmp21_);
#line 223 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_position_free0 (_tmp17_);
#line 223 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp23_) {
#line 1082 "worm.c"
		WormDirection _tmp24_ = 0;
		GeeLinkedList* _tmp25_ = NULL;
		gpointer _tmp26_ = NULL;
		Position* _tmp27_ = NULL;
		gint _tmp28_ = 0;
		GeeLinkedList* _tmp29_ = NULL;
		gpointer _tmp30_ = NULL;
		Position* _tmp31_ = NULL;
		gint _tmp32_ = 0;
		gboolean _tmp33_ = FALSE;
#line 224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp25_ = self->priv->_list;
#line 224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp26_ = gee_abstract_list_get ((GeeAbstractList*) _tmp25_, 0);
#line 224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp27_ = (Position*) _tmp26_;
#line 224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp28_ = (*_tmp27_).x;
#line 224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp29_ = self->priv->_list;
#line 224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp30_ = gee_abstract_list_get ((GeeAbstractList*) _tmp29_, 1);
#line 224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp31_ = (Position*) _tmp30_;
#line 224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp32_ = (*_tmp31_).x;
#line 224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp33_ = _tmp28_ > _tmp32_;
#line 224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_position_free0 (_tmp31_);
#line 224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_position_free0 (_tmp27_);
#line 224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		if (_tmp33_) {
#line 224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp24_ = WORM_DIRECTION_RIGHT;
#line 1119 "worm.c"
		} else {
#line 224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp24_ = WORM_DIRECTION_LEFT;
#line 1123 "worm.c"
		}
#line 224 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		self->direction = _tmp24_;
#line 1127 "worm.c"
	} else {
		WormDirection _tmp34_ = 0;
		GeeLinkedList* _tmp35_ = NULL;
		gpointer _tmp36_ = NULL;
		Position* _tmp37_ = NULL;
		gint _tmp38_ = 0;
		GeeLinkedList* _tmp39_ = NULL;
		gpointer _tmp40_ = NULL;
		Position* _tmp41_ = NULL;
		gint _tmp42_ = 0;
		gboolean _tmp43_ = FALSE;
#line 226 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp35_ = self->priv->_list;
#line 226 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp36_ = gee_abstract_list_get ((GeeAbstractList*) _tmp35_, 0);
#line 226 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp37_ = (Position*) _tmp36_;
#line 226 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp38_ = (*_tmp37_).y;
#line 226 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp39_ = self->priv->_list;
#line 226 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp40_ = gee_abstract_list_get ((GeeAbstractList*) _tmp39_, 1);
#line 226 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp41_ = (Position*) _tmp40_;
#line 226 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp42_ = (*_tmp41_).y;
#line 226 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp43_ = _tmp38_ > _tmp42_;
#line 226 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_position_free0 (_tmp41_);
#line 226 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_position_free0 (_tmp37_);
#line 226 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		if (_tmp43_) {
#line 226 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp34_ = WORM_DIRECTION_DOWN;
#line 1165 "worm.c"
		} else {
#line 226 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp34_ = WORM_DIRECTION_UP;
#line 1169 "worm.c"
		}
#line 226 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		self->direction = _tmp34_;
#line 1173 "worm.c"
	}
#line 213 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_g_object_unref0 (reversed_list);
#line 1177 "worm.c"
}


void worm_warp (Worm* self, Warp* warp) {
	Warp* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	Warp* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	Position _tmp4_ = {0};
#line 229 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_return_if_fail (self != NULL);
#line 229 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_return_if_fail (warp != NULL);
#line 231 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp0_ = warp;
#line 231 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp1_ = _tmp0_->wx;
#line 231 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp2_ = warp;
#line 231 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp3_ = _tmp2_->wy;
#line 231 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	memset (&_tmp4_, 0, sizeof (Position));
#line 231 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp4_.x = _tmp1_;
#line 231 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp4_.y = _tmp3_;
#line 231 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	worm_set_head (self, &_tmp4_);
#line 1207 "worm.c"
}


gboolean worm_can_move_to (Worm* self, gint* board, int board_length1, int board_length2, gint numworms) {
	gboolean result = FALSE;
	Position position = {0};
	Position _tmp0_ = {0};
	gint next_position = 0;
	gint* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint _tmp1__length2 = 0;
	Position _tmp2_ = {0};
	gint _tmp3_ = 0;
	Position _tmp4_ = {0};
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gboolean _tmp7_ = FALSE;
	gint _tmp8_ = 0;
	gboolean _tmp10_ = FALSE;
	gint _tmp11_ = 0;
#line 234 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 236 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	worm_position_move (self, &_tmp0_);
#line 236 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	position = _tmp0_;
#line 237 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp1_ = board;
#line 237 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp1__length1 = board_length1;
#line 237 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp1__length2 = board_length2;
#line 237 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp2_ = position;
#line 237 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp3_ = _tmp2_.x;
#line 237 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp4_ = position;
#line 237 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp5_ = _tmp4_.y;
#line 237 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp6_ = _tmp1_[(_tmp3_ * _tmp1__length2) + _tmp5_];
#line 237 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	next_position = _tmp6_;
#line 239 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp8_ = next_position;
#line 239 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp8_ > ((gint) NIBBLES_GAME_EMPTYCHAR)) {
#line 1256 "worm.c"
		gint _tmp9_ = 0;
#line 240 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp9_ = next_position;
#line 240 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp7_ = _tmp9_ < ((gint) NIBBLES_GAME_WORMCHAR);
#line 1262 "worm.c"
	} else {
#line 239 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp7_ = FALSE;
#line 1266 "worm.c"
	}
#line 239 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp7_) {
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		result = FALSE;
#line 241 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		return result;
#line 1274 "worm.c"
	}
#line 243 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp11_ = next_position;
#line 243 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp11_ >= ((gint) NIBBLES_GAME_WORMCHAR)) {
#line 1280 "worm.c"
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
#line 244 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp12_ = next_position;
#line 244 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp13_ = numworms;
#line 244 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp10_ = _tmp12_ < (NIBBLES_GAME_WORMCHAR + _tmp13_);
#line 1289 "worm.c"
	} else {
#line 243 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp10_ = FALSE;
#line 1293 "worm.c"
	}
#line 243 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp10_) {
#line 1297 "worm.c"
		gboolean _tmp14_ = FALSE;
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp14_ = self->priv->_is_materialized;
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		result = !_tmp14_;
#line 245 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		return result;
#line 1305 "worm.c"
	}
#line 247 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	result = TRUE;
#line 247 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	return result;
#line 1311 "worm.c"
}


static gboolean _position_equal (const Position* s1, const Position* s2) {
#line 258 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (s1 == s2) {
#line 258 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		return TRUE;
#line 1320 "worm.c"
	}
#line 258 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (s1 == NULL) {
#line 258 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		return FALSE;
#line 1326 "worm.c"
	}
#line 258 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (s2 == NULL) {
#line 258 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		return FALSE;
#line 1332 "worm.c"
	}
#line 258 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (s1->x != s2->x) {
#line 258 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		return FALSE;
#line 1338 "worm.c"
	}
#line 258 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (s1->y != s2->y) {
#line 258 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		return FALSE;
#line 1344 "worm.c"
	}
#line 258 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	return TRUE;
#line 1348 "worm.c"
}


gboolean worm_will_collide_with_head (Worm* self, Worm* other_worm) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Position worm_pos = {0};
	Position _tmp4_ = {0};
	Position other_worm_pos = {0};
	Worm* _tmp5_ = NULL;
	Position _tmp6_ = {0};
	Position _tmp7_ = {0};
	Position _tmp8_ = {0};
#line 250 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 250 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_return_val_if_fail (other_worm != NULL, FALSE);
#line 252 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp1_ = self->priv->_is_materialized;
#line 252 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (!_tmp1_) {
#line 252 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp0_ = TRUE;
#line 1373 "worm.c"
	} else {
		Worm* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 252 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp2_ = other_worm;
#line 252 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp3_ = _tmp2_->priv->_is_materialized;
#line 252 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp0_ = !_tmp3_;
#line 1383 "worm.c"
	}
#line 252 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp0_) {
#line 253 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		result = FALSE;
#line 253 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		return result;
#line 1391 "worm.c"
	}
#line 255 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	worm_position_move (self, &_tmp4_);
#line 255 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	worm_pos = _tmp4_;
#line 256 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp5_ = other_worm;
#line 256 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	worm_position_move (_tmp5_, &_tmp6_);
#line 256 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	other_worm_pos = _tmp6_;
#line 258 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp7_ = worm_pos;
#line 258 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp8_ = other_worm_pos;
#line 258 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_position_equal (&_tmp7_, &_tmp8_) == TRUE) {
#line 259 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		result = TRUE;
#line 259 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		return result;
#line 1413 "worm.c"
	}
#line 261 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	result = FALSE;
#line 261 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	return result;
#line 1419 "worm.c"
}


void worm_spawn (Worm* self, gint* board, int board_length1, int board_length2) {
#line 264 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_return_if_fail (self != NULL);
#line 266 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	self->change = WORM_STARTING_LENGTH - 1;
#line 1428 "worm.c"
	{
		gint i = 0;
#line 267 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		i = 0;
#line 1433 "worm.c"
		{
			gboolean _tmp0_ = FALSE;
#line 267 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp0_ = TRUE;
#line 267 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			while (TRUE) {
#line 1440 "worm.c"
				gint _tmp2_ = 0;
				gint* _tmp3_ = NULL;
				gint _tmp3__length1 = 0;
				gint _tmp3__length2 = 0;
#line 267 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				if (!_tmp0_) {
#line 1447 "worm.c"
					gint _tmp1_ = 0;
#line 267 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp1_ = i;
#line 267 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					i = _tmp1_ + 1;
#line 1453 "worm.c"
				}
#line 267 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp0_ = FALSE;
#line 267 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp2_ = i;
#line 267 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				if (!(_tmp2_ < WORM_STARTING_LENGTH)) {
#line 267 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					break;
#line 1463 "worm.c"
				}
#line 268 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp3_ = board;
#line 268 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp3__length1 = board_length1;
#line 268 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp3__length2 = board_length2;
#line 268 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				worm_move (self, _tmp3_, _tmp3__length1, _tmp3__length2);
#line 1473 "worm.c"
			}
		}
	}
}


static void worm_materialize (Worm* self, gint* board, int board_length1, int board_length2) {
#line 271 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_return_if_fail (self != NULL);
#line 1483 "worm.c"
	{
		GeeLinkedList* _pos_list = NULL;
		GeeLinkedList* _tmp0_ = NULL;
		GeeLinkedList* _tmp1_ = NULL;
		gint _pos_size = 0;
		GeeLinkedList* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _pos_index = 0;
#line 273 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp0_ = self->priv->_list;
#line 273 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp1_ = _g_object_ref0 (_tmp0_);
#line 273 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_pos_list = _tmp1_;
#line 273 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp2_ = _pos_list;
#line 273 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp3_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp2_);
#line 273 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp4_ = _tmp3_;
#line 273 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_pos_size = _tmp4_;
#line 273 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_pos_index = -1;
#line 273 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		while (TRUE) {
#line 1511 "worm.c"
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			Position* pos = NULL;
			GeeLinkedList* _tmp8_ = NULL;
			gint _tmp9_ = 0;
			gpointer _tmp10_ = NULL;
			gint* _tmp11_ = NULL;
			gint _tmp11__length1 = 0;
			gint _tmp11__length2 = 0;
			Position* _tmp12_ = NULL;
			gint _tmp13_ = 0;
			Position* _tmp14_ = NULL;
			gint _tmp15_ = 0;
			gint _tmp16_ = 0;
#line 273 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp5_ = _pos_index;
#line 273 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_pos_index = _tmp5_ + 1;
#line 273 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp6_ = _pos_index;
#line 273 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp7_ = _pos_size;
#line 273 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			if (!(_tmp6_ < _tmp7_)) {
#line 273 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				break;
#line 1539 "worm.c"
			}
#line 273 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp8_ = _pos_list;
#line 273 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp9_ = _pos_index;
#line 273 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tmp9_);
#line 273 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			pos = (Position*) _tmp10_;
#line 275 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp11_ = board;
#line 275 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp11__length1 = board_length1;
#line 275 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp11__length2 = board_length2;
#line 275 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp12_ = pos;
#line 275 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp13_ = (*_tmp12_).x;
#line 275 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp14_ = pos;
#line 275 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp15_ = (*_tmp14_).y;
#line 275 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp16_ = _tmp11_[(_tmp13_ * _tmp11__length2) + _tmp15_];
#line 275 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			if (_tmp16_ != ((gint) NIBBLES_GAME_EMPTYCHAR)) {
#line 1567 "worm.c"
				gint _tmp17_ = 0;
#line 277 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp17_ = self->priv->rounds_dematerialized;
#line 277 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				self->priv->rounds_dematerialized = _tmp17_ + 1;
#line 278 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_position_free0 (pos);
#line 278 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_g_object_unref0 (_pos_list);
#line 278 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				return;
#line 1579 "worm.c"
			}
#line 273 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_position_free0 (pos);
#line 1583 "worm.c"
		}
#line 273 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_g_object_unref0 (_pos_list);
#line 1587 "worm.c"
	}
	{
		GeeLinkedList* _pos_list = NULL;
		GeeLinkedList* _tmp18_ = NULL;
		GeeLinkedList* _tmp19_ = NULL;
		gint _pos_size = 0;
		GeeLinkedList* _tmp20_ = NULL;
		gint _tmp21_ = 0;
		gint _tmp22_ = 0;
		gint _pos_index = 0;
#line 281 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp18_ = self->priv->_list;
#line 281 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp19_ = _g_object_ref0 (_tmp18_);
#line 281 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_pos_list = _tmp19_;
#line 281 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp20_ = _pos_list;
#line 281 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp21_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp20_);
#line 281 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp22_ = _tmp21_;
#line 281 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_pos_size = _tmp22_;
#line 281 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_pos_index = -1;
#line 281 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		while (TRUE) {
#line 1616 "worm.c"
			gint _tmp23_ = 0;
			gint _tmp24_ = 0;
			gint _tmp25_ = 0;
			Position* pos = NULL;
			GeeLinkedList* _tmp26_ = NULL;
			gint _tmp27_ = 0;
			gpointer _tmp28_ = NULL;
			gint* _tmp29_ = NULL;
			gint _tmp29__length1 = 0;
			gint _tmp29__length2 = 0;
			Position* _tmp30_ = NULL;
			gint _tmp31_ = 0;
			Position* _tmp32_ = NULL;
			gint _tmp33_ = 0;
			gint _tmp34_ = 0;
			gint _tmp35_ = 0;
#line 281 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp23_ = _pos_index;
#line 281 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_pos_index = _tmp23_ + 1;
#line 281 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp24_ = _pos_index;
#line 281 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp25_ = _pos_size;
#line 281 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			if (!(_tmp24_ < _tmp25_)) {
#line 281 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				break;
#line 1645 "worm.c"
			}
#line 281 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp26_ = _pos_list;
#line 281 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp27_ = _pos_index;
#line 281 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp28_ = gee_abstract_list_get ((GeeAbstractList*) _tmp26_, _tmp27_);
#line 281 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			pos = (Position*) _tmp28_;
#line 282 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp29_ = board;
#line 282 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp29__length1 = board_length1;
#line 282 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp29__length2 = board_length2;
#line 282 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp30_ = pos;
#line 282 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp31_ = (*_tmp30_).x;
#line 282 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp32_ = pos;
#line 282 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp33_ = (*_tmp32_).y;
#line 282 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp34_ = self->priv->_id;
#line 282 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp29_[(_tmp31_ * _tmp29__length2) + _tmp33_] = NIBBLES_GAME_WORMCHAR + _tmp34_;
#line 282 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp35_ = _tmp29_[(_tmp31_ * _tmp29__length2) + _tmp33_];
#line 281 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_position_free0 (pos);
#line 1677 "worm.c"
		}
#line 281 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_g_object_unref0 (_pos_list);
#line 1681 "worm.c"
	}
#line 283 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	worm_set_is_materialized (self, TRUE);
#line 284 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	self->priv->rounds_dematerialized = 0;
#line 1687 "worm.c"
}


void worm_dematerialize (Worm* self, gint* board, int board_length1, int board_length2, gint rounds) {
	gint _tmp0_ = 0;
#line 287 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_return_if_fail (self != NULL);
#line 289 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp0_ = rounds;
#line 289 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	self->priv->rounds_dematerialized = _tmp0_;
#line 290 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	worm_set_is_materialized (self, FALSE);
#line 1701 "worm.c"
	{
		GeeLinkedList* _pos_list = NULL;
		GeeLinkedList* _tmp1_ = NULL;
		GeeLinkedList* _tmp2_ = NULL;
		gint _pos_size = 0;
		GeeLinkedList* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _pos_index = 0;
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp1_ = self->priv->_list;
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_pos_list = _tmp2_;
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp3_ = _pos_list;
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp5_ = _tmp4_;
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_pos_size = _tmp5_;
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_pos_index = -1;
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		while (TRUE) {
#line 1729 "worm.c"
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			Position* pos = NULL;
			GeeLinkedList* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gpointer _tmp11_ = NULL;
			gint* _tmp12_ = NULL;
			gint _tmp12__length1 = 0;
			gint _tmp12__length2 = 0;
			Position* _tmp13_ = NULL;
			gint _tmp14_ = 0;
			Position* _tmp15_ = NULL;
			gint _tmp16_ = 0;
			gint _tmp17_ = 0;
			gint _tmp18_ = 0;
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp6_ = _pos_index;
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_pos_index = _tmp6_ + 1;
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp7_ = _pos_index;
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp8_ = _pos_size;
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			if (!(_tmp7_ < _tmp8_)) {
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				break;
#line 1758 "worm.c"
			}
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp9_ = _pos_list;
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp10_ = _pos_index;
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			pos = (Position*) _tmp11_;
#line 293 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp12_ = board;
#line 293 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp12__length1 = board_length1;
#line 293 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp12__length2 = board_length2;
#line 293 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp13_ = pos;
#line 293 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp14_ = (*_tmp13_).x;
#line 293 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp15_ = pos;
#line 293 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp16_ = (*_tmp15_).y;
#line 293 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp17_ = _tmp12_[(_tmp14_ * _tmp12__length2) + _tmp16_];
#line 293 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp18_ = self->priv->_id;
#line 293 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			if (_tmp17_ == (NIBBLES_GAME_WORMCHAR + _tmp18_)) {
#line 1788 "worm.c"
				gint* _tmp19_ = NULL;
				gint _tmp19__length1 = 0;
				gint _tmp19__length2 = 0;
				Position* _tmp20_ = NULL;
				gint _tmp21_ = 0;
				Position* _tmp22_ = NULL;
				gint _tmp23_ = 0;
				gint _tmp24_ = 0;
#line 294 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp19_ = board;
#line 294 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp19__length1 = board_length1;
#line 294 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp19__length2 = board_length2;
#line 294 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp20_ = pos;
#line 294 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp21_ = (*_tmp20_).x;
#line 294 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp22_ = pos;
#line 294 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp23_ = (*_tmp22_).y;
#line 294 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp19_[(_tmp21_ * _tmp19__length2) + _tmp23_] = (gint) NIBBLES_GAME_EMPTYCHAR;
#line 294 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp24_ = _tmp19_[(_tmp21_ * _tmp19__length2) + _tmp23_];
#line 1815 "worm.c"
			}
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_position_free0 (pos);
#line 1819 "worm.c"
		}
#line 291 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_g_object_unref0 (_pos_list);
#line 1823 "worm.c"
	}
}


void worm_add_life (Worm* self) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
#line 298 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_return_if_fail (self != NULL);
#line 300 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp0_ = self->priv->_lives;
#line 300 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp0_ > WORM_MAX_LIVES) {
#line 301 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		return;
#line 1839 "worm.c"
	}
#line 303 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp1_ = self->priv->_lives;
#line 303 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	worm_set_lives (self, _tmp1_ + 1);
#line 1845 "worm.c"
}


static void worm_lose_life (Worm* self) {
	gint _tmp0_ = 0;
#line 306 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_return_if_fail (self != NULL);
#line 308 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp0_ = self->priv->_lives;
#line 308 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	worm_set_lives (self, _tmp0_ - 1);
#line 1857 "worm.c"
}


void worm_reset (Worm* self, gint* board, int board_length1, int board_length2) {
	GeeArrayQueue* _tmp0_ = NULL;
	GeeLinkedList* _tmp18_ = NULL;
	GeeLinkedList* _tmp19_ = NULL;
	Position _tmp20_ = {0};
	WormDirection _tmp21_ = 0;
	gint* _tmp22_ = NULL;
	gint _tmp22__length1 = 0;
	gint _tmp22__length2 = 0;
#line 311 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_return_if_fail (self != NULL);
#line 313 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	self->is_stopped = TRUE;
#line 314 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	worm_set_is_materialized (self, FALSE);
#line 315 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	self->priv->rounds_dematerialized = 0;
#line 317 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp0_ = self->priv->key_queue;
#line 317 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
#line 319 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	worm_lose_life (self);
#line 321 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_signal_emit_by_name (self, "died");
#line 1886 "worm.c"
	{
		GeeLinkedList* _pos_list = NULL;
		GeeLinkedList* _tmp1_ = NULL;
		GeeLinkedList* _tmp2_ = NULL;
		gint _pos_size = 0;
		GeeLinkedList* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _pos_index = 0;
#line 322 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp1_ = self->priv->_list;
#line 322 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 322 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_pos_list = _tmp2_;
#line 322 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp3_ = _pos_list;
#line 322 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
#line 322 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp5_ = _tmp4_;
#line 322 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_pos_size = _tmp5_;
#line 322 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_pos_index = -1;
#line 322 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		while (TRUE) {
#line 1914 "worm.c"
			gint _tmp6_ = 0;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			Position* pos = NULL;
			GeeLinkedList* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gpointer _tmp11_ = NULL;
			gint* _tmp12_ = NULL;
			gint _tmp12__length1 = 0;
			gint _tmp12__length2 = 0;
			Position* _tmp13_ = NULL;
			gint _tmp14_ = 0;
			Position* _tmp15_ = NULL;
			gint _tmp16_ = 0;
			gint _tmp17_ = 0;
#line 322 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp6_ = _pos_index;
#line 322 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_pos_index = _tmp6_ + 1;
#line 322 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp7_ = _pos_index;
#line 322 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp8_ = _pos_size;
#line 322 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			if (!(_tmp7_ < _tmp8_)) {
#line 322 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				break;
#line 1942 "worm.c"
			}
#line 322 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp9_ = _pos_list;
#line 322 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp10_ = _pos_index;
#line 322 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
#line 322 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			pos = (Position*) _tmp11_;
#line 323 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp12_ = board;
#line 323 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp12__length1 = board_length1;
#line 323 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp12__length2 = board_length2;
#line 323 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp13_ = pos;
#line 323 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp14_ = (*_tmp13_).x;
#line 323 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp15_ = pos;
#line 323 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp16_ = (*_tmp15_).y;
#line 323 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp12_[(_tmp14_ * _tmp12__length2) + _tmp16_] = (gint) NIBBLES_GAME_EMPTYCHAR;
#line 323 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp17_ = _tmp12_[(_tmp14_ * _tmp12__length2) + _tmp16_];
#line 322 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_position_free0 (pos);
#line 1972 "worm.c"
		}
#line 322 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_g_object_unref0 (_pos_list);
#line 1976 "worm.c"
	}
#line 325 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp18_ = self->priv->_list;
#line 325 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp18_);
#line 326 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp19_ = self->priv->_list;
#line 326 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp20_ = self->priv->_starting_position;
#line 326 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, &_tmp20_);
#line 327 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_signal_emit_by_name (self, "added");
#line 329 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp21_ = self->starting_direction;
#line 329 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	self->direction = _tmp21_;
#line 330 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	self->change = 0;
#line 331 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp22_ = board;
#line 331 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp22__length1 = board_length1;
#line 331 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp22__length2 = board_length2;
#line 331 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	worm_spawn (self, _tmp22_, _tmp22__length1, _tmp22__length2);
#line 333 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_signal_emit_by_name (self, "finish-added");
#line 2006 "worm.c"
}


static void worm_position_move (Worm* self, Position* result) {
	Position position = {0};
	Position _tmp0_ = {0};
	Position _tmp1_ = {0};
	WormDirection _tmp2_ = 0;
#line 336 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_return_if_fail (self != NULL);
#line 338 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	worm_get_head (self, &_tmp0_);
#line 338 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp1_ = _tmp0_;
#line 338 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	position = _tmp1_;
#line 340 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp2_ = self->direction;
#line 340 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	switch (_tmp2_) {
#line 340 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		case WORM_DIRECTION_UP:
#line 2029 "worm.c"
		{
			Position _tmp3_ = {0};
			Position _tmp4_ = {0};
			Position _tmp5_ = {0};
			Position _tmp6_ = {0};
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			Position _tmp9_ = {0};
			gint _tmp10_ = 0;
#line 343 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			worm_get_head (self, &_tmp3_);
#line 343 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp4_ = _tmp3_;
#line 343 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			worm_get_head (self, &_tmp5_);
#line 343 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp6_ = _tmp5_;
#line 343 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp7_ = _tmp6_.y;
#line 343 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp6_.y = _tmp7_ - 1;
#line 343 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp8_ = _tmp6_.y;
#line 343 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			position.y = _tmp8_;
#line 344 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp9_ = position;
#line 344 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp10_ = _tmp9_.y;
#line 344 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			if (_tmp10_ < 0) {
#line 345 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				position.y = NIBBLES_GAME_HEIGHT - 1;
#line 2063 "worm.c"
			}
#line 346 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			break;
#line 2067 "worm.c"
		}
#line 340 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		case WORM_DIRECTION_DOWN:
#line 2071 "worm.c"
		{
			Position _tmp11_ = {0};
			Position _tmp12_ = {0};
			Position _tmp13_ = {0};
			Position _tmp14_ = {0};
			gint _tmp15_ = 0;
			gint _tmp16_ = 0;
			Position _tmp17_ = {0};
			gint _tmp18_ = 0;
#line 348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			worm_get_head (self, &_tmp11_);
#line 348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp12_ = _tmp11_;
#line 348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			worm_get_head (self, &_tmp13_);
#line 348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp14_ = _tmp13_;
#line 348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp15_ = _tmp14_.y;
#line 348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp14_.y = _tmp15_ + 1;
#line 348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp16_ = _tmp14_.y;
#line 348 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			position.y = _tmp16_;
#line 349 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp17_ = position;
#line 349 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp18_ = _tmp17_.y;
#line 349 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			if (_tmp18_ >= NIBBLES_GAME_HEIGHT) {
#line 350 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				position.y = 0;
#line 2105 "worm.c"
			}
#line 351 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			break;
#line 2109 "worm.c"
		}
#line 340 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		case WORM_DIRECTION_LEFT:
#line 2113 "worm.c"
		{
			Position _tmp19_ = {0};
			Position _tmp20_ = {0};
			Position _tmp21_ = {0};
			Position _tmp22_ = {0};
			gint _tmp23_ = 0;
			gint _tmp24_ = 0;
			Position _tmp25_ = {0};
			gint _tmp26_ = 0;
#line 353 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			worm_get_head (self, &_tmp19_);
#line 353 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp20_ = _tmp19_;
#line 353 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			worm_get_head (self, &_tmp21_);
#line 353 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp22_ = _tmp21_;
#line 353 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp23_ = _tmp22_.x;
#line 353 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp22_.x = _tmp23_ - 1;
#line 353 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp24_ = _tmp22_.x;
#line 353 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			position.x = _tmp24_;
#line 354 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp25_ = position;
#line 354 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp26_ = _tmp25_.x;
#line 354 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			if (_tmp26_ < 0) {
#line 355 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				position.x = NIBBLES_GAME_WIDTH - 1;
#line 2147 "worm.c"
			}
#line 356 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			break;
#line 2151 "worm.c"
		}
#line 340 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		case WORM_DIRECTION_RIGHT:
#line 2155 "worm.c"
		{
			Position _tmp27_ = {0};
			Position _tmp28_ = {0};
			Position _tmp29_ = {0};
			Position _tmp30_ = {0};
			gint _tmp31_ = 0;
			gint _tmp32_ = 0;
			Position _tmp33_ = {0};
			gint _tmp34_ = 0;
#line 358 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			worm_get_head (self, &_tmp27_);
#line 358 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp28_ = _tmp27_;
#line 358 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			worm_get_head (self, &_tmp29_);
#line 358 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp30_ = _tmp29_;
#line 358 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp31_ = _tmp30_.x;
#line 358 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp30_.x = _tmp31_ + 1;
#line 358 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp32_ = _tmp30_.x;
#line 358 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			position.x = _tmp32_;
#line 359 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp33_ = position;
#line 359 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp34_ = _tmp33_.x;
#line 359 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			if (_tmp34_ >= NIBBLES_GAME_WIDTH) {
#line 360 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				position.x = 0;
#line 2189 "worm.c"
			}
#line 361 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			break;
#line 2193 "worm.c"
		}
		default:
		{
#line 363 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			break;
#line 2199 "worm.c"
		}
	}
#line 366 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	*result = position;
#line 366 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	return;
#line 2206 "worm.c"
}


static void worm_direction_set (Worm* self, WormDirection dir) {
	gboolean _tmp0_ = FALSE;
	WormDirection _tmp1_ = 0;
	WormDirection _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	WormDirection _tmp5_ = 0;
#line 369 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_return_if_fail (self != NULL);
#line 371 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp0_ = self->is_human;
#line 371 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (!_tmp0_) {
#line 372 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		return;
#line 2224 "worm.c"
	}
#line 374 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp1_ = dir;
#line 374 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp1_ > 4) {
#line 375 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		dir = (WormDirection) 1;
#line 2232 "worm.c"
	}
#line 376 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp2_ = dir;
#line 376 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp2_ < 1) {
#line 377 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		dir = (WormDirection) 4;
#line 2240 "worm.c"
	}
#line 379 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp3_ = self->keypress;
#line 379 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp3_) {
#line 2246 "worm.c"
		WormDirection _tmp4_ = 0;
#line 381 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp4_ = dir;
#line 381 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		worm_queue_keypress (self, _tmp4_);
#line 382 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		return;
#line 2254 "worm.c"
	}
#line 385 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp5_ = dir;
#line 385 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	self->direction = (WormDirection) _tmp5_;
#line 386 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	self->keypress = TRUE;
#line 2262 "worm.c"
}


static guint worm_upper_key (Worm* self, guint keyval) {
	guint result = 0U;
	guint _tmp0_ = 0U;
	guint _tmp2_ = 0U;
	gchar _tmp3_ = '\0';
#line 392 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 394 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp0_ = keyval;
#line 394 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp0_ > ((guint) 255)) {
#line 2277 "worm.c"
		guint _tmp1_ = 0U;
#line 395 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp1_ = keyval;
#line 395 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		result = _tmp1_;
#line 395 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		return result;
#line 2285 "worm.c"
	}
#line 396 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp2_ = keyval;
#line 396 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp3_ = g_ascii_toupper ((gchar) _tmp2_);
#line 396 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	result = (guint) _tmp3_;
#line 396 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	return result;
#line 2295 "worm.c"
}


void worm_handle_direction (Worm* self, WormDirection dir) {
	WormDirection _tmp0_ = 0;
#line 399 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_return_if_fail (self != NULL);
#line 401 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp0_ = dir;
#line 401 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	worm_direction_set (self, _tmp0_);
#line 2307 "worm.c"
}


gboolean worm_handle_keypress (Worm* self, guint keyval, GeeHashMap* worm_props) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	WormProperties properties = {0};
	guint propsUp = 0U;
	guint propsDown = 0U;
	guint propsLeft = 0U;
	guint propsRight = 0U;
	guint keyvalUpper = 0U;
	GeeHashMap* _tmp3_ = NULL;
	gpointer _tmp4_ = NULL;
	WormProperties* _tmp5_ = NULL;
	WormProperties _tmp6_ = {0};
	guint _tmp7_ = 0U;
	guint _tmp8_ = 0U;
	WormProperties _tmp9_ = {0};
	guint _tmp10_ = 0U;
	guint _tmp11_ = 0U;
	WormProperties _tmp12_ = {0};
	guint _tmp13_ = 0U;
	guint _tmp14_ = 0U;
	WormProperties _tmp15_ = {0};
	guint _tmp16_ = 0U;
	guint _tmp17_ = 0U;
	guint _tmp18_ = 0U;
	guint _tmp19_ = 0U;
	gboolean _tmp20_ = FALSE;
	guint _tmp21_ = 0U;
	guint _tmp22_ = 0U;
	gboolean _tmp24_ = FALSE;
	guint _tmp25_ = 0U;
	guint _tmp26_ = 0U;
	gboolean _tmp28_ = FALSE;
	guint _tmp29_ = 0U;
	guint _tmp30_ = 0U;
	gboolean _tmp32_ = FALSE;
	guint _tmp33_ = 0U;
	guint _tmp34_ = 0U;
#line 404 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 404 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_return_val_if_fail (worm_props != NULL, FALSE);
#line 406 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp1_ = self->priv->_lives;
#line 406 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp1_ <= 0) {
#line 406 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp0_ = TRUE;
#line 2360 "worm.c"
	} else {
		gboolean _tmp2_ = FALSE;
#line 406 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp2_ = self->is_stopped;
#line 406 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp0_ = _tmp2_;
#line 2367 "worm.c"
	}
#line 406 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp0_) {
#line 407 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		result = FALSE;
#line 407 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		return result;
#line 2375 "worm.c"
	}
#line 412 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp3_ = worm_props;
#line 412 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp4_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, self);
#line 412 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp5_ = (WormProperties*) _tmp4_;
#line 412 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	properties = *_tmp5_;
#line 412 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_worm_properties_free0 (_tmp5_);
#line 413 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp6_ = properties;
#line 413 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp7_ = _tmp6_.up;
#line 413 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp8_ = worm_upper_key (self, _tmp7_);
#line 413 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	propsUp = _tmp8_;
#line 414 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp9_ = properties;
#line 414 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp10_ = _tmp9_.left;
#line 414 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp11_ = worm_upper_key (self, _tmp10_);
#line 414 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	propsLeft = _tmp11_;
#line 415 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp12_ = properties;
#line 415 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp13_ = _tmp12_.down;
#line 415 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp14_ = worm_upper_key (self, _tmp13_);
#line 415 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	propsDown = _tmp14_;
#line 416 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp15_ = properties;
#line 416 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp16_ = _tmp15_.right;
#line 416 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp17_ = worm_upper_key (self, _tmp16_);
#line 416 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	propsRight = _tmp17_;
#line 417 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp18_ = keyval;
#line 417 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp19_ = worm_upper_key (self, _tmp18_);
#line 417 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	keyvalUpper = _tmp19_;
#line 419 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp21_ = keyvalUpper;
#line 419 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp22_ = propsUp;
#line 419 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp21_ == _tmp22_) {
#line 2431 "worm.c"
		WormDirection _tmp23_ = 0;
#line 419 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp23_ = self->direction;
#line 419 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp20_ = _tmp23_ != WORM_DIRECTION_DOWN;
#line 2437 "worm.c"
	} else {
#line 419 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp20_ = FALSE;
#line 2441 "worm.c"
	}
#line 419 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp20_) {
#line 421 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		worm_handle_direction (self, WORM_DIRECTION_UP);
#line 422 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		result = TRUE;
#line 422 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		return result;
#line 2451 "worm.c"
	}
#line 424 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp25_ = keyvalUpper;
#line 424 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp26_ = propsDown;
#line 424 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp25_ == _tmp26_) {
#line 2459 "worm.c"
		WormDirection _tmp27_ = 0;
#line 424 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp27_ = self->direction;
#line 424 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp24_ = _tmp27_ != WORM_DIRECTION_UP;
#line 2465 "worm.c"
	} else {
#line 424 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp24_ = FALSE;
#line 2469 "worm.c"
	}
#line 424 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp24_) {
#line 426 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		worm_handle_direction (self, WORM_DIRECTION_DOWN);
#line 427 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		result = TRUE;
#line 427 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		return result;
#line 2479 "worm.c"
	}
#line 429 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp29_ = keyvalUpper;
#line 429 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp30_ = propsRight;
#line 429 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp29_ == _tmp30_) {
#line 2487 "worm.c"
		WormDirection _tmp31_ = 0;
#line 429 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp31_ = self->direction;
#line 429 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp28_ = _tmp31_ != WORM_DIRECTION_LEFT;
#line 2493 "worm.c"
	} else {
#line 429 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp28_ = FALSE;
#line 2497 "worm.c"
	}
#line 429 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp28_) {
#line 431 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		worm_handle_direction (self, WORM_DIRECTION_RIGHT);
#line 432 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		result = TRUE;
#line 432 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		return result;
#line 2507 "worm.c"
	}
#line 434 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp33_ = keyvalUpper;
#line 434 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp34_ = propsLeft;
#line 434 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp33_ == _tmp34_) {
#line 2515 "worm.c"
		WormDirection _tmp35_ = 0;
#line 434 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp35_ = self->direction;
#line 434 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp32_ = _tmp35_ != WORM_DIRECTION_RIGHT;
#line 2521 "worm.c"
	} else {
#line 434 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp32_ = FALSE;
#line 2525 "worm.c"
	}
#line 434 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp32_) {
#line 436 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		worm_handle_direction (self, WORM_DIRECTION_LEFT);
#line 437 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		result = TRUE;
#line 437 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		return result;
#line 2535 "worm.c"
	}
#line 440 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	result = FALSE;
#line 440 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	return result;
#line 2541 "worm.c"
}


void worm_queue_keypress (Worm* self, WormDirection dir) {
	gboolean _tmp0_ = FALSE;
	GeeArrayQueue* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GeeArrayQueue* _tmp7_ = NULL;
	WormDirection _tmp8_ = 0;
#line 443 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_return_if_fail (self != NULL);
#line 448 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp1_ = self->priv->key_queue;
#line 448 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp2_ = gee_array_queue_get_is_empty (_tmp1_);
#line 448 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp3_ = _tmp2_;
#line 448 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (!_tmp3_) {
#line 2562 "worm.c"
		WormDirection _tmp4_ = 0;
		GeeArrayQueue* _tmp5_ = NULL;
		gpointer _tmp6_ = NULL;
#line 448 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp4_ = dir;
#line 448 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp5_ = self->priv->key_queue;
#line 448 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp6_ = gee_abstract_queue_peek ((GeeAbstractQueue*) _tmp5_);
#line 448 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp0_ = _tmp4_ == ((WormDirection) ((gintptr) _tmp6_));
#line 2574 "worm.c"
	} else {
#line 448 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp0_ = FALSE;
#line 2578 "worm.c"
	}
#line 448 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp0_) {
#line 449 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		return;
#line 2584 "worm.c"
	}
#line 451 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp7_ = self->priv->key_queue;
#line 451 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp8_ = dir;
#line 451 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, (gpointer) ((gintptr) _tmp8_));
#line 2592 "worm.c"
}


void worm_dequeue_keypress (Worm* self) {
	GeeArrayQueue* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GeeArrayQueue* _tmp3_ = NULL;
	gpointer _tmp4_ = NULL;
#line 454 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_return_if_fail (self != NULL);
#line 454 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp0_ = self->priv->key_queue;
#line 454 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp1_ = gee_array_queue_get_is_empty (_tmp0_);
#line 454 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp2_ = _tmp1_;
#line 454 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_vala_return_if_fail (!_tmp2_, "!key_queue.is_empty");
#line 457 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp3_ = self->priv->key_queue;
#line 457 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp4_ = gee_abstract_queue_poll ((GeeAbstractQueue*) _tmp3_);
#line 457 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	worm_direction_set (self, (WormDirection) ((gintptr) _tmp4_));
#line 2618 "worm.c"
}


static gint worm_ai_deadend (gint* board, int board_length1, int board_length2, gint numworms, gint x, gint y, gint length_left) {
	gint result = 0;
	gint cdir = 0;
	gint cx = 0;
	gint cy = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp46_ = 0;
#line 484 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp0_ = x;
#line 484 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp0_ >= NIBBLES_GAME_WIDTH) {
#line 485 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		x = 0;
#line 2639 "worm.c"
	}
#line 486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp1_ = x;
#line 486 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp1_ < 0) {
#line 487 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		x = NIBBLES_GAME_WIDTH - 1;
#line 2647 "worm.c"
	}
#line 488 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp2_ = y;
#line 488 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp2_ >= NIBBLES_GAME_HEIGHT) {
#line 489 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		y = 0;
#line 2655 "worm.c"
	}
#line 490 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp3_ = y;
#line 490 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp3_ < 0) {
#line 491 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		y = NIBBLES_GAME_HEIGHT - 1;
#line 2663 "worm.c"
	}
#line 493 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp4_ = length_left;
#line 493 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp4_ <= 0) {
#line 494 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		result = 0;
#line 494 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		return result;
#line 2673 "worm.c"
	}
#line 496 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	cdir = 5;
#line 497 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	while (TRUE) {
#line 2679 "worm.c"
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		gint* _tmp20_ = NULL;
		gint _tmp20__length1 = 0;
		gint _tmp20__length2 = 0;
		gint _tmp21_ = 0;
		gint _tmp22_ = 0;
		gint _tmp23_ = 0;
#line 497 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp5_ = cdir;
#line 497 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		cdir = _tmp5_ - 1;
#line 497 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp6_ = cdir;
#line 497 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		if (!(_tmp6_ > 0)) {
#line 497 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			break;
#line 2707 "worm.c"
		}
#line 499 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp7_ = x;
#line 499 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		cx = _tmp7_;
#line 500 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp8_ = y;
#line 500 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		cy = _tmp8_;
#line 501 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp9_ = cdir;
#line 501 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		switch (_tmp9_) {
#line 501 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			case WORM_DIRECTION_UP:
#line 2723 "worm.c"
			{
				gint _tmp10_ = 0;
#line 504 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp10_ = cy;
#line 504 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				cy = _tmp10_ - 1;
#line 505 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				break;
#line 2732 "worm.c"
			}
#line 501 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			case WORM_DIRECTION_DOWN:
#line 2736 "worm.c"
			{
				gint _tmp11_ = 0;
#line 507 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp11_ = cy;
#line 507 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				cy = _tmp11_ + 1;
#line 508 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				break;
#line 2745 "worm.c"
			}
#line 501 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			case WORM_DIRECTION_LEFT:
#line 2749 "worm.c"
			{
				gint _tmp12_ = 0;
#line 510 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp12_ = cx;
#line 510 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				cx = _tmp12_ - 1;
#line 511 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				break;
#line 2758 "worm.c"
			}
#line 501 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			case WORM_DIRECTION_RIGHT:
#line 2762 "worm.c"
			{
				gint _tmp13_ = 0;
#line 513 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp13_ = cx;
#line 513 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				cx = _tmp13_ + 1;
#line 514 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				break;
#line 2771 "worm.c"
			}
			default:
#line 501 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			break;
#line 2776 "worm.c"
		}
#line 517 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp14_ = cx;
#line 517 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		if (_tmp14_ >= NIBBLES_GAME_WIDTH) {
#line 518 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			cx = 0;
#line 2784 "worm.c"
		}
#line 519 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp15_ = cx;
#line 519 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		if (_tmp15_ < 0) {
#line 520 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			cx = NIBBLES_GAME_WIDTH - 1;
#line 2792 "worm.c"
		}
#line 521 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp16_ = cy;
#line 521 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		if (_tmp16_ >= NIBBLES_GAME_HEIGHT) {
#line 522 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			cy = 0;
#line 2800 "worm.c"
		}
#line 523 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp17_ = cy;
#line 523 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		if (_tmp17_ < 0) {
#line 524 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			cy = NIBBLES_GAME_HEIGHT - 1;
#line 2808 "worm.c"
		}
#line 526 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp20_ = board;
#line 526 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp20__length1 = board_length1;
#line 526 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp20__length2 = board_length2;
#line 526 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp21_ = cx;
#line 526 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp22_ = cy;
#line 526 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp23_ = _tmp20_[(_tmp21_ * _tmp20__length2) + _tmp22_];
#line 526 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		if (_tmp23_ <= ((gint) NIBBLES_GAME_EMPTYCHAR)) {
#line 526 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp19_ = TRUE;
#line 2826 "worm.c"
		} else {
			gint* _tmp24_ = NULL;
			gint _tmp24__length1 = 0;
			gint _tmp24__length2 = 0;
			gint _tmp25_ = 0;
			gint _tmp26_ = 0;
			gint _tmp27_ = 0;
			gint _tmp28_ = 0;
#line 527 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp24_ = board;
#line 527 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp24__length1 = board_length1;
#line 527 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp24__length2 = board_length2;
#line 527 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp25_ = x;
#line 527 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp26_ = y;
#line 527 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp27_ = _tmp24_[(_tmp25_ * _tmp24__length2) + _tmp26_];
#line 527 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp28_ = numworms;
#line 527 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp19_ = _tmp27_ >= ('z' + _tmp28_);
#line 2851 "worm.c"
		}
#line 526 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		if (_tmp19_) {
#line 2855 "worm.c"
			guint* _tmp29_ = NULL;
			gint _tmp29__length1 = 0;
			gint _tmp29__length2 = 0;
			gint _tmp30_ = 0;
			gint _tmp31_ = 0;
			guint _tmp32_ = 0U;
			guint _tmp33_ = 0U;
#line 528 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp29_ = worm_deadend_board;
#line 528 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp29__length1 = worm_deadend_board_length1;
#line 528 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp29__length2 = worm_deadend_board_length2;
#line 528 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp30_ = cx;
#line 528 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp31_ = cy;
#line 528 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp32_ = _tmp29_[(_tmp30_ * _tmp29__length2) + _tmp31_];
#line 528 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp33_ = worm_deadend_runnumber;
#line 528 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp18_ = _tmp32_ != _tmp33_;
#line 2879 "worm.c"
		} else {
#line 526 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp18_ = FALSE;
#line 2883 "worm.c"
		}
#line 526 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		if (_tmp18_) {
#line 2887 "worm.c"
			guint* _tmp34_ = NULL;
			gint _tmp34__length1 = 0;
			gint _tmp34__length2 = 0;
			gint _tmp35_ = 0;
			gint _tmp36_ = 0;
			guint _tmp37_ = 0U;
			guint _tmp38_ = 0U;
			gint* _tmp39_ = NULL;
			gint _tmp39__length1 = 0;
			gint _tmp39__length2 = 0;
			gint _tmp40_ = 0;
			gint _tmp41_ = 0;
			gint _tmp42_ = 0;
			gint _tmp43_ = 0;
			gint _tmp44_ = 0;
			gint _tmp45_ = 0;
#line 530 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp34_ = worm_deadend_board;
#line 530 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp34__length1 = worm_deadend_board_length1;
#line 530 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp34__length2 = worm_deadend_board_length2;
#line 530 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp35_ = cx;
#line 530 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp36_ = cy;
#line 530 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp37_ = worm_deadend_runnumber;
#line 530 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp34_[(_tmp35_ * _tmp34__length2) + _tmp36_] = _tmp37_;
#line 530 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp38_ = _tmp34_[(_tmp35_ * _tmp34__length2) + _tmp36_];
#line 531 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp39_ = board;
#line 531 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp39__length1 = board_length1;
#line 531 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp39__length2 = board_length2;
#line 531 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp40_ = numworms;
#line 531 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp41_ = cx;
#line 531 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp42_ = cy;
#line 531 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp43_ = length_left;
#line 531 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp44_ = worm_ai_deadend (_tmp39_, _tmp39__length1, _tmp39__length2, _tmp40_, _tmp41_, _tmp42_, _tmp43_ - 1);
#line 531 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			length_left = _tmp44_;
#line 532 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp45_ = length_left;
#line 532 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			if (_tmp45_ <= 0) {
#line 533 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				result = 0;
#line 533 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				return result;
#line 2946 "worm.c"
			}
		}
	}
#line 537 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp46_ = length_left;
#line 537 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	result = _tmp46_;
#line 537 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	return result;
#line 2956 "worm.c"
}


static gint worm_ai_deadend_after (gint* board, int board_length1, int board_length2, GeeLinkedList* worms, gint numworms, gint x, gint y, gint dir, gint length) {
	gint result = 0;
	gint cx = 0;
	gint cy = 0;
	gint cl = 0;
	gint i = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_ = 0;
	guint _tmp7_ = 0U;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp55_ = 0;
	gint _tmp56_ = 0;
	gint _tmp57_ = 0;
	gint _tmp62_ = 0;
	gint _tmp63_ = 0;
	gint _tmp64_ = 0;
	gint _tmp65_ = 0;
	guint* _tmp66_ = NULL;
	gint _tmp66__length1 = 0;
	gint _tmp66__length2 = 0;
	gint _tmp67_ = 0;
	gint _tmp68_ = 0;
	guint _tmp69_ = 0U;
	guint _tmp70_ = 0U;
	guint* _tmp71_ = NULL;
	gint _tmp71__length1 = 0;
	gint _tmp71__length2 = 0;
	gint _tmp72_ = 0;
	gint _tmp73_ = 0;
	guint _tmp74_ = 0U;
	guint _tmp75_ = 0U;
	gint _tmp76_ = 0;
	gint _tmp77_ = 0;
	gint _tmp78_ = 0;
	gint* _tmp79_ = NULL;
	gint _tmp79__length1 = 0;
	gint _tmp79__length2 = 0;
	gint _tmp80_ = 0;
	gint _tmp81_ = 0;
	gint _tmp82_ = 0;
	gint _tmp83_ = 0;
	gint _tmp84_ = 0;
#line 549 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_return_val_if_fail (worms != NULL, 0);
#line 553 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp3_ = x;
#line 553 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp3_ < 0) {
#line 553 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp2_ = TRUE;
#line 3014 "worm.c"
	} else {
		gint _tmp4_ = 0;
#line 553 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp4_ = x;
#line 553 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp2_ = _tmp4_ >= NIBBLES_GAME_WIDTH;
#line 3021 "worm.c"
	}
#line 553 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp2_) {
#line 553 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp1_ = TRUE;
#line 3027 "worm.c"
	} else {
		gint _tmp5_ = 0;
#line 553 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp5_ = y;
#line 553 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp1_ = _tmp5_ < 0;
#line 3034 "worm.c"
	}
#line 553 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp1_) {
#line 553 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp0_ = TRUE;
#line 3040 "worm.c"
	} else {
		gint _tmp6_ = 0;
#line 553 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp6_ = y;
#line 553 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp0_ = _tmp6_ >= NIBBLES_GAME_HEIGHT;
#line 3047 "worm.c"
	}
#line 553 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp0_) {
#line 554 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		result = 0;
#line 554 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		return result;
#line 3055 "worm.c"
	}
#line 556 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp7_ = worm_deadend_runnumber;
#line 556 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	worm_deadend_runnumber = _tmp7_ + 1;
#line 558 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp8_ = dir;
#line 558 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp8_ > 4) {
#line 559 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		dir = 1;
#line 3067 "worm.c"
	}
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp9_ = dir;
#line 560 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp9_ < 1) {
#line 561 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		dir = 4;
#line 3075 "worm.c"
	}
#line 563 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp10_ = numworms;
#line 563 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	i = _tmp10_;
#line 564 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	while (TRUE) {
#line 3083 "worm.c"
		gint _tmp11_ = 0;
		GeeLinkedList* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		gpointer _tmp14_ = NULL;
		Worm* _tmp15_ = NULL;
		Position _tmp16_ = {0};
		Position _tmp17_ = {0};
		gint _tmp18_ = 0;
		GeeLinkedList* _tmp19_ = NULL;
		gint _tmp20_ = 0;
		gpointer _tmp21_ = NULL;
		Worm* _tmp22_ = NULL;
		Position _tmp23_ = {0};
		Position _tmp24_ = {0};
		gint _tmp25_ = 0;
		gboolean _tmp26_ = FALSE;
		gint _tmp27_ = 0;
		gint _tmp28_ = 0;
#line 564 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp11_ = i;
#line 564 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		i = _tmp11_ - 1;
#line 564 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		if (!(_tmp11_ > 0)) {
#line 564 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			break;
#line 3110 "worm.c"
		}
#line 566 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp12_ = worms;
#line 566 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp13_ = i;
#line 566 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _tmp13_);
#line 566 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp15_ = (Worm*) _tmp14_;
#line 566 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		worm_get_head (_tmp15_, &_tmp16_);
#line 566 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp17_ = _tmp16_;
#line 566 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp18_ = _tmp17_.x;
#line 566 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		cx = _tmp18_;
#line 566 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_g_object_unref0 (_tmp15_);
#line 567 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp19_ = worms;
#line 567 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp20_ = i;
#line 567 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp21_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, _tmp20_);
#line 567 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp22_ = (Worm*) _tmp21_;
#line 567 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		worm_get_head (_tmp22_, &_tmp23_);
#line 567 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp24_ = _tmp23_;
#line 567 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp25_ = _tmp24_.y;
#line 567 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		cy = _tmp25_;
#line 567 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_g_object_unref0 (_tmp22_);
#line 568 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp27_ = cx;
#line 568 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp28_ = x;
#line 568 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		if (_tmp27_ != _tmp28_) {
#line 568 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp26_ = TRUE;
#line 3156 "worm.c"
		} else {
			gint _tmp29_ = 0;
			gint _tmp30_ = 0;
#line 568 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp29_ = cy;
#line 568 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp30_ = y;
#line 568 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp26_ = _tmp29_ != _tmp30_;
#line 3166 "worm.c"
		}
#line 568 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		if (_tmp26_) {
#line 3170 "worm.c"
			gint _tmp31_ = 0;
			gint _tmp37_ = 0;
			gint _tmp43_ = 0;
			gint _tmp49_ = 0;
#line 569 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp31_ = cx;
#line 569 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			if (_tmp31_ > 0) {
#line 3179 "worm.c"
				guint* _tmp32_ = NULL;
				gint _tmp32__length1 = 0;
				gint _tmp32__length2 = 0;
				gint _tmp33_ = 0;
				gint _tmp34_ = 0;
				guint _tmp35_ = 0U;
				guint _tmp36_ = 0U;
#line 570 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp32_ = worm_deadend_board;
#line 570 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp32__length1 = worm_deadend_board_length1;
#line 570 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp32__length2 = worm_deadend_board_length2;
#line 570 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp33_ = cx;
#line 570 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp34_ = cy;
#line 570 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp35_ = worm_deadend_runnumber;
#line 570 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp32_[((_tmp33_ - 1) * _tmp32__length2) + _tmp34_] = _tmp35_;
#line 570 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp36_ = _tmp32_[((_tmp33_ - 1) * _tmp32__length2) + _tmp34_];
#line 3203 "worm.c"
			}
#line 571 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp37_ = cy;
#line 571 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			if (_tmp37_ > 0) {
#line 3209 "worm.c"
				guint* _tmp38_ = NULL;
				gint _tmp38__length1 = 0;
				gint _tmp38__length2 = 0;
				gint _tmp39_ = 0;
				gint _tmp40_ = 0;
				guint _tmp41_ = 0U;
				guint _tmp42_ = 0U;
#line 572 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp38_ = worm_deadend_board;
#line 572 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp38__length1 = worm_deadend_board_length1;
#line 572 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp38__length2 = worm_deadend_board_length2;
#line 572 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp39_ = cx;
#line 572 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp40_ = cy;
#line 572 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp41_ = worm_deadend_runnumber;
#line 572 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp38_[(_tmp39_ * _tmp38__length2) + (_tmp40_ - 1)] = _tmp41_;
#line 572 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp42_ = _tmp38_[(_tmp39_ * _tmp38__length2) + (_tmp40_ - 1)];
#line 3233 "worm.c"
			}
#line 573 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp43_ = cx;
#line 573 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			if (_tmp43_ < (NIBBLES_GAME_WIDTH - 1)) {
#line 3239 "worm.c"
				guint* _tmp44_ = NULL;
				gint _tmp44__length1 = 0;
				gint _tmp44__length2 = 0;
				gint _tmp45_ = 0;
				gint _tmp46_ = 0;
				guint _tmp47_ = 0U;
				guint _tmp48_ = 0U;
#line 574 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp44_ = worm_deadend_board;
#line 574 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp44__length1 = worm_deadend_board_length1;
#line 574 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp44__length2 = worm_deadend_board_length2;
#line 574 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp45_ = cx;
#line 574 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp46_ = cy;
#line 574 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp47_ = worm_deadend_runnumber;
#line 574 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp44_[((_tmp45_ + 1) * _tmp44__length2) + _tmp46_] = _tmp47_;
#line 574 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp48_ = _tmp44_[((_tmp45_ + 1) * _tmp44__length2) + _tmp46_];
#line 3263 "worm.c"
			}
#line 575 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp49_ = cy;
#line 575 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			if (_tmp49_ < (NIBBLES_GAME_HEIGHT - 1)) {
#line 3269 "worm.c"
				guint* _tmp50_ = NULL;
				gint _tmp50__length1 = 0;
				gint _tmp50__length2 = 0;
				gint _tmp51_ = 0;
				gint _tmp52_ = 0;
				guint _tmp53_ = 0U;
				guint _tmp54_ = 0U;
#line 576 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp50_ = worm_deadend_board;
#line 576 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp50__length1 = worm_deadend_board_length1;
#line 576 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp50__length2 = worm_deadend_board_length2;
#line 576 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp51_ = cx;
#line 576 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp52_ = cy;
#line 576 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp53_ = worm_deadend_runnumber;
#line 576 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp50_[(_tmp51_ * _tmp50__length2) + (_tmp52_ + 1)] = _tmp53_;
#line 576 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp54_ = _tmp50_[(_tmp51_ * _tmp50__length2) + (_tmp52_ + 1)];
#line 3293 "worm.c"
			}
		}
	}
#line 580 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp55_ = x;
#line 580 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	cx = _tmp55_;
#line 581 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp56_ = y;
#line 581 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	cy = _tmp56_;
#line 582 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp57_ = dir;
#line 582 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	switch (_tmp57_) {
#line 582 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		case WORM_DIRECTION_UP:
#line 3311 "worm.c"
		{
			gint _tmp58_ = 0;
#line 585 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp58_ = cy;
#line 585 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			cy = _tmp58_ - 1;
#line 586 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			break;
#line 3320 "worm.c"
		}
#line 582 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		case WORM_DIRECTION_DOWN:
#line 3324 "worm.c"
		{
			gint _tmp59_ = 0;
#line 588 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp59_ = cy;
#line 588 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			cy = _tmp59_ + 1;
#line 589 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			break;
#line 3333 "worm.c"
		}
#line 582 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		case WORM_DIRECTION_LEFT:
#line 3337 "worm.c"
		{
			gint _tmp60_ = 0;
#line 591 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp60_ = cx;
#line 591 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			cx = _tmp60_ - 1;
#line 592 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			break;
#line 3346 "worm.c"
		}
#line 582 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		case WORM_DIRECTION_RIGHT:
#line 3350 "worm.c"
		{
			gint _tmp61_ = 0;
#line 594 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp61_ = cx;
#line 594 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			cx = _tmp61_ + 1;
#line 595 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			break;
#line 3359 "worm.c"
		}
		default:
#line 582 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		break;
#line 3364 "worm.c"
	}
#line 598 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp62_ = cx;
#line 598 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp62_ >= NIBBLES_GAME_WIDTH) {
#line 599 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		cx = 0;
#line 3372 "worm.c"
	}
#line 600 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp63_ = cx;
#line 600 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp63_ < 0) {
#line 601 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		cx = NIBBLES_GAME_WIDTH - 1;
#line 3380 "worm.c"
	}
#line 602 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp64_ = cy;
#line 602 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp64_ >= NIBBLES_GAME_HEIGHT) {
#line 603 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		cy = 0;
#line 3388 "worm.c"
	}
#line 604 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp65_ = cy;
#line 604 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp65_ < 0) {
#line 605 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		cy = NIBBLES_GAME_HEIGHT - 1;
#line 3396 "worm.c"
	}
#line 607 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp66_ = worm_deadend_board;
#line 607 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp66__length1 = worm_deadend_board_length1;
#line 607 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp66__length2 = worm_deadend_board_length2;
#line 607 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp67_ = x;
#line 607 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp68_ = y;
#line 607 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp69_ = worm_deadend_runnumber;
#line 607 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp66_[(_tmp67_ * _tmp66__length2) + _tmp68_] = _tmp69_;
#line 607 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp70_ = _tmp66_[(_tmp67_ * _tmp66__length2) + _tmp68_];
#line 608 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp71_ = worm_deadend_board;
#line 608 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp71__length1 = worm_deadend_board_length1;
#line 608 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp71__length2 = worm_deadend_board_length2;
#line 608 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp72_ = cx;
#line 608 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp73_ = cy;
#line 608 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp74_ = worm_deadend_runnumber;
#line 608 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp71_[(_tmp72_ * _tmp71__length2) + _tmp73_] = _tmp74_;
#line 608 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp75_ = _tmp71_[(_tmp72_ * _tmp71__length2) + _tmp73_];
#line 610 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp76_ = length;
#line 610 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp77_ = length;
#line 610 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	cl = (_tmp76_ * _tmp77_) / 16;
#line 611 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp78_ = cl;
#line 611 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp78_ < NIBBLES_GAME_WIDTH) {
#line 612 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		cl = NIBBLES_GAME_WIDTH;
#line 3442 "worm.c"
	}
#line 613 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp79_ = board;
#line 613 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp79__length1 = board_length1;
#line 613 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp79__length2 = board_length2;
#line 613 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp80_ = numworms;
#line 613 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp81_ = cx;
#line 613 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp82_ = cy;
#line 613 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp83_ = cl;
#line 613 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp84_ = worm_ai_deadend (_tmp79_, _tmp79__length1, _tmp79__length2, _tmp80_, _tmp81_, _tmp82_, _tmp83_);
#line 613 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	result = _tmp84_;
#line 613 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	return result;
#line 3464 "worm.c"
}


static gboolean worm_ai_too_close (Worm* self, GeeLinkedList* worms, gint numworms) {
	gboolean result = FALSE;
	gint i = 0;
	gint _tmp0_ = 0;
	gint dx = 0;
	gint dy = 0;
#line 620 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 620 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_return_val_if_fail (worms != NULL, FALSE);
#line 622 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp0_ = numworms;
#line 622 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	i = _tmp0_;
#line 625 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	while (TRUE) {
#line 3484 "worm.c"
		gint _tmp1_ = 0;
		Position _tmp2_ = {0};
		Position _tmp3_ = {0};
		gint _tmp4_ = 0;
		GeeLinkedList* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gpointer _tmp7_ = NULL;
		Worm* _tmp8_ = NULL;
		Position _tmp9_ = {0};
		Position _tmp10_ = {0};
		gint _tmp11_ = 0;
		Position _tmp12_ = {0};
		Position _tmp13_ = {0};
		gint _tmp14_ = 0;
		GeeLinkedList* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		gpointer _tmp17_ = NULL;
		Worm* _tmp18_ = NULL;
		Position _tmp19_ = {0};
		Position _tmp20_ = {0};
		gint _tmp21_ = 0;
		WormDirection _tmp22_ = 0;
#line 625 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp1_ = i;
#line 625 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		i = _tmp1_ - 1;
#line 625 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		if (!(_tmp1_ > 0)) {
#line 625 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			break;
#line 3515 "worm.c"
		}
#line 627 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		worm_get_head (self, &_tmp2_);
#line 627 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp3_ = _tmp2_;
#line 627 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp4_ = _tmp3_.x;
#line 627 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp5_ = worms;
#line 627 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp6_ = i;
#line 627 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp5_, _tmp6_);
#line 627 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp8_ = (Worm*) _tmp7_;
#line 627 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		worm_get_head (_tmp8_, &_tmp9_);
#line 627 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp10_ = _tmp9_;
#line 627 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp11_ = _tmp10_.x;
#line 627 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		dx = _tmp4_ - _tmp11_;
#line 627 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_g_object_unref0 (_tmp8_);
#line 628 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		worm_get_head (self, &_tmp12_);
#line 628 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp13_ = _tmp12_;
#line 628 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp14_ = _tmp13_.y;
#line 628 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp15_ = worms;
#line 628 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp16_ = i;
#line 628 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, _tmp16_);
#line 628 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp18_ = (Worm*) _tmp17_;
#line 628 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		worm_get_head (_tmp18_, &_tmp19_);
#line 628 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp20_ = _tmp19_;
#line 628 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp21_ = _tmp20_.y;
#line 628 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		dy = _tmp14_ - _tmp21_;
#line 628 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_g_object_unref0 (_tmp18_);
#line 629 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp22_ = self->direction;
#line 629 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		switch (_tmp22_) {
#line 629 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			case WORM_DIRECTION_UP:
#line 3571 "worm.c"
			{
				gboolean _tmp23_ = FALSE;
				gboolean _tmp24_ = FALSE;
				gboolean _tmp25_ = FALSE;
				gint _tmp26_ = 0;
#line 632 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp26_ = dy;
#line 632 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				if (_tmp26_ > 0) {
#line 3581 "worm.c"
					gint _tmp27_ = 0;
#line 632 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp27_ = dy;
#line 632 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp25_ = _tmp27_ <= 3;
#line 3587 "worm.c"
				} else {
#line 632 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp25_ = FALSE;
#line 3591 "worm.c"
				}
#line 632 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				if (_tmp25_) {
#line 3595 "worm.c"
					gint _tmp28_ = 0;
#line 632 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp28_ = dx;
#line 632 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp24_ = _tmp28_ >= -1;
#line 3601 "worm.c"
				} else {
#line 632 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp24_ = FALSE;
#line 3605 "worm.c"
				}
#line 632 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				if (_tmp24_) {
#line 3609 "worm.c"
					gint _tmp29_ = 0;
#line 632 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp29_ = dx;
#line 632 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp23_ = _tmp29_ <= 1;
#line 3615 "worm.c"
				} else {
#line 632 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp23_ = FALSE;
#line 3619 "worm.c"
				}
#line 632 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				if (_tmp23_) {
#line 633 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					result = TRUE;
#line 633 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					return result;
#line 3627 "worm.c"
				}
#line 634 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				break;
#line 3631 "worm.c"
			}
#line 629 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			case WORM_DIRECTION_DOWN:
#line 3635 "worm.c"
			{
				gboolean _tmp30_ = FALSE;
				gboolean _tmp31_ = FALSE;
				gboolean _tmp32_ = FALSE;
				gint _tmp33_ = 0;
#line 636 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp33_ = dy;
#line 636 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				if (_tmp33_ < 0) {
#line 3645 "worm.c"
					gint _tmp34_ = 0;
#line 636 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp34_ = dy;
#line 636 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp32_ = _tmp34_ >= -3;
#line 3651 "worm.c"
				} else {
#line 636 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp32_ = FALSE;
#line 3655 "worm.c"
				}
#line 636 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				if (_tmp32_) {
#line 3659 "worm.c"
					gint _tmp35_ = 0;
#line 636 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp35_ = dx;
#line 636 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp31_ = _tmp35_ >= -1;
#line 3665 "worm.c"
				} else {
#line 636 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp31_ = FALSE;
#line 3669 "worm.c"
				}
#line 636 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				if (_tmp31_) {
#line 3673 "worm.c"
					gint _tmp36_ = 0;
#line 636 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp36_ = dx;
#line 636 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp30_ = _tmp36_ <= 1;
#line 3679 "worm.c"
				} else {
#line 636 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp30_ = FALSE;
#line 3683 "worm.c"
				}
#line 636 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				if (_tmp30_) {
#line 637 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					result = TRUE;
#line 637 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					return result;
#line 3691 "worm.c"
				}
#line 638 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				break;
#line 3695 "worm.c"
			}
#line 629 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			case WORM_DIRECTION_LEFT:
#line 3699 "worm.c"
			{
				gboolean _tmp37_ = FALSE;
				gboolean _tmp38_ = FALSE;
				gboolean _tmp39_ = FALSE;
				gint _tmp40_ = 0;
#line 640 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp40_ = dx;
#line 640 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				if (_tmp40_ > 0) {
#line 3709 "worm.c"
					gint _tmp41_ = 0;
#line 640 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp41_ = dx;
#line 640 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp39_ = _tmp41_ <= 3;
#line 3715 "worm.c"
				} else {
#line 640 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp39_ = FALSE;
#line 3719 "worm.c"
				}
#line 640 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				if (_tmp39_) {
#line 3723 "worm.c"
					gint _tmp42_ = 0;
#line 640 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp42_ = dy;
#line 640 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp38_ = _tmp42_ >= -1;
#line 3729 "worm.c"
				} else {
#line 640 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp38_ = FALSE;
#line 3733 "worm.c"
				}
#line 640 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				if (_tmp38_) {
#line 3737 "worm.c"
					gint _tmp43_ = 0;
#line 640 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp43_ = dy;
#line 640 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp37_ = _tmp43_ <= 1;
#line 3743 "worm.c"
				} else {
#line 640 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp37_ = FALSE;
#line 3747 "worm.c"
				}
#line 640 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				if (_tmp37_) {
#line 641 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					result = TRUE;
#line 641 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					return result;
#line 3755 "worm.c"
				}
#line 642 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				break;
#line 3759 "worm.c"
			}
#line 629 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			case WORM_DIRECTION_RIGHT:
#line 3763 "worm.c"
			{
				gboolean _tmp44_ = FALSE;
				gboolean _tmp45_ = FALSE;
				gboolean _tmp46_ = FALSE;
				gint _tmp47_ = 0;
#line 644 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp47_ = dx;
#line 644 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				if (_tmp47_ < 0) {
#line 3773 "worm.c"
					gint _tmp48_ = 0;
#line 644 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp48_ = dx;
#line 644 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp46_ = _tmp48_ >= -3;
#line 3779 "worm.c"
				} else {
#line 644 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp46_ = FALSE;
#line 3783 "worm.c"
				}
#line 644 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				if (_tmp46_) {
#line 3787 "worm.c"
					gint _tmp49_ = 0;
#line 644 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp49_ = dy;
#line 644 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp45_ = _tmp49_ >= -1;
#line 3793 "worm.c"
				} else {
#line 644 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp45_ = FALSE;
#line 3797 "worm.c"
				}
#line 644 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				if (_tmp45_) {
#line 3801 "worm.c"
					gint _tmp50_ = 0;
#line 644 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp50_ = dy;
#line 644 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp44_ = _tmp50_ <= 1;
#line 3807 "worm.c"
				} else {
#line 644 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp44_ = FALSE;
#line 3811 "worm.c"
				}
#line 644 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				if (_tmp44_) {
#line 645 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					result = TRUE;
#line 645 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					return result;
#line 3819 "worm.c"
				}
#line 646 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				break;
#line 3823 "worm.c"
			}
			default:
#line 629 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			break;
#line 3828 "worm.c"
		}
	}
#line 650 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	result = FALSE;
#line 650 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	return result;
#line 3835 "worm.c"
}


static gboolean worm_ai_wander (gint* board, int board_length1, int board_length2, gint numworms, gint x, gint y, gint dir, gint ox, gint oy) {
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint* _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	gint _tmp11__length2 = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
#line 655 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp0_ = dir;
#line 655 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp0_ > 4) {
#line 656 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		dir = 1;
#line 3860 "worm.c"
	}
#line 657 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp1_ = dir;
#line 657 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp1_ < 1) {
#line 658 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		dir = 4;
#line 3868 "worm.c"
	}
#line 660 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp2_ = dir;
#line 660 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	switch (_tmp2_) {
#line 660 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		case WORM_DIRECTION_UP:
#line 3876 "worm.c"
		{
			gint _tmp3_ = 0;
#line 663 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp3_ = y;
#line 663 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			y = _tmp3_ - 1;
#line 664 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			break;
#line 3885 "worm.c"
		}
#line 660 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		case WORM_DIRECTION_DOWN:
#line 3889 "worm.c"
		{
			gint _tmp4_ = 0;
#line 666 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp4_ = y;
#line 666 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			y = _tmp4_ + 1;
#line 667 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			break;
#line 3898 "worm.c"
		}
#line 660 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		case WORM_DIRECTION_LEFT:
#line 3902 "worm.c"
		{
			gint _tmp5_ = 0;
#line 669 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp5_ = x;
#line 669 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			x = _tmp5_ - 1;
#line 670 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			break;
#line 3911 "worm.c"
		}
#line 660 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		case WORM_DIRECTION_RIGHT:
#line 3915 "worm.c"
		{
			gint _tmp6_ = 0;
#line 672 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp6_ = x;
#line 672 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			x = _tmp6_ + 1;
#line 673 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			break;
#line 3924 "worm.c"
		}
		default:
#line 660 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		break;
#line 3929 "worm.c"
	}
#line 676 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp7_ = x;
#line 676 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp7_ >= NIBBLES_GAME_WIDTH) {
#line 677 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		x = 0;
#line 3937 "worm.c"
	}
#line 678 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp8_ = x;
#line 678 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp8_ < 0) {
#line 679 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		x = NIBBLES_GAME_WIDTH - 1;
#line 3945 "worm.c"
	}
#line 680 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp9_ = y;
#line 680 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp9_ >= NIBBLES_GAME_HEIGHT) {
#line 681 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		y = 0;
#line 3953 "worm.c"
	}
#line 682 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp10_ = y;
#line 682 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (_tmp10_ < 0) {
#line 683 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		y = NIBBLES_GAME_HEIGHT - 1;
#line 3961 "worm.c"
	}
#line 685 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp11_ = board;
#line 685 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp11__length1 = board_length1;
#line 685 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp11__length2 = board_length2;
#line 685 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp12_ = x;
#line 685 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp13_ = y;
#line 685 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp14_ = _tmp11_[(_tmp12_ * _tmp11__length2) + _tmp13_];
#line 685 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	switch (_tmp14_ - 'A') {
#line 685 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		case BONUS_TYPE_REGULAR:
#line 3979 "worm.c"
		{
#line 688 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			result = TRUE;
#line 688 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			return result;
#line 3985 "worm.c"
		}
#line 685 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		case BONUS_TYPE_DOUBLE:
#line 3989 "worm.c"
		{
#line 690 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			result = TRUE;
#line 690 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			return result;
#line 3995 "worm.c"
		}
#line 685 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		case BONUS_TYPE_LIFE:
#line 3999 "worm.c"
		{
#line 692 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			result = TRUE;
#line 692 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			return result;
#line 4005 "worm.c"
		}
#line 685 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		case BONUS_TYPE_REVERSE:
#line 4009 "worm.c"
		{
#line 694 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			result = TRUE;
#line 694 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			return result;
#line 4015 "worm.c"
		}
#line 685 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		case BONUS_TYPE_HALF:
#line 4019 "worm.c"
		{
#line 696 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			result = FALSE;
#line 696 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			return result;
#line 4025 "worm.c"
		}
		default:
		{
			gboolean _tmp15_ = FALSE;
			gint* _tmp16_ = NULL;
			gint _tmp16__length1 = 0;
			gint _tmp16__length2 = 0;
			gint _tmp17_ = 0;
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
#line 698 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp16_ = board;
#line 698 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp16__length1 = board_length1;
#line 698 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp16__length2 = board_length2;
#line 698 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp17_ = x;
#line 698 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp18_ = y;
#line 698 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp19_ = _tmp16_[(_tmp17_ * _tmp16__length2) + _tmp18_];
#line 698 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			if (_tmp19_ > ((gint) NIBBLES_GAME_EMPTYCHAR)) {
#line 4050 "worm.c"
				gint* _tmp20_ = NULL;
				gint _tmp20__length1 = 0;
				gint _tmp20__length2 = 0;
				gint _tmp21_ = 0;
				gint _tmp22_ = 0;
				gint _tmp23_ = 0;
				gint _tmp24_ = 0;
#line 699 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp20_ = board;
#line 699 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp20__length1 = board_length1;
#line 699 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp20__length2 = board_length2;
#line 699 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp21_ = x;
#line 699 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp22_ = y;
#line 699 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp23_ = _tmp20_[(_tmp21_ * _tmp20__length2) + _tmp22_];
#line 699 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp24_ = numworms;
#line 699 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp15_ = _tmp23_ < ('z' + _tmp24_);
#line 4074 "worm.c"
			} else {
#line 698 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp15_ = FALSE;
#line 4078 "worm.c"
			}
#line 698 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			if (_tmp15_) {
#line 701 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				result = FALSE;
#line 701 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				return result;
#line 4086 "worm.c"
			} else {
				gboolean _tmp25_ = FALSE;
				gint _tmp26_ = 0;
				gint _tmp27_ = 0;
				gint* _tmp30_ = NULL;
				gint _tmp30__length1 = 0;
				gint _tmp30__length2 = 0;
				gint _tmp31_ = 0;
				gint _tmp32_ = 0;
				gint _tmp33_ = 0;
				gint _tmp34_ = 0;
				gint _tmp35_ = 0;
				gint _tmp36_ = 0;
				gboolean _tmp37_ = FALSE;
#line 705 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp26_ = ox;
#line 705 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp27_ = x;
#line 705 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				if (_tmp26_ == _tmp27_) {
#line 4107 "worm.c"
					gint _tmp28_ = 0;
					gint _tmp29_ = 0;
#line 705 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp28_ = oy;
#line 705 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp29_ = y;
#line 705 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp25_ = _tmp28_ == _tmp29_;
#line 4116 "worm.c"
				} else {
#line 705 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp25_ = FALSE;
#line 4120 "worm.c"
				}
#line 705 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				if (_tmp25_) {
#line 706 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					result = FALSE;
#line 706 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					return result;
#line 4128 "worm.c"
				}
#line 708 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp30_ = board;
#line 708 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp30__length1 = board_length1;
#line 708 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp30__length2 = board_length2;
#line 708 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp31_ = numworms;
#line 708 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp32_ = x;
#line 708 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp33_ = y;
#line 708 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp34_ = dir;
#line 708 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp35_ = ox;
#line 708 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp36_ = oy;
#line 708 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp37_ = worm_ai_wander (_tmp30_, _tmp30__length1, _tmp30__length2, _tmp31_, _tmp32_, _tmp33_, _tmp34_, _tmp35_, _tmp36_);
#line 708 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				result = _tmp37_;
#line 708 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				return result;
#line 4154 "worm.c"
			}
		}
	}
}


void worm_ai_move (Worm* self, gint* board, int board_length1, int board_length2, gint numworms, GeeLinkedList* worms) {
	WormDirection opposite = 0;
	WormDirection _tmp0_ = 0;
	gboolean front = FALSE;
	gint* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint _tmp1__length2 = 0;
	gint _tmp2_ = 0;
	Position _tmp3_ = {0};
	Position _tmp4_ = {0};
	gint _tmp5_ = 0;
	Position _tmp6_ = {0};
	Position _tmp7_ = {0};
	gint _tmp8_ = 0;
	WormDirection _tmp9_ = 0;
	Position _tmp10_ = {0};
	Position _tmp11_ = {0};
	gint _tmp12_ = 0;
	Position _tmp13_ = {0};
	Position _tmp14_ = {0};
	gint _tmp15_ = 0;
	gboolean _tmp16_ = FALSE;
	gboolean left = FALSE;
	gint* _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	gint _tmp17__length2 = 0;
	gint _tmp18_ = 0;
	Position _tmp19_ = {0};
	Position _tmp20_ = {0};
	gint _tmp21_ = 0;
	Position _tmp22_ = {0};
	Position _tmp23_ = {0};
	gint _tmp24_ = 0;
	WormDirection _tmp25_ = 0;
	Position _tmp26_ = {0};
	Position _tmp27_ = {0};
	gint _tmp28_ = 0;
	Position _tmp29_ = {0};
	Position _tmp30_ = {0};
	gint _tmp31_ = 0;
	gboolean _tmp32_ = FALSE;
	gboolean right = FALSE;
	gint* _tmp33_ = NULL;
	gint _tmp33__length1 = 0;
	gint _tmp33__length2 = 0;
	gint _tmp34_ = 0;
	Position _tmp35_ = {0};
	Position _tmp36_ = {0};
	gint _tmp37_ = 0;
	Position _tmp38_ = {0};
	Position _tmp39_ = {0};
	gint _tmp40_ = 0;
	WormDirection _tmp41_ = 0;
	Position _tmp42_ = {0};
	Position _tmp43_ = {0};
	gint _tmp44_ = 0;
	Position _tmp45_ = {0};
	Position _tmp46_ = {0};
	gint _tmp47_ = 0;
	gboolean _tmp48_ = FALSE;
	gint dir = 0;
	gboolean _tmp49_ = FALSE;
	WormDirection old_dir = 0;
	WormDirection _tmp67_ = 0;
	gint best_yet = 0;
	gint best_dir = 0;
	gint this_len = 0;
	gint _tmp109_ = 0;
#line 714 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_return_if_fail (self != NULL);
#line 714 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_return_if_fail (worms != NULL);
#line 716 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp0_ = self->direction;
#line 716 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	opposite = ((_tmp0_ + 1) % 4) + 1;
#line 718 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp1_ = board;
#line 718 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp1__length1 = board_length1;
#line 718 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp1__length2 = board_length2;
#line 718 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp2_ = numworms;
#line 718 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	worm_get_head (self, &_tmp3_);
#line 718 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp4_ = _tmp3_;
#line 718 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp5_ = _tmp4_.x;
#line 718 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	worm_get_head (self, &_tmp6_);
#line 718 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp7_ = _tmp6_;
#line 718 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp8_ = _tmp7_.y;
#line 718 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp9_ = self->direction;
#line 718 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	worm_get_head (self, &_tmp10_);
#line 718 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp11_ = _tmp10_;
#line 718 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp12_ = _tmp11_.x;
#line 718 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	worm_get_head (self, &_tmp13_);
#line 718 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp14_ = _tmp13_;
#line 718 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp15_ = _tmp14_.y;
#line 718 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp16_ = worm_ai_wander (_tmp1_, _tmp1__length1, _tmp1__length2, _tmp2_, _tmp5_, _tmp8_, (gint) _tmp9_, _tmp12_, _tmp15_);
#line 718 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	front = _tmp16_;
#line 719 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp17_ = board;
#line 719 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp17__length1 = board_length1;
#line 719 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp17__length2 = board_length2;
#line 719 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp18_ = numworms;
#line 719 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	worm_get_head (self, &_tmp19_);
#line 719 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp20_ = _tmp19_;
#line 719 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp21_ = _tmp20_.x;
#line 719 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	worm_get_head (self, &_tmp22_);
#line 719 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp23_ = _tmp22_;
#line 719 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp24_ = _tmp23_.y;
#line 719 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp25_ = self->direction;
#line 719 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	worm_get_head (self, &_tmp26_);
#line 719 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp27_ = _tmp26_;
#line 719 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp28_ = _tmp27_.x;
#line 719 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	worm_get_head (self, &_tmp29_);
#line 719 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp30_ = _tmp29_;
#line 719 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp31_ = _tmp30_.y;
#line 719 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp32_ = worm_ai_wander (_tmp17_, _tmp17__length1, _tmp17__length2, _tmp18_, _tmp21_, _tmp24_, (gint) (_tmp25_ - 1), _tmp28_, _tmp31_);
#line 719 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	left = _tmp32_;
#line 720 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp33_ = board;
#line 720 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp33__length1 = board_length1;
#line 720 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp33__length2 = board_length2;
#line 720 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp34_ = numworms;
#line 720 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	worm_get_head (self, &_tmp35_);
#line 720 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp36_ = _tmp35_;
#line 720 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp37_ = _tmp36_.x;
#line 720 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	worm_get_head (self, &_tmp38_);
#line 720 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp39_ = _tmp38_;
#line 720 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp40_ = _tmp39_.y;
#line 720 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp41_ = self->direction;
#line 720 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	worm_get_head (self, &_tmp42_);
#line 720 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp43_ = _tmp42_;
#line 720 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp44_ = _tmp43_.x;
#line 720 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	worm_get_head (self, &_tmp45_);
#line 720 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp46_ = _tmp45_;
#line 720 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp47_ = _tmp46_.y;
#line 720 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp48_ = worm_ai_wander (_tmp33_, _tmp33__length1, _tmp33__length2, _tmp34_, _tmp37_, _tmp40_, (gint) (_tmp41_ + 1), _tmp44_, _tmp47_);
#line 720 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	right = _tmp48_;
#line 723 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp49_ = front;
#line 723 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	if (!_tmp49_) {
#line 4355 "worm.c"
		gboolean _tmp50_ = FALSE;
#line 725 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp50_ = left;
#line 725 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		if (_tmp50_) {
#line 4361 "worm.c"
			WormDirection _tmp51_ = 0;
			gint _tmp52_ = 0;
			gint _tmp53_ = 0;
#line 728 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp51_ = self->direction;
#line 728 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			dir = (gint) (_tmp51_ - 1);
#line 729 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp52_ = dir;
#line 729 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			if (_tmp52_ < 1) {
#line 730 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				dir = 4;
#line 4375 "worm.c"
			}
#line 732 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp53_ = dir;
#line 732 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			self->direction = (WormDirection) _tmp53_;
#line 4381 "worm.c"
		} else {
			gboolean _tmp54_ = FALSE;
#line 734 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp54_ = right;
#line 734 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			if (_tmp54_) {
#line 4388 "worm.c"
				WormDirection _tmp55_ = 0;
				gint _tmp56_ = 0;
				gint _tmp57_ = 0;
#line 737 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp55_ = self->direction;
#line 737 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				dir = (gint) (_tmp55_ + 1);
#line 738 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp56_ = dir;
#line 738 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				if (_tmp56_ > 4) {
#line 739 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					dir = 1;
#line 4402 "worm.c"
				}
#line 741 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp57_ = dir;
#line 741 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				self->direction = (WormDirection) _tmp57_;
#line 4408 "worm.c"
			} else {
				gint32 _tmp58_ = 0;
#line 746 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp58_ = g_random_int_range ((gint32) 0, (gint32) 30);
#line 746 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				if (_tmp58_ == ((gint32) 1)) {
#line 4415 "worm.c"
					gint _tmp59_ = 0;
					gboolean _tmp60_ = FALSE;
					WormDirection _tmp61_ = 0;
					gint _tmp62_ = 0;
					WormDirection _tmp63_ = 0;
#line 748 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp60_ = g_random_boolean ();
#line 748 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					if (_tmp60_) {
#line 748 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
						_tmp59_ = 1;
#line 4427 "worm.c"
					} else {
#line 748 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
						_tmp59_ = -1;
#line 4431 "worm.c"
					}
#line 748 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp61_ = self->direction;
#line 748 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					dir = (gint) (_tmp61_ + _tmp59_);
#line 749 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp62_ = dir;
#line 749 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					_tmp63_ = opposite;
#line 749 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
					if (_tmp62_ != ((gint) _tmp63_)) {
#line 4443 "worm.c"
						gint _tmp64_ = 0;
						gint _tmp65_ = 0;
						gint _tmp66_ = 0;
#line 751 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
						_tmp64_ = dir;
#line 751 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
						if (_tmp64_ > 4) {
#line 752 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
							dir = 1;
#line 4453 "worm.c"
						}
#line 753 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
						_tmp65_ = dir;
#line 753 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
						if (_tmp65_ < 1) {
#line 754 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
							dir = 4;
#line 4461 "worm.c"
						}
#line 756 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
						_tmp66_ = dir;
#line 756 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
						self->direction = (WormDirection) _tmp66_;
#line 4467 "worm.c"
					}
				}
			}
		}
	}
#line 773 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp67_ = self->direction;
#line 773 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	old_dir = _tmp67_;
#line 774 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	best_yet = NIBBLES_GAME_CAPACITY * 2;
#line 775 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	best_dir = -1;
#line 4481 "worm.c"
	{
		gboolean _tmp68_ = FALSE;
#line 778 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		dir = 1;
#line 778 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp68_ = TRUE;
#line 778 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		while (TRUE) {
#line 4490 "worm.c"
			gint _tmp70_ = 0;
			gint _tmp71_ = 0;
			gint _tmp72_ = 0;
			WormDirection _tmp73_ = 0;
			gint* _tmp74_ = NULL;
			gint _tmp74__length1 = 0;
			gint _tmp74__length2 = 0;
			gint _tmp75_ = 0;
			gboolean _tmp76_ = FALSE;
			GeeLinkedList* _tmp78_ = NULL;
			gint _tmp79_ = 0;
			gboolean _tmp80_ = FALSE;
			gint _tmp82_ = 0;
			gint* _tmp83_ = NULL;
			gint _tmp83__length1 = 0;
			gint _tmp83__length2 = 0;
			GeeLinkedList* _tmp84_ = NULL;
			gint _tmp85_ = 0;
			Position _tmp86_ = {0};
			Position _tmp87_ = {0};
			gint _tmp88_ = 0;
			Position _tmp89_ = {0};
			Position _tmp90_ = {0};
			gint _tmp91_ = 0;
			gint _tmp92_ = 0;
			gint _tmp93_ = 0;
			gint _tmp94_ = 0;
			gint _tmp95_ = 0;
			gint _tmp96_ = 0;
			gboolean _tmp97_ = FALSE;
			gint _tmp98_ = 0;
			WormDirection _tmp99_ = 0;
			gint _tmp102_ = 0;
			gint _tmp105_ = 0;
			gint _tmp106_ = 0;
#line 778 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			if (!_tmp68_) {
#line 4528 "worm.c"
				gint _tmp69_ = 0;
#line 778 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp69_ = dir;
#line 778 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				dir = _tmp69_ + 1;
#line 4534 "worm.c"
			}
#line 778 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp68_ = FALSE;
#line 778 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp70_ = dir;
#line 778 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			if (!(_tmp70_ <= 4)) {
#line 778 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				break;
#line 4544 "worm.c"
			}
#line 780 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp71_ = dir;
#line 780 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			self->direction = (WormDirection) _tmp71_;
#line 782 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp72_ = dir;
#line 782 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp73_ = opposite;
#line 782 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			if (_tmp72_ == ((gint) _tmp73_)) {
#line 783 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				continue;
#line 4558 "worm.c"
			}
#line 784 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			this_len = 0;
#line 786 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp74_ = board;
#line 786 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp74__length1 = board_length1;
#line 786 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp74__length2 = board_length2;
#line 786 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp75_ = numworms;
#line 786 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp76_ = worm_can_move_to (self, _tmp74_, _tmp74__length1, _tmp74__length2, _tmp75_);
#line 786 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			if (!_tmp76_) {
#line 4574 "worm.c"
				gint _tmp77_ = 0;
#line 787 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp77_ = this_len;
#line 787 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				this_len = _tmp77_ + NIBBLES_GAME_CAPACITY;
#line 4580 "worm.c"
			}
#line 789 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp78_ = worms;
#line 789 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp79_ = numworms;
#line 789 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp80_ = worm_ai_too_close (self, _tmp78_, _tmp79_);
#line 789 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			if (_tmp80_) {
#line 4590 "worm.c"
				gint _tmp81_ = 0;
#line 790 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp81_ = this_len;
#line 790 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				this_len = _tmp81_ + 4;
#line 4596 "worm.c"
			}
#line 792 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp82_ = this_len;
#line 792 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp83_ = board;
#line 792 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp83__length1 = board_length1;
#line 792 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp83__length2 = board_length2;
#line 792 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp84_ = worms;
#line 792 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp85_ = numworms;
#line 792 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			worm_get_head (self, &_tmp86_);
#line 792 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp87_ = _tmp86_;
#line 792 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp88_ = _tmp87_.x;
#line 792 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			worm_get_head (self, &_tmp89_);
#line 792 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp90_ = _tmp89_;
#line 792 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp91_ = _tmp90_.y;
#line 792 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp92_ = dir;
#line 792 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp93_ = worm_get_length (self);
#line 792 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp94_ = _tmp93_;
#line 792 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp95_ = self->change;
#line 792 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp96_ = worm_ai_deadend_after (_tmp83_, _tmp83__length1, _tmp83__length2, _tmp84_, _tmp85_, _tmp88_, _tmp91_, _tmp92_, _tmp94_ + _tmp95_);
#line 792 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			this_len = _tmp82_ + _tmp96_;
#line 794 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp98_ = dir;
#line 794 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp99_ = old_dir;
#line 794 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			if (_tmp98_ == ((gint) _tmp99_)) {
#line 4640 "worm.c"
				gint _tmp100_ = 0;
#line 794 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp100_ = this_len;
#line 794 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp97_ = _tmp100_ <= 0;
#line 4646 "worm.c"
			} else {
#line 794 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp97_ = FALSE;
#line 4650 "worm.c"
			}
#line 794 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			if (_tmp97_) {
#line 4654 "worm.c"
				gint _tmp101_ = 0;
#line 795 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp101_ = this_len;
#line 795 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				this_len = _tmp101_ - 100;
#line 4660 "worm.c"
			}
#line 802 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp102_ = this_len;
#line 802 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			if (_tmp102_ <= 0) {
#line 4666 "worm.c"
				gint _tmp103_ = 0;
				gint32 _tmp104_ = 0;
#line 803 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp103_ = this_len;
#line 803 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp104_ = g_random_int_range ((gint32) 0, (gint32) 100);
#line 803 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				this_len = _tmp103_ - _tmp104_;
#line 4675 "worm.c"
			}
#line 804 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp105_ = this_len;
#line 804 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp106_ = best_yet;
#line 804 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			if (_tmp105_ < _tmp106_) {
#line 4683 "worm.c"
				gint _tmp107_ = 0;
				gint _tmp108_ = 0;
#line 806 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp107_ = this_len;
#line 806 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				best_yet = _tmp107_;
#line 807 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp108_ = dir;
#line 807 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				best_dir = _tmp108_;
#line 4694 "worm.c"
			}
		}
	}
#line 811 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp109_ = best_dir;
#line 811 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	self->direction = (WormDirection) _tmp109_;
#line 4702 "worm.c"
	{
		gboolean _tmp110_ = FALSE;
#line 816 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		dir = 1;
#line 816 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		_tmp110_ = TRUE;
#line 816 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		while (TRUE) {
#line 4711 "worm.c"
			gint _tmp112_ = 0;
			gint _tmp113_ = 0;
			WormDirection _tmp114_ = 0;
			gint* _tmp115_ = NULL;
			gint _tmp115__length1 = 0;
			gint _tmp115__length2 = 0;
			gint _tmp116_ = 0;
			gboolean _tmp117_ = FALSE;
#line 816 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			if (!_tmp110_) {
#line 4722 "worm.c"
				gint _tmp111_ = 0;
#line 816 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp111_ = dir;
#line 816 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				dir = _tmp111_ + 1;
#line 4728 "worm.c"
			}
#line 816 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp110_ = FALSE;
#line 816 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp112_ = dir;
#line 816 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			if (!(_tmp112_ <= 4)) {
#line 816 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				break;
#line 4738 "worm.c"
			}
#line 818 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp113_ = dir;
#line 818 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp114_ = opposite;
#line 818 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			if (_tmp113_ == ((gint) _tmp114_)) {
#line 819 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				continue;
#line 4748 "worm.c"
			}
#line 821 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp115_ = board;
#line 821 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp115__length1 = board_length1;
#line 821 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp115__length2 = board_length2;
#line 821 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp116_ = numworms;
#line 821 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			_tmp117_ = worm_can_move_to (self, _tmp115_, _tmp115__length1, _tmp115__length2, _tmp116_);
#line 821 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			if (!_tmp117_) {
#line 4762 "worm.c"
				gint _tmp118_ = 0;
#line 822 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				_tmp118_ = dir;
#line 822 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				self->direction = (WormDirection) _tmp118_;
#line 4768 "worm.c"
			} else {
#line 824 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
				continue;
#line 4772 "worm.c"
			}
		}
	}
}


void worm_get_starting_position (Worm* self, Position* result) {
	Position _tmp0_ = {0};
#line 54 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_return_if_fail (self != NULL);
#line 54 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp0_ = self->priv->_starting_position;
#line 54 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	*result = _tmp0_;
#line 54 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	return;
#line 4789 "worm.c"
}


static void worm_set_starting_position (Worm* self, Position* value) {
	Position _tmp0_ = {0};
#line 54 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_return_if_fail (self != NULL);
#line 54 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp0_ = *value;
#line 54 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	self->priv->_starting_position = _tmp0_;
#line 54 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_object_notify ((GObject *) self, "starting-position");
#line 4803 "worm.c"
}


gint worm_get_id (Worm* self) {
	gint result;
	gint _tmp0_ = 0;
#line 56 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 56 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp0_ = self->priv->_id;
#line 56 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	result = _tmp0_;
#line 56 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	return result;
#line 4818 "worm.c"
}


static void worm_set_id (Worm* self, gint value) {
	gint _tmp0_ = 0;
#line 56 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_return_if_fail (self != NULL);
#line 56 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp0_ = value;
#line 56 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	self->priv->_id = _tmp0_;
#line 56 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_object_notify ((GObject *) self, "id");
#line 4832 "worm.c"
}


gboolean worm_get_is_materialized (Worm* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 61 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 61 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp0_ = self->priv->_is_materialized;
#line 61 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	result = _tmp0_;
#line 61 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	return result;
#line 4847 "worm.c"
}


static void worm_set_is_materialized (Worm* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 61 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_return_if_fail (self != NULL);
#line 61 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp0_ = value;
#line 61 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	self->priv->_is_materialized = _tmp0_;
#line 61 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_object_notify ((GObject *) self, "is-materialized");
#line 4861 "worm.c"
}


gint worm_get_lives (Worm* self) {
	gint result;
	gint _tmp0_ = 0;
#line 64 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 64 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp0_ = self->priv->_lives;
#line 64 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	result = _tmp0_;
#line 64 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	return result;
#line 4876 "worm.c"
}


void worm_set_lives (Worm* self, gint value) {
	gint _tmp0_ = 0;
#line 64 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_return_if_fail (self != NULL);
#line 64 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp0_ = value;
#line 64 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	self->priv->_lives = _tmp0_;
#line 64 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_object_notify ((GObject *) self, "lives");
#line 4890 "worm.c"
}


gint worm_get_score (Worm* self) {
	gint result;
	gint _tmp0_ = 0;
#line 66 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 66 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp0_ = self->priv->_score;
#line 66 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	result = _tmp0_;
#line 66 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	return result;
#line 4905 "worm.c"
}


void worm_set_score (Worm* self, gint value) {
	gint _tmp0_ = 0;
#line 66 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_return_if_fail (self != NULL);
#line 66 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp0_ = value;
#line 66 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	self->priv->_score = _tmp0_;
#line 66 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_object_notify ((GObject *) self, "score");
#line 4919 "worm.c"
}


gint worm_get_length (Worm* self) {
	gint result;
	GeeLinkedList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 70 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 70 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp0_ = self->priv->_list;
#line 70 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp1_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp0_);
#line 70 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp2_ = _tmp1_;
#line 70 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	result = _tmp2_;
#line 70 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	return result;
#line 4940 "worm.c"
}


void worm_set_length (Worm* self, gint value) {
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_return_if_fail (self != NULL);
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_object_notify ((GObject *) self, "length");
#line 4949 "worm.c"
}


void worm_get_head (Worm* self, Position* result) {
	Position head = {0};
	GeeLinkedList* _tmp0_ = NULL;
	gpointer _tmp1_ = NULL;
	Position* _tmp2_ = NULL;
	Position _tmp3_ = {0};
	Position _tmp4_ = {0};
#line 76 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_return_if_fail (self != NULL);
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp0_ = self->priv->_list;
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp1_ = gee_linked_list_first (_tmp0_);
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp2_ = (Position*) _tmp1_;
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp3_ = *_tmp2_;
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_position_free0 (_tmp2_);
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	head = _tmp3_;
#line 79 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp4_ = head;
#line 79 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	*result = _tmp4_;
#line 79 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	return;
#line 4980 "worm.c"
}


static void worm_set_head (Worm* self, Position* value) {
	GeeLinkedList* _tmp0_ = NULL;
	Position _tmp1_ = {0};
#line 81 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_return_if_fail (self != NULL);
#line 83 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp0_ = self->priv->_list;
#line 83 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp1_ = *value;
#line 83 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	gee_abstract_list_set ((GeeAbstractList*) _tmp0_, 0, &_tmp1_);
#line 81 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_object_notify ((GObject *) self, "head");
#line 4997 "worm.c"
}


GeeLinkedList* worm_get_list (Worm* self) {
	GeeLinkedList* result;
	GeeLinkedList* _tmp0_ = NULL;
#line 93 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 93 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp0_ = self->priv->_list;
#line 93 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	result = _tmp0_;
#line 93 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	return result;
#line 5012 "worm.c"
}


static void worm_set_list (Worm* self, GeeLinkedList* value) {
	GeeLinkedList* _tmp0_ = NULL;
	GeeLinkedList* _tmp1_ = NULL;
#line 93 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_return_if_fail (self != NULL);
#line 93 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp0_ = value;
#line 93 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 93 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_g_object_unref0 (self->priv->_list);
#line 93 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	self->priv->_list = _tmp1_;
#line 93 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_object_notify ((GObject *) self, "list");
#line 5031 "worm.c"
}


static void worm_class_init (WormClass * klass) {
	guint* _tmp0_ = NULL;
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	worm_parent_class = g_type_class_peek_parent (klass);
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_type_class_add_private (klass, sizeof (WormPrivate));
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_worm_get_property;
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_worm_set_property;
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	G_OBJECT_CLASS (klass)->finalize = worm_finalize;
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), WORM_STARTING_POSITION, g_param_spec_boxed ("starting-position", "starting-position", "starting-position", TYPE_POSITION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), WORM_ID, g_param_spec_int ("id", "id", "id", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), WORM_IS_MATERIALIZED, g_param_spec_boolean ("is-materialized", "is-materialized", "is-materialized", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), WORM_LIVES, g_param_spec_int ("lives", "lives", "lives", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), WORM_SCORE, g_param_spec_int ("score", "score", "score", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), WORM_LENGTH, g_param_spec_int ("length", "length", "length", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), WORM_HEAD, g_param_spec_boxed ("head", "head", "head", TYPE_POSITION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), WORM_LIST, g_param_spec_object ("list", "list", "list", GEE_TYPE_LINKED_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_signal_new ("added", TYPE_WORM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_signal_new ("finish_added", TYPE_WORM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_signal_new ("moved", TYPE_WORM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_signal_new ("rescaled", TYPE_WORM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_signal_new ("died", TYPE_WORM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_signal_new ("tail_reduced", TYPE_WORM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_signal_new ("reversed", TYPE_WORM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_signal_new ("bonus_found", TYPE_WORM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	g_signal_new ("warp_found", TYPE_WORM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 477 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_tmp0_ = g_new0 (guint, NIBBLES_GAME_WIDTH * NIBBLES_GAME_HEIGHT);
#line 477 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	worm_deadend_board = _tmp0_;
#line 477 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	worm_deadend_board_length1 = NIBBLES_GAME_WIDTH;
#line 477 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	worm_deadend_board_length2 = NIBBLES_GAME_HEIGHT;
#line 5089 "worm.c"
}


static void worm_instance_init (Worm * self) {
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	self->priv = WORM_GET_PRIVATE (self);
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	self->keypress = FALSE;
#line 60 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	self->is_stopped = FALSE;
#line 61 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	self->priv->_is_materialized = TRUE;
#line 5102 "worm.c"
}


static void worm_finalize (GObject* obj) {
	Worm * self;
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_WORM, Worm);
#line 91 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_g_object_unref0 (self->priv->key_queue);
#line 93 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	_g_object_unref0 (self->priv->_list);
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	G_OBJECT_CLASS (worm_parent_class)->finalize (obj);
#line 5116 "worm.c"
}


GType worm_get_type (void) {
	static volatile gsize worm_type_id__volatile = 0;
	if (g_once_init_enter (&worm_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (WormClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) worm_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Worm), 0, (GInstanceInitFunc) worm_instance_init, NULL };
		GType worm_type_id;
		worm_type_id = g_type_register_static (G_TYPE_OBJECT, "Worm", &g_define_type_info, 0);
		g_once_init_leave (&worm_type_id__volatile, worm_type_id);
	}
	return worm_type_id__volatile;
}


static void _vala_worm_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Worm * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_WORM, Worm);
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	switch (property_id) {
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		case WORM_STARTING_POSITION:
#line 5139 "worm.c"
		{
			Position boxed;
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			worm_get_starting_position (self, &boxed);
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			g_value_set_boxed (value, &boxed);
#line 5146 "worm.c"
		}
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		break;
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		case WORM_ID:
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		g_value_set_int (value, worm_get_id (self));
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		break;
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		case WORM_IS_MATERIALIZED:
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		g_value_set_boolean (value, worm_get_is_materialized (self));
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		break;
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		case WORM_LIVES:
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		g_value_set_int (value, worm_get_lives (self));
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		break;
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		case WORM_SCORE:
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		g_value_set_int (value, worm_get_score (self));
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		break;
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		case WORM_LENGTH:
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		g_value_set_int (value, worm_get_length (self));
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		break;
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		case WORM_HEAD:
#line 5182 "worm.c"
		{
			Position boxed;
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			worm_get_head (self, &boxed);
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
			g_value_set_boxed (value, &boxed);
#line 5189 "worm.c"
		}
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		break;
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		case WORM_LIST:
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		g_value_set_object (value, worm_get_list (self));
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		break;
#line 5199 "worm.c"
		default:
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		break;
#line 5205 "worm.c"
	}
}


static void _vala_worm_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Worm * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_WORM, Worm);
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
	switch (property_id) {
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		case WORM_STARTING_POSITION:
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		worm_set_starting_position (self, g_value_get_boxed (value));
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		break;
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		case WORM_ID:
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		worm_set_id (self, g_value_get_int (value));
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		break;
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		case WORM_IS_MATERIALIZED:
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		worm_set_is_materialized (self, g_value_get_boolean (value));
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		break;
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		case WORM_LIVES:
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		worm_set_lives (self, g_value_get_int (value));
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		break;
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		case WORM_SCORE:
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		worm_set_score (self, g_value_get_int (value));
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		break;
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		case WORM_LENGTH:
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		worm_set_length (self, g_value_get_int (value));
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		break;
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		case WORM_HEAD:
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		worm_set_head (self, g_value_get_boxed (value));
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		break;
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		case WORM_LIST:
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		worm_set_list (self, g_value_get_object (value));
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		break;
#line 5263 "worm.c"
		default:
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 46 "/home/mcatanzaro/src/jhbuild/checkout/gnome-nibbles/src/worm.vala"
		break;
#line 5269 "worm.c"
	}
}



