/* support-repository.c generated by valac 0.34.0.108-f56ac, the Vala compiler
 * generated from support-repository.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2013 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include "libgitg/libgitg.h"
#include <stdlib.h>
#include <string.h>
#include <stdarg.h>
#include <gio/gio.h>
#include <libgit2-glib/ggit.h>
#include <gitg-assert.h>
#include <glib/gstdio.h>
#include <stdio.h>


#define GITG_TEST_TYPE_TEST (gitg_test_test_get_type ())
#define GITG_TEST_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TEST_TYPE_TEST, GitgTestTest))
#define GITG_TEST_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TEST_TYPE_TEST, GitgTestTestClass))
#define GITG_TEST_IS_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TEST_TYPE_TEST))
#define GITG_TEST_IS_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TEST_TYPE_TEST))
#define GITG_TEST_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TEST_TYPE_TEST, GitgTestTestClass))

typedef struct _GitgTestTest GitgTestTest;
typedef struct _GitgTestTestClass GitgTestTestClass;
typedef struct _GitgTestTestPrivate GitgTestTestPrivate;

#define GITG_TEST_TYPE_REPOSITORY (gitg_test_repository_get_type ())
#define GITG_TEST_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TEST_TYPE_REPOSITORY, GitgTestRepository))
#define GITG_TEST_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TEST_TYPE_REPOSITORY, GitgTestRepositoryClass))
#define GITG_TEST_IS_REPOSITORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TEST_TYPE_REPOSITORY))
#define GITG_TEST_IS_REPOSITORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TEST_TYPE_REPOSITORY))
#define GITG_TEST_REPOSITORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TEST_TYPE_REPOSITORY, GitgTestRepositoryClass))

typedef struct _GitgTestRepository GitgTestRepository;
typedef struct _GitgTestRepositoryClass GitgTestRepositoryClass;
typedef struct _GitgTestRepositoryPrivate GitgTestRepositoryPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GITG_TEST_REPOSITORY_TYPE_FILE (gitg_test_repository_file_get_type ())
typedef struct _GitgTestRepositoryFile GitgTestRepositoryFile;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define __vala_GgitOId_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitOId_free (var), NULL)))
#define _ggit_index_entry_unref0(var) ((var == NULL) ? NULL : (var = (ggit_index_entry_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GitgTestTest {
	GObject parent_instance;
	GitgTestTestPrivate * priv;
};

struct _GitgTestTestClass {
	GObjectClass parent_class;
	void (*set_up) (GitgTestTest* self);
	void (*tear_down) (GitgTestTest* self);
};

struct _GitgTestRepository {
	GitgTestTest parent_instance;
	GitgTestRepositoryPrivate * priv;
	GitgRepository* d_repository;
};

struct _GitgTestRepositoryClass {
	GitgTestTestClass parent_class;
};

struct _GitgTestRepositoryPrivate {
	guint d_current_time;
};

struct _GitgTestRepositoryFile {
	gchar* filename;
	gchar* contents;
};


static gpointer gitg_test_repository_parent_class = NULL;

GType gitg_test_test_get_type (void) G_GNUC_CONST;
GType gitg_test_repository_get_type (void) G_GNUC_CONST;
#define GITG_TEST_REPOSITORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GITG_TEST_TYPE_REPOSITORY, GitgTestRepositoryPrivate))
enum  {
	GITG_TEST_REPOSITORY_DUMMY_PROPERTY
};
static GType gitg_test_repository_file_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GitgTestRepositoryFile* gitg_test_repository_file_dup (const GitgTestRepositoryFile* self);
static void gitg_test_repository_file_free (GitgTestRepositoryFile* self);
static void gitg_test_repository_file_copy (const GitgTestRepositoryFile* self, GitgTestRepositoryFile* dest);
static void gitg_test_repository_file_destroy (GitgTestRepositoryFile* self);
static GitgTestRepositoryFile* gitg_test_repository_files_from_varargs (GitgTestRepository* self, const gchar* filename, va_list l, int* result_length1);
static void _vala_array_add10 (GitgTestRepositoryFile* * array, int* length, int* size, const GitgTestRepositoryFile* value);
static void _vala_GitgTestRepositoryFile_array_free (GitgTestRepositoryFile * array, gint array_length);
static GitgTestRepositoryFile* gitg_test_repository_filenames_from_varargs (GitgTestRepository* self, const gchar* filename, va_list l, int* result_length1);
static void _vala_array_add11 (GitgTestRepositoryFile* * array, int* length, int* size, const GitgTestRepositoryFile* value);
void gitg_test_repository_assert_file_contents (GitgTestRepository* self, const gchar* filename, const gchar* expected_contents);
void gitg_test_assert_assert_file_contents (const gchar* filename, const gchar* expected_contents);
gboolean gitg_test_repository_file_exists (GitgTestRepository* self, const gchar* filename);
static void gitg_test_repository_write_files (GitgTestRepository* self, GitgTestRepositoryFile* files, int files_length1);
void gitg_test_repository_write_file (GitgTestRepository* self, const gchar* filename, const gchar* contents);
GgitSignature* gitg_test_repository_get_verified_committer (GitgTestRepository* self);
void gitg_test_repository_commit (GitgTestRepository* self, const gchar* filename, ...);
static void _vala_GgitOId_free (GgitOId* self);
void gitg_test_repository_workdir_remove (GitgTestRepository* self, const gchar* filename, ...);
void gitg_test_repository_workdir_modify (GitgTestRepository* self, const gchar* filename, ...);
void gitg_test_repository_index_modify (GitgTestRepository* self, const gchar* filename, ...);
GitgBranch* gitg_test_repository_create_branch (GitgTestRepository* self, const gchar* name);
void gitg_test_repository_checkout_branch (GitgTestRepository* self, const gchar* name);
static void gitg_test_repository_real_set_up (GitgTestTest* base);
static void gitg_test_repository_remove_recursively (GitgTestRepository* self, GFile* f);
GitgBranch* gitg_test_repository_lookup_branch (GitgTestRepository* self, const gchar* name);
GitgCommit* gitg_test_repository_lookup_commit (GitgTestRepository* self, const gchar* name);
static void gitg_test_repository_real_tear_down (GitgTestTest* base);
GitgTestRepository* gitg_test_repository_new (void);
GitgTestRepository* gitg_test_repository_construct (GType object_type);
GitgTestTest* gitg_test_test_new (void);
GitgTestTest* gitg_test_test_construct (GType object_type);
static void gitg_test_repository_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _vala_array_add10 (GitgTestRepositoryFile* * array, int* length, int* size, const GitgTestRepositoryFile* value) {
#line 41 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	if ((*length) == (*size)) {
#line 41 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 41 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		*array = g_renew (GitgTestRepositoryFile, *array, *size);
#line 155 "support-repository.c"
	}
#line 41 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	(*array)[(*length)++] = *value;
#line 159 "support-repository.c"
}


static void _vala_GitgTestRepositoryFile_array_free (GitgTestRepositoryFile * array, gint array_length) {
#line 33 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	if (array != NULL) {
#line 166 "support-repository.c"
		int i;
#line 33 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 33 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			gitg_test_repository_file_destroy (&array[i]);
#line 172 "support-repository.c"
		}
	}
#line 33 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	g_free (array);
#line 177 "support-repository.c"
}


static GitgTestRepositoryFile* gitg_test_repository_files_from_varargs (GitgTestRepository* self, const gchar* filename, va_list l, int* result_length1) {
	GitgTestRepositoryFile* result = NULL;
	GitgTestRepositoryFile* files = NULL;
	GitgTestRepositoryFile* _tmp0_ = NULL;
	gint files_length1 = 0;
	gint _files_size_ = 0;
	GitgTestRepositoryFile* _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
#line 33 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 35 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp0_ = g_new0 (GitgTestRepositoryFile, 0);
#line 35 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	files = _tmp0_;
#line 35 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	files_length1 = 0;
#line 35 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_files_size_ = files_length1;
#line 37 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	while (TRUE) {
#line 201 "support-repository.c"
		const gchar* _tmp1_ = NULL;
		gchar* contents = NULL;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_ = NULL;
		GitgTestRepositoryFile* _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		GitgTestRepositoryFile _tmp9_ = {0};
		const gchar* _tmp10_ = NULL;
#line 37 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp1_ = filename;
#line 37 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		if (!(_tmp1_ != NULL)) {
#line 37 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			break;
#line 220 "support-repository.c"
		}
#line 39 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp2_ = va_arg (l, gchar*);
#line 39 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp3_ = g_strdup (_tmp2_);
#line 39 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		contents = _tmp3_;
#line 41 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp4_ = files;
#line 41 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp4__length1 = files_length1;
#line 41 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp5_ = filename;
#line 41 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp6_ = g_strdup (_tmp5_);
#line 41 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp7_ = contents;
#line 41 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp8_ = g_strdup (_tmp7_);
#line 41 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		memset (&_tmp9_, 0, sizeof (GitgTestRepositoryFile));
#line 41 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_free0 (_tmp9_.filename);
#line 41 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp9_.filename = _tmp6_;
#line 41 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_free0 (_tmp9_.contents);
#line 41 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp9_.contents = _tmp8_;
#line 41 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_vala_array_add10 (&files, &files_length1, &_files_size_, &_tmp9_);
#line 46 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp10_ = va_arg (l, gchar*);
#line 46 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		filename = _tmp10_;
#line 37 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_free0 (contents);
#line 258 "support-repository.c"
	}
#line 49 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp11_ = files;
#line 49 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp11__length1 = files_length1;
#line 49 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	if (result_length1) {
#line 49 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		*result_length1 = _tmp11__length1;
#line 268 "support-repository.c"
	}
#line 49 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	result = _tmp11_;
#line 49 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	return result;
#line 274 "support-repository.c"
}


static void _vala_array_add11 (GitgTestRepositoryFile* * array, int* length, int* size, const GitgTestRepositoryFile* value) {
#line 58 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	if ((*length) == (*size)) {
#line 58 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 58 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		*array = g_renew (GitgTestRepositoryFile, *array, *size);
#line 285 "support-repository.c"
	}
#line 58 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	(*array)[(*length)++] = *value;
#line 289 "support-repository.c"
}


static GitgTestRepositoryFile* gitg_test_repository_filenames_from_varargs (GitgTestRepository* self, const gchar* filename, va_list l, int* result_length1) {
	GitgTestRepositoryFile* result = NULL;
	GitgTestRepositoryFile* files = NULL;
	GitgTestRepositoryFile* _tmp0_ = NULL;
	gint files_length1 = 0;
	gint _files_size_ = 0;
	GitgTestRepositoryFile* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
#line 52 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 54 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp0_ = g_new0 (GitgTestRepositoryFile, 0);
#line 54 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	files = _tmp0_;
#line 54 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	files_length1 = 0;
#line 54 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_files_size_ = files_length1;
#line 56 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	while (TRUE) {
#line 313 "support-repository.c"
		const gchar* _tmp1_ = NULL;
		GitgTestRepositoryFile* _tmp2_ = NULL;
		gint _tmp2__length1 = 0;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		GitgTestRepositoryFile _tmp5_ = {0};
		const gchar* _tmp6_ = NULL;
#line 56 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp1_ = filename;
#line 56 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		if (!(_tmp1_ != NULL)) {
#line 56 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			break;
#line 327 "support-repository.c"
		}
#line 58 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp2_ = files;
#line 58 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp2__length1 = files_length1;
#line 58 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp3_ = filename;
#line 58 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp4_ = g_strdup (_tmp3_);
#line 58 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		memset (&_tmp5_, 0, sizeof (GitgTestRepositoryFile));
#line 58 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_free0 (_tmp5_.filename);
#line 58 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp5_.filename = _tmp4_;
#line 58 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_free0 (_tmp5_.contents);
#line 58 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp5_.contents = NULL;
#line 58 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_vala_array_add11 (&files, &files_length1, &_files_size_, &_tmp5_);
#line 63 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp6_ = va_arg (l, gchar*);
#line 63 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		filename = _tmp6_;
#line 353 "support-repository.c"
	}
#line 66 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp7_ = files;
#line 66 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp7__length1 = files_length1;
#line 66 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	if (result_length1) {
#line 66 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		*result_length1 = _tmp7__length1;
#line 363 "support-repository.c"
	}
#line 66 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	result = _tmp7_;
#line 66 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	return result;
#line 369 "support-repository.c"
}


void gitg_test_repository_assert_file_contents (GitgTestRepository* self, const gchar* filename, const gchar* expected_contents) {
	GFile* wd = NULL;
	GitgRepository* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
#line 69 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	g_return_if_fail (self != NULL);
#line 69 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	g_return_if_fail (filename != NULL);
#line 69 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	g_return_if_fail (expected_contents != NULL);
#line 71 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp0_ = self->d_repository;
#line 71 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp1_ = ggit_repository_get_workdir ((GgitRepository*) _tmp0_);
#line 71 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	wd = _tmp1_;
#line 73 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp2_ = g_file_get_path (wd);
#line 73 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp3_ = _tmp2_;
#line 73 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp4_ = filename;
#line 73 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp5_ = g_build_filename (_tmp3_, _tmp4_, NULL);
#line 73 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp6_ = _tmp5_;
#line 73 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp7_ = expected_contents;
#line 73 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	gitg_test_assert_assert_file_contents (_tmp6_, _tmp7_);
#line 73 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_g_free0 (_tmp6_);
#line 73 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_g_free0 (_tmp3_);
#line 69 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_g_object_unref0 (wd);
#line 415 "support-repository.c"
}


gboolean gitg_test_repository_file_exists (GitgTestRepository* self, const gchar* filename) {
	gboolean result = FALSE;
	GitgRepository* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
#line 76 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 76 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	g_return_val_if_fail (filename != NULL, FALSE);
#line 78 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp0_ = self->d_repository;
#line 78 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp1_ = ggit_repository_get_workdir ((GgitRepository*) _tmp0_);
#line 78 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp2_ = _tmp1_;
#line 78 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp3_ = filename;
#line 78 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp4_ = g_file_get_child (_tmp2_, _tmp3_);
#line 78 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp5_ = _tmp4_;
#line 78 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp6_ = g_file_query_exists (_tmp5_, NULL);
#line 78 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp7_ = _tmp6_;
#line 78 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_g_object_unref0 (_tmp5_);
#line 78 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_g_object_unref0 (_tmp2_);
#line 78 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	result = _tmp7_;
#line 78 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	return result;
#line 457 "support-repository.c"
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res = NULL;
	gint res_length1 = 0;
	gint _res_size_ = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guint8* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
#line 1420 "/home/jesse/.local/share/vala-0.36/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1421 "/home/jesse/.local/share/vala-0.36/vapi/glib-2.0.vapi"
	res = (guint8*) self;
#line 1421 "/home/jesse/.local/share/vala-0.36/vapi/glib-2.0.vapi"
	res_length1 = -1;
#line 1421 "/home/jesse/.local/share/vala-0.36/vapi/glib-2.0.vapi"
	_res_size_ = res_length1;
#line 1422 "/home/jesse/.local/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1422 "/home/jesse/.local/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1422 "/home/jesse/.local/share/vala-0.36/vapi/glib-2.0.vapi"
	res_length1 = (gint) _tmp1_;
#line 1422 "/home/jesse/.local/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp2_ = res_length1;
#line 1423 "/home/jesse/.local/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp3_ = res;
#line 1423 "/home/jesse/.local/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp3__length1 = res_length1;
#line 1423 "/home/jesse/.local/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp4_ = _tmp3_;
#line 1423 "/home/jesse/.local/share/vala-0.36/vapi/glib-2.0.vapi"
	_tmp4__length1 = _tmp3__length1;
#line 1423 "/home/jesse/.local/share/vala-0.36/vapi/glib-2.0.vapi"
	if (result_length1) {
#line 1423 "/home/jesse/.local/share/vala-0.36/vapi/glib-2.0.vapi"
		*result_length1 = _tmp4__length1;
#line 501 "support-repository.c"
	}
#line 1423 "/home/jesse/.local/share/vala-0.36/vapi/glib-2.0.vapi"
	result = _tmp4_;
#line 1423 "/home/jesse/.local/share/vala-0.36/vapi/glib-2.0.vapi"
	return result;
#line 507 "support-repository.c"
}


static void gitg_test_repository_write_files (GitgTestRepository* self, GitgTestRepositoryFile* files, int files_length1) {
	GFile* wd = NULL;
	GitgRepository* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GitgTestRepositoryFile* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	GError * _inner_error_ = NULL;
#line 81 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	g_return_if_fail (self != NULL);
#line 83 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp0_ = self->d_repository;
#line 83 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp1_ = ggit_repository_get_workdir ((GgitRepository*) _tmp0_);
#line 83 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	wd = _tmp1_;
#line 85 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp2_ = files;
#line 85 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp2__length1 = files_length1;
#line 530 "support-repository.c"
	{
		GitgTestRepositoryFile* f_collection = NULL;
		gint f_collection_length1 = 0;
		gint _f_collection_size_ = 0;
		gint f_it = 0;
#line 85 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		f_collection = _tmp2_;
#line 85 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		f_collection_length1 = _tmp2__length1;
#line 85 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		for (f_it = 0; f_it < _tmp2__length1; f_it = f_it + 1) {
#line 542 "support-repository.c"
			GitgTestRepositoryFile _tmp3_ = {0};
			GitgTestRepositoryFile f = {0};
#line 85 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			gitg_test_repository_file_copy (&f_collection[f_it], &_tmp3_);
#line 85 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			f = _tmp3_;
#line 549 "support-repository.c"
			{
				GFile* fp = NULL;
				GFile* _tmp4_ = NULL;
				GitgTestRepositoryFile _tmp5_ = {0};
				const gchar* _tmp6_ = NULL;
				GFile* _tmp7_ = NULL;
#line 87 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
				_tmp4_ = wd;
#line 87 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
				_tmp5_ = f;
#line 87 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
				_tmp6_ = _tmp5_.filename;
#line 87 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
				_tmp7_ = g_file_get_child (_tmp4_, _tmp6_);
#line 87 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
				fp = _tmp7_;
#line 566 "support-repository.c"
				{
					GFileOutputStream* os = NULL;
					GFile* _tmp8_ = NULL;
					GFileOutputStream* _tmp9_ = NULL;
					GFileOutputStream* _tmp10_ = NULL;
					GitgTestRepositoryFile _tmp11_ = {0};
					const gchar* _tmp12_ = NULL;
					guint8* _tmp13_ = NULL;
					gint _tmp13__length1 = 0;
					guint8* _tmp14_ = NULL;
					gint _tmp14__length1 = 0;
					GFileOutputStream* _tmp15_ = NULL;
#line 91 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_tmp8_ = fp;
#line 91 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_tmp9_ = g_file_replace (_tmp8_, NULL, FALSE, G_FILE_CREATE_NONE, NULL, &_inner_error_);
#line 91 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					os = _tmp9_;
#line 91 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 587 "support-repository.c"
						goto __catch1_g_error;
					}
#line 92 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_tmp10_ = os;
#line 92 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_tmp11_ = f;
#line 92 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_tmp12_ = _tmp11_.contents;
#line 92 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_tmp13_ = string_get_data (_tmp12_, &_tmp13__length1);
#line 92 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_tmp14_ = _tmp13_;
#line 92 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_tmp14__length1 = _tmp13__length1;
#line 92 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					g_output_stream_write ((GOutputStream*) _tmp10_, _tmp14_, (gsize) _tmp14__length1, NULL, &_inner_error_);
#line 92 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 92 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
						_g_object_unref0 (os);
#line 608 "support-repository.c"
						goto __catch1_g_error;
					}
#line 93 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_tmp15_ = os;
#line 93 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					g_output_stream_close ((GOutputStream*) _tmp15_, NULL, &_inner_error_);
#line 93 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 93 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
						_g_object_unref0 (os);
#line 619 "support-repository.c"
						goto __catch1_g_error;
					}
#line 89 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_g_object_unref0 (os);
#line 624 "support-repository.c"
				}
				goto __finally1;
				__catch1_g_error:
				{
					GError* e = NULL;
					GError* _tmp16_ = NULL;
#line 89 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					e = _inner_error_;
#line 89 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_inner_error_ = NULL;
#line 97 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_tmp16_ = e;
#line 97 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					gitg_test_assert_assert_no_error (_tmp16_);
#line 89 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_g_error_free0 (e);
#line 641 "support-repository.c"
				}
				__finally1:
#line 89 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 89 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_g_object_unref0 (fp);
#line 89 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					gitg_test_repository_file_destroy (&f);
#line 89 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_g_object_unref0 (wd);
#line 89 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 89 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					g_clear_error (&_inner_error_);
#line 89 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					return;
#line 658 "support-repository.c"
				}
#line 85 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
				_g_object_unref0 (fp);
#line 85 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
				gitg_test_repository_file_destroy (&f);
#line 664 "support-repository.c"
			}
		}
	}
#line 81 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_g_object_unref0 (wd);
#line 670 "support-repository.c"
}


void gitg_test_repository_write_file (GitgTestRepository* self, const gchar* filename, const gchar* contents) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GitgTestRepositoryFile _tmp4_ = {0};
	GitgTestRepositoryFile* _tmp5_ = NULL;
	GitgTestRepositoryFile* _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
#line 102 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	g_return_if_fail (self != NULL);
#line 102 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	g_return_if_fail (filename != NULL);
#line 102 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	g_return_if_fail (contents != NULL);
#line 104 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp0_ = filename;
#line 104 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 104 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp2_ = contents;
#line 104 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 104 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	memset (&_tmp4_, 0, sizeof (GitgTestRepositoryFile));
#line 104 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_g_free0 (_tmp4_.filename);
#line 104 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp4_.filename = _tmp1_;
#line 104 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_g_free0 (_tmp4_.contents);
#line 104 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp4_.contents = _tmp3_;
#line 104 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp5_ = g_new0 (GitgTestRepositoryFile, 1);
#line 104 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp5_[0] = _tmp4_;
#line 104 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp6_ = _tmp5_;
#line 104 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp6__length1 = 1;
#line 104 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	gitg_test_repository_write_files (self, _tmp6_, 1);
#line 104 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp6_ = (_vala_GitgTestRepositoryFile_array_free (_tmp6_, _tmp6__length1), NULL);
#line 719 "support-repository.c"
}


GgitSignature* gitg_test_repository_get_verified_committer (GitgTestRepository* self) {
	GgitSignature* result = NULL;
	GError * _inner_error_ = NULL;
#line 112 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 728 "support-repository.c"
	{
		GgitSignature* _tmp0_ = NULL;
		guint _tmp1_ = 0U;
		GDateTime* _tmp2_ = NULL;
		GDateTime* _tmp3_ = NULL;
		GgitSignature* _tmp4_ = NULL;
		GgitSignature* _tmp5_ = NULL;
		GgitSignature* _tmp6_ = NULL;
#line 116 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp1_ = self->priv->d_current_time;
#line 116 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		self->priv->d_current_time = _tmp1_ + 1;
#line 116 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp2_ = g_date_time_new_from_unix_utc ((gint64) _tmp1_);
#line 116 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp3_ = _tmp2_;
#line 116 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp4_ = ggit_signature_new ("gitg tester", "gitg-tester@gnome.org", _tmp3_, &_inner_error_);
#line 116 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp5_ = _tmp4_;
#line 116 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_date_time_unref0 (_tmp3_);
#line 116 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp0_ = _tmp5_;
#line 116 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 755 "support-repository.c"
			goto __catch2_g_error;
		}
#line 116 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp6_ = _tmp0_;
#line 116 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp0_ = NULL;
#line 116 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		result = _tmp6_;
#line 116 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (_tmp0_);
#line 116 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		return result;
#line 768 "support-repository.c"
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_ = NULL;
#line 114 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		e = _inner_error_;
#line 114 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_inner_error_ = NULL;
#line 120 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp7_ = e;
#line 120 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		gitg_test_assert_assert_no_error (_tmp7_);
#line 121 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		result = NULL;
#line 121 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_error_free0 (e);
#line 121 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		return result;
#line 789 "support-repository.c"
	}
	__finally2:
#line 114 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 114 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	g_clear_error (&_inner_error_);
#line 114 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	return NULL;
#line 798 "support-repository.c"
}


static void _vala_GgitOId_free (GgitOId* self) {
#line 166 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	g_boxed_free (ggit_oid_get_type (), self);
#line 805 "support-repository.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 206 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	return self ? g_object_ref (self) : NULL;
#line 812 "support-repository.c"
}


void gitg_test_repository_commit (GitgTestRepository* self, const gchar* filename, ...) {
	GitgRepository* _tmp0_ = NULL;
	GitgTestRepositoryFile* files = NULL;
	const gchar* _tmp1_ = NULL;
	va_list _tmp2_ = {0};
	gint _tmp3_ = 0;
	GitgTestRepositoryFile* _tmp4_ = NULL;
	GitgTestRepositoryFile* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gint files_length1 = 0;
	gint _files_size_ = 0;
	GitgTestRepositoryFile* _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
	GgitIndex* index = NULL;
	GitgTestRepositoryFile* _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	GgitOId* treeoid = NULL;
	GgitSignature* sig = NULL;
	GgitSignature* _tmp24_ = NULL;
	GgitTree* tree = NULL;
	GgitOId* commitoid = NULL;
	GgitRef* head = NULL;
	GgitCommit* parent = NULL;
	GError * _inner_error_ = NULL;
#line 125 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	g_return_if_fail (self != NULL);
#line 127 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp0_ = self->d_repository;
#line 127 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	if (_tmp0_ == NULL) {
#line 129 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		return;
#line 848 "support-repository.c"
	}
#line 132 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp1_ = filename;
#line 132 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	va_start (_tmp2_, filename);
#line 132 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp4_ = gitg_test_repository_files_from_varargs (self, _tmp1_, _tmp2_, &_tmp3_);
#line 132 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp5_ = _tmp4_;
#line 132 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp5__length1 = _tmp3_;
#line 132 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	va_end (_tmp2_);
#line 132 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	files = _tmp5_;
#line 132 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	files_length1 = _tmp5__length1;
#line 132 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_files_size_ = files_length1;
#line 133 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp6_ = files;
#line 133 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp6__length1 = files_length1;
#line 133 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	gitg_test_repository_write_files (self, _tmp6_, _tmp6__length1);
#line 874 "support-repository.c"
	{
		GgitIndex* _tmp7_ = NULL;
		GitgRepository* _tmp8_ = NULL;
		GgitIndex* _tmp9_ = NULL;
		GgitIndex* _tmp10_ = NULL;
#line 141 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp8_ = self->d_repository;
#line 141 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp9_ = ggit_repository_get_index ((GgitRepository*) _tmp8_, &_inner_error_);
#line 141 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp7_ = _tmp9_;
#line 141 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 888 "support-repository.c"
			goto __catch3_g_error;
		}
#line 141 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp10_ = _tmp7_;
#line 141 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp7_ = NULL;
#line 141 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (index);
#line 141 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		index = _tmp10_;
#line 139 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (_tmp7_);
#line 901 "support-repository.c"
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_ = NULL;
#line 139 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		e = _inner_error_;
#line 139 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_inner_error_ = NULL;
#line 145 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp11_ = e;
#line 145 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		gitg_test_assert_assert_no_error (_tmp11_);
#line 146 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_error_free0 (e);
#line 146 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (index);
#line 146 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		files = (_vala_GitgTestRepositoryFile_array_free (files, files_length1), NULL);
#line 146 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		return;
#line 924 "support-repository.c"
	}
	__finally3:
#line 139 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 139 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (index);
#line 139 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		files = (_vala_GitgTestRepositoryFile_array_free (files, files_length1), NULL);
#line 139 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 139 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		g_clear_error (&_inner_error_);
#line 139 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		return;
#line 939 "support-repository.c"
	}
#line 149 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp12_ = files;
#line 149 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp12__length1 = files_length1;
#line 945 "support-repository.c"
	{
		GitgTestRepositoryFile* f_collection = NULL;
		gint f_collection_length1 = 0;
		gint _f_collection_size_ = 0;
		gint f_it = 0;
#line 149 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		f_collection = _tmp12_;
#line 149 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		f_collection_length1 = _tmp12__length1;
#line 149 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		for (f_it = 0; f_it < _tmp12__length1; f_it = f_it + 1) {
#line 957 "support-repository.c"
			GitgTestRepositoryFile _tmp13_ = {0};
			GitgTestRepositoryFile f = {0};
#line 149 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			gitg_test_repository_file_copy (&f_collection[f_it], &_tmp13_);
#line 149 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			f = _tmp13_;
#line 964 "support-repository.c"
			{
				{
					GgitIndex* _tmp14_ = NULL;
					GitgTestRepositoryFile _tmp15_ = {0};
					const gchar* _tmp16_ = NULL;
#line 153 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_tmp14_ = index;
#line 153 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_tmp15_ = f;
#line 153 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_tmp16_ = _tmp15_.filename;
#line 153 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					ggit_index_add_path (_tmp14_, _tmp16_, &_inner_error_);
#line 153 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 980 "support-repository.c"
						goto __catch4_g_error;
					}
				}
				goto __finally4;
				__catch4_g_error:
				{
					GError* e = NULL;
					GError* _tmp17_ = NULL;
#line 151 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					e = _inner_error_;
#line 151 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_inner_error_ = NULL;
#line 157 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_tmp17_ = e;
#line 157 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					gitg_test_assert_assert_no_error (_tmp17_);
#line 151 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_g_error_free0 (e);
#line 999 "support-repository.c"
				}
				__finally4:
#line 151 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 151 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					gitg_test_repository_file_destroy (&f);
#line 151 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_g_object_unref0 (index);
#line 151 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					files = (_vala_GitgTestRepositoryFile_array_free (files, files_length1), NULL);
#line 151 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 151 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					g_clear_error (&_inner_error_);
#line 151 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					return;
#line 1016 "support-repository.c"
				}
#line 149 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
				gitg_test_repository_file_destroy (&f);
#line 1020 "support-repository.c"
			}
		}
	}
	{
		GgitIndex* _tmp18_ = NULL;
		GgitOId* _tmp19_ = NULL;
		GgitIndex* _tmp20_ = NULL;
		GgitOId* _tmp21_ = NULL;
		GgitOId* _tmp22_ = NULL;
#line 165 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp18_ = index;
#line 165 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		ggit_index_write (_tmp18_, &_inner_error_);
#line 165 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1036 "support-repository.c"
			goto __catch5_g_error;
		}
#line 166 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp20_ = index;
#line 166 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp21_ = ggit_index_write_tree (_tmp20_, &_inner_error_);
#line 166 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp19_ = _tmp21_;
#line 166 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1047 "support-repository.c"
			goto __catch5_g_error;
		}
#line 166 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp22_ = _tmp19_;
#line 166 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp19_ = NULL;
#line 166 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		__vala_GgitOId_free0 (treeoid);
#line 166 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		treeoid = _tmp22_;
#line 163 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		__vala_GgitOId_free0 (_tmp19_);
#line 1060 "support-repository.c"
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		GError* _tmp23_ = NULL;
#line 163 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		e = _inner_error_;
#line 163 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_inner_error_ = NULL;
#line 170 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp23_ = e;
#line 170 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		gitg_test_assert_assert_no_error (_tmp23_);
#line 171 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_error_free0 (e);
#line 171 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		__vala_GgitOId_free0 (treeoid);
#line 171 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (index);
#line 171 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		files = (_vala_GitgTestRepositoryFile_array_free (files, files_length1), NULL);
#line 171 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		return;
#line 1085 "support-repository.c"
	}
	__finally5:
#line 163 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 163 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		__vala_GgitOId_free0 (treeoid);
#line 163 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (index);
#line 163 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		files = (_vala_GitgTestRepositoryFile_array_free (files, files_length1), NULL);
#line 163 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 163 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		g_clear_error (&_inner_error_);
#line 163 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		return;
#line 1102 "support-repository.c"
	}
#line 175 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp24_ = gitg_test_repository_get_verified_committer (self);
#line 175 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	sig = _tmp24_;
#line 1108 "support-repository.c"
	{
		GgitTree* _tmp25_ = NULL;
		GitgRepository* _tmp26_ = NULL;
		GgitOId* _tmp27_ = NULL;
		gpointer _tmp28_ = NULL;
		GgitTree* _tmp29_ = NULL;
#line 181 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp26_ = self->d_repository;
#line 181 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp27_ = treeoid;
#line 181 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp28_ = gitg_repository_lookup (_tmp26_, ggit_tree_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, _tmp27_, &_inner_error_);
#line 181 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp25_ = (GgitTree*) _tmp28_;
#line 181 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1125 "support-repository.c"
			goto __catch6_g_error;
		}
#line 181 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp29_ = _tmp25_;
#line 181 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp25_ = NULL;
#line 181 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (tree);
#line 181 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		tree = _tmp29_;
#line 179 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (_tmp25_);
#line 1138 "support-repository.c"
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		GError* _tmp30_ = NULL;
#line 179 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		e = _inner_error_;
#line 179 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_inner_error_ = NULL;
#line 185 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp30_ = e;
#line 185 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		gitg_test_assert_assert_no_error (_tmp30_);
#line 186 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_error_free0 (e);
#line 186 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (tree);
#line 186 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (sig);
#line 186 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		__vala_GgitOId_free0 (treeoid);
#line 186 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (index);
#line 186 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		files = (_vala_GitgTestRepositoryFile_array_free (files, files_length1), NULL);
#line 186 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		return;
#line 1167 "support-repository.c"
	}
	__finally6:
#line 179 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 179 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (tree);
#line 179 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (sig);
#line 179 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		__vala_GgitOId_free0 (treeoid);
#line 179 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (index);
#line 179 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		files = (_vala_GitgTestRepositoryFile_array_free (files, files_length1), NULL);
#line 179 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 179 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		g_clear_error (&_inner_error_);
#line 179 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		return;
#line 1188 "support-repository.c"
	}
#line 191 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	head = NULL;
#line 192 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	parent = NULL;
#line 1194 "support-repository.c"
	{
		GitgRef* _tmp31_ = NULL;
		GitgRepository* _tmp32_ = NULL;
		GitgRef* _tmp33_ = NULL;
		GitgRef* _tmp34_ = NULL;
		GgitObject* _tmp35_ = NULL;
		GgitRef* _tmp36_ = NULL;
		GgitObject* _tmp37_ = NULL;
		GgitObject* _tmp38_ = NULL;
		GgitCommit* _tmp39_ = NULL;
#line 196 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp32_ = self->d_repository;
#line 196 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp33_ = gitg_repository_get_head (_tmp32_, &_inner_error_);
#line 196 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp31_ = _tmp33_;
#line 196 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1213 "support-repository.c"
			goto __catch7_g_error;
		}
#line 196 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp34_ = _tmp31_;
#line 196 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp31_ = NULL;
#line 196 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (head);
#line 196 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		head = (GgitRef*) _tmp34_;
#line 197 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp36_ = head;
#line 197 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp37_ = ggit_ref_lookup (_tmp36_, &_inner_error_);
#line 197 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp35_ = _tmp37_;
#line 197 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 197 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			_g_object_unref0 (_tmp31_);
#line 1234 "support-repository.c"
			goto __catch7_g_error;
		}
#line 197 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp38_ = _tmp35_;
#line 197 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp35_ = NULL;
#line 197 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp39_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp38_, ggit_commit_get_type ()) ? ((GgitCommit*) _tmp38_) : NULL;
#line 197 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		if (_tmp39_ == NULL) {
#line 197 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			_g_object_unref0 (_tmp38_);
#line 1247 "support-repository.c"
		}
#line 197 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (parent);
#line 197 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		parent = _tmp39_;
#line 194 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (_tmp35_);
#line 194 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (_tmp31_);
#line 1257 "support-repository.c"
	}
	goto __finally7;
	__catch7_g_error:
	{
#line 194 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		g_clear_error (&_inner_error_);
#line 194 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_inner_error_ = NULL;
#line 1266 "support-repository.c"
	}
	__finally7:
#line 194 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 194 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (parent);
#line 194 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (head);
#line 194 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		__vala_GgitOId_free0 (commitoid);
#line 194 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (tree);
#line 194 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (sig);
#line 194 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		__vala_GgitOId_free0 (treeoid);
#line 194 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (index);
#line 194 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		files = (_vala_GitgTestRepositoryFile_array_free (files, files_length1), NULL);
#line 194 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 194 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		g_clear_error (&_inner_error_);
#line 194 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		return;
#line 1293 "support-repository.c"
	}
	{
		GgitCommit** parents = NULL;
		gint parents_length1 = 0;
		gint _parents_size_ = 0;
		GgitCommit* _tmp40_ = NULL;
		GgitOId* _tmp45_ = NULL;
		GitgRepository* _tmp46_ = NULL;
		GgitSignature* _tmp47_ = NULL;
		GgitSignature* _tmp48_ = NULL;
		const gchar* _tmp49_ = NULL;
		gchar* _tmp50_ = NULL;
		gchar* _tmp51_ = NULL;
		GgitTree* _tmp52_ = NULL;
		GgitCommit** _tmp53_ = NULL;
		gint _tmp53__length1 = 0;
		GgitOId* _tmp54_ = NULL;
		GgitOId* _tmp55_ = NULL;
		GgitOId* _tmp56_ = NULL;
#line 204 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp40_ = parent;
#line 204 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		if (_tmp40_ != NULL) {
#line 1317 "support-repository.c"
			GgitCommit* _tmp41_ = NULL;
			GgitCommit* _tmp42_ = NULL;
			GgitCommit** _tmp43_ = NULL;
#line 206 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			_tmp41_ = parent;
#line 206 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			_tmp42_ = _g_object_ref0 (_tmp41_);
#line 206 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			_tmp43_ = g_new0 (GgitCommit*, 1 + 1);
#line 206 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			_tmp43_[0] = _tmp42_;
#line 206 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			parents = (_vala_array_free (parents, parents_length1, (GDestroyNotify) g_object_unref), NULL);
#line 206 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			parents = _tmp43_;
#line 206 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			parents_length1 = 1;
#line 206 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			_parents_size_ = parents_length1;
#line 1337 "support-repository.c"
		} else {
			GgitCommit** _tmp44_ = NULL;
#line 210 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			_tmp44_ = g_new0 (GgitCommit*, 0 + 1);
#line 210 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			parents = (_vala_array_free (parents, parents_length1, (GDestroyNotify) g_object_unref), NULL);
#line 210 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			parents = _tmp44_;
#line 210 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			parents_length1 = 0;
#line 210 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			_parents_size_ = parents_length1;
#line 1350 "support-repository.c"
		}
#line 213 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp46_ = self->d_repository;
#line 213 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp47_ = sig;
#line 213 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp48_ = sig;
#line 213 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp49_ = filename;
#line 213 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp50_ = g_strconcat ("commit ", _tmp49_, NULL);
#line 213 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp51_ = _tmp50_;
#line 213 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp52_ = tree;
#line 213 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp53_ = parents;
#line 213 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp53__length1 = parents_length1;
#line 213 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp54_ = ggit_repository_create_commit ((GgitRepository*) _tmp46_, "HEAD", _tmp47_, _tmp48_, NULL, _tmp51_, _tmp52_, _tmp53_, _tmp53__length1, &_inner_error_);
#line 213 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp55_ = _tmp54_;
#line 213 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_free0 (_tmp51_);
#line 213 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp45_ = _tmp55_;
#line 213 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 213 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			parents = (_vala_array_free (parents, parents_length1, (GDestroyNotify) g_object_unref), NULL);
#line 1382 "support-repository.c"
			goto __catch8_g_error;
		}
#line 213 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp56_ = _tmp45_;
#line 213 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp45_ = NULL;
#line 213 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		__vala_GgitOId_free0 (commitoid);
#line 213 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		commitoid = _tmp56_;
#line 200 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		__vala_GgitOId_free0 (_tmp45_);
#line 200 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		parents = (_vala_array_free (parents, parents_length1, (GDestroyNotify) g_object_unref), NULL);
#line 1397 "support-repository.c"
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
		GError* _tmp57_ = NULL;
#line 200 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		e = _inner_error_;
#line 200 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_inner_error_ = NULL;
#line 223 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp57_ = e;
#line 223 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		gitg_test_assert_assert_no_error (_tmp57_);
#line 224 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_error_free0 (e);
#line 224 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (parent);
#line 224 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (head);
#line 224 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		__vala_GgitOId_free0 (commitoid);
#line 224 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (tree);
#line 224 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (sig);
#line 224 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		__vala_GgitOId_free0 (treeoid);
#line 224 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (index);
#line 224 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		files = (_vala_GitgTestRepositoryFile_array_free (files, files_length1), NULL);
#line 224 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		return;
#line 1432 "support-repository.c"
	}
	__finally8:
#line 200 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 200 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (parent);
#line 200 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (head);
#line 200 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		__vala_GgitOId_free0 (commitoid);
#line 200 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (tree);
#line 200 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (sig);
#line 200 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		__vala_GgitOId_free0 (treeoid);
#line 200 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (index);
#line 200 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		files = (_vala_GitgTestRepositoryFile_array_free (files, files_length1), NULL);
#line 200 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 200 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		g_clear_error (&_inner_error_);
#line 200 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		return;
#line 1459 "support-repository.c"
	}
#line 125 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_g_object_unref0 (parent);
#line 125 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_g_object_unref0 (head);
#line 125 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	__vala_GgitOId_free0 (commitoid);
#line 125 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_g_object_unref0 (tree);
#line 125 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_g_object_unref0 (sig);
#line 125 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	__vala_GgitOId_free0 (treeoid);
#line 125 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_g_object_unref0 (index);
#line 125 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	files = (_vala_GitgTestRepositoryFile_array_free (files, files_length1), NULL);
#line 1477 "support-repository.c"
}


void gitg_test_repository_workdir_remove (GitgTestRepository* self, const gchar* filename, ...) {
	GitgRepository* _tmp0_ = NULL;
	GitgTestRepositoryFile* files = NULL;
	const gchar* _tmp1_ = NULL;
	va_list _tmp2_ = {0};
	gint _tmp3_ = 0;
	GitgTestRepositoryFile* _tmp4_ = NULL;
	GitgTestRepositoryFile* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gint files_length1 = 0;
	gint _files_size_ = 0;
	GFile* wd = NULL;
	GitgRepository* _tmp6_ = NULL;
	GFile* _tmp7_ = NULL;
	GitgTestRepositoryFile* _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	GError * _inner_error_ = NULL;
#line 228 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	g_return_if_fail (self != NULL);
#line 230 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp0_ = self->d_repository;
#line 230 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	if (_tmp0_ == NULL) {
#line 232 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		return;
#line 1506 "support-repository.c"
	}
#line 235 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp1_ = filename;
#line 235 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	va_start (_tmp2_, filename);
#line 235 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp4_ = gitg_test_repository_filenames_from_varargs (self, _tmp1_, _tmp2_, &_tmp3_);
#line 235 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp5_ = _tmp4_;
#line 235 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp5__length1 = _tmp3_;
#line 235 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	va_end (_tmp2_);
#line 235 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	files = _tmp5_;
#line 235 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	files_length1 = _tmp5__length1;
#line 235 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_files_size_ = files_length1;
#line 236 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp6_ = self->d_repository;
#line 236 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp7_ = ggit_repository_get_workdir ((GgitRepository*) _tmp6_);
#line 236 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	wd = _tmp7_;
#line 238 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp8_ = files;
#line 238 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp8__length1 = files_length1;
#line 1536 "support-repository.c"
	{
		GitgTestRepositoryFile* f_collection = NULL;
		gint f_collection_length1 = 0;
		gint _f_collection_size_ = 0;
		gint f_it = 0;
#line 238 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		f_collection = _tmp8_;
#line 238 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		f_collection_length1 = _tmp8__length1;
#line 238 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		for (f_it = 0; f_it < _tmp8__length1; f_it = f_it + 1) {
#line 1548 "support-repository.c"
			GitgTestRepositoryFile _tmp9_ = {0};
			GitgTestRepositoryFile f = {0};
#line 238 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			gitg_test_repository_file_copy (&f_collection[f_it], &_tmp9_);
#line 238 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			f = _tmp9_;
#line 1555 "support-repository.c"
			{
				GFile* fs = NULL;
				GFile* _tmp10_ = NULL;
				GitgTestRepositoryFile _tmp11_ = {0};
				const gchar* _tmp12_ = NULL;
				GFile* _tmp13_ = NULL;
#line 240 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
				_tmp10_ = wd;
#line 240 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
				_tmp11_ = f;
#line 240 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
				_tmp12_ = _tmp11_.filename;
#line 240 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
				_tmp13_ = g_file_get_child (_tmp10_, _tmp12_);
#line 240 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
				fs = _tmp13_;
#line 1572 "support-repository.c"
				{
					GFile* _tmp14_ = NULL;
#line 244 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_tmp14_ = fs;
#line 244 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					g_file_delete (_tmp14_, NULL, &_inner_error_);
#line 244 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1581 "support-repository.c"
						goto __catch9_g_error;
					}
				}
				goto __finally9;
				__catch9_g_error:
				{
					GError* e = NULL;
					GError* _tmp15_ = NULL;
#line 242 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					e = _inner_error_;
#line 242 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_inner_error_ = NULL;
#line 248 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_tmp15_ = e;
#line 248 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					gitg_test_assert_assert_no_error (_tmp15_);
#line 242 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_g_error_free0 (e);
#line 1600 "support-repository.c"
				}
				__finally9:
#line 242 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 242 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_g_object_unref0 (fs);
#line 242 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					gitg_test_repository_file_destroy (&f);
#line 242 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_g_object_unref0 (wd);
#line 242 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					files = (_vala_GitgTestRepositoryFile_array_free (files, files_length1), NULL);
#line 242 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 242 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					g_clear_error (&_inner_error_);
#line 242 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					return;
#line 1619 "support-repository.c"
				}
#line 238 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
				_g_object_unref0 (fs);
#line 238 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
				gitg_test_repository_file_destroy (&f);
#line 1625 "support-repository.c"
			}
		}
	}
#line 228 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_g_object_unref0 (wd);
#line 228 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	files = (_vala_GitgTestRepositoryFile_array_free (files, files_length1), NULL);
#line 1633 "support-repository.c"
}


void gitg_test_repository_workdir_modify (GitgTestRepository* self, const gchar* filename, ...) {
	GitgRepository* _tmp0_ = NULL;
	GitgTestRepositoryFile* files = NULL;
	const gchar* _tmp1_ = NULL;
	va_list _tmp2_ = {0};
	gint _tmp3_ = 0;
	GitgTestRepositoryFile* _tmp4_ = NULL;
	GitgTestRepositoryFile* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gint files_length1 = 0;
	gint _files_size_ = 0;
	GitgTestRepositoryFile* _tmp6_ = NULL;
	gint _tmp6__length1 = 0;
#line 253 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	g_return_if_fail (self != NULL);
#line 255 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp0_ = self->d_repository;
#line 255 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	if (_tmp0_ == NULL) {
#line 257 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		return;
#line 1658 "support-repository.c"
	}
#line 260 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp1_ = filename;
#line 260 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	va_start (_tmp2_, filename);
#line 260 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp4_ = gitg_test_repository_files_from_varargs (self, _tmp1_, _tmp2_, &_tmp3_);
#line 260 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp5_ = _tmp4_;
#line 260 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp5__length1 = _tmp3_;
#line 260 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	va_end (_tmp2_);
#line 260 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	files = _tmp5_;
#line 260 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	files_length1 = _tmp5__length1;
#line 260 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_files_size_ = files_length1;
#line 261 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp6_ = files;
#line 261 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp6__length1 = files_length1;
#line 261 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	gitg_test_repository_write_files (self, _tmp6_, _tmp6__length1);
#line 253 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	files = (_vala_GitgTestRepositoryFile_array_free (files, files_length1), NULL);
#line 1686 "support-repository.c"
}


void gitg_test_repository_index_modify (GitgTestRepository* self, const gchar* filename, ...) {
	GitgRepository* _tmp0_ = NULL;
	GitgTestRepositoryFile* files = NULL;
	const gchar* _tmp1_ = NULL;
	va_list _tmp2_ = {0};
	gint _tmp3_ = 0;
	GitgTestRepositoryFile* _tmp4_ = NULL;
	GitgTestRepositoryFile* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gint files_length1 = 0;
	gint _files_size_ = 0;
	GgitOId* id = NULL;
	GgitIndex* index = NULL;
	GitgTestRepositoryFile* _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	GError * _inner_error_ = NULL;
#line 264 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	g_return_if_fail (self != NULL);
#line 266 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp0_ = self->d_repository;
#line 266 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	if (_tmp0_ == NULL) {
#line 268 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		return;
#line 1714 "support-repository.c"
	}
#line 271 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp1_ = filename;
#line 271 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	va_start (_tmp2_, filename);
#line 271 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp4_ = gitg_test_repository_files_from_varargs (self, _tmp1_, _tmp2_, &_tmp3_);
#line 271 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp5_ = _tmp4_;
#line 271 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp5__length1 = _tmp3_;
#line 271 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	va_end (_tmp2_);
#line 271 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	files = _tmp5_;
#line 271 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	files_length1 = _tmp5__length1;
#line 271 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_files_size_ = files_length1;
#line 1734 "support-repository.c"
	{
		GgitIndex* _tmp6_ = NULL;
		GitgRepository* _tmp7_ = NULL;
		GgitIndex* _tmp8_ = NULL;
		GgitIndex* _tmp9_ = NULL;
#line 279 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp7_ = self->d_repository;
#line 279 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp8_ = ggit_repository_get_index ((GgitRepository*) _tmp7_, &_inner_error_);
#line 279 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp6_ = _tmp8_;
#line 279 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1748 "support-repository.c"
			goto __catch10_g_error;
		}
#line 279 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp9_ = _tmp6_;
#line 279 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp6_ = NULL;
#line 279 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (index);
#line 279 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		index = _tmp9_;
#line 277 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (_tmp6_);
#line 1761 "support-repository.c"
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* e = NULL;
		GError* _tmp10_ = NULL;
#line 277 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		e = _inner_error_;
#line 277 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_inner_error_ = NULL;
#line 283 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp10_ = e;
#line 283 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		gitg_test_assert_assert_no_error (_tmp10_);
#line 284 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_error_free0 (e);
#line 284 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (index);
#line 284 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		__vala_GgitOId_free0 (id);
#line 284 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		files = (_vala_GitgTestRepositoryFile_array_free (files, files_length1), NULL);
#line 284 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		return;
#line 1786 "support-repository.c"
	}
	__finally10:
#line 277 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 277 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (index);
#line 277 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		__vala_GgitOId_free0 (id);
#line 277 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		files = (_vala_GitgTestRepositoryFile_array_free (files, files_length1), NULL);
#line 277 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 277 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		g_clear_error (&_inner_error_);
#line 277 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		return;
#line 1803 "support-repository.c"
	}
#line 288 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp11_ = files;
#line 288 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp11__length1 = files_length1;
#line 1809 "support-repository.c"
	{
		GitgTestRepositoryFile* f_collection = NULL;
		gint f_collection_length1 = 0;
		gint _f_collection_size_ = 0;
		gint f_it = 0;
#line 288 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		f_collection = _tmp11_;
#line 288 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		f_collection_length1 = _tmp11__length1;
#line 288 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		for (f_it = 0; f_it < _tmp11__length1; f_it = f_it + 1) {
#line 1821 "support-repository.c"
			GitgTestRepositoryFile _tmp12_ = {0};
			GitgTestRepositoryFile f = {0};
#line 288 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			gitg_test_repository_file_copy (&f_collection[f_it], &_tmp12_);
#line 288 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			f = _tmp12_;
#line 1828 "support-repository.c"
			{
				{
					GgitOId* _tmp13_ = NULL;
					GitgRepository* _tmp14_ = NULL;
					GitgTestRepositoryFile _tmp15_ = {0};
					const gchar* _tmp16_ = NULL;
					guint8* _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
					guint8* _tmp18_ = NULL;
					gint _tmp18__length1 = 0;
					GgitOId* _tmp19_ = NULL;
					GgitOId* _tmp20_ = NULL;
#line 292 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_tmp14_ = self->d_repository;
#line 292 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_tmp15_ = f;
#line 292 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_tmp16_ = _tmp15_.contents;
#line 292 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_tmp17_ = string_get_data (_tmp16_, &_tmp17__length1);
#line 292 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_tmp18_ = _tmp17_;
#line 292 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_tmp18__length1 = _tmp17__length1;
#line 292 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_tmp19_ = ggit_repository_create_blob_from_buffer ((GgitRepository*) _tmp14_, _tmp18_, (gsize) _tmp18__length1, &_inner_error_);
#line 292 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_tmp13_ = _tmp19_;
#line 292 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1859 "support-repository.c"
						goto __catch11_g_error;
					}
#line 292 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_tmp20_ = _tmp13_;
#line 292 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_tmp13_ = NULL;
#line 292 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					__vala_GgitOId_free0 (id);
#line 292 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					id = _tmp20_;
#line 290 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					__vala_GgitOId_free0 (_tmp13_);
#line 1872 "support-repository.c"
				}
				goto __finally11;
				__catch11_g_error:
				{
					GError* e = NULL;
					GError* _tmp21_ = NULL;
#line 290 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					e = _inner_error_;
#line 290 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_inner_error_ = NULL;
#line 296 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_tmp21_ = e;
#line 296 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					gitg_test_assert_assert_no_error (_tmp21_);
#line 297 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_g_error_free0 (e);
#line 297 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					gitg_test_repository_file_destroy (&f);
#line 297 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					continue;
#line 1893 "support-repository.c"
				}
				__finally11:
#line 290 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 290 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					gitg_test_repository_file_destroy (&f);
#line 290 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_g_object_unref0 (index);
#line 290 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					__vala_GgitOId_free0 (id);
#line 290 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					files = (_vala_GitgTestRepositoryFile_array_free (files, files_length1), NULL);
#line 290 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 290 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					g_clear_error (&_inner_error_);
#line 290 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					return;
#line 1912 "support-repository.c"
				}
				{
					GgitIndexEntry* entry = NULL;
					GitgRepository* _tmp22_ = NULL;
					GitgTestRepositoryFile _tmp23_ = {0};
					const gchar* _tmp24_ = NULL;
					GgitOId* _tmp25_ = NULL;
					GgitIndexEntry* _tmp26_ = NULL;
					GgitIndex* _tmp27_ = NULL;
					GgitIndexEntry* _tmp28_ = NULL;
#line 302 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_tmp22_ = self->d_repository;
#line 302 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_tmp23_ = f;
#line 302 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_tmp24_ = _tmp23_.filename;
#line 302 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_tmp25_ = id;
#line 302 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_tmp26_ = ggit_repository_create_index_entry_for_path ((GgitRepository*) _tmp22_, _tmp24_, _tmp25_, &_inner_error_);
#line 302 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					entry = _tmp26_;
#line 302 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1937 "support-repository.c"
						goto __catch12_g_error;
					}
#line 303 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_tmp27_ = index;
#line 303 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_tmp28_ = entry;
#line 303 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					ggit_index_add (_tmp27_, _tmp28_, &_inner_error_);
#line 303 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 303 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
						_ggit_index_entry_unref0 (entry);
#line 1950 "support-repository.c"
						goto __catch12_g_error;
					}
#line 300 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_ggit_index_entry_unref0 (entry);
#line 1955 "support-repository.c"
				}
				goto __finally12;
				__catch12_g_error:
				{
					GError* e = NULL;
					GError* _tmp29_ = NULL;
#line 300 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					e = _inner_error_;
#line 300 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_inner_error_ = NULL;
#line 307 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_tmp29_ = e;
#line 307 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					gitg_test_assert_assert_no_error (_tmp29_);
#line 300 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_g_error_free0 (e);
#line 1972 "support-repository.c"
				}
				__finally12:
#line 300 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 300 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					gitg_test_repository_file_destroy (&f);
#line 300 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_g_object_unref0 (index);
#line 300 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					__vala_GgitOId_free0 (id);
#line 300 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					files = (_vala_GitgTestRepositoryFile_array_free (files, files_length1), NULL);
#line 300 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 300 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					g_clear_error (&_inner_error_);
#line 300 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					return;
#line 1991 "support-repository.c"
				}
#line 288 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
				gitg_test_repository_file_destroy (&f);
#line 1995 "support-repository.c"
			}
		}
	}
	{
		GgitIndex* _tmp30_ = NULL;
#line 313 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp30_ = index;
#line 313 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		ggit_index_write (_tmp30_, &_inner_error_);
#line 313 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2007 "support-repository.c"
			goto __catch13_g_error;
		}
	}
	goto __finally13;
	__catch13_g_error:
	{
		GError* e = NULL;
		GError* _tmp31_ = NULL;
#line 311 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		e = _inner_error_;
#line 311 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_inner_error_ = NULL;
#line 317 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp31_ = e;
#line 317 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		gitg_test_assert_assert_no_error (_tmp31_);
#line 311 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_error_free0 (e);
#line 2026 "support-repository.c"
	}
	__finally13:
#line 311 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 311 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (index);
#line 311 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		__vala_GgitOId_free0 (id);
#line 311 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		files = (_vala_GitgTestRepositoryFile_array_free (files, files_length1), NULL);
#line 311 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 311 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		g_clear_error (&_inner_error_);
#line 311 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		return;
#line 2043 "support-repository.c"
	}
#line 264 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_g_object_unref0 (index);
#line 264 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	__vala_GgitOId_free0 (id);
#line 264 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	files = (_vala_GitgTestRepositoryFile_array_free (files, files_length1), NULL);
#line 2051 "support-repository.c"
}


GitgBranch* gitg_test_repository_create_branch (GitgTestRepository* self, const gchar* name) {
	GitgBranch* result = NULL;
	GError * _inner_error_ = NULL;
#line 321 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 321 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 2062 "support-repository.c"
	{
		GitgRef* _tmp0_ = NULL;
		GitgRepository* _tmp1_ = NULL;
		GitgRef* _tmp2_ = NULL;
		GitgCommit* commit = NULL;
		GitgRepository* _tmp3_ = NULL;
		GitgRef* _tmp4_ = NULL;
		GitgRef* _tmp5_ = NULL;
		GgitOId* _tmp6_ = NULL;
		GgitOId* _tmp7_ = NULL;
		gpointer _tmp8_ = NULL;
		GitgCommit* _tmp9_ = NULL;
		GitgBranch* _tmp10_ = NULL;
		GitgRepository* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		GitgCommit* _tmp13_ = NULL;
		GitgBranch* _tmp14_ = NULL;
		GitgBranch* _tmp15_ = NULL;
#line 325 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp1_ = self->d_repository;
#line 325 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp2_ = gitg_repository_get_head (_tmp1_, &_inner_error_);
#line 325 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp0_ = _tmp2_;
#line 325 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2089 "support-repository.c"
			goto __catch14_g_error;
		}
#line 325 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp3_ = self->d_repository;
#line 325 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp4_ = _tmp0_;
#line 325 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp0_ = NULL;
#line 325 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp5_ = _tmp4_;
#line 325 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp6_ = ggit_ref_get_target ((GgitRef*) _tmp5_);
#line 325 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp7_ = _tmp6_;
#line 325 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp8_ = gitg_repository_lookup (_tmp3_, GITG_TYPE_COMMIT, (GBoxedCopyFunc) g_object_ref, g_object_unref, _tmp7_, &_inner_error_);
#line 325 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp9_ = (GitgCommit*) _tmp8_;
#line 325 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		__vala_GgitOId_free0 (_tmp7_);
#line 325 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (_tmp5_);
#line 325 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		commit = _tmp9_;
#line 325 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 325 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			_g_object_unref0 (_tmp0_);
#line 2118 "support-repository.c"
			goto __catch14_g_error;
		}
#line 326 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp11_ = self->d_repository;
#line 326 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp12_ = name;
#line 326 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp13_ = commit;
#line 326 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp14_ = gitg_repository_create_branch (_tmp11_, _tmp12_, (GgitObject*) _tmp13_, GGIT_CREATE_NONE, &_inner_error_);
#line 326 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp10_ = _tmp14_;
#line 326 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 326 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			_g_object_unref0 (commit);
#line 326 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			_g_object_unref0 (_tmp0_);
#line 2137 "support-repository.c"
			goto __catch14_g_error;
		}
#line 326 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp15_ = _tmp10_;
#line 326 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp10_ = NULL;
#line 326 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		result = _tmp15_;
#line 326 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (_tmp10_);
#line 326 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (commit);
#line 326 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (_tmp0_);
#line 326 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		return result;
#line 2154 "support-repository.c"
	}
	goto __finally14;
	__catch14_g_error:
	{
		GError* e = NULL;
		GError* _tmp16_ = NULL;
#line 323 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		e = _inner_error_;
#line 323 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_inner_error_ = NULL;
#line 330 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp16_ = e;
#line 330 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		gitg_test_assert_assert_no_error (_tmp16_);
#line 331 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		result = NULL;
#line 331 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_error_free0 (e);
#line 331 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		return result;
#line 2175 "support-repository.c"
	}
	__finally14:
#line 323 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 323 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	g_clear_error (&_inner_error_);
#line 323 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	return NULL;
#line 2184 "support-repository.c"
}


void gitg_test_repository_checkout_branch (GitgTestRepository* self, const gchar* name) {
	GError * _inner_error_ = NULL;
#line 335 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	g_return_if_fail (self != NULL);
#line 335 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	g_return_if_fail (name != NULL);
#line 2194 "support-repository.c"
	{
		GitgRef* _tmp0_ = NULL;
		GitgRepository* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		GitgRef* _tmp3_ = NULL;
		GitgBranch* branch = NULL;
		GitgRef* _tmp4_ = NULL;
		GitgBranch* _tmp5_ = NULL;
		GgitRef* _tmp6_ = NULL;
		GitgBranch* _tmp7_ = NULL;
		GgitRef* _tmp8_ = NULL;
		GgitObject* _tmp9_ = NULL;
		GgitRef* _tmp10_ = NULL;
		GgitRef* _tmp11_ = NULL;
		GgitObject* _tmp12_ = NULL;
		GgitObject* _tmp13_ = NULL;
		GgitCommit* commit = NULL;
		GgitObject* _tmp14_ = NULL;
		GgitCommit* _tmp15_ = NULL;
		GgitTree* tree = NULL;
		GgitCommit* _tmp16_ = NULL;
		GgitTree* _tmp17_ = NULL;
		GgitCheckoutOptions* opts = NULL;
		GgitCheckoutOptions* _tmp18_ = NULL;
		GgitCheckoutOptions* _tmp19_ = NULL;
		GitgRepository* _tmp20_ = NULL;
		GgitTree* _tmp21_ = NULL;
		GgitCheckoutOptions* _tmp22_ = NULL;
		GitgRepository* _tmp23_ = NULL;
		GitgBranch* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
#line 339 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp1_ = self->d_repository;
#line 339 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp2_ = name;
#line 339 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp3_ = gitg_repository_lookup_reference_dwim (_tmp1_, _tmp2_, &_inner_error_);
#line 339 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp0_ = _tmp3_;
#line 339 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2236 "support-repository.c"
			goto __catch15_g_error;
		}
#line 339 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp4_ = _tmp0_;
#line 339 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp0_ = NULL;
#line 339 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp5_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, GITG_TYPE_BRANCH) ? ((GitgBranch*) _tmp4_) : NULL;
#line 339 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		if (_tmp5_ == NULL) {
#line 339 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			_g_object_unref0 (_tmp4_);
#line 2249 "support-repository.c"
		}
#line 339 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		branch = _tmp5_;
#line 340 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp7_ = branch;
#line 340 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp8_ = ggit_ref_resolve ((GgitRef*) _tmp7_, &_inner_error_);
#line 340 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp6_ = _tmp8_;
#line 340 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 340 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			_g_object_unref0 (branch);
#line 340 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			_g_object_unref0 (_tmp0_);
#line 2265 "support-repository.c"
			goto __catch15_g_error;
		}
#line 340 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp10_ = _tmp6_;
#line 340 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp6_ = NULL;
#line 340 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp11_ = _tmp10_;
#line 340 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp12_ = ggit_ref_lookup (_tmp11_, &_inner_error_);
#line 340 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp13_ = _tmp12_;
#line 340 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (_tmp11_);
#line 340 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp9_ = _tmp13_;
#line 340 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 340 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			_g_object_unref0 (_tmp6_);
#line 340 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			_g_object_unref0 (branch);
#line 340 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			_g_object_unref0 (_tmp0_);
#line 2290 "support-repository.c"
			goto __catch15_g_error;
		}
#line 340 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp14_ = _tmp9_;
#line 340 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp9_ = NULL;
#line 340 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp15_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, ggit_commit_get_type ()) ? ((GgitCommit*) _tmp14_) : NULL;
#line 340 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		if (_tmp15_ == NULL) {
#line 340 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			_g_object_unref0 (_tmp14_);
#line 2303 "support-repository.c"
		}
#line 340 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		commit = _tmp15_;
#line 341 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp16_ = commit;
#line 341 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp17_ = ggit_commit_get_tree (_tmp16_);
#line 341 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		tree = _tmp17_;
#line 343 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp18_ = ggit_checkout_options_new ();
#line 343 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		opts = _tmp18_;
#line 344 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp19_ = opts;
#line 344 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		ggit_checkout_options_set_strategy (_tmp19_, GGIT_CHECKOUT_SAFE);
#line 346 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp20_ = self->d_repository;
#line 346 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp21_ = tree;
#line 346 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp22_ = opts;
#line 346 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		ggit_repository_checkout_tree ((GgitRepository*) _tmp20_, (GgitObject*) _tmp21_, _tmp22_, &_inner_error_);
#line 346 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 346 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			_g_object_unref0 (opts);
#line 346 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			_g_object_unref0 (tree);
#line 346 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			_g_object_unref0 (commit);
#line 346 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			_g_object_unref0 (_tmp9_);
#line 346 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			_g_object_unref0 (_tmp6_);
#line 346 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			_g_object_unref0 (branch);
#line 346 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			_g_object_unref0 (_tmp0_);
#line 2345 "support-repository.c"
			goto __catch15_g_error;
		}
#line 347 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp23_ = self->d_repository;
#line 347 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp24_ = branch;
#line 347 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp25_ = ggit_ref_get_name ((GgitRef*) _tmp24_);
#line 347 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		ggit_repository_set_head ((GgitRepository*) _tmp23_, _tmp25_, &_inner_error_);
#line 347 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 347 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			_g_object_unref0 (opts);
#line 347 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			_g_object_unref0 (tree);
#line 347 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			_g_object_unref0 (commit);
#line 347 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			_g_object_unref0 (_tmp9_);
#line 347 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			_g_object_unref0 (_tmp6_);
#line 347 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			_g_object_unref0 (branch);
#line 347 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			_g_object_unref0 (_tmp0_);
#line 2372 "support-repository.c"
			goto __catch15_g_error;
		}
#line 337 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (opts);
#line 337 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (tree);
#line 337 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (commit);
#line 337 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (_tmp9_);
#line 337 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (_tmp6_);
#line 337 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (branch);
#line 337 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (_tmp0_);
#line 2389 "support-repository.c"
	}
	goto __finally15;
	__catch15_g_error:
	{
		GError* e = NULL;
		GError* _tmp26_ = NULL;
#line 337 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		e = _inner_error_;
#line 337 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_inner_error_ = NULL;
#line 351 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp26_ = e;
#line 351 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		gitg_test_assert_assert_no_error (_tmp26_);
#line 352 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_error_free0 (e);
#line 352 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		return;
#line 2408 "support-repository.c"
	}
	__finally15:
#line 337 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 337 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 337 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		g_clear_error (&_inner_error_);
#line 337 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		return;
#line 2419 "support-repository.c"
	}
}


static void gitg_test_repository_real_set_up (GitgTestTest* base) {
	GitgTestRepository * self;
	gchar* wd = NULL;
	GFile* f = NULL;
	const gchar* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
#line 356 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	self = (GitgTestRepository*) base;
#line 359 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	self->priv->d_current_time = (guint) 0;
#line 2435 "support-repository.c"
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
#line 363 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp1_ = g_dir_make_tmp ("gitg-test-XXXXXX", &_inner_error_);
#line 363 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp0_ = _tmp1_;
#line 363 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2446 "support-repository.c"
			goto __catch16_g_error;
		}
#line 363 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp2_ = _tmp0_;
#line 363 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp0_ = NULL;
#line 363 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_free0 (wd);
#line 363 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		wd = _tmp2_;
#line 361 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_free0 (_tmp0_);
#line 2459 "support-repository.c"
	}
	goto __finally16;
	__catch16_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
#line 361 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		e = _inner_error_;
#line 361 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_inner_error_ = NULL;
#line 367 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp3_ = e;
#line 367 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		gitg_test_assert_assert_no_error (_tmp3_);
#line 368 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_error_free0 (e);
#line 368 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_free0 (wd);
#line 368 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		return;
#line 2480 "support-repository.c"
	}
	__finally16:
#line 361 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 361 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_free0 (wd);
#line 361 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 361 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		g_clear_error (&_inner_error_);
#line 361 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		return;
#line 2493 "support-repository.c"
	}
#line 371 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp4_ = wd;
#line 371 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp5_ = g_file_new_for_path (_tmp4_);
#line 371 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	f = _tmp5_;
#line 2501 "support-repository.c"
	{
		GgitRepository* _tmp6_ = NULL;
		GFile* _tmp7_ = NULL;
		GgitRepository* _tmp8_ = NULL;
		GgitRepository* _tmp9_ = NULL;
#line 375 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp7_ = f;
#line 375 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp8_ = ggit_repository_init_repository (_tmp7_, FALSE, &_inner_error_);
#line 375 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp6_ = _tmp8_;
#line 375 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2515 "support-repository.c"
			goto __catch17_g_error;
		}
#line 375 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp9_ = _tmp6_;
#line 375 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp6_ = NULL;
#line 375 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (self->d_repository);
#line 375 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		self->d_repository = G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GITG_TYPE_REPOSITORY, GitgRepository);
#line 373 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (_tmp6_);
#line 2528 "support-repository.c"
	}
	goto __finally17;
	__catch17_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp10_ = NULL;
		GError* _tmp11_ = NULL;
#line 373 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		e = _inner_error_;
#line 373 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_inner_error_ = NULL;
#line 379 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp10_ = wd;
#line 379 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		g_rmdir (_tmp10_);
#line 380 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp11_ = e;
#line 380 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		gitg_test_assert_assert_no_error (_tmp11_);
#line 373 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_error_free0 (e);
#line 2550 "support-repository.c"
	}
	__finally17:
#line 373 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 373 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (f);
#line 373 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_free0 (wd);
#line 373 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 373 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		g_clear_error (&_inner_error_);
#line 373 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		return;
#line 2565 "support-repository.c"
	}
#line 356 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_g_object_unref0 (f);
#line 356 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_g_free0 (wd);
#line 2571 "support-repository.c"
}


static void gitg_test_repository_remove_recursively (GitgTestRepository* self, GFile* f) {
	GError * _inner_error_ = NULL;
#line 384 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	g_return_if_fail (self != NULL);
#line 384 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	g_return_if_fail (f != NULL);
#line 2581 "support-repository.c"
	{
		GFileInfo* info = NULL;
		GFile* _tmp0_ = NULL;
		GFileInfo* _tmp1_ = NULL;
		GFileInfo* _tmp2_ = NULL;
		GFileType _tmp3_ = 0;
		GFile* _tmp16_ = NULL;
#line 388 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp0_ = f;
#line 388 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp1_ = g_file_query_info (_tmp0_, "standard::*", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 388 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		info = _tmp1_;
#line 388 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2597 "support-repository.c"
			goto __catch18_g_error;
		}
#line 390 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp2_ = info;
#line 390 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp3_ = g_file_info_get_file_type (_tmp2_);
#line 390 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		if (_tmp3_ == G_FILE_TYPE_DIRECTORY) {
#line 2606 "support-repository.c"
			GFileEnumerator* e = NULL;
			GFile* _tmp4_ = NULL;
			GFileEnumerator* _tmp5_ = NULL;
#line 392 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			_tmp4_ = f;
#line 392 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			_tmp5_ = g_file_enumerate_children (_tmp4_, "standard::*", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 392 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			e = _tmp5_;
#line 392 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 392 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
				_g_object_unref0 (info);
#line 2620 "support-repository.c"
				goto __catch18_g_error;
			}
#line 394 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			while (TRUE) {
#line 2625 "support-repository.c"
				GFileInfo* _tmp6_ = NULL;
				GFileEnumerator* _tmp7_ = NULL;
				GFileInfo* _tmp8_ = NULL;
				GFileInfo* _tmp9_ = NULL;
				GFileInfo* _tmp10_ = NULL;
				GFile* c = NULL;
				GFile* _tmp11_ = NULL;
				GFileInfo* _tmp12_ = NULL;
				const gchar* _tmp13_ = NULL;
				GFile* _tmp14_ = NULL;
				GFile* _tmp15_ = NULL;
#line 394 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
				_tmp7_ = e;
#line 394 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
				_tmp8_ = g_file_enumerator_next_file (_tmp7_, NULL, &_inner_error_);
#line 394 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
				_tmp6_ = _tmp8_;
#line 394 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 394 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_g_object_unref0 (e);
#line 394 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_g_object_unref0 (info);
#line 2649 "support-repository.c"
					goto __catch18_g_error;
				}
#line 394 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
				_tmp9_ = _tmp6_;
#line 394 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
				_tmp6_ = NULL;
#line 394 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
				_g_object_unref0 (info);
#line 394 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
				info = _tmp9_;
#line 394 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
				_tmp10_ = info;
#line 394 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
				if (!(_tmp10_ != NULL)) {
#line 394 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					_g_object_unref0 (_tmp6_);
#line 394 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
					break;
#line 2668 "support-repository.c"
				}
#line 396 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
				_tmp11_ = f;
#line 396 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
				_tmp12_ = info;
#line 396 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
				_tmp13_ = g_file_info_get_name (_tmp12_);
#line 396 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
				_tmp14_ = g_file_get_child (_tmp11_, _tmp13_);
#line 396 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
				c = _tmp14_;
#line 397 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
				_tmp15_ = c;
#line 397 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
				gitg_test_repository_remove_recursively (self, _tmp15_);
#line 394 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
				_g_object_unref0 (c);
#line 394 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
				_g_object_unref0 (_tmp6_);
#line 2688 "support-repository.c"
			}
#line 390 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			_g_object_unref0 (e);
#line 2692 "support-repository.c"
		}
#line 401 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp16_ = f;
#line 401 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		g_file_delete (_tmp16_, NULL, &_inner_error_);
#line 401 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 401 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			_g_object_unref0 (info);
#line 2702 "support-repository.c"
			goto __catch18_g_error;
		}
#line 386 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (info);
#line 2707 "support-repository.c"
	}
	goto __finally18;
	__catch18_g_error:
	{
		GError* e = NULL;
		FILE* _tmp17_ = NULL;
		GFile* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		GError* _tmp21_ = NULL;
		const gchar* _tmp22_ = NULL;
#line 386 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		e = _inner_error_;
#line 386 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_inner_error_ = NULL;
#line 405 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp17_ = stderr;
#line 405 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp18_ = f;
#line 405 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp19_ = g_file_get_path (_tmp18_);
#line 405 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp20_ = _tmp19_;
#line 405 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp21_ = e;
#line 405 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp22_ = _tmp21_->message;
#line 405 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		fprintf (_tmp17_, "Failed to remove %s: %s\n", _tmp20_, _tmp22_);
#line 405 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_free0 (_tmp20_);
#line 386 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_error_free0 (e);
#line 2741 "support-repository.c"
	}
	__finally18:
#line 386 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 386 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 386 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		g_clear_error (&_inner_error_);
#line 386 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		return;
#line 2752 "support-repository.c"
	}
}


GitgBranch* gitg_test_repository_lookup_branch (GitgTestRepository* self, const gchar* name) {
	GitgBranch* result = NULL;
	GError * _inner_error_ = NULL;
#line 409 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 409 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 2764 "support-repository.c"
	{
		GitgRef* _tmp0_ = NULL;
		GitgRepository* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		GitgRef* _tmp3_ = NULL;
		GitgBranch* ret = NULL;
		GitgRef* _tmp4_ = NULL;
		GitgBranch* _tmp5_ = NULL;
		GitgBranch* _tmp6_ = NULL;
#line 413 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp1_ = self->d_repository;
#line 413 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp2_ = name;
#line 413 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp3_ = gitg_repository_lookup_reference_dwim (_tmp1_, _tmp2_, &_inner_error_);
#line 413 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp0_ = _tmp3_;
#line 413 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2784 "support-repository.c"
			goto __catch19_g_error;
		}
#line 413 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp4_ = _tmp0_;
#line 413 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp0_ = NULL;
#line 413 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp5_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, GITG_TYPE_BRANCH) ? ((GitgBranch*) _tmp4_) : NULL;
#line 413 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		if (_tmp5_ == NULL) {
#line 413 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			_g_object_unref0 (_tmp4_);
#line 2797 "support-repository.c"
		}
#line 413 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		ret = _tmp5_;
#line 414 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp6_ = ret;
#line 414 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_vala_assert (_tmp6_, "ret");
#line 416 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		result = ret;
#line 416 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (_tmp0_);
#line 416 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		return result;
#line 2811 "support-repository.c"
	}
	goto __finally19;
	__catch19_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_ = NULL;
#line 411 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		e = _inner_error_;
#line 411 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_inner_error_ = NULL;
#line 420 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp7_ = e;
#line 420 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		gitg_test_assert_assert_no_error (_tmp7_);
#line 411 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_error_free0 (e);
#line 2828 "support-repository.c"
	}
	__finally19:
#line 411 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 411 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 411 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		g_clear_error (&_inner_error_);
#line 411 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		return NULL;
#line 2839 "support-repository.c"
	}
#line 423 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	result = NULL;
#line 423 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	return result;
#line 2845 "support-repository.c"
}


GitgCommit* gitg_test_repository_lookup_commit (GitgTestRepository* self, const gchar* name) {
	GitgCommit* result = NULL;
	GError * _inner_error_ = NULL;
#line 426 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 426 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 2856 "support-repository.c"
	{
		GgitObject* _tmp0_ = NULL;
		const gchar* _tmp1_ = NULL;
		GitgBranch* _tmp2_ = NULL;
		GitgBranch* _tmp3_ = NULL;
		GgitObject* _tmp4_ = NULL;
		GgitObject* _tmp5_ = NULL;
		GitgCommit* ret = NULL;
		GgitObject* _tmp6_ = NULL;
		GitgCommit* _tmp7_ = NULL;
		GitgCommit* _tmp8_ = NULL;
#line 430 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp1_ = name;
#line 430 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp2_ = gitg_test_repository_lookup_branch (self, _tmp1_);
#line 430 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp3_ = _tmp2_;
#line 430 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp4_ = ggit_ref_lookup ((GgitRef*) _tmp3_, &_inner_error_);
#line 430 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp5_ = _tmp4_;
#line 430 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (_tmp3_);
#line 430 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp0_ = _tmp5_;
#line 430 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2884 "support-repository.c"
			goto __catch20_g_error;
		}
#line 430 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp6_ = _tmp0_;
#line 430 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp0_ = NULL;
#line 430 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp7_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, GITG_TYPE_COMMIT) ? ((GitgCommit*) _tmp6_) : NULL;
#line 430 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		if (_tmp7_ == NULL) {
#line 430 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
			_g_object_unref0 (_tmp6_);
#line 2897 "support-repository.c"
		}
#line 430 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		ret = _tmp7_;
#line 431 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp8_ = ret;
#line 431 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_vala_assert (_tmp8_, "ret");
#line 433 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		result = ret;
#line 433 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_object_unref0 (_tmp0_);
#line 433 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		return result;
#line 2911 "support-repository.c"
	}
	goto __finally20;
	__catch20_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_ = NULL;
#line 428 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		e = _inner_error_;
#line 428 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_inner_error_ = NULL;
#line 437 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_tmp9_ = e;
#line 437 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		gitg_test_assert_assert_no_error (_tmp9_);
#line 428 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		_g_error_free0 (e);
#line 2928 "support-repository.c"
	}
	__finally20:
#line 428 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 428 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 428 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		g_clear_error (&_inner_error_);
#line 428 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		return NULL;
#line 2939 "support-repository.c"
	}
#line 440 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	result = NULL;
#line 440 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	return result;
#line 2945 "support-repository.c"
}


static void gitg_test_repository_real_tear_down (GitgTestTest* base) {
	GitgTestRepository * self;
	GitgRepository* _tmp0_ = NULL;
	GitgRepository* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
#line 443 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	self = (GitgTestRepository*) base;
#line 445 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp0_ = self->d_repository;
#line 445 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	if (_tmp0_ == NULL) {
#line 447 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
		return;
#line 2963 "support-repository.c"
	}
#line 450 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp1_ = self->d_repository;
#line 450 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp2_ = ggit_repository_get_workdir ((GgitRepository*) _tmp1_);
#line 450 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp3_ = _tmp2_;
#line 450 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	gitg_test_repository_remove_recursively (self, _tmp3_);
#line 450 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_g_object_unref0 (_tmp3_);
#line 451 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_g_object_unref0 (self->d_repository);
#line 451 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	self->d_repository = NULL;
#line 2979 "support-repository.c"
}


GitgTestRepository* gitg_test_repository_construct (GType object_type) {
	GitgTestRepository * self = NULL;
#line 22 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	self = (GitgTestRepository*) gitg_test_test_construct (object_type);
#line 22 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	return self;
#line 2989 "support-repository.c"
}


GitgTestRepository* gitg_test_repository_new (void) {
#line 22 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	return gitg_test_repository_construct (GITG_TEST_TYPE_REPOSITORY);
#line 2996 "support-repository.c"
}


static void gitg_test_repository_file_copy (const GitgTestRepositoryFile* self, GitgTestRepositoryFile* dest) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 27 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp0_ = (*self).filename;
#line 27 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 27 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_g_free0 ((*dest).filename);
#line 27 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	(*dest).filename = _tmp1_;
#line 27 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp2_ = (*self).contents;
#line 27 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 27 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_g_free0 ((*dest).contents);
#line 27 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	(*dest).contents = _tmp3_;
#line 3021 "support-repository.c"
}


static void gitg_test_repository_file_destroy (GitgTestRepositoryFile* self) {
#line 29 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_g_free0 ((*self).filename);
#line 30 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_g_free0 ((*self).contents);
#line 3030 "support-repository.c"
}


static GitgTestRepositoryFile* gitg_test_repository_file_dup (const GitgTestRepositoryFile* self) {
	GitgTestRepositoryFile* dup;
#line 27 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	dup = g_new0 (GitgTestRepositoryFile, 1);
#line 27 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	gitg_test_repository_file_copy (self, dup);
#line 27 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	return dup;
#line 3042 "support-repository.c"
}


static void gitg_test_repository_file_free (GitgTestRepositoryFile* self) {
#line 27 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	gitg_test_repository_file_destroy (self);
#line 27 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	g_free (self);
#line 3051 "support-repository.c"
}


static GType gitg_test_repository_file_get_type (void) {
	static volatile gsize gitg_test_repository_file_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_test_repository_file_type_id__volatile)) {
		GType gitg_test_repository_file_type_id;
		gitg_test_repository_file_type_id = g_boxed_type_register_static ("GitgTestRepositoryFile", (GBoxedCopyFunc) gitg_test_repository_file_dup, (GBoxedFreeFunc) gitg_test_repository_file_free);
		g_once_init_leave (&gitg_test_repository_file_type_id__volatile, gitg_test_repository_file_type_id);
	}
	return gitg_test_repository_file_type_id__volatile;
}


static void gitg_test_repository_class_init (GitgTestRepositoryClass * klass) {
#line 22 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	gitg_test_repository_parent_class = g_type_class_peek_parent (klass);
#line 22 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	g_type_class_add_private (klass, sizeof (GitgTestRepositoryPrivate));
#line 22 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	((GitgTestTestClass *) klass)->set_up = gitg_test_repository_real_set_up;
#line 22 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	((GitgTestTestClass *) klass)->tear_down = gitg_test_repository_real_tear_down;
#line 22 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	G_OBJECT_CLASS (klass)->finalize = gitg_test_repository_finalize;
#line 3077 "support-repository.c"
}


static void gitg_test_repository_instance_init (GitgTestRepository * self) {
#line 22 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	self->priv = GITG_TEST_REPOSITORY_GET_PRIVATE (self);
#line 3084 "support-repository.c"
}


static void gitg_test_repository_finalize (GObject * obj) {
	GitgTestRepository * self;
#line 22 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TEST_TYPE_REPOSITORY, GitgTestRepository);
#line 24 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	_g_object_unref0 (self->d_repository);
#line 22 "/home/jesse/dev/gitg/tests/gitg/support-repository.vala"
	G_OBJECT_CLASS (gitg_test_repository_parent_class)->finalize (obj);
#line 3096 "support-repository.c"
}


GType gitg_test_repository_get_type (void) {
	static volatile gsize gitg_test_repository_type_id__volatile = 0;
	if (g_once_init_enter (&gitg_test_repository_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GitgTestRepositoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_test_repository_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgTestRepository), 0, (GInstanceInitFunc) gitg_test_repository_instance_init, NULL };
		GType gitg_test_repository_type_id;
		gitg_test_repository_type_id = g_type_register_static (GITG_TEST_TYPE_TEST, "GitgTestRepository", &g_define_type_info, 0);
		g_once_init_leave (&gitg_test_repository_type_id__volatile, gitg_test_repository_type_id);
	}
	return gitg_test_repository_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



